# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetModelsResult',
    'AwaitableGetModelsResult',
    'get_models',
    'get_models_output',
]

@pulumi.output_type
class GetModelsResult:
    """
    A collection of values returned by getModels.
    """
    def __init__(__self__, category=None, compartment_id=None, created_by=None, display_name=None, filters=None, id=None, model_version_set_id=None, model_version_set_name=None, models=None, project_id=None, state=None, version_label=None):
        if category and not isinstance(category, str):
            raise TypeError("Expected argument 'category' to be a str")
        pulumi.set(__self__, "category", category)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if model_version_set_id and not isinstance(model_version_set_id, str):
            raise TypeError("Expected argument 'model_version_set_id' to be a str")
        pulumi.set(__self__, "model_version_set_id", model_version_set_id)
        if model_version_set_name and not isinstance(model_version_set_name, str):
            raise TypeError("Expected argument 'model_version_set_name' to be a str")
        pulumi.set(__self__, "model_version_set_name", model_version_set_name)
        if models and not isinstance(models, list):
            raise TypeError("Expected argument 'models' to be a list")
        pulumi.set(__self__, "models", models)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if version_label and not isinstance(version_label, str):
            raise TypeError("Expected argument 'version_label' to be a str")
        pulumi.set(__self__, "version_label", version_label)

    @property
    @pulumi.getter
    def category(self) -> Optional[builtins.str]:
        """
        Category of model metadata which should be null for defined metadata.For custom metadata is should be one of the following values "Performance,Training Profile,Training and Validation Datasets,Training Environment,Reports,Readme,other".
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the model.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetModelsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="modelVersionSetId")
    def model_version_set_id(self) -> Optional[builtins.str]:
        """
        The OCID of the model version set that the model is associated to.
        """
        return pulumi.get(self, "model_version_set_id")

    @property
    @pulumi.getter(name="modelVersionSetName")
    def model_version_set_name(self) -> Optional[builtins.str]:
        """
        The name of the model version set that the model is associated to.
        """
        return pulumi.get(self, "model_version_set_name")

    @property
    @pulumi.getter
    def models(self) -> Sequence['outputs.GetModelsModelResult']:
        """
        The list of models.
        """
        return pulumi.get(self, "models")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project associated with the model.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The state of the model.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="versionLabel")
    def version_label(self) -> Optional[builtins.str]:
        return pulumi.get(self, "version_label")


class AwaitableGetModelsResult(GetModelsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetModelsResult(
            category=self.category,
            compartment_id=self.compartment_id,
            created_by=self.created_by,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            model_version_set_id=self.model_version_set_id,
            model_version_set_name=self.model_version_set_name,
            models=self.models,
            project_id=self.project_id,
            state=self.state,
            version_label=self.version_label)


def get_models(category: Optional[builtins.str] = None,
               compartment_id: Optional[builtins.str] = None,
               created_by: Optional[builtins.str] = None,
               display_name: Optional[builtins.str] = None,
               filters: Optional[Sequence[Union['GetModelsFilterArgs', 'GetModelsFilterArgsDict']]] = None,
               id: Optional[builtins.str] = None,
               model_version_set_id: Optional[builtins.str] = None,
               model_version_set_name: Optional[builtins.str] = None,
               project_id: Optional[builtins.str] = None,
               state: Optional[builtins.str] = None,
               version_label: Optional[builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetModelsResult:
    """
    This data source provides the list of Models in Oracle Cloud Infrastructure Data Science service.

    Lists models in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_models = oci.DataScience.get_models(compartment_id=compartment_id,
        category=model_category,
        created_by=model_created_by,
        display_name=model_display_name,
        id=model_id,
        model_version_set_name=test_model_version_set["name"],
        project_id=test_project["id"],
        state=model_state)
    ```


    :param builtins.str category: Specifies the type of models to list. By default, user models are listed.
    :param builtins.str compartment_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str created_by: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the resource.
    :param builtins.str display_name: <b>Filter</b> results by its user-friendly name.
    :param builtins.str id: <b>Filter</b> results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resource type.
    :param builtins.str model_version_set_id: The OCID of the model version set that the model is associated to.
    :param builtins.str model_version_set_name: The name of the model version set that the model is associated to.
    :param builtins.str project_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project.
    :param builtins.str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
    """
    __args__ = dict()
    __args__['category'] = category
    __args__['compartmentId'] = compartment_id
    __args__['createdBy'] = created_by
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['modelVersionSetId'] = model_version_set_id
    __args__['modelVersionSetName'] = model_version_set_name
    __args__['projectId'] = project_id
    __args__['state'] = state
    __args__['versionLabel'] = version_label
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataScience/getModels:getModels', __args__, opts=opts, typ=GetModelsResult).value

    return AwaitableGetModelsResult(
        category=pulumi.get(__ret__, 'category'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        created_by=pulumi.get(__ret__, 'created_by'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        model_version_set_id=pulumi.get(__ret__, 'model_version_set_id'),
        model_version_set_name=pulumi.get(__ret__, 'model_version_set_name'),
        models=pulumi.get(__ret__, 'models'),
        project_id=pulumi.get(__ret__, 'project_id'),
        state=pulumi.get(__ret__, 'state'),
        version_label=pulumi.get(__ret__, 'version_label'))
def get_models_output(category: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                      created_by: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetModelsFilterArgs', 'GetModelsFilterArgsDict']]]]] = None,
                      id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      model_version_set_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      model_version_set_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      version_label: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetModelsResult]:
    """
    This data source provides the list of Models in Oracle Cloud Infrastructure Data Science service.

    Lists models in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_models = oci.DataScience.get_models(compartment_id=compartment_id,
        category=model_category,
        created_by=model_created_by,
        display_name=model_display_name,
        id=model_id,
        model_version_set_name=test_model_version_set["name"],
        project_id=test_project["id"],
        state=model_state)
    ```


    :param builtins.str category: Specifies the type of models to list. By default, user models are listed.
    :param builtins.str compartment_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str created_by: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the resource.
    :param builtins.str display_name: <b>Filter</b> results by its user-friendly name.
    :param builtins.str id: <b>Filter</b> results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resource type.
    :param builtins.str model_version_set_id: The OCID of the model version set that the model is associated to.
    :param builtins.str model_version_set_name: The name of the model version set that the model is associated to.
    :param builtins.str project_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project.
    :param builtins.str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
    """
    __args__ = dict()
    __args__['category'] = category
    __args__['compartmentId'] = compartment_id
    __args__['createdBy'] = created_by
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['modelVersionSetId'] = model_version_set_id
    __args__['modelVersionSetName'] = model_version_set_name
    __args__['projectId'] = project_id
    __args__['state'] = state
    __args__['versionLabel'] = version_label
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataScience/getModels:getModels', __args__, opts=opts, typ=GetModelsResult)
    return __ret__.apply(lambda __response__: GetModelsResult(
        category=pulumi.get(__response__, 'category'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        created_by=pulumi.get(__response__, 'created_by'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        model_version_set_id=pulumi.get(__response__, 'model_version_set_id'),
        model_version_set_name=pulumi.get(__response__, 'model_version_set_name'),
        models=pulumi.get(__response__, 'models'),
        project_id=pulumi.get(__response__, 'project_id'),
        state=pulumi.get(__response__, 'state'),
        version_label=pulumi.get(__response__, 'version_label')))
