# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetEmailDomainsResult',
    'AwaitableGetEmailDomainsResult',
    'get_email_domains',
    'get_email_domains_output',
]

@pulumi.output_type
class GetEmailDomainsResult:
    """
    A collection of values returned by getEmailDomains.
    """
    def __init__(__self__, compartment_id=None, email_domain_collections=None, filters=None, id=None, name=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if email_domain_collections and not isinstance(email_domain_collections, list):
            raise TypeError("Expected argument 'email_domain_collections' to be a list")
        pulumi.set(__self__, "email_domain_collections", email_domain_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains this email domain.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="emailDomainCollections")
    def email_domain_collections(self) -> Sequence['outputs.GetEmailDomainsEmailDomainCollectionResult']:
        """
        The list of email_domain_collection.
        """
        return pulumi.get(self, "email_domain_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetEmailDomainsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the email domain.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the email domain in the Internet Domain Name System (DNS).  Example: `mydomain.example.com`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the email domain.
        """
        return pulumi.get(self, "state")


class AwaitableGetEmailDomainsResult(GetEmailDomainsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEmailDomainsResult(
            compartment_id=self.compartment_id,
            email_domain_collections=self.email_domain_collections,
            filters=self.filters,
            id=self.id,
            name=self.name,
            state=self.state)


def get_email_domains(compartment_id: Optional[builtins.str] = None,
                      filters: Optional[Sequence[Union['GetEmailDomainsFilterArgs', 'GetEmailDomainsFilterArgsDict']]] = None,
                      id: Optional[builtins.str] = None,
                      name: Optional[builtins.str] = None,
                      state: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEmailDomainsResult:
    """
    This data source provides the list of Email Domains in Oracle Cloud Infrastructure Email service.

    Lists email domains in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_email_domains = oci.Email.get_email_domains(compartment_id=compartment_id,
        id=email_domain_id,
        name=email_domain_name,
        state=email_domain_state)
    ```


    :param builtins.str compartment_id: The OCID for the compartment.
    :param builtins.str id: A filter to only return resources that match the given id exactly.
    :param builtins.str name: A filter to only return resources that match the given name exactly.
    :param builtins.str state: Filter returned list by specified lifecycle state. This parameter is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Email/getEmailDomains:getEmailDomains', __args__, opts=opts, typ=GetEmailDomainsResult).value

    return AwaitableGetEmailDomainsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        email_domain_collections=pulumi.get(__ret__, 'email_domain_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'))
def get_email_domains_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetEmailDomainsFilterArgs', 'GetEmailDomainsFilterArgsDict']]]]] = None,
                             id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEmailDomainsResult]:
    """
    This data source provides the list of Email Domains in Oracle Cloud Infrastructure Email service.

    Lists email domains in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_email_domains = oci.Email.get_email_domains(compartment_id=compartment_id,
        id=email_domain_id,
        name=email_domain_name,
        state=email_domain_state)
    ```


    :param builtins.str compartment_id: The OCID for the compartment.
    :param builtins.str id: A filter to only return resources that match the given id exactly.
    :param builtins.str name: A filter to only return resources that match the given name exactly.
    :param builtins.str state: Filter returned list by specified lifecycle state. This parameter is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Email/getEmailDomains:getEmailDomains', __args__, opts=opts, typ=GetEmailDomainsResult)
    return __ret__.apply(lambda __response__: GetEmailDomainsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        email_domain_collections=pulumi.get(__response__, 'email_domain_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state')))
