# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFleetCredentialsResult',
    'AwaitableGetFleetCredentialsResult',
    'get_fleet_credentials',
    'get_fleet_credentials_output',
]

@pulumi.output_type
class GetFleetCredentialsResult:
    """
    A collection of values returned by getFleetCredentials.
    """
    def __init__(__self__, compartment_id=None, credential_level=None, display_name=None, filters=None, fleet_credential_collections=None, fleet_id=None, id=None, resource_id=None, state=None, target=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if credential_level and not isinstance(credential_level, str):
            raise TypeError("Expected argument 'credential_level' to be a str")
        pulumi.set(__self__, "credential_level", credential_level)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_credential_collections and not isinstance(fleet_credential_collections, list):
            raise TypeError("Expected argument 'fleet_credential_collections' to be a list")
        pulumi.set(__self__, "fleet_credential_collections", fleet_credential_collections)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if target and not isinstance(target, str):
            raise TypeError("Expected argument 'target' to be a str")
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        Compartment OCID
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="credentialLevel")
    def credential_level(self) -> Optional[builtins.str]:
        """
        At what level the credential is provided?
        """
        return pulumi.get(self, "credential_level")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFleetCredentialsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fleetCredentialCollections")
    def fleet_credential_collections(self) -> Sequence['outputs.GetFleetCredentialsFleetCredentialCollectionResult']:
        """
        The list of fleet_credential_collection.
        """
        return pulumi.get(self, "fleet_credential_collections")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> builtins.str:
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The unique id of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[builtins.str]:
        """
        OCID of the resource associated with the target for which the credential is created.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the FleetCredential.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def target(self) -> Optional[builtins.str]:
        """
        Target name for which the credential is provided.
        """
        return pulumi.get(self, "target")


class AwaitableGetFleetCredentialsResult(GetFleetCredentialsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetCredentialsResult(
            compartment_id=self.compartment_id,
            credential_level=self.credential_level,
            display_name=self.display_name,
            filters=self.filters,
            fleet_credential_collections=self.fleet_credential_collections,
            fleet_id=self.fleet_id,
            id=self.id,
            resource_id=self.resource_id,
            state=self.state,
            target=self.target)


def get_fleet_credentials(compartment_id: Optional[builtins.str] = None,
                          credential_level: Optional[builtins.str] = None,
                          display_name: Optional[builtins.str] = None,
                          filters: Optional[Sequence[Union['GetFleetCredentialsFilterArgs', 'GetFleetCredentialsFilterArgsDict']]] = None,
                          fleet_id: Optional[builtins.str] = None,
                          id: Optional[builtins.str] = None,
                          resource_id: Optional[builtins.str] = None,
                          state: Optional[builtins.str] = None,
                          target: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetCredentialsResult:
    """
    This data source provides the list of Fleet Credentials in Oracle Cloud Infrastructure Fleet Apps Management service.

    List credentials associated with a fleet.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_credentials = oci.FleetAppsManagement.get_fleet_credentials(fleet_id=test_fleet["id"],
        credential_level=fleet_credential_credential_level,
        display_name=fleet_credential_display_name,
        id=fleet_credential_id,
        resource_id=test_resource["id"],
        state=fleet_credential_state,
        target=fleet_credential_target)
    ```


    :param builtins.str compartment_id: Compartment OCID
    :param builtins.str credential_level: A filter to return only resources whose credentialLevel matches the given credentialLevel.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str fleet_id: Unique Fleet identifier.
    :param builtins.str id: A filter to return only resources whose credential identifier matches the given identifier.
    :param builtins.str resource_id: Resource Identifier
    :param builtins.str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    :param builtins.str target: A filter to return only resources whose target matches the given target name.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['credentialLevel'] = credential_level
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['id'] = id
    __args__['resourceId'] = resource_id
    __args__['state'] = state
    __args__['target'] = target
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getFleetCredentials:getFleetCredentials', __args__, opts=opts, typ=GetFleetCredentialsResult).value

    return AwaitableGetFleetCredentialsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        credential_level=pulumi.get(__ret__, 'credential_level'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        fleet_credential_collections=pulumi.get(__ret__, 'fleet_credential_collections'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        state=pulumi.get(__ret__, 'state'),
        target=pulumi.get(__ret__, 'target'))
def get_fleet_credentials_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 credential_level: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFleetCredentialsFilterArgs', 'GetFleetCredentialsFilterArgsDict']]]]] = None,
                                 fleet_id: Optional[pulumi.Input[builtins.str]] = None,
                                 id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 resource_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 target: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFleetCredentialsResult]:
    """
    This data source provides the list of Fleet Credentials in Oracle Cloud Infrastructure Fleet Apps Management service.

    List credentials associated with a fleet.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_credentials = oci.FleetAppsManagement.get_fleet_credentials(fleet_id=test_fleet["id"],
        credential_level=fleet_credential_credential_level,
        display_name=fleet_credential_display_name,
        id=fleet_credential_id,
        resource_id=test_resource["id"],
        state=fleet_credential_state,
        target=fleet_credential_target)
    ```


    :param builtins.str compartment_id: Compartment OCID
    :param builtins.str credential_level: A filter to return only resources whose credentialLevel matches the given credentialLevel.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str fleet_id: Unique Fleet identifier.
    :param builtins.str id: A filter to return only resources whose credential identifier matches the given identifier.
    :param builtins.str resource_id: Resource Identifier
    :param builtins.str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    :param builtins.str target: A filter to return only resources whose target matches the given target name.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['credentialLevel'] = credential_level
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['id'] = id
    __args__['resourceId'] = resource_id
    __args__['state'] = state
    __args__['target'] = target
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getFleetCredentials:getFleetCredentials', __args__, opts=opts, typ=GetFleetCredentialsResult)
    return __ret__.apply(lambda __response__: GetFleetCredentialsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        credential_level=pulumi.get(__response__, 'credential_level'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        fleet_credential_collections=pulumi.get(__response__, 'fleet_credential_collections'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        id=pulumi.get(__response__, 'id'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        state=pulumi.get(__response__, 'state'),
        target=pulumi.get(__response__, 'target')))
