# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetProvisionsResult',
    'AwaitableGetProvisionsResult',
    'get_provisions',
    'get_provisions_output',
]

@pulumi.output_type
class GetProvisionsResult:
    """
    A collection of values returned by getProvisions.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, fleet_id=None, id=None, provision_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if provision_collections and not isinstance(provision_collections, list):
            raise TypeError("Expected argument 'provision_collections' to be a list")
        pulumi.set(__self__, "provision_collections", provision_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which instance is deployed.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetProvisionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        """
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the FamProvision.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="provisionCollections")
    def provision_collections(self) -> Sequence['outputs.GetProvisionsProvisionCollectionResult']:
        """
        The list of provision_collection.
        """
        return pulumi.get(self, "provision_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the FamProvision.
        """
        return pulumi.get(self, "state")


class AwaitableGetProvisionsResult(GetProvisionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProvisionsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            fleet_id=self.fleet_id,
            id=self.id,
            provision_collections=self.provision_collections,
            state=self.state)


def get_provisions(compartment_id: Optional[builtins.str] = None,
                   display_name: Optional[builtins.str] = None,
                   filters: Optional[Sequence[Union['GetProvisionsFilterArgs', 'GetProvisionsFilterArgsDict']]] = None,
                   fleet_id: Optional[builtins.str] = None,
                   id: Optional[builtins.str] = None,
                   state: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProvisionsResult:
    """
    This data source provides the list of Provisions in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of all the Provisions in the specified compartment.
    The query parameter `compartmentId` is required unless the query parameter `id` or `fleetId` is specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_provisions = oci.FleetAppsManagement.get_provisions(compartment_id=compartment_id,
        display_name=provision_display_name,
        fleet_id=test_fleet["id"],
        id=provision_id,
        state=provision_state)
    ```


    :param builtins.str compartment_id: (Updatable) The ID of the compartment in which to list resources. Empty only if the resource OCID query param is not specified.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str fleet_id: unique Fleet identifier
    :param builtins.str id: Unique identifier or OCID for listing a single provision by id. Either compartmentId or id must be provided.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getProvisions:getProvisions', __args__, opts=opts, typ=GetProvisionsResult).value

    return AwaitableGetProvisionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'),
        provision_collections=pulumi.get(__ret__, 'provision_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_provisions_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          filters: Optional[pulumi.Input[Optional[Sequence[Union['GetProvisionsFilterArgs', 'GetProvisionsFilterArgsDict']]]]] = None,
                          fleet_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProvisionsResult]:
    """
    This data source provides the list of Provisions in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of all the Provisions in the specified compartment.
    The query parameter `compartmentId` is required unless the query parameter `id` or `fleetId` is specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_provisions = oci.FleetAppsManagement.get_provisions(compartment_id=compartment_id,
        display_name=provision_display_name,
        fleet_id=test_fleet["id"],
        id=provision_id,
        state=provision_state)
    ```


    :param builtins.str compartment_id: (Updatable) The ID of the compartment in which to list resources. Empty only if the resource OCID query param is not specified.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str fleet_id: unique Fleet identifier
    :param builtins.str id: Unique identifier or OCID for listing a single provision by id. Either compartmentId or id must be provided.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getProvisions:getProvisions', __args__, opts=opts, typ=GetProvisionsResult)
    return __ret__.apply(lambda __response__: GetProvisionsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        id=pulumi.get(__response__, 'id'),
        provision_collections=pulumi.get(__response__, 'provision_collections'),
        state=pulumi.get(__response__, 'state')))
