# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSchedulerDefinitionResult',
    'AwaitableGetSchedulerDefinitionResult',
    'get_scheduler_definition',
    'get_scheduler_definition_output',
]

@pulumi.output_type
class GetSchedulerDefinitionResult:
    """
    A collection of values returned by getSchedulerDefinition.
    """
    def __init__(__self__, action_groups=None, compartment_id=None, count_of_affected_action_groups=None, count_of_affected_resources=None, count_of_affected_targets=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, lifecycle_operations=None, products=None, resource_region=None, run_books=None, scheduler_definition_id=None, schedules=None, state=None, system_tags=None, time_created=None, time_of_next_run=None, time_updated=None):
        if action_groups and not isinstance(action_groups, list):
            raise TypeError("Expected argument 'action_groups' to be a list")
        pulumi.set(__self__, "action_groups", action_groups)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if count_of_affected_action_groups and not isinstance(count_of_affected_action_groups, int):
            raise TypeError("Expected argument 'count_of_affected_action_groups' to be a int")
        pulumi.set(__self__, "count_of_affected_action_groups", count_of_affected_action_groups)
        if count_of_affected_resources and not isinstance(count_of_affected_resources, int):
            raise TypeError("Expected argument 'count_of_affected_resources' to be a int")
        pulumi.set(__self__, "count_of_affected_resources", count_of_affected_resources)
        if count_of_affected_targets and not isinstance(count_of_affected_targets, int):
            raise TypeError("Expected argument 'count_of_affected_targets' to be a int")
        pulumi.set(__self__, "count_of_affected_targets", count_of_affected_targets)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lifecycle_operations and not isinstance(lifecycle_operations, list):
            raise TypeError("Expected argument 'lifecycle_operations' to be a list")
        pulumi.set(__self__, "lifecycle_operations", lifecycle_operations)
        if products and not isinstance(products, list):
            raise TypeError("Expected argument 'products' to be a list")
        pulumi.set(__self__, "products", products)
        if resource_region and not isinstance(resource_region, str):
            raise TypeError("Expected argument 'resource_region' to be a str")
        pulumi.set(__self__, "resource_region", resource_region)
        if run_books and not isinstance(run_books, list):
            raise TypeError("Expected argument 'run_books' to be a list")
        pulumi.set(__self__, "run_books", run_books)
        if scheduler_definition_id and not isinstance(scheduler_definition_id, str):
            raise TypeError("Expected argument 'scheduler_definition_id' to be a str")
        pulumi.set(__self__, "scheduler_definition_id", scheduler_definition_id)
        if schedules and not isinstance(schedules, list):
            raise TypeError("Expected argument 'schedules' to be a list")
        pulumi.set(__self__, "schedules", schedules)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_of_next_run and not isinstance(time_of_next_run, str):
            raise TypeError("Expected argument 'time_of_next_run' to be a str")
        pulumi.set(__self__, "time_of_next_run", time_of_next_run)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="actionGroups")
    def action_groups(self) -> Sequence['outputs.GetSchedulerDefinitionActionGroupResult']:
        """
        Action Groups associated with the Schedule.
        """
        return pulumi.get(self, "action_groups")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Compartment OCID
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="countOfAffectedActionGroups")
    def count_of_affected_action_groups(self) -> builtins.int:
        """
        Count of Action Groups affected by the Schedule.
        """
        return pulumi.get(self, "count_of_affected_action_groups")

    @property
    @pulumi.getter(name="countOfAffectedResources")
    def count_of_affected_resources(self) -> builtins.int:
        """
        Count of Resources affected by the Schedule.
        """
        return pulumi.get(self, "count_of_affected_resources")

    @property
    @pulumi.getter(name="countOfAffectedTargets")
    def count_of_affected_targets(self) -> builtins.int:
        """
        Count of Targets affected by the Schedule.
        """
        return pulumi.get(self, "count_of_affected_targets")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="lifecycleOperations")
    def lifecycle_operations(self) -> Sequence[builtins.str]:
        """
        All LifeCycle Operations that are part of the schedule.
        """
        return pulumi.get(self, "lifecycle_operations")

    @property
    @pulumi.getter
    def products(self) -> Sequence[builtins.str]:
        """
        All products that are part of the schedule for PRODUCT ActionGroup Type.
        """
        return pulumi.get(self, "products")

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> builtins.str:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @property
    @pulumi.getter(name="runBooks")
    def run_books(self) -> Sequence['outputs.GetSchedulerDefinitionRunBookResult']:
        """
        Runbooks.
        """
        return pulumi.get(self, "run_books")

    @property
    @pulumi.getter(name="schedulerDefinitionId")
    def scheduler_definition_id(self) -> builtins.str:
        return pulumi.get(self, "scheduler_definition_id")

    @property
    @pulumi.getter
    def schedules(self) -> Sequence['outputs.GetSchedulerDefinitionScheduleResult']:
        """
        Schedule Information.
        """
        return pulumi.get(self, "schedules")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the SchedulerDefinition.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfNextRun")
    def time_of_next_run(self) -> builtins.str:
        """
        The scheduled date for the next run of the Job.
        """
        return pulumi.get(self, "time_of_next_run")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetSchedulerDefinitionResult(GetSchedulerDefinitionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSchedulerDefinitionResult(
            action_groups=self.action_groups,
            compartment_id=self.compartment_id,
            count_of_affected_action_groups=self.count_of_affected_action_groups,
            count_of_affected_resources=self.count_of_affected_resources,
            count_of_affected_targets=self.count_of_affected_targets,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            lifecycle_operations=self.lifecycle_operations,
            products=self.products,
            resource_region=self.resource_region,
            run_books=self.run_books,
            scheduler_definition_id=self.scheduler_definition_id,
            schedules=self.schedules,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_of_next_run=self.time_of_next_run,
            time_updated=self.time_updated)


def get_scheduler_definition(scheduler_definition_id: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSchedulerDefinitionResult:
    """
    This data source provides details about a specific Scheduler Definition resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Get the details of a SchedulerDefinition that performs lifecycle management operations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduler_definition = oci.FleetAppsManagement.get_scheduler_definition(scheduler_definition_id=test_scheduler_definition_oci_fleet_apps_management_scheduler_definition["id"])
    ```


    :param builtins.str scheduler_definition_id: unique SchedulerDefinition identifier
    """
    __args__ = dict()
    __args__['schedulerDefinitionId'] = scheduler_definition_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getSchedulerDefinition:getSchedulerDefinition', __args__, opts=opts, typ=GetSchedulerDefinitionResult).value

    return AwaitableGetSchedulerDefinitionResult(
        action_groups=pulumi.get(__ret__, 'action_groups'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        count_of_affected_action_groups=pulumi.get(__ret__, 'count_of_affected_action_groups'),
        count_of_affected_resources=pulumi.get(__ret__, 'count_of_affected_resources'),
        count_of_affected_targets=pulumi.get(__ret__, 'count_of_affected_targets'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        lifecycle_operations=pulumi.get(__ret__, 'lifecycle_operations'),
        products=pulumi.get(__ret__, 'products'),
        resource_region=pulumi.get(__ret__, 'resource_region'),
        run_books=pulumi.get(__ret__, 'run_books'),
        scheduler_definition_id=pulumi.get(__ret__, 'scheduler_definition_id'),
        schedules=pulumi.get(__ret__, 'schedules'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_of_next_run=pulumi.get(__ret__, 'time_of_next_run'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_scheduler_definition_output(scheduler_definition_id: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSchedulerDefinitionResult]:
    """
    This data source provides details about a specific Scheduler Definition resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Get the details of a SchedulerDefinition that performs lifecycle management operations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduler_definition = oci.FleetAppsManagement.get_scheduler_definition(scheduler_definition_id=test_scheduler_definition_oci_fleet_apps_management_scheduler_definition["id"])
    ```


    :param builtins.str scheduler_definition_id: unique SchedulerDefinition identifier
    """
    __args__ = dict()
    __args__['schedulerDefinitionId'] = scheduler_definition_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getSchedulerDefinition:getSchedulerDefinition', __args__, opts=opts, typ=GetSchedulerDefinitionResult)
    return __ret__.apply(lambda __response__: GetSchedulerDefinitionResult(
        action_groups=pulumi.get(__response__, 'action_groups'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        count_of_affected_action_groups=pulumi.get(__response__, 'count_of_affected_action_groups'),
        count_of_affected_resources=pulumi.get(__response__, 'count_of_affected_resources'),
        count_of_affected_targets=pulumi.get(__response__, 'count_of_affected_targets'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        lifecycle_operations=pulumi.get(__response__, 'lifecycle_operations'),
        products=pulumi.get(__response__, 'products'),
        resource_region=pulumi.get(__response__, 'resource_region'),
        run_books=pulumi.get(__response__, 'run_books'),
        scheduler_definition_id=pulumi.get(__response__, 'scheduler_definition_id'),
        schedules=pulumi.get(__response__, 'schedules'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_of_next_run=pulumi.get(__response__, 'time_of_next_run'),
        time_updated=pulumi.get(__response__, 'time_updated')))
