# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSchedulerExecutionsResult',
    'AwaitableGetSchedulerExecutionsResult',
    'get_scheduler_executions',
    'get_scheduler_executions_output',
]

@pulumi.output_type
class GetSchedulerExecutionsResult:
    """
    A collection of values returned by getSchedulerExecutions.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, resource_id=None, runbook_id=None, runbook_version_name=None, scheduler_defintion_id=None, scheduler_execution_collections=None, scheduler_job_id=None, substate=None, time_scheduled_greater_than_or_equal_to=None, time_scheduled_less_than=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if runbook_id and not isinstance(runbook_id, str):
            raise TypeError("Expected argument 'runbook_id' to be a str")
        pulumi.set(__self__, "runbook_id", runbook_id)
        if runbook_version_name and not isinstance(runbook_version_name, str):
            raise TypeError("Expected argument 'runbook_version_name' to be a str")
        pulumi.set(__self__, "runbook_version_name", runbook_version_name)
        if scheduler_defintion_id and not isinstance(scheduler_defintion_id, str):
            raise TypeError("Expected argument 'scheduler_defintion_id' to be a str")
        pulumi.set(__self__, "scheduler_defintion_id", scheduler_defintion_id)
        if scheduler_execution_collections and not isinstance(scheduler_execution_collections, list):
            raise TypeError("Expected argument 'scheduler_execution_collections' to be a list")
        pulumi.set(__self__, "scheduler_execution_collections", scheduler_execution_collections)
        if scheduler_job_id and not isinstance(scheduler_job_id, str):
            raise TypeError("Expected argument 'scheduler_job_id' to be a str")
        pulumi.set(__self__, "scheduler_job_id", scheduler_job_id)
        if substate and not isinstance(substate, str):
            raise TypeError("Expected argument 'substate' to be a str")
        pulumi.set(__self__, "substate", substate)
        if time_scheduled_greater_than_or_equal_to and not isinstance(time_scheduled_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_scheduled_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_scheduled_greater_than_or_equal_to", time_scheduled_greater_than_or_equal_to)
        if time_scheduled_less_than and not isinstance(time_scheduled_less_than, str):
            raise TypeError("Expected argument 'time_scheduled_less_than' to be a str")
        pulumi.set(__self__, "time_scheduled_less_than", time_scheduled_less_than)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        Compartment OCID
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSchedulerExecutionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[builtins.str]:
        """
        ResourceId associated with the Schedule.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> Optional[builtins.str]:
        """
        RunbookId associated with the Schedule.
        """
        return pulumi.get(self, "runbook_id")

    @property
    @pulumi.getter(name="runbookVersionName")
    def runbook_version_name(self) -> Optional[builtins.str]:
        """
        Name of the Runbook version associated with the Schedule.
        """
        return pulumi.get(self, "runbook_version_name")

    @property
    @pulumi.getter(name="schedulerDefintionId")
    def scheduler_defintion_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "scheduler_defintion_id")

    @property
    @pulumi.getter(name="schedulerExecutionCollections")
    def scheduler_execution_collections(self) -> Sequence['outputs.GetSchedulerExecutionsSchedulerExecutionCollectionResult']:
        """
        The list of scheduler_execution_collection.
        """
        return pulumi.get(self, "scheduler_execution_collections")

    @property
    @pulumi.getter(name="schedulerJobId")
    def scheduler_job_id(self) -> Optional[builtins.str]:
        """
        jobId associated with the Schedule.
        """
        return pulumi.get(self, "scheduler_job_id")

    @property
    @pulumi.getter
    def substate(self) -> Optional[builtins.str]:
        return pulumi.get(self, "substate")

    @property
    @pulumi.getter(name="timeScheduledGreaterThanOrEqualTo")
    def time_scheduled_greater_than_or_equal_to(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_scheduled_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timeScheduledLessThan")
    def time_scheduled_less_than(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_scheduled_less_than")


class AwaitableGetSchedulerExecutionsResult(GetSchedulerExecutionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSchedulerExecutionsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            resource_id=self.resource_id,
            runbook_id=self.runbook_id,
            runbook_version_name=self.runbook_version_name,
            scheduler_defintion_id=self.scheduler_defintion_id,
            scheduler_execution_collections=self.scheduler_execution_collections,
            scheduler_job_id=self.scheduler_job_id,
            substate=self.substate,
            time_scheduled_greater_than_or_equal_to=self.time_scheduled_greater_than_or_equal_to,
            time_scheduled_less_than=self.time_scheduled_less_than)


def get_scheduler_executions(compartment_id: Optional[builtins.str] = None,
                             display_name: Optional[builtins.str] = None,
                             filters: Optional[Sequence[Union['GetSchedulerExecutionsFilterArgs', 'GetSchedulerExecutionsFilterArgsDict']]] = None,
                             resource_id: Optional[builtins.str] = None,
                             runbook_id: Optional[builtins.str] = None,
                             runbook_version_name: Optional[builtins.str] = None,
                             scheduler_defintion_id: Optional[builtins.str] = None,
                             scheduler_job_id: Optional[builtins.str] = None,
                             substate: Optional[builtins.str] = None,
                             time_scheduled_greater_than_or_equal_to: Optional[builtins.str] = None,
                             time_scheduled_less_than: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSchedulerExecutionsResult:
    """
    This data source provides the list of Scheduler Executions in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of all Fleets that are scheduled.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduler_executions = oci.FleetAppsManagement.get_scheduler_executions(compartment_id=compartment_id,
        display_name=scheduler_execution_display_name,
        resource_id=test_resource["id"],
        runbook_id=test_runbook["id"],
        runbook_version_name=test_runbook_version["name"],
        scheduler_defintion_id=test_scheduler_defintion["id"],
        scheduler_job_id=test_job["id"],
        substate=scheduler_execution_substate,
        time_scheduled_greater_than_or_equal_to=scheduler_execution_time_scheduled_greater_than_or_equal_to,
        time_scheduled_less_than=scheduler_execution_time_scheduled_less_than)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources. Empty only if the resource OCID query param is not specified.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str resource_id: ResourceId filter (Example FleetId)
    :param builtins.str runbook_id: A filter to return only schedule definitions whose associated runbookId matches the given runbookId.
    :param builtins.str runbook_version_name: RunbookVersion Name filter
    :param builtins.str scheduler_defintion_id: SchedulerDefinition identifier
    :param builtins.str scheduler_job_id: SchedulerJob identifier filter
    :param builtins.str substate: A filter to return only resources their subState matches the given subState.
    :param builtins.str time_scheduled_greater_than_or_equal_to: Scheduled Time
    :param builtins.str time_scheduled_less_than: Scheduled Time
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['resourceId'] = resource_id
    __args__['runbookId'] = runbook_id
    __args__['runbookVersionName'] = runbook_version_name
    __args__['schedulerDefintionId'] = scheduler_defintion_id
    __args__['schedulerJobId'] = scheduler_job_id
    __args__['substate'] = substate
    __args__['timeScheduledGreaterThanOrEqualTo'] = time_scheduled_greater_than_or_equal_to
    __args__['timeScheduledLessThan'] = time_scheduled_less_than
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getSchedulerExecutions:getSchedulerExecutions', __args__, opts=opts, typ=GetSchedulerExecutionsResult).value

    return AwaitableGetSchedulerExecutionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        runbook_id=pulumi.get(__ret__, 'runbook_id'),
        runbook_version_name=pulumi.get(__ret__, 'runbook_version_name'),
        scheduler_defintion_id=pulumi.get(__ret__, 'scheduler_defintion_id'),
        scheduler_execution_collections=pulumi.get(__ret__, 'scheduler_execution_collections'),
        scheduler_job_id=pulumi.get(__ret__, 'scheduler_job_id'),
        substate=pulumi.get(__ret__, 'substate'),
        time_scheduled_greater_than_or_equal_to=pulumi.get(__ret__, 'time_scheduled_greater_than_or_equal_to'),
        time_scheduled_less_than=pulumi.get(__ret__, 'time_scheduled_less_than'))
def get_scheduler_executions_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSchedulerExecutionsFilterArgs', 'GetSchedulerExecutionsFilterArgsDict']]]]] = None,
                                    resource_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    runbook_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    runbook_version_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    scheduler_defintion_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    scheduler_job_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    substate: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    time_scheduled_greater_than_or_equal_to: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    time_scheduled_less_than: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSchedulerExecutionsResult]:
    """
    This data source provides the list of Scheduler Executions in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of all Fleets that are scheduled.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduler_executions = oci.FleetAppsManagement.get_scheduler_executions(compartment_id=compartment_id,
        display_name=scheduler_execution_display_name,
        resource_id=test_resource["id"],
        runbook_id=test_runbook["id"],
        runbook_version_name=test_runbook_version["name"],
        scheduler_defintion_id=test_scheduler_defintion["id"],
        scheduler_job_id=test_job["id"],
        substate=scheduler_execution_substate,
        time_scheduled_greater_than_or_equal_to=scheduler_execution_time_scheduled_greater_than_or_equal_to,
        time_scheduled_less_than=scheduler_execution_time_scheduled_less_than)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources. Empty only if the resource OCID query param is not specified.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str resource_id: ResourceId filter (Example FleetId)
    :param builtins.str runbook_id: A filter to return only schedule definitions whose associated runbookId matches the given runbookId.
    :param builtins.str runbook_version_name: RunbookVersion Name filter
    :param builtins.str scheduler_defintion_id: SchedulerDefinition identifier
    :param builtins.str scheduler_job_id: SchedulerJob identifier filter
    :param builtins.str substate: A filter to return only resources their subState matches the given subState.
    :param builtins.str time_scheduled_greater_than_or_equal_to: Scheduled Time
    :param builtins.str time_scheduled_less_than: Scheduled Time
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['resourceId'] = resource_id
    __args__['runbookId'] = runbook_id
    __args__['runbookVersionName'] = runbook_version_name
    __args__['schedulerDefintionId'] = scheduler_defintion_id
    __args__['schedulerJobId'] = scheduler_job_id
    __args__['substate'] = substate
    __args__['timeScheduledGreaterThanOrEqualTo'] = time_scheduled_greater_than_or_equal_to
    __args__['timeScheduledLessThan'] = time_scheduled_less_than
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getSchedulerExecutions:getSchedulerExecutions', __args__, opts=opts, typ=GetSchedulerExecutionsResult)
    return __ret__.apply(lambda __response__: GetSchedulerExecutionsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        runbook_id=pulumi.get(__response__, 'runbook_id'),
        runbook_version_name=pulumi.get(__response__, 'runbook_version_name'),
        scheduler_defintion_id=pulumi.get(__response__, 'scheduler_defintion_id'),
        scheduler_execution_collections=pulumi.get(__response__, 'scheduler_execution_collections'),
        scheduler_job_id=pulumi.get(__response__, 'scheduler_job_id'),
        substate=pulumi.get(__response__, 'substate'),
        time_scheduled_greater_than_or_equal_to=pulumi.get(__response__, 'time_scheduled_greater_than_or_equal_to'),
        time_scheduled_less_than=pulumi.get(__response__, 'time_scheduled_less_than')))
