# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetTaskRecordsResult',
    'AwaitableGetTaskRecordsResult',
    'get_task_records',
    'get_task_records_output',
]

@pulumi.output_type
class GetTaskRecordsResult:
    """
    A collection of values returned by getTaskRecords.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, operation=None, platform=None, state=None, task_record_collections=None, type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if operation and not isinstance(operation, str):
            raise TypeError("Expected argument 'operation' to be a str")
        pulumi.set(__self__, "operation", operation)
        if platform and not isinstance(platform, str):
            raise TypeError("Expected argument 'platform' to be a str")
        pulumi.set(__self__, "platform", platform)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if task_record_collections and not isinstance(task_record_collections, list):
            raise TypeError("Expected argument 'task_record_collections' to be a list")
        pulumi.set(__self__, "task_record_collections", task_record_collections)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetTaskRecordsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def operation(self) -> Optional[builtins.str]:
        """
        The lifecycle operation performed by the runbook.
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter
    def platform(self) -> Optional[builtins.str]:
        """
        The platform of the runbook.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the task record.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskRecordCollections")
    def task_record_collections(self) -> Sequence['outputs.GetTaskRecordsTaskRecordCollectionResult']:
        """
        The list of task_record_collection.
        """
        return pulumi.get(self, "task_record_collections")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        Task type.
        """
        return pulumi.get(self, "type")


class AwaitableGetTaskRecordsResult(GetTaskRecordsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTaskRecordsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            operation=self.operation,
            platform=self.platform,
            state=self.state,
            task_record_collections=self.task_record_collections,
            type=self.type)


def get_task_records(compartment_id: Optional[builtins.str] = None,
                     display_name: Optional[builtins.str] = None,
                     filters: Optional[Sequence[Union['GetTaskRecordsFilterArgs', 'GetTaskRecordsFilterArgsDict']]] = None,
                     id: Optional[builtins.str] = None,
                     operation: Optional[builtins.str] = None,
                     platform: Optional[builtins.str] = None,
                     state: Optional[builtins.str] = None,
                     type: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTaskRecordsResult:
    """
    This data source provides the list of Task Records in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of all the task records in the specified compartment.
    The query parameter `compartmentId` is required unless the query parameter `id` is specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_task_records = oci.FleetAppsManagement.get_task_records(compartment_id=compartment_id,
        display_name=task_record_display_name,
        id=task_record_id,
        operation=task_record_operation,
        platform=task_record_platform,
        state=task_record_state,
        type=task_record_type)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources. Empty only if the resource OCID query param is not specified.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str id: Unique identifier or OCID for listing a single task record by id. Either compartmentId or id must be provided.
    :param builtins.str operation: A filter to return task records whose operation matches the given lifecycle operation.
    :param builtins.str platform: The platform for the task record.
    :param builtins.str state: The current state of the task record.
    :param builtins.str type: The type of the Task.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['operation'] = operation
    __args__['platform'] = platform
    __args__['state'] = state
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getTaskRecords:getTaskRecords', __args__, opts=opts, typ=GetTaskRecordsResult).value

    return AwaitableGetTaskRecordsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        operation=pulumi.get(__ret__, 'operation'),
        platform=pulumi.get(__ret__, 'platform'),
        state=pulumi.get(__ret__, 'state'),
        task_record_collections=pulumi.get(__ret__, 'task_record_collections'),
        type=pulumi.get(__ret__, 'type'))
def get_task_records_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            filters: Optional[pulumi.Input[Optional[Sequence[Union['GetTaskRecordsFilterArgs', 'GetTaskRecordsFilterArgsDict']]]]] = None,
                            id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            operation: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            platform: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTaskRecordsResult]:
    """
    This data source provides the list of Task Records in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of all the task records in the specified compartment.
    The query parameter `compartmentId` is required unless the query parameter `id` is specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_task_records = oci.FleetAppsManagement.get_task_records(compartment_id=compartment_id,
        display_name=task_record_display_name,
        id=task_record_id,
        operation=task_record_operation,
        platform=task_record_platform,
        state=task_record_state,
        type=task_record_type)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources. Empty only if the resource OCID query param is not specified.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str id: Unique identifier or OCID for listing a single task record by id. Either compartmentId or id must be provided.
    :param builtins.str operation: A filter to return task records whose operation matches the given lifecycle operation.
    :param builtins.str platform: The platform for the task record.
    :param builtins.str state: The current state of the task record.
    :param builtins.str type: The type of the Task.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['operation'] = operation
    __args__['platform'] = platform
    __args__['state'] = state
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getTaskRecords:getTaskRecords', __args__, opts=opts, typ=GetTaskRecordsResult)
    return __ret__.apply(lambda __response__: GetTaskRecordsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        operation=pulumi.get(__response__, 'operation'),
        platform=pulumi.get(__response__, 'platform'),
        state=pulumi.get(__response__, 'state'),
        task_record_collections=pulumi.get(__response__, 'task_record_collections'),
        type=pulumi.get(__response__, 'type')))
