# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProvisionArgs', 'Provision']

@pulumi.input_type
class ProvisionArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 config_catalog_item_id: pulumi.Input[builtins.str],
                 fleet_id: pulumi.Input[builtins.str],
                 package_catalog_item_id: pulumi.Input[builtins.str],
                 tf_variable_region_id: pulumi.Input[builtins.str],
                 tf_variable_tenancy_id: pulumi.Input[builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 provision_description: Optional[pulumi.Input[builtins.str]] = None,
                 tf_variable_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 tf_variable_current_user_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Provision resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the FamProvision in.
        :param pulumi.Input[builtins.str] config_catalog_item_id: A [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Catalog Item to a file with key/value pairs to set up variables for createStack API.
        :param pulumi.Input[builtins.str] fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        :param pulumi.Input[builtins.str] package_catalog_item_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Catalog Item.
        :param pulumi.Input[builtins.str] tf_variable_region_id: A mandatory variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        :param pulumi.Input[builtins.str] tf_variable_tenancy_id: A mandatory variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] provision_description: (Updatable) A description of the provision.
        :param pulumi.Input[builtins.str] tf_variable_compartment_id: An optional variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        :param pulumi.Input[builtins.str] tf_variable_current_user_id: An optional variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "config_catalog_item_id", config_catalog_item_id)
        pulumi.set(__self__, "fleet_id", fleet_id)
        pulumi.set(__self__, "package_catalog_item_id", package_catalog_item_id)
        pulumi.set(__self__, "tf_variable_region_id", tf_variable_region_id)
        pulumi.set(__self__, "tf_variable_tenancy_id", tf_variable_tenancy_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if provision_description is not None:
            pulumi.set(__self__, "provision_description", provision_description)
        if tf_variable_compartment_id is not None:
            pulumi.set(__self__, "tf_variable_compartment_id", tf_variable_compartment_id)
        if tf_variable_current_user_id is not None:
            pulumi.set(__self__, "tf_variable_current_user_id", tf_variable_current_user_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the FamProvision in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="configCatalogItemId")
    def config_catalog_item_id(self) -> pulumi.Input[builtins.str]:
        """
        A [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Catalog Item to a file with key/value pairs to set up variables for createStack API.
        """
        return pulumi.get(self, "config_catalog_item_id")

    @config_catalog_item_id.setter
    def config_catalog_item_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "config_catalog_item_id", value)

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        """
        return pulumi.get(self, "fleet_id")

    @fleet_id.setter
    def fleet_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "fleet_id", value)

    @property
    @pulumi.getter(name="packageCatalogItemId")
    def package_catalog_item_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Catalog Item.
        """
        return pulumi.get(self, "package_catalog_item_id")

    @package_catalog_item_id.setter
    def package_catalog_item_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "package_catalog_item_id", value)

    @property
    @pulumi.getter(name="tfVariableRegionId")
    def tf_variable_region_id(self) -> pulumi.Input[builtins.str]:
        """
        A mandatory variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        """
        return pulumi.get(self, "tf_variable_region_id")

    @tf_variable_region_id.setter
    def tf_variable_region_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tf_variable_region_id", value)

    @property
    @pulumi.getter(name="tfVariableTenancyId")
    def tf_variable_tenancy_id(self) -> pulumi.Input[builtins.str]:
        """
        A mandatory variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tf_variable_tenancy_id")

    @tf_variable_tenancy_id.setter
    def tf_variable_tenancy_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tf_variable_tenancy_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="provisionDescription")
    def provision_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A description of the provision.
        """
        return pulumi.get(self, "provision_description")

    @provision_description.setter
    def provision_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "provision_description", value)

    @property
    @pulumi.getter(name="tfVariableCompartmentId")
    def tf_variable_compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        """
        return pulumi.get(self, "tf_variable_compartment_id")

    @tf_variable_compartment_id.setter
    def tf_variable_compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tf_variable_compartment_id", value)

    @property
    @pulumi.getter(name="tfVariableCurrentUserId")
    def tf_variable_current_user_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        """
        return pulumi.get(self, "tf_variable_current_user_id")

    @tf_variable_current_user_id.setter
    def tf_variable_current_user_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tf_variable_current_user_id", value)


@pulumi.input_type
class _ProvisionState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 config_catalog_item_display_name: Optional[pulumi.Input[builtins.str]] = None,
                 config_catalog_item_id: Optional[pulumi.Input[builtins.str]] = None,
                 config_catalog_item_listing_id: Optional[pulumi.Input[builtins.str]] = None,
                 config_catalog_item_listing_version: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 deployed_resources: Optional[pulumi.Input[Sequence[pulumi.Input['ProvisionDeployedResourceArgs']]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 fleet_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 package_catalog_item_display_name: Optional[pulumi.Input[builtins.str]] = None,
                 package_catalog_item_id: Optional[pulumi.Input[builtins.str]] = None,
                 package_catalog_item_listing_id: Optional[pulumi.Input[builtins.str]] = None,
                 package_catalog_item_listing_version: Optional[pulumi.Input[builtins.str]] = None,
                 provision_description: Optional[pulumi.Input[builtins.str]] = None,
                 rms_apply_job_id: Optional[pulumi.Input[builtins.str]] = None,
                 stack_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tf_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['ProvisionTfOutputArgs']]]] = None,
                 tf_variable_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 tf_variable_current_user_id: Optional[pulumi.Input[builtins.str]] = None,
                 tf_variable_region_id: Optional[pulumi.Input[builtins.str]] = None,
                 tf_variable_tenancy_id: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Provision resources.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the FamProvision in.
        :param pulumi.Input[builtins.str] config_catalog_item_display_name: A display Name of the Catalog Item in the Catalog.
        :param pulumi.Input[builtins.str] config_catalog_item_id: A [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Catalog Item to a file with key/value pairs to set up variables for createStack API.
        :param pulumi.Input[builtins.str] config_catalog_item_listing_id: A listing ID of the Catalog Item in the Catalog.
        :param pulumi.Input[builtins.str] config_catalog_item_listing_version: A listing version of the Catalog Item in the Catalog.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['ProvisionDeployedResourceArgs']]] deployed_resources: The deployed resources and their summary
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] lifecycle_details: A message that describes the current state of the FamProvision in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[builtins.str] package_catalog_item_display_name: A display Name of the Catalog Item in the Catalog.
        :param pulumi.Input[builtins.str] package_catalog_item_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Catalog Item.
        :param pulumi.Input[builtins.str] package_catalog_item_listing_id: A listing ID of the Catalog Item in the Catalog.
        :param pulumi.Input[builtins.str] package_catalog_item_listing_version: A listing version of the Catalog Item in the Catalog.
        :param pulumi.Input[builtins.str] provision_description: (Updatable) A description of the provision.
        :param pulumi.Input[builtins.str] rms_apply_job_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the RMS APPLY Job.
        :param pulumi.Input[builtins.str] stack_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the RMS Stack.
        :param pulumi.Input[builtins.str] state: The current state of the FamProvision.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[Sequence[pulumi.Input['ProvisionTfOutputArgs']]] tf_outputs: Outputs from the pulumi up job
        :param pulumi.Input[builtins.str] tf_variable_compartment_id: An optional variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        :param pulumi.Input[builtins.str] tf_variable_current_user_id: An optional variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        :param pulumi.Input[builtins.str] tf_variable_region_id: A mandatory variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        :param pulumi.Input[builtins.str] tf_variable_tenancy_id: A mandatory variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_created: The date and time the FamProvision was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_updated: The date and time the FamProvision was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if config_catalog_item_display_name is not None:
            pulumi.set(__self__, "config_catalog_item_display_name", config_catalog_item_display_name)
        if config_catalog_item_id is not None:
            pulumi.set(__self__, "config_catalog_item_id", config_catalog_item_id)
        if config_catalog_item_listing_id is not None:
            pulumi.set(__self__, "config_catalog_item_listing_id", config_catalog_item_listing_id)
        if config_catalog_item_listing_version is not None:
            pulumi.set(__self__, "config_catalog_item_listing_version", config_catalog_item_listing_version)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deployed_resources is not None:
            pulumi.set(__self__, "deployed_resources", deployed_resources)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if fleet_id is not None:
            pulumi.set(__self__, "fleet_id", fleet_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if package_catalog_item_display_name is not None:
            pulumi.set(__self__, "package_catalog_item_display_name", package_catalog_item_display_name)
        if package_catalog_item_id is not None:
            pulumi.set(__self__, "package_catalog_item_id", package_catalog_item_id)
        if package_catalog_item_listing_id is not None:
            pulumi.set(__self__, "package_catalog_item_listing_id", package_catalog_item_listing_id)
        if package_catalog_item_listing_version is not None:
            pulumi.set(__self__, "package_catalog_item_listing_version", package_catalog_item_listing_version)
        if provision_description is not None:
            pulumi.set(__self__, "provision_description", provision_description)
        if rms_apply_job_id is not None:
            pulumi.set(__self__, "rms_apply_job_id", rms_apply_job_id)
        if stack_id is not None:
            pulumi.set(__self__, "stack_id", stack_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if tf_outputs is not None:
            pulumi.set(__self__, "tf_outputs", tf_outputs)
        if tf_variable_compartment_id is not None:
            pulumi.set(__self__, "tf_variable_compartment_id", tf_variable_compartment_id)
        if tf_variable_current_user_id is not None:
            pulumi.set(__self__, "tf_variable_current_user_id", tf_variable_current_user_id)
        if tf_variable_region_id is not None:
            pulumi.set(__self__, "tf_variable_region_id", tf_variable_region_id)
        if tf_variable_tenancy_id is not None:
            pulumi.set(__self__, "tf_variable_tenancy_id", tf_variable_tenancy_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the FamProvision in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="configCatalogItemDisplayName")
    def config_catalog_item_display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A display Name of the Catalog Item in the Catalog.
        """
        return pulumi.get(self, "config_catalog_item_display_name")

    @config_catalog_item_display_name.setter
    def config_catalog_item_display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "config_catalog_item_display_name", value)

    @property
    @pulumi.getter(name="configCatalogItemId")
    def config_catalog_item_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Catalog Item to a file with key/value pairs to set up variables for createStack API.
        """
        return pulumi.get(self, "config_catalog_item_id")

    @config_catalog_item_id.setter
    def config_catalog_item_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "config_catalog_item_id", value)

    @property
    @pulumi.getter(name="configCatalogItemListingId")
    def config_catalog_item_listing_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A listing ID of the Catalog Item in the Catalog.
        """
        return pulumi.get(self, "config_catalog_item_listing_id")

    @config_catalog_item_listing_id.setter
    def config_catalog_item_listing_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "config_catalog_item_listing_id", value)

    @property
    @pulumi.getter(name="configCatalogItemListingVersion")
    def config_catalog_item_listing_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A listing version of the Catalog Item in the Catalog.
        """
        return pulumi.get(self, "config_catalog_item_listing_version")

    @config_catalog_item_listing_version.setter
    def config_catalog_item_listing_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "config_catalog_item_listing_version", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deployedResources")
    def deployed_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProvisionDeployedResourceArgs']]]]:
        """
        The deployed resources and their summary
        """
        return pulumi.get(self, "deployed_resources")

    @deployed_resources.setter
    def deployed_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProvisionDeployedResourceArgs']]]]):
        pulumi.set(self, "deployed_resources", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        """
        return pulumi.get(self, "fleet_id")

    @fleet_id.setter
    def fleet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fleet_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A message that describes the current state of the FamProvision in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="packageCatalogItemDisplayName")
    def package_catalog_item_display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A display Name of the Catalog Item in the Catalog.
        """
        return pulumi.get(self, "package_catalog_item_display_name")

    @package_catalog_item_display_name.setter
    def package_catalog_item_display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "package_catalog_item_display_name", value)

    @property
    @pulumi.getter(name="packageCatalogItemId")
    def package_catalog_item_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Catalog Item.
        """
        return pulumi.get(self, "package_catalog_item_id")

    @package_catalog_item_id.setter
    def package_catalog_item_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "package_catalog_item_id", value)

    @property
    @pulumi.getter(name="packageCatalogItemListingId")
    def package_catalog_item_listing_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A listing ID of the Catalog Item in the Catalog.
        """
        return pulumi.get(self, "package_catalog_item_listing_id")

    @package_catalog_item_listing_id.setter
    def package_catalog_item_listing_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "package_catalog_item_listing_id", value)

    @property
    @pulumi.getter(name="packageCatalogItemListingVersion")
    def package_catalog_item_listing_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A listing version of the Catalog Item in the Catalog.
        """
        return pulumi.get(self, "package_catalog_item_listing_version")

    @package_catalog_item_listing_version.setter
    def package_catalog_item_listing_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "package_catalog_item_listing_version", value)

    @property
    @pulumi.getter(name="provisionDescription")
    def provision_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A description of the provision.
        """
        return pulumi.get(self, "provision_description")

    @provision_description.setter
    def provision_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "provision_description", value)

    @property
    @pulumi.getter(name="rmsApplyJobId")
    def rms_apply_job_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the RMS APPLY Job.
        """
        return pulumi.get(self, "rms_apply_job_id")

    @rms_apply_job_id.setter
    def rms_apply_job_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rms_apply_job_id", value)

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the RMS Stack.
        """
        return pulumi.get(self, "stack_id")

    @stack_id.setter
    def stack_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stack_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the FamProvision.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="tfOutputs")
    def tf_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProvisionTfOutputArgs']]]]:
        """
        Outputs from the pulumi up job
        """
        return pulumi.get(self, "tf_outputs")

    @tf_outputs.setter
    def tf_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProvisionTfOutputArgs']]]]):
        pulumi.set(self, "tf_outputs", value)

    @property
    @pulumi.getter(name="tfVariableCompartmentId")
    def tf_variable_compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        """
        return pulumi.get(self, "tf_variable_compartment_id")

    @tf_variable_compartment_id.setter
    def tf_variable_compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tf_variable_compartment_id", value)

    @property
    @pulumi.getter(name="tfVariableCurrentUserId")
    def tf_variable_current_user_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        """
        return pulumi.get(self, "tf_variable_current_user_id")

    @tf_variable_current_user_id.setter
    def tf_variable_current_user_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tf_variable_current_user_id", value)

    @property
    @pulumi.getter(name="tfVariableRegionId")
    def tf_variable_region_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A mandatory variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        """
        return pulumi.get(self, "tf_variable_region_id")

    @tf_variable_region_id.setter
    def tf_variable_region_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tf_variable_region_id", value)

    @property
    @pulumi.getter(name="tfVariableTenancyId")
    def tf_variable_tenancy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A mandatory variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tf_variable_tenancy_id")

    @tf_variable_tenancy_id.setter
    def tf_variable_tenancy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tf_variable_tenancy_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the FamProvision was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the FamProvision was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:FleetAppsManagement/provision:Provision")
class Provision(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 config_catalog_item_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 fleet_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 package_catalog_item_id: Optional[pulumi.Input[builtins.str]] = None,
                 provision_description: Optional[pulumi.Input[builtins.str]] = None,
                 tf_variable_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 tf_variable_current_user_id: Optional[pulumi.Input[builtins.str]] = None,
                 tf_variable_region_id: Optional[pulumi.Input[builtins.str]] = None,
                 tf_variable_tenancy_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Provision resource in Oracle Cloud Infrastructure Fleet Apps Management service.

        Creates a Provision.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_provision = oci.fleet_apps_management.Provision("test_provision",
            compartment_id=compartment_id,
            config_catalog_item_id=test_catalog_item["id"],
            fleet_id=test_fleet["id"],
            package_catalog_item_id=test_catalog_item["id"],
            tf_variable_region_id=test_region["id"],
            tf_variable_tenancy_id=test_tenancy["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=provision_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            provision_description=provision_provision_description,
            tf_variable_compartment_id=test_compartment["id"],
            tf_variable_current_user_id=test_user["id"])
        ```

        ## Import

        Provisions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FleetAppsManagement/provision:Provision test_provision "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the FamProvision in.
        :param pulumi.Input[builtins.str] config_catalog_item_id: A [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Catalog Item to a file with key/value pairs to set up variables for createStack API.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] package_catalog_item_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Catalog Item.
        :param pulumi.Input[builtins.str] provision_description: (Updatable) A description of the provision.
        :param pulumi.Input[builtins.str] tf_variable_compartment_id: An optional variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        :param pulumi.Input[builtins.str] tf_variable_current_user_id: An optional variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        :param pulumi.Input[builtins.str] tf_variable_region_id: A mandatory variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        :param pulumi.Input[builtins.str] tf_variable_tenancy_id: A mandatory variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProvisionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Provision resource in Oracle Cloud Infrastructure Fleet Apps Management service.

        Creates a Provision.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_provision = oci.fleet_apps_management.Provision("test_provision",
            compartment_id=compartment_id,
            config_catalog_item_id=test_catalog_item["id"],
            fleet_id=test_fleet["id"],
            package_catalog_item_id=test_catalog_item["id"],
            tf_variable_region_id=test_region["id"],
            tf_variable_tenancy_id=test_tenancy["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=provision_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            provision_description=provision_provision_description,
            tf_variable_compartment_id=test_compartment["id"],
            tf_variable_current_user_id=test_user["id"])
        ```

        ## Import

        Provisions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FleetAppsManagement/provision:Provision test_provision "id"
        ```

        :param str resource_name: The name of the resource.
        :param ProvisionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProvisionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 config_catalog_item_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 fleet_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 package_catalog_item_id: Optional[pulumi.Input[builtins.str]] = None,
                 provision_description: Optional[pulumi.Input[builtins.str]] = None,
                 tf_variable_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 tf_variable_current_user_id: Optional[pulumi.Input[builtins.str]] = None,
                 tf_variable_region_id: Optional[pulumi.Input[builtins.str]] = None,
                 tf_variable_tenancy_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProvisionArgs.__new__(ProvisionArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if config_catalog_item_id is None and not opts.urn:
                raise TypeError("Missing required property 'config_catalog_item_id'")
            __props__.__dict__["config_catalog_item_id"] = config_catalog_item_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            if fleet_id is None and not opts.urn:
                raise TypeError("Missing required property 'fleet_id'")
            __props__.__dict__["fleet_id"] = fleet_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            if package_catalog_item_id is None and not opts.urn:
                raise TypeError("Missing required property 'package_catalog_item_id'")
            __props__.__dict__["package_catalog_item_id"] = package_catalog_item_id
            __props__.__dict__["provision_description"] = provision_description
            __props__.__dict__["tf_variable_compartment_id"] = tf_variable_compartment_id
            __props__.__dict__["tf_variable_current_user_id"] = tf_variable_current_user_id
            if tf_variable_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'tf_variable_region_id'")
            __props__.__dict__["tf_variable_region_id"] = tf_variable_region_id
            if tf_variable_tenancy_id is None and not opts.urn:
                raise TypeError("Missing required property 'tf_variable_tenancy_id'")
            __props__.__dict__["tf_variable_tenancy_id"] = tf_variable_tenancy_id
            __props__.__dict__["config_catalog_item_display_name"] = None
            __props__.__dict__["config_catalog_item_listing_id"] = None
            __props__.__dict__["config_catalog_item_listing_version"] = None
            __props__.__dict__["deployed_resources"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["package_catalog_item_display_name"] = None
            __props__.__dict__["package_catalog_item_listing_id"] = None
            __props__.__dict__["package_catalog_item_listing_version"] = None
            __props__.__dict__["rms_apply_job_id"] = None
            __props__.__dict__["stack_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["tf_outputs"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(Provision, __self__).__init__(
            'oci:FleetAppsManagement/provision:Provision',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            config_catalog_item_display_name: Optional[pulumi.Input[builtins.str]] = None,
            config_catalog_item_id: Optional[pulumi.Input[builtins.str]] = None,
            config_catalog_item_listing_id: Optional[pulumi.Input[builtins.str]] = None,
            config_catalog_item_listing_version: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            deployed_resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProvisionDeployedResourceArgs', 'ProvisionDeployedResourceArgsDict']]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            fleet_id: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            package_catalog_item_display_name: Optional[pulumi.Input[builtins.str]] = None,
            package_catalog_item_id: Optional[pulumi.Input[builtins.str]] = None,
            package_catalog_item_listing_id: Optional[pulumi.Input[builtins.str]] = None,
            package_catalog_item_listing_version: Optional[pulumi.Input[builtins.str]] = None,
            provision_description: Optional[pulumi.Input[builtins.str]] = None,
            rms_apply_job_id: Optional[pulumi.Input[builtins.str]] = None,
            stack_id: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tf_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProvisionTfOutputArgs', 'ProvisionTfOutputArgsDict']]]]] = None,
            tf_variable_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            tf_variable_current_user_id: Optional[pulumi.Input[builtins.str]] = None,
            tf_variable_region_id: Optional[pulumi.Input[builtins.str]] = None,
            tf_variable_tenancy_id: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'Provision':
        """
        Get an existing Provision resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the FamProvision in.
        :param pulumi.Input[builtins.str] config_catalog_item_display_name: A display Name of the Catalog Item in the Catalog.
        :param pulumi.Input[builtins.str] config_catalog_item_id: A [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Catalog Item to a file with key/value pairs to set up variables for createStack API.
        :param pulumi.Input[builtins.str] config_catalog_item_listing_id: A listing ID of the Catalog Item in the Catalog.
        :param pulumi.Input[builtins.str] config_catalog_item_listing_version: A listing version of the Catalog Item in the Catalog.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProvisionDeployedResourceArgs', 'ProvisionDeployedResourceArgsDict']]]] deployed_resources: The deployed resources and their summary
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] lifecycle_details: A message that describes the current state of the FamProvision in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[builtins.str] package_catalog_item_display_name: A display Name of the Catalog Item in the Catalog.
        :param pulumi.Input[builtins.str] package_catalog_item_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Catalog Item.
        :param pulumi.Input[builtins.str] package_catalog_item_listing_id: A listing ID of the Catalog Item in the Catalog.
        :param pulumi.Input[builtins.str] package_catalog_item_listing_version: A listing version of the Catalog Item in the Catalog.
        :param pulumi.Input[builtins.str] provision_description: (Updatable) A description of the provision.
        :param pulumi.Input[builtins.str] rms_apply_job_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the RMS APPLY Job.
        :param pulumi.Input[builtins.str] stack_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the RMS Stack.
        :param pulumi.Input[builtins.str] state: The current state of the FamProvision.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProvisionTfOutputArgs', 'ProvisionTfOutputArgsDict']]]] tf_outputs: Outputs from the pulumi up job
        :param pulumi.Input[builtins.str] tf_variable_compartment_id: An optional variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        :param pulumi.Input[builtins.str] tf_variable_current_user_id: An optional variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        :param pulumi.Input[builtins.str] tf_variable_region_id: A mandatory variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        :param pulumi.Input[builtins.str] tf_variable_tenancy_id: A mandatory variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_created: The date and time the FamProvision was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_updated: The date and time the FamProvision was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProvisionState.__new__(_ProvisionState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["config_catalog_item_display_name"] = config_catalog_item_display_name
        __props__.__dict__["config_catalog_item_id"] = config_catalog_item_id
        __props__.__dict__["config_catalog_item_listing_id"] = config_catalog_item_listing_id
        __props__.__dict__["config_catalog_item_listing_version"] = config_catalog_item_listing_version
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["deployed_resources"] = deployed_resources
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["fleet_id"] = fleet_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["package_catalog_item_display_name"] = package_catalog_item_display_name
        __props__.__dict__["package_catalog_item_id"] = package_catalog_item_id
        __props__.__dict__["package_catalog_item_listing_id"] = package_catalog_item_listing_id
        __props__.__dict__["package_catalog_item_listing_version"] = package_catalog_item_listing_version
        __props__.__dict__["provision_description"] = provision_description
        __props__.__dict__["rms_apply_job_id"] = rms_apply_job_id
        __props__.__dict__["stack_id"] = stack_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["tf_outputs"] = tf_outputs
        __props__.__dict__["tf_variable_compartment_id"] = tf_variable_compartment_id
        __props__.__dict__["tf_variable_current_user_id"] = tf_variable_current_user_id
        __props__.__dict__["tf_variable_region_id"] = tf_variable_region_id
        __props__.__dict__["tf_variable_tenancy_id"] = tf_variable_tenancy_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return Provision(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the FamProvision in.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configCatalogItemDisplayName")
    def config_catalog_item_display_name(self) -> pulumi.Output[builtins.str]:
        """
        A display Name of the Catalog Item in the Catalog.
        """
        return pulumi.get(self, "config_catalog_item_display_name")

    @property
    @pulumi.getter(name="configCatalogItemId")
    def config_catalog_item_id(self) -> pulumi.Output[builtins.str]:
        """
        A [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Catalog Item to a file with key/value pairs to set up variables for createStack API.
        """
        return pulumi.get(self, "config_catalog_item_id")

    @property
    @pulumi.getter(name="configCatalogItemListingId")
    def config_catalog_item_listing_id(self) -> pulumi.Output[builtins.str]:
        """
        A listing ID of the Catalog Item in the Catalog.
        """
        return pulumi.get(self, "config_catalog_item_listing_id")

    @property
    @pulumi.getter(name="configCatalogItemListingVersion")
    def config_catalog_item_listing_version(self) -> pulumi.Output[builtins.str]:
        """
        A listing version of the Catalog Item in the Catalog.
        """
        return pulumi.get(self, "config_catalog_item_listing_version")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deployedResources")
    def deployed_resources(self) -> pulumi.Output[Sequence['outputs.ProvisionDeployedResource']]:
        """
        The deployed resources and their summary
        """
        return pulumi.get(self, "deployed_resources")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
        """
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        A message that describes the current state of the FamProvision in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="packageCatalogItemDisplayName")
    def package_catalog_item_display_name(self) -> pulumi.Output[builtins.str]:
        """
        A display Name of the Catalog Item in the Catalog.
        """
        return pulumi.get(self, "package_catalog_item_display_name")

    @property
    @pulumi.getter(name="packageCatalogItemId")
    def package_catalog_item_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Catalog Item.
        """
        return pulumi.get(self, "package_catalog_item_id")

    @property
    @pulumi.getter(name="packageCatalogItemListingId")
    def package_catalog_item_listing_id(self) -> pulumi.Output[builtins.str]:
        """
        A listing ID of the Catalog Item in the Catalog.
        """
        return pulumi.get(self, "package_catalog_item_listing_id")

    @property
    @pulumi.getter(name="packageCatalogItemListingVersion")
    def package_catalog_item_listing_version(self) -> pulumi.Output[builtins.str]:
        """
        A listing version of the Catalog Item in the Catalog.
        """
        return pulumi.get(self, "package_catalog_item_listing_version")

    @property
    @pulumi.getter(name="provisionDescription")
    def provision_description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A description of the provision.
        """
        return pulumi.get(self, "provision_description")

    @property
    @pulumi.getter(name="rmsApplyJobId")
    def rms_apply_job_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the RMS APPLY Job.
        """
        return pulumi.get(self, "rms_apply_job_id")

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the RMS Stack.
        """
        return pulumi.get(self, "stack_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the FamProvision.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="tfOutputs")
    def tf_outputs(self) -> pulumi.Output[Sequence['outputs.ProvisionTfOutput']]:
        """
        Outputs from the pulumi up job
        """
        return pulumi.get(self, "tf_outputs")

    @property
    @pulumi.getter(name="tfVariableCompartmentId")
    def tf_variable_compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        An optional variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        """
        return pulumi.get(self, "tf_variable_compartment_id")

    @property
    @pulumi.getter(name="tfVariableCurrentUserId")
    def tf_variable_current_user_id(self) -> pulumi.Output[builtins.str]:
        """
        An optional variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        """
        return pulumi.get(self, "tf_variable_current_user_id")

    @property
    @pulumi.getter(name="tfVariableRegionId")
    def tf_variable_region_id(self) -> pulumi.Output[builtins.str]:
        """
        A mandatory variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.
        """
        return pulumi.get(self, "tf_variable_region_id")

    @property
    @pulumi.getter(name="tfVariableTenancyId")
    def tf_variable_tenancy_id(self) -> pulumi.Output[builtins.str]:
        """
        A mandatory variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tf_variable_tenancy_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the FamProvision was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the FamProvision was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

