# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFsuCollectionsResult',
    'AwaitableGetFsuCollectionsResult',
    'get_fsu_collections',
    'get_fsu_collections_output',
]

@pulumi.output_type
class GetFsuCollectionsResult:
    """
    A collection of values returned by getFsuCollections.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, fsu_collection_summary_collections=None, id=None, state=None, type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fsu_collection_summary_collections and not isinstance(fsu_collection_summary_collections, list):
            raise TypeError("Expected argument 'fsu_collection_summary_collections' to be a list")
        pulumi.set(__self__, "fsu_collection_summary_collections", fsu_collection_summary_collections)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Exadata Fleet Update Collection resource display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFsuCollectionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fsuCollectionSummaryCollections")
    def fsu_collection_summary_collections(self) -> Sequence['outputs.GetFsuCollectionsFsuCollectionSummaryCollectionResult']:
        """
        The list of fsu_collection_summary_collection.
        """
        return pulumi.get(self, "fsu_collection_summary_collections")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the Exadata Fleet Update Collection.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        Exadata Fleet Update Collection type.
        """
        return pulumi.get(self, "type")


class AwaitableGetFsuCollectionsResult(GetFsuCollectionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFsuCollectionsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            fsu_collection_summary_collections=self.fsu_collection_summary_collections,
            id=self.id,
            state=self.state,
            type=self.type)


def get_fsu_collections(compartment_id: Optional[builtins.str] = None,
                        display_name: Optional[builtins.str] = None,
                        filters: Optional[Sequence[Union['GetFsuCollectionsFilterArgs', 'GetFsuCollectionsFilterArgsDict']]] = None,
                        state: Optional[builtins.str] = None,
                        type: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFsuCollectionsResult:
    """
    This data source provides the list of Fsu Collections in Oracle Cloud Infrastructure Fleet Software Update service.

    Gets a list of all Exadata Fleet Update Collections in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fsu_collections = oci.FleetSoftwareUpdate.get_fsu_collections(compartment_id=compartment_id,
        display_name=fsu_collection_display_name,
        state=fsu_collection_state,
        type=fsu_collection_type)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    :param builtins.str type: A filter to return only resources whose type matches the given type.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetSoftwareUpdate/getFsuCollections:getFsuCollections', __args__, opts=opts, typ=GetFsuCollectionsResult).value

    return AwaitableGetFsuCollectionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        fsu_collection_summary_collections=pulumi.get(__ret__, 'fsu_collection_summary_collections'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        type=pulumi.get(__ret__, 'type'))
def get_fsu_collections_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                               display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFsuCollectionsFilterArgs', 'GetFsuCollectionsFilterArgsDict']]]]] = None,
                               state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFsuCollectionsResult]:
    """
    This data source provides the list of Fsu Collections in Oracle Cloud Infrastructure Fleet Software Update service.

    Gets a list of all Exadata Fleet Update Collections in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fsu_collections = oci.FleetSoftwareUpdate.get_fsu_collections(compartment_id=compartment_id,
        display_name=fsu_collection_display_name,
        state=fsu_collection_state,
        type=fsu_collection_type)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    :param builtins.str type: A filter to return only resources whose type matches the given type.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetSoftwareUpdate/getFsuCollections:getFsuCollections', __args__, opts=opts, typ=GetFsuCollectionsResult)
    return __ret__.apply(lambda __response__: GetFsuCollectionsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        fsu_collection_summary_collections=pulumi.get(__response__, 'fsu_collection_summary_collections'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        type=pulumi.get(__response__, 'type')))
