# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'FsuCollectionActiveFsuCycle',
    'FsuCollectionFleetDiscovery',
    'FsuCollectionFleetDiscoveryFilter',
    'FsuCollectionFleetDiscoveryFilterTag',
    'FsuCycleApplyActionSchedule',
    'FsuCycleBatchingStrategy',
    'FsuCycleDiagnosticsCollection',
    'FsuCycleGoalVersionDetails',
    'FsuCycleNextActionToExecute',
    'FsuCycleStageActionSchedule',
    'FsuCycleUpgradeDetails',
    'GetFsuCollectionActiveFsuCycleResult',
    'GetFsuCollectionFleetDiscoveryResult',
    'GetFsuCollectionFleetDiscoveryFilterResult',
    'GetFsuCollectionFleetDiscoveryFilterTagResult',
    'GetFsuCollectionsFilterResult',
    'GetFsuCollectionsFsuCollectionSummaryCollectionResult',
    'GetFsuCollectionsFsuCollectionSummaryCollectionItemResult',
    'GetFsuCollectionsFsuCollectionSummaryCollectionItemActiveFsuCycleResult',
    'GetFsuCollectionsFsuCollectionSummaryCollectionItemFleetDiscoveryResult',
    'GetFsuCollectionsFsuCollectionSummaryCollectionItemFleetDiscoveryFilterResult',
    'GetFsuCollectionsFsuCollectionSummaryCollectionItemFleetDiscoveryFilterTagResult',
    'GetFsuCycleApplyActionScheduleResult',
    'GetFsuCycleBatchingStrategyResult',
    'GetFsuCycleDiagnosticsCollectionResult',
    'GetFsuCycleGoalVersionDetailResult',
    'GetFsuCycleNextActionToExecuteResult',
    'GetFsuCycleStageActionScheduleResult',
    'GetFsuCycleUpgradeDetailResult',
    'GetFsuCyclesFilterResult',
    'GetFsuCyclesFsuCycleSummaryCollectionResult',
    'GetFsuCyclesFsuCycleSummaryCollectionItemResult',
    'GetFsuCyclesFsuCycleSummaryCollectionItemApplyActionScheduleResult',
    'GetFsuCyclesFsuCycleSummaryCollectionItemBatchingStrategyResult',
    'GetFsuCyclesFsuCycleSummaryCollectionItemDiagnosticsCollectionResult',
    'GetFsuCyclesFsuCycleSummaryCollectionItemGoalVersionDetailResult',
    'GetFsuCyclesFsuCycleSummaryCollectionItemNextActionToExecuteResult',
    'GetFsuCyclesFsuCycleSummaryCollectionItemStageActionScheduleResult',
    'GetFsuCyclesFsuCycleSummaryCollectionItemUpgradeDetailResult',
]

@pulumi.output_type
class FsuCollectionActiveFsuCycle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FsuCollectionActiveFsuCycle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FsuCollectionActiveFsuCycle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FsuCollectionActiveFsuCycle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None):
        """
        :param builtins.str display_name: (Updatable) Exadata Fleet Update Collection Identifier.
        :param builtins.str id: OCID identifier for the Exadata Fleet Update Collection.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        (Updatable) Exadata Fleet Update Collection Identifier.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        OCID identifier for the Exadata Fleet Update Collection.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class FsuCollectionFleetDiscovery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsuDiscoveryId":
            suggest = "fsu_discovery_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FsuCollectionFleetDiscovery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FsuCollectionFleetDiscovery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FsuCollectionFleetDiscovery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 strategy: builtins.str,
                 filters: Optional[Sequence['outputs.FsuCollectionFleetDiscoveryFilter']] = None,
                 fsu_discovery_id: Optional[builtins.str] = None,
                 query: Optional[builtins.str] = None,
                 targets: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str strategy: Possible fleet discovery strategies.
        :param Sequence['FsuCollectionFleetDiscoveryFilterArgs'] filters: Filters to perform the target discovery.
        :param builtins.str fsu_discovery_id: OCIDs of Fleet Software Update Discovery.
        :param builtins.str query: Oracle Cloud Infrastructure Search Service query string.
        :param Sequence[builtins.str] targets: OCIDs of target resources to include. For EXACC service type Collections only VMClusters are allowed. For EXACS service type Collections only CloudVMClusters are allowed.
        """
        pulumi.set(__self__, "strategy", strategy)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if fsu_discovery_id is not None:
            pulumi.set(__self__, "fsu_discovery_id", fsu_discovery_id)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter
    def strategy(self) -> builtins.str:
        """
        Possible fleet discovery strategies.
        """
        return pulumi.get(self, "strategy")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.FsuCollectionFleetDiscoveryFilter']]:
        """
        Filters to perform the target discovery.
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fsuDiscoveryId")
    def fsu_discovery_id(self) -> Optional[builtins.str]:
        """
        OCIDs of Fleet Software Update Discovery.
        """
        return pulumi.get(self, "fsu_discovery_id")

    @property
    @pulumi.getter
    def query(self) -> Optional[builtins.str]:
        """
        Oracle Cloud Infrastructure Search Service query string.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter
    def targets(self) -> Optional[Sequence[builtins.str]]:
        """
        OCIDs of target resources to include. For EXACC service type Collections only VMClusters are allowed. For EXACS service type Collections only CloudVMClusters are allowed.
        """
        return pulumi.get(self, "targets")


@pulumi.output_type
class FsuCollectionFleetDiscoveryFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityType":
            suggest = "entity_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FsuCollectionFleetDiscoveryFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FsuCollectionFleetDiscoveryFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FsuCollectionFleetDiscoveryFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 entity_type: Optional[builtins.str] = None,
                 identifiers: Optional[Sequence[builtins.str]] = None,
                 mode: Optional[builtins.str] = None,
                 names: Optional[Sequence[builtins.str]] = None,
                 operator: Optional[builtins.str] = None,
                 tags: Optional[Sequence['outputs.FsuCollectionFleetDiscoveryFilterTag']] = None,
                 versions: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str type: Type of filters supported for Database targets discovery.
        :param builtins.str entity_type: Type of resource to match in the discovery.
        :param Sequence[builtins.str] identifiers: Related resource Ids to include in the discovery.  All must match the specified entityType.
        :param builtins.str mode: INCLUDE or EXCLUDE the filter results in the discovery for DB targets. Supported for 'FSUCOLLECTION' RESOURCE_ID filter only.
        :param Sequence[builtins.str] names: List of Database unique names to include in the discovery.
        :param builtins.str operator: Type of join for each element in this filter.
        :param Sequence['FsuCollectionFleetDiscoveryFilterTagArgs'] tags: Freeform tags to include in the discovery.
        :param Sequence[builtins.str] versions: List of Versions strings to include in the discovery.
        """
        pulumi.set(__self__, "type", type)
        if entity_type is not None:
            pulumi.set(__self__, "entity_type", entity_type)
        if identifiers is not None:
            pulumi.set(__self__, "identifiers", identifiers)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of filters supported for Database targets discovery.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> Optional[builtins.str]:
        """
        Type of resource to match in the discovery.
        """
        return pulumi.get(self, "entity_type")

    @property
    @pulumi.getter
    def identifiers(self) -> Optional[Sequence[builtins.str]]:
        """
        Related resource Ids to include in the discovery.  All must match the specified entityType.
        """
        return pulumi.get(self, "identifiers")

    @property
    @pulumi.getter
    def mode(self) -> Optional[builtins.str]:
        """
        INCLUDE or EXCLUDE the filter results in the discovery for DB targets. Supported for 'FSUCOLLECTION' RESOURCE_ID filter only.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[builtins.str]]:
        """
        List of Database unique names to include in the discovery.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def operator(self) -> Optional[builtins.str]:
        """
        Type of join for each element in this filter.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.FsuCollectionFleetDiscoveryFilterTag']]:
        """
        Freeform tags to include in the discovery.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def versions(self) -> Optional[Sequence[builtins.str]]:
        """
        List of Versions strings to include in the discovery.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class FsuCollectionFleetDiscoveryFilterTag(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str,
                 namespace: Optional[builtins.str] = None):
        """
        :param builtins.str key: Freeform tag key.
        :param builtins.str value: Freeform tag value.
        :param builtins.str namespace: Defined tag namespace.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Freeform tag key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Freeform tag value.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        Defined tag namespace.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class FsuCycleApplyActionSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeToStart":
            suggest = "time_to_start"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FsuCycleApplyActionSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FsuCycleApplyActionSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FsuCycleApplyActionSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 time_to_start: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str time_to_start: The date and time the Exadata Fleet Update Action is expected to start. [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param builtins.str type: Type of scheduling strategy to use for Fleet Patching Update Action execution.
        """
        pulumi.set(__self__, "time_to_start", time_to_start)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="timeToStart")
    def time_to_start(self) -> builtins.str:
        """
        The date and time the Exadata Fleet Update Action is expected to start. [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_to_start")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of scheduling strategy to use for Fleet Patching Update Action execution.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FsuCycleBatchingStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isForceRolling":
            suggest = "is_force_rolling"
        elif key == "isWaitForBatchResume":
            suggest = "is_wait_for_batch_resume"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FsuCycleBatchingStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FsuCycleBatchingStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FsuCycleBatchingStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_force_rolling: Optional[builtins.bool] = None,
                 is_wait_for_batch_resume: Optional[builtins.bool] = None,
                 percentage: Optional[builtins.int] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.bool is_force_rolling: (Updatable) True to force rolling patching.
        :param builtins.bool is_wait_for_batch_resume: (Updatable) True to wait for customer to resume the Apply Action once the first half is done. False to automatically patch the second half.
        :param builtins.int percentage: (Updatable) Percentage of availability in the service during the Patch operation.
        :param builtins.str type: (Updatable) Supported batching strategies.
        """
        if is_force_rolling is not None:
            pulumi.set(__self__, "is_force_rolling", is_force_rolling)
        if is_wait_for_batch_resume is not None:
            pulumi.set(__self__, "is_wait_for_batch_resume", is_wait_for_batch_resume)
        if percentage is not None:
            pulumi.set(__self__, "percentage", percentage)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="isForceRolling")
    def is_force_rolling(self) -> Optional[builtins.bool]:
        """
        (Updatable) True to force rolling patching.
        """
        return pulumi.get(self, "is_force_rolling")

    @property
    @pulumi.getter(name="isWaitForBatchResume")
    def is_wait_for_batch_resume(self) -> Optional[builtins.bool]:
        """
        (Updatable) True to wait for customer to resume the Apply Action once the first half is done. False to automatically patch the second half.
        """
        return pulumi.get(self, "is_wait_for_batch_resume")

    @property
    @pulumi.getter
    def percentage(self) -> Optional[builtins.int]:
        """
        (Updatable) Percentage of availability in the service during the Patch operation.
        """
        return pulumi.get(self, "percentage")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        (Updatable) Supported batching strategies.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FsuCycleDiagnosticsCollection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logCollectionMode":
            suggest = "log_collection_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FsuCycleDiagnosticsCollection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FsuCycleDiagnosticsCollection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FsuCycleDiagnosticsCollection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_collection_mode: Optional[builtins.str] = None):
        """
        :param builtins.str log_collection_mode: (Updatable) Enable incident logs and trace collection.  Allow Oracle to collect incident logs and traces to enable fault diagnosis and issue resolution according to the selected mode.
        """
        if log_collection_mode is not None:
            pulumi.set(__self__, "log_collection_mode", log_collection_mode)

    @property
    @pulumi.getter(name="logCollectionMode")
    def log_collection_mode(self) -> Optional[builtins.str]:
        """
        (Updatable) Enable incident logs and trace collection.  Allow Oracle to collect incident logs and traces to enable fault diagnosis and issue resolution according to the selected mode.
        """
        return pulumi.get(self, "log_collection_mode")


@pulumi.output_type
class FsuCycleGoalVersionDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "homePolicy":
            suggest = "home_policy"
        elif key == "newHomePrefix":
            suggest = "new_home_prefix"
        elif key == "softwareImageId":
            suggest = "software_image_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FsuCycleGoalVersionDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FsuCycleGoalVersionDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FsuCycleGoalVersionDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 home_policy: Optional[builtins.str] = None,
                 new_home_prefix: Optional[builtins.str] = None,
                 software_image_id: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str type: (Updatable) Type of goal target version specified
        :param builtins.str home_policy: (Updatable) Goal home policy to use when Staging the Goal Version during patching. CREATE_NEW: Create a new DBHome (for Database Collections) for the specified image or version. USE_EXISTING: All database targets in the same VMCluster or CloudVmCluster will be moved to a shared database home.  If an existing home for the selected image or version is not found in the VM Cluster for a target database, then a new home will be created.  If more than one existing home for the selected image is found, then the home with the least number of databases will be used.  If multiple homes have the least number of databases, then a home will be selected at random.
        :param builtins.str new_home_prefix: (Updatable) Prefix name used for new DB home resources created as part of the Stage Action. Format: <specified_prefix>_<timestamp> If not specified, a default Oracle Cloud Infrastructure DB home resource will be generated for the new DB home resources created.
        :param builtins.str software_image_id: (Updatable) Target database software image OCID.
        :param builtins.str version: (Updatable) Target DB or GI version string for the Exadata Fleet Update Cycle.
        """
        pulumi.set(__self__, "type", type)
        if home_policy is not None:
            pulumi.set(__self__, "home_policy", home_policy)
        if new_home_prefix is not None:
            pulumi.set(__self__, "new_home_prefix", new_home_prefix)
        if software_image_id is not None:
            pulumi.set(__self__, "software_image_id", software_image_id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        (Updatable) Type of goal target version specified
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="homePolicy")
    def home_policy(self) -> Optional[builtins.str]:
        """
        (Updatable) Goal home policy to use when Staging the Goal Version during patching. CREATE_NEW: Create a new DBHome (for Database Collections) for the specified image or version. USE_EXISTING: All database targets in the same VMCluster or CloudVmCluster will be moved to a shared database home.  If an existing home for the selected image or version is not found in the VM Cluster for a target database, then a new home will be created.  If more than one existing home for the selected image is found, then the home with the least number of databases will be used.  If multiple homes have the least number of databases, then a home will be selected at random.
        """
        return pulumi.get(self, "home_policy")

    @property
    @pulumi.getter(name="newHomePrefix")
    def new_home_prefix(self) -> Optional[builtins.str]:
        """
        (Updatable) Prefix name used for new DB home resources created as part of the Stage Action. Format: <specified_prefix>_<timestamp> If not specified, a default Oracle Cloud Infrastructure DB home resource will be generated for the new DB home resources created.
        """
        return pulumi.get(self, "new_home_prefix")

    @property
    @pulumi.getter(name="softwareImageId")
    def software_image_id(self) -> Optional[builtins.str]:
        """
        (Updatable) Target database software image OCID.
        """
        return pulumi.get(self, "software_image_id")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        (Updatable) Target DB or GI version string for the Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class FsuCycleNextActionToExecute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeToStart":
            suggest = "time_to_start"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FsuCycleNextActionToExecute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FsuCycleNextActionToExecute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FsuCycleNextActionToExecute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 time_to_start: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str time_to_start: The date and time the Exadata Fleet Update Action is expected to start. [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param builtins.str type: (Updatable) Type of Exadata Fleet Update Cycle.
        """
        if time_to_start is not None:
            pulumi.set(__self__, "time_to_start", time_to_start)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="timeToStart")
    def time_to_start(self) -> Optional[builtins.str]:
        """
        The date and time the Exadata Fleet Update Action is expected to start. [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_to_start")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        (Updatable) Type of Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FsuCycleStageActionSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeToStart":
            suggest = "time_to_start"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FsuCycleStageActionSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FsuCycleStageActionSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FsuCycleStageActionSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 time_to_start: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str time_to_start: The date and time the Exadata Fleet Update Action is expected to start. [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param builtins.str type: Type of scheduling strategy to use for Fleet Patching Update Action execution.
        """
        pulumi.set(__self__, "time_to_start", time_to_start)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="timeToStart")
    def time_to_start(self) -> builtins.str:
        """
        The date and time the Exadata Fleet Update Action is expected to start. [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_to_start")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of scheduling strategy to use for Fleet Patching Update Action execution.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FsuCycleUpgradeDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "collectionType":
            suggest = "collection_type"
        elif key == "isRecompileInvalidObjects":
            suggest = "is_recompile_invalid_objects"
        elif key == "isTimeZoneUpgrade":
            suggest = "is_time_zone_upgrade"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FsuCycleUpgradeDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FsuCycleUpgradeDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FsuCycleUpgradeDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 collection_type: builtins.str,
                 is_recompile_invalid_objects: Optional[builtins.bool] = None,
                 is_time_zone_upgrade: Optional[builtins.bool] = None):
        """
        :param builtins.str collection_type: (Updatable) Type of Exadata Fleet Update collection being upgraded.
        :param builtins.bool is_recompile_invalid_objects: (Updatable) Enables or disables the recompilation of invalid objects.
        :param builtins.bool is_time_zone_upgrade: (Updatable) Enables or disables time zone upgrade. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "collection_type", collection_type)
        if is_recompile_invalid_objects is not None:
            pulumi.set(__self__, "is_recompile_invalid_objects", is_recompile_invalid_objects)
        if is_time_zone_upgrade is not None:
            pulumi.set(__self__, "is_time_zone_upgrade", is_time_zone_upgrade)

    @property
    @pulumi.getter(name="collectionType")
    def collection_type(self) -> builtins.str:
        """
        (Updatable) Type of Exadata Fleet Update collection being upgraded.
        """
        return pulumi.get(self, "collection_type")

    @property
    @pulumi.getter(name="isRecompileInvalidObjects")
    def is_recompile_invalid_objects(self) -> Optional[builtins.bool]:
        """
        (Updatable) Enables or disables the recompilation of invalid objects.
        """
        return pulumi.get(self, "is_recompile_invalid_objects")

    @property
    @pulumi.getter(name="isTimeZoneUpgrade")
    def is_time_zone_upgrade(self) -> Optional[builtins.bool]:
        """
        (Updatable) Enables or disables time zone upgrade. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "is_time_zone_upgrade")


@pulumi.output_type
class GetFsuCollectionActiveFsuCycleResult(dict):
    def __init__(__self__, *,
                 display_name: builtins.str,
                 id: builtins.str):
        """
        :param builtins.str display_name: Exadata Fleet Update Collection resource display name.
        :param builtins.str id: OCID identifier for the Exadata Fleet Update Collection.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Exadata Fleet Update Collection resource display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        OCID identifier for the Exadata Fleet Update Collection.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetFsuCollectionFleetDiscoveryResult(dict):
    def __init__(__self__, *,
                 filters: Sequence['outputs.GetFsuCollectionFleetDiscoveryFilterResult'],
                 fsu_discovery_id: builtins.str,
                 query: builtins.str,
                 strategy: builtins.str,
                 targets: Sequence[builtins.str]):
        """
        :param Sequence['GetFsuCollectionFleetDiscoveryFilterArgs'] filters: Filters to perform the target discovery.
        :param builtins.str fsu_discovery_id: OCIDs of Fleet Software Update Discovery.
        :param builtins.str query: Oracle Cloud Infrastructure Search Service query string.
        :param builtins.str strategy: Possible fleet discovery strategies.
        :param Sequence[builtins.str] targets: OCIDs of target resources to include. For EXACC service type Collections only VMClusters are allowed. For EXACS service type Collections only CloudVMClusters are allowed.
        """
        pulumi.set(__self__, "filters", filters)
        pulumi.set(__self__, "fsu_discovery_id", fsu_discovery_id)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "strategy", strategy)
        pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter
    def filters(self) -> Sequence['outputs.GetFsuCollectionFleetDiscoveryFilterResult']:
        """
        Filters to perform the target discovery.
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fsuDiscoveryId")
    def fsu_discovery_id(self) -> builtins.str:
        """
        OCIDs of Fleet Software Update Discovery.
        """
        return pulumi.get(self, "fsu_discovery_id")

    @property
    @pulumi.getter
    def query(self) -> builtins.str:
        """
        Oracle Cloud Infrastructure Search Service query string.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter
    def strategy(self) -> builtins.str:
        """
        Possible fleet discovery strategies.
        """
        return pulumi.get(self, "strategy")

    @property
    @pulumi.getter
    def targets(self) -> Sequence[builtins.str]:
        """
        OCIDs of target resources to include. For EXACC service type Collections only VMClusters are allowed. For EXACS service type Collections only CloudVMClusters are allowed.
        """
        return pulumi.get(self, "targets")


@pulumi.output_type
class GetFsuCollectionFleetDiscoveryFilterResult(dict):
    def __init__(__self__, *,
                 entity_type: builtins.str,
                 identifiers: Sequence[builtins.str],
                 mode: builtins.str,
                 names: Sequence[builtins.str],
                 operator: builtins.str,
                 tags: Sequence['outputs.GetFsuCollectionFleetDiscoveryFilterTagResult'],
                 type: builtins.str,
                 versions: Sequence[builtins.str]):
        """
        :param builtins.str entity_type: Type of resource to match in the discovery.
        :param Sequence[builtins.str] identifiers: Related resource Ids to include in the discovery.  All must match the specified entityType.
        :param builtins.str mode: INCLUDE or EXCLUDE the filter results in the discovery for DB targets. Supported for 'FSUCOLLECTION' RESOURCE_ID filter only.
        :param Sequence[builtins.str] names: List of Database unique names to include in the discovery.
        :param builtins.str operator: Type of join for each element in this filter.
        :param Sequence['GetFsuCollectionFleetDiscoveryFilterTagArgs'] tags: Freeform tags to include in the discovery.
        :param builtins.str type: Exadata Fleet Update Collection type.
        :param Sequence[builtins.str] versions: List of Versions strings to include in the discovery.
        """
        pulumi.set(__self__, "entity_type", entity_type)
        pulumi.set(__self__, "identifiers", identifiers)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "names", names)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "versions", versions)

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> builtins.str:
        """
        Type of resource to match in the discovery.
        """
        return pulumi.get(self, "entity_type")

    @property
    @pulumi.getter
    def identifiers(self) -> Sequence[builtins.str]:
        """
        Related resource Ids to include in the discovery.  All must match the specified entityType.
        """
        return pulumi.get(self, "identifiers")

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        INCLUDE or EXCLUDE the filter results in the discovery for DB targets. Supported for 'FSUCOLLECTION' RESOURCE_ID filter only.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def names(self) -> Sequence[builtins.str]:
        """
        List of Database unique names to include in the discovery.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def operator(self) -> builtins.str:
        """
        Type of join for each element in this filter.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetFsuCollectionFleetDiscoveryFilterTagResult']:
        """
        Freeform tags to include in the discovery.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Exadata Fleet Update Collection type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def versions(self) -> Sequence[builtins.str]:
        """
        List of Versions strings to include in the discovery.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class GetFsuCollectionFleetDiscoveryFilterTagResult(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 namespace: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: Freeform tag key.
        :param builtins.str namespace: Defined tag namespace.
        :param builtins.str value: Freeform tag value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Freeform tag key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        Defined tag namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Freeform tag value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetFsuCollectionsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFsuCollectionsFsuCollectionSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetFsuCollectionsFsuCollectionSummaryCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetFsuCollectionsFsuCollectionSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetFsuCollectionsFsuCollectionSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 active_fsu_cycles: Sequence['outputs.GetFsuCollectionsFsuCollectionSummaryCollectionItemActiveFsuCycleResult'],
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 display_name: builtins.str,
                 fleet_discoveries: Sequence['outputs.GetFsuCollectionsFsuCollectionSummaryCollectionItemFleetDiscoveryResult'],
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 last_completed_fsu_cycle_id: builtins.str,
                 lifecycle_details: builtins.str,
                 service_type: builtins.str,
                 source_major_version: builtins.str,
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 target_count: builtins.int,
                 time_created: builtins.str,
                 time_updated: builtins.str,
                 type: builtins.str):
        """
        :param Sequence['GetFsuCollectionsFsuCollectionSummaryCollectionItemActiveFsuCycleArgs'] active_fsu_cycles: Active Exadata Fleet Update Cycle resource for this Collection. Object would be null if there is no active Cycle.
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Sequence['GetFsuCollectionsFsuCollectionSummaryCollectionItemFleetDiscoveryArgs'] fleet_discoveries: Supported fleet discovery strategies for DB Collections. If specified on an Update Collection request, this will re-discover the targets of the Collection.
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str id: OCID identifier for the Exadata Fleet Update Collection.
        :param builtins.str last_completed_fsu_cycle_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of last completed FSU Cycle.
        :param builtins.str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param builtins.str service_type: Exadata service type for the target resource members.
        :param builtins.str source_major_version: Database Major Version of targets to be included in the Exadata Fleet Update Collection. https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/DbVersionSummary/ListDbVersions Only Database targets that match the version specified in this value would be added to the Exadata Fleet Update Collection.
        :param builtins.str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
        :param Mapping[str, builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.int target_count: Number of targets that are members of this Collection.
        :param builtins.str time_created: The time the Exadata Fleet Update Collection was created. An RFC3339 formatted datetime string.
        :param builtins.str time_updated: The time the Exadata Fleet Update Collection was updated. An RFC3339 formatted datetime string.
        :param builtins.str type: A filter to return only resources whose type matches the given type.
        """
        pulumi.set(__self__, "active_fsu_cycles", active_fsu_cycles)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "fleet_discoveries", fleet_discoveries)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_completed_fsu_cycle_id", last_completed_fsu_cycle_id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "service_type", service_type)
        pulumi.set(__self__, "source_major_version", source_major_version)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "target_count", target_count)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="activeFsuCycles")
    def active_fsu_cycles(self) -> Sequence['outputs.GetFsuCollectionsFsuCollectionSummaryCollectionItemActiveFsuCycleResult']:
        """
        Active Exadata Fleet Update Cycle resource for this Collection. Object would be null if there is no active Cycle.
        """
        return pulumi.get(self, "active_fsu_cycles")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fleetDiscoveries")
    def fleet_discoveries(self) -> Sequence['outputs.GetFsuCollectionsFsuCollectionSummaryCollectionItemFleetDiscoveryResult']:
        """
        Supported fleet discovery strategies for DB Collections. If specified on an Update Collection request, this will re-discover the targets of the Collection.
        """
        return pulumi.get(self, "fleet_discoveries")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        OCID identifier for the Exadata Fleet Update Collection.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastCompletedFsuCycleId")
    def last_completed_fsu_cycle_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of last completed FSU Cycle.
        """
        return pulumi.get(self, "last_completed_fsu_cycle_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> builtins.str:
        """
        Exadata service type for the target resource members.
        """
        return pulumi.get(self, "service_type")

    @property
    @pulumi.getter(name="sourceMajorVersion")
    def source_major_version(self) -> builtins.str:
        """
        Database Major Version of targets to be included in the Exadata Fleet Update Collection. https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/DbVersionSummary/ListDbVersions Only Database targets that match the version specified in this value would be added to the Exadata Fleet Update Collection.
        """
        return pulumi.get(self, "source_major_version")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to return only resources whose lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetCount")
    def target_count(self) -> builtins.int:
        """
        Number of targets that are members of this Collection.
        """
        return pulumi.get(self, "target_count")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the Exadata Fleet Update Collection was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the Exadata Fleet Update Collection was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        A filter to return only resources whose type matches the given type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetFsuCollectionsFsuCollectionSummaryCollectionItemActiveFsuCycleResult(dict):
    def __init__(__self__, *,
                 display_name: builtins.str,
                 id: builtins.str):
        """
        :param builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param builtins.str id: OCID identifier for the Exadata Fleet Update Collection.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        OCID identifier for the Exadata Fleet Update Collection.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetFsuCollectionsFsuCollectionSummaryCollectionItemFleetDiscoveryResult(dict):
    def __init__(__self__, *,
                 filters: Sequence['outputs.GetFsuCollectionsFsuCollectionSummaryCollectionItemFleetDiscoveryFilterResult'],
                 fsu_discovery_id: builtins.str,
                 query: builtins.str,
                 strategy: builtins.str,
                 targets: Sequence[builtins.str]):
        """
        :param Sequence['GetFsuCollectionsFsuCollectionSummaryCollectionItemFleetDiscoveryFilterArgs'] filters: Filters to perform the target discovery.
        :param builtins.str fsu_discovery_id: OCIDs of Fleet Software Update Discovery.
        :param builtins.str query: Oracle Cloud Infrastructure Search Service query string.
        :param builtins.str strategy: Possible fleet discovery strategies.
        :param Sequence[builtins.str] targets: OCIDs of target resources to include. For EXACC service type Collections only VMClusters are allowed. For EXACS service type Collections only CloudVMClusters are allowed.
        """
        pulumi.set(__self__, "filters", filters)
        pulumi.set(__self__, "fsu_discovery_id", fsu_discovery_id)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "strategy", strategy)
        pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter
    def filters(self) -> Sequence['outputs.GetFsuCollectionsFsuCollectionSummaryCollectionItemFleetDiscoveryFilterResult']:
        """
        Filters to perform the target discovery.
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fsuDiscoveryId")
    def fsu_discovery_id(self) -> builtins.str:
        """
        OCIDs of Fleet Software Update Discovery.
        """
        return pulumi.get(self, "fsu_discovery_id")

    @property
    @pulumi.getter
    def query(self) -> builtins.str:
        """
        Oracle Cloud Infrastructure Search Service query string.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter
    def strategy(self) -> builtins.str:
        """
        Possible fleet discovery strategies.
        """
        return pulumi.get(self, "strategy")

    @property
    @pulumi.getter
    def targets(self) -> Sequence[builtins.str]:
        """
        OCIDs of target resources to include. For EXACC service type Collections only VMClusters are allowed. For EXACS service type Collections only CloudVMClusters are allowed.
        """
        return pulumi.get(self, "targets")


@pulumi.output_type
class GetFsuCollectionsFsuCollectionSummaryCollectionItemFleetDiscoveryFilterResult(dict):
    def __init__(__self__, *,
                 entity_type: builtins.str,
                 identifiers: Sequence[builtins.str],
                 mode: builtins.str,
                 names: Sequence[builtins.str],
                 operator: builtins.str,
                 tags: Sequence['outputs.GetFsuCollectionsFsuCollectionSummaryCollectionItemFleetDiscoveryFilterTagResult'],
                 type: builtins.str,
                 versions: Sequence[builtins.str]):
        """
        :param builtins.str entity_type: Type of resource to match in the discovery.
        :param Sequence[builtins.str] identifiers: Related resource Ids to include in the discovery.  All must match the specified entityType.
        :param builtins.str mode: INCLUDE or EXCLUDE the filter results in the discovery for DB targets. Supported for 'FSUCOLLECTION' RESOURCE_ID filter only.
        :param Sequence[builtins.str] names: List of Database unique names to include in the discovery.
        :param builtins.str operator: Type of join for each element in this filter.
        :param Sequence['GetFsuCollectionsFsuCollectionSummaryCollectionItemFleetDiscoveryFilterTagArgs'] tags: Freeform tags to include in the discovery.
        :param builtins.str type: A filter to return only resources whose type matches the given type.
        :param Sequence[builtins.str] versions: List of Versions strings to include in the discovery.
        """
        pulumi.set(__self__, "entity_type", entity_type)
        pulumi.set(__self__, "identifiers", identifiers)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "names", names)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "versions", versions)

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> builtins.str:
        """
        Type of resource to match in the discovery.
        """
        return pulumi.get(self, "entity_type")

    @property
    @pulumi.getter
    def identifiers(self) -> Sequence[builtins.str]:
        """
        Related resource Ids to include in the discovery.  All must match the specified entityType.
        """
        return pulumi.get(self, "identifiers")

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        INCLUDE or EXCLUDE the filter results in the discovery for DB targets. Supported for 'FSUCOLLECTION' RESOURCE_ID filter only.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def names(self) -> Sequence[builtins.str]:
        """
        List of Database unique names to include in the discovery.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def operator(self) -> builtins.str:
        """
        Type of join for each element in this filter.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetFsuCollectionsFsuCollectionSummaryCollectionItemFleetDiscoveryFilterTagResult']:
        """
        Freeform tags to include in the discovery.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        A filter to return only resources whose type matches the given type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def versions(self) -> Sequence[builtins.str]:
        """
        List of Versions strings to include in the discovery.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class GetFsuCollectionsFsuCollectionSummaryCollectionItemFleetDiscoveryFilterTagResult(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 namespace: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: Freeform tag key.
        :param builtins.str namespace: Defined tag namespace.
        :param builtins.str value: Freeform tag value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Freeform tag key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        Defined tag namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Freeform tag value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetFsuCycleApplyActionScheduleResult(dict):
    def __init__(__self__, *,
                 time_to_start: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str time_to_start: The date and time the Exadata Fleet Update Action is expected to start. [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param builtins.str type: Type of Exadata Fleet Update Cycle.
        """
        pulumi.set(__self__, "time_to_start", time_to_start)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="timeToStart")
    def time_to_start(self) -> builtins.str:
        """
        The date and time the Exadata Fleet Update Action is expected to start. [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_to_start")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetFsuCycleBatchingStrategyResult(dict):
    def __init__(__self__, *,
                 is_force_rolling: builtins.bool,
                 is_wait_for_batch_resume: builtins.bool,
                 percentage: builtins.int,
                 type: builtins.str):
        """
        :param builtins.bool is_force_rolling: True to force rolling patching.
        :param builtins.bool is_wait_for_batch_resume: True to wait for customer to resume the Apply Action once the first half is done. False to automatically patch the second half.
        :param builtins.int percentage: Percentage of availability in the service during the Patch operation.
        :param builtins.str type: Type of Exadata Fleet Update Cycle.
        """
        pulumi.set(__self__, "is_force_rolling", is_force_rolling)
        pulumi.set(__self__, "is_wait_for_batch_resume", is_wait_for_batch_resume)
        pulumi.set(__self__, "percentage", percentage)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="isForceRolling")
    def is_force_rolling(self) -> builtins.bool:
        """
        True to force rolling patching.
        """
        return pulumi.get(self, "is_force_rolling")

    @property
    @pulumi.getter(name="isWaitForBatchResume")
    def is_wait_for_batch_resume(self) -> builtins.bool:
        """
        True to wait for customer to resume the Apply Action once the first half is done. False to automatically patch the second half.
        """
        return pulumi.get(self, "is_wait_for_batch_resume")

    @property
    @pulumi.getter
    def percentage(self) -> builtins.int:
        """
        Percentage of availability in the service during the Patch operation.
        """
        return pulumi.get(self, "percentage")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetFsuCycleDiagnosticsCollectionResult(dict):
    def __init__(__self__, *,
                 log_collection_mode: builtins.str):
        """
        :param builtins.str log_collection_mode: Enable incident logs and trace collection.  Allow Oracle to collect incident logs and traces to enable fault diagnosis and issue resolution according to the selected mode.
        """
        pulumi.set(__self__, "log_collection_mode", log_collection_mode)

    @property
    @pulumi.getter(name="logCollectionMode")
    def log_collection_mode(self) -> builtins.str:
        """
        Enable incident logs and trace collection.  Allow Oracle to collect incident logs and traces to enable fault diagnosis and issue resolution according to the selected mode.
        """
        return pulumi.get(self, "log_collection_mode")


@pulumi.output_type
class GetFsuCycleGoalVersionDetailResult(dict):
    def __init__(__self__, *,
                 home_policy: builtins.str,
                 new_home_prefix: builtins.str,
                 software_image_id: builtins.str,
                 type: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str home_policy: Goal home policy to use when Staging the Goal Version during patching. CREATE_NEW: Create a new DBHome (for Database Collections) for the specified image or version. USE_EXISTING: All database targets in the same VMCluster or CloudVmCluster will be moved to a shared database home.  If an existing home for the selected image or version is not found in the VM Cluster for a target database, then a new home will be created.  If more than one existing home for the selected image is found, then the home with the least number of databases will be used.  If multiple homes have the least number of databases, then a home will be selected at random.
        :param builtins.str new_home_prefix: Prefix name used for new DB home resources created as part of the Stage Action. Format: <specified_prefix>_<timestamp> If not specified, a default Oracle Cloud Infrastructure DB home resource will be generated for the new DB home resources created.
        :param builtins.str software_image_id: Target database software image OCID.
        :param builtins.str type: Type of Exadata Fleet Update Cycle.
        :param builtins.str version: Target DB or GI version string for the Exadata Fleet Update Cycle.
        """
        pulumi.set(__self__, "home_policy", home_policy)
        pulumi.set(__self__, "new_home_prefix", new_home_prefix)
        pulumi.set(__self__, "software_image_id", software_image_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="homePolicy")
    def home_policy(self) -> builtins.str:
        """
        Goal home policy to use when Staging the Goal Version during patching. CREATE_NEW: Create a new DBHome (for Database Collections) for the specified image or version. USE_EXISTING: All database targets in the same VMCluster or CloudVmCluster will be moved to a shared database home.  If an existing home for the selected image or version is not found in the VM Cluster for a target database, then a new home will be created.  If more than one existing home for the selected image is found, then the home with the least number of databases will be used.  If multiple homes have the least number of databases, then a home will be selected at random.
        """
        return pulumi.get(self, "home_policy")

    @property
    @pulumi.getter(name="newHomePrefix")
    def new_home_prefix(self) -> builtins.str:
        """
        Prefix name used for new DB home resources created as part of the Stage Action. Format: <specified_prefix>_<timestamp> If not specified, a default Oracle Cloud Infrastructure DB home resource will be generated for the new DB home resources created.
        """
        return pulumi.get(self, "new_home_prefix")

    @property
    @pulumi.getter(name="softwareImageId")
    def software_image_id(self) -> builtins.str:
        """
        Target database software image OCID.
        """
        return pulumi.get(self, "software_image_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Target DB or GI version string for the Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetFsuCycleNextActionToExecuteResult(dict):
    def __init__(__self__, *,
                 time_to_start: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str time_to_start: The date and time the Exadata Fleet Update Action is expected to start. [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param builtins.str type: Type of Exadata Fleet Update Cycle.
        """
        pulumi.set(__self__, "time_to_start", time_to_start)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="timeToStart")
    def time_to_start(self) -> builtins.str:
        """
        The date and time the Exadata Fleet Update Action is expected to start. [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_to_start")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetFsuCycleStageActionScheduleResult(dict):
    def __init__(__self__, *,
                 time_to_start: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str time_to_start: The date and time the Exadata Fleet Update Action is expected to start. [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param builtins.str type: Type of Exadata Fleet Update Cycle.
        """
        pulumi.set(__self__, "time_to_start", time_to_start)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="timeToStart")
    def time_to_start(self) -> builtins.str:
        """
        The date and time the Exadata Fleet Update Action is expected to start. [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_to_start")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetFsuCycleUpgradeDetailResult(dict):
    def __init__(__self__, *,
                 collection_type: builtins.str,
                 is_recompile_invalid_objects: builtins.bool,
                 is_time_zone_upgrade: builtins.bool):
        """
        :param builtins.str collection_type: Type of Exadata Fleet Update collection being upgraded.
        :param builtins.bool is_recompile_invalid_objects: Enables or disables the recompilation of invalid objects.
        :param builtins.bool is_time_zone_upgrade: Enables or disables time zone upgrade.
        """
        pulumi.set(__self__, "collection_type", collection_type)
        pulumi.set(__self__, "is_recompile_invalid_objects", is_recompile_invalid_objects)
        pulumi.set(__self__, "is_time_zone_upgrade", is_time_zone_upgrade)

    @property
    @pulumi.getter(name="collectionType")
    def collection_type(self) -> builtins.str:
        """
        Type of Exadata Fleet Update collection being upgraded.
        """
        return pulumi.get(self, "collection_type")

    @property
    @pulumi.getter(name="isRecompileInvalidObjects")
    def is_recompile_invalid_objects(self) -> builtins.bool:
        """
        Enables or disables the recompilation of invalid objects.
        """
        return pulumi.get(self, "is_recompile_invalid_objects")

    @property
    @pulumi.getter(name="isTimeZoneUpgrade")
    def is_time_zone_upgrade(self) -> builtins.bool:
        """
        Enables or disables time zone upgrade.
        """
        return pulumi.get(self, "is_time_zone_upgrade")


@pulumi.output_type
class GetFsuCyclesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFsuCyclesFsuCycleSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetFsuCyclesFsuCycleSummaryCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetFsuCyclesFsuCycleSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetFsuCyclesFsuCycleSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 apply_action_schedules: Sequence['outputs.GetFsuCyclesFsuCycleSummaryCollectionItemApplyActionScheduleResult'],
                 batching_strategies: Sequence['outputs.GetFsuCyclesFsuCycleSummaryCollectionItemBatchingStrategyResult'],
                 collection_type: builtins.str,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 diagnostics_collections: Sequence['outputs.GetFsuCyclesFsuCycleSummaryCollectionItemDiagnosticsCollectionResult'],
                 display_name: builtins.str,
                 executing_fsu_action_id: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 fsu_collection_id: builtins.str,
                 goal_version_details: Sequence['outputs.GetFsuCyclesFsuCycleSummaryCollectionItemGoalVersionDetailResult'],
                 id: builtins.str,
                 is_ignore_missing_patches: Sequence[builtins.str],
                 is_ignore_patches: builtins.bool,
                 is_keep_placement: builtins.bool,
                 last_completed_action: builtins.str,
                 last_completed_action_id: builtins.str,
                 lifecycle_details: builtins.str,
                 max_drain_timeout_in_seconds: builtins.int,
                 next_action_to_executes: Sequence['outputs.GetFsuCyclesFsuCycleSummaryCollectionItemNextActionToExecuteResult'],
                 rollback_cycle_state: builtins.str,
                 stage_action_schedules: Sequence['outputs.GetFsuCyclesFsuCycleSummaryCollectionItemStageActionScheduleResult'],
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str,
                 time_finished: builtins.str,
                 time_updated: builtins.str,
                 type: builtins.str,
                 upgrade_details: Sequence['outputs.GetFsuCyclesFsuCycleSummaryCollectionItemUpgradeDetailResult']):
        """
        :param Sequence['GetFsuCyclesFsuCycleSummaryCollectionItemApplyActionScheduleArgs'] apply_action_schedules: Scheduling related details for the Exadata Fleet Update Action. The specified time should not conflict with existing Exadata Infrastructure maintenance windows. Null scheduleDetails would execute the Exadata Fleet Update Action as soon as possible.
        :param Sequence['GetFsuCyclesFsuCycleSummaryCollectionItemBatchingStrategyArgs'] batching_strategies: Batching strategy details to use during PRECHECK and APPLY Cycle Actions.
        :param builtins.str collection_type: A filter to return only resources whose Collection type matches the given type.
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param Sequence['GetFsuCyclesFsuCycleSummaryCollectionItemDiagnosticsCollectionArgs'] diagnostics_collections: Details to configure diagnostics collection for targets affected by this Exadata Fleet Update Maintenance Cycle.
        :param builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param builtins.str executing_fsu_action_id: OCID identifier for the Action that is currently in execution, if applicable.
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str fsu_collection_id: A filter to return only resources whose fsuCollectionId matches the given fsuCollectionId.
        :param Sequence['GetFsuCyclesFsuCycleSummaryCollectionItemGoalVersionDetailArgs'] goal_version_details: Goal version or image details for the Exadata Fleet Update Cycle.
        :param builtins.str id: OCID identifier for the Exadata Fleet Update Cycle.
        :param Sequence[builtins.str] is_ignore_missing_patches: List of identifiers of patches to ignore.
        :param builtins.bool is_ignore_patches: Ignore patch conflicts or missing patches between the source and goal homes.
        :param builtins.bool is_keep_placement: Ensure that services of administrator-managed Oracle RAC or Oracle RAC One databases are running on the same instances before and after the move operation.
        :param builtins.str last_completed_action: The latest Action type that was completed in the Exadata Fleet Update Cycle. No value would indicate that the Cycle has not completed any Action yet.
        :param builtins.str last_completed_action_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the latest Action  in the Exadata Fleet Update Cycle.
        :param builtins.str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param builtins.int max_drain_timeout_in_seconds: Service drain timeout specified in seconds.
        :param Sequence['GetFsuCyclesFsuCycleSummaryCollectionItemNextActionToExecuteArgs'] next_action_to_executes: In this array all the possible actions will be listed. The first element is the suggested Action.
        :param builtins.str rollback_cycle_state: Current rollback cycle state if rollback maintenance cycle action has been attempted. No value would indicate that the Cycle has not run a rollback maintenance cycle action before.
        :param Sequence['GetFsuCyclesFsuCycleSummaryCollectionItemStageActionScheduleArgs'] stage_action_schedules: Scheduling related details for the Exadata Fleet Update Action. The specified time should not conflict with existing Exadata Infrastructure maintenance windows. Null scheduleDetails would execute the Exadata Fleet Update Action as soon as possible.
        :param builtins.str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
        :param Mapping[str, builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_created: The date and time the Exadata Fleet Update Cycle was created, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param builtins.str time_finished: The date and time the Exadata Fleet Update Cycle was finished, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param builtins.str time_updated: The date and time the Exadata Fleet Update Cycle was updated, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param builtins.str type: Type of Exadata Fleet Update Cycle.
        :param Sequence['GetFsuCyclesFsuCycleSummaryCollectionItemUpgradeDetailArgs'] upgrade_details: Details of supported upgrade options for DB or GI collection.
        """
        pulumi.set(__self__, "apply_action_schedules", apply_action_schedules)
        pulumi.set(__self__, "batching_strategies", batching_strategies)
        pulumi.set(__self__, "collection_type", collection_type)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "diagnostics_collections", diagnostics_collections)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "executing_fsu_action_id", executing_fsu_action_id)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "fsu_collection_id", fsu_collection_id)
        pulumi.set(__self__, "goal_version_details", goal_version_details)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_ignore_missing_patches", is_ignore_missing_patches)
        pulumi.set(__self__, "is_ignore_patches", is_ignore_patches)
        pulumi.set(__self__, "is_keep_placement", is_keep_placement)
        pulumi.set(__self__, "last_completed_action", last_completed_action)
        pulumi.set(__self__, "last_completed_action_id", last_completed_action_id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "max_drain_timeout_in_seconds", max_drain_timeout_in_seconds)
        pulumi.set(__self__, "next_action_to_executes", next_action_to_executes)
        pulumi.set(__self__, "rollback_cycle_state", rollback_cycle_state)
        pulumi.set(__self__, "stage_action_schedules", stage_action_schedules)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_finished", time_finished)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "upgrade_details", upgrade_details)

    @property
    @pulumi.getter(name="applyActionSchedules")
    def apply_action_schedules(self) -> Sequence['outputs.GetFsuCyclesFsuCycleSummaryCollectionItemApplyActionScheduleResult']:
        """
        Scheduling related details for the Exadata Fleet Update Action. The specified time should not conflict with existing Exadata Infrastructure maintenance windows. Null scheduleDetails would execute the Exadata Fleet Update Action as soon as possible.
        """
        return pulumi.get(self, "apply_action_schedules")

    @property
    @pulumi.getter(name="batchingStrategies")
    def batching_strategies(self) -> Sequence['outputs.GetFsuCyclesFsuCycleSummaryCollectionItemBatchingStrategyResult']:
        """
        Batching strategy details to use during PRECHECK and APPLY Cycle Actions.
        """
        return pulumi.get(self, "batching_strategies")

    @property
    @pulumi.getter(name="collectionType")
    def collection_type(self) -> builtins.str:
        """
        A filter to return only resources whose Collection type matches the given type.
        """
        return pulumi.get(self, "collection_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="diagnosticsCollections")
    def diagnostics_collections(self) -> Sequence['outputs.GetFsuCyclesFsuCycleSummaryCollectionItemDiagnosticsCollectionResult']:
        """
        Details to configure diagnostics collection for targets affected by this Exadata Fleet Update Maintenance Cycle.
        """
        return pulumi.get(self, "diagnostics_collections")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="executingFsuActionId")
    def executing_fsu_action_id(self) -> builtins.str:
        """
        OCID identifier for the Action that is currently in execution, if applicable.
        """
        return pulumi.get(self, "executing_fsu_action_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="fsuCollectionId")
    def fsu_collection_id(self) -> builtins.str:
        """
        A filter to return only resources whose fsuCollectionId matches the given fsuCollectionId.
        """
        return pulumi.get(self, "fsu_collection_id")

    @property
    @pulumi.getter(name="goalVersionDetails")
    def goal_version_details(self) -> Sequence['outputs.GetFsuCyclesFsuCycleSummaryCollectionItemGoalVersionDetailResult']:
        """
        Goal version or image details for the Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "goal_version_details")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        OCID identifier for the Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isIgnoreMissingPatches")
    def is_ignore_missing_patches(self) -> Sequence[builtins.str]:
        """
        List of identifiers of patches to ignore.
        """
        return pulumi.get(self, "is_ignore_missing_patches")

    @property
    @pulumi.getter(name="isIgnorePatches")
    def is_ignore_patches(self) -> builtins.bool:
        """
        Ignore patch conflicts or missing patches between the source and goal homes.
        """
        return pulumi.get(self, "is_ignore_patches")

    @property
    @pulumi.getter(name="isKeepPlacement")
    def is_keep_placement(self) -> builtins.bool:
        """
        Ensure that services of administrator-managed Oracle RAC or Oracle RAC One databases are running on the same instances before and after the move operation.
        """
        return pulumi.get(self, "is_keep_placement")

    @property
    @pulumi.getter(name="lastCompletedAction")
    def last_completed_action(self) -> builtins.str:
        """
        The latest Action type that was completed in the Exadata Fleet Update Cycle. No value would indicate that the Cycle has not completed any Action yet.
        """
        return pulumi.get(self, "last_completed_action")

    @property
    @pulumi.getter(name="lastCompletedActionId")
    def last_completed_action_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the latest Action  in the Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "last_completed_action_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maxDrainTimeoutInSeconds")
    def max_drain_timeout_in_seconds(self) -> builtins.int:
        """
        Service drain timeout specified in seconds.
        """
        return pulumi.get(self, "max_drain_timeout_in_seconds")

    @property
    @pulumi.getter(name="nextActionToExecutes")
    def next_action_to_executes(self) -> Sequence['outputs.GetFsuCyclesFsuCycleSummaryCollectionItemNextActionToExecuteResult']:
        """
        In this array all the possible actions will be listed. The first element is the suggested Action.
        """
        return pulumi.get(self, "next_action_to_executes")

    @property
    @pulumi.getter(name="rollbackCycleState")
    def rollback_cycle_state(self) -> builtins.str:
        """
        Current rollback cycle state if rollback maintenance cycle action has been attempted. No value would indicate that the Cycle has not run a rollback maintenance cycle action before.
        """
        return pulumi.get(self, "rollback_cycle_state")

    @property
    @pulumi.getter(name="stageActionSchedules")
    def stage_action_schedules(self) -> Sequence['outputs.GetFsuCyclesFsuCycleSummaryCollectionItemStageActionScheduleResult']:
        """
        Scheduling related details for the Exadata Fleet Update Action. The specified time should not conflict with existing Exadata Infrastructure maintenance windows. Null scheduleDetails would execute the Exadata Fleet Update Action as soon as possible.
        """
        return pulumi.get(self, "stage_action_schedules")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to return only resources whose lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the Exadata Fleet Update Cycle was created, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> builtins.str:
        """
        The date and time the Exadata Fleet Update Cycle was finished, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the Exadata Fleet Update Cycle was updated, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="upgradeDetails")
    def upgrade_details(self) -> Sequence['outputs.GetFsuCyclesFsuCycleSummaryCollectionItemUpgradeDetailResult']:
        """
        Details of supported upgrade options for DB or GI collection.
        """
        return pulumi.get(self, "upgrade_details")


@pulumi.output_type
class GetFsuCyclesFsuCycleSummaryCollectionItemApplyActionScheduleResult(dict):
    def __init__(__self__, *,
                 time_to_start: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str time_to_start: The date and time the Exadata Fleet Update Action is expected to start. [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param builtins.str type: Type of Exadata Fleet Update Cycle.
        """
        pulumi.set(__self__, "time_to_start", time_to_start)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="timeToStart")
    def time_to_start(self) -> builtins.str:
        """
        The date and time the Exadata Fleet Update Action is expected to start. [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_to_start")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetFsuCyclesFsuCycleSummaryCollectionItemBatchingStrategyResult(dict):
    def __init__(__self__, *,
                 is_force_rolling: builtins.bool,
                 is_wait_for_batch_resume: builtins.bool,
                 percentage: builtins.int,
                 type: builtins.str):
        """
        :param builtins.bool is_force_rolling: True to force rolling patching.
        :param builtins.bool is_wait_for_batch_resume: True to wait for customer to resume the Apply Action once the first half is done. False to automatically patch the second half.
        :param builtins.int percentage: Percentage of availability in the service during the Patch operation.
        :param builtins.str type: Type of Exadata Fleet Update Cycle.
        """
        pulumi.set(__self__, "is_force_rolling", is_force_rolling)
        pulumi.set(__self__, "is_wait_for_batch_resume", is_wait_for_batch_resume)
        pulumi.set(__self__, "percentage", percentage)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="isForceRolling")
    def is_force_rolling(self) -> builtins.bool:
        """
        True to force rolling patching.
        """
        return pulumi.get(self, "is_force_rolling")

    @property
    @pulumi.getter(name="isWaitForBatchResume")
    def is_wait_for_batch_resume(self) -> builtins.bool:
        """
        True to wait for customer to resume the Apply Action once the first half is done. False to automatically patch the second half.
        """
        return pulumi.get(self, "is_wait_for_batch_resume")

    @property
    @pulumi.getter
    def percentage(self) -> builtins.int:
        """
        Percentage of availability in the service during the Patch operation.
        """
        return pulumi.get(self, "percentage")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetFsuCyclesFsuCycleSummaryCollectionItemDiagnosticsCollectionResult(dict):
    def __init__(__self__, *,
                 log_collection_mode: builtins.str):
        """
        :param builtins.str log_collection_mode: Enable incident logs and trace collection.  Allow Oracle to collect incident logs and traces to enable fault diagnosis and issue resolution according to the selected mode.
        """
        pulumi.set(__self__, "log_collection_mode", log_collection_mode)

    @property
    @pulumi.getter(name="logCollectionMode")
    def log_collection_mode(self) -> builtins.str:
        """
        Enable incident logs and trace collection.  Allow Oracle to collect incident logs and traces to enable fault diagnosis and issue resolution according to the selected mode.
        """
        return pulumi.get(self, "log_collection_mode")


@pulumi.output_type
class GetFsuCyclesFsuCycleSummaryCollectionItemGoalVersionDetailResult(dict):
    def __init__(__self__, *,
                 home_policy: builtins.str,
                 new_home_prefix: builtins.str,
                 software_image_id: builtins.str,
                 type: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str home_policy: Goal home policy to use when Staging the Goal Version during patching. CREATE_NEW: Create a new DBHome (for Database Collections) for the specified image or version. USE_EXISTING: All database targets in the same VMCluster or CloudVmCluster will be moved to a shared database home.  If an existing home for the selected image or version is not found in the VM Cluster for a target database, then a new home will be created.  If more than one existing home for the selected image is found, then the home with the least number of databases will be used.  If multiple homes have the least number of databases, then a home will be selected at random.
        :param builtins.str new_home_prefix: Prefix name used for new DB home resources created as part of the Stage Action. Format: <specified_prefix>_<timestamp> If not specified, a default Oracle Cloud Infrastructure DB home resource will be generated for the new DB home resources created.
        :param builtins.str software_image_id: Target database software image OCID.
        :param builtins.str type: Type of Exadata Fleet Update Cycle.
        :param builtins.str version: Target DB or GI version string for the Exadata Fleet Update Cycle.
        """
        pulumi.set(__self__, "home_policy", home_policy)
        pulumi.set(__self__, "new_home_prefix", new_home_prefix)
        pulumi.set(__self__, "software_image_id", software_image_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="homePolicy")
    def home_policy(self) -> builtins.str:
        """
        Goal home policy to use when Staging the Goal Version during patching. CREATE_NEW: Create a new DBHome (for Database Collections) for the specified image or version. USE_EXISTING: All database targets in the same VMCluster or CloudVmCluster will be moved to a shared database home.  If an existing home for the selected image or version is not found in the VM Cluster for a target database, then a new home will be created.  If more than one existing home for the selected image is found, then the home with the least number of databases will be used.  If multiple homes have the least number of databases, then a home will be selected at random.
        """
        return pulumi.get(self, "home_policy")

    @property
    @pulumi.getter(name="newHomePrefix")
    def new_home_prefix(self) -> builtins.str:
        """
        Prefix name used for new DB home resources created as part of the Stage Action. Format: <specified_prefix>_<timestamp> If not specified, a default Oracle Cloud Infrastructure DB home resource will be generated for the new DB home resources created.
        """
        return pulumi.get(self, "new_home_prefix")

    @property
    @pulumi.getter(name="softwareImageId")
    def software_image_id(self) -> builtins.str:
        """
        Target database software image OCID.
        """
        return pulumi.get(self, "software_image_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Target DB or GI version string for the Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetFsuCyclesFsuCycleSummaryCollectionItemNextActionToExecuteResult(dict):
    def __init__(__self__, *,
                 time_to_start: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str time_to_start: The date and time the Exadata Fleet Update Action is expected to start. [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param builtins.str type: Type of Exadata Fleet Update Cycle.
        """
        pulumi.set(__self__, "time_to_start", time_to_start)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="timeToStart")
    def time_to_start(self) -> builtins.str:
        """
        The date and time the Exadata Fleet Update Action is expected to start. [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_to_start")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetFsuCyclesFsuCycleSummaryCollectionItemStageActionScheduleResult(dict):
    def __init__(__self__, *,
                 time_to_start: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str time_to_start: The date and time the Exadata Fleet Update Action is expected to start. [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param builtins.str type: Type of Exadata Fleet Update Cycle.
        """
        pulumi.set(__self__, "time_to_start", time_to_start)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="timeToStart")
    def time_to_start(self) -> builtins.str:
        """
        The date and time the Exadata Fleet Update Action is expected to start. [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_to_start")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of Exadata Fleet Update Cycle.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetFsuCyclesFsuCycleSummaryCollectionItemUpgradeDetailResult(dict):
    def __init__(__self__, *,
                 collection_type: builtins.str,
                 is_recompile_invalid_objects: builtins.bool,
                 is_time_zone_upgrade: builtins.bool):
        """
        :param builtins.str collection_type: A filter to return only resources whose Collection type matches the given type.
        :param builtins.bool is_recompile_invalid_objects: Enables or disables the recompilation of invalid objects.
        :param builtins.bool is_time_zone_upgrade: Enables or disables time zone upgrade.
        """
        pulumi.set(__self__, "collection_type", collection_type)
        pulumi.set(__self__, "is_recompile_invalid_objects", is_recompile_invalid_objects)
        pulumi.set(__self__, "is_time_zone_upgrade", is_time_zone_upgrade)

    @property
    @pulumi.getter(name="collectionType")
    def collection_type(self) -> builtins.str:
        """
        A filter to return only resources whose Collection type matches the given type.
        """
        return pulumi.get(self, "collection_type")

    @property
    @pulumi.getter(name="isRecompileInvalidObjects")
    def is_recompile_invalid_objects(self) -> builtins.bool:
        """
        Enables or disables the recompilation of invalid objects.
        """
        return pulumi.get(self, "is_recompile_invalid_objects")

    @property
    @pulumi.getter(name="isTimeZoneUpgrade")
    def is_time_zone_upgrade(self) -> builtins.bool:
        """
        Enables or disables time zone upgrade.
        """
        return pulumi.get(self, "is_time_zone_upgrade")


