# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFunctionsResult',
    'AwaitableGetFunctionsResult',
    'get_functions',
    'get_functions_output',
]

@pulumi.output_type
class GetFunctionsResult:
    """
    A collection of values returned by getFunctions.
    """
    def __init__(__self__, application_id=None, display_name=None, filters=None, functions=None, id=None, state=None):
        if application_id and not isinstance(application_id, str):
            raise TypeError("Expected argument 'application_id' to be a str")
        pulumi.set(__self__, "application_id", application_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if functions and not isinstance(functions, list):
            raise TypeError("Expected argument 'functions' to be a list")
        pulumi.set(__self__, "functions", functions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> builtins.str:
        """
        The OCID of the application the function belongs to.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        The display name of the function. The display name is unique within the application containing the function.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFunctionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def functions(self) -> Sequence['outputs.GetFunctionsFunctionResult']:
        """
        The list of functions.
        """
        return pulumi.get(self, "functions")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the function.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the function.
        """
        return pulumi.get(self, "state")


class AwaitableGetFunctionsResult(GetFunctionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFunctionsResult(
            application_id=self.application_id,
            display_name=self.display_name,
            filters=self.filters,
            functions=self.functions,
            id=self.id,
            state=self.state)


def get_functions(application_id: Optional[builtins.str] = None,
                  display_name: Optional[builtins.str] = None,
                  filters: Optional[Sequence[Union['GetFunctionsFilterArgs', 'GetFunctionsFilterArgsDict']]] = None,
                  id: Optional[builtins.str] = None,
                  state: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFunctionsResult:
    """
    This data source provides the list of Functions in Oracle Cloud Infrastructure Functions service.

    Lists functions for an application.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_functions = oci.Functions.get_functions(application_id=test_application["id"],
        display_name=function_display_name,
        id=function_id,
        state=function_state)
    ```


    :param builtins.str application_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the application to which this function belongs.
    :param builtins.str display_name: A filter to return only functions with display names that match the display name string. Matching is exact.
    :param builtins.str id: A filter to return only functions with the specified OCID.
    :param builtins.str state: A filter to return only functions that match the lifecycle state in this parameter. Example: `Creating`
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Functions/getFunctions:getFunctions', __args__, opts=opts, typ=GetFunctionsResult).value

    return AwaitableGetFunctionsResult(
        application_id=pulumi.get(__ret__, 'application_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        functions=pulumi.get(__ret__, 'functions'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_functions_output(application_id: Optional[pulumi.Input[builtins.str]] = None,
                         display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFunctionsFilterArgs', 'GetFunctionsFilterArgsDict']]]]] = None,
                         id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFunctionsResult]:
    """
    This data source provides the list of Functions in Oracle Cloud Infrastructure Functions service.

    Lists functions for an application.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_functions = oci.Functions.get_functions(application_id=test_application["id"],
        display_name=function_display_name,
        id=function_id,
        state=function_state)
    ```


    :param builtins.str application_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the application to which this function belongs.
    :param builtins.str display_name: A filter to return only functions with display names that match the display name string. Matching is exact.
    :param builtins.str id: A filter to return only functions with the specified OCID.
    :param builtins.str state: A filter to return only functions that match the lifecycle state in this parameter. Example: `Creating`
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Functions/getFunctions:getFunctions', __args__, opts=opts, typ=GetFunctionsResult)
    return __ret__.apply(lambda __response__: GetFunctionsResult(
        application_id=pulumi.get(__response__, 'application_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        functions=pulumi.get(__response__, 'functions'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
