# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDatabaseRegistrationsResult',
    'AwaitableGetDatabaseRegistrationsResult',
    'get_database_registrations',
    'get_database_registrations_output',
]

@pulumi.output_type
class GetDatabaseRegistrationsResult:
    """
    A collection of values returned by getDatabaseRegistrations.
    """
    def __init__(__self__, compartment_id=None, database_registration_collections=None, display_name=None, filters=None, id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if database_registration_collections and not isinstance(database_registration_collections, list):
            raise TypeError("Expected argument 'database_registration_collections' to be a list")
        pulumi.set(__self__, "database_registration_collections", database_registration_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseRegistrationCollections")
    def database_registration_collections(self) -> Sequence['outputs.GetDatabaseRegistrationsDatabaseRegistrationCollectionResult']:
        """
        The list of database_registration_collection.
        """
        return pulumi.get(self, "database_registration_collections")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        An object's Display Name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDatabaseRegistrationsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        Possible lifecycle states.
        """
        return pulumi.get(self, "state")


class AwaitableGetDatabaseRegistrationsResult(GetDatabaseRegistrationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseRegistrationsResult(
            compartment_id=self.compartment_id,
            database_registration_collections=self.database_registration_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_database_registrations(compartment_id: Optional[builtins.str] = None,
                               display_name: Optional[builtins.str] = None,
                               filters: Optional[Sequence[Union['GetDatabaseRegistrationsFilterArgs', 'GetDatabaseRegistrationsFilterArgsDict']]] = None,
                               state: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseRegistrationsResult:
    """
    This data source provides the list of Database Registrations in Oracle Cloud Infrastructure Golden Gate service.

    Note: Deprecated. Use the /connections API instead.
    Lists the DatabaseRegistrations in the compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_registrations = oci.GoldenGate.get_database_registrations(compartment_id=compartment_id,
        display_name=database_registration_display_name,
        state=database_registration_state)
    ```


    :param builtins.str compartment_id: The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
    :param builtins.str display_name: A filter to return only the resources that match the entire 'displayName' given.
    :param builtins.str state: A filter to return only the resources that match the 'lifecycleState' given.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GoldenGate/getDatabaseRegistrations:getDatabaseRegistrations', __args__, opts=opts, typ=GetDatabaseRegistrationsResult).value

    return AwaitableGetDatabaseRegistrationsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        database_registration_collections=pulumi.get(__ret__, 'database_registration_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_database_registrations_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                      display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDatabaseRegistrationsFilterArgs', 'GetDatabaseRegistrationsFilterArgsDict']]]]] = None,
                                      state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabaseRegistrationsResult]:
    """
    This data source provides the list of Database Registrations in Oracle Cloud Infrastructure Golden Gate service.

    Note: Deprecated. Use the /connections API instead.
    Lists the DatabaseRegistrations in the compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_registrations = oci.GoldenGate.get_database_registrations(compartment_id=compartment_id,
        display_name=database_registration_display_name,
        state=database_registration_state)
    ```


    :param builtins.str compartment_id: The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
    :param builtins.str display_name: A filter to return only the resources that match the entire 'displayName' given.
    :param builtins.str state: A filter to return only the resources that match the 'lifecycleState' given.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GoldenGate/getDatabaseRegistrations:getDatabaseRegistrations', __args__, opts=opts, typ=GetDatabaseRegistrationsResult)
    return __ret__.apply(lambda __response__: GetDatabaseRegistrationsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        database_registration_collections=pulumi.get(__response__, 'database_registration_collections'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
