# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDeploymentTypeResult',
    'AwaitableGetDeploymentTypeResult',
    'get_deployment_type',
    'get_deployment_type_output',
]

@pulumi.output_type
class GetDeploymentTypeResult:
    """
    A collection of values returned by getDeploymentType.
    """
    def __init__(__self__, compartment_id=None, display_name=None, id=None, items=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        An object's Display Name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDeploymentTypeItemResult']:
        """
        Array of DeploymentTypeSummary
        """
        return pulumi.get(self, "items")


class AwaitableGetDeploymentTypeResult(GetDeploymentTypeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDeploymentTypeResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            id=self.id,
            items=self.items)


def get_deployment_type(compartment_id: Optional[builtins.str] = None,
                        display_name: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDeploymentTypeResult:
    """
    This data source provides details about a specific Deployment Type resource in Oracle Cloud Infrastructure Golden Gate service.

    Returns an array of DeploymentTypeDescriptor

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_deployment_type = oci.GoldenGate.get_deployment_type(compartment_id=compartment_id,
        display_name=deployment_type_display_name)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only the resources that match the entire 'displayName' given.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GoldenGate/getDeploymentType:getDeploymentType', __args__, opts=opts, typ=GetDeploymentTypeResult).value

    return AwaitableGetDeploymentTypeResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'))
def get_deployment_type_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                               display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDeploymentTypeResult]:
    """
    This data source provides details about a specific Deployment Type resource in Oracle Cloud Infrastructure Golden Gate service.

    Returns an array of DeploymentTypeDescriptor

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_deployment_type = oci.GoldenGate.get_deployment_type(compartment_id=compartment_id,
        display_name=deployment_type_display_name)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only the resources that match the entire 'displayName' given.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GoldenGate/getDeploymentType:getDeploymentType', __args__, opts=opts, typ=GetDeploymentTypeResult)
    return __ret__.apply(lambda __response__: GetDeploymentTypeResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items')))
