# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMessagesResult',
    'AwaitableGetMessagesResult',
    'get_messages',
    'get_messages_output',
]

@pulumi.output_type
class GetMessagesResult:
    """
    A collection of values returned by getMessages.
    """
    def __init__(__self__, deployment_id=None, deployment_messages_collections=None, filters=None, id=None):
        if deployment_id and not isinstance(deployment_id, str):
            raise TypeError("Expected argument 'deployment_id' to be a str")
        pulumi.set(__self__, "deployment_id", deployment_id)
        if deployment_messages_collections and not isinstance(deployment_messages_collections, list):
            raise TypeError("Expected argument 'deployment_messages_collections' to be a list")
        pulumi.set(__self__, "deployment_messages_collections", deployment_messages_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> builtins.str:
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="deploymentMessagesCollections")
    def deployment_messages_collections(self) -> Sequence['outputs.GetMessagesDeploymentMessagesCollectionResult']:
        """
        The list of deployment_messages_collection.
        """
        return pulumi.get(self, "deployment_messages_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMessagesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetMessagesResult(GetMessagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMessagesResult(
            deployment_id=self.deployment_id,
            deployment_messages_collections=self.deployment_messages_collections,
            filters=self.filters,
            id=self.id)


def get_messages(deployment_id: Optional[builtins.str] = None,
                 filters: Optional[Sequence[Union['GetMessagesFilterArgs', 'GetMessagesFilterArgsDict']]] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMessagesResult:
    """
    This data source provides the list of Messages in Oracle Cloud Infrastructure Golden Gate service.

    Lists the DeploymentMessages for a deployment. The sorting order is not important. By default first will be Upgrade message, next Exception message and then Storage Utilization message.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_messages = oci.GoldenGate.get_messages(deployment_id=test_deployment["id"])
    ```


    :param builtins.str deployment_id: A unique Deployment identifier.
    """
    __args__ = dict()
    __args__['deploymentId'] = deployment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GoldenGate/getMessages:getMessages', __args__, opts=opts, typ=GetMessagesResult).value

    return AwaitableGetMessagesResult(
        deployment_id=pulumi.get(__ret__, 'deployment_id'),
        deployment_messages_collections=pulumi.get(__ret__, 'deployment_messages_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_messages_output(deployment_id: Optional[pulumi.Input[builtins.str]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetMessagesFilterArgs', 'GetMessagesFilterArgsDict']]]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMessagesResult]:
    """
    This data source provides the list of Messages in Oracle Cloud Infrastructure Golden Gate service.

    Lists the DeploymentMessages for a deployment. The sorting order is not important. By default first will be Upgrade message, next Exception message and then Storage Utilization message.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_messages = oci.GoldenGate.get_messages(deployment_id=test_deployment["id"])
    ```


    :param builtins.str deployment_id: A unique Deployment identifier.
    """
    __args__ = dict()
    __args__['deploymentId'] = deployment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GoldenGate/getMessages:getMessages', __args__, opts=opts, typ=GetMessagesResult)
    return __ret__.apply(lambda __response__: GetMessagesResult(
        deployment_id=pulumi.get(__response__, 'deployment_id'),
        deployment_messages_collections=pulumi.get(__response__, 'deployment_messages_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
