# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVantagePointsResult',
    'AwaitableGetVantagePointsResult',
    'get_vantage_points',
    'get_vantage_points_output',
]

@pulumi.output_type
class GetVantagePointsResult:
    """
    A collection of values returned by getVantagePoints.
    """
    def __init__(__self__, display_name=None, filters=None, health_checks_vantage_points=None, id=None, name=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if health_checks_vantage_points and not isinstance(health_checks_vantage_points, list):
            raise TypeError("Expected argument 'health_checks_vantage_points' to be a list")
        pulumi.set(__self__, "health_checks_vantage_points", health_checks_vantage_points)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        The display name for the vantage point. Display names are determined by the best information available and may change over time.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVantagePointsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="healthChecksVantagePoints")
    def health_checks_vantage_points(self) -> Sequence['outputs.GetVantagePointsHealthChecksVantagePointResult']:
        """
        The list of health_checks_vantage_points.
        """
        return pulumi.get(self, "health_checks_vantage_points")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The unique, permanent name for the vantage point.
        """
        return pulumi.get(self, "name")


class AwaitableGetVantagePointsResult(GetVantagePointsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVantagePointsResult(
            display_name=self.display_name,
            filters=self.filters,
            health_checks_vantage_points=self.health_checks_vantage_points,
            id=self.id,
            name=self.name)


def get_vantage_points(display_name: Optional[builtins.str] = None,
                       filters: Optional[Sequence[Union['GetVantagePointsFilterArgs', 'GetVantagePointsFilterArgsDict']]] = None,
                       name: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVantagePointsResult:
    """
    This data source provides the list of Vantage Points in Oracle Cloud Infrastructure Health Checks service.

    Gets information about all vantage points available to the user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vantage_points = oci.HealthChecks.get_vantage_points(display_name=vantage_point_display_name,
        name=vantage_point_name)
    ```


    :param builtins.str display_name: Filters results that exactly match the `displayName` field.
    :param builtins.str name: Filters results that exactly match the `name` field.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:HealthChecks/getVantagePoints:getVantagePoints', __args__, opts=opts, typ=GetVantagePointsResult).value

    return AwaitableGetVantagePointsResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        health_checks_vantage_points=pulumi.get(__ret__, 'health_checks_vantage_points'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))
def get_vantage_points_output(display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVantagePointsFilterArgs', 'GetVantagePointsFilterArgsDict']]]]] = None,
                              name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVantagePointsResult]:
    """
    This data source provides the list of Vantage Points in Oracle Cloud Infrastructure Health Checks service.

    Gets information about all vantage points available to the user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vantage_points = oci.HealthChecks.get_vantage_points(display_name=vantage_point_display_name,
        name=vantage_point_name)
    ```


    :param builtins.str display_name: Filters results that exactly match the `displayName` field.
    :param builtins.str name: Filters results that exactly match the `name` field.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:HealthChecks/getVantagePoints:getVantagePoints', __args__, opts=opts, typ=GetVantagePointsResult)
    return __ret__.apply(lambda __response__: GetVantagePointsResult(
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        health_checks_vantage_points=pulumi.get(__response__, 'health_checks_vantage_points'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name')))
