# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInstallationSitesResult',
    'AwaitableGetInstallationSitesResult',
    'get_installation_sites',
    'get_installation_sites_output',
]

@pulumi.output_type
class GetInstallationSitesResult:
    """
    A collection of values returned by getInstallationSites.
    """
    def __init__(__self__, application_id=None, filters=None, fleet_id=None, id=None, installation_path=None, installation_site_collections=None, jre_distribution=None, jre_security_status=None, jre_vendor=None, jre_version=None, managed_instance_id=None, os_families=None, path_contains=None, time_end=None, time_start=None):
        if application_id and not isinstance(application_id, str):
            raise TypeError("Expected argument 'application_id' to be a str")
        pulumi.set(__self__, "application_id", application_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if installation_path and not isinstance(installation_path, str):
            raise TypeError("Expected argument 'installation_path' to be a str")
        pulumi.set(__self__, "installation_path", installation_path)
        if installation_site_collections and not isinstance(installation_site_collections, list):
            raise TypeError("Expected argument 'installation_site_collections' to be a list")
        pulumi.set(__self__, "installation_site_collections", installation_site_collections)
        if jre_distribution and not isinstance(jre_distribution, str):
            raise TypeError("Expected argument 'jre_distribution' to be a str")
        pulumi.set(__self__, "jre_distribution", jre_distribution)
        if jre_security_status and not isinstance(jre_security_status, str):
            raise TypeError("Expected argument 'jre_security_status' to be a str")
        pulumi.set(__self__, "jre_security_status", jre_security_status)
        if jre_vendor and not isinstance(jre_vendor, str):
            raise TypeError("Expected argument 'jre_vendor' to be a str")
        pulumi.set(__self__, "jre_vendor", jre_vendor)
        if jre_version and not isinstance(jre_version, str):
            raise TypeError("Expected argument 'jre_version' to be a str")
        pulumi.set(__self__, "jre_version", jre_version)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if os_families and not isinstance(os_families, list):
            raise TypeError("Expected argument 'os_families' to be a list")
        pulumi.set(__self__, "os_families", os_families)
        if path_contains and not isinstance(path_contains, str):
            raise TypeError("Expected argument 'path_contains' to be a str")
        pulumi.set(__self__, "path_contains", path_contains)
        if time_end and not isinstance(time_end, str):
            raise TypeError("Expected argument 'time_end' to be a str")
        pulumi.set(__self__, "time_end", time_end)
        if time_start and not isinstance(time_start, str):
            raise TypeError("Expected argument 'time_start' to be a str")
        pulumi.set(__self__, "time_start", time_start)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInstallationSitesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> builtins.str:
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="installationPath")
    def installation_path(self) -> Optional[builtins.str]:
        return pulumi.get(self, "installation_path")

    @property
    @pulumi.getter(name="installationSiteCollections")
    def installation_site_collections(self) -> Sequence['outputs.GetInstallationSitesInstallationSiteCollectionResult']:
        """
        The list of installation_site_collection.
        """
        return pulumi.get(self, "installation_site_collections")

    @property
    @pulumi.getter(name="jreDistribution")
    def jre_distribution(self) -> Optional[builtins.str]:
        return pulumi.get(self, "jre_distribution")

    @property
    @pulumi.getter(name="jreSecurityStatus")
    def jre_security_status(self) -> Optional[builtins.str]:
        return pulumi.get(self, "jre_security_status")

    @property
    @pulumi.getter(name="jreVendor")
    def jre_vendor(self) -> Optional[builtins.str]:
        return pulumi.get(self, "jre_vendor")

    @property
    @pulumi.getter(name="jreVersion")
    def jre_version(self) -> Optional[builtins.str]:
        return pulumi.get(self, "jre_version")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the related managed instance.
        """
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter(name="osFamilies")
    def os_families(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "os_families")

    @property
    @pulumi.getter(name="pathContains")
    def path_contains(self) -> Optional[builtins.str]:
        return pulumi.get(self, "path_contains")

    @property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_end")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_start")


class AwaitableGetInstallationSitesResult(GetInstallationSitesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstallationSitesResult(
            application_id=self.application_id,
            filters=self.filters,
            fleet_id=self.fleet_id,
            id=self.id,
            installation_path=self.installation_path,
            installation_site_collections=self.installation_site_collections,
            jre_distribution=self.jre_distribution,
            jre_security_status=self.jre_security_status,
            jre_vendor=self.jre_vendor,
            jre_version=self.jre_version,
            managed_instance_id=self.managed_instance_id,
            os_families=self.os_families,
            path_contains=self.path_contains,
            time_end=self.time_end,
            time_start=self.time_start)


def get_installation_sites(application_id: Optional[builtins.str] = None,
                           filters: Optional[Sequence[Union['GetInstallationSitesFilterArgs', 'GetInstallationSitesFilterArgsDict']]] = None,
                           fleet_id: Optional[builtins.str] = None,
                           installation_path: Optional[builtins.str] = None,
                           jre_distribution: Optional[builtins.str] = None,
                           jre_security_status: Optional[builtins.str] = None,
                           jre_vendor: Optional[builtins.str] = None,
                           jre_version: Optional[builtins.str] = None,
                           managed_instance_id: Optional[builtins.str] = None,
                           os_families: Optional[Sequence[builtins.str]] = None,
                           path_contains: Optional[builtins.str] = None,
                           time_end: Optional[builtins.str] = None,
                           time_start: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstallationSitesResult:
    """
    This data source provides the list of Fleet Installation Sites in Oracle Cloud Infrastructure Jms service.

    List Java installation sites in a Fleet filtered by query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_installation_sites = oci.Jms.get_installation_sites(fleet_id=test_fleet["id"],
        application_id=fleet_installation_site_application_id,
        installation_path=fleet_installation_site_installation_path,
        jre_distribution=fleet_installation_site_jre_distribution,
        jre_security_status=fleet_installation_site_jre_security_status,
        jre_vendor=fleet_installation_site_jre_vendor,
        jre_version=fleet_installation_site_jre_version,
        managed_instance_id=fleet_installation_site_managed_instance_id,
        os_families=fleet_installation_site_os_family,
        path_contains=fleet_installation_site_path_contains,
        time_end=fleet_installation_site_time_end,
        time_start=fleet_installation_site_time_start)
    ```


    :param builtins.str application_id: The Fleet-unique identifier of the related application.
    :param builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    :param builtins.str installation_path: The file system path of the installation.
    :param builtins.str jre_distribution: The distribution of the related Java Runtime.
    :param builtins.str jre_security_status: The security status of the Java Runtime.
    :param builtins.str jre_vendor: The vendor of the related Java Runtime.
    :param builtins.str jre_version: The version of the related Java Runtime.
    :param builtins.str managed_instance_id: The Fleet-unique identifier of the related managed instance.
    :param Sequence[builtins.str] os_families: The operating system type.
    :param builtins.str path_contains: Filter the list with path contains the given value.
    :param builtins.str time_end: The end of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param builtins.str time_start: The start of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['installationPath'] = installation_path
    __args__['jreDistribution'] = jre_distribution
    __args__['jreSecurityStatus'] = jre_security_status
    __args__['jreVendor'] = jre_vendor
    __args__['jreVersion'] = jre_version
    __args__['managedInstanceId'] = managed_instance_id
    __args__['osFamilies'] = os_families
    __args__['pathContains'] = path_contains
    __args__['timeEnd'] = time_end
    __args__['timeStart'] = time_start
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getInstallationSites:getInstallationSites', __args__, opts=opts, typ=GetInstallationSitesResult).value

    return AwaitableGetInstallationSitesResult(
        application_id=pulumi.get(__ret__, 'application_id'),
        filters=pulumi.get(__ret__, 'filters'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'),
        installation_path=pulumi.get(__ret__, 'installation_path'),
        installation_site_collections=pulumi.get(__ret__, 'installation_site_collections'),
        jre_distribution=pulumi.get(__ret__, 'jre_distribution'),
        jre_security_status=pulumi.get(__ret__, 'jre_security_status'),
        jre_vendor=pulumi.get(__ret__, 'jre_vendor'),
        jre_version=pulumi.get(__ret__, 'jre_version'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        os_families=pulumi.get(__ret__, 'os_families'),
        path_contains=pulumi.get(__ret__, 'path_contains'),
        time_end=pulumi.get(__ret__, 'time_end'),
        time_start=pulumi.get(__ret__, 'time_start'))
def get_installation_sites_output(application_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetInstallationSitesFilterArgs', 'GetInstallationSitesFilterArgsDict']]]]] = None,
                                  fleet_id: Optional[pulumi.Input[builtins.str]] = None,
                                  installation_path: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  jre_distribution: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  jre_security_status: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  jre_vendor: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  jre_version: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  managed_instance_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  os_families: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                  path_contains: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  time_end: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  time_start: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstallationSitesResult]:
    """
    This data source provides the list of Fleet Installation Sites in Oracle Cloud Infrastructure Jms service.

    List Java installation sites in a Fleet filtered by query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_installation_sites = oci.Jms.get_installation_sites(fleet_id=test_fleet["id"],
        application_id=fleet_installation_site_application_id,
        installation_path=fleet_installation_site_installation_path,
        jre_distribution=fleet_installation_site_jre_distribution,
        jre_security_status=fleet_installation_site_jre_security_status,
        jre_vendor=fleet_installation_site_jre_vendor,
        jre_version=fleet_installation_site_jre_version,
        managed_instance_id=fleet_installation_site_managed_instance_id,
        os_families=fleet_installation_site_os_family,
        path_contains=fleet_installation_site_path_contains,
        time_end=fleet_installation_site_time_end,
        time_start=fleet_installation_site_time_start)
    ```


    :param builtins.str application_id: The Fleet-unique identifier of the related application.
    :param builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    :param builtins.str installation_path: The file system path of the installation.
    :param builtins.str jre_distribution: The distribution of the related Java Runtime.
    :param builtins.str jre_security_status: The security status of the Java Runtime.
    :param builtins.str jre_vendor: The vendor of the related Java Runtime.
    :param builtins.str jre_version: The version of the related Java Runtime.
    :param builtins.str managed_instance_id: The Fleet-unique identifier of the related managed instance.
    :param Sequence[builtins.str] os_families: The operating system type.
    :param builtins.str path_contains: Filter the list with path contains the given value.
    :param builtins.str time_end: The end of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param builtins.str time_start: The start of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['installationPath'] = installation_path
    __args__['jreDistribution'] = jre_distribution
    __args__['jreSecurityStatus'] = jre_security_status
    __args__['jreVendor'] = jre_vendor
    __args__['jreVersion'] = jre_version
    __args__['managedInstanceId'] = managed_instance_id
    __args__['osFamilies'] = os_families
    __args__['pathContains'] = path_contains
    __args__['timeEnd'] = time_end
    __args__['timeStart'] = time_start
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getInstallationSites:getInstallationSites', __args__, opts=opts, typ=GetInstallationSitesResult)
    return __ret__.apply(lambda __response__: GetInstallationSitesResult(
        application_id=pulumi.get(__response__, 'application_id'),
        filters=pulumi.get(__response__, 'filters'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        id=pulumi.get(__response__, 'id'),
        installation_path=pulumi.get(__response__, 'installation_path'),
        installation_site_collections=pulumi.get(__response__, 'installation_site_collections'),
        jre_distribution=pulumi.get(__response__, 'jre_distribution'),
        jre_security_status=pulumi.get(__response__, 'jre_security_status'),
        jre_vendor=pulumi.get(__response__, 'jre_vendor'),
        jre_version=pulumi.get(__response__, 'jre_version'),
        managed_instance_id=pulumi.get(__response__, 'managed_instance_id'),
        os_families=pulumi.get(__response__, 'os_families'),
        path_contains=pulumi.get(__response__, 'path_contains'),
        time_end=pulumi.get(__response__, 'time_end'),
        time_start=pulumi.get(__response__, 'time_start')))
