# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVaultResult',
    'AwaitableGetVaultResult',
    'get_vault',
    'get_vault_output',
]

@pulumi.output_type
class GetVaultResult:
    """
    A collection of values returned by getVault.
    """
    def __init__(__self__, compartment_id=None, crypto_endpoint=None, defined_tags=None, display_name=None, external_key_manager_metadata_summaries=None, external_key_manager_metadatas=None, freeform_tags=None, id=None, is_primary=None, is_vault_replicable=None, management_endpoint=None, replica_details=None, restore_from_files=None, restore_from_object_stores=None, restore_trigger=None, restored_from_vault_id=None, state=None, time_created=None, time_of_deletion=None, vault_id=None, vault_type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if crypto_endpoint and not isinstance(crypto_endpoint, str):
            raise TypeError("Expected argument 'crypto_endpoint' to be a str")
        pulumi.set(__self__, "crypto_endpoint", crypto_endpoint)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if external_key_manager_metadata_summaries and not isinstance(external_key_manager_metadata_summaries, list):
            raise TypeError("Expected argument 'external_key_manager_metadata_summaries' to be a list")
        pulumi.set(__self__, "external_key_manager_metadata_summaries", external_key_manager_metadata_summaries)
        if external_key_manager_metadatas and not isinstance(external_key_manager_metadatas, list):
            raise TypeError("Expected argument 'external_key_manager_metadatas' to be a list")
        pulumi.set(__self__, "external_key_manager_metadatas", external_key_manager_metadatas)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_primary and not isinstance(is_primary, bool):
            raise TypeError("Expected argument 'is_primary' to be a bool")
        pulumi.set(__self__, "is_primary", is_primary)
        if is_vault_replicable and not isinstance(is_vault_replicable, bool):
            raise TypeError("Expected argument 'is_vault_replicable' to be a bool")
        pulumi.set(__self__, "is_vault_replicable", is_vault_replicable)
        if management_endpoint and not isinstance(management_endpoint, str):
            raise TypeError("Expected argument 'management_endpoint' to be a str")
        pulumi.set(__self__, "management_endpoint", management_endpoint)
        if replica_details and not isinstance(replica_details, list):
            raise TypeError("Expected argument 'replica_details' to be a list")
        pulumi.set(__self__, "replica_details", replica_details)
        if restore_from_files and not isinstance(restore_from_files, list):
            raise TypeError("Expected argument 'restore_from_files' to be a list")
        pulumi.set(__self__, "restore_from_files", restore_from_files)
        if restore_from_object_stores and not isinstance(restore_from_object_stores, list):
            raise TypeError("Expected argument 'restore_from_object_stores' to be a list")
        pulumi.set(__self__, "restore_from_object_stores", restore_from_object_stores)
        if restore_trigger and not isinstance(restore_trigger, bool):
            raise TypeError("Expected argument 'restore_trigger' to be a bool")
        pulumi.set(__self__, "restore_trigger", restore_trigger)
        if restored_from_vault_id and not isinstance(restored_from_vault_id, str):
            raise TypeError("Expected argument 'restored_from_vault_id' to be a str")
        pulumi.set(__self__, "restored_from_vault_id", restored_from_vault_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_of_deletion and not isinstance(time_of_deletion, str):
            raise TypeError("Expected argument 'time_of_deletion' to be a str")
        pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        if vault_id and not isinstance(vault_id, str):
            raise TypeError("Expected argument 'vault_id' to be a str")
        pulumi.set(__self__, "vault_id", vault_id)
        if vault_type and not isinstance(vault_type, str):
            raise TypeError("Expected argument 'vault_type' to be a str")
        pulumi.set(__self__, "vault_type", vault_type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment that contains a particular vault.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="cryptoEndpoint")
    def crypto_endpoint(self) -> builtins.str:
        """
        The service endpoint to perform cryptographic operations against. Cryptographic operations include [Encrypt](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/EncryptedData/Encrypt), [Decrypt](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/DecryptedData/Decrypt), and [GenerateDataEncryptionKey](https://docs.cloud.oracle.com/iaas/api/#/en/key/latest/GeneratedKey/GenerateDataEncryptionKey) operations.
        """
        return pulumi.get(self, "crypto_endpoint")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name for the vault. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalKeyManagerMetadataSummaries")
    def external_key_manager_metadata_summaries(self) -> Sequence['outputs.GetVaultExternalKeyManagerMetadataSummaryResult']:
        """
        Summary about metadata of external key manager to be returned to the customer as a response.
        """
        return pulumi.get(self, "external_key_manager_metadata_summaries")

    @property
    @pulumi.getter(name="externalKeyManagerMetadatas")
    def external_key_manager_metadatas(self) -> Sequence['outputs.GetVaultExternalKeyManagerMetadataResult']:
        return pulumi.get(self, "external_key_manager_metadatas")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the vault.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> builtins.bool:
        """
        A Boolean value that indicates whether the Vault is primary Vault or replica Vault.
        """
        return pulumi.get(self, "is_primary")

    @property
    @pulumi.getter(name="isVaultReplicable")
    def is_vault_replicable(self) -> builtins.bool:
        """
        A Boolean value that indicates whether the Vault has cross region replication capability. Always true for Virtual Private Vaults.
        """
        return pulumi.get(self, "is_vault_replicable")

    @property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> builtins.str:
        """
        The service endpoint to perform management operations against. Management operations include "Create," "Update," "List," "Get," and "Delete" operations.
        """
        return pulumi.get(self, "management_endpoint")

    @property
    @pulumi.getter(name="replicaDetails")
    def replica_details(self) -> Sequence['outputs.GetVaultReplicaDetailResult']:
        """
        Vault replica details
        """
        return pulumi.get(self, "replica_details")

    @property
    @pulumi.getter(name="restoreFromFiles")
    def restore_from_files(self) -> Sequence['outputs.GetVaultRestoreFromFileResult']:
        """
        Details where vault was backed up.
        """
        return pulumi.get(self, "restore_from_files")

    @property
    @pulumi.getter(name="restoreFromObjectStores")
    def restore_from_object_stores(self) -> Sequence['outputs.GetVaultRestoreFromObjectStoreResult']:
        """
        Details where vault was backed up
        """
        return pulumi.get(self, "restore_from_object_stores")

    @property
    @pulumi.getter(name="restoreTrigger")
    def restore_trigger(self) -> builtins.bool:
        """
        When flipped, triggers restore if restore options are provided. Values of 0 or 1 are supported
        """
        return pulumi.get(self, "restore_trigger")

    @property
    @pulumi.getter(name="restoredFromVaultId")
    def restored_from_vault_id(self) -> builtins.str:
        """
        The OCID of the vault from which this vault was restored, if it was restored from a backup file. If you restore a vault to the same region, the vault retains the same OCID that it had when you backed up the vault.
        """
        return pulumi.get(self, "restored_from_vault_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The vault's current lifecycle state.  Example: `DELETED`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time this vault was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> builtins.str:
        """
        An optional property to indicate when to delete the vault, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> builtins.str:
        return pulumi.get(self, "vault_id")

    @property
    @pulumi.getter(name="vaultType")
    def vault_type(self) -> builtins.str:
        """
        The type of vault. Each type of vault stores the key with different degrees of isolation and has different options and pricing.
        """
        return pulumi.get(self, "vault_type")


class AwaitableGetVaultResult(GetVaultResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVaultResult(
            compartment_id=self.compartment_id,
            crypto_endpoint=self.crypto_endpoint,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            external_key_manager_metadata_summaries=self.external_key_manager_metadata_summaries,
            external_key_manager_metadatas=self.external_key_manager_metadatas,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_primary=self.is_primary,
            is_vault_replicable=self.is_vault_replicable,
            management_endpoint=self.management_endpoint,
            replica_details=self.replica_details,
            restore_from_files=self.restore_from_files,
            restore_from_object_stores=self.restore_from_object_stores,
            restore_trigger=self.restore_trigger,
            restored_from_vault_id=self.restored_from_vault_id,
            state=self.state,
            time_created=self.time_created,
            time_of_deletion=self.time_of_deletion,
            vault_id=self.vault_id,
            vault_type=self.vault_type)


def get_vault(vault_id: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVaultResult:
    """
    This data source provides details about a specific Vault resource in Oracle Cloud Infrastructure Kms service.

    Gets the specified vault's configuration information.

    As a provisioning operation, this call is subject to a Key Management limit that applies to
    the total number of requests across all provisioning read operations. Key Management might
    throttle this call to reject an otherwise valid request when the total rate of provisioning
    read operations exceeds 10 requests per second for a given tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vault = oci.Kms.get_vault(vault_id=test_vault_oci_kms_vault["id"])
    ```


    :param builtins.str vault_id: The OCID of the vault.
    """
    __args__ = dict()
    __args__['vaultId'] = vault_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Kms/getVault:getVault', __args__, opts=opts, typ=GetVaultResult).value

    return AwaitableGetVaultResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        crypto_endpoint=pulumi.get(__ret__, 'crypto_endpoint'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        external_key_manager_metadata_summaries=pulumi.get(__ret__, 'external_key_manager_metadata_summaries'),
        external_key_manager_metadatas=pulumi.get(__ret__, 'external_key_manager_metadatas'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_primary=pulumi.get(__ret__, 'is_primary'),
        is_vault_replicable=pulumi.get(__ret__, 'is_vault_replicable'),
        management_endpoint=pulumi.get(__ret__, 'management_endpoint'),
        replica_details=pulumi.get(__ret__, 'replica_details'),
        restore_from_files=pulumi.get(__ret__, 'restore_from_files'),
        restore_from_object_stores=pulumi.get(__ret__, 'restore_from_object_stores'),
        restore_trigger=pulumi.get(__ret__, 'restore_trigger'),
        restored_from_vault_id=pulumi.get(__ret__, 'restored_from_vault_id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_of_deletion=pulumi.get(__ret__, 'time_of_deletion'),
        vault_id=pulumi.get(__ret__, 'vault_id'),
        vault_type=pulumi.get(__ret__, 'vault_type'))
def get_vault_output(vault_id: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVaultResult]:
    """
    This data source provides details about a specific Vault resource in Oracle Cloud Infrastructure Kms service.

    Gets the specified vault's configuration information.

    As a provisioning operation, this call is subject to a Key Management limit that applies to
    the total number of requests across all provisioning read operations. Key Management might
    throttle this call to reject an otherwise valid request when the total rate of provisioning
    read operations exceeds 10 requests per second for a given tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vault = oci.Kms.get_vault(vault_id=test_vault_oci_kms_vault["id"])
    ```


    :param builtins.str vault_id: The OCID of the vault.
    """
    __args__ = dict()
    __args__['vaultId'] = vault_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Kms/getVault:getVault', __args__, opts=opts, typ=GetVaultResult)
    return __ret__.apply(lambda __response__: GetVaultResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        crypto_endpoint=pulumi.get(__response__, 'crypto_endpoint'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        external_key_manager_metadata_summaries=pulumi.get(__response__, 'external_key_manager_metadata_summaries'),
        external_key_manager_metadatas=pulumi.get(__response__, 'external_key_manager_metadatas'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_primary=pulumi.get(__response__, 'is_primary'),
        is_vault_replicable=pulumi.get(__response__, 'is_vault_replicable'),
        management_endpoint=pulumi.get(__response__, 'management_endpoint'),
        replica_details=pulumi.get(__response__, 'replica_details'),
        restore_from_files=pulumi.get(__response__, 'restore_from_files'),
        restore_from_object_stores=pulumi.get(__response__, 'restore_from_object_stores'),
        restore_trigger=pulumi.get(__response__, 'restore_trigger'),
        restored_from_vault_id=pulumi.get(__response__, 'restored_from_vault_id'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_of_deletion=pulumi.get(__response__, 'time_of_deletion'),
        vault_id=pulumi.get(__response__, 'vault_id'),
        vault_type=pulumi.get(__response__, 'vault_type')))
