# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ProductLicenseImage',
    'GetLicenseRecordsFilterResult',
    'GetLicenseRecordsLicenseRecordCollectionResult',
    'GetLicenseRecordsLicenseRecordCollectionItemResult',
    'GetProductLicenseConsumersItemResult',
    'GetProductLicenseConsumersItemMissingProductResult',
    'GetProductLicenseImageResult',
    'GetProductLicensesFilterResult',
    'GetProductLicensesProductLicenseCollectionResult',
    'GetProductLicensesProductLicenseCollectionItemResult',
    'GetProductLicensesProductLicenseCollectionItemImageResult',
    'GetTopUtilizedProductLicensesItemResult',
    'GetTopUtilizedResourcesItemResult',
]

@pulumi.output_type
class ProductLicenseImage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "listingId":
            suggest = "listing_id"
        elif key == "packageVersion":
            suggest = "package_version"
        elif key == "listingName":
            suggest = "listing_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProductLicenseImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProductLicenseImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProductLicenseImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 listing_id: builtins.str,
                 package_version: builtins.str,
                 id: Optional[builtins.str] = None,
                 listing_name: Optional[builtins.str] = None,
                 publisher: Optional[builtins.str] = None):
        """
        :param builtins.str listing_id: (Updatable) Marketplace image listing ID.
        :param builtins.str package_version: (Updatable) Image package version.
        :param builtins.str id: The image ID associated with the product license.
        :param builtins.str listing_name: The listing name associated with the product license.
        :param builtins.str publisher: The image publisher.
        """
        pulumi.set(__self__, "listing_id", listing_id)
        pulumi.set(__self__, "package_version", package_version)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if listing_name is not None:
            pulumi.set(__self__, "listing_name", listing_name)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)

    @property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> builtins.str:
        """
        (Updatable) Marketplace image listing ID.
        """
        return pulumi.get(self, "listing_id")

    @property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> builtins.str:
        """
        (Updatable) Image package version.
        """
        return pulumi.get(self, "package_version")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The image ID associated with the product license.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="listingName")
    def listing_name(self) -> Optional[builtins.str]:
        """
        The listing name associated with the product license.
        """
        return pulumi.get(self, "listing_name")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[builtins.str]:
        """
        The image publisher.
        """
        return pulumi.get(self, "publisher")


@pulumi.output_type
class GetLicenseRecordsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetLicenseRecordsLicenseRecordCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetLicenseRecordsLicenseRecordCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetLicenseRecordsLicenseRecordCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetLicenseRecordsLicenseRecordCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 display_name: builtins.str,
                 expiration_date: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 is_perpetual: builtins.bool,
                 is_unlimited: builtins.bool,
                 license_count: builtins.int,
                 license_unit: builtins.str,
                 product_id: builtins.str,
                 product_license: builtins.str,
                 product_license_id: builtins.str,
                 state: builtins.str,
                 support_end_date: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) where the license record is created.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param builtins.str display_name: The license record display name. Avoid entering confidential information.
        :param builtins.str expiration_date: The license record end date in [RFC 3339](https://tools.ietf.org/html/rfc3339) date format. Example: `2018-09-12`
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str id: The license record [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param builtins.bool is_perpetual: Specifies if the license record term is perpertual.
        :param builtins.bool is_unlimited: Specifies if the license count is unlimited.
        :param builtins.int license_count: The number of license units added by the user for the given license record. Default 1
        :param builtins.str license_unit: The product license unit.
        :param builtins.str product_id: The license record product ID.
        :param builtins.str product_license: The product license name with which the license record is associated.
        :param builtins.str product_license_id: Unique product license identifier.
        :param builtins.str state: The current license record state.
        :param builtins.str support_end_date: The license record support end date in [RFC 3339](https://tools.ietf.org/html/rfc3339) date format. Example: `2018-09-12`
        :param Mapping[str, builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_created: The time the license record was created. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        :param builtins.str time_updated: The time the license record was updated. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "expiration_date", expiration_date)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_perpetual", is_perpetual)
        pulumi.set(__self__, "is_unlimited", is_unlimited)
        pulumi.set(__self__, "license_count", license_count)
        pulumi.set(__self__, "license_unit", license_unit)
        pulumi.set(__self__, "product_id", product_id)
        pulumi.set(__self__, "product_license", product_license)
        pulumi.set(__self__, "product_license_id", product_license_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "support_end_date", support_end_date)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) where the license record is created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The license record display name. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> builtins.str:
        """
        The license record end date in [RFC 3339](https://tools.ietf.org/html/rfc3339) date format. Example: `2018-09-12`
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The license record [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isPerpetual")
    def is_perpetual(self) -> builtins.bool:
        """
        Specifies if the license record term is perpertual.
        """
        return pulumi.get(self, "is_perpetual")

    @property
    @pulumi.getter(name="isUnlimited")
    def is_unlimited(self) -> builtins.bool:
        """
        Specifies if the license count is unlimited.
        """
        return pulumi.get(self, "is_unlimited")

    @property
    @pulumi.getter(name="licenseCount")
    def license_count(self) -> builtins.int:
        """
        The number of license units added by the user for the given license record. Default 1
        """
        return pulumi.get(self, "license_count")

    @property
    @pulumi.getter(name="licenseUnit")
    def license_unit(self) -> builtins.str:
        """
        The product license unit.
        """
        return pulumi.get(self, "license_unit")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> builtins.str:
        """
        The license record product ID.
        """
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter(name="productLicense")
    def product_license(self) -> builtins.str:
        """
        The product license name with which the license record is associated.
        """
        return pulumi.get(self, "product_license")

    @property
    @pulumi.getter(name="productLicenseId")
    def product_license_id(self) -> builtins.str:
        """
        Unique product license identifier.
        """
        return pulumi.get(self, "product_license_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current license record state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="supportEndDate")
    def support_end_date(self) -> builtins.str:
        """
        The license record support end date in [RFC 3339](https://tools.ietf.org/html/rfc3339) date format. Example: `2018-09-12`
        """
        return pulumi.get(self, "support_end_date")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the license record was created. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the license record was updated. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetProductLicenseConsumersItemResult(dict):
    def __init__(__self__, *,
                 are_all_options_available: builtins.bool,
                 is_base_license_available: builtins.bool,
                 license_unit_type: builtins.str,
                 license_units_consumed: builtins.float,
                 missing_products: Sequence['outputs.GetProductLicenseConsumersItemMissingProductResult'],
                 product_name: builtins.str,
                 resource_compartment_id: builtins.str,
                 resource_compartment_name: builtins.str,
                 resource_id: builtins.str,
                 resource_name: builtins.str,
                 resource_unit_count: builtins.float,
                 resource_unit_type: builtins.str):
        """
        :param builtins.bool are_all_options_available: Specifies if all options are available.
        :param builtins.bool is_base_license_available: Specifies if the base license is available.
        :param builtins.str license_unit_type: The product license unit.
        :param builtins.float license_units_consumed: Number of license units consumed by the resource.
        :param Sequence['GetProductLicenseConsumersItemMissingProductArgs'] missing_products: Collection of missing product licenses.
        :param builtins.str product_name: The resource product name.
        :param builtins.str resource_compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the resource.
        :param builtins.str resource_compartment_name: The display name of the compartment that contains the resource.
        :param builtins.str resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource.
        :param builtins.str resource_name: The display name of the resource.
        :param builtins.float resource_unit_count: Number of units of the resource
        :param builtins.str resource_unit_type: The unit type for the resource.
        """
        pulumi.set(__self__, "are_all_options_available", are_all_options_available)
        pulumi.set(__self__, "is_base_license_available", is_base_license_available)
        pulumi.set(__self__, "license_unit_type", license_unit_type)
        pulumi.set(__self__, "license_units_consumed", license_units_consumed)
        pulumi.set(__self__, "missing_products", missing_products)
        pulumi.set(__self__, "product_name", product_name)
        pulumi.set(__self__, "resource_compartment_id", resource_compartment_id)
        pulumi.set(__self__, "resource_compartment_name", resource_compartment_name)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_name", resource_name)
        pulumi.set(__self__, "resource_unit_count", resource_unit_count)
        pulumi.set(__self__, "resource_unit_type", resource_unit_type)

    @property
    @pulumi.getter(name="areAllOptionsAvailable")
    def are_all_options_available(self) -> builtins.bool:
        """
        Specifies if all options are available.
        """
        return pulumi.get(self, "are_all_options_available")

    @property
    @pulumi.getter(name="isBaseLicenseAvailable")
    def is_base_license_available(self) -> builtins.bool:
        """
        Specifies if the base license is available.
        """
        return pulumi.get(self, "is_base_license_available")

    @property
    @pulumi.getter(name="licenseUnitType")
    def license_unit_type(self) -> builtins.str:
        """
        The product license unit.
        """
        return pulumi.get(self, "license_unit_type")

    @property
    @pulumi.getter(name="licenseUnitsConsumed")
    def license_units_consumed(self) -> builtins.float:
        """
        Number of license units consumed by the resource.
        """
        return pulumi.get(self, "license_units_consumed")

    @property
    @pulumi.getter(name="missingProducts")
    def missing_products(self) -> Sequence['outputs.GetProductLicenseConsumersItemMissingProductResult']:
        """
        Collection of missing product licenses.
        """
        return pulumi.get(self, "missing_products")

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> builtins.str:
        """
        The resource product name.
        """
        return pulumi.get(self, "product_name")

    @property
    @pulumi.getter(name="resourceCompartmentId")
    def resource_compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the resource.
        """
        return pulumi.get(self, "resource_compartment_id")

    @property
    @pulumi.getter(name="resourceCompartmentName")
    def resource_compartment_name(self) -> builtins.str:
        """
        The display name of the compartment that contains the resource.
        """
        return pulumi.get(self, "resource_compartment_name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> builtins.str:
        """
        The display name of the resource.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceUnitCount")
    def resource_unit_count(self) -> builtins.float:
        """
        Number of units of the resource
        """
        return pulumi.get(self, "resource_unit_count")

    @property
    @pulumi.getter(name="resourceUnitType")
    def resource_unit_type(self) -> builtins.str:
        """
        The unit type for the resource.
        """
        return pulumi.get(self, "resource_unit_type")


@pulumi.output_type
class GetProductLicenseConsumersItemMissingProductResult(dict):
    def __init__(__self__, *,
                 category: builtins.str,
                 count: builtins.float,
                 name: builtins.str):
        """
        :param builtins.str category: Product category base or option.
        :param builtins.float count: Units required for the missing product.
        :param builtins.str name: Name of the product.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def category(self) -> builtins.str:
        """
        Product category base or option.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def count(self) -> builtins.float:
        """
        Units required for the missing product.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the product.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetProductLicenseImageResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 listing_id: builtins.str,
                 listing_name: builtins.str,
                 package_version: builtins.str,
                 publisher: builtins.str):
        """
        :param builtins.str id: The image ID associated with the product license.
        :param builtins.str listing_id: The image listing ID.
        :param builtins.str listing_name: The listing name associated with the product license.
        :param builtins.str package_version: The image package version.
        :param builtins.str publisher: The image publisher.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "listing_id", listing_id)
        pulumi.set(__self__, "listing_name", listing_name)
        pulumi.set(__self__, "package_version", package_version)
        pulumi.set(__self__, "publisher", publisher)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The image ID associated with the product license.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> builtins.str:
        """
        The image listing ID.
        """
        return pulumi.get(self, "listing_id")

    @property
    @pulumi.getter(name="listingName")
    def listing_name(self) -> builtins.str:
        """
        The listing name associated with the product license.
        """
        return pulumi.get(self, "listing_name")

    @property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> builtins.str:
        """
        The image package version.
        """
        return pulumi.get(self, "package_version")

    @property
    @pulumi.getter
    def publisher(self) -> builtins.str:
        """
        The image publisher.
        """
        return pulumi.get(self, "publisher")


@pulumi.output_type
class GetProductLicensesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetProductLicensesProductLicenseCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetProductLicensesProductLicenseCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProductLicensesProductLicenseCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProductLicensesProductLicenseCollectionItemResult(dict):
    def __init__(__self__, *,
                 active_license_record_count: builtins.int,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 images: Sequence['outputs.GetProductLicensesProductLicenseCollectionItemImageResult'],
                 is_over_subscribed: builtins.bool,
                 is_unlimited: builtins.bool,
                 is_vendor_oracle: builtins.bool,
                 license_unit: builtins.str,
                 state: builtins.str,
                 status: builtins.str,
                 status_description: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str,
                 time_updated: builtins.str,
                 total_active_license_unit_count: builtins.int,
                 total_license_record_count: builtins.int,
                 total_license_units_consumed: builtins.float,
                 vendor_name: builtins.str):
        """
        :param builtins.int active_license_record_count: The number of active license records associated with the product license.
        :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) used for the license record, product license, and configuration.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param builtins.str display_name: License record name
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str id: The image ID associated with the product license.
        :param Sequence['GetProductLicensesProductLicenseCollectionItemImageArgs'] images: The images associated with the product license.
        :param builtins.bool is_over_subscribed: Specifies whether or not the product license is oversubscribed.
        :param builtins.bool is_unlimited: Specifies if the license unit count is unlimited.
        :param builtins.bool is_vendor_oracle: Specifies whether the vendor is Oracle or a third party.
        :param builtins.str license_unit: The product license unit.
        :param builtins.str state: The current product license state.
        :param builtins.str status: The current product license status.
        :param builtins.str status_description: Status description for the current product license status.
        :param Mapping[str, builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_created: The time the product license was created. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        :param builtins.str time_updated: The time the product license was updated. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        :param builtins.int total_active_license_unit_count: The total number of licenses available for the product license, calculated by adding up all the license counts for active license records associated with the product license.
        :param builtins.int total_license_record_count: The number of license records associated with the product license.
        :param builtins.float total_license_units_consumed: The number of license units consumed. Updated after each allocation run.
        :param builtins.str vendor_name: The vendor of the ProductLicense
        """
        pulumi.set(__self__, "active_license_record_count", active_license_record_count)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "images", images)
        pulumi.set(__self__, "is_over_subscribed", is_over_subscribed)
        pulumi.set(__self__, "is_unlimited", is_unlimited)
        pulumi.set(__self__, "is_vendor_oracle", is_vendor_oracle)
        pulumi.set(__self__, "license_unit", license_unit)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_description", status_description)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "total_active_license_unit_count", total_active_license_unit_count)
        pulumi.set(__self__, "total_license_record_count", total_license_record_count)
        pulumi.set(__self__, "total_license_units_consumed", total_license_units_consumed)
        pulumi.set(__self__, "vendor_name", vendor_name)

    @property
    @pulumi.getter(name="activeLicenseRecordCount")
    def active_license_record_count(self) -> builtins.int:
        """
        The number of active license records associated with the product license.
        """
        return pulumi.get(self, "active_license_record_count")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) used for the license record, product license, and configuration.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        License record name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The image ID associated with the product license.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def images(self) -> Sequence['outputs.GetProductLicensesProductLicenseCollectionItemImageResult']:
        """
        The images associated with the product license.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter(name="isOverSubscribed")
    def is_over_subscribed(self) -> builtins.bool:
        """
        Specifies whether or not the product license is oversubscribed.
        """
        return pulumi.get(self, "is_over_subscribed")

    @property
    @pulumi.getter(name="isUnlimited")
    def is_unlimited(self) -> builtins.bool:
        """
        Specifies if the license unit count is unlimited.
        """
        return pulumi.get(self, "is_unlimited")

    @property
    @pulumi.getter(name="isVendorOracle")
    def is_vendor_oracle(self) -> builtins.bool:
        """
        Specifies whether the vendor is Oracle or a third party.
        """
        return pulumi.get(self, "is_vendor_oracle")

    @property
    @pulumi.getter(name="licenseUnit")
    def license_unit(self) -> builtins.str:
        """
        The product license unit.
        """
        return pulumi.get(self, "license_unit")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current product license state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The current product license status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusDescription")
    def status_description(self) -> builtins.str:
        """
        Status description for the current product license status.
        """
        return pulumi.get(self, "status_description")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the product license was created. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the product license was updated. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="totalActiveLicenseUnitCount")
    def total_active_license_unit_count(self) -> builtins.int:
        """
        The total number of licenses available for the product license, calculated by adding up all the license counts for active license records associated with the product license.
        """
        return pulumi.get(self, "total_active_license_unit_count")

    @property
    @pulumi.getter(name="totalLicenseRecordCount")
    def total_license_record_count(self) -> builtins.int:
        """
        The number of license records associated with the product license.
        """
        return pulumi.get(self, "total_license_record_count")

    @property
    @pulumi.getter(name="totalLicenseUnitsConsumed")
    def total_license_units_consumed(self) -> builtins.float:
        """
        The number of license units consumed. Updated after each allocation run.
        """
        return pulumi.get(self, "total_license_units_consumed")

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> builtins.str:
        """
        The vendor of the ProductLicense
        """
        return pulumi.get(self, "vendor_name")


@pulumi.output_type
class GetProductLicensesProductLicenseCollectionItemImageResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 listing_id: builtins.str,
                 listing_name: builtins.str,
                 package_version: builtins.str,
                 publisher: builtins.str):
        """
        :param builtins.str id: The image ID associated with the product license.
        :param builtins.str listing_id: The image listing ID.
        :param builtins.str listing_name: The listing name associated with the product license.
        :param builtins.str package_version: The image package version.
        :param builtins.str publisher: The image publisher.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "listing_id", listing_id)
        pulumi.set(__self__, "listing_name", listing_name)
        pulumi.set(__self__, "package_version", package_version)
        pulumi.set(__self__, "publisher", publisher)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The image ID associated with the product license.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> builtins.str:
        """
        The image listing ID.
        """
        return pulumi.get(self, "listing_id")

    @property
    @pulumi.getter(name="listingName")
    def listing_name(self) -> builtins.str:
        """
        The listing name associated with the product license.
        """
        return pulumi.get(self, "listing_name")

    @property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> builtins.str:
        """
        The image package version.
        """
        return pulumi.get(self, "package_version")

    @property
    @pulumi.getter
    def publisher(self) -> builtins.str:
        """
        The image publisher.
        """
        return pulumi.get(self, "publisher")


@pulumi.output_type
class GetTopUtilizedProductLicensesItemResult(dict):
    def __init__(__self__, *,
                 is_unlimited: builtins.bool,
                 product_license_id: builtins.str,
                 product_type: builtins.str,
                 status: builtins.str,
                 total_license_unit_count: builtins.int,
                 total_units_consumed: builtins.float,
                 unit_type: builtins.str):
        """
        :param builtins.bool is_unlimited: Specifies if the license unit count is unlimited.
        :param builtins.str product_license_id: The product license [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param builtins.str product_type: The product type.
        :param builtins.str status: The current product license status.
        :param builtins.int total_license_unit_count: Total number of license units in the product license provided by the user.
        :param builtins.float total_units_consumed: Number of license units consumed.
        :param builtins.str unit_type: The product license unit.
        """
        pulumi.set(__self__, "is_unlimited", is_unlimited)
        pulumi.set(__self__, "product_license_id", product_license_id)
        pulumi.set(__self__, "product_type", product_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "total_license_unit_count", total_license_unit_count)
        pulumi.set(__self__, "total_units_consumed", total_units_consumed)
        pulumi.set(__self__, "unit_type", unit_type)

    @property
    @pulumi.getter(name="isUnlimited")
    def is_unlimited(self) -> builtins.bool:
        """
        Specifies if the license unit count is unlimited.
        """
        return pulumi.get(self, "is_unlimited")

    @property
    @pulumi.getter(name="productLicenseId")
    def product_license_id(self) -> builtins.str:
        """
        The product license [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "product_license_id")

    @property
    @pulumi.getter(name="productType")
    def product_type(self) -> builtins.str:
        """
        The product type.
        """
        return pulumi.get(self, "product_type")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The current product license status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="totalLicenseUnitCount")
    def total_license_unit_count(self) -> builtins.int:
        """
        Total number of license units in the product license provided by the user.
        """
        return pulumi.get(self, "total_license_unit_count")

    @property
    @pulumi.getter(name="totalUnitsConsumed")
    def total_units_consumed(self) -> builtins.float:
        """
        Number of license units consumed.
        """
        return pulumi.get(self, "total_units_consumed")

    @property
    @pulumi.getter(name="unitType")
    def unit_type(self) -> builtins.str:
        """
        The product license unit.
        """
        return pulumi.get(self, "unit_type")


@pulumi.output_type
class GetTopUtilizedResourcesItemResult(dict):
    def __init__(__self__, *,
                 resource_compartment_id: builtins.str,
                 resource_compartment_name: builtins.str,
                 resource_id: builtins.str,
                 resource_name: builtins.str,
                 total_units: builtins.float,
                 unit_type: builtins.str):
        """
        :param builtins.str resource_compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that contains the resource.
        :param builtins.str resource_compartment_name: The display name of the compartment that contains the resource.
        :param builtins.str resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource.
        :param builtins.str resource_name: Resource canonical name.
        :param builtins.float total_units: Number of license units consumed by the resource.
        :param builtins.str unit_type: The resource unit.
        """
        pulumi.set(__self__, "resource_compartment_id", resource_compartment_id)
        pulumi.set(__self__, "resource_compartment_name", resource_compartment_name)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_name", resource_name)
        pulumi.set(__self__, "total_units", total_units)
        pulumi.set(__self__, "unit_type", unit_type)

    @property
    @pulumi.getter(name="resourceCompartmentId")
    def resource_compartment_id(self) -> builtins.str:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that contains the resource.
        """
        return pulumi.get(self, "resource_compartment_id")

    @property
    @pulumi.getter(name="resourceCompartmentName")
    def resource_compartment_name(self) -> builtins.str:
        """
        The display name of the compartment that contains the resource.
        """
        return pulumi.get(self, "resource_compartment_name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> builtins.str:
        """
        Resource canonical name.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="totalUnits")
    def total_units(self) -> builtins.float:
        """
        Number of license units consumed by the resource.
        """
        return pulumi.get(self, "total_units")

    @property
    @pulumi.getter(name="unitType")
    def unit_type(self) -> builtins.str:
        """
        The resource unit.
        """
        return pulumi.get(self, "unit_type")


