# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetLogAnalyticsEntitiesResult',
    'AwaitableGetLogAnalyticsEntitiesResult',
    'get_log_analytics_entities',
    'get_log_analytics_entities_output',
]

@pulumi.output_type
class GetLogAnalyticsEntitiesResult:
    """
    A collection of values returned by getLogAnalyticsEntities.
    """
    def __init__(__self__, cloud_resource_id=None, compartment_id=None, defined_tag_equals=None, defined_tag_exists=None, entity_type_names=None, filters=None, freeform_tag_equals=None, freeform_tag_exists=None, hostname=None, hostname_contains=None, id=None, is_management_agent_id_null=None, is_show_associated_sources_count=None, lifecycle_details_contains=None, log_analytics_entity_collections=None, metadata_equals=None, name=None, name_contains=None, namespace=None, source_id=None, state=None):
        if cloud_resource_id and not isinstance(cloud_resource_id, str):
            raise TypeError("Expected argument 'cloud_resource_id' to be a str")
        pulumi.set(__self__, "cloud_resource_id", cloud_resource_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tag_equals and not isinstance(defined_tag_equals, list):
            raise TypeError("Expected argument 'defined_tag_equals' to be a list")
        pulumi.set(__self__, "defined_tag_equals", defined_tag_equals)
        if defined_tag_exists and not isinstance(defined_tag_exists, list):
            raise TypeError("Expected argument 'defined_tag_exists' to be a list")
        pulumi.set(__self__, "defined_tag_exists", defined_tag_exists)
        if entity_type_names and not isinstance(entity_type_names, list):
            raise TypeError("Expected argument 'entity_type_names' to be a list")
        pulumi.set(__self__, "entity_type_names", entity_type_names)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if freeform_tag_equals and not isinstance(freeform_tag_equals, list):
            raise TypeError("Expected argument 'freeform_tag_equals' to be a list")
        pulumi.set(__self__, "freeform_tag_equals", freeform_tag_equals)
        if freeform_tag_exists and not isinstance(freeform_tag_exists, list):
            raise TypeError("Expected argument 'freeform_tag_exists' to be a list")
        pulumi.set(__self__, "freeform_tag_exists", freeform_tag_exists)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if hostname_contains and not isinstance(hostname_contains, str):
            raise TypeError("Expected argument 'hostname_contains' to be a str")
        pulumi.set(__self__, "hostname_contains", hostname_contains)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_management_agent_id_null and not isinstance(is_management_agent_id_null, str):
            raise TypeError("Expected argument 'is_management_agent_id_null' to be a str")
        pulumi.set(__self__, "is_management_agent_id_null", is_management_agent_id_null)
        if is_show_associated_sources_count and not isinstance(is_show_associated_sources_count, bool):
            raise TypeError("Expected argument 'is_show_associated_sources_count' to be a bool")
        pulumi.set(__self__, "is_show_associated_sources_count", is_show_associated_sources_count)
        if lifecycle_details_contains and not isinstance(lifecycle_details_contains, str):
            raise TypeError("Expected argument 'lifecycle_details_contains' to be a str")
        pulumi.set(__self__, "lifecycle_details_contains", lifecycle_details_contains)
        if log_analytics_entity_collections and not isinstance(log_analytics_entity_collections, list):
            raise TypeError("Expected argument 'log_analytics_entity_collections' to be a list")
        pulumi.set(__self__, "log_analytics_entity_collections", log_analytics_entity_collections)
        if metadata_equals and not isinstance(metadata_equals, list):
            raise TypeError("Expected argument 'metadata_equals' to be a list")
        pulumi.set(__self__, "metadata_equals", metadata_equals)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_contains and not isinstance(name_contains, str):
            raise TypeError("Expected argument 'name_contains' to be a str")
        pulumi.set(__self__, "name_contains", name_contains)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if source_id and not isinstance(source_id, str):
            raise TypeError("Expected argument 'source_id' to be a str")
        pulumi.set(__self__, "source_id", source_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="cloudResourceId")
    def cloud_resource_id(self) -> Optional[builtins.str]:
        """
        The OCID of the Cloud resource which this entity is a representation of. This may be blank when the entity represents a non-cloud resource that the customer may have on their premises.
        """
        return pulumi.get(self, "cloud_resource_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTagEquals")
    def defined_tag_equals(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "defined_tag_equals")

    @property
    @pulumi.getter(name="definedTagExists")
    def defined_tag_exists(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "defined_tag_exists")

    @property
    @pulumi.getter(name="entityTypeNames")
    def entity_type_names(self) -> Optional[Sequence[builtins.str]]:
        """
        Log analytics entity type name.
        """
        return pulumi.get(self, "entity_type_names")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetLogAnalyticsEntitiesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="freeformTagEquals")
    def freeform_tag_equals(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "freeform_tag_equals")

    @property
    @pulumi.getter(name="freeformTagExists")
    def freeform_tag_exists(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "freeform_tag_exists")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[builtins.str]:
        """
        The hostname where the entity represented here is actually present. This would be the output one would get if they run `echo $HOSTNAME` on Linux or an equivalent OS command. This may be different from management agents host since logs may be collected remotely.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="hostnameContains")
    def hostname_contains(self) -> Optional[builtins.str]:
        return pulumi.get(self, "hostname_contains")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isManagementAgentIdNull")
    def is_management_agent_id_null(self) -> Optional[builtins.str]:
        return pulumi.get(self, "is_management_agent_id_null")

    @property
    @pulumi.getter(name="isShowAssociatedSourcesCount")
    def is_show_associated_sources_count(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "is_show_associated_sources_count")

    @property
    @pulumi.getter(name="lifecycleDetailsContains")
    def lifecycle_details_contains(self) -> Optional[builtins.str]:
        return pulumi.get(self, "lifecycle_details_contains")

    @property
    @pulumi.getter(name="logAnalyticsEntityCollections")
    def log_analytics_entity_collections(self) -> Sequence['outputs.GetLogAnalyticsEntitiesLogAnalyticsEntityCollectionResult']:
        """
        The list of log_analytics_entity_collection.
        """
        return pulumi.get(self, "log_analytics_entity_collections")

    @property
    @pulumi.getter(name="metadataEquals")
    def metadata_equals(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "metadata_equals")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Log analytics entity name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameContains")
    def name_contains(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name_contains")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[builtins.str]:
        """
        This indicates the type of source. It is primarily for Enterprise Manager Repository ID.
        """
        return pulumi.get(self, "source_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the log analytics entity.
        """
        return pulumi.get(self, "state")


class AwaitableGetLogAnalyticsEntitiesResult(GetLogAnalyticsEntitiesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogAnalyticsEntitiesResult(
            cloud_resource_id=self.cloud_resource_id,
            compartment_id=self.compartment_id,
            defined_tag_equals=self.defined_tag_equals,
            defined_tag_exists=self.defined_tag_exists,
            entity_type_names=self.entity_type_names,
            filters=self.filters,
            freeform_tag_equals=self.freeform_tag_equals,
            freeform_tag_exists=self.freeform_tag_exists,
            hostname=self.hostname,
            hostname_contains=self.hostname_contains,
            id=self.id,
            is_management_agent_id_null=self.is_management_agent_id_null,
            is_show_associated_sources_count=self.is_show_associated_sources_count,
            lifecycle_details_contains=self.lifecycle_details_contains,
            log_analytics_entity_collections=self.log_analytics_entity_collections,
            metadata_equals=self.metadata_equals,
            name=self.name,
            name_contains=self.name_contains,
            namespace=self.namespace,
            source_id=self.source_id,
            state=self.state)


def get_log_analytics_entities(cloud_resource_id: Optional[builtins.str] = None,
                               compartment_id: Optional[builtins.str] = None,
                               defined_tag_equals: Optional[Sequence[builtins.str]] = None,
                               defined_tag_exists: Optional[Sequence[builtins.str]] = None,
                               entity_type_names: Optional[Sequence[builtins.str]] = None,
                               filters: Optional[Sequence[Union['GetLogAnalyticsEntitiesFilterArgs', 'GetLogAnalyticsEntitiesFilterArgsDict']]] = None,
                               freeform_tag_equals: Optional[Sequence[builtins.str]] = None,
                               freeform_tag_exists: Optional[Sequence[builtins.str]] = None,
                               hostname: Optional[builtins.str] = None,
                               hostname_contains: Optional[builtins.str] = None,
                               is_management_agent_id_null: Optional[builtins.str] = None,
                               is_show_associated_sources_count: Optional[builtins.bool] = None,
                               lifecycle_details_contains: Optional[builtins.str] = None,
                               metadata_equals: Optional[Sequence[builtins.str]] = None,
                               name: Optional[builtins.str] = None,
                               name_contains: Optional[builtins.str] = None,
                               namespace: Optional[builtins.str] = None,
                               source_id: Optional[builtins.str] = None,
                               state: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogAnalyticsEntitiesResult:
    """
    This data source provides the list of Log Analytics Entities in Oracle Cloud Infrastructure Log Analytics service.

    Return a list of log analytics entities.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_entities = oci.LogAnalytics.get_log_analytics_entities(compartment_id=compartment_id,
        namespace=log_analytics_entity_namespace,
        cloud_resource_id=log_analytics_entity_cloud_resource_id,
        defined_tag_equals=log_analytics_entity_defined_tag_equals,
        defined_tag_exists=log_analytics_entity_defined_tag_exists,
        entity_type_names=log_analytics_entity_entity_type_name,
        freeform_tag_equals=log_analytics_entity_freeform_tag_equals,
        freeform_tag_exists=log_analytics_entity_freeform_tag_exists,
        hostname=log_analytics_entity_hostname,
        hostname_contains=log_analytics_entity_hostname_contains,
        is_management_agent_id_null=log_analytics_entity_is_management_agent_id_null,
        is_show_associated_sources_count=log_analytics_entity_is_show_associated_sources_count,
        lifecycle_details_contains=log_analytics_entity_lifecycle_details_contains,
        metadata_equals=log_analytics_entity_metadata_equals,
        name=log_analytics_entity_name,
        name_contains=log_analytics_entity_name_contains,
        source_id=test_source["id"],
        state=log_analytics_entity_state)
    ```


    :param builtins.str cloud_resource_id: A filter to return only log analytics entities whose cloudResourceId matches the cloudResourceId given.
    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param Sequence[builtins.str] defined_tag_equals: A list of tag filters to apply.  Only entities with a defined tag matching the value will be returned. Each item in the list has the format "{namespace}.{tagName}.{value}".  All inputs are case-insensitive. Multiple values for the same key (i.e. same namespace and tag name) are interpreted as "OR". Values for different keys (i.e. different namespaces, different tag names, or both) are interpreted as "AND".
    :param Sequence[builtins.str] defined_tag_exists: A list of tag existence filters to apply.  Only entities for which the specified defined tags exist will be returned. Each item in the list has the format "{namespace}.{tagName}.true" (for checking existence of a defined tag) or "{namespace}.true".  All inputs are case-insensitive. Currently, only existence ("true" at the end) is supported. Absence ("false" at the end) is not supported. Multiple values for the same key (i.e. same namespace and tag name) are interpreted as "OR". Values for different keys (i.e. different namespaces, different tag names, or both) are interpreted as "AND".
    :param Sequence[builtins.str] entity_type_names: A filter to return only log analytics entities whose entityTypeName matches the entire log analytics entity type name of one of the entityTypeNames given in the list. The match is case-insensitive.
    :param Sequence[builtins.str] freeform_tag_equals: A list of tag filters to apply.  Only entities with a freeform tag matching the value will be returned. The key for each tag is "{tagName}.{value}".  All inputs are case-insensitive. Multiple values for the same tag name are interpreted as "OR".  Values for different tag names are interpreted as "AND".
    :param Sequence[builtins.str] freeform_tag_exists: A list of tag existence filters to apply.  Only entities for which the specified freeform tags exist the value will be returned. The key for each tag is "{tagName}.true".  All inputs are case-insensitive. Currently, only existence ("true" at the end) is supported. Absence ("false" at the end) is not supported. Multiple values for different tag names are interpreted as "AND".
    :param builtins.str hostname: A filter to return only log analytics entities whose hostname matches the entire hostname given.
    :param builtins.str hostname_contains: A filter to return only log analytics entities whose hostname contains the substring given. The match is case-insensitive.
    :param builtins.str is_management_agent_id_null: A filter to return only those log analytics entities whose managementAgentId is null or is not null.
    :param builtins.bool is_show_associated_sources_count: Option to return count of associated log sources for log analytics entity(s).
    :param builtins.str lifecycle_details_contains: A filter to return only log analytics entities whose lifecycleDetails contains the specified string.
    :param Sequence[builtins.str] metadata_equals: A filter to return only log analytics entities whose metadata name, value and type matches the specified string. Each item in the array has the format "{name}:{value}:{type}".  All inputs are case-insensitive.
    :param builtins.str name: A filter to return only log analytics entities whose name matches the entire name given. The match is case-insensitive.
    :param builtins.str name_contains: A filter to return only log analytics entities whose name contains the name given. The match is case-insensitive.
    :param builtins.str namespace: The Logging Analytics namespace used for the request.
    :param builtins.str source_id: A filter to return only log analytics entities whose sourceId matches the sourceId given.
    :param builtins.str state: A filter to return only those log analytics entities with the specified lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['cloudResourceId'] = cloud_resource_id
    __args__['compartmentId'] = compartment_id
    __args__['definedTagEquals'] = defined_tag_equals
    __args__['definedTagExists'] = defined_tag_exists
    __args__['entityTypeNames'] = entity_type_names
    __args__['filters'] = filters
    __args__['freeformTagEquals'] = freeform_tag_equals
    __args__['freeformTagExists'] = freeform_tag_exists
    __args__['hostname'] = hostname
    __args__['hostnameContains'] = hostname_contains
    __args__['isManagementAgentIdNull'] = is_management_agent_id_null
    __args__['isShowAssociatedSourcesCount'] = is_show_associated_sources_count
    __args__['lifecycleDetailsContains'] = lifecycle_details_contains
    __args__['metadataEquals'] = metadata_equals
    __args__['name'] = name
    __args__['nameContains'] = name_contains
    __args__['namespace'] = namespace
    __args__['sourceId'] = source_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getLogAnalyticsEntities:getLogAnalyticsEntities', __args__, opts=opts, typ=GetLogAnalyticsEntitiesResult).value

    return AwaitableGetLogAnalyticsEntitiesResult(
        cloud_resource_id=pulumi.get(__ret__, 'cloud_resource_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tag_equals=pulumi.get(__ret__, 'defined_tag_equals'),
        defined_tag_exists=pulumi.get(__ret__, 'defined_tag_exists'),
        entity_type_names=pulumi.get(__ret__, 'entity_type_names'),
        filters=pulumi.get(__ret__, 'filters'),
        freeform_tag_equals=pulumi.get(__ret__, 'freeform_tag_equals'),
        freeform_tag_exists=pulumi.get(__ret__, 'freeform_tag_exists'),
        hostname=pulumi.get(__ret__, 'hostname'),
        hostname_contains=pulumi.get(__ret__, 'hostname_contains'),
        id=pulumi.get(__ret__, 'id'),
        is_management_agent_id_null=pulumi.get(__ret__, 'is_management_agent_id_null'),
        is_show_associated_sources_count=pulumi.get(__ret__, 'is_show_associated_sources_count'),
        lifecycle_details_contains=pulumi.get(__ret__, 'lifecycle_details_contains'),
        log_analytics_entity_collections=pulumi.get(__ret__, 'log_analytics_entity_collections'),
        metadata_equals=pulumi.get(__ret__, 'metadata_equals'),
        name=pulumi.get(__ret__, 'name'),
        name_contains=pulumi.get(__ret__, 'name_contains'),
        namespace=pulumi.get(__ret__, 'namespace'),
        source_id=pulumi.get(__ret__, 'source_id'),
        state=pulumi.get(__ret__, 'state'))
def get_log_analytics_entities_output(cloud_resource_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                      defined_tag_equals: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                      defined_tag_exists: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                      entity_type_names: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetLogAnalyticsEntitiesFilterArgs', 'GetLogAnalyticsEntitiesFilterArgsDict']]]]] = None,
                                      freeform_tag_equals: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                      freeform_tag_exists: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                      hostname: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      hostname_contains: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      is_management_agent_id_null: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      is_show_associated_sources_count: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                      lifecycle_details_contains: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      metadata_equals: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                      name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      name_contains: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      namespace: Optional[pulumi.Input[builtins.str]] = None,
                                      source_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogAnalyticsEntitiesResult]:
    """
    This data source provides the list of Log Analytics Entities in Oracle Cloud Infrastructure Log Analytics service.

    Return a list of log analytics entities.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_entities = oci.LogAnalytics.get_log_analytics_entities(compartment_id=compartment_id,
        namespace=log_analytics_entity_namespace,
        cloud_resource_id=log_analytics_entity_cloud_resource_id,
        defined_tag_equals=log_analytics_entity_defined_tag_equals,
        defined_tag_exists=log_analytics_entity_defined_tag_exists,
        entity_type_names=log_analytics_entity_entity_type_name,
        freeform_tag_equals=log_analytics_entity_freeform_tag_equals,
        freeform_tag_exists=log_analytics_entity_freeform_tag_exists,
        hostname=log_analytics_entity_hostname,
        hostname_contains=log_analytics_entity_hostname_contains,
        is_management_agent_id_null=log_analytics_entity_is_management_agent_id_null,
        is_show_associated_sources_count=log_analytics_entity_is_show_associated_sources_count,
        lifecycle_details_contains=log_analytics_entity_lifecycle_details_contains,
        metadata_equals=log_analytics_entity_metadata_equals,
        name=log_analytics_entity_name,
        name_contains=log_analytics_entity_name_contains,
        source_id=test_source["id"],
        state=log_analytics_entity_state)
    ```


    :param builtins.str cloud_resource_id: A filter to return only log analytics entities whose cloudResourceId matches the cloudResourceId given.
    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param Sequence[builtins.str] defined_tag_equals: A list of tag filters to apply.  Only entities with a defined tag matching the value will be returned. Each item in the list has the format "{namespace}.{tagName}.{value}".  All inputs are case-insensitive. Multiple values for the same key (i.e. same namespace and tag name) are interpreted as "OR". Values for different keys (i.e. different namespaces, different tag names, or both) are interpreted as "AND".
    :param Sequence[builtins.str] defined_tag_exists: A list of tag existence filters to apply.  Only entities for which the specified defined tags exist will be returned. Each item in the list has the format "{namespace}.{tagName}.true" (for checking existence of a defined tag) or "{namespace}.true".  All inputs are case-insensitive. Currently, only existence ("true" at the end) is supported. Absence ("false" at the end) is not supported. Multiple values for the same key (i.e. same namespace and tag name) are interpreted as "OR". Values for different keys (i.e. different namespaces, different tag names, or both) are interpreted as "AND".
    :param Sequence[builtins.str] entity_type_names: A filter to return only log analytics entities whose entityTypeName matches the entire log analytics entity type name of one of the entityTypeNames given in the list. The match is case-insensitive.
    :param Sequence[builtins.str] freeform_tag_equals: A list of tag filters to apply.  Only entities with a freeform tag matching the value will be returned. The key for each tag is "{tagName}.{value}".  All inputs are case-insensitive. Multiple values for the same tag name are interpreted as "OR".  Values for different tag names are interpreted as "AND".
    :param Sequence[builtins.str] freeform_tag_exists: A list of tag existence filters to apply.  Only entities for which the specified freeform tags exist the value will be returned. The key for each tag is "{tagName}.true".  All inputs are case-insensitive. Currently, only existence ("true" at the end) is supported. Absence ("false" at the end) is not supported. Multiple values for different tag names are interpreted as "AND".
    :param builtins.str hostname: A filter to return only log analytics entities whose hostname matches the entire hostname given.
    :param builtins.str hostname_contains: A filter to return only log analytics entities whose hostname contains the substring given. The match is case-insensitive.
    :param builtins.str is_management_agent_id_null: A filter to return only those log analytics entities whose managementAgentId is null or is not null.
    :param builtins.bool is_show_associated_sources_count: Option to return count of associated log sources for log analytics entity(s).
    :param builtins.str lifecycle_details_contains: A filter to return only log analytics entities whose lifecycleDetails contains the specified string.
    :param Sequence[builtins.str] metadata_equals: A filter to return only log analytics entities whose metadata name, value and type matches the specified string. Each item in the array has the format "{name}:{value}:{type}".  All inputs are case-insensitive.
    :param builtins.str name: A filter to return only log analytics entities whose name matches the entire name given. The match is case-insensitive.
    :param builtins.str name_contains: A filter to return only log analytics entities whose name contains the name given. The match is case-insensitive.
    :param builtins.str namespace: The Logging Analytics namespace used for the request.
    :param builtins.str source_id: A filter to return only log analytics entities whose sourceId matches the sourceId given.
    :param builtins.str state: A filter to return only those log analytics entities with the specified lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['cloudResourceId'] = cloud_resource_id
    __args__['compartmentId'] = compartment_id
    __args__['definedTagEquals'] = defined_tag_equals
    __args__['definedTagExists'] = defined_tag_exists
    __args__['entityTypeNames'] = entity_type_names
    __args__['filters'] = filters
    __args__['freeformTagEquals'] = freeform_tag_equals
    __args__['freeformTagExists'] = freeform_tag_exists
    __args__['hostname'] = hostname
    __args__['hostnameContains'] = hostname_contains
    __args__['isManagementAgentIdNull'] = is_management_agent_id_null
    __args__['isShowAssociatedSourcesCount'] = is_show_associated_sources_count
    __args__['lifecycleDetailsContains'] = lifecycle_details_contains
    __args__['metadataEquals'] = metadata_equals
    __args__['name'] = name
    __args__['nameContains'] = name_contains
    __args__['namespace'] = namespace
    __args__['sourceId'] = source_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:LogAnalytics/getLogAnalyticsEntities:getLogAnalyticsEntities', __args__, opts=opts, typ=GetLogAnalyticsEntitiesResult)
    return __ret__.apply(lambda __response__: GetLogAnalyticsEntitiesResult(
        cloud_resource_id=pulumi.get(__response__, 'cloud_resource_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tag_equals=pulumi.get(__response__, 'defined_tag_equals'),
        defined_tag_exists=pulumi.get(__response__, 'defined_tag_exists'),
        entity_type_names=pulumi.get(__response__, 'entity_type_names'),
        filters=pulumi.get(__response__, 'filters'),
        freeform_tag_equals=pulumi.get(__response__, 'freeform_tag_equals'),
        freeform_tag_exists=pulumi.get(__response__, 'freeform_tag_exists'),
        hostname=pulumi.get(__response__, 'hostname'),
        hostname_contains=pulumi.get(__response__, 'hostname_contains'),
        id=pulumi.get(__response__, 'id'),
        is_management_agent_id_null=pulumi.get(__response__, 'is_management_agent_id_null'),
        is_show_associated_sources_count=pulumi.get(__response__, 'is_show_associated_sources_count'),
        lifecycle_details_contains=pulumi.get(__response__, 'lifecycle_details_contains'),
        log_analytics_entity_collections=pulumi.get(__response__, 'log_analytics_entity_collections'),
        metadata_equals=pulumi.get(__response__, 'metadata_equals'),
        name=pulumi.get(__response__, 'name'),
        name_contains=pulumi.get(__response__, 'name_contains'),
        namespace=pulumi.get(__response__, 'namespace'),
        source_id=pulumi.get(__response__, 'source_id'),
        state=pulumi.get(__response__, 'state')))
