# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNamespaceStorageArchivalConfigResult',
    'AwaitableGetNamespaceStorageArchivalConfigResult',
    'get_namespace_storage_archival_config',
    'get_namespace_storage_archival_config_output',
]

@pulumi.output_type
class GetNamespaceStorageArchivalConfigResult:
    """
    A collection of values returned by getNamespaceStorageArchivalConfig.
    """
    def __init__(__self__, archiving_configurations=None, id=None, is_archiving_enabled=None, namespace=None):
        if archiving_configurations and not isinstance(archiving_configurations, list):
            raise TypeError("Expected argument 'archiving_configurations' to be a list")
        pulumi.set(__self__, "archiving_configurations", archiving_configurations)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_archiving_enabled and not isinstance(is_archiving_enabled, bool):
            raise TypeError("Expected argument 'is_archiving_enabled' to be a bool")
        pulumi.set(__self__, "is_archiving_enabled", is_archiving_enabled)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="archivingConfigurations")
    def archiving_configurations(self) -> Sequence['outputs.GetNamespaceStorageArchivalConfigArchivingConfigurationResult']:
        """
        This is the configuration for data archiving in object storage
        """
        return pulumi.get(self, "archiving_configurations")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isArchivingEnabled")
    def is_archiving_enabled(self) -> builtins.bool:
        """
        This indicates if old data can be archived for a tenancy
        """
        return pulumi.get(self, "is_archiving_enabled")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        return pulumi.get(self, "namespace")


class AwaitableGetNamespaceStorageArchivalConfigResult(GetNamespaceStorageArchivalConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNamespaceStorageArchivalConfigResult(
            archiving_configurations=self.archiving_configurations,
            id=self.id,
            is_archiving_enabled=self.is_archiving_enabled,
            namespace=self.namespace)


def get_namespace_storage_archival_config(namespace: Optional[builtins.str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNamespaceStorageArchivalConfigResult:
    """
    This data source provides details about a specific Namespace Storage Archival Config resource in Oracle Cloud Infrastructure Log Analytics service.

    This API gets the storage configuration of a tenancy

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_namespace_storage_archival_config = oci.LogAnalytics.get_namespace_storage_archival_config(namespace=namespace_storage_archival_config_namespace)
    ```


    :param builtins.str namespace: The Logging Analytics namespace used for the request.
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getNamespaceStorageArchivalConfig:getNamespaceStorageArchivalConfig', __args__, opts=opts, typ=GetNamespaceStorageArchivalConfigResult).value

    return AwaitableGetNamespaceStorageArchivalConfigResult(
        archiving_configurations=pulumi.get(__ret__, 'archiving_configurations'),
        id=pulumi.get(__ret__, 'id'),
        is_archiving_enabled=pulumi.get(__ret__, 'is_archiving_enabled'),
        namespace=pulumi.get(__ret__, 'namespace'))
def get_namespace_storage_archival_config_output(namespace: Optional[pulumi.Input[builtins.str]] = None,
                                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNamespaceStorageArchivalConfigResult]:
    """
    This data source provides details about a specific Namespace Storage Archival Config resource in Oracle Cloud Infrastructure Log Analytics service.

    This API gets the storage configuration of a tenancy

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_namespace_storage_archival_config = oci.LogAnalytics.get_namespace_storage_archival_config(namespace=namespace_storage_archival_config_namespace)
    ```


    :param builtins.str namespace: The Logging Analytics namespace used for the request.
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:LogAnalytics/getNamespaceStorageArchivalConfig:getNamespaceStorageArchivalConfig', __args__, opts=opts, typ=GetNamespaceStorageArchivalConfigResult)
    return __ret__.apply(lambda __response__: GetNamespaceStorageArchivalConfigResult(
        archiving_configurations=pulumi.get(__response__, 'archiving_configurations'),
        id=pulumi.get(__response__, 'id'),
        is_archiving_enabled=pulumi.get(__response__, 'is_archiving_enabled'),
        namespace=pulumi.get(__response__, 'namespace')))
