# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMysqlBackupsResult',
    'AwaitableGetMysqlBackupsResult',
    'get_mysql_backups',
    'get_mysql_backups_output',
]

@pulumi.output_type
class GetMysqlBackupsResult:
    """
    A collection of values returned by getMysqlBackups.
    """
    def __init__(__self__, backup_id=None, backups=None, compartment_id=None, creation_type=None, db_system_id=None, display_name=None, filters=None, id=None, soft_delete=None, state=None):
        if backup_id and not isinstance(backup_id, str):
            raise TypeError("Expected argument 'backup_id' to be a str")
        pulumi.set(__self__, "backup_id", backup_id)
        if backups and not isinstance(backups, list):
            raise TypeError("Expected argument 'backups' to be a list")
        pulumi.set(__self__, "backups", backups)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if creation_type and not isinstance(creation_type, str):
            raise TypeError("Expected argument 'creation_type' to be a str")
        pulumi.set(__self__, "creation_type", creation_type)
        if db_system_id and not isinstance(db_system_id, str):
            raise TypeError("Expected argument 'db_system_id' to be a str")
        pulumi.set(__self__, "db_system_id", db_system_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if soft_delete and not isinstance(soft_delete, str):
            raise TypeError("Expected argument 'soft_delete' to be a str")
        pulumi.set(__self__, "soft_delete", soft_delete)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter
    def backups(self) -> Sequence['outputs.GetMysqlBackupsBackupResult']:
        """
        The list of backups.
        """
        return pulumi.get(self, "backups")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment the DB System belongs in.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="creationType")
    def creation_type(self) -> Optional[builtins.str]:
        """
        Indicates how the backup was created: manually, automatic, or by an Operator.
        """
        return pulumi.get(self, "creation_type")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[builtins.str]:
        """
        The OCID of the DB System the backup is associated with.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-supplied display name for the backup.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMysqlBackupsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="softDelete")
    def soft_delete(self) -> Optional[builtins.str]:
        """
        Retains the backup to be deleted due to the retention policy in DELETE SCHEDULED state for 7 days before permanently deleting it.
        """
        return pulumi.get(self, "soft_delete")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The state of the backup.
        """
        return pulumi.get(self, "state")


class AwaitableGetMysqlBackupsResult(GetMysqlBackupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMysqlBackupsResult(
            backup_id=self.backup_id,
            backups=self.backups,
            compartment_id=self.compartment_id,
            creation_type=self.creation_type,
            db_system_id=self.db_system_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            soft_delete=self.soft_delete,
            state=self.state)


def get_mysql_backups(backup_id: Optional[builtins.str] = None,
                      compartment_id: Optional[builtins.str] = None,
                      creation_type: Optional[builtins.str] = None,
                      db_system_id: Optional[builtins.str] = None,
                      display_name: Optional[builtins.str] = None,
                      filters: Optional[Sequence[Union['GetMysqlBackupsFilterArgs', 'GetMysqlBackupsFilterArgsDict']]] = None,
                      soft_delete: Optional[builtins.str] = None,
                      state: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMysqlBackupsResult:
    """
    This data source provides the list of Mysql Backups in Oracle Cloud Infrastructure MySQL Database service.

    Get a list of DB System backups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_mysql_backups = oci.Mysql.get_mysql_backups(compartment_id=compartment_id,
        backup_id=test_backup["id"],
        creation_type=mysql_backup_creation_type,
        db_system_id=test_db_system["id"],
        display_name=mysql_backup_display_name,
        soft_delete=mysql_backup_soft_delete,
        state=mysql_backup_state)
    ```


    :param builtins.str backup_id: Backup OCID
    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str creation_type: Backup creationType
    :param builtins.str db_system_id: The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str display_name: A filter to return only the resource matching the given display name exactly.
    :param builtins.str soft_delete: Backup Soft Delete
    :param builtins.str state: Backup Lifecycle State
    """
    __args__ = dict()
    __args__['backupId'] = backup_id
    __args__['compartmentId'] = compartment_id
    __args__['creationType'] = creation_type
    __args__['dbSystemId'] = db_system_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['softDelete'] = soft_delete
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Mysql/getMysqlBackups:getMysqlBackups', __args__, opts=opts, typ=GetMysqlBackupsResult).value

    return AwaitableGetMysqlBackupsResult(
        backup_id=pulumi.get(__ret__, 'backup_id'),
        backups=pulumi.get(__ret__, 'backups'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        creation_type=pulumi.get(__ret__, 'creation_type'),
        db_system_id=pulumi.get(__ret__, 'db_system_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        soft_delete=pulumi.get(__ret__, 'soft_delete'),
        state=pulumi.get(__ret__, 'state'))
def get_mysql_backups_output(backup_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                             creation_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             db_system_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetMysqlBackupsFilterArgs', 'GetMysqlBackupsFilterArgsDict']]]]] = None,
                             soft_delete: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMysqlBackupsResult]:
    """
    This data source provides the list of Mysql Backups in Oracle Cloud Infrastructure MySQL Database service.

    Get a list of DB System backups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_mysql_backups = oci.Mysql.get_mysql_backups(compartment_id=compartment_id,
        backup_id=test_backup["id"],
        creation_type=mysql_backup_creation_type,
        db_system_id=test_db_system["id"],
        display_name=mysql_backup_display_name,
        soft_delete=mysql_backup_soft_delete,
        state=mysql_backup_state)
    ```


    :param builtins.str backup_id: Backup OCID
    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str creation_type: Backup creationType
    :param builtins.str db_system_id: The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str display_name: A filter to return only the resource matching the given display name exactly.
    :param builtins.str soft_delete: Backup Soft Delete
    :param builtins.str state: Backup Lifecycle State
    """
    __args__ = dict()
    __args__['backupId'] = backup_id
    __args__['compartmentId'] = compartment_id
    __args__['creationType'] = creation_type
    __args__['dbSystemId'] = db_system_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['softDelete'] = soft_delete
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Mysql/getMysqlBackups:getMysqlBackups', __args__, opts=opts, typ=GetMysqlBackupsResult)
    return __ret__.apply(lambda __response__: GetMysqlBackupsResult(
        backup_id=pulumi.get(__response__, 'backup_id'),
        backups=pulumi.get(__response__, 'backups'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        creation_type=pulumi.get(__response__, 'creation_type'),
        db_system_id=pulumi.get(__response__, 'db_system_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        soft_delete=pulumi.get(__response__, 'soft_delete'),
        state=pulumi.get(__response__, 'state')))
