# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StorageObjectArgs', 'StorageObject']

@pulumi.input_type
class StorageObjectArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[builtins.str],
                 namespace: pulumi.Input[builtins.str],
                 object: pulumi.Input[builtins.str],
                 cache_control: Optional[pulumi.Input[builtins.str]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 content_disposition: Optional[pulumi.Input[builtins.str]] = None,
                 content_encoding: Optional[pulumi.Input[builtins.str]] = None,
                 content_language: Optional[pulumi.Input[builtins.str]] = None,
                 content_md5: Optional[pulumi.Input[builtins.str]] = None,
                 content_type: Optional[pulumi.Input[builtins.str]] = None,
                 delete_all_object_versions: Optional[pulumi.Input[builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 opc_sse_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 source_uri_details: Optional[pulumi.Input['StorageObjectSourceUriDetailsArgs']] = None,
                 storage_tier: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a StorageObject resource.
        :param pulumi.Input[builtins.str] bucket: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
        :param pulumi.Input[builtins.str] namespace: The Object Storage namespace used for the request.
        :param pulumi.Input[builtins.str] object: (Updatable) The name of the object. Avoid entering confidential information. Example: `test/object1.log`
        :param pulumi.Input[builtins.str] cache_control: The optional Cache-Control header that defines the caching behavior value to be returned in GetObject and HeadObject responses. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to identify objects that require caching restrictions.
        :param pulumi.Input[builtins.str] content: The object to upload to the object store. Cannot be defined if `source` or `source_uri_details` is defined.
        :param pulumi.Input[builtins.str] content_disposition: The optional Content-Disposition header that defines presentational information for the object to be returned in GetObject and HeadObject responses. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to let users download objects with custom filenames in a browser.
        :param pulumi.Input[builtins.str] content_encoding: The optional Content-Encoding header that defines the content encodings that were applied to the object to upload. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to determine what decoding mechanisms need to be applied to obtain the media-type specified by the Content-Type header of the object.
        :param pulumi.Input[builtins.str] content_language: The optional Content-Language header that defines the content language of the object to upload. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to identify and differentiate objects based on a particular language.
        :param pulumi.Input[builtins.str] content_md5: (Updatable) The optional header that defines the base64-encoded MD5 hash of the body. If the optional Content-MD5 header is present, Object Storage performs an integrity check on the body of the HTTP request by computing the MD5 hash for the body and comparing it to the MD5 hash supplied in the header. If the two hashes do not match, the object is rejected and an HTTP-400 Unmatched Content MD5 error is returned with the message:
               
               "The computed MD5 of the request body (ACTUAL_MD5) does not match the Content-MD5 header (HEADER_MD5)"
        :param pulumi.Input[builtins.str] content_type: The optional Content-Type header that defines the standard MIME type format of the object. Content type defaults to 'application/octet-stream' if not specified in the PutObject call. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to identify and perform special operations on text only objects.
        :param pulumi.Input[builtins.bool] delete_all_object_versions: (Updatable) A boolean to delete all object versions for an object in a bucket that has or ever had versioning enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Optional user-defined metadata key and value.
               Note: All specified keys must be in lower case.
        :param pulumi.Input[builtins.str] opc_sse_kms_key_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a master encryption key used to call the Key Management service to generate a data encryption key or to encrypt or decrypt a data encryption key.
        :param pulumi.Input[builtins.str] source: An absolute path to a file on the local system. Cannot be defined if `content` or `source_uri_details` is defined.
        :param pulumi.Input['StorageObjectSourceUriDetailsArgs'] source_uri_details: Details of the source URI of the object in the cloud. Cannot be defined if `content` or `source` is defined. 
               Note: To enable object copy, you must authorize the service to manage objects on your behalf.
        :param pulumi.Input[builtins.str] storage_tier: (Updatable) The storage tier that the object should be stored in. If not specified, the object will be stored in the same storage tier as the bucket.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)
        if cache_control is not None:
            pulumi.set(__self__, "cache_control", cache_control)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_disposition is not None:
            pulumi.set(__self__, "content_disposition", content_disposition)
        if content_encoding is not None:
            pulumi.set(__self__, "content_encoding", content_encoding)
        if content_language is not None:
            pulumi.set(__self__, "content_language", content_language)
        if content_md5 is not None:
            pulumi.set(__self__, "content_md5", content_md5)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if delete_all_object_versions is not None:
            pulumi.set(__self__, "delete_all_object_versions", delete_all_object_versions)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if opc_sse_kms_key_id is not None:
            pulumi.set(__self__, "opc_sse_kms_key_id", opc_sse_kms_key_id)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_uri_details is not None:
            pulumi.set(__self__, "source_uri_details", source_uri_details)
        if storage_tier is not None:
            pulumi.set(__self__, "storage_tier", storage_tier)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[builtins.str]:
        """
        The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[builtins.str]:
        """
        The Object Storage namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The name of the object. Avoid entering confidential information. Example: `test/object1.log`
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The optional Cache-Control header that defines the caching behavior value to be returned in GetObject and HeadObject responses. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to identify objects that require caching restrictions.
        """
        return pulumi.get(self, "cache_control")

    @cache_control.setter
    def cache_control(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cache_control", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The object to upload to the object store. Cannot be defined if `source` or `source_uri_details` is defined.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The optional Content-Disposition header that defines presentational information for the object to be returned in GetObject and HeadObject responses. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to let users download objects with custom filenames in a browser.
        """
        return pulumi.get(self, "content_disposition")

    @content_disposition.setter
    def content_disposition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_disposition", value)

    @property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The optional Content-Encoding header that defines the content encodings that were applied to the object to upload. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to determine what decoding mechanisms need to be applied to obtain the media-type specified by the Content-Type header of the object.
        """
        return pulumi.get(self, "content_encoding")

    @content_encoding.setter
    def content_encoding(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_encoding", value)

    @property
    @pulumi.getter(name="contentLanguage")
    def content_language(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The optional Content-Language header that defines the content language of the object to upload. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to identify and differentiate objects based on a particular language.
        """
        return pulumi.get(self, "content_language")

    @content_language.setter
    def content_language(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_language", value)

    @property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The optional header that defines the base64-encoded MD5 hash of the body. If the optional Content-MD5 header is present, Object Storage performs an integrity check on the body of the HTTP request by computing the MD5 hash for the body and comparing it to the MD5 hash supplied in the header. If the two hashes do not match, the object is rejected and an HTTP-400 Unmatched Content MD5 error is returned with the message:

        "The computed MD5 of the request body (ACTUAL_MD5) does not match the Content-MD5 header (HEADER_MD5)"
        """
        return pulumi.get(self, "content_md5")

    @content_md5.setter
    def content_md5(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_md5", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The optional Content-Type header that defines the standard MIME type format of the object. Content type defaults to 'application/octet-stream' if not specified in the PutObject call. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to identify and perform special operations on text only objects.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="deleteAllObjectVersions")
    def delete_all_object_versions(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) A boolean to delete all object versions for an object in a bucket that has or ever had versioning enabled.
        """
        return pulumi.get(self, "delete_all_object_versions")

    @delete_all_object_versions.setter
    def delete_all_object_versions(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_all_object_versions", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional user-defined metadata key and value.
        Note: All specified keys must be in lower case.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="opcSseKmsKeyId")
    def opc_sse_kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a master encryption key used to call the Key Management service to generate a data encryption key or to encrypt or decrypt a data encryption key.
        """
        return pulumi.get(self, "opc_sse_kms_key_id")

    @opc_sse_kms_key_id.setter
    def opc_sse_kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "opc_sse_kms_key_id", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An absolute path to a file on the local system. Cannot be defined if `content` or `source_uri_details` is defined.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceUriDetails")
    def source_uri_details(self) -> Optional[pulumi.Input['StorageObjectSourceUriDetailsArgs']]:
        """
        Details of the source URI of the object in the cloud. Cannot be defined if `content` or `source` is defined. 
        Note: To enable object copy, you must authorize the service to manage objects on your behalf.
        """
        return pulumi.get(self, "source_uri_details")

    @source_uri_details.setter
    def source_uri_details(self, value: Optional[pulumi.Input['StorageObjectSourceUriDetailsArgs']]):
        pulumi.set(self, "source_uri_details", value)

    @property
    @pulumi.getter(name="storageTier")
    def storage_tier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The storage tier that the object should be stored in. If not specified, the object will be stored in the same storage tier as the bucket.
        """
        return pulumi.get(self, "storage_tier")

    @storage_tier.setter
    def storage_tier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_tier", value)


@pulumi.input_type
class _StorageObjectState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 cache_control: Optional[pulumi.Input[builtins.str]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 content_disposition: Optional[pulumi.Input[builtins.str]] = None,
                 content_encoding: Optional[pulumi.Input[builtins.str]] = None,
                 content_language: Optional[pulumi.Input[builtins.str]] = None,
                 content_length: Optional[pulumi.Input[builtins.str]] = None,
                 content_md5: Optional[pulumi.Input[builtins.str]] = None,
                 content_type: Optional[pulumi.Input[builtins.str]] = None,
                 delete_all_object_versions: Optional[pulumi.Input[builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 object: Optional[pulumi.Input[builtins.str]] = None,
                 opc_sse_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 source_uri_details: Optional[pulumi.Input['StorageObjectSourceUriDetailsArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 storage_tier: Optional[pulumi.Input[builtins.str]] = None,
                 version_id: Optional[pulumi.Input[builtins.str]] = None,
                 work_request_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering StorageObject resources.
        :param pulumi.Input[builtins.str] bucket: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
        :param pulumi.Input[builtins.str] cache_control: The optional Cache-Control header that defines the caching behavior value to be returned in GetObject and HeadObject responses. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to identify objects that require caching restrictions.
        :param pulumi.Input[builtins.str] content: The object to upload to the object store. Cannot be defined if `source` or `source_uri_details` is defined.
        :param pulumi.Input[builtins.str] content_disposition: The optional Content-Disposition header that defines presentational information for the object to be returned in GetObject and HeadObject responses. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to let users download objects with custom filenames in a browser.
        :param pulumi.Input[builtins.str] content_encoding: The optional Content-Encoding header that defines the content encodings that were applied to the object to upload. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to determine what decoding mechanisms need to be applied to obtain the media-type specified by the Content-Type header of the object.
        :param pulumi.Input[builtins.str] content_language: The optional Content-Language header that defines the content language of the object to upload. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to identify and differentiate objects based on a particular language.
        :param pulumi.Input[builtins.str] content_length: (Updatable) The content length of the body.
        :param pulumi.Input[builtins.str] content_md5: (Updatable) The optional header that defines the base64-encoded MD5 hash of the body. If the optional Content-MD5 header is present, Object Storage performs an integrity check on the body of the HTTP request by computing the MD5 hash for the body and comparing it to the MD5 hash supplied in the header. If the two hashes do not match, the object is rejected and an HTTP-400 Unmatched Content MD5 error is returned with the message:
               
               "The computed MD5 of the request body (ACTUAL_MD5) does not match the Content-MD5 header (HEADER_MD5)"
        :param pulumi.Input[builtins.str] content_type: The optional Content-Type header that defines the standard MIME type format of the object. Content type defaults to 'application/octet-stream' if not specified in the PutObject call. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to identify and perform special operations on text only objects.
        :param pulumi.Input[builtins.bool] delete_all_object_versions: (Updatable) A boolean to delete all object versions for an object in a bucket that has or ever had versioning enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Optional user-defined metadata key and value.
               Note: All specified keys must be in lower case.
        :param pulumi.Input[builtins.str] namespace: The Object Storage namespace used for the request.
        :param pulumi.Input[builtins.str] object: (Updatable) The name of the object. Avoid entering confidential information. Example: `test/object1.log`
        :param pulumi.Input[builtins.str] opc_sse_kms_key_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a master encryption key used to call the Key Management service to generate a data encryption key or to encrypt or decrypt a data encryption key.
        :param pulumi.Input[builtins.str] source: An absolute path to a file on the local system. Cannot be defined if `content` or `source_uri_details` is defined.
        :param pulumi.Input['StorageObjectSourceUriDetailsArgs'] source_uri_details: Details of the source URI of the object in the cloud. Cannot be defined if `content` or `source` is defined. 
               Note: To enable object copy, you must authorize the service to manage objects on your behalf.
        :param pulumi.Input[builtins.str] storage_tier: (Updatable) The storage tier that the object should be stored in. If not specified, the object will be stored in the same storage tier as the bucket.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if cache_control is not None:
            pulumi.set(__self__, "cache_control", cache_control)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_disposition is not None:
            pulumi.set(__self__, "content_disposition", content_disposition)
        if content_encoding is not None:
            pulumi.set(__self__, "content_encoding", content_encoding)
        if content_language is not None:
            pulumi.set(__self__, "content_language", content_language)
        if content_length is not None:
            pulumi.set(__self__, "content_length", content_length)
        if content_md5 is not None:
            pulumi.set(__self__, "content_md5", content_md5)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if delete_all_object_versions is not None:
            pulumi.set(__self__, "delete_all_object_versions", delete_all_object_versions)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if opc_sse_kms_key_id is not None:
            pulumi.set(__self__, "opc_sse_kms_key_id", opc_sse_kms_key_id)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_uri_details is not None:
            pulumi.set(__self__, "source_uri_details", source_uri_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_tier is not None:
            pulumi.set(__self__, "storage_tier", storage_tier)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)
        if work_request_id is not None:
            pulumi.set(__self__, "work_request_id", work_request_id)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The optional Cache-Control header that defines the caching behavior value to be returned in GetObject and HeadObject responses. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to identify objects that require caching restrictions.
        """
        return pulumi.get(self, "cache_control")

    @cache_control.setter
    def cache_control(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cache_control", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The object to upload to the object store. Cannot be defined if `source` or `source_uri_details` is defined.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The optional Content-Disposition header that defines presentational information for the object to be returned in GetObject and HeadObject responses. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to let users download objects with custom filenames in a browser.
        """
        return pulumi.get(self, "content_disposition")

    @content_disposition.setter
    def content_disposition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_disposition", value)

    @property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The optional Content-Encoding header that defines the content encodings that were applied to the object to upload. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to determine what decoding mechanisms need to be applied to obtain the media-type specified by the Content-Type header of the object.
        """
        return pulumi.get(self, "content_encoding")

    @content_encoding.setter
    def content_encoding(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_encoding", value)

    @property
    @pulumi.getter(name="contentLanguage")
    def content_language(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The optional Content-Language header that defines the content language of the object to upload. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to identify and differentiate objects based on a particular language.
        """
        return pulumi.get(self, "content_language")

    @content_language.setter
    def content_language(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_language", value)

    @property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The content length of the body.
        """
        return pulumi.get(self, "content_length")

    @content_length.setter
    def content_length(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_length", value)

    @property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The optional header that defines the base64-encoded MD5 hash of the body. If the optional Content-MD5 header is present, Object Storage performs an integrity check on the body of the HTTP request by computing the MD5 hash for the body and comparing it to the MD5 hash supplied in the header. If the two hashes do not match, the object is rejected and an HTTP-400 Unmatched Content MD5 error is returned with the message:

        "The computed MD5 of the request body (ACTUAL_MD5) does not match the Content-MD5 header (HEADER_MD5)"
        """
        return pulumi.get(self, "content_md5")

    @content_md5.setter
    def content_md5(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_md5", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The optional Content-Type header that defines the standard MIME type format of the object. Content type defaults to 'application/octet-stream' if not specified in the PutObject call. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to identify and perform special operations on text only objects.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="deleteAllObjectVersions")
    def delete_all_object_versions(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) A boolean to delete all object versions for an object in a bucket that has or ever had versioning enabled.
        """
        return pulumi.get(self, "delete_all_object_versions")

    @delete_all_object_versions.setter
    def delete_all_object_versions(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_all_object_versions", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional user-defined metadata key and value.
        Note: All specified keys must be in lower case.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Object Storage namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The name of the object. Avoid entering confidential information. Example: `test/object1.log`
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter(name="opcSseKmsKeyId")
    def opc_sse_kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a master encryption key used to call the Key Management service to generate a data encryption key or to encrypt or decrypt a data encryption key.
        """
        return pulumi.get(self, "opc_sse_kms_key_id")

    @opc_sse_kms_key_id.setter
    def opc_sse_kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "opc_sse_kms_key_id", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An absolute path to a file on the local system. Cannot be defined if `content` or `source_uri_details` is defined.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceUriDetails")
    def source_uri_details(self) -> Optional[pulumi.Input['StorageObjectSourceUriDetailsArgs']]:
        """
        Details of the source URI of the object in the cloud. Cannot be defined if `content` or `source` is defined. 
        Note: To enable object copy, you must authorize the service to manage objects on your behalf.
        """
        return pulumi.get(self, "source_uri_details")

    @source_uri_details.setter
    def source_uri_details(self, value: Optional[pulumi.Input['StorageObjectSourceUriDetailsArgs']]):
        pulumi.set(self, "source_uri_details", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="storageTier")
    def storage_tier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The storage tier that the object should be stored in. If not specified, the object will be stored in the same storage tier as the bucket.
        """
        return pulumi.get(self, "storage_tier")

    @storage_tier.setter
    def storage_tier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_tier", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version_id", value)

    @property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "work_request_id")

    @work_request_id.setter
    def work_request_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "work_request_id", value)


@pulumi.type_token("oci:ObjectStorage/storageObject:StorageObject")
class StorageObject(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 cache_control: Optional[pulumi.Input[builtins.str]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 content_disposition: Optional[pulumi.Input[builtins.str]] = None,
                 content_encoding: Optional[pulumi.Input[builtins.str]] = None,
                 content_language: Optional[pulumi.Input[builtins.str]] = None,
                 content_md5: Optional[pulumi.Input[builtins.str]] = None,
                 content_type: Optional[pulumi.Input[builtins.str]] = None,
                 delete_all_object_versions: Optional[pulumi.Input[builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 object: Optional[pulumi.Input[builtins.str]] = None,
                 opc_sse_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 source_uri_details: Optional[pulumi.Input[Union['StorageObjectSourceUriDetailsArgs', 'StorageObjectSourceUriDetailsArgsDict']]] = None,
                 storage_tier: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Object resource in Oracle Cloud Infrastructure Object Storage service.

        Creates a new object or overwrites an existing object with the same name. The maximum object size allowed by
        PutObject is 50 GiB.

        See [Object Names](https://docs.cloud.oracle.com/iaas/Content/Object/Tasks/managingobjects.htm#namerequirements)
        for object naming requirements.

        See [Special Instructions for Object Storage PUT](https://docs.cloud.oracle.com/iaas/Content/API/Concepts/signingrequests.htm#ObjectStoragePut)
        for request signature requirements.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_object = oci.object_storage.StorageObject("test_object",
            bucket=object_bucket,
            content=object_content,
            namespace=object_namespace,
            object=object_object,
            cache_control=object_cache_control,
            content_disposition=object_content_disposition,
            content_encoding=object_content_encoding,
            content_language=object_content_language,
            content_type=object_content_type,
            delete_all_object_versions=object_delete_all_object_versions,
            metadata=object_metadata,
            storage_tier=object_storage_tier,
            opc_sse_kms_key_id=object_opc_sse_kms_key_id)
        ```

        ## Import

        Objects can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ObjectStorage/storageObject:StorageObject test_object "n/{namespaceName}/b/{bucketName}/o/{objectName}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] bucket: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
        :param pulumi.Input[builtins.str] cache_control: The optional Cache-Control header that defines the caching behavior value to be returned in GetObject and HeadObject responses. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to identify objects that require caching restrictions.
        :param pulumi.Input[builtins.str] content: The object to upload to the object store. Cannot be defined if `source` or `source_uri_details` is defined.
        :param pulumi.Input[builtins.str] content_disposition: The optional Content-Disposition header that defines presentational information for the object to be returned in GetObject and HeadObject responses. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to let users download objects with custom filenames in a browser.
        :param pulumi.Input[builtins.str] content_encoding: The optional Content-Encoding header that defines the content encodings that were applied to the object to upload. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to determine what decoding mechanisms need to be applied to obtain the media-type specified by the Content-Type header of the object.
        :param pulumi.Input[builtins.str] content_language: The optional Content-Language header that defines the content language of the object to upload. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to identify and differentiate objects based on a particular language.
        :param pulumi.Input[builtins.str] content_md5: (Updatable) The optional header that defines the base64-encoded MD5 hash of the body. If the optional Content-MD5 header is present, Object Storage performs an integrity check on the body of the HTTP request by computing the MD5 hash for the body and comparing it to the MD5 hash supplied in the header. If the two hashes do not match, the object is rejected and an HTTP-400 Unmatched Content MD5 error is returned with the message:
               
               "The computed MD5 of the request body (ACTUAL_MD5) does not match the Content-MD5 header (HEADER_MD5)"
        :param pulumi.Input[builtins.str] content_type: The optional Content-Type header that defines the standard MIME type format of the object. Content type defaults to 'application/octet-stream' if not specified in the PutObject call. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to identify and perform special operations on text only objects.
        :param pulumi.Input[builtins.bool] delete_all_object_versions: (Updatable) A boolean to delete all object versions for an object in a bucket that has or ever had versioning enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Optional user-defined metadata key and value.
               Note: All specified keys must be in lower case.
        :param pulumi.Input[builtins.str] namespace: The Object Storage namespace used for the request.
        :param pulumi.Input[builtins.str] object: (Updatable) The name of the object. Avoid entering confidential information. Example: `test/object1.log`
        :param pulumi.Input[builtins.str] opc_sse_kms_key_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a master encryption key used to call the Key Management service to generate a data encryption key or to encrypt or decrypt a data encryption key.
        :param pulumi.Input[builtins.str] source: An absolute path to a file on the local system. Cannot be defined if `content` or `source_uri_details` is defined.
        :param pulumi.Input[Union['StorageObjectSourceUriDetailsArgs', 'StorageObjectSourceUriDetailsArgsDict']] source_uri_details: Details of the source URI of the object in the cloud. Cannot be defined if `content` or `source` is defined. 
               Note: To enable object copy, you must authorize the service to manage objects on your behalf.
        :param pulumi.Input[builtins.str] storage_tier: (Updatable) The storage tier that the object should be stored in. If not specified, the object will be stored in the same storage tier as the bucket.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StorageObjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Object resource in Oracle Cloud Infrastructure Object Storage service.

        Creates a new object or overwrites an existing object with the same name. The maximum object size allowed by
        PutObject is 50 GiB.

        See [Object Names](https://docs.cloud.oracle.com/iaas/Content/Object/Tasks/managingobjects.htm#namerequirements)
        for object naming requirements.

        See [Special Instructions for Object Storage PUT](https://docs.cloud.oracle.com/iaas/Content/API/Concepts/signingrequests.htm#ObjectStoragePut)
        for request signature requirements.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_object = oci.object_storage.StorageObject("test_object",
            bucket=object_bucket,
            content=object_content,
            namespace=object_namespace,
            object=object_object,
            cache_control=object_cache_control,
            content_disposition=object_content_disposition,
            content_encoding=object_content_encoding,
            content_language=object_content_language,
            content_type=object_content_type,
            delete_all_object_versions=object_delete_all_object_versions,
            metadata=object_metadata,
            storage_tier=object_storage_tier,
            opc_sse_kms_key_id=object_opc_sse_kms_key_id)
        ```

        ## Import

        Objects can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ObjectStorage/storageObject:StorageObject test_object "n/{namespaceName}/b/{bucketName}/o/{objectName}"
        ```

        :param str resource_name: The name of the resource.
        :param StorageObjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StorageObjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 cache_control: Optional[pulumi.Input[builtins.str]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 content_disposition: Optional[pulumi.Input[builtins.str]] = None,
                 content_encoding: Optional[pulumi.Input[builtins.str]] = None,
                 content_language: Optional[pulumi.Input[builtins.str]] = None,
                 content_md5: Optional[pulumi.Input[builtins.str]] = None,
                 content_type: Optional[pulumi.Input[builtins.str]] = None,
                 delete_all_object_versions: Optional[pulumi.Input[builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 object: Optional[pulumi.Input[builtins.str]] = None,
                 opc_sse_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 source_uri_details: Optional[pulumi.Input[Union['StorageObjectSourceUriDetailsArgs', 'StorageObjectSourceUriDetailsArgsDict']]] = None,
                 storage_tier: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StorageObjectArgs.__new__(StorageObjectArgs)

            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["cache_control"] = cache_control
            __props__.__dict__["content"] = content
            __props__.__dict__["content_disposition"] = content_disposition
            __props__.__dict__["content_encoding"] = content_encoding
            __props__.__dict__["content_language"] = content_language
            __props__.__dict__["content_md5"] = content_md5
            __props__.__dict__["content_type"] = content_type
            __props__.__dict__["delete_all_object_versions"] = delete_all_object_versions
            __props__.__dict__["metadata"] = metadata
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            if object is None and not opts.urn:
                raise TypeError("Missing required property 'object'")
            __props__.__dict__["object"] = object
            __props__.__dict__["opc_sse_kms_key_id"] = opc_sse_kms_key_id
            __props__.__dict__["source"] = source
            __props__.__dict__["source_uri_details"] = source_uri_details
            __props__.__dict__["storage_tier"] = storage_tier
            __props__.__dict__["content_length"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["version_id"] = None
            __props__.__dict__["work_request_id"] = None
        super(StorageObject, __self__).__init__(
            'oci:ObjectStorage/storageObject:StorageObject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[builtins.str]] = None,
            cache_control: Optional[pulumi.Input[builtins.str]] = None,
            content: Optional[pulumi.Input[builtins.str]] = None,
            content_disposition: Optional[pulumi.Input[builtins.str]] = None,
            content_encoding: Optional[pulumi.Input[builtins.str]] = None,
            content_language: Optional[pulumi.Input[builtins.str]] = None,
            content_length: Optional[pulumi.Input[builtins.str]] = None,
            content_md5: Optional[pulumi.Input[builtins.str]] = None,
            content_type: Optional[pulumi.Input[builtins.str]] = None,
            delete_all_object_versions: Optional[pulumi.Input[builtins.bool]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            namespace: Optional[pulumi.Input[builtins.str]] = None,
            object: Optional[pulumi.Input[builtins.str]] = None,
            opc_sse_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
            source: Optional[pulumi.Input[builtins.str]] = None,
            source_uri_details: Optional[pulumi.Input[Union['StorageObjectSourceUriDetailsArgs', 'StorageObjectSourceUriDetailsArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            storage_tier: Optional[pulumi.Input[builtins.str]] = None,
            version_id: Optional[pulumi.Input[builtins.str]] = None,
            work_request_id: Optional[pulumi.Input[builtins.str]] = None) -> 'StorageObject':
        """
        Get an existing StorageObject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] bucket: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
        :param pulumi.Input[builtins.str] cache_control: The optional Cache-Control header that defines the caching behavior value to be returned in GetObject and HeadObject responses. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to identify objects that require caching restrictions.
        :param pulumi.Input[builtins.str] content: The object to upload to the object store. Cannot be defined if `source` or `source_uri_details` is defined.
        :param pulumi.Input[builtins.str] content_disposition: The optional Content-Disposition header that defines presentational information for the object to be returned in GetObject and HeadObject responses. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to let users download objects with custom filenames in a browser.
        :param pulumi.Input[builtins.str] content_encoding: The optional Content-Encoding header that defines the content encodings that were applied to the object to upload. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to determine what decoding mechanisms need to be applied to obtain the media-type specified by the Content-Type header of the object.
        :param pulumi.Input[builtins.str] content_language: The optional Content-Language header that defines the content language of the object to upload. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to identify and differentiate objects based on a particular language.
        :param pulumi.Input[builtins.str] content_length: (Updatable) The content length of the body.
        :param pulumi.Input[builtins.str] content_md5: (Updatable) The optional header that defines the base64-encoded MD5 hash of the body. If the optional Content-MD5 header is present, Object Storage performs an integrity check on the body of the HTTP request by computing the MD5 hash for the body and comparing it to the MD5 hash supplied in the header. If the two hashes do not match, the object is rejected and an HTTP-400 Unmatched Content MD5 error is returned with the message:
               
               "The computed MD5 of the request body (ACTUAL_MD5) does not match the Content-MD5 header (HEADER_MD5)"
        :param pulumi.Input[builtins.str] content_type: The optional Content-Type header that defines the standard MIME type format of the object. Content type defaults to 'application/octet-stream' if not specified in the PutObject call. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to identify and perform special operations on text only objects.
        :param pulumi.Input[builtins.bool] delete_all_object_versions: (Updatable) A boolean to delete all object versions for an object in a bucket that has or ever had versioning enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Optional user-defined metadata key and value.
               Note: All specified keys must be in lower case.
        :param pulumi.Input[builtins.str] namespace: The Object Storage namespace used for the request.
        :param pulumi.Input[builtins.str] object: (Updatable) The name of the object. Avoid entering confidential information. Example: `test/object1.log`
        :param pulumi.Input[builtins.str] opc_sse_kms_key_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a master encryption key used to call the Key Management service to generate a data encryption key or to encrypt or decrypt a data encryption key.
        :param pulumi.Input[builtins.str] source: An absolute path to a file on the local system. Cannot be defined if `content` or `source_uri_details` is defined.
        :param pulumi.Input[Union['StorageObjectSourceUriDetailsArgs', 'StorageObjectSourceUriDetailsArgsDict']] source_uri_details: Details of the source URI of the object in the cloud. Cannot be defined if `content` or `source` is defined. 
               Note: To enable object copy, you must authorize the service to manage objects on your behalf.
        :param pulumi.Input[builtins.str] storage_tier: (Updatable) The storage tier that the object should be stored in. If not specified, the object will be stored in the same storage tier as the bucket.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StorageObjectState.__new__(_StorageObjectState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["cache_control"] = cache_control
        __props__.__dict__["content"] = content
        __props__.__dict__["content_disposition"] = content_disposition
        __props__.__dict__["content_encoding"] = content_encoding
        __props__.__dict__["content_language"] = content_language
        __props__.__dict__["content_length"] = content_length
        __props__.__dict__["content_md5"] = content_md5
        __props__.__dict__["content_type"] = content_type
        __props__.__dict__["delete_all_object_versions"] = delete_all_object_versions
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["object"] = object
        __props__.__dict__["opc_sse_kms_key_id"] = opc_sse_kms_key_id
        __props__.__dict__["source"] = source
        __props__.__dict__["source_uri_details"] = source_uri_details
        __props__.__dict__["state"] = state
        __props__.__dict__["storage_tier"] = storage_tier
        __props__.__dict__["version_id"] = version_id
        __props__.__dict__["work_request_id"] = work_request_id
        return StorageObject(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[builtins.str]:
        """
        The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The optional Cache-Control header that defines the caching behavior value to be returned in GetObject and HeadObject responses. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to identify objects that require caching restrictions.
        """
        return pulumi.get(self, "cache_control")

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The object to upload to the object store. Cannot be defined if `source` or `source_uri_details` is defined.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The optional Content-Disposition header that defines presentational information for the object to be returned in GetObject and HeadObject responses. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to let users download objects with custom filenames in a browser.
        """
        return pulumi.get(self, "content_disposition")

    @property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The optional Content-Encoding header that defines the content encodings that were applied to the object to upload. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to determine what decoding mechanisms need to be applied to obtain the media-type specified by the Content-Type header of the object.
        """
        return pulumi.get(self, "content_encoding")

    @property
    @pulumi.getter(name="contentLanguage")
    def content_language(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The optional Content-Language header that defines the content language of the object to upload. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to identify and differentiate objects based on a particular language.
        """
        return pulumi.get(self, "content_language")

    @property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The content length of the body.
        """
        return pulumi.get(self, "content_length")

    @property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The optional header that defines the base64-encoded MD5 hash of the body. If the optional Content-MD5 header is present, Object Storage performs an integrity check on the body of the HTTP request by computing the MD5 hash for the body and comparing it to the MD5 hash supplied in the header. If the two hashes do not match, the object is rejected and an HTTP-400 Unmatched Content MD5 error is returned with the message:

        "The computed MD5 of the request body (ACTUAL_MD5) does not match the Content-MD5 header (HEADER_MD5)"
        """
        return pulumi.get(self, "content_md5")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[builtins.str]:
        """
        The optional Content-Type header that defines the standard MIME type format of the object. Content type defaults to 'application/octet-stream' if not specified in the PutObject call. Specifying values for this header has no effect on Object Storage behavior. Programs that read the object determine what to do based on the value provided. For example, you could use this header to identify and perform special operations on text only objects.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="deleteAllObjectVersions")
    def delete_all_object_versions(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        (Updatable) A boolean to delete all object versions for an object in a bucket that has or ever had versioning enabled.
        """
        return pulumi.get(self, "delete_all_object_versions")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Optional user-defined metadata key and value.
        Note: All specified keys must be in lower case.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[builtins.str]:
        """
        The Object Storage namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The name of the object. Avoid entering confidential information. Example: `test/object1.log`
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="opcSseKmsKeyId")
    def opc_sse_kms_key_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a master encryption key used to call the Key Management service to generate a data encryption key or to encrypt or decrypt a data encryption key.
        """
        return pulumi.get(self, "opc_sse_kms_key_id")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An absolute path to a file on the local system. Cannot be defined if `content` or `source_uri_details` is defined.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceUriDetails")
    def source_uri_details(self) -> pulumi.Output[Optional['outputs.StorageObjectSourceUriDetails']]:
        """
        Details of the source URI of the object in the cloud. Cannot be defined if `content` or `source` is defined. 
        Note: To enable object copy, you must authorize the service to manage objects on your behalf.
        """
        return pulumi.get(self, "source_uri_details")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageTier")
    def storage_tier(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The storage tier that the object should be stored in. If not specified, the object will be stored in the same storage tier as the bucket.
        """
        return pulumi.get(self, "storage_tier")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "version_id")

    @property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "work_request_id")

