# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApiaccesscontrolPrivilegedApiRequestArgs', 'ApiaccesscontrolPrivilegedApiRequest']

@pulumi.input_type
class ApiaccesscontrolPrivilegedApiRequestArgs:
    def __init__(__self__, *,
                 privileged_operation_lists: pulumi.Input[Sequence[pulumi.Input['ApiaccesscontrolPrivilegedApiRequestPrivilegedOperationListArgs']]],
                 reason_summary: pulumi.Input[builtins.str],
                 resource_id: pulumi.Input[builtins.str],
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 duration_in_hrs: Optional[pulumi.Input[builtins.int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 notification_topic_id: Optional[pulumi.Input[builtins.str]] = None,
                 reason_detail: Optional[pulumi.Input[builtins.str]] = None,
                 severity: Optional[pulumi.Input[builtins.str]] = None,
                 sub_resource_name_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ticket_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 time_requested_for_future_access: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ApiaccesscontrolPrivilegedApiRequest resource.
        :param pulumi.Input[Sequence[pulumi.Input['ApiaccesscontrolPrivilegedApiRequestPrivilegedOperationListArgs']]] privileged_operation_lists: List of api names, attributes for which approval is sought by the user.
        :param pulumi.Input[builtins.str] reason_summary: Summary comment by the operator creating the access request.
        :param pulumi.Input[builtins.str] resource_id: The OCID of the target resource associated with the access request. The operator raises an access request to get approval to access the target resource.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.int] duration_in_hrs: Duration in hours for which access is sought on the target resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] notification_topic_id: The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Privileged Api Request.
        :param pulumi.Input[builtins.str] reason_detail: Reason in detail for which the operator is requesting access on the target resource.
        :param pulumi.Input[builtins.str] severity: Priority assigned to the access request by the operator
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sub_resource_name_lists: The subresource names requested for approval.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ticket_numbers: A list of ticket numbers related to this Privileged Api Access Request, e.g. Service Request (SR) number and JIRA ticket number.
        :param pulumi.Input[builtins.str] time_requested_for_future_access: Time in future when the user for the privilegedApi request needs to be created in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z' 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "privileged_operation_lists", privileged_operation_lists)
        pulumi.set(__self__, "reason_summary", reason_summary)
        pulumi.set(__self__, "resource_id", resource_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if duration_in_hrs is not None:
            pulumi.set(__self__, "duration_in_hrs", duration_in_hrs)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if notification_topic_id is not None:
            pulumi.set(__self__, "notification_topic_id", notification_topic_id)
        if reason_detail is not None:
            pulumi.set(__self__, "reason_detail", reason_detail)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if sub_resource_name_lists is not None:
            pulumi.set(__self__, "sub_resource_name_lists", sub_resource_name_lists)
        if ticket_numbers is not None:
            pulumi.set(__self__, "ticket_numbers", ticket_numbers)
        if time_requested_for_future_access is not None:
            pulumi.set(__self__, "time_requested_for_future_access", time_requested_for_future_access)

    @property
    @pulumi.getter(name="privilegedOperationLists")
    def privileged_operation_lists(self) -> pulumi.Input[Sequence[pulumi.Input['ApiaccesscontrolPrivilegedApiRequestPrivilegedOperationListArgs']]]:
        """
        List of api names, attributes for which approval is sought by the user.
        """
        return pulumi.get(self, "privileged_operation_lists")

    @privileged_operation_lists.setter
    def privileged_operation_lists(self, value: pulumi.Input[Sequence[pulumi.Input['ApiaccesscontrolPrivilegedApiRequestPrivilegedOperationListArgs']]]):
        pulumi.set(self, "privileged_operation_lists", value)

    @property
    @pulumi.getter(name="reasonSummary")
    def reason_summary(self) -> pulumi.Input[builtins.str]:
        """
        Summary comment by the operator creating the access request.
        """
        return pulumi.get(self, "reason_summary")

    @reason_summary.setter
    def reason_summary(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "reason_summary", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the target resource associated with the access request. The operator raises an access request to get approval to access the target resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="durationInHrs")
    def duration_in_hrs(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Duration in hours for which access is sought on the target resource.
        """
        return pulumi.get(self, "duration_in_hrs")

    @duration_in_hrs.setter
    def duration_in_hrs(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "duration_in_hrs", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="notificationTopicId")
    def notification_topic_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Privileged Api Request.
        """
        return pulumi.get(self, "notification_topic_id")

    @notification_topic_id.setter
    def notification_topic_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notification_topic_id", value)

    @property
    @pulumi.getter(name="reasonDetail")
    def reason_detail(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Reason in detail for which the operator is requesting access on the target resource.
        """
        return pulumi.get(self, "reason_detail")

    @reason_detail.setter
    def reason_detail(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reason_detail", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Priority assigned to the access request by the operator
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter(name="subResourceNameLists")
    def sub_resource_name_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The subresource names requested for approval.
        """
        return pulumi.get(self, "sub_resource_name_lists")

    @sub_resource_name_lists.setter
    def sub_resource_name_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "sub_resource_name_lists", value)

    @property
    @pulumi.getter(name="ticketNumbers")
    def ticket_numbers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of ticket numbers related to this Privileged Api Access Request, e.g. Service Request (SR) number and JIRA ticket number.
        """
        return pulumi.get(self, "ticket_numbers")

    @ticket_numbers.setter
    def ticket_numbers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ticket_numbers", value)

    @property
    @pulumi.getter(name="timeRequestedForFutureAccess")
    def time_requested_for_future_access(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time in future when the user for the privilegedApi request needs to be created in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z' 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_requested_for_future_access")

    @time_requested_for_future_access.setter
    def time_requested_for_future_access(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_requested_for_future_access", value)


@pulumi.input_type
class _ApiaccesscontrolPrivilegedApiRequestState:
    def __init__(__self__, *,
                 approver_details: Optional[pulumi.Input[Sequence[pulumi.Input['ApiaccesscontrolPrivilegedApiRequestApproverDetailArgs']]]] = None,
                 closure_comment: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 duration_in_hrs: Optional[pulumi.Input[builtins.int]] = None,
                 entity_type: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 notification_topic_id: Optional[pulumi.Input[builtins.str]] = None,
                 number_of_approvers_required: Optional[pulumi.Input[builtins.int]] = None,
                 privileged_api_control_id: Optional[pulumi.Input[builtins.str]] = None,
                 privileged_api_control_name: Optional[pulumi.Input[builtins.str]] = None,
                 privileged_operation_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ApiaccesscontrolPrivilegedApiRequestPrivilegedOperationListArgs']]]] = None,
                 reason_detail: Optional[pulumi.Input[builtins.str]] = None,
                 reason_summary: Optional[pulumi.Input[builtins.str]] = None,
                 request_id: Optional[pulumi.Input[builtins.str]] = None,
                 requested_bies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 severity: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 state_details: Optional[pulumi.Input[builtins.str]] = None,
                 sub_resource_name_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ticket_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_requested_for_future_access: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApiaccesscontrolPrivilegedApiRequest resources.
        :param pulumi.Input[Sequence[pulumi.Input['ApiaccesscontrolPrivilegedApiRequestApproverDetailArgs']]] approver_details: Contains the approver details who have approved the privilegedApi Request during the initial request.
        :param pulumi.Input[builtins.str] closure_comment: The comment entered by the operator while closing the request.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: Name of the privilegedApi control. The name must be unique.
        :param pulumi.Input[builtins.int] duration_in_hrs: Duration in hours for which access is sought on the target resource.
        :param pulumi.Input[builtins.str] entity_type: entityType of resource for which the AccessRequest is applicable
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] lifecycle_details: more in detail about the lifeCycleState.
        :param pulumi.Input[builtins.str] notification_topic_id: The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Privileged Api Request.
        :param pulumi.Input[builtins.int] number_of_approvers_required: Number of approvers required to approve an privilegedApi request.
        :param pulumi.Input[builtins.str] privileged_api_control_id: The OCID of the privilegedApi control governing the target resource.
        :param pulumi.Input[builtins.str] privileged_api_control_name: Name of the privilegedApi control governing the target resource.
        :param pulumi.Input[Sequence[pulumi.Input['ApiaccesscontrolPrivilegedApiRequestPrivilegedOperationListArgs']]] privileged_operation_lists: List of api names, attributes for which approval is sought by the user.
        :param pulumi.Input[builtins.str] reason_detail: Reason in detail for which the operator is requesting access on the target resource.
        :param pulumi.Input[builtins.str] reason_summary: Summary comment by the operator creating the access request.
        :param pulumi.Input[builtins.str] request_id: This is an automatic identifier generated by the system which is easier for human comprehension.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] requested_bies: List of Users who has created this privilegedApiRequest.
        :param pulumi.Input[builtins.str] resource_id: The OCID of the target resource associated with the access request. The operator raises an access request to get approval to access the target resource.
        :param pulumi.Input[builtins.str] resource_name: resourceName for which the PrivilegedApiRequest is applicable
        :param pulumi.Input[builtins.str] resource_type: resourceType for which the AccessRequest is applicable
        :param pulumi.Input[builtins.str] severity: Priority assigned to the access request by the operator
        :param pulumi.Input[builtins.str] state: The current state of the PrivilegedApiRequest.
        :param pulumi.Input[builtins.str] state_details: A message that describes the current state of the PrivilegedApiControl in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sub_resource_name_lists: The subresource names requested for approval.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ticket_numbers: A list of ticket numbers related to this Privileged Api Access Request, e.g. Service Request (SR) number and JIRA ticket number.
        :param pulumi.Input[builtins.str] time_created: Time when the privilegedApi request was created in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[builtins.str] time_requested_for_future_access: Time in future when the user for the privilegedApi request needs to be created in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z' 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_updated: Time when the privilegedApi request was last modified in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        if approver_details is not None:
            pulumi.set(__self__, "approver_details", approver_details)
        if closure_comment is not None:
            pulumi.set(__self__, "closure_comment", closure_comment)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if duration_in_hrs is not None:
            pulumi.set(__self__, "duration_in_hrs", duration_in_hrs)
        if entity_type is not None:
            pulumi.set(__self__, "entity_type", entity_type)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if notification_topic_id is not None:
            pulumi.set(__self__, "notification_topic_id", notification_topic_id)
        if number_of_approvers_required is not None:
            pulumi.set(__self__, "number_of_approvers_required", number_of_approvers_required)
        if privileged_api_control_id is not None:
            pulumi.set(__self__, "privileged_api_control_id", privileged_api_control_id)
        if privileged_api_control_name is not None:
            pulumi.set(__self__, "privileged_api_control_name", privileged_api_control_name)
        if privileged_operation_lists is not None:
            pulumi.set(__self__, "privileged_operation_lists", privileged_operation_lists)
        if reason_detail is not None:
            pulumi.set(__self__, "reason_detail", reason_detail)
        if reason_summary is not None:
            pulumi.set(__self__, "reason_summary", reason_summary)
        if request_id is not None:
            pulumi.set(__self__, "request_id", request_id)
        if requested_bies is not None:
            pulumi.set(__self__, "requested_bies", requested_bies)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_details is not None:
            pulumi.set(__self__, "state_details", state_details)
        if sub_resource_name_lists is not None:
            pulumi.set(__self__, "sub_resource_name_lists", sub_resource_name_lists)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if ticket_numbers is not None:
            pulumi.set(__self__, "ticket_numbers", ticket_numbers)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_requested_for_future_access is not None:
            pulumi.set(__self__, "time_requested_for_future_access", time_requested_for_future_access)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="approverDetails")
    def approver_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiaccesscontrolPrivilegedApiRequestApproverDetailArgs']]]]:
        """
        Contains the approver details who have approved the privilegedApi Request during the initial request.
        """
        return pulumi.get(self, "approver_details")

    @approver_details.setter
    def approver_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiaccesscontrolPrivilegedApiRequestApproverDetailArgs']]]]):
        pulumi.set(self, "approver_details", value)

    @property
    @pulumi.getter(name="closureComment")
    def closure_comment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The comment entered by the operator while closing the request.
        """
        return pulumi.get(self, "closure_comment")

    @closure_comment.setter
    def closure_comment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "closure_comment", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the privilegedApi control. The name must be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="durationInHrs")
    def duration_in_hrs(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Duration in hours for which access is sought on the target resource.
        """
        return pulumi.get(self, "duration_in_hrs")

    @duration_in_hrs.setter
    def duration_in_hrs(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "duration_in_hrs", value)

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        entityType of resource for which the AccessRequest is applicable
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "entity_type", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        more in detail about the lifeCycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="notificationTopicId")
    def notification_topic_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Privileged Api Request.
        """
        return pulumi.get(self, "notification_topic_id")

    @notification_topic_id.setter
    def notification_topic_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notification_topic_id", value)

    @property
    @pulumi.getter(name="numberOfApproversRequired")
    def number_of_approvers_required(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of approvers required to approve an privilegedApi request.
        """
        return pulumi.get(self, "number_of_approvers_required")

    @number_of_approvers_required.setter
    def number_of_approvers_required(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "number_of_approvers_required", value)

    @property
    @pulumi.getter(name="privilegedApiControlId")
    def privileged_api_control_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the privilegedApi control governing the target resource.
        """
        return pulumi.get(self, "privileged_api_control_id")

    @privileged_api_control_id.setter
    def privileged_api_control_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "privileged_api_control_id", value)

    @property
    @pulumi.getter(name="privilegedApiControlName")
    def privileged_api_control_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the privilegedApi control governing the target resource.
        """
        return pulumi.get(self, "privileged_api_control_name")

    @privileged_api_control_name.setter
    def privileged_api_control_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "privileged_api_control_name", value)

    @property
    @pulumi.getter(name="privilegedOperationLists")
    def privileged_operation_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiaccesscontrolPrivilegedApiRequestPrivilegedOperationListArgs']]]]:
        """
        List of api names, attributes for which approval is sought by the user.
        """
        return pulumi.get(self, "privileged_operation_lists")

    @privileged_operation_lists.setter
    def privileged_operation_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiaccesscontrolPrivilegedApiRequestPrivilegedOperationListArgs']]]]):
        pulumi.set(self, "privileged_operation_lists", value)

    @property
    @pulumi.getter(name="reasonDetail")
    def reason_detail(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Reason in detail for which the operator is requesting access on the target resource.
        """
        return pulumi.get(self, "reason_detail")

    @reason_detail.setter
    def reason_detail(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reason_detail", value)

    @property
    @pulumi.getter(name="reasonSummary")
    def reason_summary(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Summary comment by the operator creating the access request.
        """
        return pulumi.get(self, "reason_summary")

    @reason_summary.setter
    def reason_summary(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reason_summary", value)

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This is an automatic identifier generated by the system which is easier for human comprehension.
        """
        return pulumi.get(self, "request_id")

    @request_id.setter
    def request_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "request_id", value)

    @property
    @pulumi.getter(name="requestedBies")
    def requested_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of Users who has created this privilegedApiRequest.
        """
        return pulumi.get(self, "requested_bies")

    @requested_bies.setter
    def requested_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "requested_bies", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the target resource associated with the access request. The operator raises an access request to get approval to access the target resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        resourceName for which the PrivilegedApiRequest is applicable
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_name", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        resourceType for which the AccessRequest is applicable
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Priority assigned to the access request by the operator
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the PrivilegedApiRequest.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A message that describes the current state of the PrivilegedApiControl in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "state_details")

    @state_details.setter
    def state_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state_details", value)

    @property
    @pulumi.getter(name="subResourceNameLists")
    def sub_resource_name_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The subresource names requested for approval.
        """
        return pulumi.get(self, "sub_resource_name_lists")

    @sub_resource_name_lists.setter
    def sub_resource_name_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "sub_resource_name_lists", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="ticketNumbers")
    def ticket_numbers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of ticket numbers related to this Privileged Api Access Request, e.g. Service Request (SR) number and JIRA ticket number.
        """
        return pulumi.get(self, "ticket_numbers")

    @ticket_numbers.setter
    def ticket_numbers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ticket_numbers", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time when the privilegedApi request was created in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeRequestedForFutureAccess")
    def time_requested_for_future_access(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time in future when the user for the privilegedApi request needs to be created in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z' 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_requested_for_future_access")

    @time_requested_for_future_access.setter
    def time_requested_for_future_access(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_requested_for_future_access", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time when the privilegedApi request was last modified in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:oci/apiaccesscontrolPrivilegedApiRequest:ApiaccesscontrolPrivilegedApiRequest")
class ApiaccesscontrolPrivilegedApiRequest(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 duration_in_hrs: Optional[pulumi.Input[builtins.int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 notification_topic_id: Optional[pulumi.Input[builtins.str]] = None,
                 privileged_operation_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiaccesscontrolPrivilegedApiRequestPrivilegedOperationListArgs', 'ApiaccesscontrolPrivilegedApiRequestPrivilegedOperationListArgsDict']]]]] = None,
                 reason_detail: Optional[pulumi.Input[builtins.str]] = None,
                 reason_summary: Optional[pulumi.Input[builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 severity: Optional[pulumi.Input[builtins.str]] = None,
                 sub_resource_name_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ticket_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 time_requested_for_future_access: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Privileged Api Request resource in Oracle Cloud Infrastructure Apiaccesscontrol service.

        Creates a PrivilegedApiRequest.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_privileged_api_request = oci.oci.ApiaccesscontrolPrivilegedApiRequest("test_privileged_api_request",
            privileged_operation_lists=[{
                "api_name": test_api["name"],
                "attribute_names": privileged_api_request_privileged_operation_list_attribute_names,
            }],
            reason_summary=privileged_api_request_reason_summary,
            resource_id=test_resource["id"],
            compartment_id=compartment_id,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            duration_in_hrs=privileged_api_request_duration_in_hrs,
            freeform_tags={
                "Department": "Finance",
            },
            notification_topic_id=test_notification_topic["id"],
            reason_detail=privileged_api_request_reason_detail,
            severity=privileged_api_request_severity,
            sub_resource_name_lists=privileged_api_request_sub_resource_name_list,
            ticket_numbers=privileged_api_request_ticket_numbers,
            time_requested_for_future_access=privileged_api_request_time_requested_for_future_access)
        ```

        ## Import

        PrivilegedApiRequests can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:oci/apiaccesscontrolPrivilegedApiRequest:ApiaccesscontrolPrivilegedApiRequest test_privileged_api_request "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.int] duration_in_hrs: Duration in hours for which access is sought on the target resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] notification_topic_id: The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Privileged Api Request.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApiaccesscontrolPrivilegedApiRequestPrivilegedOperationListArgs', 'ApiaccesscontrolPrivilegedApiRequestPrivilegedOperationListArgsDict']]]] privileged_operation_lists: List of api names, attributes for which approval is sought by the user.
        :param pulumi.Input[builtins.str] reason_detail: Reason in detail for which the operator is requesting access on the target resource.
        :param pulumi.Input[builtins.str] reason_summary: Summary comment by the operator creating the access request.
        :param pulumi.Input[builtins.str] resource_id: The OCID of the target resource associated with the access request. The operator raises an access request to get approval to access the target resource.
        :param pulumi.Input[builtins.str] severity: Priority assigned to the access request by the operator
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sub_resource_name_lists: The subresource names requested for approval.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ticket_numbers: A list of ticket numbers related to this Privileged Api Access Request, e.g. Service Request (SR) number and JIRA ticket number.
        :param pulumi.Input[builtins.str] time_requested_for_future_access: Time in future when the user for the privilegedApi request needs to be created in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z' 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiaccesscontrolPrivilegedApiRequestArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Privileged Api Request resource in Oracle Cloud Infrastructure Apiaccesscontrol service.

        Creates a PrivilegedApiRequest.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_privileged_api_request = oci.oci.ApiaccesscontrolPrivilegedApiRequest("test_privileged_api_request",
            privileged_operation_lists=[{
                "api_name": test_api["name"],
                "attribute_names": privileged_api_request_privileged_operation_list_attribute_names,
            }],
            reason_summary=privileged_api_request_reason_summary,
            resource_id=test_resource["id"],
            compartment_id=compartment_id,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            duration_in_hrs=privileged_api_request_duration_in_hrs,
            freeform_tags={
                "Department": "Finance",
            },
            notification_topic_id=test_notification_topic["id"],
            reason_detail=privileged_api_request_reason_detail,
            severity=privileged_api_request_severity,
            sub_resource_name_lists=privileged_api_request_sub_resource_name_list,
            ticket_numbers=privileged_api_request_ticket_numbers,
            time_requested_for_future_access=privileged_api_request_time_requested_for_future_access)
        ```

        ## Import

        PrivilegedApiRequests can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:oci/apiaccesscontrolPrivilegedApiRequest:ApiaccesscontrolPrivilegedApiRequest test_privileged_api_request "id"
        ```

        :param str resource_name: The name of the resource.
        :param ApiaccesscontrolPrivilegedApiRequestArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiaccesscontrolPrivilegedApiRequestArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 duration_in_hrs: Optional[pulumi.Input[builtins.int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 notification_topic_id: Optional[pulumi.Input[builtins.str]] = None,
                 privileged_operation_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiaccesscontrolPrivilegedApiRequestPrivilegedOperationListArgs', 'ApiaccesscontrolPrivilegedApiRequestPrivilegedOperationListArgsDict']]]]] = None,
                 reason_detail: Optional[pulumi.Input[builtins.str]] = None,
                 reason_summary: Optional[pulumi.Input[builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 severity: Optional[pulumi.Input[builtins.str]] = None,
                 sub_resource_name_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ticket_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 time_requested_for_future_access: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiaccesscontrolPrivilegedApiRequestArgs.__new__(ApiaccesscontrolPrivilegedApiRequestArgs)

            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["duration_in_hrs"] = duration_in_hrs
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["notification_topic_id"] = notification_topic_id
            if privileged_operation_lists is None and not opts.urn:
                raise TypeError("Missing required property 'privileged_operation_lists'")
            __props__.__dict__["privileged_operation_lists"] = privileged_operation_lists
            __props__.__dict__["reason_detail"] = reason_detail
            if reason_summary is None and not opts.urn:
                raise TypeError("Missing required property 'reason_summary'")
            __props__.__dict__["reason_summary"] = reason_summary
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            __props__.__dict__["severity"] = severity
            __props__.__dict__["sub_resource_name_lists"] = sub_resource_name_lists
            __props__.__dict__["ticket_numbers"] = ticket_numbers
            __props__.__dict__["time_requested_for_future_access"] = time_requested_for_future_access
            __props__.__dict__["approver_details"] = None
            __props__.__dict__["closure_comment"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["entity_type"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["number_of_approvers_required"] = None
            __props__.__dict__["privileged_api_control_id"] = None
            __props__.__dict__["privileged_api_control_name"] = None
            __props__.__dict__["request_id"] = None
            __props__.__dict__["requested_bies"] = None
            __props__.__dict__["resource_name"] = None
            __props__.__dict__["resource_type"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_details"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(ApiaccesscontrolPrivilegedApiRequest, __self__).__init__(
            'oci:oci/apiaccesscontrolPrivilegedApiRequest:ApiaccesscontrolPrivilegedApiRequest',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            approver_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiaccesscontrolPrivilegedApiRequestApproverDetailArgs', 'ApiaccesscontrolPrivilegedApiRequestApproverDetailArgsDict']]]]] = None,
            closure_comment: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            duration_in_hrs: Optional[pulumi.Input[builtins.int]] = None,
            entity_type: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            notification_topic_id: Optional[pulumi.Input[builtins.str]] = None,
            number_of_approvers_required: Optional[pulumi.Input[builtins.int]] = None,
            privileged_api_control_id: Optional[pulumi.Input[builtins.str]] = None,
            privileged_api_control_name: Optional[pulumi.Input[builtins.str]] = None,
            privileged_operation_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiaccesscontrolPrivilegedApiRequestPrivilegedOperationListArgs', 'ApiaccesscontrolPrivilegedApiRequestPrivilegedOperationListArgsDict']]]]] = None,
            reason_detail: Optional[pulumi.Input[builtins.str]] = None,
            reason_summary: Optional[pulumi.Input[builtins.str]] = None,
            request_id: Optional[pulumi.Input[builtins.str]] = None,
            requested_bies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            resource_id: Optional[pulumi.Input[builtins.str]] = None,
            resource_name_: Optional[pulumi.Input[builtins.str]] = None,
            resource_type: Optional[pulumi.Input[builtins.str]] = None,
            severity: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            state_details: Optional[pulumi.Input[builtins.str]] = None,
            sub_resource_name_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            ticket_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_requested_for_future_access: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'ApiaccesscontrolPrivilegedApiRequest':
        """
        Get an existing ApiaccesscontrolPrivilegedApiRequest resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApiaccesscontrolPrivilegedApiRequestApproverDetailArgs', 'ApiaccesscontrolPrivilegedApiRequestApproverDetailArgsDict']]]] approver_details: Contains the approver details who have approved the privilegedApi Request during the initial request.
        :param pulumi.Input[builtins.str] closure_comment: The comment entered by the operator while closing the request.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: Name of the privilegedApi control. The name must be unique.
        :param pulumi.Input[builtins.int] duration_in_hrs: Duration in hours for which access is sought on the target resource.
        :param pulumi.Input[builtins.str] entity_type: entityType of resource for which the AccessRequest is applicable
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] lifecycle_details: more in detail about the lifeCycleState.
        :param pulumi.Input[builtins.str] notification_topic_id: The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Privileged Api Request.
        :param pulumi.Input[builtins.int] number_of_approvers_required: Number of approvers required to approve an privilegedApi request.
        :param pulumi.Input[builtins.str] privileged_api_control_id: The OCID of the privilegedApi control governing the target resource.
        :param pulumi.Input[builtins.str] privileged_api_control_name: Name of the privilegedApi control governing the target resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApiaccesscontrolPrivilegedApiRequestPrivilegedOperationListArgs', 'ApiaccesscontrolPrivilegedApiRequestPrivilegedOperationListArgsDict']]]] privileged_operation_lists: List of api names, attributes for which approval is sought by the user.
        :param pulumi.Input[builtins.str] reason_detail: Reason in detail for which the operator is requesting access on the target resource.
        :param pulumi.Input[builtins.str] reason_summary: Summary comment by the operator creating the access request.
        :param pulumi.Input[builtins.str] request_id: This is an automatic identifier generated by the system which is easier for human comprehension.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] requested_bies: List of Users who has created this privilegedApiRequest.
        :param pulumi.Input[builtins.str] resource_id: The OCID of the target resource associated with the access request. The operator raises an access request to get approval to access the target resource.
        :param pulumi.Input[builtins.str] resource_name_: resourceName for which the PrivilegedApiRequest is applicable
        :param pulumi.Input[builtins.str] resource_type: resourceType for which the AccessRequest is applicable
        :param pulumi.Input[builtins.str] severity: Priority assigned to the access request by the operator
        :param pulumi.Input[builtins.str] state: The current state of the PrivilegedApiRequest.
        :param pulumi.Input[builtins.str] state_details: A message that describes the current state of the PrivilegedApiControl in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sub_resource_name_lists: The subresource names requested for approval.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ticket_numbers: A list of ticket numbers related to this Privileged Api Access Request, e.g. Service Request (SR) number and JIRA ticket number.
        :param pulumi.Input[builtins.str] time_created: Time when the privilegedApi request was created in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[builtins.str] time_requested_for_future_access: Time in future when the user for the privilegedApi request needs to be created in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z' 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_updated: Time when the privilegedApi request was last modified in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiaccesscontrolPrivilegedApiRequestState.__new__(_ApiaccesscontrolPrivilegedApiRequestState)

        __props__.__dict__["approver_details"] = approver_details
        __props__.__dict__["closure_comment"] = closure_comment
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["duration_in_hrs"] = duration_in_hrs
        __props__.__dict__["entity_type"] = entity_type
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["notification_topic_id"] = notification_topic_id
        __props__.__dict__["number_of_approvers_required"] = number_of_approvers_required
        __props__.__dict__["privileged_api_control_id"] = privileged_api_control_id
        __props__.__dict__["privileged_api_control_name"] = privileged_api_control_name
        __props__.__dict__["privileged_operation_lists"] = privileged_operation_lists
        __props__.__dict__["reason_detail"] = reason_detail
        __props__.__dict__["reason_summary"] = reason_summary
        __props__.__dict__["request_id"] = request_id
        __props__.__dict__["requested_bies"] = requested_bies
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["resource_name"] = resource_name_
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["severity"] = severity
        __props__.__dict__["state"] = state
        __props__.__dict__["state_details"] = state_details
        __props__.__dict__["sub_resource_name_lists"] = sub_resource_name_lists
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["ticket_numbers"] = ticket_numbers
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_requested_for_future_access"] = time_requested_for_future_access
        __props__.__dict__["time_updated"] = time_updated
        return ApiaccesscontrolPrivilegedApiRequest(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="approverDetails")
    def approver_details(self) -> pulumi.Output[Sequence['outputs.ApiaccesscontrolPrivilegedApiRequestApproverDetail']]:
        """
        Contains the approver details who have approved the privilegedApi Request during the initial request.
        """
        return pulumi.get(self, "approver_details")

    @property
    @pulumi.getter(name="closureComment")
    def closure_comment(self) -> pulumi.Output[builtins.str]:
        """
        The comment entered by the operator while closing the request.
        """
        return pulumi.get(self, "closure_comment")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the privilegedApi control. The name must be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="durationInHrs")
    def duration_in_hrs(self) -> pulumi.Output[builtins.int]:
        """
        Duration in hours for which access is sought on the target resource.
        """
        return pulumi.get(self, "duration_in_hrs")

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> pulumi.Output[builtins.str]:
        """
        entityType of resource for which the AccessRequest is applicable
        """
        return pulumi.get(self, "entity_type")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        more in detail about the lifeCycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="notificationTopicId")
    def notification_topic_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Privileged Api Request.
        """
        return pulumi.get(self, "notification_topic_id")

    @property
    @pulumi.getter(name="numberOfApproversRequired")
    def number_of_approvers_required(self) -> pulumi.Output[builtins.int]:
        """
        Number of approvers required to approve an privilegedApi request.
        """
        return pulumi.get(self, "number_of_approvers_required")

    @property
    @pulumi.getter(name="privilegedApiControlId")
    def privileged_api_control_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the privilegedApi control governing the target resource.
        """
        return pulumi.get(self, "privileged_api_control_id")

    @property
    @pulumi.getter(name="privilegedApiControlName")
    def privileged_api_control_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the privilegedApi control governing the target resource.
        """
        return pulumi.get(self, "privileged_api_control_name")

    @property
    @pulumi.getter(name="privilegedOperationLists")
    def privileged_operation_lists(self) -> pulumi.Output[Sequence['outputs.ApiaccesscontrolPrivilegedApiRequestPrivilegedOperationList']]:
        """
        List of api names, attributes for which approval is sought by the user.
        """
        return pulumi.get(self, "privileged_operation_lists")

    @property
    @pulumi.getter(name="reasonDetail")
    def reason_detail(self) -> pulumi.Output[builtins.str]:
        """
        Reason in detail for which the operator is requesting access on the target resource.
        """
        return pulumi.get(self, "reason_detail")

    @property
    @pulumi.getter(name="reasonSummary")
    def reason_summary(self) -> pulumi.Output[builtins.str]:
        """
        Summary comment by the operator creating the access request.
        """
        return pulumi.get(self, "reason_summary")

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> pulumi.Output[builtins.str]:
        """
        This is an automatic identifier generated by the system which is easier for human comprehension.
        """
        return pulumi.get(self, "request_id")

    @property
    @pulumi.getter(name="requestedBies")
    def requested_bies(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of Users who has created this privilegedApiRequest.
        """
        return pulumi.get(self, "requested_bies")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the target resource associated with the access request. The operator raises an access request to get approval to access the target resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> pulumi.Output[builtins.str]:
        """
        resourceName for which the PrivilegedApiRequest is applicable
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[builtins.str]:
        """
        resourceType for which the AccessRequest is applicable
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Output[builtins.str]:
        """
        Priority assigned to the access request by the operator
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the PrivilegedApiRequest.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> pulumi.Output[builtins.str]:
        """
        A message that describes the current state of the PrivilegedApiControl in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "state_details")

    @property
    @pulumi.getter(name="subResourceNameLists")
    def sub_resource_name_lists(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The subresource names requested for approval.
        """
        return pulumi.get(self, "sub_resource_name_lists")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="ticketNumbers")
    def ticket_numbers(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of ticket numbers related to this Privileged Api Access Request, e.g. Service Request (SR) number and JIRA ticket number.
        """
        return pulumi.get(self, "ticket_numbers")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        Time when the privilegedApi request was created in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeRequestedForFutureAccess")
    def time_requested_for_future_access(self) -> pulumi.Output[builtins.str]:
        """
        Time in future when the user for the privilegedApi request needs to be created in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z' 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_requested_for_future_access")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        Time when the privilegedApi request was last modified in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")

