# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DbmulticloudOracleDbAzureBlobMountArgs', 'DbmulticloudOracleDbAzureBlobMount']

@pulumi.input_type
class DbmulticloudOracleDbAzureBlobMountArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 oracle_db_azure_blob_container_id: pulumi.Input[builtins.str],
                 oracle_db_azure_connector_id: pulumi.Input[builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a DbmulticloudOracleDbAzureBlobMount resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains VMs where to mount Azure Container.
        :param pulumi.Input[builtins.str] display_name: (Updatable) Oracle DB Azure Blob Mount Resource name.
        :param pulumi.Input[builtins.str] oracle_db_azure_blob_container_id: (Updatable) The OCID of the Oracle DB Azure Blob Container Resource.
        :param pulumi.Input[builtins.str] oracle_db_azure_connector_id: (Updatable) The OCID of the Oracle DB Azure Connector Resource.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "oracle_db_azure_blob_container_id", oracle_db_azure_blob_container_id)
        pulumi.set(__self__, "oracle_db_azure_connector_id", oracle_db_azure_connector_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The OCID of the compartment that contains VMs where to mount Azure Container.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Oracle DB Azure Blob Mount Resource name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="oracleDbAzureBlobContainerId")
    def oracle_db_azure_blob_container_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The OCID of the Oracle DB Azure Blob Container Resource.
        """
        return pulumi.get(self, "oracle_db_azure_blob_container_id")

    @oracle_db_azure_blob_container_id.setter
    def oracle_db_azure_blob_container_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "oracle_db_azure_blob_container_id", value)

    @property
    @pulumi.getter(name="oracleDbAzureConnectorId")
    def oracle_db_azure_connector_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The OCID of the Oracle DB Azure Connector Resource.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "oracle_db_azure_connector_id")

    @oracle_db_azure_connector_id.setter
    def oracle_db_azure_connector_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "oracle_db_azure_connector_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _DbmulticloudOracleDbAzureBlobMountState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 last_modification: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_state_details: Optional[pulumi.Input[builtins.str]] = None,
                 mount_path: Optional[pulumi.Input[builtins.str]] = None,
                 oracle_db_azure_blob_container_id: Optional[pulumi.Input[builtins.str]] = None,
                 oracle_db_azure_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DbmulticloudOracleDbAzureBlobMount resources.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains VMs where to mount Azure Container.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) Oracle DB Azure Blob Mount Resource name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] last_modification: Description of the latest modification of the Oracle DB Azure Blob Mount Resource.
        :param pulumi.Input[builtins.str] lifecycle_state_details: Description of the current lifecycle state in more detail.
        :param pulumi.Input[builtins.str] mount_path: Azure Container mount path.
        :param pulumi.Input[builtins.str] oracle_db_azure_blob_container_id: (Updatable) The OCID of the Oracle DB Azure Blob Container Resource.
        :param pulumi.Input[builtins.str] oracle_db_azure_connector_id: (Updatable) The OCID of the Oracle DB Azure Connector Resource.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current lifecycle state of the Azure Arc Agent Resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: Time when the Oracle DB Azure Blob Mount was created in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[builtins.str] time_updated: Time when the Oracle DB Azure Blob Mount was last modified, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if last_modification is not None:
            pulumi.set(__self__, "last_modification", last_modification)
        if lifecycle_state_details is not None:
            pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if oracle_db_azure_blob_container_id is not None:
            pulumi.set(__self__, "oracle_db_azure_blob_container_id", oracle_db_azure_blob_container_id)
        if oracle_db_azure_connector_id is not None:
            pulumi.set(__self__, "oracle_db_azure_connector_id", oracle_db_azure_connector_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the compartment that contains VMs where to mount Azure Container.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle DB Azure Blob Mount Resource name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lastModification")
    def last_modification(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the latest modification of the Oracle DB Azure Blob Mount Resource.
        """
        return pulumi.get(self, "last_modification")

    @last_modification.setter
    def last_modification(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_modification", value)

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @lifecycle_state_details.setter
    def lifecycle_state_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_state_details", value)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Azure Container mount path.
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter(name="oracleDbAzureBlobContainerId")
    def oracle_db_azure_blob_container_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the Oracle DB Azure Blob Container Resource.
        """
        return pulumi.get(self, "oracle_db_azure_blob_container_id")

    @oracle_db_azure_blob_container_id.setter
    def oracle_db_azure_blob_container_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "oracle_db_azure_blob_container_id", value)

    @property
    @pulumi.getter(name="oracleDbAzureConnectorId")
    def oracle_db_azure_connector_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the Oracle DB Azure Connector Resource.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "oracle_db_azure_connector_id")

    @oracle_db_azure_connector_id.setter
    def oracle_db_azure_connector_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "oracle_db_azure_connector_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current lifecycle state of the Azure Arc Agent Resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time when the Oracle DB Azure Blob Mount was created in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time when the Oracle DB Azure Blob Mount was last modified, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:oci/dbmulticloudOracleDbAzureBlobMount:DbmulticloudOracleDbAzureBlobMount")
class DbmulticloudOracleDbAzureBlobMount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 oracle_db_azure_blob_container_id: Optional[pulumi.Input[builtins.str]] = None,
                 oracle_db_azure_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Oracle Db Azure Blob Mount resource in Oracle Cloud Infrastructure Dbmulticloud service.

        Creates Oracle DB Azure Blob Mount resource and mounts Azure Container in Oracle Cloud Infrastructure Database Resource,
        based on provided Azure Container details and Database Resource ID.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_oracle_db_azure_blob_mount = oci.oci.DbmulticloudOracleDbAzureBlobMount("test_oracle_db_azure_blob_mount",
            compartment_id=compartment_id,
            display_name=oracle_db_azure_blob_mount_display_name,
            oracle_db_azure_blob_container_id=test_oracle_db_azure_blob_container["id"],
            oracle_db_azure_connector_id=test_oracle_db_azure_connector["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        OracleDbAzureBlobMounts can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:oci/dbmulticloudOracleDbAzureBlobMount:DbmulticloudOracleDbAzureBlobMount test_oracle_db_azure_blob_mount "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains VMs where to mount Azure Container.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) Oracle DB Azure Blob Mount Resource name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] oracle_db_azure_blob_container_id: (Updatable) The OCID of the Oracle DB Azure Blob Container Resource.
        :param pulumi.Input[builtins.str] oracle_db_azure_connector_id: (Updatable) The OCID of the Oracle DB Azure Connector Resource.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbmulticloudOracleDbAzureBlobMountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Oracle Db Azure Blob Mount resource in Oracle Cloud Infrastructure Dbmulticloud service.

        Creates Oracle DB Azure Blob Mount resource and mounts Azure Container in Oracle Cloud Infrastructure Database Resource,
        based on provided Azure Container details and Database Resource ID.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_oracle_db_azure_blob_mount = oci.oci.DbmulticloudOracleDbAzureBlobMount("test_oracle_db_azure_blob_mount",
            compartment_id=compartment_id,
            display_name=oracle_db_azure_blob_mount_display_name,
            oracle_db_azure_blob_container_id=test_oracle_db_azure_blob_container["id"],
            oracle_db_azure_connector_id=test_oracle_db_azure_connector["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        OracleDbAzureBlobMounts can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:oci/dbmulticloudOracleDbAzureBlobMount:DbmulticloudOracleDbAzureBlobMount test_oracle_db_azure_blob_mount "id"
        ```

        :param str resource_name: The name of the resource.
        :param DbmulticloudOracleDbAzureBlobMountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbmulticloudOracleDbAzureBlobMountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 oracle_db_azure_blob_container_id: Optional[pulumi.Input[builtins.str]] = None,
                 oracle_db_azure_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbmulticloudOracleDbAzureBlobMountArgs.__new__(DbmulticloudOracleDbAzureBlobMountArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if oracle_db_azure_blob_container_id is None and not opts.urn:
                raise TypeError("Missing required property 'oracle_db_azure_blob_container_id'")
            __props__.__dict__["oracle_db_azure_blob_container_id"] = oracle_db_azure_blob_container_id
            if oracle_db_azure_connector_id is None and not opts.urn:
                raise TypeError("Missing required property 'oracle_db_azure_connector_id'")
            __props__.__dict__["oracle_db_azure_connector_id"] = oracle_db_azure_connector_id
            __props__.__dict__["last_modification"] = None
            __props__.__dict__["lifecycle_state_details"] = None
            __props__.__dict__["mount_path"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(DbmulticloudOracleDbAzureBlobMount, __self__).__init__(
            'oci:oci/dbmulticloudOracleDbAzureBlobMount:DbmulticloudOracleDbAzureBlobMount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            last_modification: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_state_details: Optional[pulumi.Input[builtins.str]] = None,
            mount_path: Optional[pulumi.Input[builtins.str]] = None,
            oracle_db_azure_blob_container_id: Optional[pulumi.Input[builtins.str]] = None,
            oracle_db_azure_connector_id: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'DbmulticloudOracleDbAzureBlobMount':
        """
        Get an existing DbmulticloudOracleDbAzureBlobMount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains VMs where to mount Azure Container.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) Oracle DB Azure Blob Mount Resource name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] last_modification: Description of the latest modification of the Oracle DB Azure Blob Mount Resource.
        :param pulumi.Input[builtins.str] lifecycle_state_details: Description of the current lifecycle state in more detail.
        :param pulumi.Input[builtins.str] mount_path: Azure Container mount path.
        :param pulumi.Input[builtins.str] oracle_db_azure_blob_container_id: (Updatable) The OCID of the Oracle DB Azure Blob Container Resource.
        :param pulumi.Input[builtins.str] oracle_db_azure_connector_id: (Updatable) The OCID of the Oracle DB Azure Connector Resource.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current lifecycle state of the Azure Arc Agent Resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: Time when the Oracle DB Azure Blob Mount was created in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[builtins.str] time_updated: Time when the Oracle DB Azure Blob Mount was last modified, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbmulticloudOracleDbAzureBlobMountState.__new__(_DbmulticloudOracleDbAzureBlobMountState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["last_modification"] = last_modification
        __props__.__dict__["lifecycle_state_details"] = lifecycle_state_details
        __props__.__dict__["mount_path"] = mount_path
        __props__.__dict__["oracle_db_azure_blob_container_id"] = oracle_db_azure_blob_container_id
        __props__.__dict__["oracle_db_azure_connector_id"] = oracle_db_azure_connector_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return DbmulticloudOracleDbAzureBlobMount(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the compartment that contains VMs where to mount Azure Container.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle DB Azure Blob Mount Resource name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lastModification")
    def last_modification(self) -> pulumi.Output[builtins.str]:
        """
        Description of the latest modification of the Oracle DB Azure Blob Mount Resource.
        """
        return pulumi.get(self, "last_modification")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> pulumi.Output[builtins.str]:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> pulumi.Output[builtins.str]:
        """
        Azure Container mount path.
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter(name="oracleDbAzureBlobContainerId")
    def oracle_db_azure_blob_container_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the Oracle DB Azure Blob Container Resource.
        """
        return pulumi.get(self, "oracle_db_azure_blob_container_id")

    @property
    @pulumi.getter(name="oracleDbAzureConnectorId")
    def oracle_db_azure_connector_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the Oracle DB Azure Connector Resource.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "oracle_db_azure_connector_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current lifecycle state of the Azure Arc Agent Resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        Time when the Oracle DB Azure Blob Mount was created in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        Time when the Oracle DB Azure Blob Mount was last modified, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")

