# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DbmulticloudOracleDbAzureVaultArgs', 'DbmulticloudOracleDbAzureVault']

@pulumi.input_type
class DbmulticloudOracleDbAzureVaultArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 oracle_db_connector_id: pulumi.Input[builtins.str],
                 azure_vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 oracle_db_azure_resource_group: Optional[pulumi.Input[builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a DbmulticloudOracleDbAzureVault resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains DB Azure Vault Resource.
        :param pulumi.Input[builtins.str] display_name: (Updatable) Display name of DB Azure Vault.
        :param pulumi.Input[builtins.str] oracle_db_connector_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB Connector Resource.
        :param pulumi.Input[builtins.str] azure_vault_id: (Updatable) Azure Vault Id.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] location: (Updatable) Vault Resource Location.
        :param pulumi.Input[builtins.str] oracle_db_azure_resource_group: (Updatable) Display name of Azure Resource Group.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] properties: (Updatable) Resource's properties.
        :param pulumi.Input[builtins.str] type: (Updatable) Vault Resource Type.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "oracle_db_connector_id", oracle_db_connector_id)
        if azure_vault_id is not None:
            pulumi.set(__self__, "azure_vault_id", azure_vault_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if oracle_db_azure_resource_group is not None:
            pulumi.set(__self__, "oracle_db_azure_resource_group", oracle_db_azure_resource_group)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains DB Azure Vault Resource.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Display name of DB Azure Vault.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="oracleDbConnectorId")
    def oracle_db_connector_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB Connector Resource.
        """
        return pulumi.get(self, "oracle_db_connector_id")

    @oracle_db_connector_id.setter
    def oracle_db_connector_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "oracle_db_connector_id", value)

    @property
    @pulumi.getter(name="azureVaultId")
    def azure_vault_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Azure Vault Id.
        """
        return pulumi.get(self, "azure_vault_id")

    @azure_vault_id.setter
    def azure_vault_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "azure_vault_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Vault Resource Location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="oracleDbAzureResourceGroup")
    def oracle_db_azure_resource_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Display name of Azure Resource Group.
        """
        return pulumi.get(self, "oracle_db_azure_resource_group")

    @oracle_db_azure_resource_group.setter
    def oracle_db_azure_resource_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "oracle_db_azure_resource_group", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Resource's properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Vault Resource Type.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _DbmulticloudOracleDbAzureVaultState:
    def __init__(__self__, *,
                 azure_vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 last_modification: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_state_details: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 oracle_db_azure_resource_group: Optional[pulumi.Input[builtins.str]] = None,
                 oracle_db_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DbmulticloudOracleDbAzureVault resources.
        :param pulumi.Input[builtins.str] azure_vault_id: (Updatable) Azure Vault Id.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains DB Azure Vault Resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) Display name of DB Azure Vault.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] last_modification: Description of the latest modification of the DB Azure Vault Resource.
        :param pulumi.Input[builtins.str] lifecycle_state_details: Description of the current lifecycle state in more detail.
        :param pulumi.Input[builtins.str] location: (Updatable) Vault Resource Location.
        :param pulumi.Input[builtins.str] oracle_db_azure_resource_group: (Updatable) Display name of Azure Resource Group.
        :param pulumi.Input[builtins.str] oracle_db_connector_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB Connector Resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] properties: (Updatable) Resource's properties.
        :param pulumi.Input[builtins.str] state: The lifecycle state of the DB Azure Vault Resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: Time when the DB Azure Vault was created in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-23T21:10:29.600Z'
        :param pulumi.Input[builtins.str] time_updated: Time when the DB Azure Vault was last modified, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-23T21:10:29.600Z'
        :param pulumi.Input[builtins.str] type: (Updatable) Vault Resource Type.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if azure_vault_id is not None:
            pulumi.set(__self__, "azure_vault_id", azure_vault_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if last_modification is not None:
            pulumi.set(__self__, "last_modification", last_modification)
        if lifecycle_state_details is not None:
            pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if oracle_db_azure_resource_group is not None:
            pulumi.set(__self__, "oracle_db_azure_resource_group", oracle_db_azure_resource_group)
        if oracle_db_connector_id is not None:
            pulumi.set(__self__, "oracle_db_connector_id", oracle_db_connector_id)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="azureVaultId")
    def azure_vault_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Azure Vault Id.
        """
        return pulumi.get(self, "azure_vault_id")

    @azure_vault_id.setter
    def azure_vault_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "azure_vault_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains DB Azure Vault Resource.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Display name of DB Azure Vault.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lastModification")
    def last_modification(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the latest modification of the DB Azure Vault Resource.
        """
        return pulumi.get(self, "last_modification")

    @last_modification.setter
    def last_modification(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_modification", value)

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @lifecycle_state_details.setter
    def lifecycle_state_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_state_details", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Vault Resource Location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="oracleDbAzureResourceGroup")
    def oracle_db_azure_resource_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Display name of Azure Resource Group.
        """
        return pulumi.get(self, "oracle_db_azure_resource_group")

    @oracle_db_azure_resource_group.setter
    def oracle_db_azure_resource_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "oracle_db_azure_resource_group", value)

    @property
    @pulumi.getter(name="oracleDbConnectorId")
    def oracle_db_connector_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB Connector Resource.
        """
        return pulumi.get(self, "oracle_db_connector_id")

    @oracle_db_connector_id.setter
    def oracle_db_connector_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "oracle_db_connector_id", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Resource's properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The lifecycle state of the DB Azure Vault Resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time when the DB Azure Vault was created in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-23T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time when the DB Azure Vault was last modified, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-23T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Vault Resource Type.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("oci:oci/dbmulticloudOracleDbAzureVault:DbmulticloudOracleDbAzureVault")
class DbmulticloudOracleDbAzureVault(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure_vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 oracle_db_azure_resource_group: Optional[pulumi.Input[builtins.str]] = None,
                 oracle_db_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Oracle Db Azure Vault resource in Oracle Cloud Infrastructure Dbmulticloud service.

        Create DB Azure Vaults based on the provided information, this will fetch Keys related to Azure Vaults.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_oracle_db_azure_vault = oci.oci.DbmulticloudOracleDbAzureVault("test_oracle_db_azure_vault",
            compartment_id=compartment_id,
            display_name=oracle_db_azure_vault_display_name,
            oracle_db_connector_id=test_oracle_db_connector["id"],
            azure_vault_id=test_vault["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            location=oracle_db_azure_vault_location,
            oracle_db_azure_resource_group=oracle_db_azure_vault_oracle_db_azure_resource_group,
            properties=oracle_db_azure_vault_properties,
            type=oracle_db_azure_vault_type)
        ```

        ## Import

        OracleDbAzureVaults can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:oci/dbmulticloudOracleDbAzureVault:DbmulticloudOracleDbAzureVault test_oracle_db_azure_vault "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] azure_vault_id: (Updatable) Azure Vault Id.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains DB Azure Vault Resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) Display name of DB Azure Vault.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] location: (Updatable) Vault Resource Location.
        :param pulumi.Input[builtins.str] oracle_db_azure_resource_group: (Updatable) Display name of Azure Resource Group.
        :param pulumi.Input[builtins.str] oracle_db_connector_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB Connector Resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] properties: (Updatable) Resource's properties.
        :param pulumi.Input[builtins.str] type: (Updatable) Vault Resource Type.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbmulticloudOracleDbAzureVaultArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Oracle Db Azure Vault resource in Oracle Cloud Infrastructure Dbmulticloud service.

        Create DB Azure Vaults based on the provided information, this will fetch Keys related to Azure Vaults.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_oracle_db_azure_vault = oci.oci.DbmulticloudOracleDbAzureVault("test_oracle_db_azure_vault",
            compartment_id=compartment_id,
            display_name=oracle_db_azure_vault_display_name,
            oracle_db_connector_id=test_oracle_db_connector["id"],
            azure_vault_id=test_vault["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            location=oracle_db_azure_vault_location,
            oracle_db_azure_resource_group=oracle_db_azure_vault_oracle_db_azure_resource_group,
            properties=oracle_db_azure_vault_properties,
            type=oracle_db_azure_vault_type)
        ```

        ## Import

        OracleDbAzureVaults can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:oci/dbmulticloudOracleDbAzureVault:DbmulticloudOracleDbAzureVault test_oracle_db_azure_vault "id"
        ```

        :param str resource_name: The name of the resource.
        :param DbmulticloudOracleDbAzureVaultArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbmulticloudOracleDbAzureVaultArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure_vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 oracle_db_azure_resource_group: Optional[pulumi.Input[builtins.str]] = None,
                 oracle_db_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbmulticloudOracleDbAzureVaultArgs.__new__(DbmulticloudOracleDbAzureVaultArgs)

            __props__.__dict__["azure_vault_id"] = azure_vault_id
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["location"] = location
            __props__.__dict__["oracle_db_azure_resource_group"] = oracle_db_azure_resource_group
            if oracle_db_connector_id is None and not opts.urn:
                raise TypeError("Missing required property 'oracle_db_connector_id'")
            __props__.__dict__["oracle_db_connector_id"] = oracle_db_connector_id
            __props__.__dict__["properties"] = properties
            __props__.__dict__["type"] = type
            __props__.__dict__["last_modification"] = None
            __props__.__dict__["lifecycle_state_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(DbmulticloudOracleDbAzureVault, __self__).__init__(
            'oci:oci/dbmulticloudOracleDbAzureVault:DbmulticloudOracleDbAzureVault',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            azure_vault_id: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            last_modification: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_state_details: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            oracle_db_azure_resource_group: Optional[pulumi.Input[builtins.str]] = None,
            oracle_db_connector_id: Optional[pulumi.Input[builtins.str]] = None,
            properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'DbmulticloudOracleDbAzureVault':
        """
        Get an existing DbmulticloudOracleDbAzureVault resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] azure_vault_id: (Updatable) Azure Vault Id.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains DB Azure Vault Resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) Display name of DB Azure Vault.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] last_modification: Description of the latest modification of the DB Azure Vault Resource.
        :param pulumi.Input[builtins.str] lifecycle_state_details: Description of the current lifecycle state in more detail.
        :param pulumi.Input[builtins.str] location: (Updatable) Vault Resource Location.
        :param pulumi.Input[builtins.str] oracle_db_azure_resource_group: (Updatable) Display name of Azure Resource Group.
        :param pulumi.Input[builtins.str] oracle_db_connector_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB Connector Resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] properties: (Updatable) Resource's properties.
        :param pulumi.Input[builtins.str] state: The lifecycle state of the DB Azure Vault Resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: Time when the DB Azure Vault was created in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-23T21:10:29.600Z'
        :param pulumi.Input[builtins.str] time_updated: Time when the DB Azure Vault was last modified, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-23T21:10:29.600Z'
        :param pulumi.Input[builtins.str] type: (Updatable) Vault Resource Type.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbmulticloudOracleDbAzureVaultState.__new__(_DbmulticloudOracleDbAzureVaultState)

        __props__.__dict__["azure_vault_id"] = azure_vault_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["last_modification"] = last_modification
        __props__.__dict__["lifecycle_state_details"] = lifecycle_state_details
        __props__.__dict__["location"] = location
        __props__.__dict__["oracle_db_azure_resource_group"] = oracle_db_azure_resource_group
        __props__.__dict__["oracle_db_connector_id"] = oracle_db_connector_id
        __props__.__dict__["properties"] = properties
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        return DbmulticloudOracleDbAzureVault(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="azureVaultId")
    def azure_vault_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Azure Vault Id.
        """
        return pulumi.get(self, "azure_vault_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains DB Azure Vault Resource.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Display name of DB Azure Vault.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lastModification")
    def last_modification(self) -> pulumi.Output[builtins.str]:
        """
        Description of the latest modification of the DB Azure Vault Resource.
        """
        return pulumi.get(self, "last_modification")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> pulumi.Output[builtins.str]:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Vault Resource Location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="oracleDbAzureResourceGroup")
    def oracle_db_azure_resource_group(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Display name of Azure Resource Group.
        """
        return pulumi.get(self, "oracle_db_azure_resource_group")

    @property
    @pulumi.getter(name="oracleDbConnectorId")
    def oracle_db_connector_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB Connector Resource.
        """
        return pulumi.get(self, "oracle_db_connector_id")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Resource's properties.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The lifecycle state of the DB Azure Vault Resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        Time when the DB Azure Vault was created in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-23T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        Time when the DB Azure Vault was last modified, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-23T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Vault Resource Type.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

