# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetApiaccesscontrolPrivilegedApiRequestsResult',
    'AwaitableGetApiaccesscontrolPrivilegedApiRequestsResult',
    'get_apiaccesscontrol_privileged_api_requests',
    'get_apiaccesscontrol_privileged_api_requests_output',
]

@pulumi.output_type
class GetApiaccesscontrolPrivilegedApiRequestsResult:
    """
    A collection of values returned by getApiaccesscontrolPrivilegedApiRequests.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, privileged_api_request_collections=None, resource_id=None, resource_type=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if privileged_api_request_collections and not isinstance(privileged_api_request_collections, list):
            raise TypeError("Expected argument 'privileged_api_request_collections' to be a list")
        pulumi.set(__self__, "privileged_api_request_collections", privileged_api_request_collections)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The OCID of the compartment that contains the access request.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Name of the privilegedApi control. The name must be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetApiaccesscontrolPrivilegedApiRequestsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The OCID of the privilegedApi request.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="privilegedApiRequestCollections")
    def privileged_api_request_collections(self) -> Sequence['outputs.GetApiaccesscontrolPrivilegedApiRequestsPrivilegedApiRequestCollectionResult']:
        """
        The list of privileged_api_request_collection.
        """
        return pulumi.get(self, "privileged_api_request_collections")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[builtins.str]:
        """
        The OCID of the target resource associated with the access request. The operator raises an access request to get approval to access the target resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[builtins.str]:
        """
        resourceType for which the AccessRequest is applicable
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the PrivilegedApiRequest.
        """
        return pulumi.get(self, "state")


class AwaitableGetApiaccesscontrolPrivilegedApiRequestsResult(GetApiaccesscontrolPrivilegedApiRequestsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiaccesscontrolPrivilegedApiRequestsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            privileged_api_request_collections=self.privileged_api_request_collections,
            resource_id=self.resource_id,
            resource_type=self.resource_type,
            state=self.state)


def get_apiaccesscontrol_privileged_api_requests(compartment_id: Optional[builtins.str] = None,
                                                 display_name: Optional[builtins.str] = None,
                                                 filters: Optional[Sequence[Union['GetApiaccesscontrolPrivilegedApiRequestsFilterArgs', 'GetApiaccesscontrolPrivilegedApiRequestsFilterArgsDict']]] = None,
                                                 id: Optional[builtins.str] = None,
                                                 resource_id: Optional[builtins.str] = None,
                                                 resource_type: Optional[builtins.str] = None,
                                                 state: Optional[builtins.str] = None,
                                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiaccesscontrolPrivilegedApiRequestsResult:
    """
    This data source provides the list of Privileged Api Requests in Oracle Cloud Infrastructure Apiaccesscontrol service.

    Lists all privilegedApi requests in the compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_privileged_api_requests = oci.oci.get_apiaccesscontrol_privileged_api_requests(compartment_id=compartment_id,
        display_name=privileged_api_request_display_name,
        id=privileged_api_request_id,
        resource_id=test_resource["id"],
        resource_type=privileged_api_request_resource_type,
        state=privileged_api_request_state)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the PrivilegedApiRequest.
    :param builtins.str resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource .
    :param builtins.str resource_type: A filter to return only lists of resources that match the entire given service type.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['resourceId'] = resource_id
    __args__['resourceType'] = resource_type
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getApiaccesscontrolPrivilegedApiRequests:getApiaccesscontrolPrivilegedApiRequests', __args__, opts=opts, typ=GetApiaccesscontrolPrivilegedApiRequestsResult).value

    return AwaitableGetApiaccesscontrolPrivilegedApiRequestsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        privileged_api_request_collections=pulumi.get(__ret__, 'privileged_api_request_collections'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        state=pulumi.get(__ret__, 'state'))
def get_apiaccesscontrol_privileged_api_requests_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                        display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetApiaccesscontrolPrivilegedApiRequestsFilterArgs', 'GetApiaccesscontrolPrivilegedApiRequestsFilterArgsDict']]]]] = None,
                                                        id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                        resource_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                        resource_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                        state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiaccesscontrolPrivilegedApiRequestsResult]:
    """
    This data source provides the list of Privileged Api Requests in Oracle Cloud Infrastructure Apiaccesscontrol service.

    Lists all privilegedApi requests in the compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_privileged_api_requests = oci.oci.get_apiaccesscontrol_privileged_api_requests(compartment_id=compartment_id,
        display_name=privileged_api_request_display_name,
        id=privileged_api_request_id,
        resource_id=test_resource["id"],
        resource_type=privileged_api_request_resource_type,
        state=privileged_api_request_state)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the PrivilegedApiRequest.
    :param builtins.str resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource .
    :param builtins.str resource_type: A filter to return only lists of resources that match the entire given service type.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['resourceId'] = resource_id
    __args__['resourceType'] = resource_type
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getApiaccesscontrolPrivilegedApiRequests:getApiaccesscontrolPrivilegedApiRequests', __args__, opts=opts, typ=GetApiaccesscontrolPrivilegedApiRequestsResult)
    return __ret__.apply(lambda __response__: GetApiaccesscontrolPrivilegedApiRequestsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        privileged_api_request_collections=pulumi.get(__response__, 'privileged_api_request_collections'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        state=pulumi.get(__response__, 'state')))
