# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetWlmsManagedInstanceServersResult',
    'AwaitableGetWlmsManagedInstanceServersResult',
    'get_wlms_managed_instance_servers',
    'get_wlms_managed_instance_servers_output',
]

@pulumi.output_type
class GetWlmsManagedInstanceServersResult:
    """
    A collection of values returned by getWlmsManagedInstanceServers.
    """
    def __init__(__self__, filters=None, id=None, managed_instance_id=None, name=None, server_collections=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if server_collections and not isinstance(server_collections, list):
            raise TypeError("Expected argument 'server_collections' to be a list")
        pulumi.set(__self__, "server_collections", server_collections)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetWlmsManagedInstanceServersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> builtins.str:
        """
        The managed instance ID of the server.
        """
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serverCollections")
    def server_collections(self) -> Sequence['outputs.GetWlmsManagedInstanceServersServerCollectionResult']:
        """
        The list of server_collection.
        """
        return pulumi.get(self, "server_collections")


class AwaitableGetWlmsManagedInstanceServersResult(GetWlmsManagedInstanceServersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWlmsManagedInstanceServersResult(
            filters=self.filters,
            id=self.id,
            managed_instance_id=self.managed_instance_id,
            name=self.name,
            server_collections=self.server_collections)


def get_wlms_managed_instance_servers(filters: Optional[Sequence[Union['GetWlmsManagedInstanceServersFilterArgs', 'GetWlmsManagedInstanceServersFilterArgsDict']]] = None,
                                      managed_instance_id: Optional[builtins.str] = None,
                                      name: Optional[builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWlmsManagedInstanceServersResult:
    """
    This data source provides the list of Managed Instance Servers in Oracle Cloud Infrastructure Wlms service.

    Gets list of servers in a specific managed instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_servers = oci.oci.get_wlms_managed_instance_servers(managed_instance_id=test_managed_instance["id"],
        name=managed_instance_server_name)
    ```


    :param builtins.str managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance.
    :param builtins.str name: The name of the resource.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['managedInstanceId'] = managed_instance_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getWlmsManagedInstanceServers:getWlmsManagedInstanceServers', __args__, opts=opts, typ=GetWlmsManagedInstanceServersResult).value

    return AwaitableGetWlmsManagedInstanceServersResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        name=pulumi.get(__ret__, 'name'),
        server_collections=pulumi.get(__ret__, 'server_collections'))
def get_wlms_managed_instance_servers_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetWlmsManagedInstanceServersFilterArgs', 'GetWlmsManagedInstanceServersFilterArgsDict']]]]] = None,
                                             managed_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                                             name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWlmsManagedInstanceServersResult]:
    """
    This data source provides the list of Managed Instance Servers in Oracle Cloud Infrastructure Wlms service.

    Gets list of servers in a specific managed instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_servers = oci.oci.get_wlms_managed_instance_servers(managed_instance_id=test_managed_instance["id"],
        name=managed_instance_server_name)
    ```


    :param builtins.str managed_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance.
    :param builtins.str name: The name of the resource.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['managedInstanceId'] = managed_instance_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getWlmsManagedInstanceServers:getWlmsManagedInstanceServers', __args__, opts=opts, typ=GetWlmsManagedInstanceServersResult)
    return __ret__.apply(lambda __response__: GetWlmsManagedInstanceServersResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        managed_instance_id=pulumi.get(__response__, 'managed_instance_id'),
        name=pulumi.get(__response__, 'name'),
        server_collections=pulumi.get(__response__, 'server_collections')))
