# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetWlmsWlsDomainServerBackupsResult',
    'AwaitableGetWlmsWlsDomainServerBackupsResult',
    'get_wlms_wls_domain_server_backups',
    'get_wlms_wls_domain_server_backups_output',
]

@pulumi.output_type
class GetWlmsWlsDomainServerBackupsResult:
    """
    A collection of values returned by getWlmsWlsDomainServerBackups.
    """
    def __init__(__self__, backup_collections=None, filters=None, id=None, server_id=None, wls_domain_id=None):
        if backup_collections and not isinstance(backup_collections, list):
            raise TypeError("Expected argument 'backup_collections' to be a list")
        pulumi.set(__self__, "backup_collections", backup_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if server_id and not isinstance(server_id, str):
            raise TypeError("Expected argument 'server_id' to be a str")
        pulumi.set(__self__, "server_id", server_id)
        if wls_domain_id and not isinstance(wls_domain_id, str):
            raise TypeError("Expected argument 'wls_domain_id' to be a str")
        pulumi.set(__self__, "wls_domain_id", wls_domain_id)

    @property
    @pulumi.getter(name="backupCollections")
    def backup_collections(self) -> Sequence['outputs.GetWlmsWlsDomainServerBackupsBackupCollectionResult']:
        """
        The list of backup_collection.
        """
        return pulumi.get(self, "backup_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetWlmsWlsDomainServerBackupsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> builtins.str:
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter(name="wlsDomainId")
    def wls_domain_id(self) -> builtins.str:
        return pulumi.get(self, "wls_domain_id")


class AwaitableGetWlmsWlsDomainServerBackupsResult(GetWlmsWlsDomainServerBackupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWlmsWlsDomainServerBackupsResult(
            backup_collections=self.backup_collections,
            filters=self.filters,
            id=self.id,
            server_id=self.server_id,
            wls_domain_id=self.wls_domain_id)


def get_wlms_wls_domain_server_backups(filters: Optional[Sequence[Union['GetWlmsWlsDomainServerBackupsFilterArgs', 'GetWlmsWlsDomainServerBackupsFilterArgsDict']]] = None,
                                       server_id: Optional[builtins.str] = None,
                                       wls_domain_id: Optional[builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWlmsWlsDomainServerBackupsResult:
    """
    This data source provides the list of Wls Domain Server Backups in Oracle Cloud Infrastructure Wlms service.

    Gets a list of backups for the server of a specific WebLogic Domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_wls_domain_server_backups = oci.oci.get_wlms_wls_domain_server_backups(server_id=test_server["id"],
        wls_domain_id=test_wls_domain["id"])
    ```


    :param builtins.str server_id: The unique identifier of a server.
           
           **Note:** Not an [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str wls_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebLogic domain.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['serverId'] = server_id
    __args__['wlsDomainId'] = wls_domain_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getWlmsWlsDomainServerBackups:getWlmsWlsDomainServerBackups', __args__, opts=opts, typ=GetWlmsWlsDomainServerBackupsResult).value

    return AwaitableGetWlmsWlsDomainServerBackupsResult(
        backup_collections=pulumi.get(__ret__, 'backup_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        server_id=pulumi.get(__ret__, 'server_id'),
        wls_domain_id=pulumi.get(__ret__, 'wls_domain_id'))
def get_wlms_wls_domain_server_backups_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetWlmsWlsDomainServerBackupsFilterArgs', 'GetWlmsWlsDomainServerBackupsFilterArgsDict']]]]] = None,
                                              server_id: Optional[pulumi.Input[builtins.str]] = None,
                                              wls_domain_id: Optional[pulumi.Input[builtins.str]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWlmsWlsDomainServerBackupsResult]:
    """
    This data source provides the list of Wls Domain Server Backups in Oracle Cloud Infrastructure Wlms service.

    Gets a list of backups for the server of a specific WebLogic Domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_wls_domain_server_backups = oci.oci.get_wlms_wls_domain_server_backups(server_id=test_server["id"],
        wls_domain_id=test_wls_domain["id"])
    ```


    :param builtins.str server_id: The unique identifier of a server.
           
           **Note:** Not an [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str wls_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebLogic domain.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['serverId'] = server_id
    __args__['wlsDomainId'] = wls_domain_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getWlmsWlsDomainServerBackups:getWlmsWlsDomainServerBackups', __args__, opts=opts, typ=GetWlmsWlsDomainServerBackupsResult)
    return __ret__.apply(lambda __response__: GetWlmsWlsDomainServerBackupsResult(
        backup_collections=pulumi.get(__response__, 'backup_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        server_id=pulumi.get(__response__, 'server_id'),
        wls_domain_id=pulumi.get(__response__, 'wls_domain_id')))
