# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetControlResult',
    'AwaitableGetControlResult',
    'get_control',
    'get_control_output',
]

@pulumi.output_type
class GetControlResult:
    """
    A collection of values returned by getControl.
    """
    def __init__(__self__, approval_required_op_action_lists=None, approver_groups_lists=None, approvers_lists=None, compartment_id=None, defined_tags=None, description=None, email_id_lists=None, freeform_tags=None, id=None, is_default_operator_control=None, is_fully_pre_approved=None, last_modified_info=None, number_of_approvers=None, operator_control_id=None, operator_control_name=None, pre_approved_op_action_lists=None, resource_type=None, state=None, system_message=None, time_of_creation=None, time_of_deletion=None, time_of_modification=None):
        if approval_required_op_action_lists and not isinstance(approval_required_op_action_lists, list):
            raise TypeError("Expected argument 'approval_required_op_action_lists' to be a list")
        pulumi.set(__self__, "approval_required_op_action_lists", approval_required_op_action_lists)
        if approver_groups_lists and not isinstance(approver_groups_lists, list):
            raise TypeError("Expected argument 'approver_groups_lists' to be a list")
        pulumi.set(__self__, "approver_groups_lists", approver_groups_lists)
        if approvers_lists and not isinstance(approvers_lists, list):
            raise TypeError("Expected argument 'approvers_lists' to be a list")
        pulumi.set(__self__, "approvers_lists", approvers_lists)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if email_id_lists and not isinstance(email_id_lists, list):
            raise TypeError("Expected argument 'email_id_lists' to be a list")
        pulumi.set(__self__, "email_id_lists", email_id_lists)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_default_operator_control and not isinstance(is_default_operator_control, bool):
            raise TypeError("Expected argument 'is_default_operator_control' to be a bool")
        pulumi.set(__self__, "is_default_operator_control", is_default_operator_control)
        if is_fully_pre_approved and not isinstance(is_fully_pre_approved, bool):
            raise TypeError("Expected argument 'is_fully_pre_approved' to be a bool")
        pulumi.set(__self__, "is_fully_pre_approved", is_fully_pre_approved)
        if last_modified_info and not isinstance(last_modified_info, str):
            raise TypeError("Expected argument 'last_modified_info' to be a str")
        pulumi.set(__self__, "last_modified_info", last_modified_info)
        if number_of_approvers and not isinstance(number_of_approvers, int):
            raise TypeError("Expected argument 'number_of_approvers' to be a int")
        pulumi.set(__self__, "number_of_approvers", number_of_approvers)
        if operator_control_id and not isinstance(operator_control_id, str):
            raise TypeError("Expected argument 'operator_control_id' to be a str")
        pulumi.set(__self__, "operator_control_id", operator_control_id)
        if operator_control_name and not isinstance(operator_control_name, str):
            raise TypeError("Expected argument 'operator_control_name' to be a str")
        pulumi.set(__self__, "operator_control_name", operator_control_name)
        if pre_approved_op_action_lists and not isinstance(pre_approved_op_action_lists, list):
            raise TypeError("Expected argument 'pre_approved_op_action_lists' to be a list")
        pulumi.set(__self__, "pre_approved_op_action_lists", pre_approved_op_action_lists)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_message and not isinstance(system_message, str):
            raise TypeError("Expected argument 'system_message' to be a str")
        pulumi.set(__self__, "system_message", system_message)
        if time_of_creation and not isinstance(time_of_creation, str):
            raise TypeError("Expected argument 'time_of_creation' to be a str")
        pulumi.set(__self__, "time_of_creation", time_of_creation)
        if time_of_deletion and not isinstance(time_of_deletion, str):
            raise TypeError("Expected argument 'time_of_deletion' to be a str")
        pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        if time_of_modification and not isinstance(time_of_modification, str):
            raise TypeError("Expected argument 'time_of_modification' to be a str")
        pulumi.set(__self__, "time_of_modification", time_of_modification)

    @property
    @pulumi.getter(name="approvalRequiredOpActionLists")
    def approval_required_op_action_lists(self) -> Sequence[builtins.str]:
        """
        List of operator actions that need explicit approval. Any operator action not in the pre-approved list will require explicit approval. Access requests associated with a resource governed by this operator control will be require explicit approval if the access request contains any operator action in this list.
        """
        return pulumi.get(self, "approval_required_op_action_lists")

    @property
    @pulumi.getter(name="approverGroupsLists")
    def approver_groups_lists(self) -> Sequence[builtins.str]:
        """
        List of user groups who can approve an access request associated with a target resource under the governance of this operator control.
        """
        return pulumi.get(self, "approver_groups_lists")

    @property
    @pulumi.getter(name="approversLists")
    def approvers_lists(self) -> Sequence[builtins.str]:
        """
        List of users who can approve an access request associated with a target resource under the governance of this operator control.
        """
        return pulumi.get(self, "approvers_lists")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment that contains the operator control.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of operator control.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="emailIdLists")
    def email_id_lists(self) -> Sequence[builtins.str]:
        """
        List of emailId.
        """
        return pulumi.get(self, "email_id_lists")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the operator control.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDefaultOperatorControl")
    def is_default_operator_control(self) -> builtins.bool:
        """
        Whether the operator control is a default Operator Control.
        """
        return pulumi.get(self, "is_default_operator_control")

    @property
    @pulumi.getter(name="isFullyPreApproved")
    def is_fully_pre_approved(self) -> builtins.bool:
        """
        Whether all the operator actions have been pre-approved. If yes, all access requests associated with a resource governed by this operator control  will be auto-approved.
        """
        return pulumi.get(self, "is_fully_pre_approved")

    @property
    @pulumi.getter(name="lastModifiedInfo")
    def last_modified_info(self) -> builtins.str:
        """
        Description associated with the latest modification of the operator control.
        """
        return pulumi.get(self, "last_modified_info")

    @property
    @pulumi.getter(name="numberOfApprovers")
    def number_of_approvers(self) -> builtins.int:
        """
        Number of approvers required to approve an access request.
        """
        return pulumi.get(self, "number_of_approvers")

    @property
    @pulumi.getter(name="operatorControlId")
    def operator_control_id(self) -> builtins.str:
        return pulumi.get(self, "operator_control_id")

    @property
    @pulumi.getter(name="operatorControlName")
    def operator_control_name(self) -> builtins.str:
        """
        Name of the operator control. The name must be unique.
        """
        return pulumi.get(self, "operator_control_name")

    @property
    @pulumi.getter(name="preApprovedOpActionLists")
    def pre_approved_op_action_lists(self) -> Sequence[builtins.str]:
        """
        List of pre-approved operator actions. Access requests associated with a resource governed by this operator control will be automatically approved if the access request only contain operator actions in the pre-approved list.
        """
        return pulumi.get(self, "pre_approved_op_action_lists")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> builtins.str:
        """
        resourceType for which the OperatorControl is applicable
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current lifecycle state of the operator control.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemMessage")
    def system_message(self) -> builtins.str:
        """
        System message that would be displayed to the operator users on accessing the target resource under the governance of this operator control.
        """
        return pulumi.get(self, "system_message")

    @property
    @pulumi.getter(name="timeOfCreation")
    def time_of_creation(self) -> builtins.str:
        """
        Time when the operator control was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_creation")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> builtins.str:
        """
        Time when deleted expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'. Note a deleted operator control still stays in the system, so that you can still audit operator actions associated with access requests raised on target resources governed by the deleted operator control.
        """
        return pulumi.get(self, "time_of_deletion")

    @property
    @pulumi.getter(name="timeOfModification")
    def time_of_modification(self) -> builtins.str:
        """
        Time when the operator control was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_modification")


class AwaitableGetControlResult(GetControlResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetControlResult(
            approval_required_op_action_lists=self.approval_required_op_action_lists,
            approver_groups_lists=self.approver_groups_lists,
            approvers_lists=self.approvers_lists,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            email_id_lists=self.email_id_lists,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_default_operator_control=self.is_default_operator_control,
            is_fully_pre_approved=self.is_fully_pre_approved,
            last_modified_info=self.last_modified_info,
            number_of_approvers=self.number_of_approvers,
            operator_control_id=self.operator_control_id,
            operator_control_name=self.operator_control_name,
            pre_approved_op_action_lists=self.pre_approved_op_action_lists,
            resource_type=self.resource_type,
            state=self.state,
            system_message=self.system_message,
            time_of_creation=self.time_of_creation,
            time_of_deletion=self.time_of_deletion,
            time_of_modification=self.time_of_modification)


def get_control(operator_control_id: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetControlResult:
    """
    This data source provides details about a specific Operator Control resource in Oracle Cloud Infrastructure Operator Access Control service.

    Gets the Operator Control associated with the specified Operator Control ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_operator_control = oci.OperatorAccessControl.get_control(operator_control_id=test_operator_control_oci_operator_access_control_operator_control["id"])
    ```


    :param builtins.str operator_control_id: unique OperatorControl identifier
    """
    __args__ = dict()
    __args__['operatorControlId'] = operator_control_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OperatorAccessControl/getControl:getControl', __args__, opts=opts, typ=GetControlResult).value

    return AwaitableGetControlResult(
        approval_required_op_action_lists=pulumi.get(__ret__, 'approval_required_op_action_lists'),
        approver_groups_lists=pulumi.get(__ret__, 'approver_groups_lists'),
        approvers_lists=pulumi.get(__ret__, 'approvers_lists'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        email_id_lists=pulumi.get(__ret__, 'email_id_lists'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_default_operator_control=pulumi.get(__ret__, 'is_default_operator_control'),
        is_fully_pre_approved=pulumi.get(__ret__, 'is_fully_pre_approved'),
        last_modified_info=pulumi.get(__ret__, 'last_modified_info'),
        number_of_approvers=pulumi.get(__ret__, 'number_of_approvers'),
        operator_control_id=pulumi.get(__ret__, 'operator_control_id'),
        operator_control_name=pulumi.get(__ret__, 'operator_control_name'),
        pre_approved_op_action_lists=pulumi.get(__ret__, 'pre_approved_op_action_lists'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        state=pulumi.get(__ret__, 'state'),
        system_message=pulumi.get(__ret__, 'system_message'),
        time_of_creation=pulumi.get(__ret__, 'time_of_creation'),
        time_of_deletion=pulumi.get(__ret__, 'time_of_deletion'),
        time_of_modification=pulumi.get(__ret__, 'time_of_modification'))
def get_control_output(operator_control_id: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetControlResult]:
    """
    This data source provides details about a specific Operator Control resource in Oracle Cloud Infrastructure Operator Access Control service.

    Gets the Operator Control associated with the specified Operator Control ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_operator_control = oci.OperatorAccessControl.get_control(operator_control_id=test_operator_control_oci_operator_access_control_operator_control["id"])
    ```


    :param builtins.str operator_control_id: unique OperatorControl identifier
    """
    __args__ = dict()
    __args__['operatorControlId'] = operator_control_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OperatorAccessControl/getControl:getControl', __args__, opts=opts, typ=GetControlResult)
    return __ret__.apply(lambda __response__: GetControlResult(
        approval_required_op_action_lists=pulumi.get(__response__, 'approval_required_op_action_lists'),
        approver_groups_lists=pulumi.get(__response__, 'approver_groups_lists'),
        approvers_lists=pulumi.get(__response__, 'approvers_lists'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        email_id_lists=pulumi.get(__response__, 'email_id_lists'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_default_operator_control=pulumi.get(__response__, 'is_default_operator_control'),
        is_fully_pre_approved=pulumi.get(__response__, 'is_fully_pre_approved'),
        last_modified_info=pulumi.get(__response__, 'last_modified_info'),
        number_of_approvers=pulumi.get(__response__, 'number_of_approvers'),
        operator_control_id=pulumi.get(__response__, 'operator_control_id'),
        operator_control_name=pulumi.get(__response__, 'operator_control_name'),
        pre_approved_op_action_lists=pulumi.get(__response__, 'pre_approved_op_action_lists'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        state=pulumi.get(__response__, 'state'),
        system_message=pulumi.get(__response__, 'system_message'),
        time_of_creation=pulumi.get(__response__, 'time_of_creation'),
        time_of_deletion=pulumi.get(__response__, 'time_of_deletion'),
        time_of_modification=pulumi.get(__response__, 'time_of_modification')))
