# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetProfilesResult',
    'AwaitableGetProfilesResult',
    'get_profiles',
    'get_profiles_output',
]

@pulumi.output_type
class GetProfilesResult:
    """
    A collection of values returned by getProfiles.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, name=None, profile_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if profile_collections and not isinstance(profile_collections, list):
            raise TypeError("Expected argument 'profile_collections' to be a list")
        pulumi.set(__self__, "profile_collections", profile_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the tenancy. The tenancy is the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetProfilesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name assigned to the profile. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="profileCollections")
    def profile_collections(self) -> Sequence['outputs.GetProfilesProfileCollectionResult']:
        """
        The list of profile_collection.
        """
        return pulumi.get(self, "profile_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The profile's current state.
        """
        return pulumi.get(self, "state")


class AwaitableGetProfilesResult(GetProfilesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProfilesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            profile_collections=self.profile_collections,
            state=self.state)


def get_profiles(compartment_id: Optional[builtins.str] = None,
                 filters: Optional[Sequence[Union['GetProfilesFilterArgs', 'GetProfilesFilterArgsDict']]] = None,
                 name: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProfilesResult:
    """
    This data source provides the list of Profiles in Oracle Cloud Infrastructure Optimizer service.

    Lists the existing profiles.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_profiles = oci.Optimizer.get_profiles(compartment_id=compartment_id,
        name=profile_name,
        state=profile_state)
    ```


    :param builtins.str compartment_id: The OCID of the compartment.
    :param builtins.str name: Optional. A filter that returns results that match the name specified.
    :param builtins.str state: A filter that returns results that match the lifecycle state specified.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Optimizer/getProfiles:getProfiles', __args__, opts=opts, typ=GetProfilesResult).value

    return AwaitableGetProfilesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        profile_collections=pulumi.get(__ret__, 'profile_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_profiles_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetProfilesFilterArgs', 'GetProfilesFilterArgsDict']]]]] = None,
                        name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProfilesResult]:
    """
    This data source provides the list of Profiles in Oracle Cloud Infrastructure Optimizer service.

    Lists the existing profiles.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_profiles = oci.Optimizer.get_profiles(compartment_id=compartment_id,
        name=profile_name,
        state=profile_state)
    ```


    :param builtins.str compartment_id: The OCID of the compartment.
    :param builtins.str name: Optional. A filter that returns results that match the name specified.
    :param builtins.str state: A filter that returns results that match the lifecycle state specified.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Optimizer/getProfiles:getProfiles', __args__, opts=opts, typ=GetProfilesResult)
    return __ret__.apply(lambda __response__: GetProfilesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        profile_collections=pulumi.get(__response__, 'profile_collections'),
        state=pulumi.get(__response__, 'state')))
