# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSoftwareSourcesResult',
    'AwaitableGetSoftwareSourcesResult',
    'get_software_sources',
    'get_software_sources_output',
]

@pulumi.output_type
class GetSoftwareSourcesResult:
    """
    A collection of values returned by getSoftwareSources.
    """
    def __init__(__self__, arch_types=None, availabilities=None, availability_anywheres=None, availability_at_ocis=None, compartment_id=None, display_name=None, display_name_contains=None, display_name_not_equal_tos=None, filters=None, id=None, is_mandatory_for_autonomous_linux=None, is_mirror_sync_allowed=None, os_families=None, software_source_collections=None, software_source_id=None, software_source_types=None, states=None, vendor_name=None):
        if arch_types and not isinstance(arch_types, list):
            raise TypeError("Expected argument 'arch_types' to be a list")
        pulumi.set(__self__, "arch_types", arch_types)
        if availabilities and not isinstance(availabilities, list):
            raise TypeError("Expected argument 'availabilities' to be a list")
        pulumi.set(__self__, "availabilities", availabilities)
        if availability_anywheres and not isinstance(availability_anywheres, list):
            raise TypeError("Expected argument 'availability_anywheres' to be a list")
        pulumi.set(__self__, "availability_anywheres", availability_anywheres)
        if availability_at_ocis and not isinstance(availability_at_ocis, list):
            raise TypeError("Expected argument 'availability_at_ocis' to be a list")
        pulumi.set(__self__, "availability_at_ocis", availability_at_ocis)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if display_name_contains and not isinstance(display_name_contains, str):
            raise TypeError("Expected argument 'display_name_contains' to be a str")
        pulumi.set(__self__, "display_name_contains", display_name_contains)
        if display_name_not_equal_tos and not isinstance(display_name_not_equal_tos, list):
            raise TypeError("Expected argument 'display_name_not_equal_tos' to be a list")
        pulumi.set(__self__, "display_name_not_equal_tos", display_name_not_equal_tos)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_mandatory_for_autonomous_linux and not isinstance(is_mandatory_for_autonomous_linux, bool):
            raise TypeError("Expected argument 'is_mandatory_for_autonomous_linux' to be a bool")
        pulumi.set(__self__, "is_mandatory_for_autonomous_linux", is_mandatory_for_autonomous_linux)
        if is_mirror_sync_allowed and not isinstance(is_mirror_sync_allowed, bool):
            raise TypeError("Expected argument 'is_mirror_sync_allowed' to be a bool")
        pulumi.set(__self__, "is_mirror_sync_allowed", is_mirror_sync_allowed)
        if os_families and not isinstance(os_families, list):
            raise TypeError("Expected argument 'os_families' to be a list")
        pulumi.set(__self__, "os_families", os_families)
        if software_source_collections and not isinstance(software_source_collections, list):
            raise TypeError("Expected argument 'software_source_collections' to be a list")
        pulumi.set(__self__, "software_source_collections", software_source_collections)
        if software_source_id and not isinstance(software_source_id, str):
            raise TypeError("Expected argument 'software_source_id' to be a str")
        pulumi.set(__self__, "software_source_id", software_source_id)
        if software_source_types and not isinstance(software_source_types, list):
            raise TypeError("Expected argument 'software_source_types' to be a list")
        pulumi.set(__self__, "software_source_types", software_source_types)
        if states and not isinstance(states, list):
            raise TypeError("Expected argument 'states' to be a list")
        pulumi.set(__self__, "states", states)
        if vendor_name and not isinstance(vendor_name, str):
            raise TypeError("Expected argument 'vendor_name' to be a str")
        pulumi.set(__self__, "vendor_name", vendor_name)

    @property
    @pulumi.getter(name="archTypes")
    def arch_types(self) -> Optional[Sequence[builtins.str]]:
        """
        The architecture type supported by the software source.
        """
        return pulumi.get(self, "arch_types")

    @property
    @pulumi.getter
    def availabilities(self) -> Optional[Sequence[builtins.str]]:
        """
        Availability of the software source (for non-OCI environments).
        """
        return pulumi.get(self, "availabilities")

    @property
    @pulumi.getter(name="availabilityAnywheres")
    def availability_anywheres(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "availability_anywheres")

    @property
    @pulumi.getter(name="availabilityAtOcis")
    def availability_at_ocis(self) -> Optional[Sequence[builtins.str]]:
        """
        Availability of the software source (for Oracle Cloud Infrastructure environments).
        """
        return pulumi.get(self, "availability_at_ocis")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the software source.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        User-friendly name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="displayNameContains")
    def display_name_contains(self) -> Optional[builtins.str]:
        return pulumi.get(self, "display_name_contains")

    @property
    @pulumi.getter(name="displayNameNotEqualTos")
    def display_name_not_equal_tos(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "display_name_not_equal_tos")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSoftwareSourcesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isMandatoryForAutonomousLinux")
    def is_mandatory_for_autonomous_linux(self) -> Optional[builtins.bool]:
        """
        Indicates whether the software source is required for the Autonomous Linux service.
        """
        return pulumi.get(self, "is_mandatory_for_autonomous_linux")

    @property
    @pulumi.getter(name="isMirrorSyncAllowed")
    def is_mirror_sync_allowed(self) -> Optional[builtins.bool]:
        """
        Indicates if this software source can be mirrored to a management station.
        """
        return pulumi.get(self, "is_mirror_sync_allowed")

    @property
    @pulumi.getter(name="osFamilies")
    def os_families(self) -> Optional[Sequence[builtins.str]]:
        """
        The OS family of the software source.
        """
        return pulumi.get(self, "os_families")

    @property
    @pulumi.getter(name="softwareSourceCollections")
    def software_source_collections(self) -> Sequence['outputs.GetSoftwareSourcesSoftwareSourceCollectionResult']:
        """
        The list of software_source_collection.
        """
        return pulumi.get(self, "software_source_collections")

    @property
    @pulumi.getter(name="softwareSourceId")
    def software_source_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "software_source_id")

    @property
    @pulumi.getter(name="softwareSourceTypes")
    def software_source_types(self) -> Optional[Sequence[builtins.str]]:
        """
        Type of software source.
        """
        return pulumi.get(self, "software_source_types")

    @property
    @pulumi.getter
    def states(self) -> Optional[Sequence[builtins.str]]:
        """
        The current state of the software source.
        """
        return pulumi.get(self, "states")

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> Optional[builtins.str]:
        """
        Name of the vendor providing the software source.
        """
        return pulumi.get(self, "vendor_name")


class AwaitableGetSoftwareSourcesResult(GetSoftwareSourcesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSoftwareSourcesResult(
            arch_types=self.arch_types,
            availabilities=self.availabilities,
            availability_anywheres=self.availability_anywheres,
            availability_at_ocis=self.availability_at_ocis,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            display_name_contains=self.display_name_contains,
            display_name_not_equal_tos=self.display_name_not_equal_tos,
            filters=self.filters,
            id=self.id,
            is_mandatory_for_autonomous_linux=self.is_mandatory_for_autonomous_linux,
            is_mirror_sync_allowed=self.is_mirror_sync_allowed,
            os_families=self.os_families,
            software_source_collections=self.software_source_collections,
            software_source_id=self.software_source_id,
            software_source_types=self.software_source_types,
            states=self.states,
            vendor_name=self.vendor_name)


def get_software_sources(arch_types: Optional[Sequence[builtins.str]] = None,
                         availabilities: Optional[Sequence[builtins.str]] = None,
                         availability_anywheres: Optional[Sequence[builtins.str]] = None,
                         availability_at_ocis: Optional[Sequence[builtins.str]] = None,
                         compartment_id: Optional[builtins.str] = None,
                         display_name: Optional[builtins.str] = None,
                         display_name_contains: Optional[builtins.str] = None,
                         display_name_not_equal_tos: Optional[Sequence[builtins.str]] = None,
                         filters: Optional[Sequence[Union['GetSoftwareSourcesFilterArgs', 'GetSoftwareSourcesFilterArgsDict']]] = None,
                         is_mandatory_for_autonomous_linux: Optional[builtins.bool] = None,
                         is_mirror_sync_allowed: Optional[builtins.bool] = None,
                         os_families: Optional[Sequence[builtins.str]] = None,
                         software_source_id: Optional[builtins.str] = None,
                         software_source_types: Optional[Sequence[builtins.str]] = None,
                         states: Optional[Sequence[builtins.str]] = None,
                         vendor_name: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSoftwareSourcesResult:
    """
    This data source provides the list of Software Sources in Oracle Cloud Infrastructure Os Management Hub service.

    Lists software sources that match the specified tenancy or software source [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Filter the list against a
    variety of criteria including but not limited to its name, status, architecture, and OS family.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_software_sources = oci.OsManagementHub.get_software_sources(arch_types=software_source_arch_type,
        availabilities=software_source_availability,
        availability_anywheres=software_source_availability_anywhere,
        availability_at_ocis=software_source_availability_at_oci,
        compartment_id=compartment_id,
        display_name=software_source_display_name,
        display_name_contains=software_source_display_name_contains,
        display_name_not_equal_tos=software_source_display_name_not_equal_to,
        is_mandatory_for_autonomous_linux=software_source_is_mandatory_for_autonomous_linux,
        is_mirror_sync_allowed=software_source_is_mirror_sync_allowed,
        os_families=software_source_os_family,
        software_source_id=test_software_source["id"],
        software_source_types=software_source_software_source_type,
        states=software_source_state,
        vendor_name=software_source_vendor_name)
    ```


    :param Sequence[builtins.str] arch_types: A filter to return only instances whose architecture type matches the given architecture.
    :param Sequence[builtins.str] availabilities: The availability of the software source in a non-OCI environment for a tenancy.
    :param Sequence[builtins.str] availability_anywheres: The availability of the software source. Use this query parameter to filter across availabilities in different environments.
    :param Sequence[builtins.str] availability_at_ocis: The availability of the software source in an Oracle Cloud Infrastructure environment for a tenancy.
    :param builtins.str compartment_id: (Updatable) The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param builtins.str display_name: A filter to return resources that match the given user-friendly name.
    :param builtins.str display_name_contains: A filter to return resources that may partially match the given display name.
    :param Sequence[builtins.str] display_name_not_equal_tos: A multi filter to return resources that do not contains the given display names.
    :param builtins.bool is_mandatory_for_autonomous_linux: Indicates whether the software source is mandatory for the Autonomous Linux service.
    :param builtins.bool is_mirror_sync_allowed: A filter to return software sources which can be synced to a management station.
    :param Sequence[builtins.str] os_families: A filter to return only resources that match the given operating system family.
    :param builtins.str software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the software source.
    :param Sequence[builtins.str] software_source_types: The type of the software source.
    :param Sequence[builtins.str] states: A filter to return only software sources whose state matches the given state.
    :param builtins.str vendor_name: A filter to return only resources that match the given vendor name.
    """
    __args__ = dict()
    __args__['archTypes'] = arch_types
    __args__['availabilities'] = availabilities
    __args__['availabilityAnywheres'] = availability_anywheres
    __args__['availabilityAtOcis'] = availability_at_ocis
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['displayNameContains'] = display_name_contains
    __args__['displayNameNotEqualTos'] = display_name_not_equal_tos
    __args__['filters'] = filters
    __args__['isMandatoryForAutonomousLinux'] = is_mandatory_for_autonomous_linux
    __args__['isMirrorSyncAllowed'] = is_mirror_sync_allowed
    __args__['osFamilies'] = os_families
    __args__['softwareSourceId'] = software_source_id
    __args__['softwareSourceTypes'] = software_source_types
    __args__['states'] = states
    __args__['vendorName'] = vendor_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getSoftwareSources:getSoftwareSources', __args__, opts=opts, typ=GetSoftwareSourcesResult).value

    return AwaitableGetSoftwareSourcesResult(
        arch_types=pulumi.get(__ret__, 'arch_types'),
        availabilities=pulumi.get(__ret__, 'availabilities'),
        availability_anywheres=pulumi.get(__ret__, 'availability_anywheres'),
        availability_at_ocis=pulumi.get(__ret__, 'availability_at_ocis'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        display_name_contains=pulumi.get(__ret__, 'display_name_contains'),
        display_name_not_equal_tos=pulumi.get(__ret__, 'display_name_not_equal_tos'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_mandatory_for_autonomous_linux=pulumi.get(__ret__, 'is_mandatory_for_autonomous_linux'),
        is_mirror_sync_allowed=pulumi.get(__ret__, 'is_mirror_sync_allowed'),
        os_families=pulumi.get(__ret__, 'os_families'),
        software_source_collections=pulumi.get(__ret__, 'software_source_collections'),
        software_source_id=pulumi.get(__ret__, 'software_source_id'),
        software_source_types=pulumi.get(__ret__, 'software_source_types'),
        states=pulumi.get(__ret__, 'states'),
        vendor_name=pulumi.get(__ret__, 'vendor_name'))
def get_software_sources_output(arch_types: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                availabilities: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                availability_anywheres: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                availability_at_ocis: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                display_name_contains: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                display_name_not_equal_tos: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSoftwareSourcesFilterArgs', 'GetSoftwareSourcesFilterArgsDict']]]]] = None,
                                is_mandatory_for_autonomous_linux: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                is_mirror_sync_allowed: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                os_families: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                software_source_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                software_source_types: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                states: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                vendor_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSoftwareSourcesResult]:
    """
    This data source provides the list of Software Sources in Oracle Cloud Infrastructure Os Management Hub service.

    Lists software sources that match the specified tenancy or software source [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Filter the list against a
    variety of criteria including but not limited to its name, status, architecture, and OS family.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_software_sources = oci.OsManagementHub.get_software_sources(arch_types=software_source_arch_type,
        availabilities=software_source_availability,
        availability_anywheres=software_source_availability_anywhere,
        availability_at_ocis=software_source_availability_at_oci,
        compartment_id=compartment_id,
        display_name=software_source_display_name,
        display_name_contains=software_source_display_name_contains,
        display_name_not_equal_tos=software_source_display_name_not_equal_to,
        is_mandatory_for_autonomous_linux=software_source_is_mandatory_for_autonomous_linux,
        is_mirror_sync_allowed=software_source_is_mirror_sync_allowed,
        os_families=software_source_os_family,
        software_source_id=test_software_source["id"],
        software_source_types=software_source_software_source_type,
        states=software_source_state,
        vendor_name=software_source_vendor_name)
    ```


    :param Sequence[builtins.str] arch_types: A filter to return only instances whose architecture type matches the given architecture.
    :param Sequence[builtins.str] availabilities: The availability of the software source in a non-OCI environment for a tenancy.
    :param Sequence[builtins.str] availability_anywheres: The availability of the software source. Use this query parameter to filter across availabilities in different environments.
    :param Sequence[builtins.str] availability_at_ocis: The availability of the software source in an Oracle Cloud Infrastructure environment for a tenancy.
    :param builtins.str compartment_id: (Updatable) The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param builtins.str display_name: A filter to return resources that match the given user-friendly name.
    :param builtins.str display_name_contains: A filter to return resources that may partially match the given display name.
    :param Sequence[builtins.str] display_name_not_equal_tos: A multi filter to return resources that do not contains the given display names.
    :param builtins.bool is_mandatory_for_autonomous_linux: Indicates whether the software source is mandatory for the Autonomous Linux service.
    :param builtins.bool is_mirror_sync_allowed: A filter to return software sources which can be synced to a management station.
    :param Sequence[builtins.str] os_families: A filter to return only resources that match the given operating system family.
    :param builtins.str software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the software source.
    :param Sequence[builtins.str] software_source_types: The type of the software source.
    :param Sequence[builtins.str] states: A filter to return only software sources whose state matches the given state.
    :param builtins.str vendor_name: A filter to return only resources that match the given vendor name.
    """
    __args__ = dict()
    __args__['archTypes'] = arch_types
    __args__['availabilities'] = availabilities
    __args__['availabilityAnywheres'] = availability_anywheres
    __args__['availabilityAtOcis'] = availability_at_ocis
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['displayNameContains'] = display_name_contains
    __args__['displayNameNotEqualTos'] = display_name_not_equal_tos
    __args__['filters'] = filters
    __args__['isMandatoryForAutonomousLinux'] = is_mandatory_for_autonomous_linux
    __args__['isMirrorSyncAllowed'] = is_mirror_sync_allowed
    __args__['osFamilies'] = os_families
    __args__['softwareSourceId'] = software_source_id
    __args__['softwareSourceTypes'] = software_source_types
    __args__['states'] = states
    __args__['vendorName'] = vendor_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OsManagementHub/getSoftwareSources:getSoftwareSources', __args__, opts=opts, typ=GetSoftwareSourcesResult)
    return __ret__.apply(lambda __response__: GetSoftwareSourcesResult(
        arch_types=pulumi.get(__response__, 'arch_types'),
        availabilities=pulumi.get(__response__, 'availabilities'),
        availability_anywheres=pulumi.get(__response__, 'availability_anywheres'),
        availability_at_ocis=pulumi.get(__response__, 'availability_at_ocis'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        display_name_contains=pulumi.get(__response__, 'display_name_contains'),
        display_name_not_equal_tos=pulumi.get(__response__, 'display_name_not_equal_tos'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        is_mandatory_for_autonomous_linux=pulumi.get(__response__, 'is_mandatory_for_autonomous_linux'),
        is_mirror_sync_allowed=pulumi.get(__response__, 'is_mirror_sync_allowed'),
        os_families=pulumi.get(__response__, 'os_families'),
        software_source_collections=pulumi.get(__response__, 'software_source_collections'),
        software_source_id=pulumi.get(__response__, 'software_source_id'),
        software_source_types=pulumi.get(__response__, 'software_source_types'),
        states=pulumi.get(__response__, 'states'),
        vendor_name=pulumi.get(__response__, 'vendor_name')))
