# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AddressActionVerificationAddress',
    'SubscriptionBillingAddress',
    'SubscriptionPaymentGateway',
    'SubscriptionPaymentGatewayMerchantDefinedData',
    'SubscriptionPaymentOption',
    'SubscriptionSubscription',
    'SubscriptionSubscriptionBillingAddress',
    'SubscriptionSubscriptionPaymentGateway',
    'SubscriptionSubscriptionPaymentGatewayMerchantDefinedData',
    'SubscriptionSubscriptionPaymentOption',
    'SubscriptionSubscriptionTaxInfo',
    'SubscriptionTaxInfo',
    'GetAddressRuleAddressResult',
    'GetAddressRuleAddressFieldResult',
    'GetAddressRuleAddressFieldFormatResult',
    'GetAddressRuleAddressFieldLabelResult',
    'GetAddressRuleContactResult',
    'GetAddressRuleContactFieldResult',
    'GetAddressRuleContactFieldFormatResult',
    'GetAddressRuleContactFieldLabelResult',
    'GetAddressRuleTaxResult',
    'GetAddressRuleTaxFieldResult',
    'GetAddressRuleTaxFieldFormatResult',
    'GetAddressRuleTaxFieldLabelResult',
    'GetAddressRuleTaxValueSetResult',
    'GetInvoiceBillToAddressResult',
    'GetInvoiceBillToAddressCountryResult',
    'GetInvoiceCurrencyResult',
    'GetInvoiceLastPaymentDetailResult',
    'GetInvoicesFilterResult',
    'GetInvoicesInvoiceCollectionResult',
    'GetInvoicesInvoiceCollectionItemResult',
    'GetInvoicesInvoiceCollectionItemBillToAddressResult',
    'GetInvoicesInvoiceCollectionItemBillToAddressCountryResult',
    'GetInvoicesInvoiceCollectionItemCurrencyResult',
    'GetInvoicesInvoiceCollectionItemLastPaymentDetailResult',
    'GetInvoicesInvoiceLineItemResult',
    'GetInvoicesInvoiceLineItemCurrencyResult',
    'GetInvoicesInvoiceLinesFilterResult',
    'GetInvoicesInvoiceLinesInvoiceLineCollectionResult',
    'GetInvoicesInvoiceLinesInvoiceLineCollectionItemResult',
    'GetInvoicesInvoiceLinesInvoiceLineCollectionItemCurrencyResult',
    'GetSubscriptionBillingAddressResult',
    'GetSubscriptionPaymentGatewayResult',
    'GetSubscriptionPaymentGatewayMerchantDefinedDataResult',
    'GetSubscriptionPaymentOptionResult',
    'GetSubscriptionSubscriptionResult',
    'GetSubscriptionSubscriptionBillingAddressResult',
    'GetSubscriptionSubscriptionPaymentGatewayResult',
    'GetSubscriptionSubscriptionPaymentGatewayMerchantDefinedDataResult',
    'GetSubscriptionSubscriptionPaymentOptionResult',
    'GetSubscriptionSubscriptionTaxInfoResult',
    'GetSubscriptionTaxInfoResult',
    'GetSubscriptionsFilterResult',
    'GetSubscriptionsSubscriptionCollectionResult',
    'GetSubscriptionsSubscriptionCollectionItemResult',
    'GetSubscriptionsSubscriptionCollectionItemBillingAddressResult',
    'GetSubscriptionsSubscriptionCollectionItemPaymentGatewayResult',
    'GetSubscriptionsSubscriptionCollectionItemPaymentGatewayMerchantDefinedDataResult',
    'GetSubscriptionsSubscriptionCollectionItemPaymentOptionResult',
    'GetSubscriptionsSubscriptionCollectionItemSubscriptionResult',
    'GetSubscriptionsSubscriptionCollectionItemSubscriptionBillingAddressResult',
    'GetSubscriptionsSubscriptionCollectionItemSubscriptionPaymentGatewayResult',
    'GetSubscriptionsSubscriptionCollectionItemSubscriptionPaymentGatewayMerchantDefinedDataResult',
    'GetSubscriptionsSubscriptionCollectionItemSubscriptionPaymentOptionResult',
    'GetSubscriptionsSubscriptionCollectionItemSubscriptionTaxInfoResult',
    'GetSubscriptionsSubscriptionCollectionItemTaxInfoResult',
]

@pulumi.output_type
class AddressActionVerificationAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressKey":
            suggest = "address_key"
        elif key == "companyName":
            suggest = "company_name"
        elif key == "contributorClass":
            suggest = "contributor_class"
        elif key == "departmentName":
            suggest = "department_name"
        elif key == "emailAddress":
            suggest = "email_address"
        elif key == "firstName":
            suggest = "first_name"
        elif key == "internalNumber":
            suggest = "internal_number"
        elif key == "jobTitle":
            suggest = "job_title"
        elif key == "lastName":
            suggest = "last_name"
        elif key == "middleName":
            suggest = "middle_name"
        elif key == "municipalInscription":
            suggest = "municipal_inscription"
        elif key == "phoneCountryCode":
            suggest = "phone_country_code"
        elif key == "phoneNumber":
            suggest = "phone_number"
        elif key == "postalCode":
            suggest = "postal_code"
        elif key == "stateInscription":
            suggest = "state_inscription"
        elif key == "streetName":
            suggest = "street_name"
        elif key == "streetNumber":
            suggest = "street_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AddressActionVerificationAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AddressActionVerificationAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AddressActionVerificationAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_key: Optional[builtins.str] = None,
                 city: Optional[builtins.str] = None,
                 company_name: Optional[builtins.str] = None,
                 contributor_class: Optional[builtins.str] = None,
                 country: Optional[builtins.str] = None,
                 county: Optional[builtins.str] = None,
                 department_name: Optional[builtins.str] = None,
                 email_address: Optional[builtins.str] = None,
                 first_name: Optional[builtins.str] = None,
                 internal_number: Optional[builtins.str] = None,
                 job_title: Optional[builtins.str] = None,
                 last_name: Optional[builtins.str] = None,
                 line1: Optional[builtins.str] = None,
                 line2: Optional[builtins.str] = None,
                 line3: Optional[builtins.str] = None,
                 line4: Optional[builtins.str] = None,
                 middle_name: Optional[builtins.str] = None,
                 municipal_inscription: Optional[builtins.str] = None,
                 phone_country_code: Optional[builtins.str] = None,
                 phone_number: Optional[builtins.str] = None,
                 postal_code: Optional[builtins.str] = None,
                 province: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 state_inscription: Optional[builtins.str] = None,
                 street_name: Optional[builtins.str] = None,
                 street_number: Optional[builtins.str] = None):
        """
        :param builtins.str address_key: Address identifier.
        :param builtins.str city: Name of the city.
        :param builtins.str company_name: Name of the customer company.
        :param builtins.str contributor_class: Contributor class of the customer company.
        :param builtins.str country: Country of the address.
        :param builtins.str county: County of the address.
        :param builtins.str department_name: Department name of the customer company.
        :param builtins.str email_address: Contact person email address.
        :param builtins.str first_name: First name of the contact person.
        :param builtins.str internal_number: Internal number of the customer company.
        :param builtins.str job_title: Job title of the contact person.
        :param builtins.str last_name: Last name of the contact person.
        :param builtins.str line1: Address line 1.
        :param builtins.str line2: Address line 2.
        :param builtins.str line3: Address line 3.
        :param builtins.str line4: Address line 4.
        :param builtins.str middle_name: Middle name of the contact person.
        :param builtins.str municipal_inscription: Municipal Inscription.
        :param builtins.str phone_country_code: Phone country code of the contact person.
        :param builtins.str phone_number: Phone number of the contact person.
        :param builtins.str postal_code: Post code of the address.
        :param builtins.str province: Province of the address.
        :param builtins.str state: State of the address.
        :param builtins.str state_inscription: State Inscription.
        :param builtins.str street_name: Street name of the address.
        :param builtins.str street_number: Street number of the address.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if address_key is not None:
            pulumi.set(__self__, "address_key", address_key)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if company_name is not None:
            pulumi.set(__self__, "company_name", company_name)
        if contributor_class is not None:
            pulumi.set(__self__, "contributor_class", contributor_class)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if county is not None:
            pulumi.set(__self__, "county", county)
        if department_name is not None:
            pulumi.set(__self__, "department_name", department_name)
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if internal_number is not None:
            pulumi.set(__self__, "internal_number", internal_number)
        if job_title is not None:
            pulumi.set(__self__, "job_title", job_title)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if line1 is not None:
            pulumi.set(__self__, "line1", line1)
        if line2 is not None:
            pulumi.set(__self__, "line2", line2)
        if line3 is not None:
            pulumi.set(__self__, "line3", line3)
        if line4 is not None:
            pulumi.set(__self__, "line4", line4)
        if middle_name is not None:
            pulumi.set(__self__, "middle_name", middle_name)
        if municipal_inscription is not None:
            pulumi.set(__self__, "municipal_inscription", municipal_inscription)
        if phone_country_code is not None:
            pulumi.set(__self__, "phone_country_code", phone_country_code)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_inscription is not None:
            pulumi.set(__self__, "state_inscription", state_inscription)
        if street_name is not None:
            pulumi.set(__self__, "street_name", street_name)
        if street_number is not None:
            pulumi.set(__self__, "street_number", street_number)

    @property
    @pulumi.getter(name="addressKey")
    def address_key(self) -> Optional[builtins.str]:
        """
        Address identifier.
        """
        return pulumi.get(self, "address_key")

    @property
    @pulumi.getter
    def city(self) -> Optional[builtins.str]:
        """
        Name of the city.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> Optional[builtins.str]:
        """
        Name of the customer company.
        """
        return pulumi.get(self, "company_name")

    @property
    @pulumi.getter(name="contributorClass")
    def contributor_class(self) -> Optional[builtins.str]:
        """
        Contributor class of the customer company.
        """
        return pulumi.get(self, "contributor_class")

    @property
    @pulumi.getter
    def country(self) -> Optional[builtins.str]:
        """
        Country of the address.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def county(self) -> Optional[builtins.str]:
        """
        County of the address.
        """
        return pulumi.get(self, "county")

    @property
    @pulumi.getter(name="departmentName")
    def department_name(self) -> Optional[builtins.str]:
        """
        Department name of the customer company.
        """
        return pulumi.get(self, "department_name")

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional[builtins.str]:
        """
        Contact person email address.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[builtins.str]:
        """
        First name of the contact person.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="internalNumber")
    def internal_number(self) -> Optional[builtins.str]:
        """
        Internal number of the customer company.
        """
        return pulumi.get(self, "internal_number")

    @property
    @pulumi.getter(name="jobTitle")
    def job_title(self) -> Optional[builtins.str]:
        """
        Job title of the contact person.
        """
        return pulumi.get(self, "job_title")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[builtins.str]:
        """
        Last name of the contact person.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def line1(self) -> Optional[builtins.str]:
        """
        Address line 1.
        """
        return pulumi.get(self, "line1")

    @property
    @pulumi.getter
    def line2(self) -> Optional[builtins.str]:
        """
        Address line 2.
        """
        return pulumi.get(self, "line2")

    @property
    @pulumi.getter
    def line3(self) -> Optional[builtins.str]:
        """
        Address line 3.
        """
        return pulumi.get(self, "line3")

    @property
    @pulumi.getter
    def line4(self) -> Optional[builtins.str]:
        """
        Address line 4.
        """
        return pulumi.get(self, "line4")

    @property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> Optional[builtins.str]:
        """
        Middle name of the contact person.
        """
        return pulumi.get(self, "middle_name")

    @property
    @pulumi.getter(name="municipalInscription")
    def municipal_inscription(self) -> Optional[builtins.str]:
        """
        Municipal Inscription.
        """
        return pulumi.get(self, "municipal_inscription")

    @property
    @pulumi.getter(name="phoneCountryCode")
    def phone_country_code(self) -> Optional[builtins.str]:
        """
        Phone country code of the contact person.
        """
        return pulumi.get(self, "phone_country_code")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[builtins.str]:
        """
        Phone number of the contact person.
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[builtins.str]:
        """
        Post code of the address.
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def province(self) -> Optional[builtins.str]:
        """
        Province of the address.
        """
        return pulumi.get(self, "province")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        State of the address.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateInscription")
    def state_inscription(self) -> Optional[builtins.str]:
        """
        State Inscription.
        """
        return pulumi.get(self, "state_inscription")

    @property
    @pulumi.getter(name="streetName")
    def street_name(self) -> Optional[builtins.str]:
        """
        Street name of the address.
        """
        return pulumi.get(self, "street_name")

    @property
    @pulumi.getter(name="streetNumber")
    def street_number(self) -> Optional[builtins.str]:
        """
        Street number of the address.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "street_number")


@pulumi.output_type
class SubscriptionBillingAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressKey":
            suggest = "address_key"
        elif key == "companyName":
            suggest = "company_name"
        elif key == "contributorClass":
            suggest = "contributor_class"
        elif key == "departmentName":
            suggest = "department_name"
        elif key == "emailAddress":
            suggest = "email_address"
        elif key == "firstName":
            suggest = "first_name"
        elif key == "internalNumber":
            suggest = "internal_number"
        elif key == "jobTitle":
            suggest = "job_title"
        elif key == "lastName":
            suggest = "last_name"
        elif key == "middleName":
            suggest = "middle_name"
        elif key == "municipalInscription":
            suggest = "municipal_inscription"
        elif key == "phoneCountryCode":
            suggest = "phone_country_code"
        elif key == "phoneNumber":
            suggest = "phone_number"
        elif key == "postalCode":
            suggest = "postal_code"
        elif key == "stateInscription":
            suggest = "state_inscription"
        elif key == "streetName":
            suggest = "street_name"
        elif key == "streetNumber":
            suggest = "street_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionBillingAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionBillingAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionBillingAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_key: Optional[builtins.str] = None,
                 city: Optional[builtins.str] = None,
                 company_name: Optional[builtins.str] = None,
                 contributor_class: Optional[builtins.str] = None,
                 country: Optional[builtins.str] = None,
                 county: Optional[builtins.str] = None,
                 department_name: Optional[builtins.str] = None,
                 email_address: Optional[builtins.str] = None,
                 first_name: Optional[builtins.str] = None,
                 internal_number: Optional[builtins.str] = None,
                 job_title: Optional[builtins.str] = None,
                 last_name: Optional[builtins.str] = None,
                 line1: Optional[builtins.str] = None,
                 line2: Optional[builtins.str] = None,
                 line3: Optional[builtins.str] = None,
                 line4: Optional[builtins.str] = None,
                 middle_name: Optional[builtins.str] = None,
                 municipal_inscription: Optional[builtins.str] = None,
                 phone_country_code: Optional[builtins.str] = None,
                 phone_number: Optional[builtins.str] = None,
                 postal_code: Optional[builtins.str] = None,
                 province: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 state_inscription: Optional[builtins.str] = None,
                 street_name: Optional[builtins.str] = None,
                 street_number: Optional[builtins.str] = None):
        """
        :param builtins.str address_key: Address identifier.
        :param builtins.str city: Name of the city.
        :param builtins.str company_name: Name of the customer company.
        :param builtins.str contributor_class: Contributor class of the customer company.
        :param builtins.str country: Country of the address.
        :param builtins.str county: County of the address.
        :param builtins.str department_name: Department name of the customer company.
        :param builtins.str email_address: The email address of the paypal user.
        :param builtins.str first_name: First name of the paypal user.
        :param builtins.str internal_number: Internal number of the customer company.
        :param builtins.str job_title: Job title of the contact person.
        :param builtins.str last_name: Last name of the paypal user.
        :param builtins.str line1: Address line 1.
        :param builtins.str line2: Address line 2.
        :param builtins.str line3: Address line 3.
        :param builtins.str line4: Address line 4.
        :param builtins.str middle_name: Middle name of the contact person.
        :param builtins.str municipal_inscription: Municipal Inscription.
        :param builtins.str phone_country_code: Phone country code of the contact person.
        :param builtins.str phone_number: Phone number of the contact person.
        :param builtins.str postal_code: Post code of the address.
        :param builtins.str province: Province of the address.
        :param builtins.str state: State of the address.
        :param builtins.str state_inscription: State Inscription.
        :param builtins.str street_name: Street name of the address.
        :param builtins.str street_number: Street number of the address.
        """
        if address_key is not None:
            pulumi.set(__self__, "address_key", address_key)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if company_name is not None:
            pulumi.set(__self__, "company_name", company_name)
        if contributor_class is not None:
            pulumi.set(__self__, "contributor_class", contributor_class)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if county is not None:
            pulumi.set(__self__, "county", county)
        if department_name is not None:
            pulumi.set(__self__, "department_name", department_name)
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if internal_number is not None:
            pulumi.set(__self__, "internal_number", internal_number)
        if job_title is not None:
            pulumi.set(__self__, "job_title", job_title)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if line1 is not None:
            pulumi.set(__self__, "line1", line1)
        if line2 is not None:
            pulumi.set(__self__, "line2", line2)
        if line3 is not None:
            pulumi.set(__self__, "line3", line3)
        if line4 is not None:
            pulumi.set(__self__, "line4", line4)
        if middle_name is not None:
            pulumi.set(__self__, "middle_name", middle_name)
        if municipal_inscription is not None:
            pulumi.set(__self__, "municipal_inscription", municipal_inscription)
        if phone_country_code is not None:
            pulumi.set(__self__, "phone_country_code", phone_country_code)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_inscription is not None:
            pulumi.set(__self__, "state_inscription", state_inscription)
        if street_name is not None:
            pulumi.set(__self__, "street_name", street_name)
        if street_number is not None:
            pulumi.set(__self__, "street_number", street_number)

    @property
    @pulumi.getter(name="addressKey")
    def address_key(self) -> Optional[builtins.str]:
        """
        Address identifier.
        """
        return pulumi.get(self, "address_key")

    @property
    @pulumi.getter
    def city(self) -> Optional[builtins.str]:
        """
        Name of the city.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> Optional[builtins.str]:
        """
        Name of the customer company.
        """
        return pulumi.get(self, "company_name")

    @property
    @pulumi.getter(name="contributorClass")
    def contributor_class(self) -> Optional[builtins.str]:
        """
        Contributor class of the customer company.
        """
        return pulumi.get(self, "contributor_class")

    @property
    @pulumi.getter
    def country(self) -> Optional[builtins.str]:
        """
        Country of the address.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def county(self) -> Optional[builtins.str]:
        """
        County of the address.
        """
        return pulumi.get(self, "county")

    @property
    @pulumi.getter(name="departmentName")
    def department_name(self) -> Optional[builtins.str]:
        """
        Department name of the customer company.
        """
        return pulumi.get(self, "department_name")

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional[builtins.str]:
        """
        The email address of the paypal user.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[builtins.str]:
        """
        First name of the paypal user.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="internalNumber")
    def internal_number(self) -> Optional[builtins.str]:
        """
        Internal number of the customer company.
        """
        return pulumi.get(self, "internal_number")

    @property
    @pulumi.getter(name="jobTitle")
    def job_title(self) -> Optional[builtins.str]:
        """
        Job title of the contact person.
        """
        return pulumi.get(self, "job_title")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[builtins.str]:
        """
        Last name of the paypal user.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def line1(self) -> Optional[builtins.str]:
        """
        Address line 1.
        """
        return pulumi.get(self, "line1")

    @property
    @pulumi.getter
    def line2(self) -> Optional[builtins.str]:
        """
        Address line 2.
        """
        return pulumi.get(self, "line2")

    @property
    @pulumi.getter
    def line3(self) -> Optional[builtins.str]:
        """
        Address line 3.
        """
        return pulumi.get(self, "line3")

    @property
    @pulumi.getter
    def line4(self) -> Optional[builtins.str]:
        """
        Address line 4.
        """
        return pulumi.get(self, "line4")

    @property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> Optional[builtins.str]:
        """
        Middle name of the contact person.
        """
        return pulumi.get(self, "middle_name")

    @property
    @pulumi.getter(name="municipalInscription")
    def municipal_inscription(self) -> Optional[builtins.str]:
        """
        Municipal Inscription.
        """
        return pulumi.get(self, "municipal_inscription")

    @property
    @pulumi.getter(name="phoneCountryCode")
    def phone_country_code(self) -> Optional[builtins.str]:
        """
        Phone country code of the contact person.
        """
        return pulumi.get(self, "phone_country_code")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[builtins.str]:
        """
        Phone number of the contact person.
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[builtins.str]:
        """
        Post code of the address.
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def province(self) -> Optional[builtins.str]:
        """
        Province of the address.
        """
        return pulumi.get(self, "province")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        State of the address.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateInscription")
    def state_inscription(self) -> Optional[builtins.str]:
        """
        State Inscription.
        """
        return pulumi.get(self, "state_inscription")

    @property
    @pulumi.getter(name="streetName")
    def street_name(self) -> Optional[builtins.str]:
        """
        Street name of the address.
        """
        return pulumi.get(self, "street_name")

    @property
    @pulumi.getter(name="streetNumber")
    def street_number(self) -> Optional[builtins.str]:
        """
        Street number of the address.
        """
        return pulumi.get(self, "street_number")


@pulumi.output_type
class SubscriptionPaymentGateway(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "merchantDefinedDatas":
            suggest = "merchant_defined_datas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionPaymentGateway. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionPaymentGateway.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionPaymentGateway.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 merchant_defined_datas: Optional[Sequence['outputs.SubscriptionPaymentGatewayMerchantDefinedData']] = None):
        """
        :param Sequence['SubscriptionPaymentGatewayMerchantDefinedDataArgs'] merchant_defined_datas: Merchant details.
        """
        if merchant_defined_datas is not None:
            pulumi.set(__self__, "merchant_defined_datas", merchant_defined_datas)

    @property
    @pulumi.getter(name="merchantDefinedDatas")
    def merchant_defined_datas(self) -> Optional[Sequence['outputs.SubscriptionPaymentGatewayMerchantDefinedData']]:
        """
        Merchant details.
        """
        return pulumi.get(self, "merchant_defined_datas")


@pulumi.output_type
class SubscriptionPaymentGatewayMerchantDefinedData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudAccountName":
            suggest = "cloud_account_name"
        elif key == "promoType":
            suggest = "promo_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionPaymentGatewayMerchantDefinedData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionPaymentGatewayMerchantDefinedData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionPaymentGatewayMerchantDefinedData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_account_name: Optional[builtins.str] = None,
                 promo_type: Optional[builtins.str] = None):
        """
        :param builtins.str cloud_account_name: Cloud account name.
        :param builtins.str promo_type: Promotion type code.
        """
        if cloud_account_name is not None:
            pulumi.set(__self__, "cloud_account_name", cloud_account_name)
        if promo_type is not None:
            pulumi.set(__self__, "promo_type", promo_type)

    @property
    @pulumi.getter(name="cloudAccountName")
    def cloud_account_name(self) -> Optional[builtins.str]:
        """
        Cloud account name.
        """
        return pulumi.get(self, "cloud_account_name")

    @property
    @pulumi.getter(name="promoType")
    def promo_type(self) -> Optional[builtins.str]:
        """
        Promotion type code.
        """
        return pulumi.get(self, "promo_type")


@pulumi.output_type
class SubscriptionPaymentOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creditCardType":
            suggest = "credit_card_type"
        elif key == "emailAddress":
            suggest = "email_address"
        elif key == "extBillingAgreementId":
            suggest = "ext_billing_agreement_id"
        elif key == "firstName":
            suggest = "first_name"
        elif key == "lastDigits":
            suggest = "last_digits"
        elif key == "lastName":
            suggest = "last_name"
        elif key == "nameOnCard":
            suggest = "name_on_card"
        elif key == "paymentMethod":
            suggest = "payment_method"
        elif key == "timeExpiration":
            suggest = "time_expiration"
        elif key == "walletInstrumentId":
            suggest = "wallet_instrument_id"
        elif key == "walletTransactionId":
            suggest = "wallet_transaction_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionPaymentOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionPaymentOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionPaymentOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credit_card_type: Optional[builtins.str] = None,
                 email_address: Optional[builtins.str] = None,
                 ext_billing_agreement_id: Optional[builtins.str] = None,
                 first_name: Optional[builtins.str] = None,
                 last_digits: Optional[builtins.str] = None,
                 last_name: Optional[builtins.str] = None,
                 name_on_card: Optional[builtins.str] = None,
                 payment_method: Optional[builtins.str] = None,
                 time_expiration: Optional[builtins.str] = None,
                 wallet_instrument_id: Optional[builtins.str] = None,
                 wallet_transaction_id: Optional[builtins.str] = None):
        """
        :param builtins.str credit_card_type: Credit card type.
        :param builtins.str email_address: The email address of the paypal user.
        :param builtins.str ext_billing_agreement_id: Agreement id for the paypal account.
        :param builtins.str first_name: First name of the paypal user.
        :param builtins.str last_digits: Last four digits of the card.
        :param builtins.str last_name: Last name of the paypal user.
        :param builtins.str name_on_card: Name on the credit card.
        :param builtins.str payment_method: Payment method
        :param builtins.str time_expiration: Expired date of the credit card.
        :param builtins.str wallet_instrument_id: Wallet instrument internal id.
        :param builtins.str wallet_transaction_id: Wallet transaction id.
        """
        if credit_card_type is not None:
            pulumi.set(__self__, "credit_card_type", credit_card_type)
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)
        if ext_billing_agreement_id is not None:
            pulumi.set(__self__, "ext_billing_agreement_id", ext_billing_agreement_id)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_digits is not None:
            pulumi.set(__self__, "last_digits", last_digits)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if name_on_card is not None:
            pulumi.set(__self__, "name_on_card", name_on_card)
        if payment_method is not None:
            pulumi.set(__self__, "payment_method", payment_method)
        if time_expiration is not None:
            pulumi.set(__self__, "time_expiration", time_expiration)
        if wallet_instrument_id is not None:
            pulumi.set(__self__, "wallet_instrument_id", wallet_instrument_id)
        if wallet_transaction_id is not None:
            pulumi.set(__self__, "wallet_transaction_id", wallet_transaction_id)

    @property
    @pulumi.getter(name="creditCardType")
    def credit_card_type(self) -> Optional[builtins.str]:
        """
        Credit card type.
        """
        return pulumi.get(self, "credit_card_type")

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional[builtins.str]:
        """
        The email address of the paypal user.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="extBillingAgreementId")
    def ext_billing_agreement_id(self) -> Optional[builtins.str]:
        """
        Agreement id for the paypal account.
        """
        return pulumi.get(self, "ext_billing_agreement_id")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[builtins.str]:
        """
        First name of the paypal user.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastDigits")
    def last_digits(self) -> Optional[builtins.str]:
        """
        Last four digits of the card.
        """
        return pulumi.get(self, "last_digits")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[builtins.str]:
        """
        Last name of the paypal user.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="nameOnCard")
    def name_on_card(self) -> Optional[builtins.str]:
        """
        Name on the credit card.
        """
        return pulumi.get(self, "name_on_card")

    @property
    @pulumi.getter(name="paymentMethod")
    def payment_method(self) -> Optional[builtins.str]:
        """
        Payment method
        """
        return pulumi.get(self, "payment_method")

    @property
    @pulumi.getter(name="timeExpiration")
    def time_expiration(self) -> Optional[builtins.str]:
        """
        Expired date of the credit card.
        """
        return pulumi.get(self, "time_expiration")

    @property
    @pulumi.getter(name="walletInstrumentId")
    def wallet_instrument_id(self) -> Optional[builtins.str]:
        """
        Wallet instrument internal id.
        """
        return pulumi.get(self, "wallet_instrument_id")

    @property
    @pulumi.getter(name="walletTransactionId")
    def wallet_transaction_id(self) -> Optional[builtins.str]:
        """
        Wallet transaction id.
        """
        return pulumi.get(self, "wallet_transaction_id")


@pulumi.output_type
class SubscriptionSubscription(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subscriptionPlanNumber":
            suggest = "subscription_plan_number"
        elif key == "accountType":
            suggest = "account_type"
        elif key == "billToCustAccountId":
            suggest = "bill_to_cust_account_id"
        elif key == "billingAddresses":
            suggest = "billing_addresses"
        elif key == "currencyCode":
            suggest = "currency_code"
        elif key == "gsiOrgCode":
            suggest = "gsi_org_code"
        elif key == "isIntentToPay":
            suggest = "is_intent_to_pay"
        elif key == "languageCode":
            suggest = "language_code"
        elif key == "organizationId":
            suggest = "organization_id"
        elif key == "paymentGateway":
            suggest = "payment_gateway"
        elif key == "paymentOptions":
            suggest = "payment_options"
        elif key == "planType":
            suggest = "plan_type"
        elif key == "shipToCustAcctRoleId":
            suggest = "ship_to_cust_acct_role_id"
        elif key == "shipToCustAcctSiteId":
            suggest = "ship_to_cust_acct_site_id"
        elif key == "taxInfo":
            suggest = "tax_info"
        elif key == "timePersonalToCorporateConv":
            suggest = "time_personal_to_corporate_conv"
        elif key == "timePlanUpgrade":
            suggest = "time_plan_upgrade"
        elif key == "timeStart":
            suggest = "time_start"
        elif key == "upgradeState":
            suggest = "upgrade_state"
        elif key == "upgradeStateDetails":
            suggest = "upgrade_state_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionSubscription. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionSubscription.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionSubscription.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subscription_plan_number: builtins.str,
                 account_type: Optional[builtins.str] = None,
                 bill_to_cust_account_id: Optional[builtins.str] = None,
                 billing_addresses: Optional[Sequence['outputs.SubscriptionSubscriptionBillingAddress']] = None,
                 currency_code: Optional[builtins.str] = None,
                 gsi_org_code: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 is_intent_to_pay: Optional[builtins.bool] = None,
                 language_code: Optional[builtins.str] = None,
                 organization_id: Optional[builtins.str] = None,
                 payment_gateway: Optional['outputs.SubscriptionSubscriptionPaymentGateway'] = None,
                 payment_options: Optional[Sequence['outputs.SubscriptionSubscriptionPaymentOption']] = None,
                 plan_type: Optional[builtins.str] = None,
                 ship_to_cust_acct_role_id: Optional[builtins.str] = None,
                 ship_to_cust_acct_site_id: Optional[builtins.str] = None,
                 tax_info: Optional['outputs.SubscriptionSubscriptionTaxInfo'] = None,
                 time_personal_to_corporate_conv: Optional[builtins.str] = None,
                 time_plan_upgrade: Optional[builtins.str] = None,
                 time_start: Optional[builtins.str] = None,
                 upgrade_state: Optional[builtins.str] = None,
                 upgrade_state_details: Optional[builtins.str] = None):
        """
        :param builtins.str subscription_plan_number: (Updatable) Subscription plan number.
        :param builtins.str account_type: (Updatable) Account type.
        :param builtins.str bill_to_cust_account_id: (Updatable) Bill to customer Account id.
        :param Sequence['SubscriptionSubscriptionBillingAddressArgs'] billing_addresses: (Updatable) Address details model.
        :param builtins.str currency_code: (Updatable) Currency code
        :param builtins.str gsi_org_code: (Updatable) GSI Subscription external code.
        :param builtins.str id: (Updatable) Subscription id identifier (OCID).
        :param builtins.bool is_intent_to_pay: (Updatable) Payment intension.
        :param builtins.str language_code: (Updatable) Language short code (en, de, hu, etc)
        :param builtins.str organization_id: (Updatable) GSI organization external identifier.
        :param 'SubscriptionSubscriptionPaymentGatewayArgs' payment_gateway: (Updatable) Payment gateway details.
        :param Sequence['SubscriptionSubscriptionPaymentOptionArgs'] payment_options: (Updatable) Payment option list of a subscription.
        :param builtins.str plan_type: (Updatable) Subscription plan type.
        :param builtins.str ship_to_cust_acct_role_id: (Updatable) Ship to customer account role.
        :param builtins.str ship_to_cust_acct_site_id: (Updatable) Ship to customer account site address id.
        :param 'SubscriptionSubscriptionTaxInfoArgs' tax_info: (Updatable) Tax details.
        :param builtins.str time_personal_to_corporate_conv: (Updatable) Date of upgrade/conversion when account type changed from PERSONAL to CORPORATE
        :param builtins.str time_plan_upgrade: (Updatable) Date of upgrade/conversion when planType changed from FREE_TIER to PAYG
        :param builtins.str time_start: (Updatable) Start date of the subscription.
        :param builtins.str upgrade_state: (Updatable) Status of the upgrade.
        :param builtins.str upgrade_state_details: (Updatable) This field is used to describe the Upgrade State in case of error (E.g. Upgrade failure caused by interfacing Tax details- TaxError)
        """
        pulumi.set(__self__, "subscription_plan_number", subscription_plan_number)
        if account_type is not None:
            pulumi.set(__self__, "account_type", account_type)
        if bill_to_cust_account_id is not None:
            pulumi.set(__self__, "bill_to_cust_account_id", bill_to_cust_account_id)
        if billing_addresses is not None:
            pulumi.set(__self__, "billing_addresses", billing_addresses)
        if currency_code is not None:
            pulumi.set(__self__, "currency_code", currency_code)
        if gsi_org_code is not None:
            pulumi.set(__self__, "gsi_org_code", gsi_org_code)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_intent_to_pay is not None:
            pulumi.set(__self__, "is_intent_to_pay", is_intent_to_pay)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if payment_gateway is not None:
            pulumi.set(__self__, "payment_gateway", payment_gateway)
        if payment_options is not None:
            pulumi.set(__self__, "payment_options", payment_options)
        if plan_type is not None:
            pulumi.set(__self__, "plan_type", plan_type)
        if ship_to_cust_acct_role_id is not None:
            pulumi.set(__self__, "ship_to_cust_acct_role_id", ship_to_cust_acct_role_id)
        if ship_to_cust_acct_site_id is not None:
            pulumi.set(__self__, "ship_to_cust_acct_site_id", ship_to_cust_acct_site_id)
        if tax_info is not None:
            pulumi.set(__self__, "tax_info", tax_info)
        if time_personal_to_corporate_conv is not None:
            pulumi.set(__self__, "time_personal_to_corporate_conv", time_personal_to_corporate_conv)
        if time_plan_upgrade is not None:
            pulumi.set(__self__, "time_plan_upgrade", time_plan_upgrade)
        if time_start is not None:
            pulumi.set(__self__, "time_start", time_start)
        if upgrade_state is not None:
            pulumi.set(__self__, "upgrade_state", upgrade_state)
        if upgrade_state_details is not None:
            pulumi.set(__self__, "upgrade_state_details", upgrade_state_details)

    @property
    @pulumi.getter(name="subscriptionPlanNumber")
    def subscription_plan_number(self) -> builtins.str:
        """
        (Updatable) Subscription plan number.
        """
        return pulumi.get(self, "subscription_plan_number")

    @property
    @pulumi.getter(name="accountType")
    def account_type(self) -> Optional[builtins.str]:
        """
        (Updatable) Account type.
        """
        return pulumi.get(self, "account_type")

    @property
    @pulumi.getter(name="billToCustAccountId")
    def bill_to_cust_account_id(self) -> Optional[builtins.str]:
        """
        (Updatable) Bill to customer Account id.
        """
        return pulumi.get(self, "bill_to_cust_account_id")

    @property
    @pulumi.getter(name="billingAddresses")
    def billing_addresses(self) -> Optional[Sequence['outputs.SubscriptionSubscriptionBillingAddress']]:
        """
        (Updatable) Address details model.
        """
        return pulumi.get(self, "billing_addresses")

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> Optional[builtins.str]:
        """
        (Updatable) Currency code
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter(name="gsiOrgCode")
    def gsi_org_code(self) -> Optional[builtins.str]:
        """
        (Updatable) GSI Subscription external code.
        """
        return pulumi.get(self, "gsi_org_code")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        (Updatable) Subscription id identifier (OCID).
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isIntentToPay")
    def is_intent_to_pay(self) -> Optional[builtins.bool]:
        """
        (Updatable) Payment intension.
        """
        return pulumi.get(self, "is_intent_to_pay")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[builtins.str]:
        """
        (Updatable) Language short code (en, de, hu, etc)
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[builtins.str]:
        """
        (Updatable) GSI organization external identifier.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="paymentGateway")
    def payment_gateway(self) -> Optional['outputs.SubscriptionSubscriptionPaymentGateway']:
        """
        (Updatable) Payment gateway details.
        """
        return pulumi.get(self, "payment_gateway")

    @property
    @pulumi.getter(name="paymentOptions")
    def payment_options(self) -> Optional[Sequence['outputs.SubscriptionSubscriptionPaymentOption']]:
        """
        (Updatable) Payment option list of a subscription.
        """
        return pulumi.get(self, "payment_options")

    @property
    @pulumi.getter(name="planType")
    def plan_type(self) -> Optional[builtins.str]:
        """
        (Updatable) Subscription plan type.
        """
        return pulumi.get(self, "plan_type")

    @property
    @pulumi.getter(name="shipToCustAcctRoleId")
    def ship_to_cust_acct_role_id(self) -> Optional[builtins.str]:
        """
        (Updatable) Ship to customer account role.
        """
        return pulumi.get(self, "ship_to_cust_acct_role_id")

    @property
    @pulumi.getter(name="shipToCustAcctSiteId")
    def ship_to_cust_acct_site_id(self) -> Optional[builtins.str]:
        """
        (Updatable) Ship to customer account site address id.
        """
        return pulumi.get(self, "ship_to_cust_acct_site_id")

    @property
    @pulumi.getter(name="taxInfo")
    def tax_info(self) -> Optional['outputs.SubscriptionSubscriptionTaxInfo']:
        """
        (Updatable) Tax details.
        """
        return pulumi.get(self, "tax_info")

    @property
    @pulumi.getter(name="timePersonalToCorporateConv")
    def time_personal_to_corporate_conv(self) -> Optional[builtins.str]:
        """
        (Updatable) Date of upgrade/conversion when account type changed from PERSONAL to CORPORATE
        """
        return pulumi.get(self, "time_personal_to_corporate_conv")

    @property
    @pulumi.getter(name="timePlanUpgrade")
    def time_plan_upgrade(self) -> Optional[builtins.str]:
        """
        (Updatable) Date of upgrade/conversion when planType changed from FREE_TIER to PAYG
        """
        return pulumi.get(self, "time_plan_upgrade")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> Optional[builtins.str]:
        """
        (Updatable) Start date of the subscription.
        """
        return pulumi.get(self, "time_start")

    @property
    @pulumi.getter(name="upgradeState")
    def upgrade_state(self) -> Optional[builtins.str]:
        """
        (Updatable) Status of the upgrade.
        """
        return pulumi.get(self, "upgrade_state")

    @property
    @pulumi.getter(name="upgradeStateDetails")
    def upgrade_state_details(self) -> Optional[builtins.str]:
        """
        (Updatable) This field is used to describe the Upgrade State in case of error (E.g. Upgrade failure caused by interfacing Tax details- TaxError)
        """
        return pulumi.get(self, "upgrade_state_details")


@pulumi.output_type
class SubscriptionSubscriptionBillingAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressKey":
            suggest = "address_key"
        elif key == "companyName":
            suggest = "company_name"
        elif key == "contributorClass":
            suggest = "contributor_class"
        elif key == "departmentName":
            suggest = "department_name"
        elif key == "emailAddress":
            suggest = "email_address"
        elif key == "firstName":
            suggest = "first_name"
        elif key == "internalNumber":
            suggest = "internal_number"
        elif key == "jobTitle":
            suggest = "job_title"
        elif key == "lastName":
            suggest = "last_name"
        elif key == "middleName":
            suggest = "middle_name"
        elif key == "municipalInscription":
            suggest = "municipal_inscription"
        elif key == "phoneCountryCode":
            suggest = "phone_country_code"
        elif key == "phoneNumber":
            suggest = "phone_number"
        elif key == "postalCode":
            suggest = "postal_code"
        elif key == "stateInscription":
            suggest = "state_inscription"
        elif key == "streetName":
            suggest = "street_name"
        elif key == "streetNumber":
            suggest = "street_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionSubscriptionBillingAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionSubscriptionBillingAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionSubscriptionBillingAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_key: Optional[builtins.str] = None,
                 city: Optional[builtins.str] = None,
                 company_name: Optional[builtins.str] = None,
                 contributor_class: Optional[builtins.str] = None,
                 country: Optional[builtins.str] = None,
                 county: Optional[builtins.str] = None,
                 department_name: Optional[builtins.str] = None,
                 email_address: Optional[builtins.str] = None,
                 first_name: Optional[builtins.str] = None,
                 internal_number: Optional[builtins.str] = None,
                 job_title: Optional[builtins.str] = None,
                 last_name: Optional[builtins.str] = None,
                 line1: Optional[builtins.str] = None,
                 line2: Optional[builtins.str] = None,
                 line3: Optional[builtins.str] = None,
                 line4: Optional[builtins.str] = None,
                 middle_name: Optional[builtins.str] = None,
                 municipal_inscription: Optional[builtins.str] = None,
                 phone_country_code: Optional[builtins.str] = None,
                 phone_number: Optional[builtins.str] = None,
                 postal_code: Optional[builtins.str] = None,
                 province: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 state_inscription: Optional[builtins.str] = None,
                 street_name: Optional[builtins.str] = None,
                 street_number: Optional[builtins.str] = None):
        """
        :param builtins.str address_key: (Updatable) Address identifier.
        :param builtins.str city: (Updatable) Name of the city.
        :param builtins.str company_name: (Updatable) Name of the customer company.
        :param builtins.str contributor_class: (Updatable) Contributor class of the customer company.
        :param builtins.str country: (Updatable) Country of the address.
        :param builtins.str county: (Updatable) County of the address.
        :param builtins.str department_name: (Updatable) Department name of the customer company.
        :param builtins.str email_address: (Updatable) Contact person email address.
        :param builtins.str first_name: (Updatable) First name of the contact person.
        :param builtins.str internal_number: (Updatable) Internal number of the customer company.
        :param builtins.str job_title: (Updatable) Job title of the contact person.
        :param builtins.str last_name: (Updatable) Last name of the contact person.
        :param builtins.str line1: (Updatable) Address line 1.
        :param builtins.str line2: (Updatable) Address line 2.
        :param builtins.str line3: (Updatable) Address line 3.
        :param builtins.str line4: (Updatable) Address line 4.
        :param builtins.str middle_name: (Updatable) Middle name of the contact person.
        :param builtins.str municipal_inscription: (Updatable) Municipal Inscription.
        :param builtins.str phone_country_code: (Updatable) Phone country code of the contact person.
        :param builtins.str phone_number: (Updatable) Phone number of the contact person.
        :param builtins.str postal_code: (Updatable) Post code of the address.
        :param builtins.str province: (Updatable) Province of the address.
        :param builtins.str state: (Updatable) State of the address.
        :param builtins.str state_inscription: (Updatable) State Inscription.
        :param builtins.str street_name: (Updatable) Street name of the address.
        :param builtins.str street_number: (Updatable) Street number of the address.
        """
        if address_key is not None:
            pulumi.set(__self__, "address_key", address_key)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if company_name is not None:
            pulumi.set(__self__, "company_name", company_name)
        if contributor_class is not None:
            pulumi.set(__self__, "contributor_class", contributor_class)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if county is not None:
            pulumi.set(__self__, "county", county)
        if department_name is not None:
            pulumi.set(__self__, "department_name", department_name)
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if internal_number is not None:
            pulumi.set(__self__, "internal_number", internal_number)
        if job_title is not None:
            pulumi.set(__self__, "job_title", job_title)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if line1 is not None:
            pulumi.set(__self__, "line1", line1)
        if line2 is not None:
            pulumi.set(__self__, "line2", line2)
        if line3 is not None:
            pulumi.set(__self__, "line3", line3)
        if line4 is not None:
            pulumi.set(__self__, "line4", line4)
        if middle_name is not None:
            pulumi.set(__self__, "middle_name", middle_name)
        if municipal_inscription is not None:
            pulumi.set(__self__, "municipal_inscription", municipal_inscription)
        if phone_country_code is not None:
            pulumi.set(__self__, "phone_country_code", phone_country_code)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_inscription is not None:
            pulumi.set(__self__, "state_inscription", state_inscription)
        if street_name is not None:
            pulumi.set(__self__, "street_name", street_name)
        if street_number is not None:
            pulumi.set(__self__, "street_number", street_number)

    @property
    @pulumi.getter(name="addressKey")
    def address_key(self) -> Optional[builtins.str]:
        """
        (Updatable) Address identifier.
        """
        return pulumi.get(self, "address_key")

    @property
    @pulumi.getter
    def city(self) -> Optional[builtins.str]:
        """
        (Updatable) Name of the city.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> Optional[builtins.str]:
        """
        (Updatable) Name of the customer company.
        """
        return pulumi.get(self, "company_name")

    @property
    @pulumi.getter(name="contributorClass")
    def contributor_class(self) -> Optional[builtins.str]:
        """
        (Updatable) Contributor class of the customer company.
        """
        return pulumi.get(self, "contributor_class")

    @property
    @pulumi.getter
    def country(self) -> Optional[builtins.str]:
        """
        (Updatable) Country of the address.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def county(self) -> Optional[builtins.str]:
        """
        (Updatable) County of the address.
        """
        return pulumi.get(self, "county")

    @property
    @pulumi.getter(name="departmentName")
    def department_name(self) -> Optional[builtins.str]:
        """
        (Updatable) Department name of the customer company.
        """
        return pulumi.get(self, "department_name")

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional[builtins.str]:
        """
        (Updatable) Contact person email address.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[builtins.str]:
        """
        (Updatable) First name of the contact person.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="internalNumber")
    def internal_number(self) -> Optional[builtins.str]:
        """
        (Updatable) Internal number of the customer company.
        """
        return pulumi.get(self, "internal_number")

    @property
    @pulumi.getter(name="jobTitle")
    def job_title(self) -> Optional[builtins.str]:
        """
        (Updatable) Job title of the contact person.
        """
        return pulumi.get(self, "job_title")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[builtins.str]:
        """
        (Updatable) Last name of the contact person.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def line1(self) -> Optional[builtins.str]:
        """
        (Updatable) Address line 1.
        """
        return pulumi.get(self, "line1")

    @property
    @pulumi.getter
    def line2(self) -> Optional[builtins.str]:
        """
        (Updatable) Address line 2.
        """
        return pulumi.get(self, "line2")

    @property
    @pulumi.getter
    def line3(self) -> Optional[builtins.str]:
        """
        (Updatable) Address line 3.
        """
        return pulumi.get(self, "line3")

    @property
    @pulumi.getter
    def line4(self) -> Optional[builtins.str]:
        """
        (Updatable) Address line 4.
        """
        return pulumi.get(self, "line4")

    @property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> Optional[builtins.str]:
        """
        (Updatable) Middle name of the contact person.
        """
        return pulumi.get(self, "middle_name")

    @property
    @pulumi.getter(name="municipalInscription")
    def municipal_inscription(self) -> Optional[builtins.str]:
        """
        (Updatable) Municipal Inscription.
        """
        return pulumi.get(self, "municipal_inscription")

    @property
    @pulumi.getter(name="phoneCountryCode")
    def phone_country_code(self) -> Optional[builtins.str]:
        """
        (Updatable) Phone country code of the contact person.
        """
        return pulumi.get(self, "phone_country_code")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[builtins.str]:
        """
        (Updatable) Phone number of the contact person.
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[builtins.str]:
        """
        (Updatable) Post code of the address.
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def province(self) -> Optional[builtins.str]:
        """
        (Updatable) Province of the address.
        """
        return pulumi.get(self, "province")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        (Updatable) State of the address.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateInscription")
    def state_inscription(self) -> Optional[builtins.str]:
        """
        (Updatable) State Inscription.
        """
        return pulumi.get(self, "state_inscription")

    @property
    @pulumi.getter(name="streetName")
    def street_name(self) -> Optional[builtins.str]:
        """
        (Updatable) Street name of the address.
        """
        return pulumi.get(self, "street_name")

    @property
    @pulumi.getter(name="streetNumber")
    def street_number(self) -> Optional[builtins.str]:
        """
        (Updatable) Street number of the address.
        """
        return pulumi.get(self, "street_number")


@pulumi.output_type
class SubscriptionSubscriptionPaymentGateway(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "merchantDefinedData":
            suggest = "merchant_defined_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionSubscriptionPaymentGateway. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionSubscriptionPaymentGateway.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionSubscriptionPaymentGateway.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 merchant_defined_data: Optional['outputs.SubscriptionSubscriptionPaymentGatewayMerchantDefinedData'] = None):
        """
        :param 'SubscriptionSubscriptionPaymentGatewayMerchantDefinedDataArgs' merchant_defined_data: (Updatable) Merchant details.
        """
        if merchant_defined_data is not None:
            pulumi.set(__self__, "merchant_defined_data", merchant_defined_data)

    @property
    @pulumi.getter(name="merchantDefinedData")
    def merchant_defined_data(self) -> Optional['outputs.SubscriptionSubscriptionPaymentGatewayMerchantDefinedData']:
        """
        (Updatable) Merchant details.
        """
        return pulumi.get(self, "merchant_defined_data")


@pulumi.output_type
class SubscriptionSubscriptionPaymentGatewayMerchantDefinedData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudAccountName":
            suggest = "cloud_account_name"
        elif key == "promoType":
            suggest = "promo_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionSubscriptionPaymentGatewayMerchantDefinedData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionSubscriptionPaymentGatewayMerchantDefinedData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionSubscriptionPaymentGatewayMerchantDefinedData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_account_name: Optional[builtins.str] = None,
                 promo_type: Optional[builtins.str] = None):
        """
        :param builtins.str cloud_account_name: (Updatable) Cloud account name.
        :param builtins.str promo_type: (Updatable) Promotion type code.
        """
        if cloud_account_name is not None:
            pulumi.set(__self__, "cloud_account_name", cloud_account_name)
        if promo_type is not None:
            pulumi.set(__self__, "promo_type", promo_type)

    @property
    @pulumi.getter(name="cloudAccountName")
    def cloud_account_name(self) -> Optional[builtins.str]:
        """
        (Updatable) Cloud account name.
        """
        return pulumi.get(self, "cloud_account_name")

    @property
    @pulumi.getter(name="promoType")
    def promo_type(self) -> Optional[builtins.str]:
        """
        (Updatable) Promotion type code.
        """
        return pulumi.get(self, "promo_type")


@pulumi.output_type
class SubscriptionSubscriptionPaymentOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "paymentMethod":
            suggest = "payment_method"
        elif key == "creditCardType":
            suggest = "credit_card_type"
        elif key == "emailAddress":
            suggest = "email_address"
        elif key == "extBillingAgreementId":
            suggest = "ext_billing_agreement_id"
        elif key == "firstName":
            suggest = "first_name"
        elif key == "lastDigits":
            suggest = "last_digits"
        elif key == "lastName":
            suggest = "last_name"
        elif key == "nameOnCard":
            suggest = "name_on_card"
        elif key == "timeExpiration":
            suggest = "time_expiration"
        elif key == "walletInstrumentId":
            suggest = "wallet_instrument_id"
        elif key == "walletTransactionId":
            suggest = "wallet_transaction_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionSubscriptionPaymentOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionSubscriptionPaymentOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionSubscriptionPaymentOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 payment_method: builtins.str,
                 credit_card_type: Optional[builtins.str] = None,
                 email_address: Optional[builtins.str] = None,
                 ext_billing_agreement_id: Optional[builtins.str] = None,
                 first_name: Optional[builtins.str] = None,
                 last_digits: Optional[builtins.str] = None,
                 last_name: Optional[builtins.str] = None,
                 name_on_card: Optional[builtins.str] = None,
                 time_expiration: Optional[builtins.str] = None,
                 wallet_instrument_id: Optional[builtins.str] = None,
                 wallet_transaction_id: Optional[builtins.str] = None):
        """
        :param builtins.str payment_method: (Updatable) Payment method
        :param builtins.str credit_card_type: (Updatable) Credit card type.
        :param builtins.str email_address: (Updatable) The email address of the paypal user.
        :param builtins.str ext_billing_agreement_id: (Updatable) Agreement id for the paypal account.
        :param builtins.str first_name: (Updatable) First name of the paypal user.
        :param builtins.str last_digits: (Updatable) Last four digits of the card.
        :param builtins.str last_name: (Updatable) Last name of the paypal user.
        :param builtins.str name_on_card: (Updatable) Name on the credit card.
        :param builtins.str time_expiration: (Updatable) Expired date of the credit card.
        :param builtins.str wallet_instrument_id: (Updatable) Wallet instrument internal id.
        :param builtins.str wallet_transaction_id: (Updatable) Wallet transaction id.
        """
        pulumi.set(__self__, "payment_method", payment_method)
        if credit_card_type is not None:
            pulumi.set(__self__, "credit_card_type", credit_card_type)
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)
        if ext_billing_agreement_id is not None:
            pulumi.set(__self__, "ext_billing_agreement_id", ext_billing_agreement_id)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_digits is not None:
            pulumi.set(__self__, "last_digits", last_digits)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if name_on_card is not None:
            pulumi.set(__self__, "name_on_card", name_on_card)
        if time_expiration is not None:
            pulumi.set(__self__, "time_expiration", time_expiration)
        if wallet_instrument_id is not None:
            pulumi.set(__self__, "wallet_instrument_id", wallet_instrument_id)
        if wallet_transaction_id is not None:
            pulumi.set(__self__, "wallet_transaction_id", wallet_transaction_id)

    @property
    @pulumi.getter(name="paymentMethod")
    def payment_method(self) -> builtins.str:
        """
        (Updatable) Payment method
        """
        return pulumi.get(self, "payment_method")

    @property
    @pulumi.getter(name="creditCardType")
    def credit_card_type(self) -> Optional[builtins.str]:
        """
        (Updatable) Credit card type.
        """
        return pulumi.get(self, "credit_card_type")

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional[builtins.str]:
        """
        (Updatable) The email address of the paypal user.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="extBillingAgreementId")
    def ext_billing_agreement_id(self) -> Optional[builtins.str]:
        """
        (Updatable) Agreement id for the paypal account.
        """
        return pulumi.get(self, "ext_billing_agreement_id")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[builtins.str]:
        """
        (Updatable) First name of the paypal user.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastDigits")
    def last_digits(self) -> Optional[builtins.str]:
        """
        (Updatable) Last four digits of the card.
        """
        return pulumi.get(self, "last_digits")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[builtins.str]:
        """
        (Updatable) Last name of the paypal user.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="nameOnCard")
    def name_on_card(self) -> Optional[builtins.str]:
        """
        (Updatable) Name on the credit card.
        """
        return pulumi.get(self, "name_on_card")

    @property
    @pulumi.getter(name="timeExpiration")
    def time_expiration(self) -> Optional[builtins.str]:
        """
        (Updatable) Expired date of the credit card.
        """
        return pulumi.get(self, "time_expiration")

    @property
    @pulumi.getter(name="walletInstrumentId")
    def wallet_instrument_id(self) -> Optional[builtins.str]:
        """
        (Updatable) Wallet instrument internal id.
        """
        return pulumi.get(self, "wallet_instrument_id")

    @property
    @pulumi.getter(name="walletTransactionId")
    def wallet_transaction_id(self) -> Optional[builtins.str]:
        """
        (Updatable) Wallet transaction id.
        """
        return pulumi.get(self, "wallet_transaction_id")


@pulumi.output_type
class SubscriptionSubscriptionTaxInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "noTaxReasonCode":
            suggest = "no_tax_reason_code"
        elif key == "noTaxReasonCodeDetails":
            suggest = "no_tax_reason_code_details"
        elif key == "taxCnpj":
            suggest = "tax_cnpj"
        elif key == "taxPayerId":
            suggest = "tax_payer_id"
        elif key == "taxRegNumber":
            suggest = "tax_reg_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionSubscriptionTaxInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionSubscriptionTaxInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionSubscriptionTaxInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 no_tax_reason_code: Optional[builtins.str] = None,
                 no_tax_reason_code_details: Optional[builtins.str] = None,
                 tax_cnpj: Optional[builtins.str] = None,
                 tax_payer_id: Optional[builtins.str] = None,
                 tax_reg_number: Optional[builtins.str] = None):
        """
        :param builtins.str no_tax_reason_code: (Updatable) Tax exemption reason code.
        :param builtins.str no_tax_reason_code_details: (Updatable) Tax exemption reason description.
        :param builtins.str tax_cnpj: (Updatable) Brazilian companies' CNPJ number.
        :param builtins.str tax_payer_id: (Updatable) Tay payer identifier.
        :param builtins.str tax_reg_number: (Updatable) Tax registration number.
        """
        if no_tax_reason_code is not None:
            pulumi.set(__self__, "no_tax_reason_code", no_tax_reason_code)
        if no_tax_reason_code_details is not None:
            pulumi.set(__self__, "no_tax_reason_code_details", no_tax_reason_code_details)
        if tax_cnpj is not None:
            pulumi.set(__self__, "tax_cnpj", tax_cnpj)
        if tax_payer_id is not None:
            pulumi.set(__self__, "tax_payer_id", tax_payer_id)
        if tax_reg_number is not None:
            pulumi.set(__self__, "tax_reg_number", tax_reg_number)

    @property
    @pulumi.getter(name="noTaxReasonCode")
    def no_tax_reason_code(self) -> Optional[builtins.str]:
        """
        (Updatable) Tax exemption reason code.
        """
        return pulumi.get(self, "no_tax_reason_code")

    @property
    @pulumi.getter(name="noTaxReasonCodeDetails")
    def no_tax_reason_code_details(self) -> Optional[builtins.str]:
        """
        (Updatable) Tax exemption reason description.
        """
        return pulumi.get(self, "no_tax_reason_code_details")

    @property
    @pulumi.getter(name="taxCnpj")
    def tax_cnpj(self) -> Optional[builtins.str]:
        """
        (Updatable) Brazilian companies' CNPJ number.
        """
        return pulumi.get(self, "tax_cnpj")

    @property
    @pulumi.getter(name="taxPayerId")
    def tax_payer_id(self) -> Optional[builtins.str]:
        """
        (Updatable) Tay payer identifier.
        """
        return pulumi.get(self, "tax_payer_id")

    @property
    @pulumi.getter(name="taxRegNumber")
    def tax_reg_number(self) -> Optional[builtins.str]:
        """
        (Updatable) Tax registration number.
        """
        return pulumi.get(self, "tax_reg_number")


@pulumi.output_type
class SubscriptionTaxInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "noTaxReasonCode":
            suggest = "no_tax_reason_code"
        elif key == "noTaxReasonCodeDetails":
            suggest = "no_tax_reason_code_details"
        elif key == "taxCnpj":
            suggest = "tax_cnpj"
        elif key == "taxPayerId":
            suggest = "tax_payer_id"
        elif key == "taxRegNumber":
            suggest = "tax_reg_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionTaxInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionTaxInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionTaxInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 giro: Optional[builtins.str] = None,
                 no_tax_reason_code: Optional[builtins.str] = None,
                 no_tax_reason_code_details: Optional[builtins.str] = None,
                 tax_cnpj: Optional[builtins.str] = None,
                 tax_payer_id: Optional[builtins.str] = None,
                 tax_reg_number: Optional[builtins.str] = None):
        """
        :param builtins.str giro: Companies' GIRO code
        :param builtins.str no_tax_reason_code: Tax exemption reason code.
        :param builtins.str no_tax_reason_code_details: Tax exemption reason description.
        :param builtins.str tax_cnpj: Brazilian companies' CNPJ number.
        :param builtins.str tax_payer_id: Tay payer identifier.
        :param builtins.str tax_reg_number: Tax registration number.
        """
        if giro is not None:
            pulumi.set(__self__, "giro", giro)
        if no_tax_reason_code is not None:
            pulumi.set(__self__, "no_tax_reason_code", no_tax_reason_code)
        if no_tax_reason_code_details is not None:
            pulumi.set(__self__, "no_tax_reason_code_details", no_tax_reason_code_details)
        if tax_cnpj is not None:
            pulumi.set(__self__, "tax_cnpj", tax_cnpj)
        if tax_payer_id is not None:
            pulumi.set(__self__, "tax_payer_id", tax_payer_id)
        if tax_reg_number is not None:
            pulumi.set(__self__, "tax_reg_number", tax_reg_number)

    @property
    @pulumi.getter
    def giro(self) -> Optional[builtins.str]:
        """
        Companies' GIRO code
        """
        return pulumi.get(self, "giro")

    @property
    @pulumi.getter(name="noTaxReasonCode")
    def no_tax_reason_code(self) -> Optional[builtins.str]:
        """
        Tax exemption reason code.
        """
        return pulumi.get(self, "no_tax_reason_code")

    @property
    @pulumi.getter(name="noTaxReasonCodeDetails")
    def no_tax_reason_code_details(self) -> Optional[builtins.str]:
        """
        Tax exemption reason description.
        """
        return pulumi.get(self, "no_tax_reason_code_details")

    @property
    @pulumi.getter(name="taxCnpj")
    def tax_cnpj(self) -> Optional[builtins.str]:
        """
        Brazilian companies' CNPJ number.
        """
        return pulumi.get(self, "tax_cnpj")

    @property
    @pulumi.getter(name="taxPayerId")
    def tax_payer_id(self) -> Optional[builtins.str]:
        """
        Tay payer identifier.
        """
        return pulumi.get(self, "tax_payer_id")

    @property
    @pulumi.getter(name="taxRegNumber")
    def tax_reg_number(self) -> Optional[builtins.str]:
        """
        Tax registration number.
        """
        return pulumi.get(self, "tax_reg_number")


@pulumi.output_type
class GetAddressRuleAddressResult(dict):
    def __init__(__self__, *,
                 fields: Sequence['outputs.GetAddressRuleAddressFieldResult'],
                 third_party_validation: builtins.str):
        """
        :param Sequence['GetAddressRuleAddressFieldArgs'] fields: Tax type rule fields
        :param builtins.str third_party_validation: Third party validation.
        """
        pulumi.set(__self__, "fields", fields)
        pulumi.set(__self__, "third_party_validation", third_party_validation)

    @property
    @pulumi.getter
    def fields(self) -> Sequence['outputs.GetAddressRuleAddressFieldResult']:
        """
        Tax type rule fields
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter(name="thirdPartyValidation")
    def third_party_validation(self) -> builtins.str:
        """
        Third party validation.
        """
        return pulumi.get(self, "third_party_validation")


@pulumi.output_type
class GetAddressRuleAddressFieldResult(dict):
    def __init__(__self__, *,
                 formats: Sequence['outputs.GetAddressRuleAddressFieldFormatResult'],
                 is_required: builtins.bool,
                 labels: Sequence['outputs.GetAddressRuleAddressFieldLabelResult'],
                 language: builtins.str,
                 name: builtins.str):
        """
        :param Sequence['GetAddressRuleAddressFieldFormatArgs'] formats: Format information
        :param builtins.bool is_required: The given field is requeired or not
        :param Sequence['GetAddressRuleAddressFieldLabelArgs'] labels: Label information
        :param builtins.str language: Locale code (rfc4646 format) of a forced language (e.g.: jp addresses require jp always)
        :param builtins.str name: User friendly name
        """
        pulumi.set(__self__, "formats", formats)
        pulumi.set(__self__, "is_required", is_required)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "language", language)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def formats(self) -> Sequence['outputs.GetAddressRuleAddressFieldFormatResult']:
        """
        Format information
        """
        return pulumi.get(self, "formats")

    @property
    @pulumi.getter(name="isRequired")
    def is_required(self) -> builtins.bool:
        """
        The given field is requeired or not
        """
        return pulumi.get(self, "is_required")

    @property
    @pulumi.getter
    def labels(self) -> Sequence['outputs.GetAddressRuleAddressFieldLabelResult']:
        """
        Label information
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def language(self) -> builtins.str:
        """
        Locale code (rfc4646 format) of a forced language (e.g.: jp addresses require jp always)
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        User friendly name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAddressRuleAddressFieldFormatResult(dict):
    def __init__(__self__, *,
                 example: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str example: English translation of the label (for reference only - translation is not provided)
        :param builtins.str value: Value
        """
        pulumi.set(__self__, "example", example)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def example(self) -> builtins.str:
        """
        English translation of the label (for reference only - translation is not provided)
        """
        return pulumi.get(self, "example")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAddressRuleAddressFieldLabelResult(dict):
    def __init__(__self__, *,
                 example: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str example: English translation of the label (for reference only - translation is not provided)
        :param builtins.str value: Value
        """
        pulumi.set(__self__, "example", example)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def example(self) -> builtins.str:
        """
        English translation of the label (for reference only - translation is not provided)
        """
        return pulumi.get(self, "example")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAddressRuleContactResult(dict):
    def __init__(__self__, *,
                 fields: Sequence['outputs.GetAddressRuleContactFieldResult']):
        """
        :param Sequence['GetAddressRuleContactFieldArgs'] fields: Tax type rule fields
        """
        pulumi.set(__self__, "fields", fields)

    @property
    @pulumi.getter
    def fields(self) -> Sequence['outputs.GetAddressRuleContactFieldResult']:
        """
        Tax type rule fields
        """
        return pulumi.get(self, "fields")


@pulumi.output_type
class GetAddressRuleContactFieldResult(dict):
    def __init__(__self__, *,
                 formats: Sequence['outputs.GetAddressRuleContactFieldFormatResult'],
                 is_required: builtins.bool,
                 labels: Sequence['outputs.GetAddressRuleContactFieldLabelResult'],
                 language: builtins.str,
                 name: builtins.str):
        """
        :param Sequence['GetAddressRuleContactFieldFormatArgs'] formats: Format information
        :param builtins.bool is_required: The given field is requeired or not
        :param Sequence['GetAddressRuleContactFieldLabelArgs'] labels: Label information
        :param builtins.str language: Locale code (rfc4646 format) of a forced language (e.g.: jp addresses require jp always)
        :param builtins.str name: User friendly name
        """
        pulumi.set(__self__, "formats", formats)
        pulumi.set(__self__, "is_required", is_required)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "language", language)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def formats(self) -> Sequence['outputs.GetAddressRuleContactFieldFormatResult']:
        """
        Format information
        """
        return pulumi.get(self, "formats")

    @property
    @pulumi.getter(name="isRequired")
    def is_required(self) -> builtins.bool:
        """
        The given field is requeired or not
        """
        return pulumi.get(self, "is_required")

    @property
    @pulumi.getter
    def labels(self) -> Sequence['outputs.GetAddressRuleContactFieldLabelResult']:
        """
        Label information
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def language(self) -> builtins.str:
        """
        Locale code (rfc4646 format) of a forced language (e.g.: jp addresses require jp always)
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        User friendly name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAddressRuleContactFieldFormatResult(dict):
    def __init__(__self__, *,
                 example: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str example: English translation of the label (for reference only - translation is not provided)
        :param builtins.str value: Value
        """
        pulumi.set(__self__, "example", example)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def example(self) -> builtins.str:
        """
        English translation of the label (for reference only - translation is not provided)
        """
        return pulumi.get(self, "example")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAddressRuleContactFieldLabelResult(dict):
    def __init__(__self__, *,
                 example: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str example: English translation of the label (for reference only - translation is not provided)
        :param builtins.str value: Value
        """
        pulumi.set(__self__, "example", example)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def example(self) -> builtins.str:
        """
        English translation of the label (for reference only - translation is not provided)
        """
        return pulumi.get(self, "example")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAddressRuleTaxResult(dict):
    def __init__(__self__, *,
                 fields: Sequence['outputs.GetAddressRuleTaxFieldResult'],
                 value_sets: Sequence['outputs.GetAddressRuleTaxValueSetResult']):
        """
        :param Sequence['GetAddressRuleTaxFieldArgs'] fields: Tax type rule fields
        :param Sequence['GetAddressRuleTaxValueSetArgs'] value_sets: Label value pair for allowed values. Used for GIRO
        """
        pulumi.set(__self__, "fields", fields)
        pulumi.set(__self__, "value_sets", value_sets)

    @property
    @pulumi.getter
    def fields(self) -> Sequence['outputs.GetAddressRuleTaxFieldResult']:
        """
        Tax type rule fields
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter(name="valueSets")
    def value_sets(self) -> Sequence['outputs.GetAddressRuleTaxValueSetResult']:
        """
        Label value pair for allowed values. Used for GIRO
        """
        return pulumi.get(self, "value_sets")


@pulumi.output_type
class GetAddressRuleTaxFieldResult(dict):
    def __init__(__self__, *,
                 formats: Sequence['outputs.GetAddressRuleTaxFieldFormatResult'],
                 is_required: builtins.bool,
                 labels: Sequence['outputs.GetAddressRuleTaxFieldLabelResult'],
                 language: builtins.str,
                 name: builtins.str):
        """
        :param Sequence['GetAddressRuleTaxFieldFormatArgs'] formats: Format information
        :param builtins.bool is_required: The given field is requeired or not
        :param Sequence['GetAddressRuleTaxFieldLabelArgs'] labels: Label information
        :param builtins.str language: Locale code (rfc4646 format) of a forced language (e.g.: jp addresses require jp always)
        :param builtins.str name: User friendly name
        """
        pulumi.set(__self__, "formats", formats)
        pulumi.set(__self__, "is_required", is_required)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "language", language)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def formats(self) -> Sequence['outputs.GetAddressRuleTaxFieldFormatResult']:
        """
        Format information
        """
        return pulumi.get(self, "formats")

    @property
    @pulumi.getter(name="isRequired")
    def is_required(self) -> builtins.bool:
        """
        The given field is requeired or not
        """
        return pulumi.get(self, "is_required")

    @property
    @pulumi.getter
    def labels(self) -> Sequence['outputs.GetAddressRuleTaxFieldLabelResult']:
        """
        Label information
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def language(self) -> builtins.str:
        """
        Locale code (rfc4646 format) of a forced language (e.g.: jp addresses require jp always)
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        User friendly name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAddressRuleTaxFieldFormatResult(dict):
    def __init__(__self__, *,
                 example: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str example: English translation of the label (for reference only - translation is not provided)
        :param builtins.str value: Value
        """
        pulumi.set(__self__, "example", example)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def example(self) -> builtins.str:
        """
        English translation of the label (for reference only - translation is not provided)
        """
        return pulumi.get(self, "example")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAddressRuleTaxFieldLabelResult(dict):
    def __init__(__self__, *,
                 example: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str example: English translation of the label (for reference only - translation is not provided)
        :param builtins.str value: Value
        """
        pulumi.set(__self__, "example", example)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def example(self) -> builtins.str:
        """
        English translation of the label (for reference only - translation is not provided)
        """
        return pulumi.get(self, "example")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAddressRuleTaxValueSetResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: User friendly name
        :param builtins.str value: Value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        User friendly name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetInvoiceBillToAddressResult(dict):
    def __init__(__self__, *,
                 address_line1: builtins.str,
                 address_line2: builtins.str,
                 address_line3: builtins.str,
                 address_line4: builtins.str,
                 city: builtins.str,
                 company_name: builtins.str,
                 contact_name: builtins.str,
                 countries: Sequence['outputs.GetInvoiceBillToAddressCountryResult'],
                 county: builtins.str,
                 postal_code: builtins.str,
                 province: builtins.str,
                 state: builtins.str,
                 street_name: builtins.str,
                 street_number: builtins.str):
        """
        :param builtins.str address_line1: Address line 1
        :param builtins.str address_line2: Address line 2
        :param builtins.str address_line3: Address line 3
        :param builtins.str address_line4: Address line 4
        :param builtins.str city: Name of the city
        :param builtins.str company_name: Name of the customer company
        :param builtins.str contact_name: Name of the contact person
        :param Sequence['GetInvoiceBillToAddressCountryArgs'] countries: Country details model
        :param builtins.str county: County name
        :param builtins.str postal_code: ZIP no
        :param builtins.str province: Name of the province
        :param builtins.str state: Name of the state
        :param builtins.str street_name: Street name
        :param builtins.str street_number: House no
        """
        pulumi.set(__self__, "address_line1", address_line1)
        pulumi.set(__self__, "address_line2", address_line2)
        pulumi.set(__self__, "address_line3", address_line3)
        pulumi.set(__self__, "address_line4", address_line4)
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "company_name", company_name)
        pulumi.set(__self__, "contact_name", contact_name)
        pulumi.set(__self__, "countries", countries)
        pulumi.set(__self__, "county", county)
        pulumi.set(__self__, "postal_code", postal_code)
        pulumi.set(__self__, "province", province)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "street_name", street_name)
        pulumi.set(__self__, "street_number", street_number)

    @property
    @pulumi.getter(name="addressLine1")
    def address_line1(self) -> builtins.str:
        """
        Address line 1
        """
        return pulumi.get(self, "address_line1")

    @property
    @pulumi.getter(name="addressLine2")
    def address_line2(self) -> builtins.str:
        """
        Address line 2
        """
        return pulumi.get(self, "address_line2")

    @property
    @pulumi.getter(name="addressLine3")
    def address_line3(self) -> builtins.str:
        """
        Address line 3
        """
        return pulumi.get(self, "address_line3")

    @property
    @pulumi.getter(name="addressLine4")
    def address_line4(self) -> builtins.str:
        """
        Address line 4
        """
        return pulumi.get(self, "address_line4")

    @property
    @pulumi.getter
    def city(self) -> builtins.str:
        """
        Name of the city
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> builtins.str:
        """
        Name of the customer company
        """
        return pulumi.get(self, "company_name")

    @property
    @pulumi.getter(name="contactName")
    def contact_name(self) -> builtins.str:
        """
        Name of the contact person
        """
        return pulumi.get(self, "contact_name")

    @property
    @pulumi.getter
    def countries(self) -> Sequence['outputs.GetInvoiceBillToAddressCountryResult']:
        """
        Country details model
        """
        return pulumi.get(self, "countries")

    @property
    @pulumi.getter
    def county(self) -> builtins.str:
        """
        County name
        """
        return pulumi.get(self, "county")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> builtins.str:
        """
        ZIP no
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def province(self) -> builtins.str:
        """
        Name of the province
        """
        return pulumi.get(self, "province")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Name of the state
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="streetName")
    def street_name(self) -> builtins.str:
        """
        Street name
        """
        return pulumi.get(self, "street_name")

    @property
    @pulumi.getter(name="streetNumber")
    def street_number(self) -> builtins.str:
        """
        House no
        """
        return pulumi.get(self, "street_number")


@pulumi.output_type
class GetInvoiceBillToAddressCountryResult(dict):
    def __init__(__self__, *,
                 ascii3country_code: builtins.str,
                 country_code: builtins.str,
                 country_id: builtins.float,
                 country_name: builtins.str,
                 language_id: builtins.float):
        """
        :param builtins.str ascii3country_code: Country code in ISO-3166-1 3-letter format
        :param builtins.str country_code: Country code in ISO-3166-1 2-letter format
        :param builtins.float country_id: Indentifier of the country. This is a DB side unique id which was generated when the entity was created in the table
        :param builtins.str country_name: Name of the country
        :param builtins.float language_id: Language identifier
        """
        pulumi.set(__self__, "ascii3country_code", ascii3country_code)
        pulumi.set(__self__, "country_code", country_code)
        pulumi.set(__self__, "country_id", country_id)
        pulumi.set(__self__, "country_name", country_name)
        pulumi.set(__self__, "language_id", language_id)

    @property
    @pulumi.getter(name="ascii3countryCode")
    def ascii3country_code(self) -> builtins.str:
        """
        Country code in ISO-3166-1 3-letter format
        """
        return pulumi.get(self, "ascii3country_code")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> builtins.str:
        """
        Country code in ISO-3166-1 2-letter format
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter(name="countryId")
    def country_id(self) -> builtins.float:
        """
        Indentifier of the country. This is a DB side unique id which was generated when the entity was created in the table
        """
        return pulumi.get(self, "country_id")

    @property
    @pulumi.getter(name="countryName")
    def country_name(self) -> builtins.str:
        """
        Name of the country
        """
        return pulumi.get(self, "country_name")

    @property
    @pulumi.getter(name="languageId")
    def language_id(self) -> builtins.float:
        """
        Language identifier
        """
        return pulumi.get(self, "language_id")


@pulumi.output_type
class GetInvoiceCurrencyResult(dict):
    def __init__(__self__, *,
                 currency_code: builtins.str,
                 currency_symbol: builtins.str,
                 name: builtins.str,
                 round_decimal_point: builtins.float,
                 usd_conversion: builtins.float):
        """
        :param builtins.str currency_code: Currency code
        :param builtins.str currency_symbol: Currency symbol
        :param builtins.str name: Name of the currency
        :param builtins.float round_decimal_point: Round decimal point
        :param builtins.float usd_conversion: USD conversion rate of the currency
        """
        pulumi.set(__self__, "currency_code", currency_code)
        pulumi.set(__self__, "currency_symbol", currency_symbol)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "round_decimal_point", round_decimal_point)
        pulumi.set(__self__, "usd_conversion", usd_conversion)

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> builtins.str:
        """
        Currency code
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter(name="currencySymbol")
    def currency_symbol(self) -> builtins.str:
        """
        Currency symbol
        """
        return pulumi.get(self, "currency_symbol")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the currency
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="roundDecimalPoint")
    def round_decimal_point(self) -> builtins.float:
        """
        Round decimal point
        """
        return pulumi.get(self, "round_decimal_point")

    @property
    @pulumi.getter(name="usdConversion")
    def usd_conversion(self) -> builtins.float:
        """
        USD conversion rate of the currency
        """
        return pulumi.get(self, "usd_conversion")


@pulumi.output_type
class GetInvoiceLastPaymentDetailResult(dict):
    def __init__(__self__, *,
                 account_number: builtins.str,
                 amount_paid: builtins.float,
                 card_type: builtins.str,
                 credit_card_type: builtins.str,
                 echeck_routing: builtins.str,
                 last_digits: builtins.str,
                 name_on_card: builtins.str,
                 paid_by: builtins.str,
                 payment_method: builtins.str,
                 paypal_id: builtins.str,
                 paypal_reference: builtins.str,
                 routing_number: builtins.str,
                 time_expiration: builtins.str,
                 time_paid_on: builtins.str):
        """
        :param builtins.str account_number: Account number of the card owner
        :param builtins.float amount_paid: Amount that paid
        :param builtins.str card_type: Echeck card type
        :param builtins.str credit_card_type: Credit card type
        :param builtins.str echeck_routing: Last four routing digits of the card
        :param builtins.str last_digits: Last four digits of the card
        :param builtins.str name_on_card: Name on the credit card
        :param builtins.str paid_by: example
        :param builtins.str payment_method: Payment method
        :param builtins.str paypal_id: The id (email address) of the paypal payment
        :param builtins.str paypal_reference: paypal payment reference
        :param builtins.str routing_number: Routing number of the echeck card
        :param builtins.str time_expiration: Expired date of the credit card
        :param builtins.str time_paid_on: Paid the invoice on this day
        """
        pulumi.set(__self__, "account_number", account_number)
        pulumi.set(__self__, "amount_paid", amount_paid)
        pulumi.set(__self__, "card_type", card_type)
        pulumi.set(__self__, "credit_card_type", credit_card_type)
        pulumi.set(__self__, "echeck_routing", echeck_routing)
        pulumi.set(__self__, "last_digits", last_digits)
        pulumi.set(__self__, "name_on_card", name_on_card)
        pulumi.set(__self__, "paid_by", paid_by)
        pulumi.set(__self__, "payment_method", payment_method)
        pulumi.set(__self__, "paypal_id", paypal_id)
        pulumi.set(__self__, "paypal_reference", paypal_reference)
        pulumi.set(__self__, "routing_number", routing_number)
        pulumi.set(__self__, "time_expiration", time_expiration)
        pulumi.set(__self__, "time_paid_on", time_paid_on)

    @property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> builtins.str:
        """
        Account number of the card owner
        """
        return pulumi.get(self, "account_number")

    @property
    @pulumi.getter(name="amountPaid")
    def amount_paid(self) -> builtins.float:
        """
        Amount that paid
        """
        return pulumi.get(self, "amount_paid")

    @property
    @pulumi.getter(name="cardType")
    def card_type(self) -> builtins.str:
        """
        Echeck card type
        """
        return pulumi.get(self, "card_type")

    @property
    @pulumi.getter(name="creditCardType")
    def credit_card_type(self) -> builtins.str:
        """
        Credit card type
        """
        return pulumi.get(self, "credit_card_type")

    @property
    @pulumi.getter(name="echeckRouting")
    def echeck_routing(self) -> builtins.str:
        """
        Last four routing digits of the card
        """
        return pulumi.get(self, "echeck_routing")

    @property
    @pulumi.getter(name="lastDigits")
    def last_digits(self) -> builtins.str:
        """
        Last four digits of the card
        """
        return pulumi.get(self, "last_digits")

    @property
    @pulumi.getter(name="nameOnCard")
    def name_on_card(self) -> builtins.str:
        """
        Name on the credit card
        """
        return pulumi.get(self, "name_on_card")

    @property
    @pulumi.getter(name="paidBy")
    def paid_by(self) -> builtins.str:
        """
        example
        """
        return pulumi.get(self, "paid_by")

    @property
    @pulumi.getter(name="paymentMethod")
    def payment_method(self) -> builtins.str:
        """
        Payment method
        """
        return pulumi.get(self, "payment_method")

    @property
    @pulumi.getter(name="paypalId")
    def paypal_id(self) -> builtins.str:
        """
        The id (email address) of the paypal payment
        """
        return pulumi.get(self, "paypal_id")

    @property
    @pulumi.getter(name="paypalReference")
    def paypal_reference(self) -> builtins.str:
        """
        paypal payment reference
        """
        return pulumi.get(self, "paypal_reference")

    @property
    @pulumi.getter(name="routingNumber")
    def routing_number(self) -> builtins.str:
        """
        Routing number of the echeck card
        """
        return pulumi.get(self, "routing_number")

    @property
    @pulumi.getter(name="timeExpiration")
    def time_expiration(self) -> builtins.str:
        """
        Expired date of the credit card
        """
        return pulumi.get(self, "time_expiration")

    @property
    @pulumi.getter(name="timePaidOn")
    def time_paid_on(self) -> builtins.str:
        """
        Paid the invoice on this day
        """
        return pulumi.get(self, "time_paid_on")


@pulumi.output_type
class GetInvoicesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Name of the currency
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the currency
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetInvoicesInvoiceCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetInvoicesInvoiceCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetInvoicesInvoiceCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetInvoicesInvoiceCollectionItemResult(dict):
    def __init__(__self__, *,
                 bill_to_addresses: Sequence['outputs.GetInvoicesInvoiceCollectionItemBillToAddressResult'],
                 currencies: Sequence['outputs.GetInvoicesInvoiceCollectionItemCurrencyResult'],
                 internal_invoice_id: builtins.str,
                 invoice_amount: builtins.float,
                 invoice_amount_adjusted: builtins.float,
                 invoice_amount_applied: builtins.float,
                 invoice_amount_credited: builtins.float,
                 invoice_amount_due: builtins.float,
                 invoice_amount_in_dispute: builtins.float,
                 invoice_id: builtins.str,
                 invoice_number: builtins.str,
                 invoice_po_number: builtins.str,
                 invoice_ref_number: builtins.str,
                 invoice_status: builtins.str,
                 invoice_type: builtins.str,
                 is_credit_card_payable: builtins.bool,
                 is_display_download_pdf: builtins.bool,
                 is_display_view_pdf: builtins.bool,
                 is_paid: builtins.bool,
                 is_payable: builtins.bool,
                 is_payment_failed: builtins.bool,
                 is_pdf_email_available: builtins.bool,
                 last_payment_details: Sequence['outputs.GetInvoicesInvoiceCollectionItemLastPaymentDetailResult'],
                 party_name: builtins.str,
                 payment_terms: builtins.str,
                 preferred_email: builtins.str,
                 subscription_ids: Sequence[builtins.str],
                 tax: builtins.float,
                 time_invoice: builtins.str,
                 time_invoice_due: builtins.str):
        """
        :param Sequence['GetInvoicesInvoiceCollectionItemBillToAddressArgs'] bill_to_addresses: Address details model
        :param Sequence['GetInvoicesInvoiceCollectionItemCurrencyArgs'] currencies: Currency details model
        :param builtins.str internal_invoice_id: Transaction identifier
        :param builtins.float invoice_amount: Total amount of invoice
        :param builtins.float invoice_amount_adjusted: Invoice amount adjust
        :param builtins.float invoice_amount_applied: Invoice amount applied
        :param builtins.float invoice_amount_credited: Invoice amount credit
        :param builtins.float invoice_amount_due: Balance of invoice
        :param builtins.str invoice_id: The invoice query param (not unique).
        :param builtins.str invoice_number: Invoice external reference
        :param builtins.str invoice_po_number: Invoice PO number
        :param builtins.str invoice_ref_number: Invoice reference number
        :param builtins.str invoice_status: Invoice status
        :param builtins.str invoice_type: Type of invoice
        :param builtins.bool is_credit_card_payable: Is credit card payment eligible
        :param builtins.bool is_display_download_pdf: Is pdf download access allowed
        :param builtins.bool is_payable: Whether invoice can be payed
        :param builtins.bool is_pdf_email_available: Is emailing pdf allowed
        :param Sequence['GetInvoicesInvoiceCollectionItemLastPaymentDetailArgs'] last_payment_details: Payment related details
        :param builtins.str payment_terms: Payment terms
        :param builtins.str preferred_email: Preferred Email on the invoice
        :param Sequence[builtins.str] subscription_ids: List of subscription identifiers
        :param builtins.float tax: Tax of invoice amount
        :param builtins.str time_invoice: Date of invoice
        :param builtins.str time_invoice_due: Due date of invoice
        """
        pulumi.set(__self__, "bill_to_addresses", bill_to_addresses)
        pulumi.set(__self__, "currencies", currencies)
        pulumi.set(__self__, "internal_invoice_id", internal_invoice_id)
        pulumi.set(__self__, "invoice_amount", invoice_amount)
        pulumi.set(__self__, "invoice_amount_adjusted", invoice_amount_adjusted)
        pulumi.set(__self__, "invoice_amount_applied", invoice_amount_applied)
        pulumi.set(__self__, "invoice_amount_credited", invoice_amount_credited)
        pulumi.set(__self__, "invoice_amount_due", invoice_amount_due)
        pulumi.set(__self__, "invoice_amount_in_dispute", invoice_amount_in_dispute)
        pulumi.set(__self__, "invoice_id", invoice_id)
        pulumi.set(__self__, "invoice_number", invoice_number)
        pulumi.set(__self__, "invoice_po_number", invoice_po_number)
        pulumi.set(__self__, "invoice_ref_number", invoice_ref_number)
        pulumi.set(__self__, "invoice_status", invoice_status)
        pulumi.set(__self__, "invoice_type", invoice_type)
        pulumi.set(__self__, "is_credit_card_payable", is_credit_card_payable)
        pulumi.set(__self__, "is_display_download_pdf", is_display_download_pdf)
        pulumi.set(__self__, "is_display_view_pdf", is_display_view_pdf)
        pulumi.set(__self__, "is_paid", is_paid)
        pulumi.set(__self__, "is_payable", is_payable)
        pulumi.set(__self__, "is_payment_failed", is_payment_failed)
        pulumi.set(__self__, "is_pdf_email_available", is_pdf_email_available)
        pulumi.set(__self__, "last_payment_details", last_payment_details)
        pulumi.set(__self__, "party_name", party_name)
        pulumi.set(__self__, "payment_terms", payment_terms)
        pulumi.set(__self__, "preferred_email", preferred_email)
        pulumi.set(__self__, "subscription_ids", subscription_ids)
        pulumi.set(__self__, "tax", tax)
        pulumi.set(__self__, "time_invoice", time_invoice)
        pulumi.set(__self__, "time_invoice_due", time_invoice_due)

    @property
    @pulumi.getter(name="billToAddresses")
    def bill_to_addresses(self) -> Sequence['outputs.GetInvoicesInvoiceCollectionItemBillToAddressResult']:
        """
        Address details model
        """
        return pulumi.get(self, "bill_to_addresses")

    @property
    @pulumi.getter
    def currencies(self) -> Sequence['outputs.GetInvoicesInvoiceCollectionItemCurrencyResult']:
        """
        Currency details model
        """
        return pulumi.get(self, "currencies")

    @property
    @pulumi.getter(name="internalInvoiceId")
    def internal_invoice_id(self) -> builtins.str:
        """
        Transaction identifier
        """
        return pulumi.get(self, "internal_invoice_id")

    @property
    @pulumi.getter(name="invoiceAmount")
    def invoice_amount(self) -> builtins.float:
        """
        Total amount of invoice
        """
        return pulumi.get(self, "invoice_amount")

    @property
    @pulumi.getter(name="invoiceAmountAdjusted")
    def invoice_amount_adjusted(self) -> builtins.float:
        """
        Invoice amount adjust
        """
        return pulumi.get(self, "invoice_amount_adjusted")

    @property
    @pulumi.getter(name="invoiceAmountApplied")
    def invoice_amount_applied(self) -> builtins.float:
        """
        Invoice amount applied
        """
        return pulumi.get(self, "invoice_amount_applied")

    @property
    @pulumi.getter(name="invoiceAmountCredited")
    def invoice_amount_credited(self) -> builtins.float:
        """
        Invoice amount credit
        """
        return pulumi.get(self, "invoice_amount_credited")

    @property
    @pulumi.getter(name="invoiceAmountDue")
    def invoice_amount_due(self) -> builtins.float:
        """
        Balance of invoice
        """
        return pulumi.get(self, "invoice_amount_due")

    @property
    @pulumi.getter(name="invoiceAmountInDispute")
    def invoice_amount_in_dispute(self) -> builtins.float:
        return pulumi.get(self, "invoice_amount_in_dispute")

    @property
    @pulumi.getter(name="invoiceId")
    def invoice_id(self) -> builtins.str:
        """
        The invoice query param (not unique).
        """
        return pulumi.get(self, "invoice_id")

    @property
    @pulumi.getter(name="invoiceNumber")
    def invoice_number(self) -> builtins.str:
        """
        Invoice external reference
        """
        return pulumi.get(self, "invoice_number")

    @property
    @pulumi.getter(name="invoicePoNumber")
    def invoice_po_number(self) -> builtins.str:
        """
        Invoice PO number
        """
        return pulumi.get(self, "invoice_po_number")

    @property
    @pulumi.getter(name="invoiceRefNumber")
    def invoice_ref_number(self) -> builtins.str:
        """
        Invoice reference number
        """
        return pulumi.get(self, "invoice_ref_number")

    @property
    @pulumi.getter(name="invoiceStatus")
    def invoice_status(self) -> builtins.str:
        """
        Invoice status
        """
        return pulumi.get(self, "invoice_status")

    @property
    @pulumi.getter(name="invoiceType")
    def invoice_type(self) -> builtins.str:
        """
        Type of invoice
        """
        return pulumi.get(self, "invoice_type")

    @property
    @pulumi.getter(name="isCreditCardPayable")
    def is_credit_card_payable(self) -> builtins.bool:
        """
        Is credit card payment eligible
        """
        return pulumi.get(self, "is_credit_card_payable")

    @property
    @pulumi.getter(name="isDisplayDownloadPdf")
    def is_display_download_pdf(self) -> builtins.bool:
        """
        Is pdf download access allowed
        """
        return pulumi.get(self, "is_display_download_pdf")

    @property
    @pulumi.getter(name="isDisplayViewPdf")
    def is_display_view_pdf(self) -> builtins.bool:
        return pulumi.get(self, "is_display_view_pdf")

    @property
    @pulumi.getter(name="isPaid")
    def is_paid(self) -> builtins.bool:
        return pulumi.get(self, "is_paid")

    @property
    @pulumi.getter(name="isPayable")
    def is_payable(self) -> builtins.bool:
        """
        Whether invoice can be payed
        """
        return pulumi.get(self, "is_payable")

    @property
    @pulumi.getter(name="isPaymentFailed")
    def is_payment_failed(self) -> builtins.bool:
        return pulumi.get(self, "is_payment_failed")

    @property
    @pulumi.getter(name="isPdfEmailAvailable")
    def is_pdf_email_available(self) -> builtins.bool:
        """
        Is emailing pdf allowed
        """
        return pulumi.get(self, "is_pdf_email_available")

    @property
    @pulumi.getter(name="lastPaymentDetails")
    def last_payment_details(self) -> Sequence['outputs.GetInvoicesInvoiceCollectionItemLastPaymentDetailResult']:
        """
        Payment related details
        """
        return pulumi.get(self, "last_payment_details")

    @property
    @pulumi.getter(name="partyName")
    def party_name(self) -> builtins.str:
        return pulumi.get(self, "party_name")

    @property
    @pulumi.getter(name="paymentTerms")
    def payment_terms(self) -> builtins.str:
        """
        Payment terms
        """
        return pulumi.get(self, "payment_terms")

    @property
    @pulumi.getter(name="preferredEmail")
    def preferred_email(self) -> builtins.str:
        """
        Preferred Email on the invoice
        """
        return pulumi.get(self, "preferred_email")

    @property
    @pulumi.getter(name="subscriptionIds")
    def subscription_ids(self) -> Sequence[builtins.str]:
        """
        List of subscription identifiers
        """
        return pulumi.get(self, "subscription_ids")

    @property
    @pulumi.getter
    def tax(self) -> builtins.float:
        """
        Tax of invoice amount
        """
        return pulumi.get(self, "tax")

    @property
    @pulumi.getter(name="timeInvoice")
    def time_invoice(self) -> builtins.str:
        """
        Date of invoice
        """
        return pulumi.get(self, "time_invoice")

    @property
    @pulumi.getter(name="timeInvoiceDue")
    def time_invoice_due(self) -> builtins.str:
        """
        Due date of invoice
        """
        return pulumi.get(self, "time_invoice_due")


@pulumi.output_type
class GetInvoicesInvoiceCollectionItemBillToAddressResult(dict):
    def __init__(__self__, *,
                 address_line1: builtins.str,
                 address_line2: builtins.str,
                 address_line3: builtins.str,
                 address_line4: builtins.str,
                 city: builtins.str,
                 company_name: builtins.str,
                 contact_name: builtins.str,
                 countries: Sequence['outputs.GetInvoicesInvoiceCollectionItemBillToAddressCountryResult'],
                 county: builtins.str,
                 postal_code: builtins.str,
                 province: builtins.str,
                 state: builtins.str,
                 street_name: builtins.str,
                 street_number: builtins.str):
        """
        :param builtins.str address_line1: Address line 1
        :param builtins.str address_line2: Address line 2
        :param builtins.str address_line3: Address line 3
        :param builtins.str address_line4: Address line 4
        :param builtins.str city: Name of the city
        :param builtins.str company_name: Name of the customer company
        :param builtins.str contact_name: Name of the contact person
        :param Sequence['GetInvoicesInvoiceCollectionItemBillToAddressCountryArgs'] countries: Country details model
        :param builtins.str county: County name
        :param builtins.str postal_code: ZIP no
        :param builtins.str province: Name of the province
        :param builtins.str state: Name of the state
        :param builtins.str street_name: Street name
        :param builtins.str street_number: House no
        """
        pulumi.set(__self__, "address_line1", address_line1)
        pulumi.set(__self__, "address_line2", address_line2)
        pulumi.set(__self__, "address_line3", address_line3)
        pulumi.set(__self__, "address_line4", address_line4)
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "company_name", company_name)
        pulumi.set(__self__, "contact_name", contact_name)
        pulumi.set(__self__, "countries", countries)
        pulumi.set(__self__, "county", county)
        pulumi.set(__self__, "postal_code", postal_code)
        pulumi.set(__self__, "province", province)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "street_name", street_name)
        pulumi.set(__self__, "street_number", street_number)

    @property
    @pulumi.getter(name="addressLine1")
    def address_line1(self) -> builtins.str:
        """
        Address line 1
        """
        return pulumi.get(self, "address_line1")

    @property
    @pulumi.getter(name="addressLine2")
    def address_line2(self) -> builtins.str:
        """
        Address line 2
        """
        return pulumi.get(self, "address_line2")

    @property
    @pulumi.getter(name="addressLine3")
    def address_line3(self) -> builtins.str:
        """
        Address line 3
        """
        return pulumi.get(self, "address_line3")

    @property
    @pulumi.getter(name="addressLine4")
    def address_line4(self) -> builtins.str:
        """
        Address line 4
        """
        return pulumi.get(self, "address_line4")

    @property
    @pulumi.getter
    def city(self) -> builtins.str:
        """
        Name of the city
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> builtins.str:
        """
        Name of the customer company
        """
        return pulumi.get(self, "company_name")

    @property
    @pulumi.getter(name="contactName")
    def contact_name(self) -> builtins.str:
        """
        Name of the contact person
        """
        return pulumi.get(self, "contact_name")

    @property
    @pulumi.getter
    def countries(self) -> Sequence['outputs.GetInvoicesInvoiceCollectionItemBillToAddressCountryResult']:
        """
        Country details model
        """
        return pulumi.get(self, "countries")

    @property
    @pulumi.getter
    def county(self) -> builtins.str:
        """
        County name
        """
        return pulumi.get(self, "county")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> builtins.str:
        """
        ZIP no
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def province(self) -> builtins.str:
        """
        Name of the province
        """
        return pulumi.get(self, "province")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Name of the state
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="streetName")
    def street_name(self) -> builtins.str:
        """
        Street name
        """
        return pulumi.get(self, "street_name")

    @property
    @pulumi.getter(name="streetNumber")
    def street_number(self) -> builtins.str:
        """
        House no
        """
        return pulumi.get(self, "street_number")


@pulumi.output_type
class GetInvoicesInvoiceCollectionItemBillToAddressCountryResult(dict):
    def __init__(__self__, *,
                 ascii3country_code: builtins.str,
                 country_code: builtins.str,
                 country_id: builtins.float,
                 country_name: builtins.str,
                 language_id: builtins.float):
        """
        :param builtins.str ascii3country_code: Country code in ISO-3166-1 3-letter format
        :param builtins.str country_code: Country code in ISO-3166-1 2-letter format
        :param builtins.float country_id: Indentifier of the country. This is a DB side unique id which was generated when the entity was created in the table
        :param builtins.str country_name: Name of the country
        :param builtins.float language_id: Language identifier
        """
        pulumi.set(__self__, "ascii3country_code", ascii3country_code)
        pulumi.set(__self__, "country_code", country_code)
        pulumi.set(__self__, "country_id", country_id)
        pulumi.set(__self__, "country_name", country_name)
        pulumi.set(__self__, "language_id", language_id)

    @property
    @pulumi.getter(name="ascii3countryCode")
    def ascii3country_code(self) -> builtins.str:
        """
        Country code in ISO-3166-1 3-letter format
        """
        return pulumi.get(self, "ascii3country_code")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> builtins.str:
        """
        Country code in ISO-3166-1 2-letter format
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter(name="countryId")
    def country_id(self) -> builtins.float:
        """
        Indentifier of the country. This is a DB side unique id which was generated when the entity was created in the table
        """
        return pulumi.get(self, "country_id")

    @property
    @pulumi.getter(name="countryName")
    def country_name(self) -> builtins.str:
        """
        Name of the country
        """
        return pulumi.get(self, "country_name")

    @property
    @pulumi.getter(name="languageId")
    def language_id(self) -> builtins.float:
        """
        Language identifier
        """
        return pulumi.get(self, "language_id")


@pulumi.output_type
class GetInvoicesInvoiceCollectionItemCurrencyResult(dict):
    def __init__(__self__, *,
                 currency_code: builtins.str,
                 currency_symbol: builtins.str,
                 name: builtins.str,
                 round_decimal_point: builtins.float,
                 usd_conversion: builtins.float):
        """
        :param builtins.str currency_code: Currency code
        :param builtins.str currency_symbol: Currency symbol
        :param builtins.str name: Name of the currency
        :param builtins.float round_decimal_point: Round decimal point
        :param builtins.float usd_conversion: USD conversion rate of the currency
        """
        pulumi.set(__self__, "currency_code", currency_code)
        pulumi.set(__self__, "currency_symbol", currency_symbol)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "round_decimal_point", round_decimal_point)
        pulumi.set(__self__, "usd_conversion", usd_conversion)

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> builtins.str:
        """
        Currency code
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter(name="currencySymbol")
    def currency_symbol(self) -> builtins.str:
        """
        Currency symbol
        """
        return pulumi.get(self, "currency_symbol")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the currency
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="roundDecimalPoint")
    def round_decimal_point(self) -> builtins.float:
        """
        Round decimal point
        """
        return pulumi.get(self, "round_decimal_point")

    @property
    @pulumi.getter(name="usdConversion")
    def usd_conversion(self) -> builtins.float:
        """
        USD conversion rate of the currency
        """
        return pulumi.get(self, "usd_conversion")


@pulumi.output_type
class GetInvoicesInvoiceCollectionItemLastPaymentDetailResult(dict):
    def __init__(__self__, *,
                 account_number: builtins.str,
                 amount_paid: builtins.float,
                 card_type: builtins.str,
                 credit_card_type: builtins.str,
                 echeck_routing: builtins.str,
                 last_digits: builtins.str,
                 name_on_card: builtins.str,
                 paid_by: builtins.str,
                 payment_method: builtins.str,
                 paypal_id: builtins.str,
                 paypal_reference: builtins.str,
                 routing_number: builtins.str,
                 time_expiration: builtins.str,
                 time_paid_on: builtins.str):
        """
        :param builtins.str account_number: Account number of the card owner
        :param builtins.float amount_paid: Amount that paid
        :param builtins.str card_type: Echeck card type
        :param builtins.str credit_card_type: Credit card type
        :param builtins.str echeck_routing: Last four routing digits of the card
        :param builtins.str last_digits: Last four digits of the card
        :param builtins.str name_on_card: Name on the credit card
        :param builtins.str paid_by: example
        :param builtins.str payment_method: Payment method
        :param builtins.str paypal_id: The id (email address) of the paypal payment
        :param builtins.str paypal_reference: paypal payment reference
        :param builtins.str routing_number: Routing number of the echeck card
        :param builtins.str time_expiration: Expired date of the credit card
        :param builtins.str time_paid_on: Paid the invoice on this day
        """
        pulumi.set(__self__, "account_number", account_number)
        pulumi.set(__self__, "amount_paid", amount_paid)
        pulumi.set(__self__, "card_type", card_type)
        pulumi.set(__self__, "credit_card_type", credit_card_type)
        pulumi.set(__self__, "echeck_routing", echeck_routing)
        pulumi.set(__self__, "last_digits", last_digits)
        pulumi.set(__self__, "name_on_card", name_on_card)
        pulumi.set(__self__, "paid_by", paid_by)
        pulumi.set(__self__, "payment_method", payment_method)
        pulumi.set(__self__, "paypal_id", paypal_id)
        pulumi.set(__self__, "paypal_reference", paypal_reference)
        pulumi.set(__self__, "routing_number", routing_number)
        pulumi.set(__self__, "time_expiration", time_expiration)
        pulumi.set(__self__, "time_paid_on", time_paid_on)

    @property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> builtins.str:
        """
        Account number of the card owner
        """
        return pulumi.get(self, "account_number")

    @property
    @pulumi.getter(name="amountPaid")
    def amount_paid(self) -> builtins.float:
        """
        Amount that paid
        """
        return pulumi.get(self, "amount_paid")

    @property
    @pulumi.getter(name="cardType")
    def card_type(self) -> builtins.str:
        """
        Echeck card type
        """
        return pulumi.get(self, "card_type")

    @property
    @pulumi.getter(name="creditCardType")
    def credit_card_type(self) -> builtins.str:
        """
        Credit card type
        """
        return pulumi.get(self, "credit_card_type")

    @property
    @pulumi.getter(name="echeckRouting")
    def echeck_routing(self) -> builtins.str:
        """
        Last four routing digits of the card
        """
        return pulumi.get(self, "echeck_routing")

    @property
    @pulumi.getter(name="lastDigits")
    def last_digits(self) -> builtins.str:
        """
        Last four digits of the card
        """
        return pulumi.get(self, "last_digits")

    @property
    @pulumi.getter(name="nameOnCard")
    def name_on_card(self) -> builtins.str:
        """
        Name on the credit card
        """
        return pulumi.get(self, "name_on_card")

    @property
    @pulumi.getter(name="paidBy")
    def paid_by(self) -> builtins.str:
        """
        example
        """
        return pulumi.get(self, "paid_by")

    @property
    @pulumi.getter(name="paymentMethod")
    def payment_method(self) -> builtins.str:
        """
        Payment method
        """
        return pulumi.get(self, "payment_method")

    @property
    @pulumi.getter(name="paypalId")
    def paypal_id(self) -> builtins.str:
        """
        The id (email address) of the paypal payment
        """
        return pulumi.get(self, "paypal_id")

    @property
    @pulumi.getter(name="paypalReference")
    def paypal_reference(self) -> builtins.str:
        """
        paypal payment reference
        """
        return pulumi.get(self, "paypal_reference")

    @property
    @pulumi.getter(name="routingNumber")
    def routing_number(self) -> builtins.str:
        """
        Routing number of the echeck card
        """
        return pulumi.get(self, "routing_number")

    @property
    @pulumi.getter(name="timeExpiration")
    def time_expiration(self) -> builtins.str:
        """
        Expired date of the credit card
        """
        return pulumi.get(self, "time_expiration")

    @property
    @pulumi.getter(name="timePaidOn")
    def time_paid_on(self) -> builtins.str:
        """
        Paid the invoice on this day
        """
        return pulumi.get(self, "time_paid_on")


@pulumi.output_type
class GetInvoicesInvoiceLineItemResult(dict):
    def __init__(__self__, *,
                 currencies: Sequence['outputs.GetInvoicesInvoiceLineItemCurrencyResult'],
                 net_unit_price: builtins.float,
                 order_no: builtins.str,
                 part_number: builtins.str,
                 product: builtins.str,
                 quantity: builtins.float,
                 time_end: builtins.str,
                 time_start: builtins.str,
                 total_price: builtins.float):
        """
        :param Sequence['GetInvoicesInvoiceLineItemCurrencyArgs'] currencies: Currency details model
        :param builtins.float net_unit_price: Unit price of the ordered product
        :param builtins.str order_no: Product of the item
        :param builtins.str part_number: Part number
        :param builtins.str product: Product of the item
        :param builtins.float quantity: Quantity of the ordered product
        :param builtins.str time_end: End date
        :param builtins.str time_start: Start date
        :param builtins.float total_price: Total price of the ordered product (Net unit price x quantity)
        """
        pulumi.set(__self__, "currencies", currencies)
        pulumi.set(__self__, "net_unit_price", net_unit_price)
        pulumi.set(__self__, "order_no", order_no)
        pulumi.set(__self__, "part_number", part_number)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "quantity", quantity)
        pulumi.set(__self__, "time_end", time_end)
        pulumi.set(__self__, "time_start", time_start)
        pulumi.set(__self__, "total_price", total_price)

    @property
    @pulumi.getter
    def currencies(self) -> Sequence['outputs.GetInvoicesInvoiceLineItemCurrencyResult']:
        """
        Currency details model
        """
        return pulumi.get(self, "currencies")

    @property
    @pulumi.getter(name="netUnitPrice")
    def net_unit_price(self) -> builtins.float:
        """
        Unit price of the ordered product
        """
        return pulumi.get(self, "net_unit_price")

    @property
    @pulumi.getter(name="orderNo")
    def order_no(self) -> builtins.str:
        """
        Product of the item
        """
        return pulumi.get(self, "order_no")

    @property
    @pulumi.getter(name="partNumber")
    def part_number(self) -> builtins.str:
        """
        Part number
        """
        return pulumi.get(self, "part_number")

    @property
    @pulumi.getter
    def product(self) -> builtins.str:
        """
        Product of the item
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter
    def quantity(self) -> builtins.float:
        """
        Quantity of the ordered product
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> builtins.str:
        """
        End date
        """
        return pulumi.get(self, "time_end")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> builtins.str:
        """
        Start date
        """
        return pulumi.get(self, "time_start")

    @property
    @pulumi.getter(name="totalPrice")
    def total_price(self) -> builtins.float:
        """
        Total price of the ordered product (Net unit price x quantity)
        """
        return pulumi.get(self, "total_price")


@pulumi.output_type
class GetInvoicesInvoiceLineItemCurrencyResult(dict):
    def __init__(__self__, *,
                 currency_code: builtins.str,
                 currency_symbol: builtins.str,
                 name: builtins.str,
                 round_decimal_point: builtins.float,
                 usd_conversion: builtins.float):
        """
        :param builtins.str currency_code: Currency code
        :param builtins.str currency_symbol: Currency symbol
        :param builtins.str name: Name of the currency
        :param builtins.float round_decimal_point: Round decimal point
        :param builtins.float usd_conversion: USD conversion rate of the currency
        """
        pulumi.set(__self__, "currency_code", currency_code)
        pulumi.set(__self__, "currency_symbol", currency_symbol)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "round_decimal_point", round_decimal_point)
        pulumi.set(__self__, "usd_conversion", usd_conversion)

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> builtins.str:
        """
        Currency code
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter(name="currencySymbol")
    def currency_symbol(self) -> builtins.str:
        """
        Currency symbol
        """
        return pulumi.get(self, "currency_symbol")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the currency
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="roundDecimalPoint")
    def round_decimal_point(self) -> builtins.float:
        """
        Round decimal point
        """
        return pulumi.get(self, "round_decimal_point")

    @property
    @pulumi.getter(name="usdConversion")
    def usd_conversion(self) -> builtins.float:
        """
        USD conversion rate of the currency
        """
        return pulumi.get(self, "usd_conversion")


@pulumi.output_type
class GetInvoicesInvoiceLinesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Name of the currency
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the currency
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetInvoicesInvoiceLinesInvoiceLineCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetInvoicesInvoiceLinesInvoiceLineCollectionItemResult']):
        """
        :param Sequence['GetInvoicesInvoiceLinesInvoiceLineCollectionItemArgs'] items: Invoice line list elements
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetInvoicesInvoiceLinesInvoiceLineCollectionItemResult']:
        """
        Invoice line list elements
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetInvoicesInvoiceLinesInvoiceLineCollectionItemResult(dict):
    def __init__(__self__, *,
                 currencies: Sequence['outputs.GetInvoicesInvoiceLinesInvoiceLineCollectionItemCurrencyResult'],
                 net_unit_price: builtins.float,
                 order_no: builtins.str,
                 part_number: builtins.str,
                 product: builtins.str,
                 quantity: builtins.float,
                 time_end: builtins.str,
                 time_start: builtins.str,
                 total_price: builtins.float):
        """
        :param Sequence['GetInvoicesInvoiceLinesInvoiceLineCollectionItemCurrencyArgs'] currencies: Currency details model
        :param builtins.float net_unit_price: Unit price of the ordered product
        :param builtins.str order_no: Product of the item
        :param builtins.str part_number: Part number
        :param builtins.str product: Product of the item
        :param builtins.float quantity: Quantity of the ordered product
        :param builtins.str time_end: End date
        :param builtins.str time_start: Start date
        :param builtins.float total_price: Total price of the ordered product (Net unit price x quantity)
        """
        pulumi.set(__self__, "currencies", currencies)
        pulumi.set(__self__, "net_unit_price", net_unit_price)
        pulumi.set(__self__, "order_no", order_no)
        pulumi.set(__self__, "part_number", part_number)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "quantity", quantity)
        pulumi.set(__self__, "time_end", time_end)
        pulumi.set(__self__, "time_start", time_start)
        pulumi.set(__self__, "total_price", total_price)

    @property
    @pulumi.getter
    def currencies(self) -> Sequence['outputs.GetInvoicesInvoiceLinesInvoiceLineCollectionItemCurrencyResult']:
        """
        Currency details model
        """
        return pulumi.get(self, "currencies")

    @property
    @pulumi.getter(name="netUnitPrice")
    def net_unit_price(self) -> builtins.float:
        """
        Unit price of the ordered product
        """
        return pulumi.get(self, "net_unit_price")

    @property
    @pulumi.getter(name="orderNo")
    def order_no(self) -> builtins.str:
        """
        Product of the item
        """
        return pulumi.get(self, "order_no")

    @property
    @pulumi.getter(name="partNumber")
    def part_number(self) -> builtins.str:
        """
        Part number
        """
        return pulumi.get(self, "part_number")

    @property
    @pulumi.getter
    def product(self) -> builtins.str:
        """
        Product of the item
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter
    def quantity(self) -> builtins.float:
        """
        Quantity of the ordered product
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> builtins.str:
        """
        End date
        """
        return pulumi.get(self, "time_end")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> builtins.str:
        """
        Start date
        """
        return pulumi.get(self, "time_start")

    @property
    @pulumi.getter(name="totalPrice")
    def total_price(self) -> builtins.float:
        """
        Total price of the ordered product (Net unit price x quantity)
        """
        return pulumi.get(self, "total_price")


@pulumi.output_type
class GetInvoicesInvoiceLinesInvoiceLineCollectionItemCurrencyResult(dict):
    def __init__(__self__, *,
                 currency_code: builtins.str,
                 currency_symbol: builtins.str,
                 name: builtins.str,
                 round_decimal_point: builtins.float,
                 usd_conversion: builtins.float):
        """
        :param builtins.str currency_code: Currency code
        :param builtins.str currency_symbol: Currency symbol
        :param builtins.str name: Name of the currency
        :param builtins.float round_decimal_point: Round decimal point
        :param builtins.float usd_conversion: USD conversion rate of the currency
        """
        pulumi.set(__self__, "currency_code", currency_code)
        pulumi.set(__self__, "currency_symbol", currency_symbol)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "round_decimal_point", round_decimal_point)
        pulumi.set(__self__, "usd_conversion", usd_conversion)

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> builtins.str:
        """
        Currency code
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter(name="currencySymbol")
    def currency_symbol(self) -> builtins.str:
        """
        Currency symbol
        """
        return pulumi.get(self, "currency_symbol")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the currency
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="roundDecimalPoint")
    def round_decimal_point(self) -> builtins.float:
        """
        Round decimal point
        """
        return pulumi.get(self, "round_decimal_point")

    @property
    @pulumi.getter(name="usdConversion")
    def usd_conversion(self) -> builtins.float:
        """
        USD conversion rate of the currency
        """
        return pulumi.get(self, "usd_conversion")


@pulumi.output_type
class GetSubscriptionBillingAddressResult(dict):
    def __init__(__self__, *,
                 address_key: builtins.str,
                 city: builtins.str,
                 company_name: builtins.str,
                 contributor_class: builtins.str,
                 country: builtins.str,
                 county: builtins.str,
                 department_name: builtins.str,
                 email_address: builtins.str,
                 first_name: builtins.str,
                 internal_number: builtins.str,
                 job_title: builtins.str,
                 last_name: builtins.str,
                 line1: builtins.str,
                 line2: builtins.str,
                 line3: builtins.str,
                 line4: builtins.str,
                 middle_name: builtins.str,
                 municipal_inscription: builtins.str,
                 phone_country_code: builtins.str,
                 phone_number: builtins.str,
                 postal_code: builtins.str,
                 province: builtins.str,
                 state: builtins.str,
                 state_inscription: builtins.str,
                 street_name: builtins.str,
                 street_number: builtins.str):
        """
        :param builtins.str address_key: Address identifier.
        :param builtins.str city: Name of the city.
        :param builtins.str company_name: Name of the customer company.
        :param builtins.str contributor_class: Contributor class of the customer company.
        :param builtins.str country: Country of the address.
        :param builtins.str county: County of the address.
        :param builtins.str department_name: Department name of the customer company.
        :param builtins.str email_address: The email address of the paypal user.
        :param builtins.str first_name: First name of the paypal user.
        :param builtins.str internal_number: Internal number of the customer company.
        :param builtins.str job_title: Job title of the contact person.
        :param builtins.str last_name: Last name of the paypal user.
        :param builtins.str line1: Address line 1.
        :param builtins.str line2: Address line 2.
        :param builtins.str line3: Address line 3.
        :param builtins.str line4: Address line 4.
        :param builtins.str middle_name: Middle name of the contact person.
        :param builtins.str municipal_inscription: Municipal Inscription.
        :param builtins.str phone_country_code: Phone country code of the contact person.
        :param builtins.str phone_number: Phone number of the contact person.
        :param builtins.str postal_code: Post code of the address.
        :param builtins.str province: Province of the address.
        :param builtins.str state: State of the address.
        :param builtins.str state_inscription: State Inscription.
        :param builtins.str street_name: Street name of the address.
        :param builtins.str street_number: Street number of the address.
        """
        pulumi.set(__self__, "address_key", address_key)
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "company_name", company_name)
        pulumi.set(__self__, "contributor_class", contributor_class)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "county", county)
        pulumi.set(__self__, "department_name", department_name)
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "internal_number", internal_number)
        pulumi.set(__self__, "job_title", job_title)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "line1", line1)
        pulumi.set(__self__, "line2", line2)
        pulumi.set(__self__, "line3", line3)
        pulumi.set(__self__, "line4", line4)
        pulumi.set(__self__, "middle_name", middle_name)
        pulumi.set(__self__, "municipal_inscription", municipal_inscription)
        pulumi.set(__self__, "phone_country_code", phone_country_code)
        pulumi.set(__self__, "phone_number", phone_number)
        pulumi.set(__self__, "postal_code", postal_code)
        pulumi.set(__self__, "province", province)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_inscription", state_inscription)
        pulumi.set(__self__, "street_name", street_name)
        pulumi.set(__self__, "street_number", street_number)

    @property
    @pulumi.getter(name="addressKey")
    def address_key(self) -> builtins.str:
        """
        Address identifier.
        """
        return pulumi.get(self, "address_key")

    @property
    @pulumi.getter
    def city(self) -> builtins.str:
        """
        Name of the city.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> builtins.str:
        """
        Name of the customer company.
        """
        return pulumi.get(self, "company_name")

    @property
    @pulumi.getter(name="contributorClass")
    def contributor_class(self) -> builtins.str:
        """
        Contributor class of the customer company.
        """
        return pulumi.get(self, "contributor_class")

    @property
    @pulumi.getter
    def country(self) -> builtins.str:
        """
        Country of the address.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def county(self) -> builtins.str:
        """
        County of the address.
        """
        return pulumi.get(self, "county")

    @property
    @pulumi.getter(name="departmentName")
    def department_name(self) -> builtins.str:
        """
        Department name of the customer company.
        """
        return pulumi.get(self, "department_name")

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> builtins.str:
        """
        The email address of the paypal user.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> builtins.str:
        """
        First name of the paypal user.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="internalNumber")
    def internal_number(self) -> builtins.str:
        """
        Internal number of the customer company.
        """
        return pulumi.get(self, "internal_number")

    @property
    @pulumi.getter(name="jobTitle")
    def job_title(self) -> builtins.str:
        """
        Job title of the contact person.
        """
        return pulumi.get(self, "job_title")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> builtins.str:
        """
        Last name of the paypal user.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def line1(self) -> builtins.str:
        """
        Address line 1.
        """
        return pulumi.get(self, "line1")

    @property
    @pulumi.getter
    def line2(self) -> builtins.str:
        """
        Address line 2.
        """
        return pulumi.get(self, "line2")

    @property
    @pulumi.getter
    def line3(self) -> builtins.str:
        """
        Address line 3.
        """
        return pulumi.get(self, "line3")

    @property
    @pulumi.getter
    def line4(self) -> builtins.str:
        """
        Address line 4.
        """
        return pulumi.get(self, "line4")

    @property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> builtins.str:
        """
        Middle name of the contact person.
        """
        return pulumi.get(self, "middle_name")

    @property
    @pulumi.getter(name="municipalInscription")
    def municipal_inscription(self) -> builtins.str:
        """
        Municipal Inscription.
        """
        return pulumi.get(self, "municipal_inscription")

    @property
    @pulumi.getter(name="phoneCountryCode")
    def phone_country_code(self) -> builtins.str:
        """
        Phone country code of the contact person.
        """
        return pulumi.get(self, "phone_country_code")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> builtins.str:
        """
        Phone number of the contact person.
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> builtins.str:
        """
        Post code of the address.
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def province(self) -> builtins.str:
        """
        Province of the address.
        """
        return pulumi.get(self, "province")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        State of the address.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateInscription")
    def state_inscription(self) -> builtins.str:
        """
        State Inscription.
        """
        return pulumi.get(self, "state_inscription")

    @property
    @pulumi.getter(name="streetName")
    def street_name(self) -> builtins.str:
        """
        Street name of the address.
        """
        return pulumi.get(self, "street_name")

    @property
    @pulumi.getter(name="streetNumber")
    def street_number(self) -> builtins.str:
        """
        Street number of the address.
        """
        return pulumi.get(self, "street_number")


@pulumi.output_type
class GetSubscriptionPaymentGatewayResult(dict):
    def __init__(__self__, *,
                 merchant_defined_datas: Sequence['outputs.GetSubscriptionPaymentGatewayMerchantDefinedDataResult']):
        """
        :param Sequence['GetSubscriptionPaymentGatewayMerchantDefinedDataArgs'] merchant_defined_datas: Merchant details.
        """
        pulumi.set(__self__, "merchant_defined_datas", merchant_defined_datas)

    @property
    @pulumi.getter(name="merchantDefinedDatas")
    def merchant_defined_datas(self) -> Sequence['outputs.GetSubscriptionPaymentGatewayMerchantDefinedDataResult']:
        """
        Merchant details.
        """
        return pulumi.get(self, "merchant_defined_datas")


@pulumi.output_type
class GetSubscriptionPaymentGatewayMerchantDefinedDataResult(dict):
    def __init__(__self__, *,
                 cloud_account_name: builtins.str,
                 promo_type: builtins.str):
        """
        :param builtins.str cloud_account_name: Cloud account name.
        :param builtins.str promo_type: Promotion type code.
        """
        pulumi.set(__self__, "cloud_account_name", cloud_account_name)
        pulumi.set(__self__, "promo_type", promo_type)

    @property
    @pulumi.getter(name="cloudAccountName")
    def cloud_account_name(self) -> builtins.str:
        """
        Cloud account name.
        """
        return pulumi.get(self, "cloud_account_name")

    @property
    @pulumi.getter(name="promoType")
    def promo_type(self) -> builtins.str:
        """
        Promotion type code.
        """
        return pulumi.get(self, "promo_type")


@pulumi.output_type
class GetSubscriptionPaymentOptionResult(dict):
    def __init__(__self__, *,
                 credit_card_type: builtins.str,
                 email_address: builtins.str,
                 ext_billing_agreement_id: builtins.str,
                 first_name: builtins.str,
                 last_digits: builtins.str,
                 last_name: builtins.str,
                 name_on_card: builtins.str,
                 payment_method: builtins.str,
                 time_expiration: builtins.str,
                 wallet_instrument_id: builtins.str,
                 wallet_transaction_id: builtins.str):
        """
        :param builtins.str credit_card_type: Credit card type.
        :param builtins.str email_address: The email address of the paypal user.
        :param builtins.str ext_billing_agreement_id: Agreement id for the paypal account.
        :param builtins.str first_name: First name of the paypal user.
        :param builtins.str last_digits: Last four digits of the card.
        :param builtins.str last_name: Last name of the paypal user.
        :param builtins.str name_on_card: Name on the credit card.
        :param builtins.str payment_method: Payment method
        :param builtins.str time_expiration: Expired date of the credit card.
        :param builtins.str wallet_instrument_id: Wallet instrument internal id.
        :param builtins.str wallet_transaction_id: Wallet transaction id.
        """
        pulumi.set(__self__, "credit_card_type", credit_card_type)
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "ext_billing_agreement_id", ext_billing_agreement_id)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "last_digits", last_digits)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "name_on_card", name_on_card)
        pulumi.set(__self__, "payment_method", payment_method)
        pulumi.set(__self__, "time_expiration", time_expiration)
        pulumi.set(__self__, "wallet_instrument_id", wallet_instrument_id)
        pulumi.set(__self__, "wallet_transaction_id", wallet_transaction_id)

    @property
    @pulumi.getter(name="creditCardType")
    def credit_card_type(self) -> builtins.str:
        """
        Credit card type.
        """
        return pulumi.get(self, "credit_card_type")

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> builtins.str:
        """
        The email address of the paypal user.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="extBillingAgreementId")
    def ext_billing_agreement_id(self) -> builtins.str:
        """
        Agreement id for the paypal account.
        """
        return pulumi.get(self, "ext_billing_agreement_id")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> builtins.str:
        """
        First name of the paypal user.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastDigits")
    def last_digits(self) -> builtins.str:
        """
        Last four digits of the card.
        """
        return pulumi.get(self, "last_digits")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> builtins.str:
        """
        Last name of the paypal user.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="nameOnCard")
    def name_on_card(self) -> builtins.str:
        """
        Name on the credit card.
        """
        return pulumi.get(self, "name_on_card")

    @property
    @pulumi.getter(name="paymentMethod")
    def payment_method(self) -> builtins.str:
        """
        Payment method
        """
        return pulumi.get(self, "payment_method")

    @property
    @pulumi.getter(name="timeExpiration")
    def time_expiration(self) -> builtins.str:
        """
        Expired date of the credit card.
        """
        return pulumi.get(self, "time_expiration")

    @property
    @pulumi.getter(name="walletInstrumentId")
    def wallet_instrument_id(self) -> builtins.str:
        """
        Wallet instrument internal id.
        """
        return pulumi.get(self, "wallet_instrument_id")

    @property
    @pulumi.getter(name="walletTransactionId")
    def wallet_transaction_id(self) -> builtins.str:
        """
        Wallet transaction id.
        """
        return pulumi.get(self, "wallet_transaction_id")


@pulumi.output_type
class GetSubscriptionSubscriptionResult(dict):
    def __init__(__self__, *,
                 account_type: builtins.str,
                 bill_to_cust_account_id: builtins.str,
                 billing_addresses: Sequence['outputs.GetSubscriptionSubscriptionBillingAddressResult'],
                 currency_code: builtins.str,
                 gsi_org_code: builtins.str,
                 id: builtins.str,
                 is_intent_to_pay: builtins.bool,
                 language_code: builtins.str,
                 organization_id: builtins.str,
                 payment_gateways: Sequence['outputs.GetSubscriptionSubscriptionPaymentGatewayResult'],
                 payment_options: Sequence['outputs.GetSubscriptionSubscriptionPaymentOptionResult'],
                 plan_type: builtins.str,
                 ship_to_cust_acct_role_id: builtins.str,
                 ship_to_cust_acct_site_id: builtins.str,
                 subscription_plan_number: builtins.str,
                 tax_infos: Sequence['outputs.GetSubscriptionSubscriptionTaxInfoResult'],
                 time_personal_to_corporate_conv: builtins.str,
                 time_plan_upgrade: builtins.str,
                 time_start: builtins.str,
                 upgrade_state: builtins.str,
                 upgrade_state_details: builtins.str):
        """
        :param builtins.str account_type: Account type.
        :param builtins.str bill_to_cust_account_id: Bill to customer Account id.
        :param Sequence['GetSubscriptionSubscriptionBillingAddressArgs'] billing_addresses: Address details model.
        :param builtins.str currency_code: Currency code
        :param builtins.str gsi_org_code: GSI Subscription external code.
        :param builtins.str id: Subscription id identifier (OCID).
        :param builtins.bool is_intent_to_pay: Payment intension.
        :param builtins.str language_code: Language short code (en, de, hu, etc)
        :param builtins.str organization_id: GSI organization external identifier.
        :param Sequence['GetSubscriptionSubscriptionPaymentGatewayArgs'] payment_gateways: Payment gateway details.
        :param Sequence['GetSubscriptionSubscriptionPaymentOptionArgs'] payment_options: Payment option list of a subscription.
        :param builtins.str plan_type: Subscription plan type.
        :param builtins.str ship_to_cust_acct_role_id: Ship to customer account role.
        :param builtins.str ship_to_cust_acct_site_id: Ship to customer account site address id.
        :param builtins.str subscription_plan_number: Subscription plan number.
        :param Sequence['GetSubscriptionSubscriptionTaxInfoArgs'] tax_infos: Tax details.
        :param builtins.str time_personal_to_corporate_conv: Date of upgrade/conversion when account type changed from PERSONAL to CORPORATE
        :param builtins.str time_plan_upgrade: Date of upgrade/conversion when planType changed from FREE_TIER to PAYG
        :param builtins.str time_start: Start date of the subscription.
        :param builtins.str upgrade_state: Status of the upgrade.
        :param builtins.str upgrade_state_details: This field is used to describe the Upgrade State in case of error (E.g. Upgrade failure caused by interfacing Tax details- TaxError)
        """
        pulumi.set(__self__, "account_type", account_type)
        pulumi.set(__self__, "bill_to_cust_account_id", bill_to_cust_account_id)
        pulumi.set(__self__, "billing_addresses", billing_addresses)
        pulumi.set(__self__, "currency_code", currency_code)
        pulumi.set(__self__, "gsi_org_code", gsi_org_code)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_intent_to_pay", is_intent_to_pay)
        pulumi.set(__self__, "language_code", language_code)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "payment_gateways", payment_gateways)
        pulumi.set(__self__, "payment_options", payment_options)
        pulumi.set(__self__, "plan_type", plan_type)
        pulumi.set(__self__, "ship_to_cust_acct_role_id", ship_to_cust_acct_role_id)
        pulumi.set(__self__, "ship_to_cust_acct_site_id", ship_to_cust_acct_site_id)
        pulumi.set(__self__, "subscription_plan_number", subscription_plan_number)
        pulumi.set(__self__, "tax_infos", tax_infos)
        pulumi.set(__self__, "time_personal_to_corporate_conv", time_personal_to_corporate_conv)
        pulumi.set(__self__, "time_plan_upgrade", time_plan_upgrade)
        pulumi.set(__self__, "time_start", time_start)
        pulumi.set(__self__, "upgrade_state", upgrade_state)
        pulumi.set(__self__, "upgrade_state_details", upgrade_state_details)

    @property
    @pulumi.getter(name="accountType")
    def account_type(self) -> builtins.str:
        """
        Account type.
        """
        return pulumi.get(self, "account_type")

    @property
    @pulumi.getter(name="billToCustAccountId")
    def bill_to_cust_account_id(self) -> builtins.str:
        """
        Bill to customer Account id.
        """
        return pulumi.get(self, "bill_to_cust_account_id")

    @property
    @pulumi.getter(name="billingAddresses")
    def billing_addresses(self) -> Sequence['outputs.GetSubscriptionSubscriptionBillingAddressResult']:
        """
        Address details model.
        """
        return pulumi.get(self, "billing_addresses")

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> builtins.str:
        """
        Currency code
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter(name="gsiOrgCode")
    def gsi_org_code(self) -> builtins.str:
        """
        GSI Subscription external code.
        """
        return pulumi.get(self, "gsi_org_code")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Subscription id identifier (OCID).
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isIntentToPay")
    def is_intent_to_pay(self) -> builtins.bool:
        """
        Payment intension.
        """
        return pulumi.get(self, "is_intent_to_pay")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> builtins.str:
        """
        Language short code (en, de, hu, etc)
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> builtins.str:
        """
        GSI organization external identifier.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="paymentGateways")
    def payment_gateways(self) -> Sequence['outputs.GetSubscriptionSubscriptionPaymentGatewayResult']:
        """
        Payment gateway details.
        """
        return pulumi.get(self, "payment_gateways")

    @property
    @pulumi.getter(name="paymentOptions")
    def payment_options(self) -> Sequence['outputs.GetSubscriptionSubscriptionPaymentOptionResult']:
        """
        Payment option list of a subscription.
        """
        return pulumi.get(self, "payment_options")

    @property
    @pulumi.getter(name="planType")
    def plan_type(self) -> builtins.str:
        """
        Subscription plan type.
        """
        return pulumi.get(self, "plan_type")

    @property
    @pulumi.getter(name="shipToCustAcctRoleId")
    def ship_to_cust_acct_role_id(self) -> builtins.str:
        """
        Ship to customer account role.
        """
        return pulumi.get(self, "ship_to_cust_acct_role_id")

    @property
    @pulumi.getter(name="shipToCustAcctSiteId")
    def ship_to_cust_acct_site_id(self) -> builtins.str:
        """
        Ship to customer account site address id.
        """
        return pulumi.get(self, "ship_to_cust_acct_site_id")

    @property
    @pulumi.getter(name="subscriptionPlanNumber")
    def subscription_plan_number(self) -> builtins.str:
        """
        Subscription plan number.
        """
        return pulumi.get(self, "subscription_plan_number")

    @property
    @pulumi.getter(name="taxInfos")
    def tax_infos(self) -> Sequence['outputs.GetSubscriptionSubscriptionTaxInfoResult']:
        """
        Tax details.
        """
        return pulumi.get(self, "tax_infos")

    @property
    @pulumi.getter(name="timePersonalToCorporateConv")
    def time_personal_to_corporate_conv(self) -> builtins.str:
        """
        Date of upgrade/conversion when account type changed from PERSONAL to CORPORATE
        """
        return pulumi.get(self, "time_personal_to_corporate_conv")

    @property
    @pulumi.getter(name="timePlanUpgrade")
    def time_plan_upgrade(self) -> builtins.str:
        """
        Date of upgrade/conversion when planType changed from FREE_TIER to PAYG
        """
        return pulumi.get(self, "time_plan_upgrade")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> builtins.str:
        """
        Start date of the subscription.
        """
        return pulumi.get(self, "time_start")

    @property
    @pulumi.getter(name="upgradeState")
    def upgrade_state(self) -> builtins.str:
        """
        Status of the upgrade.
        """
        return pulumi.get(self, "upgrade_state")

    @property
    @pulumi.getter(name="upgradeStateDetails")
    def upgrade_state_details(self) -> builtins.str:
        """
        This field is used to describe the Upgrade State in case of error (E.g. Upgrade failure caused by interfacing Tax details- TaxError)
        """
        return pulumi.get(self, "upgrade_state_details")


@pulumi.output_type
class GetSubscriptionSubscriptionBillingAddressResult(dict):
    def __init__(__self__, *,
                 address_key: builtins.str,
                 city: builtins.str,
                 company_name: builtins.str,
                 contributor_class: builtins.str,
                 country: builtins.str,
                 county: builtins.str,
                 department_name: builtins.str,
                 email_address: builtins.str,
                 first_name: builtins.str,
                 internal_number: builtins.str,
                 job_title: builtins.str,
                 last_name: builtins.str,
                 line1: builtins.str,
                 line2: builtins.str,
                 line3: builtins.str,
                 line4: builtins.str,
                 middle_name: builtins.str,
                 municipal_inscription: builtins.str,
                 phone_country_code: builtins.str,
                 phone_number: builtins.str,
                 postal_code: builtins.str,
                 province: builtins.str,
                 state: builtins.str,
                 state_inscription: builtins.str,
                 street_name: builtins.str,
                 street_number: builtins.str):
        """
        :param builtins.str address_key: Address identifier.
        :param builtins.str city: Name of the city.
        :param builtins.str company_name: Name of the customer company.
        :param builtins.str contributor_class: Contributor class of the customer company.
        :param builtins.str country: Country of the address.
        :param builtins.str county: County of the address.
        :param builtins.str department_name: Department name of the customer company.
        :param builtins.str email_address: The email address of the paypal user.
        :param builtins.str first_name: First name of the paypal user.
        :param builtins.str internal_number: Internal number of the customer company.
        :param builtins.str job_title: Job title of the contact person.
        :param builtins.str last_name: Last name of the paypal user.
        :param builtins.str line1: Address line 1.
        :param builtins.str line2: Address line 2.
        :param builtins.str line3: Address line 3.
        :param builtins.str line4: Address line 4.
        :param builtins.str middle_name: Middle name of the contact person.
        :param builtins.str municipal_inscription: Municipal Inscription.
        :param builtins.str phone_country_code: Phone country code of the contact person.
        :param builtins.str phone_number: Phone number of the contact person.
        :param builtins.str postal_code: Post code of the address.
        :param builtins.str province: Province of the address.
        :param builtins.str state: State of the address.
        :param builtins.str state_inscription: State Inscription.
        :param builtins.str street_name: Street name of the address.
        :param builtins.str street_number: Street number of the address.
        """
        pulumi.set(__self__, "address_key", address_key)
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "company_name", company_name)
        pulumi.set(__self__, "contributor_class", contributor_class)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "county", county)
        pulumi.set(__self__, "department_name", department_name)
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "internal_number", internal_number)
        pulumi.set(__self__, "job_title", job_title)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "line1", line1)
        pulumi.set(__self__, "line2", line2)
        pulumi.set(__self__, "line3", line3)
        pulumi.set(__self__, "line4", line4)
        pulumi.set(__self__, "middle_name", middle_name)
        pulumi.set(__self__, "municipal_inscription", municipal_inscription)
        pulumi.set(__self__, "phone_country_code", phone_country_code)
        pulumi.set(__self__, "phone_number", phone_number)
        pulumi.set(__self__, "postal_code", postal_code)
        pulumi.set(__self__, "province", province)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_inscription", state_inscription)
        pulumi.set(__self__, "street_name", street_name)
        pulumi.set(__self__, "street_number", street_number)

    @property
    @pulumi.getter(name="addressKey")
    def address_key(self) -> builtins.str:
        """
        Address identifier.
        """
        return pulumi.get(self, "address_key")

    @property
    @pulumi.getter
    def city(self) -> builtins.str:
        """
        Name of the city.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> builtins.str:
        """
        Name of the customer company.
        """
        return pulumi.get(self, "company_name")

    @property
    @pulumi.getter(name="contributorClass")
    def contributor_class(self) -> builtins.str:
        """
        Contributor class of the customer company.
        """
        return pulumi.get(self, "contributor_class")

    @property
    @pulumi.getter
    def country(self) -> builtins.str:
        """
        Country of the address.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def county(self) -> builtins.str:
        """
        County of the address.
        """
        return pulumi.get(self, "county")

    @property
    @pulumi.getter(name="departmentName")
    def department_name(self) -> builtins.str:
        """
        Department name of the customer company.
        """
        return pulumi.get(self, "department_name")

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> builtins.str:
        """
        The email address of the paypal user.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> builtins.str:
        """
        First name of the paypal user.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="internalNumber")
    def internal_number(self) -> builtins.str:
        """
        Internal number of the customer company.
        """
        return pulumi.get(self, "internal_number")

    @property
    @pulumi.getter(name="jobTitle")
    def job_title(self) -> builtins.str:
        """
        Job title of the contact person.
        """
        return pulumi.get(self, "job_title")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> builtins.str:
        """
        Last name of the paypal user.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def line1(self) -> builtins.str:
        """
        Address line 1.
        """
        return pulumi.get(self, "line1")

    @property
    @pulumi.getter
    def line2(self) -> builtins.str:
        """
        Address line 2.
        """
        return pulumi.get(self, "line2")

    @property
    @pulumi.getter
    def line3(self) -> builtins.str:
        """
        Address line 3.
        """
        return pulumi.get(self, "line3")

    @property
    @pulumi.getter
    def line4(self) -> builtins.str:
        """
        Address line 4.
        """
        return pulumi.get(self, "line4")

    @property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> builtins.str:
        """
        Middle name of the contact person.
        """
        return pulumi.get(self, "middle_name")

    @property
    @pulumi.getter(name="municipalInscription")
    def municipal_inscription(self) -> builtins.str:
        """
        Municipal Inscription.
        """
        return pulumi.get(self, "municipal_inscription")

    @property
    @pulumi.getter(name="phoneCountryCode")
    def phone_country_code(self) -> builtins.str:
        """
        Phone country code of the contact person.
        """
        return pulumi.get(self, "phone_country_code")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> builtins.str:
        """
        Phone number of the contact person.
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> builtins.str:
        """
        Post code of the address.
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def province(self) -> builtins.str:
        """
        Province of the address.
        """
        return pulumi.get(self, "province")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        State of the address.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateInscription")
    def state_inscription(self) -> builtins.str:
        """
        State Inscription.
        """
        return pulumi.get(self, "state_inscription")

    @property
    @pulumi.getter(name="streetName")
    def street_name(self) -> builtins.str:
        """
        Street name of the address.
        """
        return pulumi.get(self, "street_name")

    @property
    @pulumi.getter(name="streetNumber")
    def street_number(self) -> builtins.str:
        """
        Street number of the address.
        """
        return pulumi.get(self, "street_number")


@pulumi.output_type
class GetSubscriptionSubscriptionPaymentGatewayResult(dict):
    def __init__(__self__, *,
                 merchant_defined_datas: Sequence['outputs.GetSubscriptionSubscriptionPaymentGatewayMerchantDefinedDataResult']):
        """
        :param Sequence['GetSubscriptionSubscriptionPaymentGatewayMerchantDefinedDataArgs'] merchant_defined_datas: Merchant details.
        """
        pulumi.set(__self__, "merchant_defined_datas", merchant_defined_datas)

    @property
    @pulumi.getter(name="merchantDefinedDatas")
    def merchant_defined_datas(self) -> Sequence['outputs.GetSubscriptionSubscriptionPaymentGatewayMerchantDefinedDataResult']:
        """
        Merchant details.
        """
        return pulumi.get(self, "merchant_defined_datas")


@pulumi.output_type
class GetSubscriptionSubscriptionPaymentGatewayMerchantDefinedDataResult(dict):
    def __init__(__self__, *,
                 cloud_account_name: builtins.str,
                 promo_type: builtins.str):
        """
        :param builtins.str cloud_account_name: Cloud account name.
        :param builtins.str promo_type: Promotion type code.
        """
        pulumi.set(__self__, "cloud_account_name", cloud_account_name)
        pulumi.set(__self__, "promo_type", promo_type)

    @property
    @pulumi.getter(name="cloudAccountName")
    def cloud_account_name(self) -> builtins.str:
        """
        Cloud account name.
        """
        return pulumi.get(self, "cloud_account_name")

    @property
    @pulumi.getter(name="promoType")
    def promo_type(self) -> builtins.str:
        """
        Promotion type code.
        """
        return pulumi.get(self, "promo_type")


@pulumi.output_type
class GetSubscriptionSubscriptionPaymentOptionResult(dict):
    def __init__(__self__, *,
                 credit_card_type: builtins.str,
                 email_address: builtins.str,
                 ext_billing_agreement_id: builtins.str,
                 first_name: builtins.str,
                 last_digits: builtins.str,
                 last_name: builtins.str,
                 name_on_card: builtins.str,
                 payment_method: builtins.str,
                 time_expiration: builtins.str,
                 wallet_instrument_id: builtins.str,
                 wallet_transaction_id: builtins.str):
        """
        :param builtins.str credit_card_type: Credit card type.
        :param builtins.str email_address: The email address of the paypal user.
        :param builtins.str ext_billing_agreement_id: Agreement id for the paypal account.
        :param builtins.str first_name: First name of the paypal user.
        :param builtins.str last_digits: Last four digits of the card.
        :param builtins.str last_name: Last name of the paypal user.
        :param builtins.str name_on_card: Name on the credit card.
        :param builtins.str payment_method: Payment method
        :param builtins.str time_expiration: Expired date of the credit card.
        :param builtins.str wallet_instrument_id: Wallet instrument internal id.
        :param builtins.str wallet_transaction_id: Wallet transaction id.
        """
        pulumi.set(__self__, "credit_card_type", credit_card_type)
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "ext_billing_agreement_id", ext_billing_agreement_id)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "last_digits", last_digits)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "name_on_card", name_on_card)
        pulumi.set(__self__, "payment_method", payment_method)
        pulumi.set(__self__, "time_expiration", time_expiration)
        pulumi.set(__self__, "wallet_instrument_id", wallet_instrument_id)
        pulumi.set(__self__, "wallet_transaction_id", wallet_transaction_id)

    @property
    @pulumi.getter(name="creditCardType")
    def credit_card_type(self) -> builtins.str:
        """
        Credit card type.
        """
        return pulumi.get(self, "credit_card_type")

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> builtins.str:
        """
        The email address of the paypal user.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="extBillingAgreementId")
    def ext_billing_agreement_id(self) -> builtins.str:
        """
        Agreement id for the paypal account.
        """
        return pulumi.get(self, "ext_billing_agreement_id")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> builtins.str:
        """
        First name of the paypal user.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastDigits")
    def last_digits(self) -> builtins.str:
        """
        Last four digits of the card.
        """
        return pulumi.get(self, "last_digits")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> builtins.str:
        """
        Last name of the paypal user.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="nameOnCard")
    def name_on_card(self) -> builtins.str:
        """
        Name on the credit card.
        """
        return pulumi.get(self, "name_on_card")

    @property
    @pulumi.getter(name="paymentMethod")
    def payment_method(self) -> builtins.str:
        """
        Payment method
        """
        return pulumi.get(self, "payment_method")

    @property
    @pulumi.getter(name="timeExpiration")
    def time_expiration(self) -> builtins.str:
        """
        Expired date of the credit card.
        """
        return pulumi.get(self, "time_expiration")

    @property
    @pulumi.getter(name="walletInstrumentId")
    def wallet_instrument_id(self) -> builtins.str:
        """
        Wallet instrument internal id.
        """
        return pulumi.get(self, "wallet_instrument_id")

    @property
    @pulumi.getter(name="walletTransactionId")
    def wallet_transaction_id(self) -> builtins.str:
        """
        Wallet transaction id.
        """
        return pulumi.get(self, "wallet_transaction_id")


@pulumi.output_type
class GetSubscriptionSubscriptionTaxInfoResult(dict):
    def __init__(__self__, *,
                 no_tax_reason_code: builtins.str,
                 no_tax_reason_code_details: builtins.str,
                 tax_cnpj: builtins.str,
                 tax_payer_id: builtins.str,
                 tax_reg_number: builtins.str):
        """
        :param builtins.str no_tax_reason_code: Tax exemption reason code.
        :param builtins.str no_tax_reason_code_details: Tax exemption reason description.
        :param builtins.str tax_cnpj: Brazilian companies' CNPJ number.
        :param builtins.str tax_payer_id: Tay payer identifier.
        :param builtins.str tax_reg_number: Tax registration number.
        """
        pulumi.set(__self__, "no_tax_reason_code", no_tax_reason_code)
        pulumi.set(__self__, "no_tax_reason_code_details", no_tax_reason_code_details)
        pulumi.set(__self__, "tax_cnpj", tax_cnpj)
        pulumi.set(__self__, "tax_payer_id", tax_payer_id)
        pulumi.set(__self__, "tax_reg_number", tax_reg_number)

    @property
    @pulumi.getter(name="noTaxReasonCode")
    def no_tax_reason_code(self) -> builtins.str:
        """
        Tax exemption reason code.
        """
        return pulumi.get(self, "no_tax_reason_code")

    @property
    @pulumi.getter(name="noTaxReasonCodeDetails")
    def no_tax_reason_code_details(self) -> builtins.str:
        """
        Tax exemption reason description.
        """
        return pulumi.get(self, "no_tax_reason_code_details")

    @property
    @pulumi.getter(name="taxCnpj")
    def tax_cnpj(self) -> builtins.str:
        """
        Brazilian companies' CNPJ number.
        """
        return pulumi.get(self, "tax_cnpj")

    @property
    @pulumi.getter(name="taxPayerId")
    def tax_payer_id(self) -> builtins.str:
        """
        Tay payer identifier.
        """
        return pulumi.get(self, "tax_payer_id")

    @property
    @pulumi.getter(name="taxRegNumber")
    def tax_reg_number(self) -> builtins.str:
        """
        Tax registration number.
        """
        return pulumi.get(self, "tax_reg_number")


@pulumi.output_type
class GetSubscriptionTaxInfoResult(dict):
    def __init__(__self__, *,
                 giro: builtins.str,
                 no_tax_reason_code: builtins.str,
                 no_tax_reason_code_details: builtins.str,
                 tax_cnpj: builtins.str,
                 tax_payer_id: builtins.str,
                 tax_reg_number: builtins.str):
        """
        :param builtins.str giro: Companies' GIRO code
        :param builtins.str no_tax_reason_code: Tax exemption reason code.
        :param builtins.str no_tax_reason_code_details: Tax exemption reason description.
        :param builtins.str tax_cnpj: Brazilian companies' CNPJ number.
        :param builtins.str tax_payer_id: Tay payer identifier.
        :param builtins.str tax_reg_number: Tax registration number.
        """
        pulumi.set(__self__, "giro", giro)
        pulumi.set(__self__, "no_tax_reason_code", no_tax_reason_code)
        pulumi.set(__self__, "no_tax_reason_code_details", no_tax_reason_code_details)
        pulumi.set(__self__, "tax_cnpj", tax_cnpj)
        pulumi.set(__self__, "tax_payer_id", tax_payer_id)
        pulumi.set(__self__, "tax_reg_number", tax_reg_number)

    @property
    @pulumi.getter
    def giro(self) -> builtins.str:
        """
        Companies' GIRO code
        """
        return pulumi.get(self, "giro")

    @property
    @pulumi.getter(name="noTaxReasonCode")
    def no_tax_reason_code(self) -> builtins.str:
        """
        Tax exemption reason code.
        """
        return pulumi.get(self, "no_tax_reason_code")

    @property
    @pulumi.getter(name="noTaxReasonCodeDetails")
    def no_tax_reason_code_details(self) -> builtins.str:
        """
        Tax exemption reason description.
        """
        return pulumi.get(self, "no_tax_reason_code_details")

    @property
    @pulumi.getter(name="taxCnpj")
    def tax_cnpj(self) -> builtins.str:
        """
        Brazilian companies' CNPJ number.
        """
        return pulumi.get(self, "tax_cnpj")

    @property
    @pulumi.getter(name="taxPayerId")
    def tax_payer_id(self) -> builtins.str:
        """
        Tay payer identifier.
        """
        return pulumi.get(self, "tax_payer_id")

    @property
    @pulumi.getter(name="taxRegNumber")
    def tax_reg_number(self) -> builtins.str:
        """
        Tax registration number.
        """
        return pulumi.get(self, "tax_reg_number")


@pulumi.output_type
class GetSubscriptionsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSubscriptionsSubscriptionCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSubscriptionsSubscriptionCollectionItemResult(dict):
    def __init__(__self__, *,
                 account_type: builtins.str,
                 bill_to_cust_account_id: builtins.str,
                 billing_addresses: Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemBillingAddressResult'],
                 compartment_id: builtins.str,
                 currency_code: builtins.str,
                 email: builtins.str,
                 gsi_org_code: builtins.str,
                 id: builtins.str,
                 is_intent_to_pay: builtins.bool,
                 language_code: builtins.str,
                 organization_id: builtins.str,
                 osp_home_region: builtins.str,
                 payment_gateways: Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemPaymentGatewayResult'],
                 payment_options: Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemPaymentOptionResult'],
                 plan_type: builtins.str,
                 ship_to_cust_acct_role_id: builtins.str,
                 ship_to_cust_acct_site_id: builtins.str,
                 subscription_id: builtins.str,
                 subscription_plan_number: builtins.str,
                 subscriptions: Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemSubscriptionResult'],
                 tax_infos: Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemTaxInfoResult'],
                 time_personal_to_corporate_conv: builtins.str,
                 time_plan_upgrade: builtins.str,
                 time_start: builtins.str,
                 upgrade_state: builtins.str,
                 upgrade_state_details: builtins.str):
        """
        :param builtins.str account_type: Account type.
        :param builtins.str bill_to_cust_account_id: Bill to customer Account id.
        :param Sequence['GetSubscriptionsSubscriptionCollectionItemBillingAddressArgs'] billing_addresses: Address details model.
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param builtins.str currency_code: Currency code
        :param builtins.str gsi_org_code: GSI Subscription external code.
        :param builtins.str id: Subscription id identifier (OCID).
        :param builtins.bool is_intent_to_pay: Payment intension.
        :param builtins.str language_code: Language short code (en, de, hu, etc)
        :param builtins.str organization_id: GSI organization external identifier.
        :param builtins.str osp_home_region: The home region's public name of the logged in user.
        :param Sequence['GetSubscriptionsSubscriptionCollectionItemPaymentGatewayArgs'] payment_gateways: Payment gateway details.
        :param Sequence['GetSubscriptionsSubscriptionCollectionItemPaymentOptionArgs'] payment_options: Payment option list of a subscription.
        :param builtins.str plan_type: Subscription plan type.
        :param builtins.str ship_to_cust_acct_role_id: Ship to customer account role.
        :param builtins.str ship_to_cust_acct_site_id: Ship to customer account site address id.
        :param builtins.str subscription_plan_number: Subscription plan number.
        :param Sequence['GetSubscriptionsSubscriptionCollectionItemTaxInfoArgs'] tax_infos: Tax details.
        :param builtins.str time_personal_to_corporate_conv: Date of upgrade/conversion when account type changed from PERSONAL to CORPORATE
        :param builtins.str time_plan_upgrade: Date of upgrade/conversion when planType changed from FREE_TIER to PAYG
        :param builtins.str time_start: Start date of the subscription.
        :param builtins.str upgrade_state: Status of the upgrade.
        :param builtins.str upgrade_state_details: This field is used to describe the Upgrade State in case of error (E.g. Upgrade failure caused by interfacing Tax details- TaxError)
        """
        pulumi.set(__self__, "account_type", account_type)
        pulumi.set(__self__, "bill_to_cust_account_id", bill_to_cust_account_id)
        pulumi.set(__self__, "billing_addresses", billing_addresses)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "currency_code", currency_code)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "gsi_org_code", gsi_org_code)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_intent_to_pay", is_intent_to_pay)
        pulumi.set(__self__, "language_code", language_code)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "osp_home_region", osp_home_region)
        pulumi.set(__self__, "payment_gateways", payment_gateways)
        pulumi.set(__self__, "payment_options", payment_options)
        pulumi.set(__self__, "plan_type", plan_type)
        pulumi.set(__self__, "ship_to_cust_acct_role_id", ship_to_cust_acct_role_id)
        pulumi.set(__self__, "ship_to_cust_acct_site_id", ship_to_cust_acct_site_id)
        pulumi.set(__self__, "subscription_id", subscription_id)
        pulumi.set(__self__, "subscription_plan_number", subscription_plan_number)
        pulumi.set(__self__, "subscriptions", subscriptions)
        pulumi.set(__self__, "tax_infos", tax_infos)
        pulumi.set(__self__, "time_personal_to_corporate_conv", time_personal_to_corporate_conv)
        pulumi.set(__self__, "time_plan_upgrade", time_plan_upgrade)
        pulumi.set(__self__, "time_start", time_start)
        pulumi.set(__self__, "upgrade_state", upgrade_state)
        pulumi.set(__self__, "upgrade_state_details", upgrade_state_details)

    @property
    @pulumi.getter(name="accountType")
    def account_type(self) -> builtins.str:
        """
        Account type.
        """
        return pulumi.get(self, "account_type")

    @property
    @pulumi.getter(name="billToCustAccountId")
    def bill_to_cust_account_id(self) -> builtins.str:
        """
        Bill to customer Account id.
        """
        return pulumi.get(self, "bill_to_cust_account_id")

    @property
    @pulumi.getter(name="billingAddresses")
    def billing_addresses(self) -> Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemBillingAddressResult']:
        """
        Address details model.
        """
        return pulumi.get(self, "billing_addresses")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> builtins.str:
        """
        Currency code
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="gsiOrgCode")
    def gsi_org_code(self) -> builtins.str:
        """
        GSI Subscription external code.
        """
        return pulumi.get(self, "gsi_org_code")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Subscription id identifier (OCID).
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isIntentToPay")
    def is_intent_to_pay(self) -> builtins.bool:
        """
        Payment intension.
        """
        return pulumi.get(self, "is_intent_to_pay")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> builtins.str:
        """
        Language short code (en, de, hu, etc)
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> builtins.str:
        """
        GSI organization external identifier.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="ospHomeRegion")
    def osp_home_region(self) -> builtins.str:
        """
        The home region's public name of the logged in user.
        """
        return pulumi.get(self, "osp_home_region")

    @property
    @pulumi.getter(name="paymentGateways")
    def payment_gateways(self) -> Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemPaymentGatewayResult']:
        """
        Payment gateway details.
        """
        return pulumi.get(self, "payment_gateways")

    @property
    @pulumi.getter(name="paymentOptions")
    def payment_options(self) -> Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemPaymentOptionResult']:
        """
        Payment option list of a subscription.
        """
        return pulumi.get(self, "payment_options")

    @property
    @pulumi.getter(name="planType")
    def plan_type(self) -> builtins.str:
        """
        Subscription plan type.
        """
        return pulumi.get(self, "plan_type")

    @property
    @pulumi.getter(name="shipToCustAcctRoleId")
    def ship_to_cust_acct_role_id(self) -> builtins.str:
        """
        Ship to customer account role.
        """
        return pulumi.get(self, "ship_to_cust_acct_role_id")

    @property
    @pulumi.getter(name="shipToCustAcctSiteId")
    def ship_to_cust_acct_site_id(self) -> builtins.str:
        """
        Ship to customer account site address id.
        """
        return pulumi.get(self, "ship_to_cust_acct_site_id")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> builtins.str:
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="subscriptionPlanNumber")
    def subscription_plan_number(self) -> builtins.str:
        """
        Subscription plan number.
        """
        return pulumi.get(self, "subscription_plan_number")

    @property
    @pulumi.getter
    def subscriptions(self) -> Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemSubscriptionResult']:
        return pulumi.get(self, "subscriptions")

    @property
    @pulumi.getter(name="taxInfos")
    def tax_infos(self) -> Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemTaxInfoResult']:
        """
        Tax details.
        """
        return pulumi.get(self, "tax_infos")

    @property
    @pulumi.getter(name="timePersonalToCorporateConv")
    def time_personal_to_corporate_conv(self) -> builtins.str:
        """
        Date of upgrade/conversion when account type changed from PERSONAL to CORPORATE
        """
        return pulumi.get(self, "time_personal_to_corporate_conv")

    @property
    @pulumi.getter(name="timePlanUpgrade")
    def time_plan_upgrade(self) -> builtins.str:
        """
        Date of upgrade/conversion when planType changed from FREE_TIER to PAYG
        """
        return pulumi.get(self, "time_plan_upgrade")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> builtins.str:
        """
        Start date of the subscription.
        """
        return pulumi.get(self, "time_start")

    @property
    @pulumi.getter(name="upgradeState")
    def upgrade_state(self) -> builtins.str:
        """
        Status of the upgrade.
        """
        return pulumi.get(self, "upgrade_state")

    @property
    @pulumi.getter(name="upgradeStateDetails")
    def upgrade_state_details(self) -> builtins.str:
        """
        This field is used to describe the Upgrade State in case of error (E.g. Upgrade failure caused by interfacing Tax details- TaxError)
        """
        return pulumi.get(self, "upgrade_state_details")


@pulumi.output_type
class GetSubscriptionsSubscriptionCollectionItemBillingAddressResult(dict):
    def __init__(__self__, *,
                 address_key: builtins.str,
                 city: builtins.str,
                 company_name: builtins.str,
                 contributor_class: builtins.str,
                 country: builtins.str,
                 county: builtins.str,
                 department_name: builtins.str,
                 email_address: builtins.str,
                 first_name: builtins.str,
                 internal_number: builtins.str,
                 job_title: builtins.str,
                 last_name: builtins.str,
                 line1: builtins.str,
                 line2: builtins.str,
                 line3: builtins.str,
                 line4: builtins.str,
                 middle_name: builtins.str,
                 municipal_inscription: builtins.str,
                 phone_country_code: builtins.str,
                 phone_number: builtins.str,
                 postal_code: builtins.str,
                 province: builtins.str,
                 state: builtins.str,
                 state_inscription: builtins.str,
                 street_name: builtins.str,
                 street_number: builtins.str):
        """
        :param builtins.str address_key: Address identifier.
        :param builtins.str city: Name of the city.
        :param builtins.str company_name: Name of the customer company.
        :param builtins.str contributor_class: Contributor class of the customer company.
        :param builtins.str country: Country of the address.
        :param builtins.str county: County of the address.
        :param builtins.str department_name: Department name of the customer company.
        :param builtins.str email_address: The email address of the paypal user.
        :param builtins.str first_name: First name of the paypal user.
        :param builtins.str internal_number: Internal number of the customer company.
        :param builtins.str job_title: Job title of the contact person.
        :param builtins.str last_name: Last name of the paypal user.
        :param builtins.str line1: Address line 1.
        :param builtins.str line2: Address line 2.
        :param builtins.str line3: Address line 3.
        :param builtins.str line4: Address line 4.
        :param builtins.str middle_name: Middle name of the contact person.
        :param builtins.str municipal_inscription: Municipal Inscription.
        :param builtins.str phone_country_code: Phone country code of the contact person.
        :param builtins.str phone_number: Phone number of the contact person.
        :param builtins.str postal_code: Post code of the address.
        :param builtins.str province: Province of the address.
        :param builtins.str state: State of the address.
        :param builtins.str state_inscription: State Inscription.
        :param builtins.str street_name: Street name of the address.
        :param builtins.str street_number: Street number of the address.
        """
        pulumi.set(__self__, "address_key", address_key)
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "company_name", company_name)
        pulumi.set(__self__, "contributor_class", contributor_class)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "county", county)
        pulumi.set(__self__, "department_name", department_name)
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "internal_number", internal_number)
        pulumi.set(__self__, "job_title", job_title)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "line1", line1)
        pulumi.set(__self__, "line2", line2)
        pulumi.set(__self__, "line3", line3)
        pulumi.set(__self__, "line4", line4)
        pulumi.set(__self__, "middle_name", middle_name)
        pulumi.set(__self__, "municipal_inscription", municipal_inscription)
        pulumi.set(__self__, "phone_country_code", phone_country_code)
        pulumi.set(__self__, "phone_number", phone_number)
        pulumi.set(__self__, "postal_code", postal_code)
        pulumi.set(__self__, "province", province)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_inscription", state_inscription)
        pulumi.set(__self__, "street_name", street_name)
        pulumi.set(__self__, "street_number", street_number)

    @property
    @pulumi.getter(name="addressKey")
    def address_key(self) -> builtins.str:
        """
        Address identifier.
        """
        return pulumi.get(self, "address_key")

    @property
    @pulumi.getter
    def city(self) -> builtins.str:
        """
        Name of the city.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> builtins.str:
        """
        Name of the customer company.
        """
        return pulumi.get(self, "company_name")

    @property
    @pulumi.getter(name="contributorClass")
    def contributor_class(self) -> builtins.str:
        """
        Contributor class of the customer company.
        """
        return pulumi.get(self, "contributor_class")

    @property
    @pulumi.getter
    def country(self) -> builtins.str:
        """
        Country of the address.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def county(self) -> builtins.str:
        """
        County of the address.
        """
        return pulumi.get(self, "county")

    @property
    @pulumi.getter(name="departmentName")
    def department_name(self) -> builtins.str:
        """
        Department name of the customer company.
        """
        return pulumi.get(self, "department_name")

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> builtins.str:
        """
        The email address of the paypal user.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> builtins.str:
        """
        First name of the paypal user.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="internalNumber")
    def internal_number(self) -> builtins.str:
        """
        Internal number of the customer company.
        """
        return pulumi.get(self, "internal_number")

    @property
    @pulumi.getter(name="jobTitle")
    def job_title(self) -> builtins.str:
        """
        Job title of the contact person.
        """
        return pulumi.get(self, "job_title")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> builtins.str:
        """
        Last name of the paypal user.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def line1(self) -> builtins.str:
        """
        Address line 1.
        """
        return pulumi.get(self, "line1")

    @property
    @pulumi.getter
    def line2(self) -> builtins.str:
        """
        Address line 2.
        """
        return pulumi.get(self, "line2")

    @property
    @pulumi.getter
    def line3(self) -> builtins.str:
        """
        Address line 3.
        """
        return pulumi.get(self, "line3")

    @property
    @pulumi.getter
    def line4(self) -> builtins.str:
        """
        Address line 4.
        """
        return pulumi.get(self, "line4")

    @property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> builtins.str:
        """
        Middle name of the contact person.
        """
        return pulumi.get(self, "middle_name")

    @property
    @pulumi.getter(name="municipalInscription")
    def municipal_inscription(self) -> builtins.str:
        """
        Municipal Inscription.
        """
        return pulumi.get(self, "municipal_inscription")

    @property
    @pulumi.getter(name="phoneCountryCode")
    def phone_country_code(self) -> builtins.str:
        """
        Phone country code of the contact person.
        """
        return pulumi.get(self, "phone_country_code")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> builtins.str:
        """
        Phone number of the contact person.
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> builtins.str:
        """
        Post code of the address.
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def province(self) -> builtins.str:
        """
        Province of the address.
        """
        return pulumi.get(self, "province")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        State of the address.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateInscription")
    def state_inscription(self) -> builtins.str:
        """
        State Inscription.
        """
        return pulumi.get(self, "state_inscription")

    @property
    @pulumi.getter(name="streetName")
    def street_name(self) -> builtins.str:
        """
        Street name of the address.
        """
        return pulumi.get(self, "street_name")

    @property
    @pulumi.getter(name="streetNumber")
    def street_number(self) -> builtins.str:
        """
        Street number of the address.
        """
        return pulumi.get(self, "street_number")


@pulumi.output_type
class GetSubscriptionsSubscriptionCollectionItemPaymentGatewayResult(dict):
    def __init__(__self__, *,
                 merchant_defined_datas: Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemPaymentGatewayMerchantDefinedDataResult']):
        """
        :param Sequence['GetSubscriptionsSubscriptionCollectionItemPaymentGatewayMerchantDefinedDataArgs'] merchant_defined_datas: Merchant details.
        """
        pulumi.set(__self__, "merchant_defined_datas", merchant_defined_datas)

    @property
    @pulumi.getter(name="merchantDefinedDatas")
    def merchant_defined_datas(self) -> Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemPaymentGatewayMerchantDefinedDataResult']:
        """
        Merchant details.
        """
        return pulumi.get(self, "merchant_defined_datas")


@pulumi.output_type
class GetSubscriptionsSubscriptionCollectionItemPaymentGatewayMerchantDefinedDataResult(dict):
    def __init__(__self__, *,
                 cloud_account_name: builtins.str,
                 promo_type: builtins.str):
        """
        :param builtins.str cloud_account_name: Cloud account name.
        :param builtins.str promo_type: Promotion type code.
        """
        pulumi.set(__self__, "cloud_account_name", cloud_account_name)
        pulumi.set(__self__, "promo_type", promo_type)

    @property
    @pulumi.getter(name="cloudAccountName")
    def cloud_account_name(self) -> builtins.str:
        """
        Cloud account name.
        """
        return pulumi.get(self, "cloud_account_name")

    @property
    @pulumi.getter(name="promoType")
    def promo_type(self) -> builtins.str:
        """
        Promotion type code.
        """
        return pulumi.get(self, "promo_type")


@pulumi.output_type
class GetSubscriptionsSubscriptionCollectionItemPaymentOptionResult(dict):
    def __init__(__self__, *,
                 credit_card_type: builtins.str,
                 email_address: builtins.str,
                 ext_billing_agreement_id: builtins.str,
                 first_name: builtins.str,
                 last_digits: builtins.str,
                 last_name: builtins.str,
                 name_on_card: builtins.str,
                 payment_method: builtins.str,
                 time_expiration: builtins.str,
                 wallet_instrument_id: builtins.str,
                 wallet_transaction_id: builtins.str):
        """
        :param builtins.str credit_card_type: Credit card type.
        :param builtins.str email_address: The email address of the paypal user.
        :param builtins.str ext_billing_agreement_id: Agreement id for the paypal account.
        :param builtins.str first_name: First name of the paypal user.
        :param builtins.str last_digits: Last four digits of the card.
        :param builtins.str last_name: Last name of the paypal user.
        :param builtins.str name_on_card: Name on the credit card.
        :param builtins.str payment_method: Payment method
        :param builtins.str time_expiration: Expired date of the credit card.
        :param builtins.str wallet_instrument_id: Wallet instrument internal id.
        :param builtins.str wallet_transaction_id: Wallet transaction id.
        """
        pulumi.set(__self__, "credit_card_type", credit_card_type)
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "ext_billing_agreement_id", ext_billing_agreement_id)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "last_digits", last_digits)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "name_on_card", name_on_card)
        pulumi.set(__self__, "payment_method", payment_method)
        pulumi.set(__self__, "time_expiration", time_expiration)
        pulumi.set(__self__, "wallet_instrument_id", wallet_instrument_id)
        pulumi.set(__self__, "wallet_transaction_id", wallet_transaction_id)

    @property
    @pulumi.getter(name="creditCardType")
    def credit_card_type(self) -> builtins.str:
        """
        Credit card type.
        """
        return pulumi.get(self, "credit_card_type")

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> builtins.str:
        """
        The email address of the paypal user.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="extBillingAgreementId")
    def ext_billing_agreement_id(self) -> builtins.str:
        """
        Agreement id for the paypal account.
        """
        return pulumi.get(self, "ext_billing_agreement_id")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> builtins.str:
        """
        First name of the paypal user.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastDigits")
    def last_digits(self) -> builtins.str:
        """
        Last four digits of the card.
        """
        return pulumi.get(self, "last_digits")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> builtins.str:
        """
        Last name of the paypal user.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="nameOnCard")
    def name_on_card(self) -> builtins.str:
        """
        Name on the credit card.
        """
        return pulumi.get(self, "name_on_card")

    @property
    @pulumi.getter(name="paymentMethod")
    def payment_method(self) -> builtins.str:
        """
        Payment method
        """
        return pulumi.get(self, "payment_method")

    @property
    @pulumi.getter(name="timeExpiration")
    def time_expiration(self) -> builtins.str:
        """
        Expired date of the credit card.
        """
        return pulumi.get(self, "time_expiration")

    @property
    @pulumi.getter(name="walletInstrumentId")
    def wallet_instrument_id(self) -> builtins.str:
        """
        Wallet instrument internal id.
        """
        return pulumi.get(self, "wallet_instrument_id")

    @property
    @pulumi.getter(name="walletTransactionId")
    def wallet_transaction_id(self) -> builtins.str:
        """
        Wallet transaction id.
        """
        return pulumi.get(self, "wallet_transaction_id")


@pulumi.output_type
class GetSubscriptionsSubscriptionCollectionItemSubscriptionResult(dict):
    def __init__(__self__, *,
                 account_type: builtins.str,
                 bill_to_cust_account_id: builtins.str,
                 billing_addresses: Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemSubscriptionBillingAddressResult'],
                 currency_code: builtins.str,
                 gsi_org_code: builtins.str,
                 id: builtins.str,
                 is_intent_to_pay: builtins.bool,
                 language_code: builtins.str,
                 organization_id: builtins.str,
                 payment_gateways: Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemSubscriptionPaymentGatewayResult'],
                 payment_options: Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemSubscriptionPaymentOptionResult'],
                 plan_type: builtins.str,
                 ship_to_cust_acct_role_id: builtins.str,
                 ship_to_cust_acct_site_id: builtins.str,
                 subscription_plan_number: builtins.str,
                 tax_infos: Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemSubscriptionTaxInfoResult'],
                 time_personal_to_corporate_conv: builtins.str,
                 time_plan_upgrade: builtins.str,
                 time_start: builtins.str,
                 upgrade_state: builtins.str,
                 upgrade_state_details: builtins.str):
        """
        :param builtins.str account_type: Account type.
        :param builtins.str bill_to_cust_account_id: Bill to customer Account id.
        :param Sequence['GetSubscriptionsSubscriptionCollectionItemSubscriptionBillingAddressArgs'] billing_addresses: Address details model.
        :param builtins.str currency_code: Currency code
        :param builtins.str gsi_org_code: GSI Subscription external code.
        :param builtins.str id: Subscription id identifier (OCID).
        :param builtins.bool is_intent_to_pay: Payment intension.
        :param builtins.str language_code: Language short code (en, de, hu, etc)
        :param builtins.str organization_id: GSI organization external identifier.
        :param Sequence['GetSubscriptionsSubscriptionCollectionItemSubscriptionPaymentGatewayArgs'] payment_gateways: Payment gateway details.
        :param Sequence['GetSubscriptionsSubscriptionCollectionItemSubscriptionPaymentOptionArgs'] payment_options: Payment option list of a subscription.
        :param builtins.str plan_type: Subscription plan type.
        :param builtins.str ship_to_cust_acct_role_id: Ship to customer account role.
        :param builtins.str ship_to_cust_acct_site_id: Ship to customer account site address id.
        :param builtins.str subscription_plan_number: Subscription plan number.
        :param Sequence['GetSubscriptionsSubscriptionCollectionItemSubscriptionTaxInfoArgs'] tax_infos: Tax details.
        :param builtins.str time_personal_to_corporate_conv: Date of upgrade/conversion when account type changed from PERSONAL to CORPORATE
        :param builtins.str time_plan_upgrade: Date of upgrade/conversion when planType changed from FREE_TIER to PAYG
        :param builtins.str time_start: Start date of the subscription.
        :param builtins.str upgrade_state: Status of the upgrade.
        :param builtins.str upgrade_state_details: This field is used to describe the Upgrade State in case of error (E.g. Upgrade failure caused by interfacing Tax details- TaxError)
        """
        pulumi.set(__self__, "account_type", account_type)
        pulumi.set(__self__, "bill_to_cust_account_id", bill_to_cust_account_id)
        pulumi.set(__self__, "billing_addresses", billing_addresses)
        pulumi.set(__self__, "currency_code", currency_code)
        pulumi.set(__self__, "gsi_org_code", gsi_org_code)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_intent_to_pay", is_intent_to_pay)
        pulumi.set(__self__, "language_code", language_code)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "payment_gateways", payment_gateways)
        pulumi.set(__self__, "payment_options", payment_options)
        pulumi.set(__self__, "plan_type", plan_type)
        pulumi.set(__self__, "ship_to_cust_acct_role_id", ship_to_cust_acct_role_id)
        pulumi.set(__self__, "ship_to_cust_acct_site_id", ship_to_cust_acct_site_id)
        pulumi.set(__self__, "subscription_plan_number", subscription_plan_number)
        pulumi.set(__self__, "tax_infos", tax_infos)
        pulumi.set(__self__, "time_personal_to_corporate_conv", time_personal_to_corporate_conv)
        pulumi.set(__self__, "time_plan_upgrade", time_plan_upgrade)
        pulumi.set(__self__, "time_start", time_start)
        pulumi.set(__self__, "upgrade_state", upgrade_state)
        pulumi.set(__self__, "upgrade_state_details", upgrade_state_details)

    @property
    @pulumi.getter(name="accountType")
    def account_type(self) -> builtins.str:
        """
        Account type.
        """
        return pulumi.get(self, "account_type")

    @property
    @pulumi.getter(name="billToCustAccountId")
    def bill_to_cust_account_id(self) -> builtins.str:
        """
        Bill to customer Account id.
        """
        return pulumi.get(self, "bill_to_cust_account_id")

    @property
    @pulumi.getter(name="billingAddresses")
    def billing_addresses(self) -> Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemSubscriptionBillingAddressResult']:
        """
        Address details model.
        """
        return pulumi.get(self, "billing_addresses")

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> builtins.str:
        """
        Currency code
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter(name="gsiOrgCode")
    def gsi_org_code(self) -> builtins.str:
        """
        GSI Subscription external code.
        """
        return pulumi.get(self, "gsi_org_code")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Subscription id identifier (OCID).
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isIntentToPay")
    def is_intent_to_pay(self) -> builtins.bool:
        """
        Payment intension.
        """
        return pulumi.get(self, "is_intent_to_pay")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> builtins.str:
        """
        Language short code (en, de, hu, etc)
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> builtins.str:
        """
        GSI organization external identifier.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="paymentGateways")
    def payment_gateways(self) -> Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemSubscriptionPaymentGatewayResult']:
        """
        Payment gateway details.
        """
        return pulumi.get(self, "payment_gateways")

    @property
    @pulumi.getter(name="paymentOptions")
    def payment_options(self) -> Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemSubscriptionPaymentOptionResult']:
        """
        Payment option list of a subscription.
        """
        return pulumi.get(self, "payment_options")

    @property
    @pulumi.getter(name="planType")
    def plan_type(self) -> builtins.str:
        """
        Subscription plan type.
        """
        return pulumi.get(self, "plan_type")

    @property
    @pulumi.getter(name="shipToCustAcctRoleId")
    def ship_to_cust_acct_role_id(self) -> builtins.str:
        """
        Ship to customer account role.
        """
        return pulumi.get(self, "ship_to_cust_acct_role_id")

    @property
    @pulumi.getter(name="shipToCustAcctSiteId")
    def ship_to_cust_acct_site_id(self) -> builtins.str:
        """
        Ship to customer account site address id.
        """
        return pulumi.get(self, "ship_to_cust_acct_site_id")

    @property
    @pulumi.getter(name="subscriptionPlanNumber")
    def subscription_plan_number(self) -> builtins.str:
        """
        Subscription plan number.
        """
        return pulumi.get(self, "subscription_plan_number")

    @property
    @pulumi.getter(name="taxInfos")
    def tax_infos(self) -> Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemSubscriptionTaxInfoResult']:
        """
        Tax details.
        """
        return pulumi.get(self, "tax_infos")

    @property
    @pulumi.getter(name="timePersonalToCorporateConv")
    def time_personal_to_corporate_conv(self) -> builtins.str:
        """
        Date of upgrade/conversion when account type changed from PERSONAL to CORPORATE
        """
        return pulumi.get(self, "time_personal_to_corporate_conv")

    @property
    @pulumi.getter(name="timePlanUpgrade")
    def time_plan_upgrade(self) -> builtins.str:
        """
        Date of upgrade/conversion when planType changed from FREE_TIER to PAYG
        """
        return pulumi.get(self, "time_plan_upgrade")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> builtins.str:
        """
        Start date of the subscription.
        """
        return pulumi.get(self, "time_start")

    @property
    @pulumi.getter(name="upgradeState")
    def upgrade_state(self) -> builtins.str:
        """
        Status of the upgrade.
        """
        return pulumi.get(self, "upgrade_state")

    @property
    @pulumi.getter(name="upgradeStateDetails")
    def upgrade_state_details(self) -> builtins.str:
        """
        This field is used to describe the Upgrade State in case of error (E.g. Upgrade failure caused by interfacing Tax details- TaxError)
        """
        return pulumi.get(self, "upgrade_state_details")


@pulumi.output_type
class GetSubscriptionsSubscriptionCollectionItemSubscriptionBillingAddressResult(dict):
    def __init__(__self__, *,
                 address_key: builtins.str,
                 city: builtins.str,
                 company_name: builtins.str,
                 contributor_class: builtins.str,
                 country: builtins.str,
                 county: builtins.str,
                 department_name: builtins.str,
                 email_address: builtins.str,
                 first_name: builtins.str,
                 internal_number: builtins.str,
                 job_title: builtins.str,
                 last_name: builtins.str,
                 line1: builtins.str,
                 line2: builtins.str,
                 line3: builtins.str,
                 line4: builtins.str,
                 middle_name: builtins.str,
                 municipal_inscription: builtins.str,
                 phone_country_code: builtins.str,
                 phone_number: builtins.str,
                 postal_code: builtins.str,
                 province: builtins.str,
                 state: builtins.str,
                 state_inscription: builtins.str,
                 street_name: builtins.str,
                 street_number: builtins.str):
        """
        :param builtins.str address_key: Address identifier.
        :param builtins.str city: Name of the city.
        :param builtins.str company_name: Name of the customer company.
        :param builtins.str contributor_class: Contributor class of the customer company.
        :param builtins.str country: Country of the address.
        :param builtins.str county: County of the address.
        :param builtins.str department_name: Department name of the customer company.
        :param builtins.str email_address: The email address of the paypal user.
        :param builtins.str first_name: First name of the paypal user.
        :param builtins.str internal_number: Internal number of the customer company.
        :param builtins.str job_title: Job title of the contact person.
        :param builtins.str last_name: Last name of the paypal user.
        :param builtins.str line1: Address line 1.
        :param builtins.str line2: Address line 2.
        :param builtins.str line3: Address line 3.
        :param builtins.str line4: Address line 4.
        :param builtins.str middle_name: Middle name of the contact person.
        :param builtins.str municipal_inscription: Municipal Inscription.
        :param builtins.str phone_country_code: Phone country code of the contact person.
        :param builtins.str phone_number: Phone number of the contact person.
        :param builtins.str postal_code: Post code of the address.
        :param builtins.str province: Province of the address.
        :param builtins.str state: State of the address.
        :param builtins.str state_inscription: State Inscription.
        :param builtins.str street_name: Street name of the address.
        :param builtins.str street_number: Street number of the address.
        """
        pulumi.set(__self__, "address_key", address_key)
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "company_name", company_name)
        pulumi.set(__self__, "contributor_class", contributor_class)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "county", county)
        pulumi.set(__self__, "department_name", department_name)
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "internal_number", internal_number)
        pulumi.set(__self__, "job_title", job_title)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "line1", line1)
        pulumi.set(__self__, "line2", line2)
        pulumi.set(__self__, "line3", line3)
        pulumi.set(__self__, "line4", line4)
        pulumi.set(__self__, "middle_name", middle_name)
        pulumi.set(__self__, "municipal_inscription", municipal_inscription)
        pulumi.set(__self__, "phone_country_code", phone_country_code)
        pulumi.set(__self__, "phone_number", phone_number)
        pulumi.set(__self__, "postal_code", postal_code)
        pulumi.set(__self__, "province", province)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_inscription", state_inscription)
        pulumi.set(__self__, "street_name", street_name)
        pulumi.set(__self__, "street_number", street_number)

    @property
    @pulumi.getter(name="addressKey")
    def address_key(self) -> builtins.str:
        """
        Address identifier.
        """
        return pulumi.get(self, "address_key")

    @property
    @pulumi.getter
    def city(self) -> builtins.str:
        """
        Name of the city.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> builtins.str:
        """
        Name of the customer company.
        """
        return pulumi.get(self, "company_name")

    @property
    @pulumi.getter(name="contributorClass")
    def contributor_class(self) -> builtins.str:
        """
        Contributor class of the customer company.
        """
        return pulumi.get(self, "contributor_class")

    @property
    @pulumi.getter
    def country(self) -> builtins.str:
        """
        Country of the address.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def county(self) -> builtins.str:
        """
        County of the address.
        """
        return pulumi.get(self, "county")

    @property
    @pulumi.getter(name="departmentName")
    def department_name(self) -> builtins.str:
        """
        Department name of the customer company.
        """
        return pulumi.get(self, "department_name")

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> builtins.str:
        """
        The email address of the paypal user.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> builtins.str:
        """
        First name of the paypal user.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="internalNumber")
    def internal_number(self) -> builtins.str:
        """
        Internal number of the customer company.
        """
        return pulumi.get(self, "internal_number")

    @property
    @pulumi.getter(name="jobTitle")
    def job_title(self) -> builtins.str:
        """
        Job title of the contact person.
        """
        return pulumi.get(self, "job_title")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> builtins.str:
        """
        Last name of the paypal user.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def line1(self) -> builtins.str:
        """
        Address line 1.
        """
        return pulumi.get(self, "line1")

    @property
    @pulumi.getter
    def line2(self) -> builtins.str:
        """
        Address line 2.
        """
        return pulumi.get(self, "line2")

    @property
    @pulumi.getter
    def line3(self) -> builtins.str:
        """
        Address line 3.
        """
        return pulumi.get(self, "line3")

    @property
    @pulumi.getter
    def line4(self) -> builtins.str:
        """
        Address line 4.
        """
        return pulumi.get(self, "line4")

    @property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> builtins.str:
        """
        Middle name of the contact person.
        """
        return pulumi.get(self, "middle_name")

    @property
    @pulumi.getter(name="municipalInscription")
    def municipal_inscription(self) -> builtins.str:
        """
        Municipal Inscription.
        """
        return pulumi.get(self, "municipal_inscription")

    @property
    @pulumi.getter(name="phoneCountryCode")
    def phone_country_code(self) -> builtins.str:
        """
        Phone country code of the contact person.
        """
        return pulumi.get(self, "phone_country_code")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> builtins.str:
        """
        Phone number of the contact person.
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> builtins.str:
        """
        Post code of the address.
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def province(self) -> builtins.str:
        """
        Province of the address.
        """
        return pulumi.get(self, "province")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        State of the address.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateInscription")
    def state_inscription(self) -> builtins.str:
        """
        State Inscription.
        """
        return pulumi.get(self, "state_inscription")

    @property
    @pulumi.getter(name="streetName")
    def street_name(self) -> builtins.str:
        """
        Street name of the address.
        """
        return pulumi.get(self, "street_name")

    @property
    @pulumi.getter(name="streetNumber")
    def street_number(self) -> builtins.str:
        """
        Street number of the address.
        """
        return pulumi.get(self, "street_number")


@pulumi.output_type
class GetSubscriptionsSubscriptionCollectionItemSubscriptionPaymentGatewayResult(dict):
    def __init__(__self__, *,
                 merchant_defined_datas: Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemSubscriptionPaymentGatewayMerchantDefinedDataResult']):
        """
        :param Sequence['GetSubscriptionsSubscriptionCollectionItemSubscriptionPaymentGatewayMerchantDefinedDataArgs'] merchant_defined_datas: Merchant details.
        """
        pulumi.set(__self__, "merchant_defined_datas", merchant_defined_datas)

    @property
    @pulumi.getter(name="merchantDefinedDatas")
    def merchant_defined_datas(self) -> Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemSubscriptionPaymentGatewayMerchantDefinedDataResult']:
        """
        Merchant details.
        """
        return pulumi.get(self, "merchant_defined_datas")


@pulumi.output_type
class GetSubscriptionsSubscriptionCollectionItemSubscriptionPaymentGatewayMerchantDefinedDataResult(dict):
    def __init__(__self__, *,
                 cloud_account_name: builtins.str,
                 promo_type: builtins.str):
        """
        :param builtins.str cloud_account_name: Cloud account name.
        :param builtins.str promo_type: Promotion type code.
        """
        pulumi.set(__self__, "cloud_account_name", cloud_account_name)
        pulumi.set(__self__, "promo_type", promo_type)

    @property
    @pulumi.getter(name="cloudAccountName")
    def cloud_account_name(self) -> builtins.str:
        """
        Cloud account name.
        """
        return pulumi.get(self, "cloud_account_name")

    @property
    @pulumi.getter(name="promoType")
    def promo_type(self) -> builtins.str:
        """
        Promotion type code.
        """
        return pulumi.get(self, "promo_type")


@pulumi.output_type
class GetSubscriptionsSubscriptionCollectionItemSubscriptionPaymentOptionResult(dict):
    def __init__(__self__, *,
                 credit_card_type: builtins.str,
                 email_address: builtins.str,
                 ext_billing_agreement_id: builtins.str,
                 first_name: builtins.str,
                 last_digits: builtins.str,
                 last_name: builtins.str,
                 name_on_card: builtins.str,
                 payment_method: builtins.str,
                 time_expiration: builtins.str,
                 wallet_instrument_id: builtins.str,
                 wallet_transaction_id: builtins.str):
        """
        :param builtins.str credit_card_type: Credit card type.
        :param builtins.str email_address: The email address of the paypal user.
        :param builtins.str ext_billing_agreement_id: Agreement id for the paypal account.
        :param builtins.str first_name: First name of the paypal user.
        :param builtins.str last_digits: Last four digits of the card.
        :param builtins.str last_name: Last name of the paypal user.
        :param builtins.str name_on_card: Name on the credit card.
        :param builtins.str payment_method: Payment method
        :param builtins.str time_expiration: Expired date of the credit card.
        :param builtins.str wallet_instrument_id: Wallet instrument internal id.
        :param builtins.str wallet_transaction_id: Wallet transaction id.
        """
        pulumi.set(__self__, "credit_card_type", credit_card_type)
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "ext_billing_agreement_id", ext_billing_agreement_id)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "last_digits", last_digits)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "name_on_card", name_on_card)
        pulumi.set(__self__, "payment_method", payment_method)
        pulumi.set(__self__, "time_expiration", time_expiration)
        pulumi.set(__self__, "wallet_instrument_id", wallet_instrument_id)
        pulumi.set(__self__, "wallet_transaction_id", wallet_transaction_id)

    @property
    @pulumi.getter(name="creditCardType")
    def credit_card_type(self) -> builtins.str:
        """
        Credit card type.
        """
        return pulumi.get(self, "credit_card_type")

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> builtins.str:
        """
        The email address of the paypal user.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="extBillingAgreementId")
    def ext_billing_agreement_id(self) -> builtins.str:
        """
        Agreement id for the paypal account.
        """
        return pulumi.get(self, "ext_billing_agreement_id")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> builtins.str:
        """
        First name of the paypal user.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastDigits")
    def last_digits(self) -> builtins.str:
        """
        Last four digits of the card.
        """
        return pulumi.get(self, "last_digits")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> builtins.str:
        """
        Last name of the paypal user.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="nameOnCard")
    def name_on_card(self) -> builtins.str:
        """
        Name on the credit card.
        """
        return pulumi.get(self, "name_on_card")

    @property
    @pulumi.getter(name="paymentMethod")
    def payment_method(self) -> builtins.str:
        """
        Payment method
        """
        return pulumi.get(self, "payment_method")

    @property
    @pulumi.getter(name="timeExpiration")
    def time_expiration(self) -> builtins.str:
        """
        Expired date of the credit card.
        """
        return pulumi.get(self, "time_expiration")

    @property
    @pulumi.getter(name="walletInstrumentId")
    def wallet_instrument_id(self) -> builtins.str:
        """
        Wallet instrument internal id.
        """
        return pulumi.get(self, "wallet_instrument_id")

    @property
    @pulumi.getter(name="walletTransactionId")
    def wallet_transaction_id(self) -> builtins.str:
        """
        Wallet transaction id.
        """
        return pulumi.get(self, "wallet_transaction_id")


@pulumi.output_type
class GetSubscriptionsSubscriptionCollectionItemSubscriptionTaxInfoResult(dict):
    def __init__(__self__, *,
                 no_tax_reason_code: builtins.str,
                 no_tax_reason_code_details: builtins.str,
                 tax_cnpj: builtins.str,
                 tax_payer_id: builtins.str,
                 tax_reg_number: builtins.str):
        """
        :param builtins.str no_tax_reason_code: Tax exemption reason code.
        :param builtins.str no_tax_reason_code_details: Tax exemption reason description.
        :param builtins.str tax_cnpj: Brazilian companies' CNPJ number.
        :param builtins.str tax_payer_id: Tay payer identifier.
        :param builtins.str tax_reg_number: Tax registration number.
        """
        pulumi.set(__self__, "no_tax_reason_code", no_tax_reason_code)
        pulumi.set(__self__, "no_tax_reason_code_details", no_tax_reason_code_details)
        pulumi.set(__self__, "tax_cnpj", tax_cnpj)
        pulumi.set(__self__, "tax_payer_id", tax_payer_id)
        pulumi.set(__self__, "tax_reg_number", tax_reg_number)

    @property
    @pulumi.getter(name="noTaxReasonCode")
    def no_tax_reason_code(self) -> builtins.str:
        """
        Tax exemption reason code.
        """
        return pulumi.get(self, "no_tax_reason_code")

    @property
    @pulumi.getter(name="noTaxReasonCodeDetails")
    def no_tax_reason_code_details(self) -> builtins.str:
        """
        Tax exemption reason description.
        """
        return pulumi.get(self, "no_tax_reason_code_details")

    @property
    @pulumi.getter(name="taxCnpj")
    def tax_cnpj(self) -> builtins.str:
        """
        Brazilian companies' CNPJ number.
        """
        return pulumi.get(self, "tax_cnpj")

    @property
    @pulumi.getter(name="taxPayerId")
    def tax_payer_id(self) -> builtins.str:
        """
        Tay payer identifier.
        """
        return pulumi.get(self, "tax_payer_id")

    @property
    @pulumi.getter(name="taxRegNumber")
    def tax_reg_number(self) -> builtins.str:
        """
        Tax registration number.
        """
        return pulumi.get(self, "tax_reg_number")


@pulumi.output_type
class GetSubscriptionsSubscriptionCollectionItemTaxInfoResult(dict):
    def __init__(__self__, *,
                 giro: builtins.str,
                 no_tax_reason_code: builtins.str,
                 no_tax_reason_code_details: builtins.str,
                 tax_cnpj: builtins.str,
                 tax_payer_id: builtins.str,
                 tax_reg_number: builtins.str):
        """
        :param builtins.str giro: Companies' GIRO code
        :param builtins.str no_tax_reason_code: Tax exemption reason code.
        :param builtins.str no_tax_reason_code_details: Tax exemption reason description.
        :param builtins.str tax_cnpj: Brazilian companies' CNPJ number.
        :param builtins.str tax_payer_id: Tay payer identifier.
        :param builtins.str tax_reg_number: Tax registration number.
        """
        pulumi.set(__self__, "giro", giro)
        pulumi.set(__self__, "no_tax_reason_code", no_tax_reason_code)
        pulumi.set(__self__, "no_tax_reason_code_details", no_tax_reason_code_details)
        pulumi.set(__self__, "tax_cnpj", tax_cnpj)
        pulumi.set(__self__, "tax_payer_id", tax_payer_id)
        pulumi.set(__self__, "tax_reg_number", tax_reg_number)

    @property
    @pulumi.getter
    def giro(self) -> builtins.str:
        """
        Companies' GIRO code
        """
        return pulumi.get(self, "giro")

    @property
    @pulumi.getter(name="noTaxReasonCode")
    def no_tax_reason_code(self) -> builtins.str:
        """
        Tax exemption reason code.
        """
        return pulumi.get(self, "no_tax_reason_code")

    @property
    @pulumi.getter(name="noTaxReasonCodeDetails")
    def no_tax_reason_code_details(self) -> builtins.str:
        """
        Tax exemption reason description.
        """
        return pulumi.get(self, "no_tax_reason_code_details")

    @property
    @pulumi.getter(name="taxCnpj")
    def tax_cnpj(self) -> builtins.str:
        """
        Brazilian companies' CNPJ number.
        """
        return pulumi.get(self, "tax_cnpj")

    @property
    @pulumi.getter(name="taxPayerId")
    def tax_payer_id(self) -> builtins.str:
        """
        Tay payer identifier.
        """
        return pulumi.get(self, "tax_payer_id")

    @property
    @pulumi.getter(name="taxRegNumber")
    def tax_reg_number(self) -> builtins.str:
        """
        Tax registration number.
        """
        return pulumi.get(self, "tax_reg_number")


