# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.7.2501
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.general_statistics import GeneralStatistics
from vrt_lss_studio.models.quality import Quality
from vrt_lss_studio.models.table_data_stats import TableDataStats
from vrt_lss_studio.models.task_statistics import TaskStatistics
from vrt_lss_studio.models.unplanned_items import UnplannedItems
from typing import Optional, Set
from typing_extensions import Self

class ExperimentStatistics(BaseModel):
    """
    Experiment statistics.
    """ # noqa: E501
    indicators: Annotated[List[Annotated[str, Field(min_length=2, strict=True, max_length=256)]], Field(min_length=0, max_length=100)] = Field(description="A list of indicators.")
    total_statistics: GeneralStatistics
    task_statistics: Optional[TaskStatistics]
    quality: Optional[Quality]
    data_statistics: TableDataStats
    unplanned_items: Optional[UnplannedItems] = None
    __properties: ClassVar[List[str]] = ["indicators", "total_statistics", "task_statistics", "quality", "data_statistics", "unplanned_items"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExperimentStatistics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of total_statistics
        if self.total_statistics:
            _dict['total_statistics'] = self.total_statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of task_statistics
        if self.task_statistics:
            _dict['task_statistics'] = self.task_statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of quality
        if self.quality:
            _dict['quality'] = self.quality.to_dict()
        # override the default output from pydantic by calling `to_dict()` of data_statistics
        if self.data_statistics:
            _dict['data_statistics'] = self.data_statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of unplanned_items
        if self.unplanned_items:
            _dict['unplanned_items'] = self.unplanned_items.to_dict()
        # set to None if task_statistics (nullable) is None
        # and model_fields_set contains the field
        if self.task_statistics is None and "task_statistics" in self.model_fields_set:
            _dict['task_statistics'] = None

        # set to None if quality (nullable) is None
        # and model_fields_set contains the field
        if self.quality is None and "quality" in self.model_fields_set:
            _dict['quality'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExperimentStatistics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "indicators": obj.get("indicators"),
            "total_statistics": GeneralStatistics.from_dict(obj["total_statistics"]) if obj.get("total_statistics") is not None else None,
            "task_statistics": TaskStatistics.from_dict(obj["task_statistics"]) if obj.get("task_statistics") is not None else None,
            "quality": Quality.from_dict(obj["quality"]) if obj.get("quality") is not None else None,
            "data_statistics": TableDataStats.from_dict(obj["data_statistics"]) if obj.get("data_statistics") is not None else None,
            "unplanned_items": UnplannedItems.from_dict(obj["unplanned_items"]) if obj.get("unplanned_items") is not None else None
        })
        return _obj


