# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.7.2501
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from vrt_lss_studio.models.performer_tariff_constraint import PerformerTariffConstraint
from typing import Optional, Set
from typing_extensions import Self

class PerformerTariff(BaseModel):
    """
    The tariff determines the cost and time limits of the shift.
    """ # noqa: E501
    cost_per_shift: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0.001)], Annotated[int, Field(le=1000000, strict=True, ge=1)]]] = Field(default=0.001, description="Price for using the shift, monetary unit.")
    constraints: Optional[Annotated[List[PerformerTariffConstraint], Field(min_length=1, max_length=100)]] = Field(default=None, description="List of components of the tariff.")
    max_penalty_cost: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=None, description="Max sum of penalties for performer or transport using this shift, monetary unit. If not specified or null, the performer can violate without restrictions. ")
    __properties: ClassVar[List[str]] = ["cost_per_shift", "constraints", "max_penalty_cost"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PerformerTariff from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in constraints (list)
        _items = []
        if self.constraints:
            for _item in self.constraints:
                if _item:
                    _items.append(_item.to_dict())
            _dict['constraints'] = _items
        # set to None if max_penalty_cost (nullable) is None
        # and model_fields_set contains the field
        if self.max_penalty_cost is None and "max_penalty_cost" in self.model_fields_set:
            _dict['max_penalty_cost'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PerformerTariff from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cost_per_shift": obj.get("cost_per_shift") if obj.get("cost_per_shift") is not None else 0.001,
            "constraints": [PerformerTariffConstraint.from_dict(_item) for _item in obj["constraints"]] if obj.get("constraints") is not None else None,
            "max_penalty_cost": obj.get("max_penalty_cost")
        })
        return _obj


