# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.7.2501
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.capacity import Capacity
from typing import Optional, Set
from typing_extensions import Self

class TransportLimits(BaseModel):
    """
    Transport load limits. 
    """ # noqa: E501
    max_boxes: Optional[Annotated[int, Field(le=100, strict=True, ge=0)]] = Field(default=None, description="Limit of the number of transports's unique locations in one trip. If not specified or null, number of using boxes is not limited. The limit should not exceed the number of boxes. ")
    max_capacity: Optional[Capacity] = None
    __properties: ClassVar[List[str]] = ["max_boxes", "max_capacity"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TransportLimits from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of max_capacity
        if self.max_capacity:
            _dict['max_capacity'] = self.max_capacity.to_dict()
        # set to None if max_boxes (nullable) is None
        # and model_fields_set contains the field
        if self.max_boxes is None and "max_boxes" in self.model_fields_set:
            _dict['max_boxes'] = None

        # set to None if max_capacity (nullable) is None
        # and model_fields_set contains the field
        if self.max_capacity is None and "max_capacity" in self.model_fields_set:
            _dict['max_capacity'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TransportLimits from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "max_boxes": obj.get("max_boxes"),
            "max_capacity": Capacity.from_dict(obj["max_capacity"]) if obj.get("max_capacity") is not None else None
        })
        return _obj


