# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.7.2501
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.break_rules import BreakRules
from vrt_lss_studio.models.rest_rules import RestRules
from typing import Optional, Set
from typing_extensions import Self

class WorkAndRestRules(BaseModel):
    """
    Work and rest rules. 
    """ # noqa: E501
    rest_rules: Optional[RestRules] = None
    break_rules: Optional[BreakRules] = None
    reset_location_keys: Optional[Annotated[List[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]], Field(min_length=0, max_length=15001)]] = Field(default=None, description="A list of locations keys in which the counters for breaks and rest are reset when located.")
    ignore_location_keys: Optional[Annotated[List[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]], Field(min_length=0, max_length=15001)]] = Field(default=None, description="A list of location keys whose stay is not taken into account in the total execution time counter.")
    __properties: ClassVar[List[str]] = ["rest_rules", "break_rules", "reset_location_keys", "ignore_location_keys"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkAndRestRules from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of rest_rules
        if self.rest_rules:
            _dict['rest_rules'] = self.rest_rules.to_dict()
        # override the default output from pydantic by calling `to_dict()` of break_rules
        if self.break_rules:
            _dict['break_rules'] = self.break_rules.to_dict()
        # set to None if rest_rules (nullable) is None
        # and model_fields_set contains the field
        if self.rest_rules is None and "rest_rules" in self.model_fields_set:
            _dict['rest_rules'] = None

        # set to None if break_rules (nullable) is None
        # and model_fields_set contains the field
        if self.break_rules is None and "break_rules" in self.model_fields_set:
            _dict['break_rules'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkAndRestRules from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "rest_rules": RestRules.from_dict(obj["rest_rules"]) if obj.get("rest_rules") is not None else None,
            "break_rules": BreakRules.from_dict(obj["break_rules"]) if obj.get("break_rules") is not None else None,
            "reset_location_keys": obj.get("reset_location_keys"),
            "ignore_location_keys": obj.get("ignore_location_keys")
        })
        return _obj


