"use strict";
(self["webpackChunktvb_ext_xircuits"] = self["webpackChunktvb_ext_xircuits"] || []).push([["vendors-node_modules_projectstorm_react-diagrams-routing_dist_index_js"],{

/***/ "./node_modules/@projectstorm/react-diagrams-routing/dist/dagre/DagreEngine.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-routing/dist/dagre/DagreEngine.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DagreEngine = void 0;
const react_diagrams_core_1 = __webpack_require__(/*! @projectstorm/react-diagrams-core */ "./node_modules/@projectstorm/react-diagrams-core/dist/index.js");
const dagre = __webpack_require__(/*! dagre */ "webpack/sharing/consume/default/dagre/dagre");
const _ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const geometry_1 = __webpack_require__(/*! @projectstorm/geometry */ "./node_modules/@projectstorm/geometry/dist/index.js");
class DagreEngine {
    constructor(options = {}) {
        this.options = options;
    }
    redistribute(model) {
        // Create a new directed graph
        var g = new dagre.graphlib.Graph({
            multigraph: true,
            compound: true
        });
        g.setGraph(this.options.graph || {});
        g.setDefaultEdgeLabel(function () {
            return {};
        });
        // set nodes
        _.forEach(model.getNodes(), (node) => {
            g.setNode(node.getID(), { width: node.width, height: node.height });
        });
        _.forEach(model.getLinks(), (link) => {
            // set edges
            if (link.getSourcePort() && link.getTargetPort()) {
                g.setEdge({
                    v: link.getSourcePort().getNode().getID(),
                    w: link.getTargetPort().getNode().getID(),
                    name: link.getID()
                });
            }
        });
        // layout the graph
        dagre.layout(g);
        g.nodes().forEach((v) => {
            const node = g.node(v);
            model.getNode(v).setPosition(node.x - node.width / 2, node.y - node.height / 2);
        });
        // also include links?
        if (this.options.includeLinks) {
            g.edges().forEach((e) => {
                const edge = g.edge(e);
                const link = model.getLink(e.name);
                const points = [link.getFirstPoint()];
                for (let i = 1; i < edge.points.length - 1; i++) {
                    points.push(new react_diagrams_core_1.PointModel({ link: link, position: new geometry_1.Point(edge.points[i].x, edge.points[i].y) }));
                }
                link.setPoints(points.concat(link.getLastPoint()));
            });
        }
    }
}
exports.DagreEngine = DagreEngine;


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-routing/dist/engine/PathFinding.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-routing/dist/engine/PathFinding.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PathFinding = void 0;
const PF = __webpack_require__(/*! pathfinding */ "webpack/sharing/consume/default/pathfinding/pathfinding");
/*
it can be very expensive to calculate routes when every single pixel on the canvas
is individually represented. Using the factor below, we combine values in order
to achieve the best trade-off between accuracy and performance.
*/
const pathFinderInstance = new PF.JumpPointFinder({
    heuristic: PF.Heuristic.manhattan,
    diagonalMovement: PF.DiagonalMovement.Never
});
class PathFinding {
    constructor(factory) {
        this.instance = pathFinderInstance;
        this.factory = factory;
    }
    /**
     * Taking as argument a fully unblocked walking matrix, this method
     * finds a direct path from point A to B.
     */
    calculateDirectPath(from, to) {
        const matrix = this.factory.getCanvasMatrix();
        const grid = new PF.Grid(matrix);
        return pathFinderInstance.findPath(this.factory.translateRoutingX(Math.floor(from.getX() / this.factory.ROUTING_SCALING_FACTOR)), this.factory.translateRoutingY(Math.floor(from.getY() / this.factory.ROUTING_SCALING_FACTOR)), this.factory.translateRoutingX(Math.floor(to.getX() / this.factory.ROUTING_SCALING_FACTOR)), this.factory.translateRoutingY(Math.floor(to.getY() / this.factory.ROUTING_SCALING_FACTOR)), grid);
    }
    /**
     * Using @link{#calculateDirectPath}'s result as input, we here
     * determine the first walkable point found in the matrix that includes
     * blocked paths.
     */
    calculateLinkStartEndCoords(matrix, path) {
        const startIndex = path.findIndex((point) => {
            if (matrix[point[1]])
                return matrix[point[1]][point[0]] === 0;
            else
                return false;
        });
        const endIndex = path.length -
            1 -
            path
                .slice()
                .reverse()
                .findIndex((point) => {
                if (matrix[point[1]])
                    return matrix[point[1]][point[0]] === 0;
                else
                    return false;
            });
        // are we trying to create a path exclusively through blocked areas?
        // if so, let's fallback to the linear routing
        if (startIndex === -1 || endIndex === -1) {
            return undefined;
        }
        const pathToStart = path.slice(0, startIndex);
        const pathToEnd = path.slice(endIndex);
        return {
            start: {
                x: path[startIndex][0],
                y: path[startIndex][1]
            },
            end: {
                x: path[endIndex][0],
                y: path[endIndex][1]
            },
            pathToStart,
            pathToEnd
        };
    }
    /**
     * Puts everything together: merges the paths from/to the centre of the ports,
     * with the path calculated around other elements.
     */
    calculateDynamicPath(routingMatrix, start, end, pathToStart, pathToEnd) {
        // generate the path based on the matrix with obstacles
        const grid = new PF.Grid(routingMatrix);
        const dynamicPath = pathFinderInstance.findPath(start.x, start.y, end.x, end.y, grid);
        // aggregate everything to have the calculated path ready for rendering
        const pathCoords = pathToStart
            .concat(dynamicPath, pathToEnd)
            .map((coords) => [
            this.factory.translateRoutingX(coords[0], true),
            this.factory.translateRoutingY(coords[1], true)
        ]);
        return PF.Util.compressPath(pathCoords);
    }
}
exports.PathFinding = PathFinding;


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-routing/dist/index.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-routing/dist/index.js ***!
  \*************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./link/PathFindingLinkFactory */ "./node_modules/@projectstorm/react-diagrams-routing/dist/link/PathFindingLinkFactory.js"), exports);
__exportStar(__webpack_require__(/*! ./link/PathFindingLinkModel */ "./node_modules/@projectstorm/react-diagrams-routing/dist/link/PathFindingLinkModel.js"), exports);
__exportStar(__webpack_require__(/*! ./link/PathFindingLinkWidget */ "./node_modules/@projectstorm/react-diagrams-routing/dist/link/PathFindingLinkWidget.js"), exports);
__exportStar(__webpack_require__(/*! ./link/RightAngleLinkWidget */ "./node_modules/@projectstorm/react-diagrams-routing/dist/link/RightAngleLinkWidget.js"), exports);
__exportStar(__webpack_require__(/*! ./link/RightAngleLinkFactory */ "./node_modules/@projectstorm/react-diagrams-routing/dist/link/RightAngleLinkFactory.js"), exports);
__exportStar(__webpack_require__(/*! ./link/RightAngleLinkModel */ "./node_modules/@projectstorm/react-diagrams-routing/dist/link/RightAngleLinkModel.js"), exports);
__exportStar(__webpack_require__(/*! ./engine/PathFinding */ "./node_modules/@projectstorm/react-diagrams-routing/dist/engine/PathFinding.js"), exports);
__exportStar(__webpack_require__(/*! ./dagre/DagreEngine */ "./node_modules/@projectstorm/react-diagrams-routing/dist/dagre/DagreEngine.js"), exports);


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-routing/dist/link/PathFindingLinkFactory.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-routing/dist/link/PathFindingLinkFactory.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PathFindingLinkFactory = void 0;
const React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
const PathFindingLinkModel_1 = __webpack_require__(/*! ./PathFindingLinkModel */ "./node_modules/@projectstorm/react-diagrams-routing/dist/link/PathFindingLinkModel.js");
const PathFindingLinkWidget_1 = __webpack_require__(/*! ./PathFindingLinkWidget */ "./node_modules/@projectstorm/react-diagrams-routing/dist/link/PathFindingLinkWidget.js");
const _ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const Path = __webpack_require__(/*! paths-js/path */ "./node_modules/paths-js/path.js");
const react_diagrams_defaults_1 = __webpack_require__(/*! @projectstorm/react-diagrams-defaults */ "webpack/sharing/consume/default/@projectstorm/react-diagrams-defaults/@projectstorm/react-diagrams-defaults");
const react_canvas_core_1 = __webpack_require__(/*! @projectstorm/react-canvas-core */ "webpack/sharing/consume/default/@projectstorm/react-canvas-core/@projectstorm/react-canvas-core?4cd6");
class PathFindingLinkFactory extends react_diagrams_defaults_1.DefaultLinkFactory {
    constructor() {
        super(PathFindingLinkFactory.NAME);
        this.ROUTING_SCALING_FACTOR = 5;
        // calculated only when smart routing is active
        this.canvasMatrix = [];
        this.routingMatrix = [];
        // used when at least one element has negative coordinates
        this.hAdjustmentFactor = 0;
        this.vAdjustmentFactor = 0;
        /**
         * Despite being a long method, we simply iterate over all three collections (nodes, ports and points)
         * to find the highest X and Y dimensions, so we can build the matrix large enough to contain all elements.
         */
        this.calculateMatrixDimensions = () => {
            const allNodesCoords = _.values(this.engine.getModel().getNodes()).map((item) => ({
                x: item.getX(),
                width: item.width,
                y: item.getY(),
                height: item.height
            }));
            const allLinks = _.values(this.engine.getModel().getLinks());
            const allPortsCoords = _.flatMap(allLinks.map((link) => [link.getSourcePort(), link.getTargetPort()]))
                .filter((port) => port !== null)
                .map((item) => ({
                x: item.getX(),
                width: item.width,
                y: item.getY(),
                height: item.height
            }));
            const allPointsCoords = _.flatMap(allLinks.map((link) => link.getPoints())).map((item) => ({
                // points don't have width/height, so let's just use 0
                x: item.getX(),
                width: 0,
                y: item.getY(),
                height: 0
            }));
            const sumProps = (object, props) => _.reduce(props, (acc, prop) => acc + _.get(object, prop, 0), 0);
            const canvas = this.engine.getCanvas();
            const concatedCoords = _.concat(allNodesCoords, allPortsCoords, allPointsCoords);
            const minX = Math.floor(Math.min(_.get(_.minBy(concatedCoords, 'x'), 'x', 0), 0) / this.ROUTING_SCALING_FACTOR) *
                this.ROUTING_SCALING_FACTOR;
            const maxXElement = _.maxBy(concatedCoords, (item) => sumProps(item, ['x', 'width']));
            const maxX = Math.max(sumProps(maxXElement, ['x', 'width']), canvas.offsetWidth);
            const minYCoords = _.minBy(concatedCoords, 'y');
            const minY = Math.floor(Math.min(_.get(minYCoords, 'y', 0), 0) / this.ROUTING_SCALING_FACTOR) * this.ROUTING_SCALING_FACTOR;
            const maxYElement = _.maxBy(concatedCoords, (item) => sumProps(item, ['y', 'height']));
            const maxY = Math.max(sumProps(maxYElement, ['y', 'height']), canvas.offsetHeight);
            return {
                width: Math.ceil(Math.abs(minX) + maxX),
                hAdjustmentFactor: Math.abs(minX) / this.ROUTING_SCALING_FACTOR + 1,
                height: Math.ceil(Math.abs(minY) + maxY),
                vAdjustmentFactor: Math.abs(minY) / this.ROUTING_SCALING_FACTOR + 1
            };
        };
        /**
         * Updates (by reference) where nodes will be drawn on the matrix passed in.
         */
        this.markNodes = (matrix) => {
            _.values(this.engine.getModel().getNodes()).forEach((node) => {
                const startX = Math.floor(node.getX() / this.ROUTING_SCALING_FACTOR);
                const endX = Math.ceil((node.getX() + node.width) / this.ROUTING_SCALING_FACTOR);
                const startY = Math.floor(node.getY() / this.ROUTING_SCALING_FACTOR);
                const endY = Math.ceil((node.getY() + node.height) / this.ROUTING_SCALING_FACTOR);
                for (let x = startX - 1; x <= endX + 1; x++) {
                    for (let y = startY - 1; y < endY + 1; y++) {
                        this.markMatrixPoint(matrix, this.translateRoutingX(x), this.translateRoutingY(y));
                    }
                }
            });
        };
        /**
         * Updates (by reference) where ports will be drawn on the matrix passed in.
         */
        this.markPorts = (matrix) => {
            const allElements = _.flatMap(_.values(this.engine.getModel().getLinks()).map((link) => [].concat(link.getSourcePort(), link.getTargetPort())));
            allElements
                .filter((port) => port !== null)
                .forEach((port) => {
                const startX = Math.floor(port.x / this.ROUTING_SCALING_FACTOR);
                const endX = Math.ceil((port.x + port.width) / this.ROUTING_SCALING_FACTOR);
                const startY = Math.floor(port.y / this.ROUTING_SCALING_FACTOR);
                const endY = Math.ceil((port.y + port.height) / this.ROUTING_SCALING_FACTOR);
                for (let x = startX - 1; x <= endX + 1; x++) {
                    for (let y = startY - 1; y < endY + 1; y++) {
                        this.markMatrixPoint(matrix, this.translateRoutingX(x), this.translateRoutingY(y));
                    }
                }
            });
        };
        this.markMatrixPoint = (matrix, x, y) => {
            if (matrix[y] !== undefined && matrix[y][x] !== undefined) {
                matrix[y][x] = 1;
            }
        };
    }
    setDiagramEngine(engine) {
        super.setDiagramEngine(engine);
        // listen for drag changes
        engine.getStateMachine().registerListener({
            stateChanged: (event) => {
                if (event.newState instanceof react_canvas_core_1.AbstractDisplacementState) {
                    const deRegister = engine.getActionEventBus().registerAction(new react_canvas_core_1.Action({
                        type: react_canvas_core_1.InputType.MOUSE_UP,
                        fire: () => {
                            this.calculateRoutingMatrix();
                            engine.repaintCanvas();
                            deRegister();
                        }
                    }));
                }
            }
        });
        this.listener = engine.registerListener({
            canvasReady: () => {
                _.defer(() => {
                    this.calculateRoutingMatrix();
                    engine.repaintCanvas();
                });
            }
        });
    }
    setFactoryBank(bank) {
        super.setFactoryBank(bank);
        if (!bank && this.listener) {
            this.listener.deregister();
        }
    }
    generateReactWidget(event) {
        return React.createElement(PathFindingLinkWidget_1.PathFindingLinkWidget, { diagramEngine: this.engine, link: event.model, factory: this });
    }
    generateModel(event) {
        return new PathFindingLinkModel_1.PathFindingLinkModel();
    }
    /**
     * A representation of the canvas in the following format:
     *
     * +-----------------+
     * | 0 0 0 0 0 0 0 0 |
     * | 0 0 0 0 0 0 0 0 |
     * | 0 0 0 0 0 0 0 0 |
     * | 0 0 0 0 0 0 0 0 |
     * | 0 0 0 0 0 0 0 0 |
     * +-----------------+
     *
     * In which all walkable points are marked by zeros.
     * It uses @link{#ROUTING_SCALING_FACTOR} to reduce the matrix dimensions and improve performance.
     */
    getCanvasMatrix() {
        if (this.canvasMatrix.length === 0) {
            this.calculateCanvasMatrix();
        }
        return this.canvasMatrix;
    }
    calculateCanvasMatrix() {
        const { width: canvasWidth, hAdjustmentFactor, height: canvasHeight, vAdjustmentFactor } = this.calculateMatrixDimensions();
        this.hAdjustmentFactor = hAdjustmentFactor;
        this.vAdjustmentFactor = vAdjustmentFactor;
        const matrixWidth = Math.ceil(canvasWidth / this.ROUTING_SCALING_FACTOR);
        const matrixHeight = Math.ceil(canvasHeight / this.ROUTING_SCALING_FACTOR);
        this.canvasMatrix = _.range(0, matrixHeight).map(() => {
            return new Array(matrixWidth).fill(0);
        });
    }
    /**
     * A representation of the canvas in the following format:
     *
     * +-----------------+
     * | 0 0 1 1 0 0 0 0 |
     * | 0 0 1 1 0 0 1 1 |
     * | 0 0 0 0 0 0 1 1 |
     * | 1 1 0 0 0 0 0 0 |
     * | 1 1 0 0 0 0 0 0 |
     * +-----------------+
     *
     * In which all points blocked by a node (and its ports) are
     * marked as 1; points were there is nothing (ie, free) receive 0.
     */
    getRoutingMatrix() {
        if (this.routingMatrix.length === 0) {
            this.calculateRoutingMatrix();
        }
        return this.routingMatrix;
    }
    calculateRoutingMatrix() {
        const matrix = _.cloneDeep(this.getCanvasMatrix());
        // nodes need to be marked as blocked points
        this.markNodes(matrix);
        // same thing for ports
        this.markPorts(matrix);
        this.routingMatrix = matrix;
    }
    /**
     * The routing matrix does not have negative indexes, but elements could be negatively positioned.
     * We use the functions below to translate back and forth between these coordinates, relying on the
     * calculated values of hAdjustmentFactor and vAdjustmentFactor.
     */
    translateRoutingX(x, reverse = false) {
        return x + this.hAdjustmentFactor * (reverse ? -1 : 1);
    }
    translateRoutingY(y, reverse = false) {
        return y + this.vAdjustmentFactor * (reverse ? -1 : 1);
    }
    generateDynamicPath(pathCoords) {
        let path = Path();
        path = path.moveto(pathCoords[0][0] * this.ROUTING_SCALING_FACTOR, pathCoords[0][1] * this.ROUTING_SCALING_FACTOR);
        pathCoords.slice(1).forEach((coords) => {
            path = path.lineto(coords[0] * this.ROUTING_SCALING_FACTOR, coords[1] * this.ROUTING_SCALING_FACTOR);
        });
        return path.print();
    }
}
exports.PathFindingLinkFactory = PathFindingLinkFactory;
PathFindingLinkFactory.NAME = 'pathfinding';


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-routing/dist/link/PathFindingLinkModel.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-routing/dist/link/PathFindingLinkModel.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PathFindingLinkModel = void 0;
const PathFindingLinkFactory_1 = __webpack_require__(/*! ./PathFindingLinkFactory */ "./node_modules/@projectstorm/react-diagrams-routing/dist/link/PathFindingLinkFactory.js");
const react_diagrams_defaults_1 = __webpack_require__(/*! @projectstorm/react-diagrams-defaults */ "webpack/sharing/consume/default/@projectstorm/react-diagrams-defaults/@projectstorm/react-diagrams-defaults");
class PathFindingLinkModel extends react_diagrams_defaults_1.DefaultLinkModel {
    constructor(options = {}) {
        super(Object.assign({ type: PathFindingLinkFactory_1.PathFindingLinkFactory.NAME }, options));
    }
    performanceTune() {
        return false;
    }
}
exports.PathFindingLinkModel = PathFindingLinkModel;


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-routing/dist/link/PathFindingLinkWidget.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-routing/dist/link/PathFindingLinkWidget.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PathFindingLinkWidget = void 0;
const React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
const _ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const PathFinding_1 = __webpack_require__(/*! ../engine/PathFinding */ "./node_modules/@projectstorm/react-diagrams-routing/dist/engine/PathFinding.js");
const react_diagrams_defaults_1 = __webpack_require__(/*! @projectstorm/react-diagrams-defaults */ "webpack/sharing/consume/default/@projectstorm/react-diagrams-defaults/@projectstorm/react-diagrams-defaults");
class PathFindingLinkWidget extends React.Component {
    constructor(props) {
        super(props);
        this.refPaths = [];
        this.state = {
            selected: false
        };
        this.pathFinding = new PathFinding_1.PathFinding(this.props.factory);
    }
    componentDidUpdate() {
        this.props.link.setRenderedPaths(this.refPaths.map((ref) => {
            return ref.current;
        }));
    }
    componentDidMount() {
        this.props.link.setRenderedPaths(this.refPaths.map((ref) => {
            return ref.current;
        }));
    }
    componentWillUnmount() {
        this.props.link.setRenderedPaths([]);
    }
    generateLink(path, id) {
        const ref = React.createRef();
        this.refPaths.push(ref);
        return (React.createElement(react_diagrams_defaults_1.DefaultLinkSegmentWidget, { key: `link-${id}`, path: path, selected: this.state.selected, diagramEngine: this.props.diagramEngine, factory: this.props.diagramEngine.getFactoryForLink(this.props.link), link: this.props.link, forwardRef: ref, onSelection: (selected) => {
                this.setState({ selected: selected });
            }, extras: {} }));
    }
    render() {
        this.refPaths = [];
        //ensure id is present for all points on the path
        var points = this.props.link.getPoints();
        var paths = [];
        // first step: calculate a direct path between the points being linked
        const directPathCoords = this.pathFinding.calculateDirectPath(_.first(points), _.last(points));
        const routingMatrix = this.props.factory.getRoutingMatrix();
        // now we need to extract, from the routing matrix, the very first walkable points
        // so they can be used as origin and destination of the link to be created
        const smartLink = this.pathFinding.calculateLinkStartEndCoords(routingMatrix, directPathCoords);
        if (smartLink) {
            const { start, end, pathToStart, pathToEnd } = smartLink;
            // second step: calculate a path avoiding hitting other elements
            const simplifiedPath = this.pathFinding.calculateDynamicPath(routingMatrix, start, end, pathToStart, pathToEnd);
            paths.push(
            //smooth: boolean, extraProps: any, id: string | number, firstPoint: PointModel, lastPoint: PointModel
            this.generateLink(this.props.factory.generateDynamicPath(simplifiedPath), '0'));
        }
        return React.createElement(React.Fragment, null, paths);
    }
}
exports.PathFindingLinkWidget = PathFindingLinkWidget;


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-routing/dist/link/RightAngleLinkFactory.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-routing/dist/link/RightAngleLinkFactory.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RightAngleLinkFactory = void 0;
const React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
const RightAngleLinkWidget_1 = __webpack_require__(/*! ./RightAngleLinkWidget */ "./node_modules/@projectstorm/react-diagrams-routing/dist/link/RightAngleLinkWidget.js");
const react_diagrams_defaults_1 = __webpack_require__(/*! @projectstorm/react-diagrams-defaults */ "webpack/sharing/consume/default/@projectstorm/react-diagrams-defaults/@projectstorm/react-diagrams-defaults");
const RightAngleLinkModel_1 = __webpack_require__(/*! ./RightAngleLinkModel */ "./node_modules/@projectstorm/react-diagrams-routing/dist/link/RightAngleLinkModel.js");
/**
 * @author Daniel Lazar
 */
class RightAngleLinkFactory extends react_diagrams_defaults_1.DefaultLinkFactory {
    constructor() {
        super(RightAngleLinkFactory.NAME);
    }
    generateModel(event) {
        return new RightAngleLinkModel_1.RightAngleLinkModel();
    }
    generateReactWidget(event) {
        return React.createElement(RightAngleLinkWidget_1.RightAngleLinkWidget, { diagramEngine: this.engine, link: event.model, factory: this });
    }
}
exports.RightAngleLinkFactory = RightAngleLinkFactory;
RightAngleLinkFactory.NAME = 'rightAngle';


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-routing/dist/link/RightAngleLinkModel.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-routing/dist/link/RightAngleLinkModel.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RightAngleLinkModel = void 0;
const react_diagrams_defaults_1 = __webpack_require__(/*! @projectstorm/react-diagrams-defaults */ "webpack/sharing/consume/default/@projectstorm/react-diagrams-defaults/@projectstorm/react-diagrams-defaults");
const RightAngleLinkFactory_1 = __webpack_require__(/*! ./RightAngleLinkFactory */ "./node_modules/@projectstorm/react-diagrams-routing/dist/link/RightAngleLinkFactory.js");
class RightAngleLinkModel extends react_diagrams_defaults_1.DefaultLinkModel {
    constructor(options = {}) {
        super(Object.assign({ type: RightAngleLinkFactory_1.RightAngleLinkFactory.NAME }, options));
        this.lastHoverIndexOfPath = 0;
        this._lastPathXdirection = false;
        this._firstPathXdirection = false;
    }
    setFirstAndLastPathsDirection() {
        let points = this.getPoints();
        for (let i = 1; i < points.length; i += points.length - 2) {
            let dx = Math.abs(points[i].getX() - points[i - 1].getX());
            let dy = Math.abs(points[i].getY() - points[i - 1].getY());
            if (i - 1 === 0) {
                this._firstPathXdirection = dx > dy;
            }
            else {
                this._lastPathXdirection = dx > dy;
            }
        }
    }
    // @ts-ignore
    addPoint(pointModel, index = 1) {
        // @ts-ignore
        super.addPoint(pointModel, index);
        this.setFirstAndLastPathsDirection();
        return pointModel;
    }
    deserialize(event) {
        super.deserialize(event);
        this.setFirstAndLastPathsDirection();
    }
    setManuallyFirstAndLastPathsDirection(first, last) {
        this._firstPathXdirection = first;
        this._lastPathXdirection = last;
    }
    getLastPathXdirection() {
        return this._lastPathXdirection;
    }
    getFirstPathXdirection() {
        return this._firstPathXdirection;
    }
    setWidth(width) {
        this.options.width = width;
        this.fireEvent({ width }, 'widthChanged');
    }
    setColor(color) {
        this.options.color = color;
        this.fireEvent({ color }, 'colorChanged');
    }
}
exports.RightAngleLinkModel = RightAngleLinkModel;


/***/ }),

/***/ "./node_modules/@projectstorm/react-diagrams-routing/dist/link/RightAngleLinkWidget.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@projectstorm/react-diagrams-routing/dist/link/RightAngleLinkWidget.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RightAngleLinkWidget = void 0;
const React = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
const react_diagrams_core_1 = __webpack_require__(/*! @projectstorm/react-diagrams-core */ "./node_modules/@projectstorm/react-diagrams-core/dist/index.js");
const react_diagrams_defaults_1 = __webpack_require__(/*! @projectstorm/react-diagrams-defaults */ "webpack/sharing/consume/default/@projectstorm/react-diagrams-defaults/@projectstorm/react-diagrams-defaults");
const geometry_1 = __webpack_require__(/*! @projectstorm/geometry */ "./node_modules/@projectstorm/geometry/dist/index.js");
class RightAngleLinkWidget extends React.Component {
    constructor(props) {
        super(props);
        this.handleMove = function (event) {
            this.draggingEvent(event, this.dragging_index);
        }.bind(this);
        this.handleUp = function (event) {
            // Unregister handlers to avoid multiple event handlers for other links
            this.setState({ canDrag: false, selected: false });
            window.removeEventListener('mousemove', this.handleMove);
            window.removeEventListener('mouseup', this.handleUp);
        }.bind(this);
        this.refPaths = [];
        this.state = {
            selected: false,
            canDrag: false
        };
        this.dragging_index = 0;
    }
    componentDidUpdate() {
        this.props.link.setRenderedPaths(this.refPaths.map((ref) => {
            return ref.current;
        }));
    }
    componentDidMount() {
        this.props.link.setRenderedPaths(this.refPaths.map((ref) => {
            return ref.current;
        }));
    }
    componentWillUnmount() {
        this.props.link.setRenderedPaths([]);
    }
    generateLink(path, extraProps, id) {
        const ref = React.createRef();
        this.refPaths.push(ref);
        return (React.createElement(react_diagrams_defaults_1.DefaultLinkSegmentWidget, { key: `link-${id}`, path: path, selected: this.state.selected, diagramEngine: this.props.diagramEngine, factory: this.props.diagramEngine.getFactoryForLink(this.props.link), link: this.props.link, forwardRef: ref, onSelection: (selected) => {
                this.setState({ selected: selected });
            }, extras: extraProps }));
    }
    calculatePositions(points, event, index, coordinate) {
        // If path is first or last add another point to keep node port on its position
        if (index === 0) {
            let point = new react_diagrams_core_1.PointModel({
                link: this.props.link,
                position: new geometry_1.Point(points[index].getX(), points[index].getY())
            });
            this.props.link.addPoint(point, index);
            this.dragging_index++;
            return;
        }
        else if (index === points.length - 2) {
            let point = new react_diagrams_core_1.PointModel({
                link: this.props.link,
                position: new geometry_1.Point(points[index + 1].getX(), points[index + 1].getY())
            });
            this.props.link.addPoint(point, index + 1);
            return;
        }
        // Merge two points if it is not close to node port and close to each other
        if (index - 2 > 0) {
            let _points = {
                [index - 2]: points[index - 2].getPosition(),
                [index + 1]: points[index + 1].getPosition(),
                [index - 1]: points[index - 1].getPosition()
            };
            if (Math.abs(_points[index - 1][coordinate] - _points[index + 1][coordinate]) < 5) {
                _points[index - 2][coordinate] = this.props.diagramEngine.getRelativeMousePoint(event)[coordinate];
                _points[index + 1][coordinate] = this.props.diagramEngine.getRelativeMousePoint(event)[coordinate];
                points[index - 2].setPosition(_points[index - 2]);
                points[index + 1].setPosition(_points[index + 1]);
                points[index - 1].remove();
                points[index - 1].remove();
                this.dragging_index--;
                this.dragging_index--;
                return;
            }
        }
        // Merge two points if it is not close to node port
        if (index + 2 < points.length - 2) {
            let _points = {
                [index + 3]: points[index + 3].getPosition(),
                [index + 2]: points[index + 2].getPosition(),
                [index + 1]: points[index + 1].getPosition(),
                [index]: points[index].getPosition()
            };
            if (Math.abs(_points[index + 1][coordinate] - _points[index + 2][coordinate]) < 5) {
                _points[index][coordinate] = this.props.diagramEngine.getRelativeMousePoint(event)[coordinate];
                _points[index + 3][coordinate] = this.props.diagramEngine.getRelativeMousePoint(event)[coordinate];
                points[index].setPosition(_points[index]);
                points[index + 3].setPosition(_points[index + 3]);
                points[index + 1].remove();
                points[index + 1].remove();
                return;
            }
        }
        // If no condition above handled then just update path points position
        let _points = {
            [index]: points[index].getPosition(),
            [index + 1]: points[index + 1].getPosition()
        };
        _points[index][coordinate] = this.props.diagramEngine.getRelativeMousePoint(event)[coordinate];
        _points[index + 1][coordinate] = this.props.diagramEngine.getRelativeMousePoint(event)[coordinate];
        points[index].setPosition(_points[index]);
        points[index + 1].setPosition(_points[index + 1]);
    }
    draggingEvent(event, index) {
        let points = this.props.link.getPoints();
        // get moving difference. Index + 1 will work because links indexes has
        // length = points.lenght - 1
        let dx = Math.abs(points[index].getX() - points[index + 1].getX());
        let dy = Math.abs(points[index].getY() - points[index + 1].getY());
        // moving with y direction
        if (dx === 0) {
            this.calculatePositions(points, event, index, 'x');
        }
        else if (dy === 0) {
            this.calculatePositions(points, event, index, 'y');
        }
        this.props.link.setFirstAndLastPathsDirection();
    }
    render() {
        //ensure id is present for all points on the path
        let points = this.props.link.getPoints();
        let paths = [];
        // Get points based on link orientation
        let pointLeft = points[0];
        let pointRight = points[points.length - 1];
        let hadToSwitch = false;
        if (pointLeft.getX() > pointRight.getX()) {
            pointLeft = points[points.length - 1];
            pointRight = points[0];
            hadToSwitch = true;
        }
        let dy = Math.abs(points[0].getY() - points[points.length - 1].getY());
        // When new link add one middle point to get everywhere 90° angle
        if (this.props.link.getTargetPort() === null && points.length === 2) {
            [...Array(2)].forEach((item) => {
                this.props.link.addPoint(new react_diagrams_core_1.PointModel({
                    link: this.props.link,
                    position: new geometry_1.Point(pointLeft.getX(), pointRight.getY())
                }), 1);
            });
            this.props.link.setManuallyFirstAndLastPathsDirection(true, true);
        }
        // When new link is moving and not connected to target port move with middle point
        // TODO: @DanielLazarLDAPPS This will be better to update in DragNewLinkState
        //  in function fireMouseMoved to avoid calling this unexpectedly e.g. after Deserialize
        else if (this.props.link.getTargetPort() === null && this.props.link.getSourcePort() !== null) {
            points[1].setPosition(pointRight.getX() + (pointLeft.getX() - pointRight.getX()) / 2, !hadToSwitch ? pointLeft.getY() : pointRight.getY());
            points[2].setPosition(pointRight.getX() + (pointLeft.getX() - pointRight.getX()) / 2, !hadToSwitch ? pointRight.getY() : pointLeft.getY());
        }
        // Render was called but link is not moved but user.
        // Node is moved and in this case fix coordinates to get 90° angle.
        // For loop just for first and last path
        else if (!this.state.canDrag && points.length > 2) {
            // Those points and its position only will be moved
            for (let i = 1; i < points.length; i += points.length - 2) {
                if (i - 1 === 0) {
                    if (this.props.link.getFirstPathXdirection()) {
                        points[i].setPosition(points[i].getX(), points[i - 1].getY());
                    }
                    else {
                        points[i].setPosition(points[i - 1].getX(), points[i].getY());
                    }
                }
                else {
                    if (this.props.link.getLastPathXdirection()) {
                        points[i - 1].setPosition(points[i - 1].getX(), points[i].getY());
                    }
                    else {
                        points[i - 1].setPosition(points[i].getX(), points[i - 1].getY());
                    }
                }
            }
        }
        // If there is existing link which has two points add one
        // NOTE: It doesn't matter if check is for dy or dx
        if (points.length === 2 && dy !== 0 && !this.state.canDrag) {
            this.props.link.addPoint(new react_diagrams_core_1.PointModel({
                link: this.props.link,
                position: new geometry_1.Point(pointLeft.getX(), pointRight.getY())
            }));
        }
        for (let j = 0; j < points.length - 1; j++) {
            paths.push(this.generateLink(react_diagrams_core_1.LinkWidget.generateLinePath(points[j], points[j + 1]), {
                'data-linkid': this.props.link.getID(),
                'data-point': j,
                onMouseDown: (event) => {
                    if (event.button === 0) {
                        this.setState({ canDrag: true });
                        this.dragging_index = j;
                        // Register mouse move event to track mouse position
                        // On mouse up these events are unregistered check "this.handleUp"
                        window.addEventListener('mousemove', this.handleMove);
                        window.addEventListener('mouseup', this.handleUp);
                    }
                },
                onMouseEnter: (event) => {
                    this.setState({ selected: true });
                    this.props.link.lastHoverIndexOfPath = j;
                }
            }, j));
        }
        this.refPaths = [];
        return React.createElement("g", { "data-default-link-test": this.props.link.getOptions().testName }, paths);
    }
}
exports.RightAngleLinkWidget = RightAngleLinkWidget;
RightAngleLinkWidget.defaultProps = {
    color: 'red',
    width: 3,
    link: null,
    smooth: false,
    diagramEngine: null,
    factory: null
};


/***/ }),

/***/ "./node_modules/paths-js/geom.js":
/*!***************************************!*\
  !*** ./node_modules/paths-js/geom.js ***!
  \***************************************/
/***/ ((module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; })();

var sq = function sq(x) {
  return x * x;
};

var distPointToPoint = function distPointToPoint(_ref, _ref3) {
  var _ref2 = _slicedToArray(_ref, 2);

  var ax = _ref2[0];
  var ay = _ref2[1];

  var _ref32 = _slicedToArray(_ref3, 2);

  var bx = _ref32[0];
  var by = _ref32[1];
  return Math.sqrt(sq(ax - bx) + sq(ay - by));
};

var distPointToParabol = function distPointToParabol(a, f) {
  var p = distPointToPoint(a, f);

  return p == 0 ? Infinity : sq(p) / (2 * Math.abs(a[1] - f[1]));
};

var circumCenter = function circumCenter(a, b, c) {
  var d = (a[0] - c[0]) * (b[1] - c[1]) - (b[0] - c[0]) * (a[1] - c[1]);

  if (d == 0) return [Infinity, Infinity];

  var xc = (((a[0] - c[0]) * (a[0] + c[0]) + (a[1] - c[1]) * (a[1] + c[1])) / 2 * (b[1] - c[1]) - ((b[0] - c[0]) * (b[0] + c[0]) + (b[1] - c[1]) * (b[1] + c[1])) / 2 * (a[1] - c[1])) / d;
  var yc = (((b[0] - c[0]) * (b[0] + c[0]) + (b[1] - c[1]) * (b[1] + c[1])) / 2 * (a[0] - c[0]) - ((a[0] - c[0]) * (a[0] + c[0]) + (a[1] - c[1]) * (a[1] + c[1])) / 2 * (b[0] - c[0])) / d;
  return [xc, yc];
};

var parabolsCrossX = function parabolsCrossX(fa, fb, q) {
  if (fa[1] === fb[1]) return [(fa[0] + fb[0]) / 2, (fa[0] + fb[0]) / 2];

  var s1 = (fa[1] * fb[0] - fa[0] * fb[1] + fa[0] * q - fb[0] * q + Math.sqrt((fa[0] * fa[0] + fa[1] * fa[1] - 2 * fa[0] * fb[0] + fb[0] * fb[0] - 2 * fa[1] * fb[1] + fb[1] * fb[1]) * (fa[1] * fb[1] - fa[1] * q - fb[1] * q + q * q))) / (fa[1] - fb[1]);
  var s2 = (fa[1] * fb[0] - fa[0] * fb[1] + fa[0] * q - fb[0] * q - Math.sqrt((fa[0] * fa[0] + fa[1] * fa[1] - 2 * fa[0] * fb[0] + fb[0] * fb[0] - 2 * fa[1] * fb[1] + fb[1] * fb[1]) * (fa[1] * fb[1] - fa[1] * q - fb[1] * q + q * q))) / (fa[1] - fb[1]);

  return s1 < s2 ? [s1, s2] : [s2, s1];
};

var doHalflinesCross = function doHalflinesCross(sa, sb) {
  var approx = arguments.length <= 2 || arguments[2] === undefined ? 1e-10 : arguments[2];
  //sa, sb are Segment instance
  var dx = sb.ps[0] - sa.ps[0];
  var dy = sb.ps[1] - sa.ps[1];

  if (sa.m == Infinity) return sa.hp * (sb.m * dx - dy) <= approx && sb.vec[0] * dx <= approx;
  if (sb.m == Infinity) return sb.hp * (sa.m * dx - dy) >= -approx && sa.vec[0] * dx >= -approx;

  var det = sb.vec[0] * sa.vec[1] - sb.vec[1] * sa.vec[0];

  if (det === 0) return false;

  var u = (dy * sb.vec[0] - dx * sb.vec[1]) / det;
  var v = (dy * sa.vec[0] - dx * sa.vec[1]) / det;

  return u >= -approx && v >= approx || u >= approx && v >= -approx;
};

var matrixTransform = function matrixTransform(points, matrix) {
  return points.map(function (point) {
    return {
      x: point.x * matrix[0] + point.y * matrix[2] + matrix[4],
      y: point.x * matrix[1] + point.y * matrix[3] + matrix[5]
    };
  });
};

var transformEllipse = function transformEllipse(rx, ry, ax, m) {
  var torad = Math.PI / 180;
  var epsilon = 0.0000000001;

  var c = Math.cos(ax * torad),
      s = Math.sin(ax * torad);
  var ma = [rx * (m[0] * c + m[2] * s), rx * (m[1] * c + m[3] * s), ry * (-m[0] * s + m[2] * c), ry * (-m[1] * s + m[3] * c)];

  var J = ma[0] * ma[0] + ma[2] * ma[2],
      K = ma[1] * ma[1] + ma[3] * ma[3];

  var D = ((ma[0] - ma[3]) * (ma[0] - ma[3]) + (ma[2] + ma[1]) * (ma[2] + ma[1])) * ((ma[0] + ma[3]) * (ma[0] + ma[3]) + (ma[2] - ma[1]) * (ma[2] - ma[1]));

  var JK = (J + K) / 2;

  if (D < epsilon * JK) {
    return {
      rx: Math.sqrt(JK),
      ry: Math.sqrt(JK),
      ax: 0,
      isDegenerate: false
    };
  }

  var L = ma[0] * ma[1] + ma[2] * ma[3];
  D = Math.sqrt(D);

  var l1 = JK + D / 2,
      l2 = JK - D / 2;

  var newAx = undefined,
      newRx = undefined,
      newRy = undefined;
  newAx = Math.abs(L) < epsilon && Math.abs(l1 - K) < epsilon ? 90 : Math.atan(Math.abs(L) > Math.abs(l1 - K) ? (l1 - J) / L : L / (l1 - K)) * 180 / Math.PI;

  if (newAx >= 0) {
    newRx = Math.sqrt(l1);
    newRy = Math.sqrt(l2);
  } else {
    newAx += 90;
    newRx = Math.sqrt(l2);
    newRy = Math.sqrt(l1);
  }

  return {
    rx: newRx,
    ry: newRy,
    ax: newAx,
    isDegenerate: newRx < epsilon * newRy || newRy < epsilon * newRx
  };
};

exports["default"] = { distPointToPoint: distPointToPoint, distPointToParabol: distPointToParabol, circumCenter: circumCenter,
  parabolsCrossX: parabolsCrossX, doHalflinesCross: doHalflinesCross, matrixTransform: matrixTransform, transformEllipse: transformEllipse };
module.exports = exports["default"];

/***/ }),

/***/ "./node_modules/paths-js/path.js":
/*!***************************************!*\
  !*** ./node_modules/paths-js/path.js ***!
  \***************************************/
/***/ ((module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _geom = __webpack_require__(/*! ./geom */ "./node_modules/paths-js/geom.js");

var Path = function Path(init) {
  var _instructions = init || [];

  var push = function push(arr, el) {
    var copy = arr.slice(0, arr.length);
    copy.push(el);
    return copy;
  };

  var areEqualPoints = function areEqualPoints(_ref, _ref3) {
    var _ref2 = _slicedToArray(_ref, 2);

    var a1 = _ref2[0];
    var b1 = _ref2[1];

    var _ref32 = _slicedToArray(_ref3, 2);

    var a2 = _ref32[0];
    var b2 = _ref32[1];
    return a1 === a2 && b1 === b2;
  };

  var trimZeros = function trimZeros(string, char) {
    var l = string.length;
    while (string.charAt(l - 1) === '0') {
      l = l - 1;
    }
    if (string.charAt(l - 1) === '.') {
      l = l - 1;
    }
    return string.substr(0, l);
  };

  var round = function round(number, digits) {
    var str = number.toFixed(digits);
    return trimZeros(str);
  };

  var printInstrunction = function printInstrunction(_ref4) {
    var command = _ref4.command;
    var params = _ref4.params;

    var numbers = params.map(function (param) {
      return round(param, 6);
    });
    return command + ' ' + numbers.join(' ');
  };

  var point = function point(_ref5, prev) {
    var command = _ref5.command;
    var params = _ref5.params;

    switch (command) {
      case 'M':
        return [params[0], params[1]];
      case 'L':
        return [params[0], params[1]];
      case 'H':
        return [params[0], prev[1]];
      case 'V':
        return [prev[0], params[0]];
      case 'Z':
        return null;
      case 'C':
        return [params[4], params[5]];
      case 'S':
        return [params[2], params[3]];
      case 'Q':
        return [params[2], params[3]];
      case 'T':
        return [params[0], params[1]];
      case 'A':
        return [params[5], params[6]];
    }
  };

  var transformParams = function transformParams(instruction, matrix, prev) {
    var p = instruction.params;

    var transformer = {
      'V': function V(instruction, matrix, prev) {
        var pts = [{ x: prev[0], y: p[0] }];
        var newPts = (0, _geom.matrixTransform)(pts, matrix);
        if (newPts[0].x === (0, _geom.matrixTransform)([{ x: prev[0], y: prev[1] }], matrix)[0].x) {
          return {
            command: 'V',
            params: [newPts[0].y]
          };
        } else {
          return {
            command: 'L',
            params: [newPts[0].x, newPts[0].y]
          };
        }
      },
      'H': function H(instruction, matrix, prev) {
        var pts = [{ x: p[0], y: prev[1] }];
        var newPts = (0, _geom.matrixTransform)(pts, matrix);
        if (newPts[0].y === (0, _geom.matrixTransform)([{ x: prev[0], y: prev[1] }], matrix)[0].y) {
          return {
            command: 'H',
            params: [newPts[0].x]
          };
        } else {
          return {
            command: 'L',
            params: [newPts[0].x, newPts[0].y]
          };
        }
      },
      'A': function A(instruction, matrix, prev) {
        // transform rx, ry, and x-axis rotation
        var r = (0, _geom.transformEllipse)(p[0], p[1], p[2], matrix);

        var sweepFlag = p[4];
        if (matrix[0] * matrix[3] - matrix[1] * matrix[2] < 0) {
          sweepFlag = sweepFlag ? '0' : '1';
        }

        // transform endpoint
        var pts = [{ x: p[5], y: p[6] }];
        var newPts = (0, _geom.matrixTransform)(pts, matrix);

        if (r.isDegenerate) {
          return {
            command: 'L',
            params: [newPts[0].x, newPts[0].y]
          };
        } else {
          return {
            command: 'A',
            params: [r.rx, r.ry, r.ax, p[3], sweepFlag, newPts[0].x, newPts[0].y]
          };
        }
      },
      'C': function C(instruction, matrix, prev) {
        var pts = [{ x: p[0], y: p[1] }, { x: p[2], y: p[3] }, { x: p[4], y: p[5] }];
        var newPts = (0, _geom.matrixTransform)(pts, matrix);
        return {
          command: 'C',
          params: [newPts[0].x, newPts[0].y, newPts[1].x, newPts[1].y, newPts[2].x, newPts[2].y]
        };
      },
      'Z': function Z(instruction, matrix, prev) {
        return {
          command: 'Z',
          params: []
        };
      },
      'default': function _default(instruction, matrix, prev) {
        var pts = [{ x: p[0], y: p[1] }];
        var newPts = (0, _geom.matrixTransform)(pts, matrix);
        var newParams = instruction.params.slice(0, instruction.params.length);
        newParams.splice(0, 2, newPts[0].x, newPts[0].y);
        return {
          command: instruction.command,
          params: newParams
        };
      }
    };

    if (transformer[instruction.command]) {
      return transformer[instruction.command](instruction, matrix, prev);
    } else {
      return transformer['default'](instruction, matrix, prev);
    }
  };

  var verbosify = function verbosify(keys, f) {
    return function (a) {
      var args = typeof a === 'object' ? keys.map(function (k) {
        return a[k];
      }) : arguments;
      return f.apply(null, args);
    };
  };

  var plus = function plus(instruction) {
    return Path(push(_instructions, instruction));
  };

  return {
    moveto: verbosify(['x', 'y'], function (x, y) {
      return plus({
        command: 'M',
        params: [x, y]
      });
    }),
    lineto: verbosify(['x', 'y'], function (x, y) {
      return plus({
        command: 'L',
        params: [x, y]
      });
    }),
    hlineto: verbosify(['x'], function (x) {
      return plus({
        command: 'H',
        params: [x]
      });
    }),
    vlineto: verbosify(['y'], function (y) {
      return plus({
        command: 'V',
        params: [y]
      });
    }),
    closepath: function closepath() {
      return plus({
        command: 'Z',
        params: []
      });
    },
    curveto: verbosify(['x1', 'y1', 'x2', 'y2', 'x', 'y'], function (x1, y1, x2, y2, x, y) {
      return plus({
        command: 'C',
        params: [x1, y1, x2, y2, x, y]
      });
    }),
    smoothcurveto: verbosify(['x2', 'y2', 'x', 'y'], function (x2, y2, x, y) {
      return plus({
        command: 'S',
        params: [x2, y2, x, y]
      });
    }),
    qcurveto: verbosify(['x1', 'y1', 'x', 'y'], function (x1, y1, x, y) {
      return plus({
        command: 'Q',
        params: [x1, y1, x, y]
      });
    }),
    smoothqcurveto: verbosify(['x', 'y'], function (x, y) {
      return plus({
        command: 'T',
        params: [x, y]
      });
    }),
    arc: verbosify(['rx', 'ry', 'xrot', 'largeArcFlag', 'sweepFlag', 'x', 'y'], function (rx, ry, xrot, largeArcFlag, sweepFlag, x, y) {
      return plus({
        command: 'A',
        params: [rx, ry, xrot, largeArcFlag, sweepFlag, x, y]
      });
    }),
    translate: verbosify(['dx', 'dy'], function () {
      var dx = arguments.length <= 0 || arguments[0] === undefined ? 0 : arguments[0];
      var dy = arguments.length <= 1 || arguments[1] === undefined ? 0 : arguments[1];

      if (dx !== 0 || dy !== 0) {
        var _ret = (function () {
          var prev = [0, 0];
          var matrix = [1, 0, 0, 1, dx, dy];
          var newInstructions = _instructions.map(function (instruction) {
            var p = transformParams(instruction, matrix, prev);
            prev = point(instruction, prev);
            return p;
          });
          return {
            v: Path(newInstructions)
          };
        })();

        if (typeof _ret === 'object') return _ret.v;
      } else {
        return Path(_instructions);
      }
    }),
    rotate: verbosify(['angle', 'rx', 'ry'], function (angle) {
      var rx = arguments.length <= 1 || arguments[1] === undefined ? 0 : arguments[1];
      var ry = arguments.length <= 2 || arguments[2] === undefined ? 0 : arguments[2];

      if (angle !== 0) {
        var _ret2 = (function () {
          var prev = undefined;
          var matrix = undefined;
          var newInstructions = _instructions;

          if (rx !== 0 && ry !== 0) {
            prev = [0, 0];
            matrix = [1, 0, 0, 1, -rx, -ry];
            newInstructions = newInstructions.map(function (instruction) {
              var p = transformParams(instruction, matrix, prev);
              prev = point(instruction, prev);
              return p;
            });
          }

          var rad = angle * Math.PI / 180;
          var cos = Math.cos(rad);
          var sin = Math.sin(rad);

          prev = [0, 0];
          matrix = [cos, sin, -sin, cos, 0, 0];
          newInstructions = newInstructions.map(function (instruction) {
            var p = transformParams(instruction, matrix, prev);
            prev = point(instruction, prev);
            return p;
          });

          if (rx !== 0 && ry !== 0) {
            prev = [0, 0];
            matrix = [1, 0, 0, 1, rx, ry];
            newInstructions = newInstructions.map(function (instruction) {
              var p = transformParams(instruction, matrix, prev);
              prev = point(instruction, prev);
              return p;
            });
          }

          return {
            v: Path(newInstructions)
          };
        })();

        if (typeof _ret2 === 'object') return _ret2.v;
      } else {
        return Path(_instructions);
      }
    }),
    scale: verbosify(['sx', 'sy'], function () {
      var sx = arguments.length <= 0 || arguments[0] === undefined ? 1 : arguments[0];
      var sy = arguments.length <= 1 || arguments[1] === undefined ? sx : arguments[1];
      return (function () {
        if (sx !== 1 || sy !== 1) {
          var _ret3 = (function () {
            var prev = [0, 0];
            var matrix = [sx, 0, 0, sy, 0, 0];
            var newInstructions = _instructions.map(function (instruction) {
              var p = transformParams(instruction, matrix, prev);
              prev = point(instruction, prev);
              return p;
            });
            return {
              v: Path(newInstructions)
            };
          })();

          if (typeof _ret3 === 'object') return _ret3.v;
        } else {
          return Path(_instructions);
        }
      })();
    }),
    shearX: verbosify(['angle'], function () {
      var angle = arguments.length <= 0 || arguments[0] === undefined ? 0 : arguments[0];

      if (angle !== 0) {
        var _ret4 = (function () {
          var prev = [0, 0];
          var matrix = [1, 0, Math.tan(angle * Math.PI / 180), 1, 0, 0];
          var newInstructions = _instructions.map(function (instruction) {
            var p = transformParams(instruction, matrix, prev);
            prev = point(instruction, prev);
            return p;
          });
          return {
            v: Path(newInstructions)
          };
        })();

        if (typeof _ret4 === 'object') return _ret4.v;
      } else {
        return Path(_instructions);
      }
    }),
    shearY: verbosify(['angle'], function () {
      var angle = arguments.length <= 0 || arguments[0] === undefined ? 0 : arguments[0];

      if (angle !== 0) {
        var _ret5 = (function () {
          var prev = [0, 0];
          var matrix = [1, Math.tan(angle * Math.PI / 180), 0, 1, 0, 0];
          var newInstructions = _instructions.map(function (instruction) {
            var p = transformParams(instruction, matrix, prev);
            prev = point(instruction, prev);
            return p;
          });
          return {
            v: Path(newInstructions)
          };
        })();

        if (typeof _ret5 === 'object') return _ret5.v;
      } else {
        return Path(_instructions);
      }
    }),
    print: function print() {
      return _instructions.map(printInstrunction).join(' ');
    },
    toString: function toString() {
      return undefined.print();
    },
    points: function points() {
      var ps = [];
      var prev = [0, 0];
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = _instructions[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var instruction = _step.value;

          var p = point(instruction, prev);
          prev = p;
          if (p) {
            ps.push(p);
          }
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator['return']) {
            _iterator['return']();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return ps;
    },
    instructions: function instructions() {
      return _instructions.slice(0, _instructions.length);
    },
    connect: function connect(path) {
      var ps = this.points();
      var last = ps[ps.length - 1];
      var first = path.points()[0];
      var newInstructions = undefined;
      if (_instructions[_instructions.length - 1].command !== 'Z') {
        newInstructions = path.instructions().slice(1);
        if (!areEqualPoints(last, first)) {
          newInstructions.unshift({
            command: "L",
            params: first
          });
        }
      } else {
        newInstructions = path.instructions();
      }
      return Path(this.instructions().concat(newInstructions));
    }
  };
};

exports["default"] = function () {
  return Path();
};

module.exports = exports['default'];

/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_projectstorm_react-diagrams-routing_dist_index_js.8debfbe7182f29f51726.js.map