from jupyter_server.utils import url_path_join

from .compile_xircuits import CompileXircuitsFileRouteHandler
from .components import ComponentsRouteHandler, EditXircuitsFile
from .config import RunConfigRouteHandler
from .debugger import DebuggerRouteHandler
from .spark_submit import SparkSubmitRouteHandler


def setup_handlers(web_app, url_path):
    host_pattern = ".*$"
    base_url = web_app.settings["base_url"]

    # Prepend the base_url so that it works in a JupyterHub setting
    web_app.add_handlers(host_pattern, [
        (
            url_path_join(base_url, url_path, "debug/enable"),
            DebuggerRouteHandler
        ),
        (
            url_path_join(base_url, url_path, "config/run"),
            RunConfigRouteHandler
        ),
        (
            url_path_join(base_url, url_path, "components/"),
            ComponentsRouteHandler
        ),
        (
            url_path_join(base_url, url_path, "spark/submit"),
            SparkSubmitRouteHandler
        ),
        (
            url_path_join(base_url, url_path, "file/compile"),
            CompileXircuitsFileRouteHandler
        ),
        (
            url_path_join(base_url, url_path, "components_edit/"),
            EditXircuitsFile
        )

    ])
