# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/40_arrs.ipynb.

# %% auto 0
__all__ = ['P', 'consec', 'non0row', 'runs', 'sameruns', 'mergeruns']

# %% ../nbs/40_arrs.ipynb 6
from inspect import getfullargspec as argspec, ismethod, isfunction, FullArgSpec
from functools import wraps

# %% ../nbs/40_arrs.ipynb 8
from typing import NamedTuple, Callable, ParamSpec, Literal, Union, ForwardRef
P = ParamSpec('P')

# %% ../nbs/40_arrs.ipynb 10
try: import numpy as np
except ImportError: 
    ...
    np = ForwardRef('numpy', module='numpy')

# %% ../nbs/40_arrs.ipynb 12
from atyp import NPArray
from asto import asarr

# %% ../nbs/40_arrs.ipynb 14
from .math import domain, toldif

# %% ../nbs/40_arrs.ipynb 16
def consec(a: list, size: float = 1) -> NPArray:
    '''consecutive'''
    return np.split(a, np.where(np.diff(a) != size)[0] + 1)

def non0row(a: list) -> NPArray:
    '''Returns the indices of nonzero values in an one-dimensional array.'''
    return asarr(a).nonzero()[0]

# %% ../nbs/40_arrs.ipynb 18
def runs(a: list) -> NPArray:
    '''Returns the [start, stop] values of consectuive numbers in the given array'''
    return np.array([domain(run) if run.size > 0 else [] for run in consec(a)])

def sameruns(a: list, b: list, tol: int = 0) -> bool:
    '''Whether or not the two runs are within the specified `tolerance`.''' 
    x, y = sorted([a, b])
    return toldif(x[0], y[1], tol + 1)

def mergeruns(a: list, b: list) -> NPArray:
    return np.array([min(a[0], b[0]), max(a[1], b[1])])
