# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/20_attr.ipynb.

# %% auto 0
__all__ = ['P', 'getattritem', 'uniattrs']

# %% ../nbs/20_attr.ipynb 6
from inspect import getfullargspec as argspec, ismethod, isfunction, FullArgSpec
from functools import wraps

# %% ../nbs/20_attr.ipynb 8
from typing import NamedTuple, Callable, ParamSpec, Literal, Union
P = ParamSpec('P')

# %% ../nbs/20_attr.ipynb 10
#| export


# %% ../nbs/20_attr.ipynb 12
from chck import isnone, notnone
from nlit import GET, __GETITEM__

# %% ../nbs/20_attr.ipynb 14
#| export


# %% ../nbs/20_attr.ipynb 16
def getattritem(obj, attr: str, default = None):
    '''`getattr`, `__getitem__`, or `get`'''
    res = None
    if hasattr(obj, GET): res = obj.get(attr, default)
    if hasattr(obj, __GETITEM__): res = obj.__getitem__(attr)
    return getattr(obj, attr, default) if isnone(res) else res

def uniattrs(attr: str, *objs) -> set: 
    return set({val for obj in objs if notnone(val := getattritem(obj, attr))})
