/******/ (function(modules) { // webpackBootstrap
/******/ 	// install a JSONP callback for chunk loading
/******/ 	var parentJsonpFunction = window["webpackJsonp"];
/******/ 	window["webpackJsonp"] = function webpackJsonpCallback(chunkIds, moreModules) {
/******/ 		// add "moreModules" to the modules object,
/******/ 		// then flag all "chunkIds" as loaded and fire callback
/******/ 		var moduleId, chunkId, i = 0, callbacks = [];
/******/ 		for(;i < chunkIds.length; i++) {
/******/ 			chunkId = chunkIds[i];
/******/ 			if(installedChunks[chunkId])
/******/ 				callbacks.push.apply(callbacks, installedChunks[chunkId]);
/******/ 			installedChunks[chunkId] = 0;
/******/ 		}
/******/ 		for(moduleId in moreModules) {
/******/ 			modules[moduleId] = moreModules[moduleId];
/******/ 		}
/******/ 		if(parentJsonpFunction) parentJsonpFunction(chunkIds, moreModules);
/******/ 		while(callbacks.length)
/******/ 			callbacks.shift().call(null, __webpack_require__);
/******/
/******/ 	};
/******/
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// object to store loaded and loading chunks
/******/ 	// "0" means "already loaded"
/******/ 	// Array means "loading", array contains callbacks
/******/ 	var installedChunks = {
/******/ 		0:0
/******/ 	};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/ 	// This file contains only the entry chunk.
/******/ 	// The chunk loading function for additional chunks
/******/ 	__webpack_require__.e = function requireEnsure(chunkId, callback) {
/******/ 		// "0" is the signal for "already loaded"
/******/ 		if(installedChunks[chunkId] === 0)
/******/ 			return callback.call(null, __webpack_require__);
/******/
/******/ 		// an array means "currently loading".
/******/ 		if(installedChunks[chunkId] !== undefined) {
/******/ 			installedChunks[chunkId].push(callback);
/******/ 		} else {
/******/ 			// start chunk loading
/******/ 			installedChunks[chunkId] = [callback];
/******/ 			var head = document.getElementsByTagName('head')[0];
/******/ 			var script = document.createElement('script');
/******/ 			script.type = 'text/javascript';
/******/ 			script.charset = 'utf-8';
/******/ 			script.async = true;
/******/
/******/ 			script.src = __webpack_require__.p + "" + chunkId + ".bundle.js";
/******/ 			head.appendChild(script);
/******/ 		}
/******/ 	};
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "lab/";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	
	var JupyterLab = __webpack_require__(1).JupyterLab;
	
	// ES6 Promise polyfill
	__webpack_require__(39).polyfill();
	
	__webpack_require__(43);
	__webpack_require__(53);
	__webpack_require__(59);
	
	var lab = new JupyterLab();
	
	lab.registerPlugins([
	  __webpack_require__(117).aboutExtension,
	  __webpack_require__(121).clipboardProvider,
	  __webpack_require__(123).commandPaletteProvider,
	  __webpack_require__(125).consoleExtension,
	  __webpack_require__(152).csvHandlerExtension,
	  __webpack_require__(155).docRegistryProvider,
	  __webpack_require__(156).editorHandlerProvider,
	  __webpack_require__(324).faqExtension,
	  __webpack_require__(326).fileBrowserProvider,
	  __webpack_require__(473).helpHandlerExtension,
	  __webpack_require__(475).imageHandlerExtension,
	  __webpack_require__(477).inspectorProvider,
	  __webpack_require__(478).mapHandlerExtension,
	  __webpack_require__(485).landingExtension,
	  __webpack_require__(486).mainExtension,
	  __webpack_require__(487).mainMenuProvider,
	  __webpack_require__(488).markdownHandlerExtension,
	  __webpack_require__(490).notebookTrackerProvider,
	  __webpack_require__(512).renderMimeProvider,
	  __webpack_require__(572).runningSessionsExtension,
	  __webpack_require__(574).servicesProvider,
	  __webpack_require__(575).shortcutsExtension,
	  __webpack_require__(576).terminalExtension,
	  __webpack_require__(592).rendererProvider,
	  __webpack_require__(597).rendererProvider
	
	
	  // require('jupyter-js-widgets-labextension/lib/plugin').widgetManagerExtension,
	]);
	
	window.onload = function() { lab.start(); }


/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var application_1 = __webpack_require__(2);
	var shell_1 = __webpack_require__(22);
	/**
	 * JupyterLab is the main application class. It is instantiated once and shared.
	 */
	var JupyterLab = (function (_super) {
	    __extends(JupyterLab, _super);
	    function JupyterLab() {
	        _super.apply(this, arguments);
	    }
	    /**
	     * Create the application shell for the JupyterLab application.
	     */
	    JupyterLab.prototype.createShell = function () {
	        return new shell_1.ApplicationShell();
	    };
	    return JupyterLab;
	}(application_1.Application));
	exports.JupyterLab = JupyterLab;


/***/ },
/* 2 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var commandregistry_1 = __webpack_require__(3);
	var keymap_1 = __webpack_require__(9);
	var widget_1 = __webpack_require__(17);
	/**
	 * An abstract base class for creating pluggable applications.
	 *
	 * #### Notes
	 * The `Application` class is useful when creating large, complex
	 * UI applications with the ability to be safely extended by third
	 * party code via plugins.
	 *
	 * Use of this class is optional. Applications with low to moderate
	 * complexity will have no need for the features this class provides.
	 */
	var Application = (function () {
	    /**
	     * Construct a new application.
	     */
	    function Application() {
	        this._started = false;
	        this._shell = null;
	        this._promise = null;
	        this._pluginMap = Private.createPluginMap();
	        this._serviceMap = Private.createServiceMap();
	        this._commands = new commandregistry_1.CommandRegistry();
	        this._keymap = new keymap_1.Keymap({ commands: this._commands });
	    }
	    Object.defineProperty(Application.prototype, "shell", {
	        /**
	         * The application shell widget.
	         *
	         * #### Notes
	         * The shell widget is the root "container" widget for the entire
	         * application. It will typically expose an API which allows the
	         * application plugins to insert content in a variety of places.
	         *
	         * This is created by a subclass in the `createShell()` method.
	         *
	         * This will be `null` until the application is started.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._shell;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Application.prototype, "commands", {
	        /**
	         * The application command registry.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._commands;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Application.prototype, "keymap", {
	        /**
	         * The application keymap.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._keymap;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Test whether a plugin is registered with the application.
	     *
	     * @param id - The id of the plugin of interest.
	     *
	     * @returns `true` if the plugin is registered, `false` otherwise.
	     */
	    Application.prototype.hasPlugin = function (id) {
	        return id in this._pluginMap;
	    };
	    /**
	     * List the IDs of the plugins registered with the application.
	     *
	     * @returns A new array of the registered plugin IDs.
	     */
	    Application.prototype.listPlugins = function () {
	        return Object.keys(this._pluginMap);
	    };
	    /**
	     * Register a plugin with the application.
	     *
	     * @param plugin - The plugin to register.
	     *
	     * #### Notes
	     * An error will be thrown if a plugin with the same id is already
	     * registered, or if the plugin has a circular dependency.
	     *
	     * If the plugin provides a service which has already been provided
	     * by another plugin, the new service will override the old service.
	     */
	    Application.prototype.registerPlugin = function (plugin) {
	        // Throw an error if the plugin id is already registered.
	        if (plugin.id in this._pluginMap) {
	            throw new Error("Plugin '" + plugin.id + "' is already registered.");
	        }
	        // Create the normalized plugin data.
	        var data = Private.createPluginData(plugin);
	        // Ensure the plugin does not cause a cyclic dependency.
	        Private.ensureNoCycle(data, this._pluginMap, this._serviceMap);
	        // Add the service token to the registry.
	        if (data.provides)
	            this._serviceMap.set(data.provides, data.id);
	        // Add the plugin to the registry.
	        this._pluginMap[data.id] = data;
	    };
	    /**
	     * Register multiple plugins with the application.
	     *
	     * @param plugins - The plugins to register.
	     *
	     * #### Notes
	     * This calls `registerPlugin()` for each of the given plugins.
	     */
	    Application.prototype.registerPlugins = function (plugins) {
	        for (var _i = 0, plugins_1 = plugins; _i < plugins_1.length; _i++) {
	            var plugin = plugins_1[_i];
	            this.registerPlugin(plugin);
	        }
	    };
	    /**
	     * Activate the plugin with the given id.
	     *
	     * @param id - The ID of the plugin of interest.
	     *
	     * @returns A promise which resolves when the plugin is activated
	     *   or rejects with an error if it cannot be activated.
	     */
	    Application.prototype.activatePlugin = function (id) {
	        var _this = this;
	        // Reject the promise if the plugin is not registered.
	        var data = this._pluginMap[id];
	        if (!data) {
	            return Promise.reject(new Error("Plugin '" + id + "' is not registered."));
	        }
	        // Resolve immediately if the plugin is already activated.
	        if (data.activated) {
	            return Promise.resolve();
	        }
	        // Return the pending resolver promise if it exists.
	        if (data.promise) {
	            return data.promise;
	        }
	        // Resolve the services required by the plugin.
	        var promises = data.requires.map(function (req) { return _this.resolveService(req); });
	        // Setup the resolver promise for the plugin.
	        data.promise = Promise.all(promises).then(function (deps) {
	            return data.activate.apply(void 0, [_this].concat(deps));
	        }).then(function (service) {
	            data.service = service;
	            data.activated = true;
	            data.promise = null;
	        }).catch(function (error) {
	            data.promise = null;
	            throw error;
	        });
	        // Return the pending resolver promise.
	        return data.promise;
	    };
	    /**
	     * Resolve a service of a given type.
	     *
	     * @param token - The token for the service type of interest.
	     *
	     * @returns A promise which resolves to an instance of the requested
	     *   service, or rejects with an error if it cannot be resolved.
	     *
	     * #### Notes
	     * Services are singletons. The same instance will be returned each
	     * time a given service token is resolved.
	     *
	     * If the plugin which provides the service has not been activated,
	     * resolving the service will automatically activate the plugin.
	     *
	     * User code will not typically call this method directly. Instead,
	     * the required services for the user's plugins will be resolved
	     * automatically when the plugin is activated.
	     */
	    Application.prototype.resolveService = function (token) {
	        // Reject the promise if there is no provider for the type.
	        var id = this._serviceMap.get(token);
	        if (!id) {
	            return Promise.reject(new Error("No provider for: " + token.name + "."));
	        }
	        // Resolve immediately if the plugin is already activated.
	        var data = this._pluginMap[id];
	        if (data.activated) {
	            return Promise.resolve(data.service);
	        }
	        // Otherwise, activate the plugin and wait on the results.
	        return this.activatePlugin(id).then(function () { return data.service; });
	    };
	    /**
	     * Start the application.
	     *
	     * @param options - The options for starting the application.
	     *
	     * @returns A promise which resolves when all bootstrapping work
	     *   is complete and the shell is mounted to the DOM, or rejects
	     *   with an error if the bootstrapping process fails.
	     *
	     * #### Notes
	     * This should be called once by the application creator after all
	     * initial plugins have been registered.
	     *
	     * Bootstrapping the application consists of the following steps:
	     * 1. Create the shell widget
	     * 2. Activate the startup plugins
	     * 3. Wait for those plugins to activate
	     * 4. Attach the shell widget to the DOM
	     * 5. Add the application event listeners
	     */
	    Application.prototype.start = function (options) {
	        var _this = this;
	        if (options === void 0) { options = {}; }
	        // Resolve immediately if the application is already started.
	        if (this._started) {
	            return Promise.resolve();
	        }
	        // Return the pending promise if it exists.
	        if (this._promise) {
	            return this._promise;
	        }
	        // Create the shell widget.
	        this._shell = this.createShell();
	        // Parse the host id for attaching the shell.
	        var hostID = options.hostID || '';
	        // Collect the ids of the startup plugins.
	        var startups = Private.collectStartupPlugins(this._pluginMap, options);
	        // Generate the activation promises.
	        var promises = startups.map(function (id) { return _this.activatePlugin(id); });
	        // Wait for the plugins to activate, then finalize startup.
	        this._promise = Promise.all(promises).then(function () {
	            _this._started = true;
	            _this._promise = null;
	            _this.attachShell(hostID);
	            _this.addEventListeners();
	        }).catch(function (error) {
	            _this._promise = null;
	            throw error;
	        });
	        // Return the pending bootstrapping promise.
	        return this._promise;
	    };
	    /**
	     * Handle the DOM events for the application.
	     *
	     * @param event - The DOM event sent to the application.
	     *
	     * #### Notes
	     * This method implements the DOM `EventListener` interface and is
	     * called in response to events registered for the application. It
	     * should not be called directly by user code.
	     */
	    Application.prototype.handleEvent = function (event) {
	        switch (event.type) {
	            case 'resize':
	                this.evtResize(event);
	                break;
	            case 'keydown':
	                this.evtKeydown(event);
	                break;
	        }
	    };
	    /**
	     * Attach the application shell to the DOM.
	     *
	     * @param id - The id of the host node for the shell, or `''`.
	     *
	     * #### Notes
	     * If the id is not provided, the document body will be the host.
	     *
	     * A subclass may reimplement this method as needed.
	     */
	    Application.prototype.attachShell = function (id) {
	        widget_1.Widget.attach(this.shell, document.getElementById(id) || document.body);
	    };
	    /**
	     * Add the application event listeners.
	     *
	     * #### Notes
	     * The default implementation of this method adds listeners for
	     * `'keydown'` and `'resize'` events.
	     *
	     * A subclass may reimplement this method as needed.
	     */
	    Application.prototype.addEventListeners = function () {
	        document.addEventListener('keydown', this);
	        window.addEventListener('resize', this);
	    };
	    /**
	     * A method invoked on a document `'keydown'` event.
	     *
	     * #### Notes
	     * The default implementation of this method invokes the key down
	     * processing method of the application keymap.
	     *
	     * A subclass may reimplement this method as needed.
	     */
	    Application.prototype.evtKeydown = function (event) {
	        this.keymap.processKeydownEvent(event);
	    };
	    /**
	     * A method invoked on a window `'resize'` event.
	     *
	     * #### Notes
	     * The default implementation of this method updates the shell.
	     *
	     * A subclass may reimplement this method as needed.
	     */
	    Application.prototype.evtResize = function (event) {
	        this.shell.update();
	    };
	    return Application;
	}());
	exports.Application = Application;
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Create a new plugin map.
	     */
	    function createPluginMap() {
	        return Object.create(null);
	    }
	    Private.createPluginMap = createPluginMap;
	    /**
	     * Create a new service map.
	     */
	    function createServiceMap() {
	        return new Map();
	    }
	    Private.createServiceMap = createServiceMap;
	    /**
	     * Create a normalized plugin data object for the given plugin.
	     */
	    function createPluginData(plugin) {
	        return {
	            id: plugin.id,
	            service: null,
	            promise: null,
	            activated: false,
	            activate: plugin.activate,
	            provides: plugin.provides || null,
	            autoStart: plugin.autoStart || false,
	            requires: plugin.requires ? plugin.requires.slice() : [],
	        };
	    }
	    Private.createPluginData = createPluginData;
	    /**
	     * Ensure no cycle is present in the plugin resolution graph.
	     *
	     * If a cycle is detected, an error will be thrown.
	     */
	    function ensureNoCycle(data, pluginMap, serviceMap) {
	        // Bail early if there cannot be a cycle.
	        if (!data.provides || data.requires.length === 0) {
	            return;
	        }
	        // Setup a stack to trace service resolution.
	        var trace = [data.id];
	        // Throw an exception if a cycle is present.
	        if (data.requires.some(visit)) {
	            throw new Error("Cycle detected: " + trace.join(' -> ') + ".");
	        }
	        function visit(token) {
	            if (token === data.provides) {
	                return true;
	            }
	            var id = serviceMap.get(token);
	            if (!id) {
	                return false;
	            }
	            var other = pluginMap[id];
	            if (other.requires.length === 0) {
	                return false;
	            }
	            trace.push(id);
	            if (other.requires.some(visit)) {
	                return true;
	            }
	            trace.pop();
	            return false;
	        }
	    }
	    Private.ensureNoCycle = ensureNoCycle;
	    /**
	     * Collect the IDs of the plugins to activate on startup.
	     */
	    function collectStartupPlugins(pluginMap, options) {
	        // Create a map to hold the plugin IDs.
	        var resultMap = Object.create(null);
	        // Collect the auto-start plugins.
	        for (var id in pluginMap) {
	            if (pluginMap[id].autoStart) {
	                resultMap[id] = true;
	            }
	        }
	        // Add the startup plugins.
	        if (options.startPlugins) {
	            for (var _i = 0, _a = options.startPlugins; _i < _a.length; _i++) {
	                var id = _a[_i];
	                resultMap[id] = true;
	            }
	        }
	        // Remove the ignored plugins.
	        if (options.ignorePlugins) {
	            for (var _b = 0, _c = options.ignorePlugins; _b < _c.length; _b++) {
	                var id = _c[_b];
	                delete resultMap[id];
	            }
	        }
	        // Return the final startup plugins.
	        return Object.keys(resultMap);
	    }
	    Private.collectStartupPlugins = collectStartupPlugins;
	})(Private || (Private = {}));


/***/ },
/* 3 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var disposable_1 = __webpack_require__(4);
	var signaling_1 = __webpack_require__(6);
	/**
	 * A registry which holds user-defined commands.
	 */
	var CommandRegistry = (function () {
	    /**
	     * Construct a new command registry.
	     */
	    function CommandRegistry() {
	        this._commands = Object.create(null);
	    }
	    /**
	     * List the ids of the registered commands.
	     *
	     * @returns A new array of the registered command ids.
	     */
	    CommandRegistry.prototype.listCommands = function () {
	        return Object.keys(this._commands);
	    };
	    /**
	     * Test whether a specific command is registered.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @returns `true` if the command is registered, `false` otherwise.
	     */
	    CommandRegistry.prototype.hasCommand = function (id) {
	        return id in this._commands;
	    };
	    /**
	     * Add a command to the registry.
	     *
	     * @param id - The unique id of the command.
	     *
	     * @param options - The options for the command.
	     *
	     * @returns A disposable which will unregister the command.
	     *
	     * @throws An error if the given `id` is already registered.
	     */
	    CommandRegistry.prototype.addCommand = function (id, options) {
	        var _this = this;
	        // Throw an error if the id is already registered.
	        if (id in this._commands) {
	            throw new Error("Command '" + id + "' already registered.");
	        }
	        // Create the command and add it to the registry.
	        this._commands[id] = Private.createCommand(options);
	        // Emit the `commandChanged` signal.
	        this.commandChanged.emit({ id: id, type: 'added' });
	        // Return a disposable which will remove the command.
	        return new disposable_1.DisposableDelegate(function () {
	            // Remove the command from the registry.
	            delete _this._commands[id];
	            // Emit the `commandChanged` signal.
	            _this.commandChanged.emit({ id: id, type: 'removed' });
	        });
	    };
	    /**
	     * Notify listeners that the state of a command has changed.
	     *
	     * @param id - The id of the command which has changed.
	     *
	     * #### Notes
	     * This method should be called by the command author whenever the
	     * application state changes such that the results of the command
	     * metadata functions may have changed.
	     *
	     * This will cause the `commandChanged` signal to be emitted.
	     *
	     * If the command is not registered, this is a no-op.
	     */
	    CommandRegistry.prototype.notifyCommandChanged = function (id) {
	        if (id in this._commands) {
	            this.commandChanged.emit({ id: id, type: 'changed' });
	        }
	    };
	    /**
	     * Get the display label for a specific command.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @param args - The arguments for the command.
	     *
	     * @returns The display label for the command.
	     *
	     * #### Notes
	     * Returns an empty string if the command is not registered.
	     */
	    CommandRegistry.prototype.label = function (id, args) {
	        var cmd = this._commands[id];
	        return cmd ? cmd.label.call(void 0, args) : '';
	    };
	    /**
	     * Get the mnemonic index for a specific command.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @param args - The arguments for the command.
	     *
	     * @returns The mnemonic index for the command.
	     *
	     * #### Notes
	     * Returns `-1` if the command is not registered.
	     */
	    CommandRegistry.prototype.mnemonic = function (id, args) {
	        var cmd = this._commands[id];
	        return cmd ? cmd.mnemonic.call(void 0, args) : -1;
	    };
	    /**
	     * Get the icon class for a specific command.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @param args - The arguments for the command.
	     *
	     * @returns The icon class for the command.
	     *
	     * #### Notes
	     * Returns an empty string if the command is not registered.
	     */
	    CommandRegistry.prototype.icon = function (id, args) {
	        var cmd = this._commands[id];
	        return cmd ? cmd.icon.call(void 0, args) : '';
	    };
	    /**
	     * Get the short form caption for a specific command.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @param args - The arguments for the command.
	     *
	     * @returns The caption for the command.
	     *
	     * #### Notes
	     * Returns an empty string if the command is not registered.
	     */
	    CommandRegistry.prototype.caption = function (id, args) {
	        var cmd = this._commands[id];
	        return cmd ? cmd.caption.call(void 0, args) : '';
	    };
	    /**
	     * Get the usage help text for a specific command.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @param args - The arguments for the command.
	     *
	     * @returns The usage text for the command.
	     *
	     * #### Notes
	     * Returns an empty string if the command is not registered.
	     */
	    CommandRegistry.prototype.usage = function (id, args) {
	        var cmd = this._commands[id];
	        return cmd ? cmd.usage.call(void 0, args) : '';
	    };
	    /**
	     * Get the extra class name for a specific command.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @param args - The arguments for the command.
	     *
	     * @returns The class name for the command.
	     *
	     * #### Notes
	     * Returns an empty string if the command is not registered.
	     */
	    CommandRegistry.prototype.className = function (id, args) {
	        var cmd = this._commands[id];
	        return cmd ? cmd.className.call(void 0, args) : '';
	    };
	    /**
	     * Test whether a specific command is enabled.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @param args - The arguments for the command.
	     *
	     * @returns `true` if the command is enabled, `false` otherwise.
	     *
	     * #### Notes
	     * Returns `false` if the command is not registered.
	     */
	    CommandRegistry.prototype.isEnabled = function (id, args) {
	        var cmd = this._commands[id];
	        return cmd ? cmd.isEnabled.call(void 0, args) : false;
	    };
	    /**
	     * Test whether a specific command is toggled.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @param args - The arguments for the command.
	     *
	     * @returns `true` if the command is toggled, `false` otherwise.
	     *
	     * #### Notes
	     * Returns `false` if the command is not registered.
	     */
	    CommandRegistry.prototype.isToggled = function (id, args) {
	        var cmd = this._commands[id];
	        return cmd ? cmd.isToggled.call(void 0, args) : false;
	    };
	    /**
	     * Test whether a specific command is visible.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @param args - The arguments for the command.
	     *
	     * @returns `true` if the command is visible, `false` otherwise.
	     *
	     * #### Notes
	     * Returns `false` if the command is not registered.
	     */
	    CommandRegistry.prototype.isVisible = function (id, args) {
	        var cmd = this._commands[id];
	        return cmd ? cmd.isVisible.call(void 0, args) : false;
	    };
	    /**
	     * Execute a specific command.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @param args - The arguments for the command.
	     *
	     * @returns A promise which resolves to the result of the command.
	     *
	     * #### Notes
	     * The promise will reject if the command is not registered.
	     */
	    CommandRegistry.prototype.execute = function (id, args) {
	        // Reject if the command is not registered.
	        var cmd = this._commands[id];
	        if (!cmd) {
	            return Promise.reject(new Error("Command '" + id + "' not registered."));
	        }
	        // Execute the command and reject if an exception is thrown.
	        var result;
	        try {
	            result = cmd.execute.call(void 0, args);
	        }
	        catch (err) {
	            result = Promise.reject(err);
	        }
	        // Create the return promise which resolves the result.
	        var promise = Promise.resolve(result);
	        // Emit the command executed signal.
	        this.commandExecuted.emit({ id: id, args: args });
	        // Return the result promise to the caller.
	        return promise;
	    };
	    return CommandRegistry;
	}());
	exports.CommandRegistry = CommandRegistry;
	// Define the signals for the `CommandRegistry` class.
	signaling_1.defineSignal(CommandRegistry.prototype, 'commandChanged');
	signaling_1.defineSignal(CommandRegistry.prototype, 'commandExecuted');
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Create a normalized command object from options.
	     */
	    function createCommand(options) {
	        return {
	            execute: options.execute,
	            label: asStringFunc(options.label),
	            mnemonic: asNumberFunc(options.mnemonic),
	            icon: asStringFunc(options.icon),
	            caption: asStringFunc(options.caption),
	            usage: asStringFunc(options.usage),
	            className: asStringFunc(options.className),
	            isEnabled: options.isEnabled || trueFunc,
	            isToggled: options.isToggled || falseFunc,
	            isVisible: options.isVisible || trueFunc
	        };
	    }
	    Private.createCommand = createCommand;
	    /**
	     * A singleton empty string function.
	     */
	    var emptyStringFunc = function (args) { return ''; };
	    /**
	     * A singleton `-1` number function
	     */
	    var negativeOneFunc = function (args) { return -1; };
	    /**
	     * A singleton true boolean function.
	     */
	    var trueFunc = function (args) { return true; };
	    /**
	     * A singleton false boolean function.
	     */
	    var falseFunc = function (args) { return false; };
	    /**
	     * Coerce a value to a string function.
	     */
	    function asStringFunc(value) {
	        if (value === void 0) {
	            return emptyStringFunc;
	        }
	        if (typeof value === 'function') {
	            return value;
	        }
	        return function (args) { return value; };
	    }
	    /**
	     * Coerce a value to a number function.
	     */
	    function asNumberFunc(value) {
	        if (value === void 0) {
	            return negativeOneFunc;
	        }
	        if (typeof value === 'function') {
	            return value;
	        }
	        return function (args) { return value; };
	    }
	})(Private || (Private = {}));


/***/ },
/* 4 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var iteration_1 = __webpack_require__(5);
	/**
	 * A disposable object which delegates to a callback function.
	 */
	var DisposableDelegate = (function () {
	    /**
	     * Construct a new disposable delegate.
	     *
	     * @param callback - The function to invoke on dispose.
	     */
	    function DisposableDelegate(callback) {
	        this._callback = callback || null;
	    }
	    Object.defineProperty(DisposableDelegate.prototype, "isDisposed", {
	        /**
	         * Test whether the delegate has been disposed.
	         *
	         * #### Notes
	         * This is a read-only property which is always safe to access.
	         */
	        get: function () {
	            return this._callback === null;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the delegate and invoke the callback function.
	     *
	     * #### Notes
	     * All calls to this method after the first will be a no-op.
	     */
	    DisposableDelegate.prototype.dispose = function () {
	        if (this._callback === null) {
	            return;
	        }
	        var callback = this._callback;
	        this._callback = null;
	        callback();
	    };
	    return DisposableDelegate;
	}());
	exports.DisposableDelegate = DisposableDelegate;
	/**
	 * An object which manages a collection of disposable items.
	 */
	var DisposableSet = (function () {
	    /**
	     * Construct a new disposable set.
	     *
	     * @param items - The initial disposable items.
	     */
	    function DisposableSet(items) {
	        var _this = this;
	        this._set = new Set();
	        if (items)
	            iteration_1.each(items, function (item) { _this._set.add(item); });
	    }
	    Object.defineProperty(DisposableSet.prototype, "isDisposed", {
	        /**
	         * Test whether the set has been disposed.
	         *
	         * #### Notes
	         * This is a read-only property which is always safe to access.
	         */
	        get: function () {
	            return this._set === null;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the set and the disposable items it contains.
	     *
	     * #### Notes
	     * Items are disposed in the order they are added to the set.
	     *
	     * It is unsafe to use the set after it has been disposed.
	     *
	     * All calls to this method after the first will be a no-op.
	     */
	    DisposableSet.prototype.dispose = function () {
	        if (this._set === null) {
	            return;
	        }
	        var set = this._set;
	        this._set = null;
	        set.forEach(function (item) { item.dispose(); });
	    };
	    /**
	     * Add a disposable item to the set.
	     *
	     * @param item - The disposable item to add to the set. If the item
	     *   is already contained in the set, this is a no-op.
	     *
	     * @throws An error if the set has been disposed.
	     */
	    DisposableSet.prototype.add = function (item) {
	        if (this._set === null) {
	            throw new Error('Object is disposed');
	        }
	        this._set.add(item);
	    };
	    /**
	     * Remove a disposable item from the set.
	     *
	     * @param item - The disposable item to remove from the set. If the
	     *   item does not exist in the set, this is a no-op.
	     *
	     * @throws An error if the set has been disposed.
	     */
	    DisposableSet.prototype.remove = function (item) {
	        if (this._set === null) {
	            throw new Error('Object is disposed');
	        }
	        this._set.delete(item);
	    };
	    /**
	     * Remove all disposable items from the set.
	     *
	     * @throws An error if the set has been disposed.
	     */
	    DisposableSet.prototype.clear = function () {
	        if (this._set === null) {
	            throw new Error('Object is disposed');
	        }
	        this._set.clear();
	    };
	    return DisposableSet;
	}());
	exports.DisposableSet = DisposableSet;


/***/ },
/* 5 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * Create an iterator for an iterable or array-like object.
	 *
	 * @param object - The iterable or array-like object of interest.
	 *
	 * @returns A new iterator for the given object.
	 *
	 * #### Notes
	 * This function allows iteration algorithms to operate on user-defined
	 * iterable types and builtin array-like objects in a uniform fashion.
	 */
	function iter(object) {
	    var it;
	    if (typeof object.iter === 'function') {
	        it = object.iter();
	    }
	    else {
	        it = new ArrayIterator(object, 0);
	    }
	    return it;
	}
	exports.iter = iter;
	/**
	 * Create an array from an iterable of values.
	 *
	 * @param object - The iterable or array-like object of interest.
	 *
	 * @returns A new array of values from the given object.
	 */
	function toArray(object) {
	    var value;
	    var result = [];
	    var it = iter(object);
	    while ((value = it.next()) !== void 0) {
	        result[result.length] = value;
	    }
	    return result;
	}
	exports.toArray = toArray;
	/**
	 * An iterator which is always empty.
	 */
	var EmptyIterator = (function () {
	    /**
	     * Construct a new empty iterator.
	     */
	    function EmptyIterator() {
	    }
	    /**
	     * Create an iterator over the object's values.
	     *
	     * @returns A reference to `this` iterator.
	     */
	    EmptyIterator.prototype.iter = function () {
	        return this;
	    };
	    /**
	     * Create an independent clone of the current iterator.
	     *
	     * @returns A new independent clone of the current iterator.
	     */
	    EmptyIterator.prototype.clone = function () {
	        return new EmptyIterator();
	    };
	    /**
	     * Get the next value from the iterator.
	     *
	     * @returns Always `undefined`.
	     */
	    EmptyIterator.prototype.next = function () {
	        return void 0;
	    };
	    return EmptyIterator;
	}());
	exports.EmptyIterator = EmptyIterator;
	/**
	 * The namespace for the `EmptyIterator` class statics.
	 */
	var EmptyIterator;
	(function (EmptyIterator) {
	    /**
	     * A singleton instance of an empty iterator.
	     */
	    EmptyIterator.instance = new EmptyIterator();
	})(EmptyIterator = exports.EmptyIterator || (exports.EmptyIterator = {}));
	/**
	 * An iterator for an array-like object.
	 *
	 * #### Notes
	 * This iterator can be used for any builtin JS array-like object.
	 */
	var ArrayIterator = (function () {
	    /**
	     * Construct a new array iterator.
	     *
	     * @param source - The array-like object of interest.
	     *
	     * @param start - The starting index for iteration.
	     */
	    function ArrayIterator(source, start) {
	        this._source = source;
	        this._index = start;
	    }
	    /**
	     * Create an iterator over the object's values.
	     *
	     * @returns A reference to `this` iterator.
	     */
	    ArrayIterator.prototype.iter = function () {
	        return this;
	    };
	    /**
	     * Create an independent clone of the current iterator.
	     *
	     * @returns A new independent clone of the current iterator.
	     *
	     * #### Notes
	     * The source array is shared among clones.
	     */
	    ArrayIterator.prototype.clone = function () {
	        return new ArrayIterator(this._source, this._index);
	    };
	    /**
	     * Get the next value from the source array.
	     *
	     * @returns The next value from the source array, or `undefined`
	     *   if the iterator is exhausted.
	     */
	    ArrayIterator.prototype.next = function () {
	        if (this._index >= this._source.length) {
	            return void 0;
	        }
	        return this._source[this._index++];
	    };
	    return ArrayIterator;
	}());
	exports.ArrayIterator = ArrayIterator;
	/**
	 * Invoke a function for each value in an iterable.
	 *
	 * @param object - The iterable or array-like object of interest.
	 *
	 * @param fn - The callback function to invoke for each value.
	 *
	 * #### Notes
	 * Iteration cannot be terminated early.
	 */
	function each(object, fn) {
	    var value;
	    var it = iter(object);
	    while ((value = it.next()) !== void 0) {
	        fn(value);
	    }
	}
	exports.each = each;
	/**
	 * Test whether all values in an iterable satisfy a predicate.
	 *
	 * @param object - The iterable or array-like object of interest.
	 *
	 * @param fn - The predicate function to invoke for each value.
	 *
	 * @returns `true` if all values pass the test, `false` otherwise.
	 *
	 * #### Notes
	 * Iteration terminates on the first `false` predicate result.
	 */
	function every(object, fn) {
	    var value;
	    var it = iter(object);
	    while ((value = it.next()) !== void 0) {
	        if (!fn(value))
	            return false;
	    }
	    return true;
	}
	exports.every = every;
	/**
	 * Test whether any value in an iterable satisfies a predicate.
	 *
	 * @param object - The iterable or array-like object of interest.
	 *
	 * @param fn - The predicate function to invoke for each value.
	 *
	 * @returns `true` if any value passes the test, `false` otherwise.
	 *
	 * #### Notes
	 * Iteration terminates on the first `true` predicate result.
	 */
	function some(object, fn) {
	    var value;
	    var it = iter(object);
	    while ((value = it.next()) !== void 0) {
	        if (fn(value))
	            return true;
	    }
	    return false;
	}
	exports.some = some;
	function reduce(object, fn, initial) {
	    // Setup the iterator and fetch the first value.
	    var it = iter(object);
	    var first = it.next();
	    // An empty iterator and no initial value is an error.
	    if (first === void 0 && initial === void 0) {
	        throw new TypeError('Reduce of empty iterable with no initial value.');
	    }
	    // If the iterator is empty, return the initial value.
	    if (first === void 0) {
	        return initial;
	    }
	    // If the iterator has a single item and no initial value, the
	    // reducer is not invoked and the first item is the return value.
	    var second = it.next();
	    if (second === void 0 && initial === void 0) {
	        return first;
	    }
	    // If iterator has a single item and an initial value is provided,
	    // the reducer is invoked and that result is the return value.
	    if (second === void 0) {
	        return fn(initial, first);
	    }
	    // Setup the initial accumulator value.
	    var accumulator;
	    if (initial === void 0) {
	        accumulator = fn(first, second);
	    }
	    else {
	        accumulator = fn(fn(initial, first), second);
	    }
	    // Iterate the rest of the values, updating the accumulator.
	    var next;
	    while ((next = it.next()) !== void 0) {
	        accumulator = fn(accumulator, next);
	    }
	    // Return the final accumulated value.
	    return accumulator;
	}
	exports.reduce = reduce;
	/**
	 * Filter an iterable for values which pass a test.
	 *
	 * @param object - The iterable or array-like object of interest.
	 *
	 * @param fn - The predicate function to invoke for each value.
	 *
	 * @returns An iterator which yields the values which pass the test.
	 */
	function filter(object, fn) {
	    return new FilterIterator(iter(object), fn);
	}
	exports.filter = filter;
	/**
	 * An iterator which yields values which pass a test.
	 */
	var FilterIterator = (function () {
	    /**
	     * Construct a new filter iterator.
	     *
	     * @param source - The iterator of values of interest.
	     *
	     * @param fn - The predicate function to invoke for each value in
	     *   the iterator. It returns whether the value passes the test.
	     */
	    function FilterIterator(source, fn) {
	        this._source = source;
	        this._fn = fn;
	    }
	    /**
	     * Create an iterator over the object's values.
	     *
	     * @returns A reference to `this` iterator.
	     */
	    FilterIterator.prototype.iter = function () {
	        return this;
	    };
	    /**
	     * Create an independent clone of the current iterator.
	     *
	     * @returns A new independent clone of the current iterator.
	     *
	     * #### Notes
	     * The source iterator must be cloneable.
	     *
	     * The predicate function is shared among clones.
	     */
	    FilterIterator.prototype.clone = function () {
	        return new FilterIterator(this._source.clone(), this._fn);
	    };
	    /**
	     * Get the next value which passes the test.
	     *
	     * @returns The next value from the source iterator which passes
	     *   the predicate, or `undefined` if the iterator is exhausted.
	     */
	    FilterIterator.prototype.next = function () {
	        var value;
	        var fn = this._fn;
	        var it = this._source;
	        while ((value = it.next()) !== void 0) {
	            if (fn(value))
	                return value;
	        }
	        return void 0;
	    };
	    return FilterIterator;
	}());
	exports.FilterIterator = FilterIterator;
	/**
	 * Transform the values of an iterable with a mapping function.
	 *
	 * @param object - The iterable or array-like object of interest.
	 *
	 * @param fn - The mapping function to invoke for each value.
	 *
	 * @returns An iterator which yields the transformed values.
	 */
	function map(object, fn) {
	    return new MapIterator(iter(object), fn);
	}
	exports.map = map;
	/**
	 * An iterator which transforms values using a mapping function.
	 */
	var MapIterator = (function () {
	    /**
	     * Construct a new map iterator.
	     *
	     * @param source - The iterator of values of interest.
	     *
	     * @param fn - The mapping function to invoke for each value in the
	     *   iterator. It returns the transformed value.
	     */
	    function MapIterator(source, fn) {
	        this._source = source;
	        this._fn = fn;
	    }
	    /**
	     * Create an iterator over the object's values.
	     *
	     * @returns A reference to `this` iterator.
	     */
	    MapIterator.prototype.iter = function () {
	        return this;
	    };
	    /**
	     * Create an independent clone of the current iterator.
	     *
	     * @returns A new independent clone of the current iterator.
	     *
	     * #### Notes
	     * The source iterator must be cloneable.
	     *
	     * The mapping function is shared among clones.
	     */
	    MapIterator.prototype.clone = function () {
	        return new MapIterator(this._source.clone(), this._fn);
	    };
	    /**
	     * Get the next mapped value from the source iterator.
	     *
	     * @returns The next value from the source iterator transformed
	     *   by the mapper, or `undefined` if the iterator is exhausted.
	     */
	    MapIterator.prototype.next = function () {
	        var value = this._source.next();
	        if (value === void 0) {
	            return void 0;
	        }
	        return this._fn.call(void 0, value);
	    };
	    return MapIterator;
	}());
	exports.MapIterator = MapIterator;
	/**
	 * Attach an incremental index to an iterable.
	 *
	 * @param object - The iterable or array-like object of interest.
	 *
	 * @param start - The initial value of the index. The default is zero.
	 *
	 * @returns An iterator which yields `[index, value]` tuples.
	 */
	function enumerate(object, start) {
	    if (start === void 0) { start = 0; }
	    return new EnumerateIterator(iter(object), start);
	}
	exports.enumerate = enumerate;
	/**
	 * An iterator which attaches an incremental index to a source.
	 */
	var EnumerateIterator = (function () {
	    /**
	     * Construct a new enumerate iterator.
	     *
	     * @param source - The iterator of values of interest.
	     *
	     * @param start - The initial value of the index.
	     */
	    function EnumerateIterator(source, start) {
	        this._source = source;
	        this._index = start;
	    }
	    /**
	     * Create an iterator over the object's values.
	     *
	     * @returns A reference to `this` iterator.
	     */
	    EnumerateIterator.prototype.iter = function () {
	        return this;
	    };
	    /**
	     * Create an independent clone of the enumerate iterator.
	     *
	     * @returns A new iterator starting with the current value.
	     *
	     * #### Notes
	     * The source iterator must be cloneable.
	     */
	    EnumerateIterator.prototype.clone = function () {
	        return new EnumerateIterator(this._source.clone(), this._index);
	    };
	    /**
	     * Get the next value from the enumeration.
	     *
	     * @returns The next value from the enumeration, or `undefined` if
	     *   the iterator is exhausted.
	     */
	    EnumerateIterator.prototype.next = function () {
	        var value = this._source.next();
	        if (value === void 0) {
	            return void 0;
	        }
	        return [this._index++, value];
	    };
	    return EnumerateIterator;
	}());
	exports.EnumerateIterator = EnumerateIterator;
	/**
	 * Iterate several iterables in lockstep.
	 *
	 * @param objects - The iterables or array-like objects of interest.
	 *
	 * @returns An iterator which yields successive tuples of values where
	 *   each value is taken in turn from the provided iterables. It will
	 *   be as long as the shortest provided iterable.
	 */
	function zip() {
	    var objects = [];
	    for (var _i = 0; _i < arguments.length; _i++) {
	        objects[_i - 0] = arguments[_i];
	    }
	    return new ZipIterator(objects.map(iter));
	}
	exports.zip = zip;
	/**
	 * An iterator which iterates several sources in lockstep.
	 */
	var ZipIterator = (function () {
	    /**
	     * Construct a new zip iterator.
	     *
	     * @param source - The iterators of interest.
	     */
	    function ZipIterator(source) {
	        this._source = source;
	    }
	    /**
	     * Create an iterator over the object's values.
	     *
	     * @returns A reference to `this` iterator.
	     */
	    ZipIterator.prototype.iter = function () {
	        return this;
	    };
	    /**
	     * Create an independent clone of the zip iterator.
	     *
	     * @returns A new iterator starting with the current value.
	     *
	     * #### Notes
	     * The source iterators must be cloneable.
	     */
	    ZipIterator.prototype.clone = function () {
	        return new ZipIterator(this._source.map(function (it) { return it.clone(); }));
	    };
	    /**
	     * Get the next zipped value from the iterator.
	     *
	     * @returns The next zipped value from the iterator, or `undefined`
	     *   when the first source iterator is exhausted.
	     */
	    ZipIterator.prototype.next = function () {
	        var iters = this._source;
	        var result = new Array(iters.length);
	        for (var i = 0, n = iters.length; i < n; ++i) {
	            var value = iters[i].next();
	            if (value === void 0) {
	                return void 0;
	            }
	            result[i] = value;
	        }
	        return result;
	    };
	    return ZipIterator;
	}());
	exports.ZipIterator = ZipIterator;
	/**
	 * Iterate over an iterable using a stepped increment.
	 *
	 * @param object - The iterable or array-like object of interest.
	 *
	 * @param step - The distance to step on each iteration. A value
	 *   of less than `1` will behave the same as a value of `1`.
	 *
	 * @returns An iterator which traverses the iterable step-wise.
	 */
	function stride(object, step) {
	    return new StrideIterator(iter(object), step);
	}
	exports.stride = stride;
	/**
	 * An iterator which traverses a source iterator step-wise.
	 */
	var StrideIterator = (function () {
	    /**
	     * Construct a new stride iterator.
	     *
	     * @param source - The iterator of values of interest.
	     *
	     * @param step - The distance to step on each iteration. A value
	     *   of less than `1` will behave the same as a value of `1`.
	     */
	    function StrideIterator(source, step) {
	        this._source = source;
	        this._step = step;
	    }
	    /**
	     * Create an iterator over the object's values.
	     *
	     * @returns A reference to `this` iterator.
	     */
	    StrideIterator.prototype.iter = function () {
	        return this;
	    };
	    /**
	     * Create an independent clone of the stride iterator.
	     *
	     * @returns A new iterator starting with the current value.
	     *
	     * #### Notes
	     * The source iterator must be cloneable.
	     */
	    StrideIterator.prototype.clone = function () {
	        return new StrideIterator(this._source.clone(), this._step);
	    };
	    /**
	     * Get the next stepped value from the iterator.
	     *
	     * @returns The next stepped value from the iterator, or `undefined`
	     *   when the source iterator is exhausted.
	     */
	    StrideIterator.prototype.next = function () {
	        var value = this._source.next();
	        if (value === void 0) {
	            return void 0;
	        }
	        var step = this._step;
	        while (--step > 0) {
	            this._source.next();
	        }
	        return value;
	    };
	    return StrideIterator;
	}());
	exports.StrideIterator = StrideIterator;


/***/ },
/* 6 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(setImmediate) {/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * Define a signal property on a prototype object.
	 *
	 * @param target - The prototype for the class of interest.
	 *
	 * @param name - The name of the signal property.
	 *
	 * #### Notes
	 * The defined signal property is read-only.
	 *
	 * #### Example
	 * ```typescript
	 * class SomeClass {
	 *   valueChanged: ISignal<SomeClass, number>;
	 * }
	 *
	 * defineSignal(SomeClass.prototype, 'valueChanged');
	 */
	function defineSignal(target, name) {
	    var token = Object.freeze({});
	    Object.defineProperty(target, name, {
	        get: function () { return new Signal(this, token); }
	    });
	}
	exports.defineSignal = defineSignal;
	/**
	 * Remove all connections where the given object is the sender.
	 *
	 * @param sender - The sender object of interest.
	 *
	 * #### Example
	 * ```typescript
	 * disconnectSender(someObject);
	 * ```
	 */
	function disconnectSender(sender) {
	    // If there are no receivers, there is nothing to do.
	    var receiverList = senderData.get(sender);
	    if (receiverList === void 0) {
	        return;
	    }
	    // Clear the connections and schedule a cleanup of the
	    // receiver's corresponding list of sender connections.
	    for (var i = 0, n = receiverList.length; i < n; ++i) {
	        var conn = receiverList[i];
	        var senderList = receiverData.get(conn.thisArg || conn.slot);
	        scheduleCleanup(senderList);
	        conn.token = null;
	    }
	    // Schedule a cleanup of the receiver list.
	    scheduleCleanup(receiverList);
	}
	exports.disconnectSender = disconnectSender;
	/**
	 * Remove all connections where the given object is the receiver.
	 *
	 * @param receiver - The receiver object of interest.
	 *
	 * #### Notes
	 * If a `thisArg` is provided when connecting a signal, that object
	 * is considered the receiver. Otherwise, the `callback` is used as
	 * the receiver.
	 *
	 * #### Example
	 * ```typescript
	 * // disconnect a regular object receiver
	 * disconnectReceiver(myObject);
	 *
	 * // disconnect a plain callback receiver
	 * disconnectReceiver(myCallback);
	 * ```
	 */
	function disconnectReceiver(receiver) {
	    // If there are no senders, there is nothing to do.
	    var senderList = receiverData.get(receiver);
	    if (senderList === void 0) {
	        return;
	    }
	    // Clear the connections and schedule a cleanup of the
	    // senders's corresponding list of receiver connections.
	    for (var i = 0, n = senderList.length; i < n; ++i) {
	        var conn = senderList[i];
	        var receiverList = senderData.get(conn.sender);
	        scheduleCleanup(receiverList);
	        conn.token = null;
	    }
	    // Schedule a cleanup of the sender list.
	    scheduleCleanup(senderList);
	}
	exports.disconnectReceiver = disconnectReceiver;
	/**
	 * Clear all signal data associated with the given object.
	 *
	 * @param obj - The object for which the signal data should be cleared.
	 *
	 * #### Notes
	 * This removes all signal connections where the object is used as
	 * either the sender or the receiver.
	 *
	 * #### Example
	 * ```typescript
	 * clearSignalData(someObject);
	 * ```
	 */
	function clearSignalData(obj) {
	    disconnectSender(obj);
	    disconnectReceiver(obj);
	}
	exports.clearSignalData = clearSignalData;
	/**
	 * A concrete implementation of `ISignal`.
	 */
	var Signal = (function () {
	    /**
	     * Construct a new signal.
	     *
	     * @param sender - The object which owns the signal.
	     *
	     * @param token - The unique token identifying the signal.
	     */
	    function Signal(sender, token) {
	        this._sender = sender;
	        this._token = token;
	    }
	    /**
	     * Connect a slot to the signal.
	     *
	     * @param slot - The slot to invoke when the signal is emitted.
	     *
	     * @param thisArg - The `this` context for the slot. If provided,
	     *   this must be a non-primitive object.
	     *
	     * @returns `true` if the connection succeeds, `false` otherwise.
	     */
	    Signal.prototype.connect = function (slot, thisArg) {
	        return connect(this._sender, this._token, slot, thisArg);
	    };
	    /**
	     * Disconnect a slot from the signal.
	     *
	     * @param slot - The slot to disconnect from the signal.
	     *
	     * @param thisArg - The `this` context for the slot. If provided,
	     *   this must be a non-primitive object.
	     *
	     * @returns `true` if the connection is removed, `false` otherwise.
	     */
	    Signal.prototype.disconnect = function (slot, thisArg) {
	        return disconnect(this._sender, this._token, slot, thisArg);
	    };
	    /**
	     * Emit the signal and invoke the connected slots.
	     *
	     * @param args - The args to pass to the connected slots.
	     */
	    Signal.prototype.emit = function (args) {
	        emit(this._sender, this._token, args);
	    };
	    return Signal;
	}());
	/**
	 * A weak mapping of sender to list of receiver connections.
	 */
	var senderData = new WeakMap();
	/**
	 * A weak mapping of receiver to list of sender connections.
	 */
	var receiverData = new WeakMap();
	/**
	 * A set of connection lists which are pending cleanup.
	 */
	var dirtySet = new Set();
	/**
	 * A local reference to an event loop callback.
	 */
	var defer = (function () {
	    var ok = typeof requestAnimationFrame === 'function';
	    return ok ? requestAnimationFrame : setImmediate;
	})();
	/**
	 * Connect a slot to a signal.
	 *
	 * @param sender - The object emitting the signal.
	 *
	 * @param token - The unique token for the signal.
	 *
	 * @param slot - The slot to connect to the signal.
	 *
	 * @param thisArg - The `this` context for the slot.
	 *
	 * @returns `true` if the connection succeeds, `false` otherwise.
	 *
	 * #### Notes
	 * Signal connections are unique. If a connection already exists for
	 * the given `slot` and `thisArg`, this function returns `false`.
	 *
	 * A newly connected slot will not be invoked until the next time the
	 * signal is emitted, even if the slot is connected while the signal
	 * is dispatching.
	 */
	function connect(sender, token, slot, thisArg) {
	    // Coerce a `null` thisArg to `undefined`.
	    thisArg = thisArg || void 0;
	    // Ensure the sender's receiver list is created.
	    var receiverList = senderData.get(sender);
	    if (receiverList === void 0) {
	        receiverList = [];
	        senderData.set(sender, receiverList);
	    }
	    // Bail if a matching connection already exists.
	    if (findConnection(receiverList, token, slot, thisArg) !== null) {
	        return false;
	    }
	    // Ensure the receiver's sender list is created.
	    var receiver = thisArg || slot;
	    var senderList = receiverData.get(receiver);
	    if (senderList === void 0) {
	        senderList = [];
	        receiverData.set(receiver, senderList);
	    }
	    // Create a new connection and add it to the end of each list.
	    var connection = { sender: sender, token: token, slot: slot, thisArg: thisArg };
	    receiverList.push(connection);
	    senderList.push(connection);
	    // Indicate a successful connection.
	    return true;
	}
	/**
	 * Disconnect a slot from a signal.
	 *
	 * @param sender - The object emitting the signal.
	 *
	 * @param token - The unique token for the signal.
	 *
	 * @param slot - The slot to disconnect from the signal.
	 *
	 * @param thisArg - The `this` context for the slot.
	 *
	 * @returns `true` if the connection is removed, `false` otherwise.
	 *
	 * #### Notes
	 * If no connection exists for the given `slot` and `thisArg`, this
	 * function returns `false`.
	 *
	 * A disconnected slot will no longer be invoked, even if the slot
	 * is disconnected while the signal is dispatching.
	 */
	function disconnect(sender, token, slot, thisArg) {
	    // Coerce a `null` thisArg to `undefined`.
	    thisArg = thisArg || void 0;
	    // Lookup the list of receivers, and bail if none exist.
	    var receiverList = senderData.get(sender);
	    if (receiverList === void 0) {
	        return false;
	    }
	    // Bail if no matching connection exits.
	    var conn = findConnection(receiverList, token, slot, thisArg);
	    if (conn === null) {
	        return false;
	    }
	    // Lookup the list of senders, which is now known to exist.
	    var senderList = receiverData.get(thisArg || slot);
	    // Clear the connection and schedule list cleanup.
	    conn.token = null;
	    scheduleCleanup(receiverList);
	    scheduleCleanup(senderList);
	    // Indicate a successful disconnection.
	    return true;
	}
	/**
	 * Emit a signal and invoke the connected slots.
	 *
	 * @param sender - The object emitting the signal.
	 *
	 * @param token - The unique token for the signal.
	 *
	 * @param args - The args to pass to the connected slots.
	 *
	 * #### Notes
	 * Connected slots are invoked synchronously, in the order in which
	 * they are connected.
	 *
	 * Exceptions thrown by connected slots will be caught and logged.
	 */
	function emit(sender, token, args) {
	    // If there are no receivers, there is nothing to do.
	    var receiverList = senderData.get(sender);
	    if (receiverList === void 0) {
	        return;
	    }
	    // Invoke the connections which match the given token.
	    for (var i = 0, n = receiverList.length; i < n; ++i) {
	        var conn = receiverList[i];
	        if (conn.token === token) {
	            invokeSlot(conn, args);
	        }
	    }
	}
	/**
	 * Safely invoke a non-empty connection.
	 *
	 * @param conn - The connection of interest
	 *
	 * @param args - The arguments to pass to the slot.
	 *
	 * #### Notes
	 * Any exception thrown by the slot will be caught and logged.
	 */
	function invokeSlot(conn, args) {
	    try {
	        conn.slot.call(conn.thisArg, conn.sender, args);
	    }
	    catch (err) {
	        console.error(err);
	    }
	}
	/**
	 * Find a connection which matches the given parameters.
	 *
	 * @param list - The list of connections to search.
	 *
	 * @param token - The unique token for the signal.
	 *
	 * @param slot - The slot of interest.
	 *
	 * @param thisArg - The `this` context for the slot.
	 *
	 * @returns The first connection which matches the supplied parameters,
	 *   or null if no matching connection is found.
	 */
	function findConnection(list, token, slot, thisArg) {
	    for (var i = 0, n = list.length; i < n; ++i) {
	        var conn = list[i];
	        if (conn.token === token &&
	            conn.slot === slot &&
	            conn.thisArg === thisArg) {
	            return conn;
	        }
	    }
	    return null;
	}
	/**
	 * Schedule a cleanup of a connection list.
	 *
	 * @param list - The list of connections to cleanup.
	 *
	 * #### Notes
	 * This will add the list to the dirty set and schedule a deferred
	 * cleanup of the list contents. On cleanup, any connection with a
	 * null token will be removed from the array.
	 */
	function scheduleCleanup(list) {
	    if (dirtySet.size === 0) {
	        defer(cleanupDirtySet);
	    }
	    dirtySet.add(list);
	}
	/**
	 * Cleanup the connection lists in the dirty set.
	 *
	 * #### Notes
	 * This function should only be invoked asynchronously, when the stack
	 * frame is guaranteed to not be on the path of a signal dispatch.
	 */
	function cleanupDirtySet() {
	    dirtySet.forEach(cleanupList);
	    dirtySet.clear();
	}
	/**
	 * Cleanup the dirty connections in a connection list.
	 *
	 * @param list - The list of connection to cleanup.
	 *
	 * #### Notes
	 * This will remove any connection with a null token from the list,
	 * while retaining the relative order of the other connections.
	 *
	 * This function should only be invoked asynchronously, when the stack
	 * frame is guaranteed to not be on the path of a signal dispatch.
	 */
	function cleanupList(list) {
	    var count = 0;
	    for (var i = 0, n = list.length; i < n; ++i) {
	        var conn = list[i];
	        if (conn.token === null) {
	            count++;
	        }
	        else {
	            list[i - count] = conn;
	        }
	    }
	    list.length -= count;
	}
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(7).setImmediate))

/***/ },
/* 7 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(setImmediate, clearImmediate) {var nextTick = __webpack_require__(8).nextTick;
	var apply = Function.prototype.apply;
	var slice = Array.prototype.slice;
	var immediateIds = {};
	var nextImmediateId = 0;
	
	// DOM APIs, for completeness
	
	exports.setTimeout = function() {
	  return new Timeout(apply.call(setTimeout, window, arguments), clearTimeout);
	};
	exports.setInterval = function() {
	  return new Timeout(apply.call(setInterval, window, arguments), clearInterval);
	};
	exports.clearTimeout =
	exports.clearInterval = function(timeout) { timeout.close(); };
	
	function Timeout(id, clearFn) {
	  this._id = id;
	  this._clearFn = clearFn;
	}
	Timeout.prototype.unref = Timeout.prototype.ref = function() {};
	Timeout.prototype.close = function() {
	  this._clearFn.call(window, this._id);
	};
	
	// Does not start the time, just sets up the members needed.
	exports.enroll = function(item, msecs) {
	  clearTimeout(item._idleTimeoutId);
	  item._idleTimeout = msecs;
	};
	
	exports.unenroll = function(item) {
	  clearTimeout(item._idleTimeoutId);
	  item._idleTimeout = -1;
	};
	
	exports._unrefActive = exports.active = function(item) {
	  clearTimeout(item._idleTimeoutId);
	
	  var msecs = item._idleTimeout;
	  if (msecs >= 0) {
	    item._idleTimeoutId = setTimeout(function onTimeout() {
	      if (item._onTimeout)
	        item._onTimeout();
	    }, msecs);
	  }
	};
	
	// That's not how node.js implements it but the exposed api is the same.
	exports.setImmediate = typeof setImmediate === "function" ? setImmediate : function(fn) {
	  var id = nextImmediateId++;
	  var args = arguments.length < 2 ? false : slice.call(arguments, 1);
	
	  immediateIds[id] = true;
	
	  nextTick(function onNextTick() {
	    if (immediateIds[id]) {
	      // fn.call() is faster so we optimize for the common use-case
	      // @see http://jsperf.com/call-apply-segu
	      if (args) {
	        fn.apply(null, args);
	      } else {
	        fn.call(null);
	      }
	      // Prevent ids from leaking
	      exports.clearImmediate(id);
	    }
	  });
	
	  return id;
	};
	
	exports.clearImmediate = typeof clearImmediate === "function" ? clearImmediate : function(id) {
	  delete immediateIds[id];
	};
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(7).setImmediate, __webpack_require__(7).clearImmediate))

/***/ },
/* 8 */
/***/ function(module, exports) {

	// shim for using process in browser
	var process = module.exports = {};
	
	// cached from whatever global is present so that test runners that stub it
	// don't break things.  But we need to wrap it in a try catch in case it is
	// wrapped in strict mode code which doesn't define any globals.  It's inside a
	// function because try/catches deoptimize in certain engines.
	
	var cachedSetTimeout;
	var cachedClearTimeout;
	
	(function () {
	    try {
	        cachedSetTimeout = setTimeout;
	    } catch (e) {
	        cachedSetTimeout = function () {
	            throw new Error('setTimeout is not defined');
	        }
	    }
	    try {
	        cachedClearTimeout = clearTimeout;
	    } catch (e) {
	        cachedClearTimeout = function () {
	            throw new Error('clearTimeout is not defined');
	        }
	    }
	} ())
	function runTimeout(fun) {
	    if (cachedSetTimeout === setTimeout) {
	        //normal enviroments in sane situations
	        return setTimeout(fun, 0);
	    }
	    try {
	        // when when somebody has screwed with setTimeout but no I.E. maddness
	        return cachedSetTimeout(fun, 0);
	    } catch(e){
	        try {
	            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
	            return cachedSetTimeout.call(null, fun, 0);
	        } catch(e){
	            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
	            return cachedSetTimeout.call(this, fun, 0);
	        }
	    }
	
	
	}
	function runClearTimeout(marker) {
	    if (cachedClearTimeout === clearTimeout) {
	        //normal enviroments in sane situations
	        return clearTimeout(marker);
	    }
	    try {
	        // when when somebody has screwed with setTimeout but no I.E. maddness
	        return cachedClearTimeout(marker);
	    } catch (e){
	        try {
	            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
	            return cachedClearTimeout.call(null, marker);
	        } catch (e){
	            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
	            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
	            return cachedClearTimeout.call(this, marker);
	        }
	    }
	
	
	
	}
	var queue = [];
	var draining = false;
	var currentQueue;
	var queueIndex = -1;
	
	function cleanUpNextTick() {
	    if (!draining || !currentQueue) {
	        return;
	    }
	    draining = false;
	    if (currentQueue.length) {
	        queue = currentQueue.concat(queue);
	    } else {
	        queueIndex = -1;
	    }
	    if (queue.length) {
	        drainQueue();
	    }
	}
	
	function drainQueue() {
	    if (draining) {
	        return;
	    }
	    var timeout = runTimeout(cleanUpNextTick);
	    draining = true;
	
	    var len = queue.length;
	    while(len) {
	        currentQueue = queue;
	        queue = [];
	        while (++queueIndex < len) {
	            if (currentQueue) {
	                currentQueue[queueIndex].run();
	            }
	        }
	        queueIndex = -1;
	        len = queue.length;
	    }
	    currentQueue = null;
	    draining = false;
	    runClearTimeout(timeout);
	}
	
	process.nextTick = function (fun) {
	    var args = new Array(arguments.length - 1);
	    if (arguments.length > 1) {
	        for (var i = 1; i < arguments.length; i++) {
	            args[i - 1] = arguments[i];
	        }
	    }
	    queue.push(new Item(fun, args));
	    if (queue.length === 1 && !draining) {
	        runTimeout(drainQueue);
	    }
	};
	
	// v8 likes predictible objects
	function Item(fun, array) {
	    this.fun = fun;
	    this.array = array;
	}
	Item.prototype.run = function () {
	    this.fun.apply(null, this.array);
	};
	process.title = 'browser';
	process.browser = true;
	process.env = {};
	process.argv = [];
	process.version = ''; // empty string to avoid regexp issues
	process.versions = {};
	
	function noop() {}
	
	process.on = noop;
	process.addListener = noop;
	process.once = noop;
	process.off = noop;
	process.removeListener = noop;
	process.removeAllListeners = noop;
	process.emit = noop;
	
	process.binding = function (name) {
	    throw new Error('process.binding is not supported');
	};
	
	process.cwd = function () { return '/' };
	process.chdir = function (dir) {
	    throw new Error('process.chdir is not supported');
	};
	process.umask = function() { return 0; };


/***/ },
/* 9 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var json_1 = __webpack_require__(10);
	var searching_1 = __webpack_require__(11);
	var vector_1 = __webpack_require__(13);
	var disposable_1 = __webpack_require__(4);
	var signaling_1 = __webpack_require__(6);
	var platform_1 = __webpack_require__(14);
	var selector_1 = __webpack_require__(15);
	var keyboard_1 = __webpack_require__(16);
	/**
	 * The timeout in ms for triggering a chord.
	 */
	var CHORD_TIMEOUT = 1000;
	/**
	 * A class which manages a collection of key bindings.
	 */
	var Keymap = (function () {
	    /**
	     * Construct a new keymap.
	     *
	     * @param options - The options for initializing the keymap.
	     */
	    function Keymap(options) {
	        this._timerID = 0;
	        this._replaying = false;
	        this._keys = [];
	        this._events = [];
	        this._exact = null;
	        this._bindings = new vector_1.Vector();
	        this._commands = options.commands;
	        this._layout = options.layout || keyboard_1.EN_US;
	    }
	    Object.defineProperty(Keymap.prototype, "commands", {
	        /**
	         * The command registry used by the keymap.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._commands;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Keymap.prototype, "layout", {
	        /**
	         * Get the keyboard layout used by the keymap.
	         *
	         * #### Notes
	         * The default is a US English layout.
	         */
	        get: function () {
	            return this._layout;
	        },
	        /**
	         * Set the keyboard layout used by the keymap.
	         *
	         * #### Notes
	         * A keymap requires a keyboard layout, so setting this value to
	         * `null` will revert the layout to the default US English layout.
	         */
	        set: function (value) {
	            var oldValue = this._layout;
	            var newValue = value || keyboard_1.EN_US;
	            if (oldValue === newValue) {
	                return;
	            }
	            this._layout = newValue;
	            this.layoutChanged.emit({ oldValue: oldValue, newValue: newValue });
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Keymap.prototype, "bindings", {
	        /**
	         * A read-only sequence of the key bindings in the keymap.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._bindings;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Find a key binding which matches the given command and args.
	     *
	     * @param command - The id of the command of interest.
	     *
	     * @param args - The arguments for the command.
	     *
	     * @returns The most recently added key binding which matches the
	     *   specified command and args, or `null` if no match is found.
	     *
	     * #### Notes
	     * This is a convenience method which searches through the public
	     * sequence of key `bindings`. If custom search behavior is needed,
	     * user code may search that sequence manually.
	     */
	    Keymap.prototype.findBinding = function (command, args) {
	        var i = searching_1.findLastIndex(this._bindings, function (kb) {
	            return kb.command === command && json_1.deepEqual(kb.args, args);
	        });
	        return i !== -1 ? this._bindings.at(i) : null;
	    };
	    /**
	     * Add a key binding to the keymap.
	     *
	     * @param options - The options for creating the key binding.
	     *
	     * @returns A disposable which removes the added key binding.
	     *
	     * #### Notes
	     * If multiple key bindings are registered for the same sequence, the
	     * binding with the highest selector specificity is executed first. A
	     * tie is broken by using the most recently added key binding.
	     *
	     * Ambiguous key bindings are resolved with a timeout. As an example,
	     * suppose two key bindings are registered: one with the key sequence
	     * `['Ctrl D']`, and another with `['Ctrl D', 'Ctrl W']`. If the user
	     * presses `Ctrl D`, the first binding cannot be immediately executed
	     * since the user may intend to complete the chord with `Ctrl W`. For
	     * such cases, a timer is used to allow the chord to be completed. If
	     * the chord is not completed before the timeout, the first binding
	     * is executed.
	     */
	    Keymap.prototype.addBinding = function (options) {
	        var _this = this;
	        // Create the binding for the given options.
	        var binding = Private.createBinding(options);
	        // Add the key binding to the internal vector.
	        this._bindings.pushBack(binding);
	        // Emit the `bindingChanged` signal.
	        this.bindingChanged.emit({ binding: binding, type: 'added' });
	        // Return a disposable which will remove the binding.
	        return new disposable_1.DisposableDelegate(function () {
	            // Remove the binding from the vector.
	            _this._bindings.remove(binding);
	            // Emit the `bindingChanged` signal.
	            _this.bindingChanged.emit({ binding: binding, type: 'removed' });
	        });
	    };
	    /**
	     * Process a `'keydown'` event and invoke a matching key binding.
	     *
	     * @param event - The event object for a `'keydown'` event.
	     *
	     * #### Notes
	     * This should be called in response to a `'keydown'` event in order
	     * to invoke the command for the best matching key binding.
	     *
	     * The keymap **does not** install its own key event listeners. This
	     * allows the application full control over the nodes for which the
	     * keymap processes `'keydown'` events.
	     */
	    Keymap.prototype.processKeydownEvent = function (event) {
	        // Bail immediately if playing back keystrokes.
	        if (this._replaying) {
	            return;
	        }
	        // Get the normalized keystroke for the event.
	        var keystroke = Keymap.keystrokeForKeydownEvent(event, this._layout);
	        // If the keystroke is not valid for the keyboard layout, replay
	        // any suppressed events and clear the pending state.
	        if (!keystroke) {
	            this._replayEvents();
	            this._clearPendingState();
	            return;
	        }
	        // Add the keystroke to the current key sequence.
	        this._keys.push(keystroke);
	        // Find the exact and partial matches for the key sequence.
	        var _a = Private.match(this._bindings, this._keys, event), exact = _a.exact, partial = _a.partial;
	        // If there is no exact match and no partial match, replay
	        // any suppressed events and clear the pending state.
	        if (!exact && !partial) {
	            this._replayEvents();
	            this._clearPendingState();
	            return;
	        }
	        // Stop propagation of the event. If there is only a partial match,
	        // the event will be replayed if a final exact match never occurs.
	        event.preventDefault();
	        event.stopPropagation();
	        // If there is an exact match but no partial match, the exact match
	        // can be dispatched immediately. The pending state is cleared so
	        // the next key press starts from the default state.
	        if (!partial) {
	            this._execute(exact);
	            this._clearPendingState();
	            return;
	        }
	        // If there is both an exact match and a partial match, the exact
	        // match is stored for future dispatch in case the timer expires
	        // before a more specific match is triggered.
	        if (exact)
	            this._exact = exact;
	        // Store the event for possible playback in the future.
	        this._events.push(event);
	        // (Re)start the timer to dispatch the most recent exact match
	        // in case the partial match fails to result in an exact match.
	        this._startTimer();
	    };
	    /**
	     * Start or restart the pending timeout.
	     */
	    Keymap.prototype._startTimer = function () {
	        var _this = this;
	        this._clearTimer();
	        this._timerID = setTimeout(function () {
	            _this._onPendingTimeout();
	        }, CHORD_TIMEOUT);
	    };
	    /**
	     * Clear the pending timeout.
	     */
	    Keymap.prototype._clearTimer = function () {
	        if (this._timerID !== 0) {
	            clearTimeout(this._timerID);
	            this._timerID = 0;
	        }
	    };
	    /**
	     * Clear the internal pending state.
	     */
	    Keymap.prototype._clearPendingState = function () {
	        this._clearTimer();
	        this._exact = null;
	        this._keys.length = 0;
	        this._events.length = 0;
	    };
	    /**
	     * Replay the events which were suppressed.
	     */
	    Keymap.prototype._replayEvents = function () {
	        if (this._events.length === 0) {
	            return;
	        }
	        this._replaying = true;
	        this._events.forEach(Private.replayEvent);
	        this._replaying = false;
	    };
	    /**
	     * Execute the command for the given key binding.
	     *
	     * If the command is disabled, a message will be logged.
	     */
	    Keymap.prototype._execute = function (binding) {
	        var command = binding.command, args = binding.args;
	        if (this._commands.isEnabled(command, args)) {
	            this._commands.execute(command, args);
	        }
	        else {
	            // TODO - right way to handle disabled command?
	            var formatted = binding.keys.map(Keymap.formatKeystroke).join(' ');
	            console.log("Command '" + command + "' is disabled (" + formatted + ").");
	        }
	    };
	    /**
	     * Handle the partial match timeout.
	     */
	    Keymap.prototype._onPendingTimeout = function () {
	        this._timerID = 0;
	        if (this._exact) {
	            this._execute(this._exact);
	        }
	        else {
	            this._replayEvents();
	        }
	        this._clearPendingState();
	    };
	    return Keymap;
	}());
	exports.Keymap = Keymap;
	// Define the signals for the `Keymap` class.
	signaling_1.defineSignal(Keymap.prototype, 'bindingChanged');
	signaling_1.defineSignal(Keymap.prototype, 'layoutChanged');
	/**
	 * The namespace for the `Keymap` class statics.
	 */
	var Keymap;
	(function (Keymap) {
	    /**
	     * Parse a keystroke into its constituent components.
	     *
	     * @param keystroke - The keystroke of interest.
	     *
	     * @returns The parsed components of the keystroke.
	     *
	     * #### Notes
	     * The keystroke should be of the form:
	     *   `[<modifier 1> [<modifier 2> [<modifier N> ]]]<primary key>`
	     *
	     * The supported modifiers are: `Accel`, `Alt`, `Cmd`, `Ctrl`, and
	     * `Shift`. The `Accel` modifier is translated to `Cmd` on Mac and
	     * `Ctrl` on all other platforms.
	     *
	     * The parsing is tolerant and will not throw exceptions. Notably:
	     *   - Duplicate modifiers are ignored.
	     *   - Extra primary keys are ignored.
	     *   - The order of modifiers and primary key is irrelevant.
	     *   - The keystroke parts should be separated by whitespace.
	     *   - The keystroke is case sensitive.
	     */
	    function parseKeystroke(keystroke) {
	        var key = '';
	        var alt = false;
	        var cmd = false;
	        var ctrl = false;
	        var shift = false;
	        for (var _i = 0, _a = keystroke.split(/\s+/); _i < _a.length; _i++) {
	            var token = _a[_i];
	            if (token === 'Accel') {
	                if (platform_1.IS_MAC) {
	                    cmd = true;
	                }
	                else {
	                    ctrl = true;
	                }
	            }
	            else if (token === 'Alt') {
	                alt = true;
	            }
	            else if (token === 'Cmd') {
	                cmd = true;
	            }
	            else if (token === 'Ctrl') {
	                ctrl = true;
	            }
	            else if (token === 'Shift') {
	                shift = true;
	            }
	            else if (token.length > 0) {
	                key = token;
	            }
	        }
	        return { cmd: cmd, ctrl: ctrl, alt: alt, shift: shift, key: key };
	    }
	    Keymap.parseKeystroke = parseKeystroke;
	    /**
	     * Normalize a keystroke into a canonical representation.
	     *
	     * @param keystroke - The keystroke of interest.
	     *
	     * @returns The normalized representation of the keystroke.
	     *
	     * #### Notes
	     * This normalizes the keystroke by removing duplicate modifiers and
	     * extra primary keys, and assembling the parts in a canonical order.
	     *
	     * The `Cmd` modifier is ignored on non-Mac platforms.
	     */
	    function normalizeKeystroke(keystroke) {
	        var mods = '';
	        var parts = parseKeystroke(keystroke);
	        if (parts.ctrl) {
	            mods += 'Ctrl ';
	        }
	        if (parts.alt) {
	            mods += 'Alt ';
	        }
	        if (parts.shift) {
	            mods += 'Shift ';
	        }
	        if (parts.cmd && platform_1.IS_MAC) {
	            mods += 'Cmd ';
	        }
	        return mods + parts.key;
	    }
	    Keymap.normalizeKeystroke = normalizeKeystroke;
	    /**
	     * Format a keystroke for display on the local system.
	     *
	     * @param keystroke - The keystroke of interest.
	     *
	     * @returns The keystroke formatted for display on the local system.
	     *
	     * #### Notes
	     * On Mac, this replaces the modifiers with the Mac-specific unicode
	     * characters. On other systems, this joins the modifiers with `+`.
	     */
	    function formatKeystroke(keystroke) {
	        var mods = '';
	        var parts = parseKeystroke(keystroke);
	        if (platform_1.IS_MAC) {
	            if (parts.ctrl) {
	                mods += '\u2303';
	            }
	            if (parts.alt) {
	                mods += '\u2325';
	            }
	            if (parts.shift) {
	                mods += '\u21E7';
	            }
	            if (parts.cmd) {
	                mods += '\u2318';
	            }
	        }
	        else {
	            if (parts.ctrl) {
	                mods += 'Ctrl+';
	            }
	            if (parts.alt) {
	                mods += 'Alt+';
	            }
	            if (parts.shift) {
	                mods += 'Shift+';
	            }
	        }
	        return mods + parts.key;
	    }
	    Keymap.formatKeystroke = formatKeystroke;
	    /**
	     * Create a normalized keystroke for a `'keydown'` event.
	     *
	     * @param event - The event object for a `'keydown'` event.
	     *
	     * @param layout - The keyboard layout for looking up the primary key.
	     *
	     * @returns A normalized keystroke, or an empty string if the event
	     *   does not represent a valid keystroke for the given layout.
	     */
	    function keystrokeForKeydownEvent(event, layout) {
	        var key = layout.keyForKeydownEvent(event);
	        if (!key) {
	            return '';
	        }
	        var mods = '';
	        if (event.ctrlKey) {
	            mods += 'Ctrl ';
	        }
	        if (event.altKey) {
	            mods += 'Alt ';
	        }
	        if (event.shiftKey) {
	            mods += 'Shift ';
	        }
	        if (event.metaKey && platform_1.IS_MAC) {
	            mods += 'Cmd ';
	        }
	        return mods + key;
	    }
	    Keymap.keystrokeForKeydownEvent = keystrokeForKeydownEvent;
	})(Keymap = exports.Keymap || (exports.Keymap = {}));
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Create a binding object from binding options.
	     */
	    function createBinding(options) {
	        return new KeyBinding(options);
	    }
	    Private.createBinding = createBinding;
	    /**
	     * Find the bindings which match a key sequence.
	     *
	     * This returns a match result which contains the best exact matching
	     * binding, and a flag which indicates if there are partial matches.
	     */
	    function match(bindings, keys, event) {
	        // Whether a partial match has been found.
	        var partial = false;
	        // The current best exact match.
	        var exact = null;
	        // The match distance for the exact match.
	        var distance = Infinity;
	        // The specificity for the exact match.
	        var specificity = 0;
	        // Iterate over the bindings and search for the best match.
	        for (var i = 0, n = bindings.length; i < n; ++i) {
	            // Lookup the current binding.
	            var binding = bindings.at(i);
	            // Check whether the key binding sequence is a match.
	            var sqm = matchSequence(binding.keys, keys);
	            // If there is no match, the binding is ignored.
	            if (sqm === 0 /* None */) {
	                continue;
	            }
	            // If it is a partial match and no other partial match has been
	            // found, ensure the selector matches and set the partial flag.
	            if (sqm === 2 /* Partial */) {
	                if (!partial && targetDistance(binding.selector, event) !== -1) {
	                    partial = true;
	                }
	                continue;
	            }
	            // Ignore the match if the selector doesn't match, or if the
	            // matched node is farther away than the current best match.
	            var td = targetDistance(binding.selector, event);
	            if (td === -1 || td > distance) {
	                continue;
	            }
	            // Get the specificity for the selector.
	            var sp = selector_1.calculateSpecificity(binding.selector);
	            // Update the best match if this match is stronger.
	            if (exact === null || td < distance || sp >= specificity) {
	                exact = binding;
	                distance = td;
	                specificity = sp;
	            }
	        }
	        // Return the match result.
	        return { exact: exact, partial: partial };
	    }
	    Private.match = match;
	    /**
	     * Replay a keyboard event.
	     *
	     * This synthetically dispatches a clone of the keyboard event.
	     */
	    function replayEvent(event) {
	        event.target.dispatchEvent(cloneKeyboardEvent(event));
	    }
	    Private.replayEvent = replayEvent;
	    /**
	     * A concrete implementation of `Keymap.IBinding`.
	     */
	    var KeyBinding = (function () {
	        /**
	         * Construct a new binding.
	         */
	        function KeyBinding(options) {
	            this._keys = normalizeKeys(options);
	            this._selector = normalizeSelector(options);
	            this._command = options.command;
	            this._args = options.args || null;
	        }
	        Object.defineProperty(KeyBinding.prototype, "keys", {
	            /**
	             * The key sequence for the key binding.
	             */
	            get: function () {
	                return this._keys;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(KeyBinding.prototype, "selector", {
	            /**
	             * The CSS selector for the key binding.
	             */
	            get: function () {
	                return this._selector;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(KeyBinding.prototype, "command", {
	            /**
	             * The command to execute when the key binding is matched.
	             */
	            get: function () {
	                return this._command;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(KeyBinding.prototype, "args", {
	            /**
	             * The arguments for the command.
	             */
	            get: function () {
	                return this._args;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        return KeyBinding;
	    }());
	    /**
	     * Get the platform-specific normalized keys for an options object.
	     *
	     * The normalized keys are frozen to prevent further modification.
	     */
	    function normalizeKeys(options) {
	        var keys;
	        if (platform_1.IS_WIN) {
	            keys = options.winKeys || options.keys;
	        }
	        else if (platform_1.IS_MAC) {
	            keys = options.macKeys || options.keys;
	        }
	        else {
	            keys = options.linuxKeys || options.keys;
	        }
	        return Object.freeze(keys.map(Keymap.normalizeKeystroke));
	    }
	    /**
	     * Normalize the selector for an options object.
	     *
	     * This returns the validated first clause of the selector.
	     */
	    function normalizeSelector(options) {
	        return selector_1.validateSelector(options.selector.split(',', 1)[0]);
	    }
	    ;
	    /**
	     * Test whether a binding sequence matches a key sequence.
	     *
	     * Returns a `SequenceMatch` value indicating the type of match.
	     */
	    function matchSequence(bindKeys, userKeys) {
	        if (bindKeys.length < userKeys.length) {
	            return 0 /* None */;
	        }
	        for (var i = 0, n = userKeys.length; i < n; ++i) {
	            if (bindKeys[i] !== userKeys[i]) {
	                return 0 /* None */;
	            }
	        }
	        if (bindKeys.length > userKeys.length) {
	            return 2 /* Partial */;
	        }
	        return 1 /* Exact */;
	    }
	    /**
	     * Find the distance from the target node to the first matching node.
	     *
	     * This traverses the event path from `target` to `currentTarget` and
	     * computes the distance from `target` to the first node which matches
	     * the CSS selector. If no match is found, `-1` is returned.
	     */
	    function targetDistance(selector, event) {
	        var distance = 0;
	        var target = event.target;
	        var current = event.currentTarget;
	        for (; target !== null; target = target.parentElement, ++distance) {
	            if (selector_1.matchesSelector(target, selector)) {
	                return distance;
	            }
	            if (target === current) {
	                return -1;
	            }
	        }
	        return -1;
	    }
	    /**
	     * Clone a keyboard event.
	     */
	    function cloneKeyboardEvent(event) {
	        // A custom event is required because Chrome nulls out the
	        // `keyCode` field in user-generated `KeyboardEvent` types.
	        var clone = document.createEvent('Event');
	        var bubbles = event.bubbles || true;
	        var cancelable = event.cancelable || true;
	        clone.initEvent(event.type || 'keydown', bubbles, cancelable);
	        clone.key = event.key || '';
	        clone.keyCode = event.keyCode || 0;
	        clone.which = event.keyCode || 0;
	        clone.ctrlKey = event.ctrlKey || false;
	        clone.altKey = event.altKey || false;
	        clone.shiftKey = event.shiftKey || false;
	        clone.metaKey = event.metaKey || false;
	        clone.view = event.view || window;
	        return clone;
	    }
	})(Private || (Private = {}));


/***/ },
/* 10 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * Test whether a JSON value is a primitive.
	 *
	 * @param value - The JSON value of interest.
	 *
	 * @returns `true` if the value is a primitive or `null`,
	 *   `false` otherwise.
	 */
	function isPrimitive(value) {
	    return (value === null ||
	        typeof value === 'boolean' ||
	        typeof value === 'number' ||
	        typeof value === 'string');
	}
	exports.isPrimitive = isPrimitive;
	/**
	 * Test whether a JSON value is an array.
	 *
	 * @param value - The JSON value of interest.
	 *
	 * @returns `true` if the value is a an array, `false` otherwise.
	 */
	function isArray(value) {
	    return Array.isArray(value);
	}
	exports.isArray = isArray;
	/**
	 * Test whether a JSON value is an object.
	 *
	 * @param value - The JSON value of interest.
	 *
	 * @returns `true` if the value is a an object, `false` otherwise.
	 */
	function isObject(value) {
	    return !isPrimitive(value) && !isArray(value);
	}
	exports.isObject = isObject;
	/**
	 * Compare two JSON values for deep equality.
	 *
	 * @param first - The first JSON value of interest.
	 *
	 * @param second - The second JSON value of interest.
	 *
	 * @returns `true` if the values are equivalent, `false` otherwise.
	 */
	function deepEqual(first, second) {
	    // Check referential and primitive equality first.
	    if (first === second) {
	        return true;
	    }
	    // If one is a primitive, the `===` check ruled out the other.
	    if (isPrimitive(first) || isPrimitive(second)) {
	        return false;
	    }
	    // Bail if either is `undefined`.
	    if (!first || !second) {
	        return false;
	    }
	    // Test whether they are arrays.
	    var a1 = isArray(first);
	    var a2 = isArray(second);
	    // Bail if the types are different.
	    if (a1 !== a2) {
	        return false;
	    }
	    // If they are both arrays, compare them.
	    if (a1 && a2) {
	        return Private.arrayEqual(first, second);
	    }
	    // At this point, they must both be objects.
	    return Private.objectEqual(first, second);
	}
	exports.deepEqual = deepEqual;
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Compare two JSON arrays for deep equality.
	     */
	    function arrayEqual(first, second) {
	        // Test the arrays for equal length.
	        if (first.length !== second.length) {
	            return false;
	        }
	        // Compare the values for equality.
	        for (var i = 0, n = first.length; i < n; ++i) {
	            if (!deepEqual(first[i], second[i])) {
	                return false;
	            }
	        }
	        // At this point, the arrays are equal.
	        return true;
	    }
	    Private.arrayEqual = arrayEqual;
	    /**
	     * Compare two JSON objects for deep equality.
	     */
	    function objectEqual(first, second) {
	        // Get the keys for each object.
	        var k1 = Object.keys(first);
	        var k2 = Object.keys(second);
	        // Test the keys for equal length.
	        if (k1.length !== k2.length) {
	            return false;
	        }
	        // Sort the keys for equivalent order.
	        k1.sort();
	        k2.sort();
	        // Compare the keys for equality.
	        for (var i = 0, n = k1.length; i < n; ++i) {
	            if (k1[i] !== k2[i]) {
	                return false;
	            }
	        }
	        // Compare the values for equality.
	        for (var i = 0, n = k1.length; i < n; ++i) {
	            if (!deepEqual(first[k1[i]], second[k1[i]])) {
	                return false;
	            }
	        }
	        // At this point, the objects are equal.
	        return true;
	    }
	    Private.objectEqual = objectEqual;
	})(Private || (Private = {}));


/***/ },
/* 11 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var iteration_1 = __webpack_require__(5);
	var sequence_1 = __webpack_require__(12);
	/**
	 * Find the first value in an iterable which matches a predicate.
	 *
	 * @param object - The iterable or array-like object to search.
	 *
	 * @param fn - The predicate function to apply to the values.
	 *
	 * @returns The first matching value, or `undefined` if no matching
	 *   value is found.
	 *
	 * #### Complexity
	 * Linear.
	 *
	 * #### Example
	 * ```typescript
	 * import { find } from 'phosphor/lib/algorithm/searching';
	 *
	 * interface IAnimal { species: string, name: string };
	 *
	 * function isCat(value: IAnimal): boolean {
	 *   return value.species === 'cat';
	 * }
	 *
	 * let data: IAnimal[] = [
	 *   { species: 'dog', name: 'spot' },
	 *   { species: 'cat', name: 'fluffy' },
	 *   { species: 'alligator', name: 'pocho' },
	 * ];
	 *
	 * find(data, isCat).name;  // 'fluffy'
	 * ```
	 */
	function find(object, fn) {
	    var value;
	    var it = iteration_1.iter(object);
	    while ((value = it.next()) !== void 0) {
	        if (fn(value)) {
	            return value;
	        }
	    }
	    return void 0;
	}
	exports.find = find;
	/**
	 * Find the minimum value in an iterable.
	 *
	 * @param object - The iterable or array-like object to search.
	 *
	 * @param fn - The 3-way comparison function to apply to the values.
	 *   It should return `< 0` if the first value is less than the second.
	 *   `0` if the values are equivalent, or `> 0` if the first value is
	 *   greater than the second.
	 *
	 * @returns The minimum value in the iterable. If multiple values are
	 *   equivalent to the minimum, the left-most value is returned. If
	 *   the iterable is empty, this returns `undefined`.
	 *
	 * #### Complexity
	 * Linear.
	 *
	 * #### Example
	 * ```typescript
	 * import { min } from 'phosphor/lib/algorithm/searching';
	 *
	 * function numberCmp(a: number, b: number): number {
	 *   return a - b;
	 * }
	 *
	 * min([7, 4, 0, 3, 9, 4], numberCmp);  // 0
	 * ```
	 */
	function min(object, fn) {
	    var it = iteration_1.iter(object);
	    var result = it.next();
	    if (result === void 0) {
	        return void 0;
	    }
	    var value;
	    while ((value = it.next()) !== void 0) {
	        if (fn(value, result) < 0) {
	            result = value;
	        }
	    }
	    return result;
	}
	exports.min = min;
	/**
	 * Find the maximum value in an iterable.
	 *
	 * @param object - The iterable or array-like object to search.
	 *
	 * @param fn - The 3-way comparison function to apply to the values.
	 *   It should return `< 0` if the first value is less than the second.
	 *   `0` if the values are equivalent, or `> 0` if the first value is
	 *   greater than the second.
	 *
	 * @returns The maximum value in the iterable. If multiple values are
	 *   equivalent to the maximum, the left-most value is returned. If
	 *   the iterable is empty, this returns `undefined`.
	 *
	 * #### Complexity
	 * Linear.
	 *
	 * #### Example
	 * ```typescript
	 * import { max } from 'phosphor/lib/algorithm/searching';
	 *
	 * function numberCmp(a: number, b: number): number {
	 *   return a - b;
	 * }
	 *
	 * max([7, 4, 0, 3, 9, 4], numberCmp);  // 9
	 * ```
	 */
	function max(object, fn) {
	    var it = iteration_1.iter(object);
	    var result = it.next();
	    if (result === void 0) {
	        return void 0;
	    }
	    var value;
	    while ((value = it.next()) !== void 0) {
	        if (fn(value, result) > 0) {
	            result = value;
	        }
	    }
	    return result;
	}
	exports.max = max;
	/**
	 * Find the index of the first occurrence of a value in a sequence.
	 *
	 * @param object - The sequence or array-like object to search.
	 *
	 * @param value - The value to locate in the sequence. Values are
	 *   compared using strict `===` equality.
	 *
	 * @param fromIndex - The starting index of the search. The default
	 *   value is `0`.
	 *
	 * @returns The index of the first occurrence of the value, or `-1`
	 *   if the value is not found.
	 *
	 * #### Complexity
	 * Linear.
	 *
	 * #### Undefined Behavior
	 * A `fromIndex` which is non-integral or `< 0`.
	 *
	 * #### Example
	 * ```typescript
	 * import { indexOf } from 'phosphor/lib/algorithm/searching';
	 *
	 * let data = ['one', 'two', 'three', 'four', 'one'];
	 * indexOf(data, 'red');     // -1
	 * indexOf(data, 'one');     // 0
	 * indexOf(data, 'one', 1);  // 4
	 * indexOf(data, 'two', 2);  // -1
	 * ```
	 */
	function indexOf(object, value, fromIndex) {
	    var length = object.length;
	    if (length === 0) {
	        return -1;
	    }
	    var start;
	    if (fromIndex === void 0) {
	        start = 0;
	    }
	    else {
	        start = fromIndex;
	    }
	    var seq = sequence_1.asSequence(object);
	    for (var i = start; i < length; ++i) {
	        if (seq.at(i) === value) {
	            return i;
	        }
	    }
	    return -1;
	}
	exports.indexOf = indexOf;
	/**
	 * Find the index of the last occurrence of a value in a sequence.
	 *
	 * @param object - The sequence or array-like object to search.
	 *
	 * @param value - The value to locate in the sequence. Values are
	 *   compared using strict `===` equality.
	 *
	 * @param fromIndex - The starting index of the search. The default
	 *   value is `length - 1`.
	 *
	 * @returns The index of the last occurrence of the value, or `-1`
	 *   if the value is not found.
	 *
	 * #### Complexity
	 * Linear.
	 *
	 * #### Undefined Behavior
	 * A `fromIndex` which is non-integral or `>= length`.
	 *
	 * #### Example
	 * ```typescript
	 * import { lastIndexOf } from 'phosphor/lib/algorithm/searching';
	 *
	 * let data = ['one', 'two', 'three', 'four', 'one'];
	 * lastIndexOf(data, 'red');     // -1
	 * lastIndexOf(data, 'one');     // 4
	 * lastIndexOf(data, 'one', 1);  // 0
	 * lastIndexOf(data, 'two', 2);  // 1
	 * ```
	 */
	function lastIndexOf(object, value, fromIndex) {
	    var length = object.length;
	    if (length === 0) {
	        return -1;
	    }
	    var start;
	    if (fromIndex === void 0) {
	        start = length - 1;
	    }
	    else {
	        start = fromIndex;
	    }
	    var seq = sequence_1.asSequence(object);
	    for (var i = start; i >= 0; --i) {
	        if (seq.at(i) === value) {
	            return i;
	        }
	    }
	    return -1;
	}
	exports.lastIndexOf = lastIndexOf;
	/**
	 * Find the index of the first value which matches a predicate.
	 *
	 * @param object - The sequence or array-like object to search.
	 *
	 * @param fn - The predicate function to apply to the values.
	 *
	 * @param fromIndex - The starting index of the search. The default
	 *   value is `0`.
	 *
	 * @returns The index of the first matching value, or `-1` if no
	 *   matching value is found.
	 *
	 * #### Complexity
	 * Linear.
	 *
	 * #### Undefined Behavior
	 * A `fromIndex` which is non-integral or `< 0`.
	 *
	 * Modifying the length of the sequence while searching.
	 *
	 * #### Example
	 * ```typescript
	 * import { findIndex } from 'phosphor/lib/algorithm/searching';
	 *
	 * function isEven(value: number): boolean {
	 *   return value % 2 === 0;
	 * }
	 *
	 * let data = [1, 2, 3, 4, 3, 2, 1];
	 * findIndex(data, isEven);     // 1
	 * findIndex(data, isEven, 4);  // 5
	 * findIndex(data, isEven, 6);  // -1
	 * ```
	 */
	function findIndex(object, fn, fromIndex) {
	    var length = object.length;
	    if (length === 0) {
	        return -1;
	    }
	    var start;
	    if (fromIndex === void 0) {
	        start = 0;
	    }
	    else {
	        start = fromIndex;
	    }
	    var seq = sequence_1.asSequence(object);
	    for (var i = start; i < length; ++i) {
	        if (fn(seq.at(i), i)) {
	            return i;
	        }
	    }
	    return -1;
	}
	exports.findIndex = findIndex;
	/**
	 * Find the index of the last value which matches a predicate.
	 *
	 * @param object - The sequence or array-like object to search.
	 *
	 * @param fn - The predicate function to apply to the values.
	 *
	 * @param fromIndex - The starting index of the search. The default
	 *   value is `length - 1`.
	 *
	 * @returns The index of the last matching value, or `-1` if no
	 *   matching value is found.
	 *
	 * #### Complexity
	 * Linear.
	 *
	 * #### Undefined Behavior
	 * A `fromIndex` which is non-integral or `>= length`.
	 *
	 * Modifying the length of the sequence while searching.
	 *
	 * #### Example
	 * ```typescript
	 * import { findLastIndex } from 'phosphor/lib/algorithm/searching';
	 *
	 * function isEven(value: number): boolean {
	 *   return value % 2 === 0;
	 * }
	 *
	 * let data = [1, 2, 3, 4, 3, 2, 1];
	 * findLastIndex(data, isEven);     // 5
	 * findLastIndex(data, isEven, 4);  // 3
	 * findLastIndex(data, isEven, 0);  // -1
	 * ```
	 */
	function findLastIndex(object, fn, fromIndex) {
	    var length = object.length;
	    if (length === 0) {
	        return -1;
	    }
	    var start;
	    if (fromIndex === void 0) {
	        start = length - 1;
	    }
	    else {
	        start = fromIndex;
	    }
	    var seq = sequence_1.asSequence(object);
	    for (var i = start; i >= 0; --i) {
	        if (fn(seq.at(i), i)) {
	            return i;
	        }
	    }
	    return -1;
	}
	exports.findLastIndex = findLastIndex;
	/**
	 * Find the index of the first element which compares `>=` to a value.
	 *
	 * @param sequence - The sequence or array-like object to search.
	 *   It must be sorted in ascending order.
	 *
	 * @param value - The value to locate in the sequence.
	 *
	 * @param fn - The 3-way comparison function to apply to the values.
	 *   It should return `< 0` if an element is less than a value, `0` if
	 *   an element is equal to a value, or `> 0` if an element is greater
	 *   than a value.
	 *
	 * @returns The index of the first element which compares `>=` to the
	 *   value, or `length` if there is no such element.
	 *
	 * #### Complexity
	 * Logarithmic.
	 *
	 * #### Undefined Behavior
	 * A sequence which is not sorted in ascending order.
	 *
	 * Modifying the length of the sequence while searching.
	 *
	 * #### Example
	 * ```typescript
	 * import { lowerBound } from 'phosphor/lib/algorithm/searching';
	 *
	 * function numberCmp(a: number, b: number): number {
	 *   return a - b;
	 * }
	 *
	 * let data = [0, 3, 4, 7, 7, 9];
	 * lowerBound(data, 0, numberCmp);   // 0
	 * lowerBound(data, 6, numberCmp);   // 3
	 * lowerBound(data, 7, numberCmp);   // 3
	 * lowerBound(data, -1, numberCmp);  // 0
	 * lowerBound(data, 10, numberCmp);  // 6
	 * ```
	 */
	function lowerBound(object, value, fn) {
	    var n = object.length;
	    if (n === 0) {
	        return 0;
	    }
	    var begin = 0;
	    var half;
	    var middle;
	    var seq = sequence_1.asSequence(object);
	    while (n > 0) {
	        half = n / 2 | 0;
	        middle = begin + half;
	        if (fn(seq.at(middle), value) < 0) {
	            begin = middle + 1;
	            n -= half + 1;
	        }
	        else {
	            n = half;
	        }
	    }
	    return begin;
	}
	exports.lowerBound = lowerBound;
	/**
	 * Find the index of the first element which compares `>` than a value.
	 *
	 * @param sequence - The sequence or array-like object to search.
	 *   It must be sorted in ascending order.
	 *
	 * @param value - The value to locate in the sequence.
	 *
	 * @param fn - The 3-way comparison function to apply to the values.
	 *   It should return `< 0` if an element is less than a value, `0` if
	 *   an element is equal to a value, or `> 0` if an element is greater
	 *   than a value.
	 *
	 * @returns The index of the first element which compares `>` than the
	 *   value, or `length` if there is no such element.
	 *
	 * #### Complexity
	 * Logarithmic.
	 *
	 * #### Undefined Behavior
	 * A sequence which is not sorted in ascending order.
	 *
	 * Modifying the length of the sequence while searching.
	 *
	 * #### Example
	 * ```typescript
	 * import { upperBound } from 'phosphor/lib/algorithm/searching';
	 *
	 * function numberCmp(a: number, b: number): number {
	 *   return a - b;
	 * }
	 *
	 * let data = [0, 3, 4, 7, 7, 9];
	 * upperBound(data, 0, numberCmp);   // 1
	 * upperBound(data, 6, numberCmp);   // 3
	 * upperBound(data, 7, numberCmp);   // 5
	 * upperBound(data, -1, numberCmp);  // 0
	 * upperBound(data, 10, numberCmp);  // 6
	 * ```
	 */
	function upperBound(object, value, fn) {
	    var n = object.length;
	    if (n === 0) {
	        return 0;
	    }
	    var begin = 0;
	    var half;
	    var middle;
	    var seq = sequence_1.asSequence(object);
	    while (n > 0) {
	        half = n / 2 | 0;
	        middle = begin + half;
	        if (fn(seq.at(middle), value) > 0) {
	            n = half;
	        }
	        else {
	            begin = middle + 1;
	            n -= half + 1;
	        }
	    }
	    return begin;
	}
	exports.upperBound = upperBound;
	/**
	 * A namespace which holds string searching functionality.
	 */
	var StringSearch;
	(function (StringSearch) {
	    /**
	     * Compute the sum-of-squares match for the given search text.
	     *
	     * @param sourceText - The text which should be searched.
	     *
	     * @param queryText - The query text to locate in the source text.
	     *
	     * @returns The match result object, or `null` if there is no match.
	     *
	     * #### Complexity
	     * Linear on `sourceText`.
	     *
	     * #### Notes
	     * This scoring algorithm uses a sum-of-squares approach to determine
	     * the score. In order for there to be a match, all of the characters
	     * in `queryText` **must** appear in `sourceText` in order. The index
	     * of each matching character is squared and added to the score. This
	     * means that early and consecutive character matches are preferred.
	     *
	     * The character match is performed with strict equality. It is case
	     * sensitive and does not ignore whitespace. If those behaviors are
	     * required, the text should be transformed before scoring.
	     */
	    function sumOfSquares(sourceText, queryText) {
	        var score = 0;
	        var indices = new Array(queryText.length);
	        for (var i = 0, j = 0, n = queryText.length; i < n; ++i, ++j) {
	            j = sourceText.indexOf(queryText[i], j);
	            if (j === -1) {
	                return null;
	            }
	            indices[i] = j;
	            score += j * j;
	        }
	        return { score: score, indices: indices };
	    }
	    StringSearch.sumOfSquares = sumOfSquares;
	    /**
	     * Highlight the matched characters of a source string.
	     *
	     * @param source - The text which should be highlighted.
	     *
	     * @param indices - The indices of the matched characters. They must
	     *   appear in increasing order and must be in bounds of the source.
	     *
	     * @returns A string with interpolated `<mark>` tags.
	     */
	    function highlight(sourceText, indices) {
	        var k = 0;
	        var last = 0;
	        var result = '';
	        var n = indices.length;
	        while (k < n) {
	            var i = indices[k];
	            var j = indices[k];
	            while (++k < n && indices[k] === j + 1) {
	                j++;
	            }
	            var head = sourceText.slice(last, i);
	            var chunk = sourceText.slice(i, j + 1);
	            result += head + "<mark>" + chunk + "</mark>";
	            last = j + 1;
	        }
	        return result + sourceText.slice(last);
	    }
	    StringSearch.highlight = highlight;
	})(StringSearch = exports.StringSearch || (exports.StringSearch = {}));


/***/ },
/* 12 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var iteration_1 = __webpack_require__(5);
	/**
	 * Cast a sequence or array-like object to a sequence.
	 *
	 * @param object - The sequence or array-like object of interest.
	 *
	 * @returns A sequence for the given object.
	 *
	 * #### Notes
	 * This function allows sequence algorithms to operate on user-defined
	 * sequence types and builtin array-like objects in a uniform fashion.
	 */
	function asSequence(object) {
	    var seq;
	    if (typeof object.at === 'function') {
	        seq = object;
	    }
	    else {
	        seq = new ArraySequence(object);
	    }
	    return seq;
	}
	exports.asSequence = asSequence;
	/**
	 * Cast a mutable sequence or array-like object to a mutable sequence.
	 *
	 * @param object - The sequence or array-like object of interest.
	 *
	 * @returns A mutable sequence for the given object.
	 *
	 * #### Notes
	 * This function allows sequence algorithms to operate on user-defined
	 * sequence types and builtin array-like objects in a uniform fashion.
	 */
	function asMutableSequence(object) {
	    var seq;
	    if (typeof object.set === 'function') {
	        seq = object;
	    }
	    else {
	        seq = new MutableArraySequence(object);
	    }
	    return seq;
	}
	exports.asMutableSequence = asMutableSequence;
	/**
	 * A sequence for an array-like object.
	 *
	 * #### Notes
	 * This sequence can be used for any builtin JS array-like object.
	 */
	var ArraySequence = (function () {
	    /**
	     * Construct a new array sequence.
	     *
	     * @param source - The array-like object of interest.
	     */
	    function ArraySequence(source) {
	        this._source = source;
	    }
	    Object.defineProperty(ArraySequence.prototype, "length", {
	        /**
	         * The length of the sequence.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._source.length;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Create an iterator over the object's values.
	     *
	     * @returns A new iterator which traverses the object's values.
	     */
	    ArraySequence.prototype.iter = function () {
	        return new iteration_1.ArrayIterator(this._source, 0);
	    };
	    /**
	     * Get the value at the specified index.
	     *
	     * @param index - The positive integer index of interest.
	     *
	     * @returns The value at the specified index.
	     *
	     * #### Undefined Behavior
	     * An `index` which is non-integral or out of range.
	     */
	    ArraySequence.prototype.at = function (index) {
	        return this._source[index];
	    };
	    return ArraySequence;
	}());
	exports.ArraySequence = ArraySequence;
	/**
	 * A sequence for a mutable array-like object.
	 *
	 * #### Notes
	 * This sequence can be used for any builtin JS array-like object.
	 */
	var MutableArraySequence = (function (_super) {
	    __extends(MutableArraySequence, _super);
	    function MutableArraySequence() {
	        _super.apply(this, arguments);
	    }
	    /**
	     * Set the value at the specified index.
	     *
	     * @param index - The positive integer index of interest.
	     *
	     * @param value - The value to set at the specified index.
	     *
	     * #### Undefined Behavior
	     * An `index` which is non-integral or out of range.
	     */
	    MutableArraySequence.prototype.set = function (index, value) {
	        this._source[index] = value;
	    };
	    return MutableArraySequence;
	}(ArraySequence));
	exports.MutableArraySequence = MutableArraySequence;


/***/ },
/* 13 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var iteration_1 = __webpack_require__(5);
	/**
	 * A generic vector data structure.
	 */
	var Vector = (function () {
	    /**
	     * Construct a new vector.
	     *
	     * @param values - The initial values for the vector.
	     */
	    function Vector(values) {
	        var _this = this;
	        this._array = [];
	        if (values)
	            iteration_1.each(values, function (value) { _this.pushBack(value); });
	    }
	    Object.defineProperty(Vector.prototype, "isEmpty", {
	        /**
	         * Test whether the vector is empty.
	         *
	         * @returns `true` if the vector is empty, `false` otherwise.
	         *
	         * #### Notes
	         * This is a read-only property.
	         *
	         * #### Complexity
	         * Constant.
	         *
	         * #### Iterator Validity
	         * No changes.
	         */
	        get: function () {
	            return this._array.length === 0;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Vector.prototype, "length", {
	        /**
	         * Get the length of the vector.
	         *
	         * @return The number of values in the vector.
	         *
	         * #### Notes
	         * This is a read-only property.
	         *
	         * #### Complexity
	         * Constant.
	         *
	         * #### Iterator Validity
	         * No changes.
	         */
	        get: function () {
	            return this._array.length;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Vector.prototype, "front", {
	        /**
	         * Get the value at the front of the vector.
	         *
	         * @returns The value at the front of the vector, or `undefined` if
	         *   the vector is empty.
	         *
	         * #### Notes
	         * This is a read-only property.
	         *
	         * #### Complexity
	         * Constant.
	         *
	         * #### Iterator Validity
	         * No changes.
	         */
	        get: function () {
	            return this._array[0];
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Vector.prototype, "back", {
	        /**
	         * Get the value at the back of the vector.
	         *
	         * @returns The value at the back of the vector, or `undefined` if
	         *   the vector is empty.
	         *
	         * #### Notes
	         * This is a read-only property.
	         *
	         * #### Complexity
	         * Constant.
	         *
	         * #### Iterator Validity
	         * No changes.
	         */
	        get: function () {
	            return this._array[this._array.length - 1];
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Create an iterator over the values in the vector.
	     *
	     * @returns A new iterator starting at the front of the vector.
	     *
	     * #### Complexity
	     * Constant.
	     *
	     * #### Iterator Validity
	     * No changes.
	     */
	    Vector.prototype.iter = function () {
	        return new iteration_1.ArrayIterator(this._array, 0);
	    };
	    /**
	     * Get the value at the specified index.
	     *
	     * @param index - The positive integer index of interest.
	     *
	     * @returns The value at the specified index.
	     *
	     * #### Complexity
	     * Constant.
	     *
	     * #### Iterator Validity
	     * No changes.
	     *
	     * #### Undefined Behavior
	     * An `index` which is non-integral or out of range.
	     */
	    Vector.prototype.at = function (index) {
	        return this._array[index];
	    };
	    /**
	     * Set the value at the specified index.
	     *
	     * @param index - The positive integer index of interest.
	     *
	     * @param value - The value to set at the specified index.
	     *
	     * #### Complexity
	     * Constant.
	     *
	     * #### Iterator Validity
	     * No changes.
	     *
	     * #### Undefined Behavior
	     * An `index` which is non-integral or out of range.
	     */
	    Vector.prototype.set = function (index, value) {
	        this._array[index] = value;
	    };
	    /**
	     * Add a value to the back of the vector.
	     *
	     * @param value - The value to add to the back of the vector.
	     *
	     * @returns The new length of the vector.
	     *
	     * #### Complexity
	     * Constant.
	     *
	     * #### Iterator Validity
	     * No changes.
	     */
	    Vector.prototype.pushBack = function (value) {
	        return this._array.push(value);
	    };
	    /**
	     * Remove and return the value at the back of the vector.
	     *
	     * @returns The value at the back of the vector, or `undefined` if
	     *   the vector is empty.
	     *
	     * #### Complexity
	     * Constant.
	     *
	     * #### Iterator Validity
	     * Iterators pointing at the removed value are invalidated.
	     */
	    Vector.prototype.popBack = function () {
	        return this._array.pop();
	    };
	    /**
	     * Insert a value into the vector at a specific index.
	     *
	     * @param index - The index at which to insert the value.
	     *
	     * @param value - The value to set at the specified index.
	     *
	     * @returns The new length of the vector.
	     *
	     * #### Complexity
	     * Linear.
	     *
	     * #### Iterator Validity
	     * No changes.
	     *
	     * #### Notes
	     * The `index` will be clamped to the bounds of the vector.
	     *
	     * #### Undefined Behavior
	     * An `index` which is non-integral.
	     */
	    Vector.prototype.insert = function (index, value) {
	        var array = this._array;
	        var n = array.length;
	        index = Math.max(0, Math.min(index, n));
	        for (var i = n; i > index; --i) {
	            array[i] = array[i - 1];
	        }
	        array[index] = value;
	        return n + 1;
	    };
	    /**
	     * Remove the first occurrence of a value from the vector.
	     *
	     * @param value - The value of interest.
	     *
	     * @returns The index of the removed value, or `-1` if the value
	     *   is not contained in the vector.
	     *
	     * #### Complexity
	     * Linear.
	     *
	     * #### Iterator Validity
	     * Iterators pointing at the removed value and beyond are invalidated.
	     *
	     * #### Notes
	     * Comparison is performed using strict `===` equality.
	     */
	    Vector.prototype.remove = function (value) {
	        var index = this._array.indexOf(value);
	        if (index !== -1)
	            this.removeAt(index);
	        return index;
	    };
	    /**
	     * Remove and return the value at a specific index.
	     *
	     * @param index - The index of the value of interest.
	     *
	     * @returns The value at the specified index, or `undefined` if the
	     *   index is out of range.
	     *
	     * #### Complexity
	     * Constant.
	     *
	     * #### Iterator Validity
	     * Iterators pointing at the removed value and beyond are invalidated.
	     *
	     * #### Undefined Behavior
	     * An `index` which is non-integral.
	     */
	    Vector.prototype.removeAt = function (index) {
	        var array = this._array;
	        var n = array.length;
	        if (index < 0 || index >= n) {
	            return void 0;
	        }
	        var value = array[index];
	        for (var i = index + 1; i < n; ++i) {
	            array[i - 1] = array[i];
	        }
	        array.length = n - 1;
	        return value;
	    };
	    /**
	     * Remove all values from the vector.
	     *
	     * #### Complexity
	     * Linear.
	     *
	     * #### Iterator Validity
	     * All current iterators are invalidated.
	     */
	    Vector.prototype.clear = function () {
	        this._array.length = 0;
	    };
	    /**
	     * Swap the contents of the vector with the contents of another.
	     *
	     * @param other - The other vector holding the contents to swap.
	     *
	     * #### Complexity
	     * Constant.
	     *
	     * #### Iterator Validity
	     * All current iterators remain valid, but will now point to the
	     * contents of the other vector involved in the swap.
	     */
	    Vector.prototype.swap = function (other) {
	        var array = other._array;
	        other._array = this._array;
	        this._array = array;
	    };
	    return Vector;
	}());
	exports.Vector = Vector;


/***/ },
/* 14 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * A boolean indicating whether the platform is Mac.
	 */
	exports.IS_MAC = !!navigator.platform.match(/Mac/i);
	/**
	 * A boolean indicating whether the platform is Windows.
	 */
	exports.IS_WIN = !!navigator.platform.match(/Win/i);
	/**
	 * A flag indicating whether the browser is IE.
	 */
	exports.IS_IE = /Trident/.test(navigator.userAgent);


/***/ },
/* 15 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * Calculate the specificity of a single CSS selector.
	 *
	 * @param selector - The CSS selector of interest.
	 *
	 * @returns The specificity of the selector.
	 *
	 * #### Undefined Behavior
	 * The selector is invalid.
	 *
	 * #### Notes
	 * This is based on https://www.w3.org/TR/css3-selectors/#specificity
	 *
	 * A larger number represents a more specific selector.
	 *
	 * The smallest possible specificity is `0`.
	 *
	 * The result is represented as a hex number `0x<aa><bb><cc>` where
	 * each component is the count of the respective selector clause.
	 *
	 * If the selector contains commas, only the first clause is used.
	 *
	 * The computed result is cached, so subsequent calculations for the
	 * same selector are extremely fast.
	 */
	function calculateSpecificity(selector) {
	    var result = Private.specificityCache[selector];
	    if (result === void 0) {
	        result = Private.calculateSingle(selector);
	        Private.specificityCache[selector] = result;
	    }
	    return result;
	}
	exports.calculateSpecificity = calculateSpecificity;
	/**
	 * Test whether a selector is a valid CSS selector.
	 *
	 * @param selector - The CSS selector of interest.
	 *
	 * @returns `true` if the selector is valid, `false` otherwise.
	 *
	 * #### Notes
	 * The computed result is cached, so subsequent tests for the same
	 * selector are extremely fast.
	 */
	function isValidSelector(selector) {
	    var result = Private.validityCache[selector];
	    if (result === void 0) {
	        try {
	            Private.testElem.querySelector(selector);
	            result = true;
	        }
	        catch (err) {
	            result = false;
	        }
	        Private.validityCache[selector] = result;
	    }
	    return result;
	}
	exports.isValidSelector = isValidSelector;
	/**
	 * Validate a CSS selector.
	 *
	 * @param selector - The CSS selector of interest.
	 *
	 * @returns The provided selector.
	 *
	 * @throws An error if the selector is invalid.
	 */
	function validateSelector(selector) {
	    if (!isValidSelector(selector)) {
	        throw new Error("Invalid selector: " + selector);
	    }
	    return selector;
	}
	exports.validateSelector = validateSelector;
	/**
	 * Test whether an element matches a CSS selector.
	 *
	 * @param elem - The element of interest.
	 *
	 * @param selector - The valid CSS selector of interest.
	 *
	 * @returns `true` if the element is a match, `false` otherwise.
	 *
	 * #### Notes
	 * This function uses the builtin browser capabilities when possible,
	 * falling back onto a document query otherwise.
	 */
	function matchesSelector(elem, selector) {
	    return Private.protoMatchFunc.call(elem, selector);
	}
	exports.matchesSelector = matchesSelector;
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * A regex which matches an ID selector at string start.
	     */
	    var ID_RE = /^#[^\s\+>~#\.\[:]+/;
	    /**
	     * A regex which matches a class selector at string start.
	     */
	    var CLASS_RE = /^\.[^\s\+>~#\.\[:]+/;
	    /**
	     * A regex which matches an attribute selector at string start.
	     */
	    var ATTR_RE = /^\[[^\]]+\]/;
	    /**
	     * A regex which matches a type selector at string start.
	     */
	    var TYPE_RE = /^[^\s\+>~#\.\[:]+/;
	    /**
	     * A regex which matches a pseudo-element selector at string start.
	     */
	    var PSEUDO_ELEM_RE = /^(::[^\s\+>~#\.\[:]+|:first-line|:first-letter|:before|:after)/;
	    /**
	     * A regex which matches a pseudo-class selector at string start.
	     */
	    var PSEUDO_CLASS_RE = /^:[^\s\+>~#\.\[:]+/;
	    /**
	     * A regex which matches ignored characters at string start.
	     */
	    var IGNORE_RE = /^[\s\+>~\*]+/;
	    /**
	     * A regex which matches the negation pseudo-class globally.
	     */
	    var NEGATION_RE = /:not\(([^\)]+)\)/g;
	    /**
	     * A cached of computed selector specificity values.
	     */
	    Private.specificityCache = Object.create(null);
	    /**
	     * A cached of computed selector validity.
	     */
	    Private.validityCache = Object.create(null);
	    /**
	     * An empty element for testing selector validity.
	     */
	    Private.testElem = document.createElement('div');
	    /**
	     * A cross-browser CSS selector matching prototype function.
	     */
	    Private.protoMatchFunc = (function () {
	        var proto = Element.prototype;
	        return (proto.matches ||
	            proto.matchesSelector ||
	            proto.mozMatchesSelector ||
	            proto.msMatchesSelector ||
	            proto.oMatchesSelector ||
	            proto.webkitMatchesSelector ||
	            (function (selector) {
	                var elem = this;
	                var matches = elem.ownerDocument.querySelectorAll(selector);
	                return Array.prototype.indexOf.call(matches, elem) !== -1;
	            }));
	    })();
	    /**
	     * Calculate the specificity of a single selector.
	     *
	     * The behavior is undefined if the selector is invalid.
	     */
	    function calculateSingle(selector) {
	        // Ignore anything after the first comma.
	        selector = selector.split(',', 1)[0];
	        // Setup the aggregate counters.
	        var a = 0;
	        var b = 0;
	        var c = 0;
	        // Apply a regex to the front selector. If the match succeeds, that
	        // portion of the selector is removed. Returns a success/fail flag.
	        function match(re) {
	            var match = selector.match(re);
	            if (match === null) {
	                return false;
	            }
	            selector = selector.slice(match[0].length);
	            return true;
	        }
	        // Replace the negation pseudo-class (which is ignored),
	        // but keep its inner content (which is not ignored).
	        selector = selector.replace(NEGATION_RE, ' $1 ');
	        // Continue matching until the selector is consumed.
	        while (selector.length > 0) {
	            // Match an ID selector.
	            if (match(ID_RE)) {
	                a++;
	                continue;
	            }
	            // Match a class selector.
	            if (match(CLASS_RE)) {
	                b++;
	                continue;
	            }
	            // Match an attribute selector.
	            if (match(ATTR_RE)) {
	                b++;
	                continue;
	            }
	            // Match a pseudo-element selector. This is done before matching
	            // a pseudo-class since this regex overlaps with the class regex.
	            if (match(PSEUDO_ELEM_RE)) {
	                c++;
	                continue;
	            }
	            // Match a pseudo-class selector.
	            if (match(PSEUDO_CLASS_RE)) {
	                b++;
	                continue;
	            }
	            // Match a plain type selector.
	            if (match(TYPE_RE)) {
	                c++;
	                continue;
	            }
	            // Finally, match any ignored characters.
	            if (match(IGNORE_RE)) {
	                continue;
	            }
	            // At this point, the selector is assumed to be invalid.
	            return 0;
	        }
	        // Clamp each component to a reasonable base.
	        a = Math.min(a, 0xFF);
	        b = Math.min(b, 0xFF);
	        c = Math.min(c, 0xFF);
	        // Combine the components into a single result.
	        return (a << 16) | (b << 8) | c;
	    }
	    Private.calculateSingle = calculateSingle;
	})(Private || (Private = {}));


/***/ },
/* 16 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * A concrete implementation of [[IKeyboardLayout]] based on keycodes.
	 *
	 * The `.keyCode` property of a `'keydown'` event is a browser and OS
	 * specific representation of the physical key (not character) which
	 * was pressed on a keyboard. While not the most convenient API, it
	 * is currently the only one which works reliably on all browsers.
	 *
	 * This class accepts a user-defined mapping of keycode to key, which
	 * allows for reliable shortcuts tailored to the user's system.
	 */
	var KeycodeLayout = (function () {
	    /**
	     * Construct a new keycode layout.
	     *
	     * @param name - The human readable name for the layout.
	     *
	     * @param codes - A mapping of keycode to key value.
	     */
	    function KeycodeLayout(name, codes) {
	        this._name = name;
	        this._codes = codes;
	        this._keys = KeycodeLayout.extractKeys(codes);
	    }
	    Object.defineProperty(KeycodeLayout.prototype, "name", {
	        /**
	         * The human readable name of the layout.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._name;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Get an array of the key values supported by the layout.
	     *
	     * @returns A new array of the supported key values.
	     */
	    KeycodeLayout.prototype.keys = function () {
	        return Object.keys(this._keys);
	    };
	    /**
	     * Test whether the given key is a valid value for the layout.
	     *
	     * @param key - The user provided key to test for validity.
	     *
	     * @returns `true` if the key is valid, `false` otherwise.
	     */
	    KeycodeLayout.prototype.isValidKey = function (key) {
	        return key in this._keys;
	    };
	    /**
	     * Get the key for a `'keydown'` event.
	     *
	     * @param event - The event object for a `'keydown'` event.
	     *
	     * @returns The associated key value, or an empty string if
	     *   the event does not represent a valid primary key.
	     */
	    KeycodeLayout.prototype.keyForKeydownEvent = function (event) {
	        return this._codes[event.keyCode] || '';
	    };
	    return KeycodeLayout;
	}());
	exports.KeycodeLayout = KeycodeLayout;
	/**
	 * The namespace for the `KeycodeLayout` class statics.
	 */
	var KeycodeLayout;
	(function (KeycodeLayout) {
	    /**
	     * Extract the set of keys from a code map.
	     *
	     * @param code - The code map of interest.
	     *
	     * @returns A set of the keys in the code map.
	     */
	    function extractKeys(codes) {
	        var keys = Object.create(null);
	        for (var c in codes)
	            keys[codes[c]] = true;
	        return keys;
	    }
	    KeycodeLayout.extractKeys = extractKeys;
	})(KeycodeLayout = exports.KeycodeLayout || (exports.KeycodeLayout = {}));
	/**
	 * A keycode-based keyboard layout for US English keyboards.
	 *
	 * This layout is valid for the following OS/Browser combinations.
	 *
	 * - Windows
	 *   - Chrome
	 *   - Firefox
	 *   - IE
	 *
	 * - OSX
	 *   - Chrome
	 *   - Firefox
	 *   - Safari
	 *
	 * - Linux
	 *   - Chrome
	 *   - Firefox
	 *
	 * Other combinations may also work, but are untested.
	 */
	exports.EN_US = new KeycodeLayout('en-us', {
	    8: 'Backspace',
	    9: 'Tab',
	    13: 'Enter',
	    19: 'Pause',
	    27: 'Escape',
	    32: 'Space',
	    33: 'PageUp',
	    34: 'PageDown',
	    35: 'End',
	    36: 'Home',
	    37: 'ArrowLeft',
	    38: 'ArrowUp',
	    39: 'ArrowRight',
	    40: 'ArrowDown',
	    45: 'Insert',
	    46: 'Delete',
	    48: '0',
	    49: '1',
	    50: '2',
	    51: '3',
	    52: '4',
	    53: '5',
	    54: '6',
	    55: '7',
	    56: '8',
	    57: '9',
	    59: ';',
	    61: '=',
	    65: 'A',
	    66: 'B',
	    67: 'C',
	    68: 'D',
	    69: 'E',
	    70: 'F',
	    71: 'G',
	    72: 'H',
	    73: 'I',
	    74: 'J',
	    75: 'K',
	    76: 'L',
	    77: 'M',
	    78: 'N',
	    79: 'O',
	    80: 'P',
	    81: 'Q',
	    82: 'R',
	    83: 'S',
	    84: 'T',
	    85: 'U',
	    86: 'V',
	    87: 'W',
	    88: 'X',
	    89: 'Y',
	    90: 'Z',
	    93: 'ContextMenu',
	    96: '0',
	    97: '1',
	    98: '2',
	    99: '3',
	    100: '4',
	    101: '5',
	    102: '6',
	    103: '7',
	    104: '8',
	    105: '9',
	    106: '*',
	    107: '+',
	    109: '-',
	    110: '.',
	    111: '/',
	    112: 'F1',
	    113: 'F2',
	    114: 'F3',
	    115: 'F4',
	    116: 'F5',
	    117: 'F6',
	    118: 'F7',
	    119: 'F8',
	    120: 'F9',
	    121: 'F10',
	    122: 'F11',
	    123: 'F12',
	    173: '-',
	    186: ';',
	    187: '=',
	    188: ',',
	    189: '-',
	    190: '.',
	    191: '/',
	    192: '`',
	    219: '[',
	    220: '\\',
	    221: ']',
	    222: '\''
	});


/***/ },
/* 17 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var iteration_1 = __webpack_require__(5);
	var messaging_1 = __webpack_require__(18);
	var properties_1 = __webpack_require__(20);
	var signaling_1 = __webpack_require__(6);
	var title_1 = __webpack_require__(21);
	/**
	 * The class name added to Widget instances.
	 */
	var WIDGET_CLASS = 'p-Widget';
	/**
	 * The class name added to hidden widgets.
	 */
	var HIDDEN_CLASS = 'p-mod-hidden';
	/**
	 * The base class of the Phosphor widget hierarchy.
	 *
	 * #### Notes
	 * This class will typically be subclassed in order to create a useful
	 * widget. However, it can be used directly to host externally created
	 * content.
	 */
	var Widget = (function () {
	    /**
	     * Construct a new widget.
	     *
	     * @param options - The options for initializing the widget.
	     */
	    function Widget(options) {
	        if (options === void 0) { options = {}; }
	        this._flags = 0;
	        this._layout = null;
	        this._parent = null;
	        this._node = Private.createNode(options);
	        this.addClass(WIDGET_CLASS);
	    }
	    /**
	     * Dispose of the widget and its descendant widgets.
	     *
	     * #### Notes
	     * It is unsafe to use the widget after it has been disposed.
	     *
	     * All calls made to this method after the first are a no-op.
	     */
	    Widget.prototype.dispose = function () {
	        // Do nothing if the widget is already disposed.
	        if (this.isDisposed) {
	            return;
	        }
	        // Set the disposed flag and emit the disposed signal.
	        this.setFlag(WidgetFlag.IsDisposed);
	        this.disposed.emit(void 0);
	        // Remove or detach the widget if necessary.
	        if (this.parent) {
	            this.parent = null;
	        }
	        else if (this.isAttached) {
	            Widget.detach(this);
	        }
	        // Dispose of the widget layout.
	        if (this._layout) {
	            this._layout.dispose();
	            this._layout = null;
	        }
	        // Clear the attached data associated with the widget.
	        signaling_1.clearSignalData(this);
	        messaging_1.clearMessageData(this);
	        properties_1.clearPropertyData(this);
	        // Clear the reference to the DOM node.
	        this._node = null;
	    };
	    Object.defineProperty(Widget.prototype, "isDisposed", {
	        /**
	         * Test whether the widget has been disposed.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.testFlag(WidgetFlag.IsDisposed);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Widget.prototype, "isAttached", {
	        /**
	         * Test whether the widget's node is attached to the DOM.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.testFlag(WidgetFlag.IsAttached);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Widget.prototype, "isHidden", {
	        /**
	         * Test whether the widget is explicitly hidden.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.testFlag(WidgetFlag.IsHidden);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Widget.prototype, "isVisible", {
	        /**
	         * Test whether the widget is visible.
	         *
	         * #### Notes
	         * A widget is visible when it is attached to the DOM, is not
	         * explicitly hidden, and has no explicitly hidden ancestors.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.testFlag(WidgetFlag.IsVisible);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Widget.prototype, "node", {
	        /**
	         * Get the DOM node owned by the widget.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._node;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Widget.prototype, "id", {
	        /**
	         * Get the id of the widget's DOM node.
	         */
	        get: function () {
	            return this._node.id;
	        },
	        /**
	         * Set the id of the widget's DOM node.
	         */
	        set: function (value) {
	            this._node.id = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Widget.prototype, "title", {
	        /**
	         * Get the title object for the widget.
	         *
	         * #### Notes
	         * The title object is used by some container widgets when displaying
	         * the widget alongside some title, such as a tab panel or side bar.
	         *
	         * Since not all widgets will use the title, it is created on demand.
	         *
	         * The `owner` property of the title is set to this widget.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return Private.titleProperty.get(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Widget.prototype, "parent", {
	        /**
	         * Get the parent of the widget.
	         *
	         * #### Notes
	         * This will be `null` if the widget does not have a parent.
	         */
	        get: function () {
	            return this._parent;
	        },
	        /**
	         * Set the parent of the widget.
	         *
	         * #### Notes
	         * Children are typically added to a widget by using a layout, which
	         * means user code will not normally set the parent widget directly.
	         *
	         * The widget will be automatically removed from its old parent.
	         *
	         * This is a no-op if there is no effective parent change.
	         */
	        set: function (value) {
	            value = value || null;
	            if (this._parent === value) {
	                return;
	            }
	            if (value && this.contains(value)) {
	                throw new Error('Invalid parent widget.');
	            }
	            if (this._parent && !this._parent.isDisposed) {
	                messaging_1.sendMessage(this._parent, new ChildMessage('child-removed', this));
	            }
	            this._parent = value;
	            if (this._parent && !this._parent.isDisposed) {
	                messaging_1.sendMessage(this._parent, new ChildMessage('child-added', this));
	            }
	            messaging_1.sendMessage(this, WidgetMessage.ParentChanged);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Widget.prototype, "layout", {
	        /**
	         * Get the layout for the widget.
	         *
	         * #### Notes
	         * This will be `null` if the widget does not have a layout.
	         */
	        get: function () {
	            return this._layout;
	        },
	        /**
	         * Set the layout for the widget.
	         *
	         * #### Notes
	         * The layout is single-use only. It cannot be set to `null` and it
	         * cannot be changed after the first assignment.
	         *
	         * The layout is disposed automatically when the widget is disposed.
	         */
	        set: function (value) {
	            value = value || null;
	            if (this._layout === value) {
	                return;
	            }
	            if (this.testFlag(WidgetFlag.DisallowLayout)) {
	                throw new Error('Cannot set widget layout.');
	            }
	            if (this._layout) {
	                throw new Error('Cannot change widget layout.');
	            }
	            if (value.parent) {
	                throw new Error('Cannot change layout parent.');
	            }
	            this._layout = value;
	            value.parent = this;
	            messaging_1.sendMessage(this, WidgetMessage.LayoutChanged);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Create an iterator over the widget's children.
	     *
	     * @returns A new iterator over the children of the widget.
	     *
	     * #### Notes
	     * The widget must have a populated layout in order to have children.
	     *
	     * If a layout is not installed, the returned iterator will be empty.
	     */
	    Widget.prototype.children = function () {
	        return iteration_1.iter(this._layout || iteration_1.EmptyIterator.instance);
	    };
	    /**
	     * Test whether a widget is a descendant of this widget.
	     *
	     * @param widget - The descendant widget of interest.
	     *
	     * @returns `true` if the widget is a descendant, `false` otherwise.
	     */
	    Widget.prototype.contains = function (widget) {
	        for (; widget; widget = widget._parent) {
	            if (widget === this)
	                return true;
	        }
	        return false;
	    };
	    /**
	     * Test whether the widget's DOM node has the given class name.
	     *
	     * @param name - The class name of interest.
	     *
	     * @returns `true` if the node has the class, `false` otherwise.
	     */
	    Widget.prototype.hasClass = function (name) {
	        return this._node.classList.contains(name);
	    };
	    /**
	     * Add a class name to the widget's DOM node.
	     *
	     * @param name - The class name to add to the node.
	     *
	     * #### Notes
	     * If the class name is already added to the node, this is a no-op.
	     *
	     * The class name must not contain whitespace.
	     */
	    Widget.prototype.addClass = function (name) {
	        this._node.classList.add(name);
	    };
	    /**
	     * Remove a class name from the widget's DOM node.
	     *
	     * @param name - The class name to remove from the node.
	     *
	     * #### Notes
	     * If the class name is not yet added to the node, this is a no-op.
	     *
	     * The class name must not contain whitespace.
	     */
	    Widget.prototype.removeClass = function (name) {
	        this._node.classList.remove(name);
	    };
	    /**
	     * Toggle a class name on the widget's DOM node.
	     *
	     * @param name - The class name to toggle on the node.
	     *
	     * @param force - Whether to force add the class (`true`) or force
	     *   remove the class (`false`). If not provided, the presence of
	     *   the class will be toggled from its current state.
	     *
	     * @returns `true` if the class is now present, `false` otherwise.
	     *
	     * #### Notes
	     * The class name must not contain whitespace.
	     */
	    Widget.prototype.toggleClass = function (name, force) {
	        if (force === true) {
	            this._node.classList.add(name);
	            return true;
	        }
	        if (force === false) {
	            this._node.classList.remove(name);
	            return false;
	        }
	        return this._node.classList.toggle(name);
	    };
	    /**
	     * Post an `'update-request'` message to the widget.
	     *
	     * #### Notes
	     * This is a simple convenience method for posting the message.
	     */
	    Widget.prototype.update = function () {
	        messaging_1.postMessage(this, WidgetMessage.UpdateRequest);
	    };
	    /**
	     * Post a `'fit-request'` message to the widget.
	     *
	     * #### Notes
	     * This is a simple convenience method for posting the message.
	     */
	    Widget.prototype.fit = function () {
	        messaging_1.postMessage(this, WidgetMessage.FitRequest);
	    };
	    /**
	     * Post an `'activate-request'` message to the widget.
	     *
	     * #### Notes
	     * This is a simple convenience method for posting the message.
	     */
	    Widget.prototype.activate = function () {
	        messaging_1.postMessage(this, WidgetMessage.ActivateRequest);
	    };
	    /**
	     * Post a `'deactivate-request'` message to the widget.
	     *
	     * #### Notes
	     * This is a simple convenience method for posting the message.
	     */
	    Widget.prototype.deactivate = function () {
	        messaging_1.postMessage(this, WidgetMessage.DeactivateRequest);
	    };
	    /**
	     * Send a `'close-request'` message to the widget.
	     *
	     * #### Notes
	     * This is a simple convenience method for sending the message.
	     */
	    Widget.prototype.close = function () {
	        messaging_1.sendMessage(this, WidgetMessage.CloseRequest);
	    };
	    /**
	     * Show the widget and make it visible to its parent widget.
	     *
	     * #### Notes
	     * This causes the [[isHidden]] property to be `false`.
	     *
	     * If the widget is not explicitly hidden, this is a no-op.
	     */
	    Widget.prototype.show = function () {
	        if (!this.testFlag(WidgetFlag.IsHidden)) {
	            return;
	        }
	        this.clearFlag(WidgetFlag.IsHidden);
	        this.removeClass(HIDDEN_CLASS);
	        if (this.isAttached && (!this.parent || this.parent.isVisible)) {
	            messaging_1.sendMessage(this, WidgetMessage.AfterShow);
	        }
	        if (this.parent) {
	            messaging_1.sendMessage(this.parent, new ChildMessage('child-shown', this));
	        }
	    };
	    /**
	     * Hide the widget and make it hidden to its parent widget.
	     *
	     * #### Notes
	     * This causes the [[isHidden]] property to be `true`.
	     *
	     * If the widget is explicitly hidden, this is a no-op.
	     */
	    Widget.prototype.hide = function () {
	        if (this.testFlag(WidgetFlag.IsHidden)) {
	            return;
	        }
	        if (this.isAttached && (!this.parent || this.parent.isVisible)) {
	            messaging_1.sendMessage(this, WidgetMessage.BeforeHide);
	        }
	        this.setFlag(WidgetFlag.IsHidden);
	        this.addClass(HIDDEN_CLASS);
	        if (this.parent) {
	            messaging_1.sendMessage(this.parent, new ChildMessage('child-hidden', this));
	        }
	    };
	    /**
	     * Show or hide the widget according to a boolean value.
	     *
	     * @param hidden - `true` to hide the widget, or `false` to show it.
	     *
	     * #### Notes
	     * This is a convenience method for `hide()` and `show()`.
	     */
	    Widget.prototype.setHidden = function (hidden) {
	        if (hidden) {
	            this.hide();
	        }
	        else {
	            this.show();
	        }
	    };
	    /**
	     * Test whether the given widget flag is set.
	     *
	     * #### Notes
	     * This will not typically be called directly by user code.
	     */
	    Widget.prototype.testFlag = function (flag) {
	        return (this._flags & flag) !== 0;
	    };
	    /**
	     * Set the given widget flag.
	     *
	     * #### Notes
	     * This will not typically be called directly by user code.
	     */
	    Widget.prototype.setFlag = function (flag) {
	        this._flags |= flag;
	    };
	    /**
	     * Clear the given widget flag.
	     *
	     * #### Notes
	     * This will not typically be called directly by user code.
	     */
	    Widget.prototype.clearFlag = function (flag) {
	        this._flags &= ~flag;
	    };
	    /**
	     * Process a message sent to the widget.
	     *
	     * @param msg - The message sent to the widget.
	     *
	     * #### Notes
	     * Subclasses may reimplement this method as needed.
	     */
	    Widget.prototype.processMessage = function (msg) {
	        switch (msg.type) {
	            case 'resize':
	                this.notifyLayout(msg);
	                this.onResize(msg);
	                break;
	            case 'update-request':
	                this.notifyLayout(msg);
	                this.onUpdateRequest(msg);
	                break;
	            case 'after-show':
	                this.setFlag(WidgetFlag.IsVisible);
	                this.notifyLayout(msg);
	                this.onAfterShow(msg);
	                break;
	            case 'before-hide':
	                this.notifyLayout(msg);
	                this.onBeforeHide(msg);
	                this.clearFlag(WidgetFlag.IsVisible);
	                break;
	            case 'after-attach':
	                var visible = !this.isHidden && (!this.parent || this.parent.isVisible);
	                if (visible)
	                    this.setFlag(WidgetFlag.IsVisible);
	                this.setFlag(WidgetFlag.IsAttached);
	                this.notifyLayout(msg);
	                this.onAfterAttach(msg);
	                break;
	            case 'before-detach':
	                this.notifyLayout(msg);
	                this.onBeforeDetach(msg);
	                this.clearFlag(WidgetFlag.IsVisible);
	                this.clearFlag(WidgetFlag.IsAttached);
	                break;
	            case 'activate-request':
	                this.notifyLayout(msg);
	                this.onActivateRequest(msg);
	                break;
	            case 'deactivate-request':
	                this.notifyLayout(msg);
	                this.onDeactivateRequest(msg);
	                break;
	            case 'close-request':
	                this.notifyLayout(msg);
	                this.onCloseRequest(msg);
	                break;
	            case 'child-added':
	                this.notifyLayout(msg);
	                this.onChildAdded(msg);
	                break;
	            case 'child-removed':
	                this.notifyLayout(msg);
	                this.onChildRemoved(msg);
	                break;
	            default:
	                this.notifyLayout(msg);
	                break;
	        }
	    };
	    /**
	     * Invoke the message processing routine of the widget's layout.
	     *
	     * @param msg - The message to dispatch to the layout.
	     *
	     * #### Notes
	     * This is a no-op if the widget does not have a layout.
	     *
	     * This will not typically be called directly by user code.
	     */
	    Widget.prototype.notifyLayout = function (msg) {
	        if (this._layout)
	            this._layout.processParentMessage(msg);
	    };
	    /**
	     * A message handler invoked on a `'close-request'` message.
	     *
	     * #### Notes
	     * The default implementation unparents or detaches the widget.
	     */
	    Widget.prototype.onCloseRequest = function (msg) {
	        if (this.parent) {
	            this.parent = null;
	        }
	        else if (this.isAttached) {
	            Widget.detach(this);
	        }
	    };
	    /**
	     * A message handler invoked on a `'resize'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Widget.prototype.onResize = function (msg) { };
	    /**
	     * A message handler invoked on an `'update-request'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Widget.prototype.onUpdateRequest = function (msg) { };
	    /**
	     * A message handler invoked on an `'activate-request'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Widget.prototype.onActivateRequest = function (msg) { };
	    /**
	     * A message handler invoked on a `'deactivate-request'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Widget.prototype.onDeactivateRequest = function (msg) { };
	    /**
	     * A message handler invoked on an `'after-show'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Widget.prototype.onAfterShow = function (msg) { };
	    /**
	     * A message handler invoked on a `'before-hide'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Widget.prototype.onBeforeHide = function (msg) { };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Widget.prototype.onAfterAttach = function (msg) { };
	    /**
	     * A message handler invoked on a `'before-detach'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Widget.prototype.onBeforeDetach = function (msg) { };
	    /**
	     * A message handler invoked on a `'child-added'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Widget.prototype.onChildAdded = function (msg) { };
	    /**
	     * A message handler invoked on a `'child-removed'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Widget.prototype.onChildRemoved = function (msg) { };
	    return Widget;
	}());
	exports.Widget = Widget;
	// Define the signals for the `Widget` class.
	signaling_1.defineSignal(Widget.prototype, 'disposed');
	/**
	 * The namespace for the `Widget` class statics.
	 */
	var Widget;
	(function (Widget) {
	    // TODO - should this be an instance method?
	    /**
	     * Attach a widget to a host DOM node.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @param host - The DOM node to use as the widget's host.
	     *
	     * #### Notes
	     * This will throw an error if the widget is not a root widget, if
	     * the widget is already attached, or if the host is not attached
	     * to the DOM.
	     */
	    function attach(widget, host) {
	        if (widget.parent) {
	            throw new Error('Cannot attach child widget.');
	        }
	        if (widget.isAttached || document.body.contains(widget.node)) {
	            throw new Error('Widget already attached.');
	        }
	        if (!document.body.contains(host)) {
	            throw new Error('Host not attached.');
	        }
	        host.appendChild(widget.node);
	        messaging_1.sendMessage(widget, WidgetMessage.AfterAttach);
	    }
	    Widget.attach = attach;
	    // TODO - should this be an instance method?
	    /**
	     * Detach the widget from its host DOM node.
	     *
	     * @param widget - The widget of interest.
	     *
	     * #### Notes
	     * This will throw an error if the widget is not a root widget, or
	     * if the widget is not attached to the DOM.
	     */
	    function detach(widget) {
	        if (widget.parent) {
	            throw new Error('Cannot detach child widget.');
	        }
	        if (!widget.isAttached || !document.body.contains(widget.node)) {
	            throw new Error('Widget not attached.');
	        }
	        messaging_1.sendMessage(widget, WidgetMessage.BeforeDetach);
	        widget.node.parentNode.removeChild(widget.node);
	    }
	    Widget.detach = detach;
	    /**
	     * Prepare a widget for absolute layout geometry.
	     *
	     * @param widget - The widget of interest.
	     *
	     * #### Notes
	     * This sets the inline style position of the widget to `absolute`.
	     */
	    function prepareGeometry(widget) {
	        widget.node.style.position = 'absolute';
	    }
	    Widget.prepareGeometry = prepareGeometry;
	    /**
	     * Reset the layout geometry of a widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * #### Notes
	     * This clears the inline style position and geometry of the widget.
	     */
	    function resetGeometry(widget) {
	        var style = widget.node.style;
	        var rect = Private.rectProperty.get(widget);
	        rect.top = NaN;
	        rect.left = NaN;
	        rect.width = NaN;
	        rect.height = NaN;
	        style.position = '';
	        style.top = '';
	        style.left = '';
	        style.width = '';
	        style.height = '';
	    }
	    Widget.resetGeometry = resetGeometry;
	    /**
	     * Set the absolute layout geometry of a widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @param left - The desired offset left position of the widget.
	     *
	     * @param top - The desired offset top position of the widget.
	     *
	     * @param width - The desired offset width of the widget.
	     *
	     * @param height - The desired offset height of the widget.
	     *
	     * #### Notes
	     * All dimensions are assumed to be pixels with coordinates relative
	     * to the origin of the widget's offset parent.
	     *
	     * The widget's node is assumed to be position `absolute`.
	     *
	     * If the widget is resized from its previous size, a `ResizeMessage`
	     * will be automatically sent to the widget.
	     */
	    function setGeometry(widget, left, top, width, height) {
	        var resized = false;
	        var style = widget.node.style;
	        var rect = Private.rectProperty.get(widget);
	        if (rect.top !== top) {
	            rect.top = top;
	            style.top = top + "px";
	        }
	        if (rect.left !== left) {
	            rect.left = left;
	            style.left = left + "px";
	        }
	        if (rect.width !== width) {
	            resized = true;
	            rect.width = width;
	            style.width = width + "px";
	        }
	        if (rect.height !== height) {
	            resized = true;
	            rect.height = height;
	            style.height = height + "px";
	        }
	        if (resized) {
	            messaging_1.sendMessage(widget, new ResizeMessage(width, height));
	        }
	    }
	    Widget.setGeometry = setGeometry;
	})(Widget = exports.Widget || (exports.Widget = {}));
	/**
	 * An abstract base class for creating Phosphor layouts.
	 *
	 * #### Notes
	 * A layout is used to add widgets to a parent and to arrange those
	 * widgets within the parent's DOM node.
	 *
	 * This class implements the base functionality which is required of
	 * nearly all layouts. It must be subclassed in order to be useful.
	 *
	 * Notably, this class does not define a uniform interface for adding
	 * widgets to the layout. A subclass should define that API in a way
	 * which is meaningful for its intended use.
	 */
	var Layout = (function () {
	    function Layout() {
	        this._disposed = false;
	        this._parent = null;
	    }
	    /**
	     * Dispose of the resources held by the layout.
	     *
	     * #### Notes
	     * This should be reimplemented to clear and dispose of the widgets.
	     *
	     * All reimplementations should call the superclass method.
	     *
	     * This method is called automatically when the parent is disposed.
	     */
	    Layout.prototype.dispose = function () {
	        this._disposed = true;
	        this._parent = null;
	        signaling_1.clearSignalData(this);
	        properties_1.clearPropertyData(this);
	    };
	    Object.defineProperty(Layout.prototype, "isDisposed", {
	        /**
	         * Test whether the layout is disposed.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._disposed;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Layout.prototype, "parent", {
	        /**
	         * Get the parent widget of the layout.
	         */
	        get: function () {
	            return this._parent;
	        },
	        /**
	         * Set the parent widget of the layout.
	         *
	         * #### Notes
	         * This is set automatically when installing the layout on the parent
	         * widget. The parent widget should not be set directly by user code.
	         */
	        set: function (value) {
	            if (!value) {
	                throw new Error('Cannot set parent widget to null.');
	            }
	            if (this._parent === value) {
	                return;
	            }
	            if (this._parent) {
	                throw new Error('Cannot change parent widget.');
	            }
	            if (value.layout !== this) {
	                throw new Error('Invalid parent widget.');
	            }
	            this._parent = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Process a message sent to the parent widget.
	     *
	     * @param msg - The message sent to the parent widget.
	     *
	     * #### Notes
	     * This method is called by the parent widget to process a message.
	     *
	     * Subclasses may reimplement this method as needed.
	     */
	    Layout.prototype.processParentMessage = function (msg) {
	        switch (msg.type) {
	            case 'resize':
	                this.onResize(msg);
	                break;
	            case 'update-request':
	                this.onUpdateRequest(msg);
	                break;
	            case 'fit-request':
	                this.onFitRequest(msg);
	                break;
	            case 'after-show':
	                this.onAfterShow(msg);
	                break;
	            case 'before-hide':
	                this.onBeforeHide(msg);
	                break;
	            case 'after-attach':
	                this.onAfterAttach(msg);
	                break;
	            case 'before-detach':
	                this.onBeforeDetach(msg);
	                break;
	            case 'child-removed':
	                this.onChildRemoved(msg);
	                break;
	            case 'child-shown':
	                this.onChildShown(msg);
	                break;
	            case 'child-hidden':
	                this.onChildHidden(msg);
	                break;
	            case 'layout-changed':
	                this.onLayoutChanged(msg);
	                break;
	        }
	    };
	    /**
	     * A message handler invoked on a `'resize'` message.
	     *
	     * #### Notes
	     * The layout should ensure that its widgets are resized according
	     * to the specified layout space, and that they are sent a `'resize'`
	     * message if appropriate.
	     *
	     * The default implementation of this method sends an `UnknownSize`
	     * resize message to all widgets.
	     *
	     * This may be reimplemented by subclasses as needed.
	     */
	    Layout.prototype.onResize = function (msg) {
	        iteration_1.each(this, function (widget) { messaging_1.sendMessage(widget, ResizeMessage.UnknownSize); });
	    };
	    /**
	     * A message handler invoked on an `'update-request'` message.
	     *
	     * #### Notes
	     * The layout should ensure that its widgets are resized according
	     * to the available layout space, and that they are sent a `'resize'`
	     * message if appropriate.
	     *
	     * The default implementation of this method sends an `UnknownSize`
	     * resize message to all widgets.
	     *
	     * This may be reimplemented by subclasses as needed.
	     */
	    Layout.prototype.onUpdateRequest = function (msg) {
	        iteration_1.each(this, function (widget) { messaging_1.sendMessage(widget, ResizeMessage.UnknownSize); });
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     *
	     * #### Notes
	     * The default implementation of this method forwards the message
	     * to all widgets. It assumes all widget nodes are attached to the
	     * parent widget node.
	     *
	     * This may be reimplemented by subclasses as needed.
	     */
	    Layout.prototype.onAfterAttach = function (msg) {
	        iteration_1.each(this, function (widget) { messaging_1.sendMessage(widget, msg); });
	    };
	    /**
	     * A message handler invoked on a `'before-detach'` message.
	     *
	     * #### Notes
	     * The default implementation of this method forwards the message
	     * to all widgets. It assumes all widget nodes are attached to the
	     * parent widget node.
	     *
	     * This may be reimplemented by subclasses as needed.
	     */
	    Layout.prototype.onBeforeDetach = function (msg) {
	        iteration_1.each(this, function (widget) { messaging_1.sendMessage(widget, msg); });
	    };
	    /**
	     * A message handler invoked on an `'after-show'` message.
	     *
	     * #### Notes
	     * The default implementation of this method forwards the message to
	     * all non-hidden widgets. It assumes all widget nodes are attached
	     * to the parent widget node.
	     *
	     * This may be reimplemented by subclasses as needed.
	     */
	    Layout.prototype.onAfterShow = function (msg) {
	        iteration_1.each(this, function (widget) { if (!widget.isHidden)
	            messaging_1.sendMessage(widget, msg); });
	    };
	    /**
	     * A message handler invoked on a `'before-hide'` message.
	     *
	     * #### Notes
	     * The default implementation of this method forwards the message to
	     * all non-hidden widgets. It assumes all widget nodes are attached
	     * to the parent widget node.
	     *
	     * This may be reimplemented by subclasses as needed.
	     */
	    Layout.prototype.onBeforeHide = function (msg) {
	        iteration_1.each(this, function (widget) { if (!widget.isHidden)
	            messaging_1.sendMessage(widget, msg); });
	    };
	    /**
	     * A message handler invoked on a `'fit-request'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Layout.prototype.onFitRequest = function (msg) { };
	    /**
	     * A message handler invoked on a `'child-shown'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Layout.prototype.onChildShown = function (msg) { };
	    /**
	     * A message handler invoked on a `'child-hidden'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Layout.prototype.onChildHidden = function (msg) { };
	    return Layout;
	}());
	exports.Layout = Layout;
	// TODO should this be in the Widget namespace?
	/**
	 * An enum of widget bit flags.
	 */
	(function (WidgetFlag) {
	    /**
	     * The widget has been disposed.
	     */
	    WidgetFlag[WidgetFlag["IsDisposed"] = 1] = "IsDisposed";
	    /**
	     * The widget is attached to the DOM.
	     */
	    WidgetFlag[WidgetFlag["IsAttached"] = 2] = "IsAttached";
	    /**
	     * The widget is hidden.
	     */
	    WidgetFlag[WidgetFlag["IsHidden"] = 4] = "IsHidden";
	    /**
	     * The widget is visible.
	     */
	    WidgetFlag[WidgetFlag["IsVisible"] = 8] = "IsVisible";
	    /**
	     * A layout cannot be set on the widget.
	     */
	    WidgetFlag[WidgetFlag["DisallowLayout"] = 16] = "DisallowLayout";
	})(exports.WidgetFlag || (exports.WidgetFlag = {}));
	var WidgetFlag = exports.WidgetFlag;
	// TODO should this be in the Widget namespace?
	/**
	 * A collection of stateless messages related to widgets.
	 */
	var WidgetMessage;
	(function (WidgetMessage) {
	    /**
	     * A singleton `'after-show'` message.
	     *
	     * #### Notes
	     * This message is sent to a widget after it becomes visible.
	     *
	     * This message is **not** sent when the widget is being attached.
	     */
	    WidgetMessage.AfterShow = new messaging_1.Message('after-show');
	    /**
	     * A singleton `'before-hide'` message.
	     *
	     * #### Notes
	     * This message is sent to a widget before it becomes not-visible.
	     *
	     * This message is **not** sent when the widget is being detached.
	     */
	    WidgetMessage.BeforeHide = new messaging_1.Message('before-hide');
	    /**
	     * A singleton `'after-attach'` message.
	     *
	     * #### Notes
	     * This message is sent to a widget after it is attached.
	     */
	    WidgetMessage.AfterAttach = new messaging_1.Message('after-attach');
	    /**
	     * A singleton `'before-detach'` message.
	     *
	     * #### Notes
	     * This message is sent to a widget before it is detached.
	     */
	    WidgetMessage.BeforeDetach = new messaging_1.Message('before-detach');
	    /**
	     * A singleton `'parent-changed'` message.
	     *
	     * #### Notes
	     * This message is sent to a widget when its parent has changed.
	     */
	    WidgetMessage.ParentChanged = new messaging_1.Message('parent-changed');
	    /**
	     * A singleton `'layout-changed'` message.
	     *
	     * #### Notes
	     * This message is sent to a widget when its layout has changed.
	     */
	    WidgetMessage.LayoutChanged = new messaging_1.Message('layout-changed');
	    /**
	     * A singleton conflatable `'update-request'` message.
	     *
	     * #### Notes
	     * This message can be dispatched to supporting widgets in order to
	     * update their content based on the current widget state. Not all
	     * widgets will respond to messages of this type.
	     *
	     * For widgets with a layout, this message will inform the layout to
	     * update the position and size of its child widgets.
	     */
	    WidgetMessage.UpdateRequest = new messaging_1.ConflatableMessage('update-request');
	    /**
	     * A singleton conflatable `'fit-request'` message.
	     *
	     * #### Notes
	     * For widgets with a layout, this message will inform the layout to
	     * recalculate its size constraints to fit the space requirements of
	     * its child widgets, and to update their position and size. Not all
	     * layouts will respond to messages of this type.
	     */
	    WidgetMessage.FitRequest = new messaging_1.ConflatableMessage('fit-request');
	    /**
	     * A singleton conflatable `'activate-request'` message.
	     *
	     * #### Notes
	     * This message should be dispatched to a widget when it should
	     * perform the actions necessary to activate the widget, which
	     * may include focusing its node or descendant node.
	     */
	    WidgetMessage.ActivateRequest = new messaging_1.ConflatableMessage('activate-request');
	    /**
	     * A singleton conflatable `'deactivate-request'` message.
	     *
	     * #### Notes
	     * This message should be dispatched to a widget when it should
	     * perform the actions necessary to decactivate the widget, which
	     * may include blurring its node or descendant node.
	     */
	    WidgetMessage.DeactivateRequest = new messaging_1.ConflatableMessage('deactivate-request');
	    /**
	     * A singleton conflatable `'close-request'` message.
	     *
	     * #### Notes
	     * This message should be dispatched to a widget when it should close
	     * and remove itself from the widget hierarchy.
	     */
	    WidgetMessage.CloseRequest = new messaging_1.ConflatableMessage('close-request');
	})(WidgetMessage = exports.WidgetMessage || (exports.WidgetMessage = {}));
	// TODO should this be in the Widget namespace?
	/**
	 * A message class for child related messages.
	 */
	var ChildMessage = (function (_super) {
	    __extends(ChildMessage, _super);
	    /**
	     * Construct a new child message.
	     *
	     * @param type - The message type.
	     *
	     * @param child - The child widget for the message.
	     */
	    function ChildMessage(type, child) {
	        _super.call(this, type);
	        this._child = child;
	    }
	    Object.defineProperty(ChildMessage.prototype, "child", {
	        /**
	         * The child widget for the message.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._child;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return ChildMessage;
	}(messaging_1.Message));
	exports.ChildMessage = ChildMessage;
	// TODO should this be in the Widget namespace?
	/**
	 * A message class for `'resize'` messages.
	 */
	var ResizeMessage = (function (_super) {
	    __extends(ResizeMessage, _super);
	    /**
	     * Construct a new resize message.
	     *
	     * @param width - The **offset width** of the widget, or `-1` if
	     *   the width is not known.
	     *
	     * @param height - The **offset height** of the widget, or `-1` if
	     *   the height is not known.
	     */
	    function ResizeMessage(width, height) {
	        _super.call(this, 'resize');
	        this._width = width;
	        this._height = height;
	    }
	    Object.defineProperty(ResizeMessage.prototype, "width", {
	        /**
	         * The offset width of the widget.
	         *
	         * #### Notes
	         * This will be `-1` if the width is unknown.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._width;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ResizeMessage.prototype, "height", {
	        /**
	         * The offset height of the widget.
	         *
	         * #### Notes
	         * This will be `-1` if the height is unknown.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._height;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return ResizeMessage;
	}(messaging_1.Message));
	exports.ResizeMessage = ResizeMessage;
	/**
	 * The namespace for the `ResizeMessage` class statics.
	 */
	var ResizeMessage;
	(function (ResizeMessage) {
	    /**
	     * A singleton `'resize'` message with an unknown size.
	     */
	    ResizeMessage.UnknownSize = new ResizeMessage(-1, -1);
	})(ResizeMessage = exports.ResizeMessage || (exports.ResizeMessage = {}));
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * A property descriptor for a widget absolute geometry rect.
	     */
	    Private.rectProperty = new properties_1.AttachedProperty({
	        name: 'rect',
	        create: function () { return ({ top: NaN, left: NaN, width: NaN, height: NaN }); },
	    });
	    /**
	     * An attached property for the widget title object.
	     */
	    Private.titleProperty = new properties_1.AttachedProperty({
	        name: 'title',
	        create: function (owner) { return new title_1.Title({ owner: owner }); },
	    });
	    /**
	     * Create a DOM node for the given widget options.
	     */
	    function createNode(options) {
	        return options.node || document.createElement('div');
	    }
	    Private.createNode = createNode;
	})(Private || (Private = {}));


/***/ },
/* 18 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(setImmediate) {"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var iteration_1 = __webpack_require__(5);
	var queue_1 = __webpack_require__(19);
	/**
	 * A message which can be delivered to a message handler.
	 *
	 * #### Notes
	 * This class may be subclassed to create complex message types.
	 *
	 * **See also:** [[postMessage]] and [[sendMessage]].
	 */
	var Message = (function () {
	    /**
	     * Construct a new message.
	     *
	     * @param type - The type of the message.
	     */
	    function Message(type) {
	        this._type = type;
	    }
	    Object.defineProperty(Message.prototype, "type", {
	        /**
	         * The type of the message.
	         *
	         * #### Notes
	         * This value can be used to cast the message to a derived type.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._type;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Message.prototype, "isConflatable", {
	        /**
	         * Test whether the message is conflatable.
	         *
	         * #### Notes
	         * Message conflation is an advanced topic. Most message types will
	         * not make use of this feature.
	         *
	         * If a conflatable message is posted to the event queue when another
	         * conflatable message of the same type and handler has already been
	         * posted, the `conflate()` method of the existing message will be
	         * invoked. If that method returns `true`, the new message will not
	         * be enqueued. This allows messages to be compressed, so that only
	         * a single instance of the message type is processed per cycle, no
	         * matter how many times messages of that type are posted.
	         *
	         * Custom message types may reimplement this property. The default
	         * implementation is always `false`.
	         *
	         * This is a read-only property.
	         *
	         * **See also:** [[conflateMessage]]
	         */
	        get: function () {
	            return false;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Conflate this message with another message of the same `type`.
	     *
	     * @param other - A conflatable message of the same `type`.
	     *
	     * @returns `true` if the message was successfully conflated, or
	     *   `false` otherwise.
	     *
	     * #### Notes
	     * Message conflation is an advanced topic. Most message types will
	     * not make use of this feature.
	     *
	     * This method is called automatically by the message loop when the
	     * given message is posted to the handler paired with this message.
	     * This message will already be enqueued and conflatable, and the
	     * given message will have the same `type` and also be conflatable.
	     *
	     * This method should merge the state of the other message into this
	     * message as needed so that when this message is finally delivered
	     * to the handler, it receives the most up-to-date information.
	     *
	     * If this method returns `true`, it signals that the other message
	     * was successfully conflated and it will not be enqueued.
	     *
	     * If this method returns `false`, the other message will be enqueued
	     * for normal delivery.
	     *
	     * Custom message types may reimplement this method. The default
	     * implementation always returns `false`.
	     *
	     * **See also:** [[isConflatable]]
	     */
	    Message.prototype.conflate = function (other) {
	        return false;
	    };
	    return Message;
	}());
	exports.Message = Message;
	/**
	 * A convenience message class which conflates automatically.
	 *
	 * #### Notes
	 * Message conflation is an advanced topic. Most user code will not
	 * make use of this class.
	 *
	 * This message class is useful for creating message instances which
	 * should be conflated, but which have no state other than `type`.
	 *
	 * If conflation of stateful messages is required, a custom `Message`
	 * subclass should be created.
	 */
	var ConflatableMessage = (function (_super) {
	    __extends(ConflatableMessage, _super);
	    function ConflatableMessage() {
	        _super.apply(this, arguments);
	    }
	    Object.defineProperty(ConflatableMessage.prototype, "isConflatable", {
	        /**
	         * Test whether the message is conflatable.
	         *
	         * #### Notes
	         * This property is always `true`.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return true;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Conflate this message with another message of the same `type`.
	     *
	     * #### Notes
	     * This method always returns `true`.
	     */
	    ConflatableMessage.prototype.conflate = function (other) {
	        return true;
	    };
	    return ConflatableMessage;
	}(Message));
	exports.ConflatableMessage = ConflatableMessage;
	/**
	 * Send a message to a message handler to process immediately.
	 *
	 * @param handler - The handler which should process the message.
	 *
	 * @param msg - The message to deliver to the handler.
	 *
	 * #### Notes
	 * The message will first be sent through any installed message hooks
	 * for the handler. If the message passes all hooks, it will then be
	 * delivered to the `processMessage` method of the handler.
	 *
	 * The message will not be conflated with pending posted messages.
	 *
	 * Exceptions in hooks and handlers will be caught and logged.
	 */
	function sendMessage(handler, msg) {
	    MessageLoop.sendMessage(handler, msg);
	}
	exports.sendMessage = sendMessage;
	/**
	 * Post a message to the message handler to process in the future.
	 *
	 * @param handler - The handler which should process the message.
	 *
	 * @param msg - The message to post to the handler.
	 *
	 * #### Notes
	 * The message will be conflated with the pending posted messages for
	 * the handler, if possible. If the message is not conflated, it will
	 * be queued for normal delivery on the next cycle of the event loop.
	 *
	 * Exceptions in hooks and handlers will be caught and logged.
	 */
	function postMessage(handler, msg) {
	    MessageLoop.postMessage(handler, msg);
	}
	exports.postMessage = postMessage;
	/**
	 * Install a message hook for a message handler.
	 *
	 * @param handler - The message handler of interest.
	 *
	 * @param hook - The message hook to install.
	 *
	 * #### Notes
	 * A message hook is invoked before a message is delivered to the
	 * handler. If the hook returns `false`, no other hooks will be
	 * invoked and the message will not be delivered to the handler.
	 *
	 * The most recently installed message hook is executed first.
	 *
	 * If the hook is already installed, it will be moved to the front.
	 *
	 * **See also:** [[removeMessageHook]]
	 */
	function installMessageHook(handler, hook) {
	    MessageLoop.installMessageHook(handler, hook);
	}
	exports.installMessageHook = installMessageHook;
	/**
	 * Remove an installed message hook for a message handler.
	 *
	 * @param handler - The message handler of interest.
	 *
	 * @param hook - The message hook to remove.
	 *
	 * #### Notes
	 * If the hook is not installed, this is a no-op.
	 *
	 * It is safe to call this function while the hook is executing.
	 */
	function removeMessageHook(handler, hook) {
	    MessageLoop.removeMessageHook(handler, hook);
	}
	exports.removeMessageHook = removeMessageHook;
	/**
	 * Clear all message data associated with a message handler.
	 *
	 * @param handler - The message handler of interest.
	 *
	 * #### Notes
	 * This will clear all pending messages and hooks for the handler.
	 */
	function clearMessageData(handler) {
	    MessageLoop.clearMessageData(handler);
	}
	exports.clearMessageData = clearMessageData;
	/**
	 * The namespace for the global singleton message loop.
	 */
	var MessageLoop;
	(function (MessageLoop) {
	    /**
	     * Send a message to a handler for immediate processing.
	     *
	     * This will first call all message hooks for the handler. If any
	     * hook rejects the message, the message will not be delivered.
	     */
	    function sendMessage(handler, msg) {
	        // Handle the common case of no message hooks.
	        var node = hooks.get(handler);
	        if (node === void 0) {
	            invokeHandler(handler, msg);
	            return;
	        }
	        // Run the message hooks and bail early if any hook returns false.
	        // A null hook indicates the hook was removed during dispatch.
	        for (; node !== null; node = node.next) {
	            if (node.hook !== null && !invokeHook(node.hook, handler, msg)) {
	                return;
	            }
	        }
	        // All message hooks returned true, so invoke the handler.
	        invokeHandler(handler, msg);
	    }
	    MessageLoop.sendMessage = sendMessage;
	    /**
	     * Post a message to a handler for processing in the future.
	     *
	     * This will first conflate the message, if possible. If it cannot
	     * be conflated, it will be queued for delivery on the next cycle
	     * of the event loop.
	     */
	    function postMessage(handler, msg) {
	        // Handle the common case a non-conflatable message first.
	        if (!msg.isConflatable) {
	            enqueueMessage(handler, msg);
	            return;
	        }
	        // Conflate message if possible.
	        var conflated = iteration_1.some(queue, function (posted) {
	            if (posted.handler !== handler) {
	                return false;
	            }
	            if (posted.msg.type !== msg.type) {
	                return false;
	            }
	            if (!posted.msg.isConflatable) {
	                return false;
	            }
	            return posted.msg.conflate(msg);
	        });
	        // If the message was not conflated, enqueue the message.
	        if (!conflated)
	            enqueueMessage(handler, msg);
	    }
	    MessageLoop.postMessage = postMessage;
	    /**
	     * Install a message hook for a handler.
	     *
	     * This will first remove the hook if it exists, then install the
	     * hook in front of other hooks for the handler.
	     */
	    function installMessageHook(handler, hook) {
	        // Remove the message hook if it's already installed.
	        removeMessageHook(handler, hook);
	        // Install the hook at the front of the list.
	        var next = hooks.get(handler) || null;
	        hooks.set(handler, { next: next, hook: hook });
	    }
	    MessageLoop.installMessageHook = installMessageHook;
	    /**
	     * Remove a message hook for a handler, if it exists.
	     */
	    function removeMessageHook(handler, hook) {
	        // Traverse the list and find the matching hook. If found, clear
	        // the reference to the hook and remove the node from the list.
	        // The node's next reference is *not* cleared so that dispatch
	        // may continue when the hook is removed during dispatch.
	        var prev = null;
	        var node = hooks.get(handler) || null;
	        for (; node !== null; prev = node, node = node.next) {
	            if (node.hook === hook) {
	                if (prev === null && node.next === null) {
	                    hooks.delete(handler);
	                }
	                else if (prev === null) {
	                    hooks.set(handler, node.next);
	                }
	                else {
	                    prev.next = node.next;
	                }
	                node.hook = null;
	                return;
	            }
	        }
	    }
	    MessageLoop.removeMessageHook = removeMessageHook;
	    /**
	     * Clear all message data for a handler.
	     *
	     * This will remove all message hooks and clear pending messages.
	     */
	    function clearMessageData(handler) {
	        // Clear all message hooks.
	        var node = hooks.get(handler) || null;
	        for (; node !== null; node = node.next) {
	            node.hook = null;
	        }
	        // Remove the handler from the hooks map.
	        hooks.delete(handler);
	        // Clear all pending messages.
	        iteration_1.each(queue, function (posted) {
	            if (posted.handler === handler) {
	                posted.handler = null;
	            }
	        });
	    }
	    MessageLoop.clearMessageData = clearMessageData;
	    /**
	     * The queue of posted message pairs.
	     */
	    var queue = new queue_1.Queue();
	    /**
	     * A mapping of handler to list of installed message hooks.
	     */
	    var hooks = new WeakMap();
	    /**
	     * A local reference to an event loop callback.
	     */
	    var defer = (function () {
	        var ok = typeof requestAnimationFrame === 'function';
	        return ok ? requestAnimationFrame : setImmediate;
	    })();
	    /**
	     * Whether a message loop cycle is pending.
	     */
	    var cyclePending = false;
	    /**
	     * Invoke a message hook with the specified handler and message.
	     *
	     * Returns the result of the hook, or `true` if the hook throws.
	     *
	     * Exceptions in the hook will be caught and logged.
	     */
	    function invokeHook(hook, handler, msg) {
	        var result;
	        try {
	            result = hook(handler, msg);
	        }
	        catch (err) {
	            result = true;
	            console.error(err);
	        }
	        return result;
	    }
	    /**
	     * Invoke a message handler with the specified message.
	     *
	     * Exceptions in the handler will be caught and logged.
	     */
	    function invokeHandler(handler, msg) {
	        try {
	            handler.processMessage(msg);
	        }
	        catch (err) {
	            console.error(err);
	        }
	    }
	    /**
	     * Add a message to the end of the message queue.
	     *
	     * This will automatically schedule a cycle of the loop.
	     */
	    function enqueueMessage(handler, msg) {
	        queue.pushBack({ handler: handler, msg: msg });
	        scheduleMessageLoop();
	    }
	    /**
	     * Schedule a message loop cycle to process any pending messages.
	     *
	     * This is a no-op if a loop cycle is already pending.
	     */
	    function scheduleMessageLoop() {
	        if (!cyclePending) {
	            defer(runMessageLoop);
	            cyclePending = true;
	        }
	    }
	    /**
	     * Run an iteration of the message loop.
	     *
	     * This will process all pending messages in the queue. If a message
	     * is added to the queue while the message loop is running, it will
	     * be processed on the next cycle of the loop.
	     */
	    function runMessageLoop() {
	        // Clear the pending flag so the next loop can be scheduled.
	        cyclePending = false;
	        // If the queue is empty, there is nothing else to do.
	        if (queue.isEmpty) {
	            return;
	        }
	        // Add a sentinel value to the end of the queue. The queue will
	        // only be processed up to the sentinel. Messages posted during
	        // this cycle will execute on the next cycle.
	        var sentinel = { handler: null, msg: null };
	        queue.pushBack(sentinel);
	        // Enter the message loop.
	        while (!queue.isEmpty) {
	            // Remove the first posted message in the queue.
	            var posted = queue.popFront();
	            // If the value is the sentinel, exit the loop.
	            if (posted === sentinel) {
	                return;
	            }
	            // Dispatch the message if the handler has not been cleared.
	            if (posted.handler !== null) {
	                sendMessage(posted.handler, posted.msg);
	            }
	        }
	    }
	})(MessageLoop || (MessageLoop = {}));
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(7).setImmediate))

/***/ },
/* 19 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var iteration_1 = __webpack_require__(5);
	/**
	 * A generic FIFO queue data structure.
	 */
	var Queue = (function () {
	    /**
	     * Construct a new queue.
	     *
	     * @param values - The initial values for the queue.
	     */
	    function Queue(values) {
	        var _this = this;
	        this._length = 0;
	        this._front = null;
	        this._back = null;
	        if (values)
	            iteration_1.each(values, function (value) { _this.pushBack(value); });
	    }
	    Object.defineProperty(Queue.prototype, "isEmpty", {
	        /**
	         * Test whether the queue is empty.
	         *
	         * @returns `true` if the queue is empty, `false` otherwise.
	         *
	         * #### Notes
	         * This is a read-only property.
	         *
	         * #### Complexity
	         * Constant.
	         *
	         * #### Iterator Validity
	         * No changes.
	         */
	        get: function () {
	            return this._length === 0;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Queue.prototype, "length", {
	        /**
	         * Get the length of the queue.
	         *
	         * @return The number of values in the queue.
	         *
	         * #### Notes
	         * This is a read-only property.
	         *
	         * #### Complexity
	         * Constant.
	         *
	         * #### Iterator Validity
	         * No changes.
	         */
	        get: function () {
	            return this._length;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Queue.prototype, "front", {
	        /**
	         * Get the value at the front of the queue.
	         *
	         * @returns The value at the front of the queue, or `undefined` if
	         *   the queue is empty.
	         *
	         * #### Notes
	         * This is a read-only property.
	         *
	         * #### Complexity
	         * Constant.
	         *
	         * #### Iterator Validity
	         * No changes.
	         */
	        get: function () {
	            return this._front ? this._front.value : void 0;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Queue.prototype, "back", {
	        /**
	         * Get the value at the back of the queue.
	         *
	         * @returns The value at the back of the queue, or `undefined` if
	         *   the queue is empty.
	         *
	         * #### Notes
	         * This is a read-only property.
	         *
	         * #### Complexity
	         * Constant.
	         *
	         * #### Iterator Validity
	         * No changes.
	         */
	        get: function () {
	            return this._back ? this._back.value : void 0;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Create an iterator over the values in the queue.
	     *
	     * @returns A new iterator starting at the front of the queue.
	     *
	     * #### Complexity
	     * Constant.
	     *
	     * #### Iterator Validity
	     * No changes.
	     */
	    Queue.prototype.iter = function () {
	        return new QueueIterator(this._front);
	    };
	    /**
	     * Add a value to the back of the queue.
	     *
	     * @param value - The value to add to the back of the queue.
	     *
	     * @returns The new length of the queue.
	     *
	     * #### Complexity
	     * Constant.
	     *
	     * #### Iterator Validity
	     * No changes.
	     */
	    Queue.prototype.pushBack = function (value) {
	        var node = new QueueNode(value);
	        if (this._length === 0) {
	            this._front = node;
	            this._back = node;
	        }
	        else {
	            this._back.next = node;
	            this._back = node;
	        }
	        return ++this._length;
	    };
	    /**
	     * Remove and return the value at the front of the queue.
	     *
	     * @returns The value at the front of the queue, or `undefined` if
	     *   the queue is empty.
	     *
	     * #### Complexity
	     * Constant.
	     *
	     * #### Iterator Validity
	     * Iterators pointing at the removed value are invalidated.
	     */
	    Queue.prototype.popFront = function () {
	        if (this._length === 0) {
	            return void 0;
	        }
	        var node = this._front;
	        if (this._length === 1) {
	            this._front = null;
	            this._back = null;
	        }
	        else {
	            this._front = node.next;
	            node.next = null;
	        }
	        this._length--;
	        return node.value;
	    };
	    /**
	     * Remove all values from the queue.
	     *
	     * #### Complexity
	     * Linear.
	     *
	     * #### Iterator Validity
	     * All current iterators are invalidated.
	     */
	    Queue.prototype.clear = function () {
	        var node = this._front;
	        while (node) {
	            var next = node.next;
	            node.next = null;
	            node = next;
	        }
	        this._length = 0;
	        this._front = null;
	        this._back = null;
	    };
	    /**
	     * Swap the contents of the queue with the contents of another.
	     *
	     * @param other - The other queue holding the contents to swap.
	     *
	     * #### Complexity
	     * Constant.
	     *
	     * #### Iterator Validity
	     * All current iterators remain valid, but will now point to the
	     * contents of the other queue involved in the swap.
	     */
	    Queue.prototype.swap = function (other) {
	        var length = other._length;
	        var front = other._front;
	        var back = other._back;
	        other._length = this._length;
	        other._front = this._front;
	        other._back = this._back;
	        this._length = length;
	        this._front = front;
	        this._back = back;
	    };
	    return Queue;
	}());
	exports.Queue = Queue;
	/**
	 * An iterator for a queue.
	 */
	var QueueIterator = (function () {
	    /**
	     * Construct a new queue iterator.
	     *
	     * @param node - The node at the front of range.
	     */
	    function QueueIterator(node) {
	        this._node = node;
	    }
	    /**
	     * Create an iterator over the object's values.
	     *
	     * @returns A reference to `this` iterator.
	     */
	    QueueIterator.prototype.iter = function () {
	        return this;
	    };
	    /**
	     * Create an independent clone of the queue iterator.
	     *
	     * @returns A new iterator starting with the current value.
	     */
	    QueueIterator.prototype.clone = function () {
	        return new QueueIterator(this._node);
	    };
	    /**
	     * Get the next value from the queue.
	     *
	     * @returns The next value from the queue, or `undefined` if the
	     *   iterator is exhausted.
	     */
	    QueueIterator.prototype.next = function () {
	        if (!this._node) {
	            return void 0;
	        }
	        var value = this._node.value;
	        this._node = this._node.next;
	        return value;
	    };
	    return QueueIterator;
	}());
	/**
	 * The node type for a queue.
	 */
	var QueueNode = (function () {
	    /**
	     * Construct a new queue node.
	     *
	     * @param value - The value for the node.
	     */
	    function QueueNode(value) {
	        /**
	         * The next node the queue.
	         */
	        this.next = null;
	        this.value = value;
	    }
	    return QueueNode;
	}());


/***/ },
/* 20 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * A class which attaches a value to an external object.
	 *
	 * #### Notes
	 * Attached properties are used to extend the state of an object with
	 * semantic data from an unrelated class. They also encapsulate value
	 * creation, coercion, and notification.
	 *
	 * Because attached property values are stored in a hash table, which
	 * in turn is stored in a WeakMap keyed on the owner object, there is
	 * non-trivial storage overhead involved in their use. The pattern is
	 * therefore best used for the storage of rare data.
	 */
	var AttachedProperty = (function () {
	    /**
	     * Construct a new attached property.
	     *
	     * @param options - The options for initializing the property.
	     */
	    function AttachedProperty(options) {
	        this._pid = nextPID();
	        this._name = options.name;
	        this._value = options.value;
	        this._create = options.create;
	        this._coerce = options.coerce;
	        this._compare = options.compare;
	        this._changed = options.changed;
	    }
	    Object.defineProperty(AttachedProperty.prototype, "name", {
	        /**
	         * Get the human readable name for the property.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._name;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Get the current value of the property for a given owner.
	     *
	     * @param owner - The property owner of interest.
	     *
	     * @returns The current value of the property.
	     *
	     * #### Notes
	     * If the value has not yet been set, the default value will be
	     * computed and assigned as the current value of the property.
	     */
	    AttachedProperty.prototype.get = function (owner) {
	        var value;
	        var map = ensureMap(owner);
	        if (this._pid in map) {
	            value = map[this._pid];
	        }
	        else {
	            value = map[this._pid] = this._createValue(owner);
	        }
	        return value;
	    };
	    /**
	     * Set the current value of the property for a given owner.
	     *
	     * @param owner - The property owner of interest.
	     *
	     * @param value - The value for the property.
	     *
	     * #### Notes
	     * If the value has not yet been set, the default value will be
	     * computed and used as the previous value for the comparison.
	     */
	    AttachedProperty.prototype.set = function (owner, value) {
	        var oldValue;
	        var map = ensureMap(owner);
	        if (this._pid in map) {
	            oldValue = map[this._pid];
	        }
	        else {
	            oldValue = map[this._pid] = this._createValue(owner);
	        }
	        var newValue = this._coerceValue(owner, value);
	        this._maybeNotify(owner, oldValue, map[this._pid] = newValue);
	    };
	    /**
	     * Explicitly coerce the current property value for a given owner.
	     *
	     * @param owner - The property owner of interest.
	     *
	     * #### Notes
	     * If the value has not yet been set, the default value will be
	     * computed and used as the previous value for the comparison.
	     */
	    AttachedProperty.prototype.coerce = function (owner) {
	        var oldValue;
	        var map = ensureMap(owner);
	        if (this._pid in map) {
	            oldValue = map[this._pid];
	        }
	        else {
	            oldValue = map[this._pid] = this._createValue(owner);
	        }
	        var newValue = this._coerceValue(owner, oldValue);
	        this._maybeNotify(owner, oldValue, map[this._pid] = newValue);
	    };
	    /**
	     * Get or create the default value for the given owner.
	     */
	    AttachedProperty.prototype._createValue = function (owner) {
	        var create = this._create;
	        return create ? create(owner) : this._value;
	    };
	    /**
	     * Coerce the value for the given owner.
	     */
	    AttachedProperty.prototype._coerceValue = function (owner, value) {
	        var coerce = this._coerce;
	        return coerce ? coerce(owner, value) : value;
	    };
	    /**
	     * Compare the old value and new value for equality.
	     */
	    AttachedProperty.prototype._compareValue = function (oldValue, newValue) {
	        var compare = this._compare;
	        return compare ? compare(oldValue, newValue) : oldValue === newValue;
	    };
	    /**
	     * Run the change notification if the given values are different.
	     */
	    AttachedProperty.prototype._maybeNotify = function (owner, oldValue, newValue) {
	        if (!this._changed || this._compareValue(oldValue, newValue)) {
	            return;
	        }
	        this._changed.call(void 0, owner, oldValue, newValue);
	    };
	    return AttachedProperty;
	}());
	exports.AttachedProperty = AttachedProperty;
	/**
	 * Clear the stored property data for the given property owner.
	 *
	 * @param owner - The property owner of interest.
	 *
	 * #### Notes
	 * This will clear all property values for the owner, but it will
	 * **not** run the change notification for any of the properties.
	 */
	function clearPropertyData(owner) {
	    ownerData.delete(owner);
	}
	exports.clearPropertyData = clearPropertyData;
	/**
	 * A weak mapping of property owner to property map.
	 */
	var ownerData = new WeakMap();
	/**
	 * A function which computes successive unique property ids.
	 */
	var nextPID = (function () {
	    var id = 0;
	    return function () {
	        var rand = Math.random();
	        var stem = ("" + rand).slice(2);
	        return "pid-" + stem + "-" + id++;
	    };
	})();
	/**
	 * Lookup the data map for the property owner.
	 *
	 * This will create the map if one does not already exist.
	 */
	function ensureMap(owner) {
	    var map = ownerData.get(owner);
	    if (map !== void 0)
	        return map;
	    map = Object.create(null);
	    ownerData.set(owner, map);
	    return map;
	}


/***/ },
/* 21 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var signaling_1 = __webpack_require__(6);
	/**
	 * An object which holds data related to a widget's title.
	 *
	 * #### Notes
	 * A title object is intended to hold the data necessary to display a
	 * header for a particular widget. A common example is the `TabPanel`,
	 * which uses the widget title to populate the tab for a child widget.
	 */
	var Title = (function () {
	    /**
	     * Construct a new title.
	     *
	     * @param options - The options for initializing the title.
	     */
	    function Title(options) {
	        if (options === void 0) { options = {}; }
	        this._label = '';
	        this._icon = '';
	        this._caption = '';
	        this._mnemonic = -1;
	        this._className = '';
	        this._closable = false;
	        this._owner = null;
	        if (options.owner !== void 0) {
	            this._owner = options.owner;
	        }
	        if (options.label !== void 0) {
	            this._label = options.label;
	        }
	        if (options.mnemonic !== void 0) {
	            this._mnemonic = options.mnemonic;
	        }
	        if (options.icon !== void 0) {
	            this._icon = options.icon;
	        }
	        if (options.caption !== void 0) {
	            this._caption = options.caption;
	        }
	        if (options.closable !== void 0) {
	            this._closable = options.closable;
	        }
	        if (options.className !== void 0) {
	            this._className = options.className;
	        }
	    }
	    Object.defineProperty(Title.prototype, "owner", {
	        /**
	         * Get the object which owns the title.
	         *
	         * #### Notes
	         * This will be `null` if the title has no owner.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._owner;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Title.prototype, "label", {
	        /**
	         * Get the label for the title.
	         *
	         * #### Notes
	         * The default value is an empty string.
	         */
	        get: function () {
	            return this._label;
	        },
	        /**
	         * Set the label for the title.
	         */
	        set: function (value) {
	            if (this._label === value) {
	                return;
	            }
	            this._label = value;
	            this.changed.emit(void 0);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Title.prototype, "mnemonic", {
	        /**
	         * Get the mnemonic index for the title.
	         *
	         * #### Notes
	         * The default value is `-1`.
	         */
	        get: function () {
	            return this._mnemonic;
	        },
	        /**
	         * Set the mnemonic index for the title.
	         */
	        set: function (value) {
	            if (this._mnemonic === value) {
	                return;
	            }
	            this._mnemonic = value;
	            this.changed.emit(void 0);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Title.prototype, "icon", {
	        /**
	         * Get the icon class name for the title.
	         *
	         * #### Notes
	         * The default value is an empty string.
	         */
	        get: function () {
	            return this._icon;
	        },
	        /**
	         * Set the icon class name for the title.
	         *
	         * #### Notes
	         * Multiple class names can be separated with whitespace.
	         */
	        set: function (value) {
	            if (this._icon === value) {
	                return;
	            }
	            this._icon = value;
	            this.changed.emit(void 0);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Title.prototype, "caption", {
	        /**
	         * Get the caption for the title.
	         *
	         * #### Notes
	         * The default value is an empty string.
	         */
	        get: function () {
	            return this._caption;
	        },
	        /**
	         * Set the caption for the title.
	         */
	        set: function (value) {
	            if (this._caption === value) {
	                return;
	            }
	            this._caption = value;
	            this.changed.emit(void 0);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Title.prototype, "className", {
	        /**
	         * Get the extra class name for the title.
	         *
	         * #### Notes
	         * The default value is an empty string.
	         */
	        get: function () {
	            return this._className;
	        },
	        /**
	         * Set the extra class name for the title.
	         *
	         * #### Notes
	         * Multiple class names can be separated with whitespace.
	         */
	        set: function (value) {
	            if (this._className === value) {
	                return;
	            }
	            this._className = value;
	            this.changed.emit(void 0);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Title.prototype, "closable", {
	        /**
	         * Get the closable state for the title.
	         *
	         * #### Notes
	         * The default value is `false`.
	         */
	        get: function () {
	            return this._closable;
	        },
	        /**
	         * Set the closable state for the title.
	         *
	         * #### Notes
	         * This controls the presence of a close icon when applicable.
	         */
	        set: function (value) {
	            if (this._closable === value) {
	                return;
	            }
	            this._closable = value;
	            this.changed.emit(void 0);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return Title;
	}());
	exports.Title = Title;
	// Define the signals for the `Title` class.
	signaling_1.defineSignal(Title.prototype, 'changed');


/***/ },
/* 22 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	var searching_1 = __webpack_require__(11);
	var vector_1 = __webpack_require__(13);
	var boxpanel_1 = __webpack_require__(23);
	var dockpanel_1 = __webpack_require__(28);
	var focustracker_1 = __webpack_require__(33);
	var panel_1 = __webpack_require__(27);
	var splitpanel_1 = __webpack_require__(34);
	var stackedpanel_1 = __webpack_require__(35);
	var tabbar_1 = __webpack_require__(37);
	/**
	 * The class name added to AppShell instances.
	 */
	var APPLICATION_SHELL_CLASS = 'jp-ApplicationShell';
	/**
	 * The class name added to side bar instances.
	 */
	var SIDEBAR_CLASS = 'jp-SideBar';
	/**
	 * The class name added to the current widget's title.
	 */
	var CURRENT_CLASS = 'jp-mod-current';
	/**
	 * The application shell for JupyterLab.
	 */
	var ApplicationShell = (function (_super) {
	    __extends(ApplicationShell, _super);
	    /**
	     * Construct a new application shell.
	     */
	    function ApplicationShell() {
	        _super.call(this);
	        this.addClass(APPLICATION_SHELL_CLASS);
	        this.id = 'main';
	        var topPanel = this._topPanel = new panel_1.Panel();
	        var hboxPanel = this._hboxPanel = new boxpanel_1.BoxPanel();
	        var dockPanel = this._dockPanel = new dockpanel_1.DockPanel();
	        var hsplitPanel = this._hsplitPanel = new splitpanel_1.SplitPanel();
	        var leftHandler = this._leftHandler = new SideBarHandler('left');
	        var rightHandler = this._rightHandler = new SideBarHandler('right');
	        topPanel.id = 'jp-top-panel';
	        hboxPanel.id = 'jp-main-content-panel';
	        dockPanel.id = 'jp-main-dock-panel';
	        hsplitPanel.id = 'jp-main-split-panel';
	        leftHandler.sideBar.addClass(SIDEBAR_CLASS);
	        leftHandler.sideBar.addClass('jp-mod-left');
	        leftHandler.stackedPanel.id = 'jp-left-stack';
	        rightHandler.sideBar.addClass(SIDEBAR_CLASS);
	        rightHandler.sideBar.addClass('jp-mod-right');
	        rightHandler.stackedPanel.id = 'jp-right-stack';
	        hboxPanel.spacing = 0;
	        dockPanel.spacing = 8;
	        hsplitPanel.spacing = 1;
	        hboxPanel.direction = 'left-to-right';
	        hsplitPanel.orientation = 'horizontal';
	        splitpanel_1.SplitPanel.setStretch(leftHandler.stackedPanel, 0);
	        splitpanel_1.SplitPanel.setStretch(dockPanel, 1);
	        splitpanel_1.SplitPanel.setStretch(rightHandler.stackedPanel, 0);
	        boxpanel_1.BoxPanel.setStretch(leftHandler.sideBar, 0);
	        boxpanel_1.BoxPanel.setStretch(hsplitPanel, 1);
	        boxpanel_1.BoxPanel.setStretch(rightHandler.sideBar, 0);
	        hsplitPanel.addWidget(leftHandler.stackedPanel);
	        hsplitPanel.addWidget(dockPanel);
	        hsplitPanel.addWidget(rightHandler.stackedPanel);
	        hboxPanel.addWidget(leftHandler.sideBar);
	        hboxPanel.addWidget(hsplitPanel);
	        hboxPanel.addWidget(rightHandler.sideBar);
	        this.addWidget(topPanel);
	        this.addWidget(hboxPanel);
	        this._tracker = new focustracker_1.FocusTracker();
	        this._tracker.currentChanged.connect(function (sender, args) {
	            if (args.newValue) {
	                args.newValue.title.className += " " + CURRENT_CLASS;
	            }
	            if (args.oldValue) {
	                args.oldValue.deactivate();
	                var title = args.oldValue.title;
	                title.className = title.className.replace(CURRENT_CLASS, '');
	            }
	        });
	    }
	    /**
	     * Add a widget to the top content area.
	     */
	    ApplicationShell.prototype.addToTopArea = function (widget, options) {
	        if (options === void 0) { options = {}; }
	        if (!widget.id) {
	            console.error('widgets added to app shell must have unique id property');
	            return;
	        }
	        // Temporary: widgets are added to the panel in order of insertion.
	        this._topPanel.addWidget(widget);
	    };
	    /**
	     * Add a widget to the left content area.
	     */
	    ApplicationShell.prototype.addToLeftArea = function (widget, options) {
	        if (options === void 0) { options = {}; }
	        if (!widget.id) {
	            console.error('widgets added to app shell must have unique id property');
	            return;
	        }
	        var rank = 'rank' in options ? options.rank : 100;
	        this._leftHandler.addWidget(widget, rank);
	    };
	    /**
	     * Add a widget to the right content area.
	     */
	    ApplicationShell.prototype.addToRightArea = function (widget, options) {
	        if (options === void 0) { options = {}; }
	        if (!widget.id) {
	            console.error('widgets added to app shell must have unique id property');
	            return;
	        }
	        var rank = 'rank' in options ? options.rank : 100;
	        this._rightHandler.addWidget(widget, rank);
	    };
	    /**
	     * Add a widget to the main content area.
	     */
	    ApplicationShell.prototype.addToMainArea = function (widget) {
	        // TODO
	        if (!widget.id) {
	            console.error('widgets added to app shell must have unique id property');
	            return;
	        }
	        this._dockPanel.addWidget(widget, { mode: 'tab-after' });
	        this._tracker.add(widget);
	    };
	    /**
	     * Activate a widget in the left area.
	     */
	    ApplicationShell.prototype.activateLeft = function (id) {
	        this._leftHandler.activate(id);
	    };
	    /**
	     * Activate a widget in the right area.
	     */
	    ApplicationShell.prototype.activateRight = function (id) {
	        this._rightHandler.activate(id);
	    };
	    /**
	     * Activate a widget in the main area.
	     */
	    ApplicationShell.prototype.activateMain = function (id) {
	        var dock = this._dockPanel;
	        var widget = searching_1.find(dock.widgets, function (value) { return value.id === id; });
	        if (widget) {
	            dock.activateWidget(widget);
	        }
	    };
	    /**
	     * Collapse the left area.
	     */
	    ApplicationShell.prototype.collapseLeft = function () {
	        this._leftHandler.collapse();
	    };
	    /**
	     * Collapse the right area.
	     */
	    ApplicationShell.prototype.collapseRight = function () {
	        this._rightHandler.collapse();
	    };
	    return ApplicationShell;
	}(panel_1.Panel));
	exports.ApplicationShell = ApplicationShell;
	/**
	 * A class which manages a side bar and related stacked panel.
	 */
	var SideBarHandler = (function () {
	    /**
	     * Construct a new side bar handler.
	     */
	    function SideBarHandler(side) {
	        this._items = new vector_1.Vector();
	        this._side = side;
	        this._sideBar = new tabbar_1.TabBar({
	            insertBehavior: 'none',
	            removeBehavior: 'none',
	            allowDeselect: true
	        });
	        this._stackedPanel = new stackedpanel_1.StackedPanel();
	        this._sideBar.hide();
	        this._stackedPanel.hide();
	        this._sideBar.currentChanged.connect(this._onCurrentChanged, this);
	        this._stackedPanel.widgetRemoved.connect(this._onWidgetRemoved, this);
	    }
	    Object.defineProperty(SideBarHandler.prototype, "sideBar", {
	        /**
	         * Get the tab bar managed by the handler.
	         */
	        get: function () {
	            return this._sideBar;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SideBarHandler.prototype, "stackedPanel", {
	        /**
	         * Get the stacked panel managed by the handler
	         */
	        get: function () {
	            return this._stackedPanel;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Activate a widget residing in the side bar by ID.
	     *
	     * @param id - The widget's unique ID.
	     */
	    SideBarHandler.prototype.activate = function (id) {
	        var widget = this._findWidgetByID(id);
	        if (widget) {
	            this._sideBar.currentTitle = widget.title;
	        }
	    };
	    /**
	     * Collapse the sidebar so no items are expanded.
	     */
	    SideBarHandler.prototype.collapse = function () {
	        this._sideBar.currentTitle = null;
	    };
	    /**
	     * Add a widget and its title to the stacked panel and side bar.
	     *
	     * If the widget is already added, it will be moved.
	     */
	    SideBarHandler.prototype.addWidget = function (widget, rank) {
	        widget.parent = null;
	        widget.hide();
	        var item = { widget: widget, rank: rank };
	        var index = this._findInsertIndex(item);
	        this._items.insert(index, item);
	        this._stackedPanel.insertWidget(index, widget);
	        this._sideBar.insertTab(index, widget.title);
	        this._refreshVisibility();
	    };
	    /**
	     * Find the insertion index for a rank item.
	     */
	    SideBarHandler.prototype._findInsertIndex = function (item) {
	        return searching_1.upperBound(this._items, item, Private.itemCmp);
	    };
	    /**
	     * Find the index of the item with the given widget, or `-1`.
	     */
	    SideBarHandler.prototype._findWidgetIndex = function (widget) {
	        return searching_1.findIndex(this._items, function (item) { return item.widget === widget; });
	    };
	    /**
	     * Find the widget which owns the given title, or `null`.
	     */
	    SideBarHandler.prototype._findWidgetByTitle = function (title) {
	        var item = searching_1.find(this._items, function (value) { return value.widget.title === title; });
	        return item ? item.widget : null;
	    };
	    /**
	     * Find the widget with the given id, or `null`.
	     */
	    SideBarHandler.prototype._findWidgetByID = function (id) {
	        var item = searching_1.find(this._items, function (value) { return value.widget.id === id; });
	        return item ? item.widget : null;
	    };
	    /**
	     * Refresh the visibility of the side bar and stacked panel.
	     */
	    SideBarHandler.prototype._refreshVisibility = function () {
	        this._sideBar.setHidden(this._sideBar.titles.length === 0);
	        this._stackedPanel.setHidden(this._sideBar.currentTitle === null);
	    };
	    /**
	     * Handle the `currentChanged` signal from the sidebar.
	     */
	    SideBarHandler.prototype._onCurrentChanged = function (sender, args) {
	        var oldWidget = this._findWidgetByTitle(args.previousTitle);
	        var newWidget = this._findWidgetByTitle(args.currentTitle);
	        if (oldWidget) {
	            oldWidget.hide();
	        }
	        if (newWidget) {
	            newWidget.show();
	        }
	        if (newWidget) {
	            document.body.dataset[(this._side + "Area")] = newWidget.id;
	        }
	        else {
	            delete document.body.dataset[(this._side + "Area")];
	        }
	        this._refreshVisibility();
	    };
	    /*
	     * Handle the `widgetRemoved` signal from the stacked panel.
	     */
	    SideBarHandler.prototype._onWidgetRemoved = function (sender, widget) {
	        this._items.removeAt(this._findWidgetIndex(widget));
	        this._sideBar.removeTab(widget.title);
	        this._refreshVisibility();
	    };
	    return SideBarHandler;
	}());
	var Private;
	(function (Private) {
	    /**
	     * A less-than comparison function for side bar rank items.
	     */
	    function itemCmp(first, second) {
	        return first.rank - second.rank;
	    }
	    Private.itemCmp = itemCmp;
	})(Private || (Private = {}));


/***/ },
/* 23 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var mutation_1 = __webpack_require__(24);
	var vector_1 = __webpack_require__(13);
	var messaging_1 = __webpack_require__(18);
	var properties_1 = __webpack_require__(20);
	var platform_1 = __webpack_require__(14);
	var sizing_1 = __webpack_require__(25);
	var boxengine_1 = __webpack_require__(26);
	var panel_1 = __webpack_require__(27);
	var widget_1 = __webpack_require__(17);
	/**
	 * The class name added to BoxPanel instances.
	 */
	var BOX_PANEL_CLASS = 'p-BoxPanel';
	/**
	 * The class name added to a BoxPanel child.
	 */
	var CHILD_CLASS = 'p-BoxPanel-child';
	/**
	 * The class name added to left-to-right box layout parents.
	 */
	var LEFT_TO_RIGHT_CLASS = 'p-mod-left-to-right';
	/**
	 * The class name added to right-to-left box layout parents.
	 */
	var RIGHT_TO_LEFT_CLASS = 'p-mod-right-to-left';
	/**
	 * The class name added to top-to-bottom box layout parents.
	 */
	var TOP_TO_BOTTOM_CLASS = 'p-mod-top-to-bottom';
	/**
	 * The class name added to bottom-to-top box layout parents.
	 */
	var BOTTOM_TO_TOP_CLASS = 'p-mod-bottom-to-top';
	/**
	 * A panel which arranges its widgets in a single row or column.
	 *
	 * #### Notes
	 * This class provides a convenience wrapper around a [[BoxLayout]].
	 */
	var BoxPanel = (function (_super) {
	    __extends(BoxPanel, _super);
	    /**
	     * Construct a new box panel.
	     *
	     * @param options - The options for initializing the box panel.
	     */
	    function BoxPanel(options) {
	        if (options === void 0) { options = {}; }
	        _super.call(this, { layout: Private.createLayout(options) });
	        this.addClass(BOX_PANEL_CLASS);
	    }
	    Object.defineProperty(BoxPanel.prototype, "direction", {
	        /**
	         * Get the layout direction for the box panel.
	         */
	        get: function () {
	            return this.layout.direction;
	        },
	        /**
	         * Set the layout direction for the box panel.
	         */
	        set: function (value) {
	            this.layout.direction = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(BoxPanel.prototype, "spacing", {
	        /**
	         * Get the inter-element spacing for the box panel.
	         */
	        get: function () {
	            return this.layout.spacing;
	        },
	        /**
	         * Set the inter-element spacing for the box panel.
	         */
	        set: function (value) {
	            this.layout.spacing = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * A message handler invoked on a `'child-added'` message.
	     */
	    BoxPanel.prototype.onChildAdded = function (msg) {
	        msg.child.addClass(CHILD_CLASS);
	    };
	    /**
	     * A message handler invoked on a `'child-removed'` message.
	     */
	    BoxPanel.prototype.onChildRemoved = function (msg) {
	        msg.child.removeClass(CHILD_CLASS);
	    };
	    return BoxPanel;
	}(panel_1.Panel));
	exports.BoxPanel = BoxPanel;
	/**
	 * The namespace for the `BoxPanel` class statics.
	 */
	var BoxPanel;
	(function (BoxPanel) {
	    /**
	     * Get the box panel stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns The box panel stretch factor for the widget.
	     */
	    function getStretch(widget) {
	        return BoxLayout.getStretch(widget);
	    }
	    BoxPanel.getStretch = getStretch;
	    /**
	     * Set the box panel stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @param value - The value for the stretch factor.
	     */
	    function setStretch(widget, value) {
	        BoxLayout.setStretch(widget, value);
	    }
	    BoxPanel.setStretch = setStretch;
	    /**
	     * Get the box panel size basis for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns The box panel size basis for the widget.
	     */
	    function getSizeBasis(widget) {
	        return BoxLayout.getSizeBasis(widget);
	    }
	    BoxPanel.getSizeBasis = getSizeBasis;
	    /**
	     * Set the box panel size basis for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @param value - The value for the size basis.
	     */
	    function setSizeBasis(widget, value) {
	        BoxLayout.setSizeBasis(widget, value);
	    }
	    BoxPanel.setSizeBasis = setSizeBasis;
	})(BoxPanel = exports.BoxPanel || (exports.BoxPanel = {}));
	/**
	 * A layout which arranges its widgets in a single row or column.
	 */
	var BoxLayout = (function (_super) {
	    __extends(BoxLayout, _super);
	    /**
	     * Construct a new box layout.
	     *
	     * @param options - The options for initializing the layout.
	     */
	    function BoxLayout(options) {
	        if (options === void 0) { options = {}; }
	        _super.call(this);
	        this._fixed = 0;
	        this._spacing = 4;
	        this._dirty = false;
	        this._box = null;
	        this._sizers = new vector_1.Vector();
	        this._direction = 'top-to-bottom';
	        if (options.direction !== void 0) {
	            this._direction = options.direction;
	        }
	        if (options.spacing !== void 0) {
	            this._spacing = Private.clampSpacing(options.spacing);
	        }
	    }
	    Object.defineProperty(BoxLayout.prototype, "direction", {
	        /**
	         * Get the layout direction for the box layout.
	         */
	        get: function () {
	            return this._direction;
	        },
	        /**
	         * Set the layout direction for the box layout.
	         */
	        set: function (value) {
	            if (this._direction === value) {
	                return;
	            }
	            this._direction = value;
	            if (!this.parent) {
	                return;
	            }
	            Private.toggleDirection(this.parent, value);
	            this.parent.fit();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(BoxLayout.prototype, "spacing", {
	        /**
	         * Get the inter-element spacing for the box layout.
	         */
	        get: function () {
	            return this._spacing;
	        },
	        /**
	         * Set the inter-element spacing for the box layout.
	         */
	        set: function (value) {
	            value = Private.clampSpacing(value);
	            if (this._spacing === value) {
	                return;
	            }
	            this._spacing = value;
	            if (!this.parent) {
	                return;
	            }
	            this.parent.fit();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Attach a widget to the parent's DOM node.
	     *
	     * @param index - The current index of the widget in the layout.
	     *
	     * @param widget - The widget to attach to the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    BoxLayout.prototype.attachWidget = function (index, widget) {
	        // Create and add a new sizer for the widget.
	        this._sizers.insert(index, new boxengine_1.BoxSizer());
	        // Prepare the layout geometry for the widget.
	        widget_1.Widget.prepareGeometry(widget);
	        // Add the widget's node to the parent.
	        this.parent.node.appendChild(widget.node);
	        // Send an `'after-attach'` message if the parent is attached.
	        if (this.parent.isAttached)
	            messaging_1.sendMessage(widget, widget_1.WidgetMessage.AfterAttach);
	        // Post a layout request for the parent widget.
	        this.parent.fit();
	    };
	    /**
	     * Move a widget in the parent's DOM node.
	     *
	     * @param fromIndex - The previous index of the widget in the layout.
	     *
	     * @param toIndex - The current index of the widget in the layout.
	     *
	     * @param widget - The widget to move in the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    BoxLayout.prototype.moveWidget = function (fromIndex, toIndex, widget) {
	        // Move the sizer for the widget.
	        mutation_1.move(this._sizers, fromIndex, toIndex);
	        // Post an update request for the parent widget.
	        this.parent.update();
	    };
	    /**
	     * Detach a widget from the parent's DOM node.
	     *
	     * @param index - The previous index of the widget in the layout.
	     *
	     * @param widget - The widget to detach from the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    BoxLayout.prototype.detachWidget = function (index, widget) {
	        // Remove the sizer for the widget.
	        this._sizers.removeAt(index);
	        // Send a `'before-detach'` message if the parent is attached.
	        if (this.parent.isAttached)
	            messaging_1.sendMessage(widget, widget_1.WidgetMessage.BeforeDetach);
	        // Remove the widget's node from the parent.
	        this.parent.node.removeChild(widget.node);
	        // Reset the layout geometry for the widget.
	        widget_1.Widget.resetGeometry(widget);
	        // Post a layout request for the parent widget.
	        this.parent.fit();
	    };
	    /**
	     * A message handler invoked on a `'layout-changed'` message.
	     *
	     * #### Notes
	     * This is called when the layout is installed on its parent.
	     */
	    BoxLayout.prototype.onLayoutChanged = function (msg) {
	        Private.toggleDirection(this.parent, this.direction);
	        _super.prototype.onLayoutChanged.call(this, msg);
	    };
	    /**
	     * A message handler invoked on an `'after-show'` message.
	     */
	    BoxLayout.prototype.onAfterShow = function (msg) {
	        _super.prototype.onAfterShow.call(this, msg);
	        this.parent.update();
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     */
	    BoxLayout.prototype.onAfterAttach = function (msg) {
	        _super.prototype.onAfterAttach.call(this, msg);
	        this.parent.fit();
	    };
	    /**
	     * A message handler invoked on a `'child-shown'` message.
	     */
	    BoxLayout.prototype.onChildShown = function (msg) {
	        if (platform_1.IS_IE) {
	            messaging_1.sendMessage(this.parent, widget_1.WidgetMessage.FitRequest);
	        }
	        else {
	            this.parent.fit();
	        }
	    };
	    /**
	     * A message handler invoked on a `'child-hidden'` message.
	     */
	    BoxLayout.prototype.onChildHidden = function (msg) {
	        if (platform_1.IS_IE) {
	            messaging_1.sendMessage(this.parent, widget_1.WidgetMessage.FitRequest);
	        }
	        else {
	            this.parent.fit();
	        }
	    };
	    /**
	     * A message handler invoked on a `'resize'` message.
	     */
	    BoxLayout.prototype.onResize = function (msg) {
	        if (this.parent.isVisible) {
	            this._update(msg.width, msg.height);
	        }
	    };
	    /**
	     * A message handler invoked on an `'update-request'` message.
	     */
	    BoxLayout.prototype.onUpdateRequest = function (msg) {
	        if (this.parent.isVisible) {
	            this._update(-1, -1);
	        }
	    };
	    /**
	     * A message handler invoked on a `'fit-request'` message.
	     */
	    BoxLayout.prototype.onFitRequest = function (msg) {
	        if (this.parent.isAttached) {
	            this._fit();
	        }
	    };
	    /**
	     * Fit the layout to the total size required by the widgets.
	     */
	    BoxLayout.prototype._fit = function () {
	        // Compute the visible item count.
	        var nVisible = 0;
	        var widgets = this.widgets;
	        for (var i = 0, n = widgets.length; i < n; ++i) {
	            if (!widgets.at(i).isHidden)
	                nVisible++;
	        }
	        // Update the fixed space for the visible items.
	        this._fixed = this._spacing * Math.max(0, nVisible - 1);
	        // Setup the initial size limits.
	        var minW = 0;
	        var minH = 0;
	        var maxW = Infinity;
	        var maxH = Infinity;
	        var horz = Private.isHorizontal(this._direction);
	        if (horz) {
	            minW = this._fixed;
	            maxW = nVisible > 0 ? minW : maxW;
	        }
	        else {
	            minH = this._fixed;
	            maxH = nVisible > 0 ? minH : maxH;
	        }
	        // Update the sizers and computed size limits.
	        for (var i = 0, n = widgets.length; i < n; ++i) {
	            var widget = widgets.at(i);
	            var sizer = this._sizers.at(i);
	            if (widget.isHidden) {
	                sizer.minSize = 0;
	                sizer.maxSize = 0;
	                continue;
	            }
	            var limits = sizing_1.sizeLimits(widget.node);
	            sizer.sizeHint = BoxLayout.getSizeBasis(widget);
	            sizer.stretch = BoxLayout.getStretch(widget);
	            if (horz) {
	                sizer.minSize = limits.minWidth;
	                sizer.maxSize = limits.maxWidth;
	                minW += limits.minWidth;
	                maxW += limits.maxWidth;
	                minH = Math.max(minH, limits.minHeight);
	                maxH = Math.min(maxH, limits.maxHeight);
	            }
	            else {
	                sizer.minSize = limits.minHeight;
	                sizer.maxSize = limits.maxHeight;
	                minH += limits.minHeight;
	                maxH += limits.maxHeight;
	                minW = Math.max(minW, limits.minWidth);
	                maxW = Math.min(maxW, limits.maxWidth);
	            }
	        }
	        // Update the box sizing and add it to the size constraints.
	        var box = this._box = sizing_1.boxSizing(this.parent.node);
	        minW += box.horizontalSum;
	        minH += box.verticalSum;
	        maxW += box.horizontalSum;
	        maxH += box.verticalSum;
	        // Update the parent's size constraints.
	        var style = this.parent.node.style;
	        style.minWidth = minW + "px";
	        style.minHeight = minH + "px";
	        style.maxWidth = maxW === Infinity ? 'none' : maxW + "px";
	        style.maxHeight = maxH === Infinity ? 'none' : maxH + "px";
	        // Set the dirty flag to ensure only a single update occurs.
	        this._dirty = true;
	        // Notify the ancestor that it should fit immediately. This may
	        // cause a resize of the parent, fulfilling the required update.
	        var ancestor = this.parent.parent;
	        if (ancestor)
	            messaging_1.sendMessage(ancestor, widget_1.WidgetMessage.FitRequest);
	        // If the dirty flag is still set, the parent was not resized.
	        // Trigger the required update on the parent widget immediately.
	        if (this._dirty)
	            messaging_1.sendMessage(this.parent, widget_1.WidgetMessage.UpdateRequest);
	    };
	    /**
	     * Update the layout position and size of the widgets.
	     *
	     * The parent offset dimensions should be `-1` if unknown.
	     */
	    BoxLayout.prototype._update = function (offsetWidth, offsetHeight) {
	        // Clear the dirty flag to indicate the update occurred.
	        this._dirty = false;
	        // Bail early if there are no widgets to layout.
	        var widgets = this.widgets;
	        if (widgets.length === 0) {
	            return;
	        }
	        // Measure the parent if the offset dimensions are unknown.
	        if (offsetWidth < 0) {
	            offsetWidth = this.parent.node.offsetWidth;
	        }
	        if (offsetHeight < 0) {
	            offsetHeight = this.parent.node.offsetHeight;
	        }
	        // Ensure the parent box sizing data is computed.
	        var box = this._box || (this._box = sizing_1.boxSizing(this.parent.node));
	        // Compute the layout area adjusted for border and padding.
	        var top = box.paddingTop;
	        var left = box.paddingLeft;
	        var width = offsetWidth - box.horizontalSum;
	        var height = offsetHeight - box.verticalSum;
	        // Distribute the layout space and adjust the start position.
	        switch (this._direction) {
	            case 'left-to-right':
	                boxengine_1.boxCalc(this._sizers, Math.max(0, width - this._fixed));
	                break;
	            case 'top-to-bottom':
	                boxengine_1.boxCalc(this._sizers, Math.max(0, height - this._fixed));
	                break;
	            case 'right-to-left':
	                boxengine_1.boxCalc(this._sizers, Math.max(0, width - this._fixed));
	                left += width;
	                break;
	            case 'bottom-to-top':
	                boxengine_1.boxCalc(this._sizers, Math.max(0, height - this._fixed));
	                top += height;
	                break;
	        }
	        // Layout the widgets using the computed box sizes.
	        for (var i = 0, n = widgets.length; i < n; ++i) {
	            var widget = widgets.at(i);
	            if (widget.isHidden) {
	                continue;
	            }
	            var size = this._sizers.at(i).size;
	            switch (this._direction) {
	                case 'left-to-right':
	                    widget_1.Widget.setGeometry(widget, left, top, size, height);
	                    left += size + this._spacing;
	                    break;
	                case 'top-to-bottom':
	                    widget_1.Widget.setGeometry(widget, left, top, width, size);
	                    top += size + this._spacing;
	                    break;
	                case 'right-to-left':
	                    widget_1.Widget.setGeometry(widget, left - size, top, size, height);
	                    left -= size + this._spacing;
	                    break;
	                case 'bottom-to-top':
	                    widget_1.Widget.setGeometry(widget, left, top - size, width, size);
	                    top -= size + this._spacing;
	                    break;
	            }
	        }
	    };
	    return BoxLayout;
	}(panel_1.PanelLayout));
	exports.BoxLayout = BoxLayout;
	/**
	 * The namespace for the `BoxLayout` class statics.
	 */
	var BoxLayout;
	(function (BoxLayout) {
	    /**
	     * Get the box layout stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns The box layout stretch factor for the widget.
	     */
	    function getStretch(widget) {
	        return Private.stretchProperty.get(widget);
	    }
	    BoxLayout.getStretch = getStretch;
	    /**
	     * Set the box layout stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @param value - The value for the stretch factor.
	     */
	    function setStretch(widget, value) {
	        Private.stretchProperty.set(widget, value);
	    }
	    BoxLayout.setStretch = setStretch;
	    /**
	     * Get the box layout size basis for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns The box layout size basis for the widget.
	     */
	    function getSizeBasis(widget) {
	        return Private.sizeBasisProperty.get(widget);
	    }
	    BoxLayout.getSizeBasis = getSizeBasis;
	    /**
	     * Set the box layout size basis for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @param value - The value for the size basis.
	     */
	    function setSizeBasis(widget, value) {
	        Private.sizeBasisProperty.set(widget, value);
	    }
	    BoxLayout.setSizeBasis = setSizeBasis;
	})(BoxLayout = exports.BoxLayout || (exports.BoxLayout = {}));
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * The property descriptor for a widget stretch factor.
	     */
	    Private.stretchProperty = new properties_1.AttachedProperty({
	        name: 'stretch',
	        value: 0,
	        coerce: function (owner, value) { return Math.max(0, Math.floor(value)); },
	        changed: onChildPropertyChanged
	    });
	    /**
	     * The property descriptor for a widget size basis.
	     */
	    Private.sizeBasisProperty = new properties_1.AttachedProperty({
	        name: 'sizeBasis',
	        value: 0,
	        coerce: function (owner, value) { return Math.max(0, Math.floor(value)); },
	        changed: onChildPropertyChanged
	    });
	    /**
	     * Create a box layout for the given panel options.
	     */
	    function createLayout(options) {
	        return options.layout || new BoxLayout(options);
	    }
	    Private.createLayout = createLayout;
	    /**
	     * Test whether a direction has horizontal orientation.
	     */
	    function isHorizontal(dir) {
	        return dir === 'left-to-right' || dir === 'right-to-left';
	    }
	    Private.isHorizontal = isHorizontal;
	    /**
	     * Toggle the CSS direction class for the given widget.
	     */
	    function toggleDirection(widget, dir) {
	        widget.toggleClass(LEFT_TO_RIGHT_CLASS, dir === 'left-to-right');
	        widget.toggleClass(RIGHT_TO_LEFT_CLASS, dir === 'right-to-left');
	        widget.toggleClass(TOP_TO_BOTTOM_CLASS, dir === 'top-to-bottom');
	        widget.toggleClass(BOTTOM_TO_TOP_CLASS, dir === 'bottom-to-top');
	    }
	    Private.toggleDirection = toggleDirection;
	    /**
	     * Clamp a spacing value to an integer >= 0.
	     */
	    function clampSpacing(value) {
	        return Math.max(0, Math.floor(value));
	    }
	    Private.clampSpacing = clampSpacing;
	    /**
	     * The change handler for the attached child properties.
	     */
	    function onChildPropertyChanged(child) {
	        var parent = child.parent;
	        var layout = parent && parent.layout;
	        if (layout instanceof BoxLayout)
	            parent.fit();
	    }
	})(Private || (Private = {}));


/***/ },
/* 24 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var sequence_1 = __webpack_require__(12);
	/**
	 * Move an element in a sequence from one index to another.
	 *
	 * @param object - The sequence or array-like object to mutate.
	 *
	 * @param fromIndex - The index of the element to move.
	 *
	 * @param toIndex - The target index of the element.
	 *
	 * #### Complexity
	 * Linear.
	 *
	 * #### Undefined Behavior
	 * A `fromIndex` which is non-integral or out of range.
	 *
	 * A `toIndex` which is non-integral or out of range.
	 *
	 * #### Example
	 * ```typescript
	 * import { move } from 'phosphor/lib/algorithm/mutation';
	 *
	 * let data = [0, 1, 2, 3, 4];
	 * move(data, 1, 2);  // [0, 2, 1, 3, 4]
	 * move(data, 4, 2);  // [0, 2, 4, 1, 3]
	 * ```
	 */
	function move(object, fromIndex, toIndex) {
	    if (object.length <= 1 || fromIndex === toIndex) {
	        return;
	    }
	    var d = fromIndex < toIndex ? 1 : -1;
	    var seq = sequence_1.asMutableSequence(object);
	    var value = seq.at(fromIndex);
	    for (var i = fromIndex; i !== toIndex; i += d) {
	        seq.set(i, seq.at(i + d));
	    }
	    seq.set(toIndex, value);
	}
	exports.move = move;
	/**
	 * Reverse a sequence in-place subject to an optional range.
	 *
	 * @param object - The sequence or array-like object to mutate.
	 *
	 * @param first - The index of the first element of the range. This
	 *   should be `<=` the `last` index. The default is `0`.
	 *
	 * @param last - The index of the last element of the range. This
	 *   should be `>=` the `first` index. The default is `length - 1`.
	 *
	 * #### Complexity
	 * Linear.
	 *
	 * #### Undefined Behavior
	 * A `first` index which is non-integral or out of range.
	 *
	 * A `last` index which is non-integral or out of range.
	 *
	 * #### Example
	 * ```typescript
	 * import { reverse } from 'phosphor/lib/algorithm/mutation';
	 *
	 * let data = [0, 1, 2, 3, 4];
	 * reverse(data, 1, 3);  // [0, 3, 2, 1, 4]
	 * reverse(data, 3);     // [0, 3, 2, 4, 1]
	 * reverse(data);        // [1, 4, 2, 3, 0]
	 * ```
	 */
	function reverse(object, first, last) {
	    var length = object.length;
	    if (length <= 1) {
	        return;
	    }
	    if (first === void 0) {
	        first = 0;
	    }
	    if (last === void 0) {
	        last = length - 1;
	    }
	    if (first >= last) {
	        return;
	    }
	    var seq = sequence_1.asMutableSequence(object);
	    while (first < last) {
	        var front = seq.at(first);
	        var back = seq.at(last);
	        seq.set(first++, back);
	        seq.set(last--, front);
	    }
	}
	exports.reverse = reverse;
	/**
	 * Rotate the elements of a sequence by a positive or negative amount.
	 *
	 * @param object - The sequence or array-like object to mutate.
	 *
	 * @param delta - The amount of rotation to apply to the elements. A
	 *   positive value will rotate the elements to the left. A negative
	 *   value will rotate the elements to the right.
	 *
	 * #### Complexity
	 * Linear.
	 *
	 * #### Undefined Behavior
	 * A `delta` amount which is non-integral.
	 *
	 * #### Example
	 * ```typescript
	 * import { rotate } from 'phosphor/lib/algorithm/mutation';
	 *
	 * let data = [0, 1, 2, 3, 4];
	 * rotate(data, 2);   // [2, 3, 4, 0, 1]
	 * rotate(data, -2);  // [0, 1, 2, 3, 4]
	 * rotate(data, 10);  // [0, 1, 2, 3, 4]
	 * rotate(data, 9);   // [4, 0, 1, 2, 3]
	 * ```
	 */
	function rotate(object, delta) {
	    var length = object.length;
	    if (length <= 1) {
	        return;
	    }
	    if (delta > 0) {
	        delta = delta % length;
	    }
	    else if (delta < 0) {
	        delta = ((delta % length) + length) % length;
	    }
	    if (delta === 0) {
	        return;
	    }
	    var seq = sequence_1.asMutableSequence(object);
	    reverse(seq, 0, delta - 1);
	    reverse(seq, delta, length - 1);
	    reverse(seq, 0, length - 1);
	}
	exports.rotate = rotate;


/***/ },
/* 25 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * Compute the box sizing for a DOM node.
	 *
	 * @param node - The DOM node for which to compute the box sizing.
	 *
	 * @returns The box sizing data for the specified DOM node.
	 *
	 * #### Example
	 * ```typescript
	 * import { boxSizing } from 'phosphor/lib/dom/sizing';
	 *
	 * let div = document.createElement('div');
	 * div.style.borderTop = 'solid 10px black';
	 * document.body.appendChild(div);
	 *
	 * let sizing = boxSizing(div);
	 * sizing.borderTop;    // 10
	 * sizing.paddingLeft;  // 0
	 * // etc...
	 * ```
	 */
	function boxSizing(node) {
	    var cstyle = window.getComputedStyle(node);
	    var bt = parseInt(cstyle.borderTopWidth, 10) || 0;
	    var bl = parseInt(cstyle.borderLeftWidth, 10) || 0;
	    var br = parseInt(cstyle.borderRightWidth, 10) || 0;
	    var bb = parseInt(cstyle.borderBottomWidth, 10) || 0;
	    var pt = parseInt(cstyle.paddingTop, 10) || 0;
	    var pl = parseInt(cstyle.paddingLeft, 10) || 0;
	    var pr = parseInt(cstyle.paddingRight, 10) || 0;
	    var pb = parseInt(cstyle.paddingBottom, 10) || 0;
	    var hs = bl + pl + pr + br;
	    var vs = bt + pt + pb + bb;
	    return {
	        borderTop: bt,
	        borderLeft: bl,
	        borderRight: br,
	        borderBottom: bb,
	        paddingTop: pt,
	        paddingLeft: pl,
	        paddingRight: pr,
	        paddingBottom: pb,
	        horizontalSum: hs,
	        verticalSum: vs
	    };
	}
	exports.boxSizing = boxSizing;
	/**
	 * Compute the size limits for a DOM node.
	 *
	 * @param node - The node for which to compute the size limits.
	 *
	 * @returns The size limit data for the specified DOM node.
	 *
	 * #### Example
	 * ```typescript
	 * import { sizeLimits } from 'phosphor/lib/dom/sizing';
	 *
	 * let div = document.createElement('div');
	 * div.style.minWidth = '90px';
	 * document.body.appendChild(div);
	 *
	 * let limits = sizeLimits(div);
	 * limits.minWidth;   // 90
	 * limits.maxHeight;  // Infinity
	 * // etc...
	 * ```
	 */
	function sizeLimits(node) {
	    var cstyle = window.getComputedStyle(node);
	    return {
	        minWidth: parseInt(cstyle.minWidth, 10) || 0,
	        minHeight: parseInt(cstyle.minHeight, 10) || 0,
	        maxWidth: parseInt(cstyle.maxWidth, 10) || Infinity,
	        maxHeight: parseInt(cstyle.maxHeight, 10) || Infinity
	    };
	}
	exports.sizeLimits = sizeLimits;


/***/ },
/* 26 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var sequence_1 = __webpack_require__(12);
	/**
	 * A sizer object for use with the [[boxCalc]] function.
	 *
	 * #### Notes
	 * A box sizer holds the geometry information for an object along a
	 * layout orientation.
	 *
	 * For best performance, this class should be treated as a raw data
	 * struct. It should not typically be subclassed.
	 */
	var BoxSizer = (function () {
	    function BoxSizer() {
	        /**
	         * The preferred size for the sizer.
	         *
	         * #### Notes
	         * The sizer will be given this initial size subject to its size
	         * bounds. The sizer will not deviate from this size unless such
	         * deviation is required to fit into the available layout space.
	         *
	         * There is no limit to this value, but it will be clamped to the
	         * bounds defined by [[minSize]] and [[maxSize]].
	         *
	         * The default value is `0`.
	         */
	        this.sizeHint = 0;
	        /**
	         * The minimum size of the sizer.
	         *
	         * #### Notes
	         * The sizer will never be sized less than this value, even if
	         * it means the sizer will overflow the available layout space.
	         *
	         * It is assumed that this value lies in the range `[0, Infinity)`
	         * and that it is `<=` to [[maxSize]]. Failure to adhere to this
	         * constraint will yield undefined results.
	         *
	         * The default value is `0`.
	         */
	        this.minSize = 0;
	        /**
	         * The maximum size of the sizer.
	         *
	         * #### Notes
	         * The sizer will never be sized greater than this value, even if
	         * it means the sizer will underflow the available layout space.
	         *
	         * It is assumed that this value lies in the range `[0, Infinity]`
	         * and that it is `>=` to [[minSize]]. Failure to adhere to this
	         * constraint will yield undefined results.
	         *
	         * The default value is `Infinity`.
	         */
	        this.maxSize = Infinity;
	        /**
	         * The stretch factor for the sizer.
	         *
	         * #### Notes
	         * This controls how much the sizer stretches relative to its sibling
	         * sizers when layout space is distributed. A stretch factor of zero
	         * is special and will cause the sizer to only be resized after all
	         * other sizers with a stretch factor greater than zero have been
	         * resized to their limits.
	         *
	         * It is assumed that this value is an integer that lies in the range
	         * `[0, Infinity)`. Failure to adhere to this constraint will yield
	         * undefined results.
	         *
	         * The default value is `1`.
	         */
	        this.stretch = 1;
	        /**
	         * The computed size of the sizer.
	         *
	         * #### Notes
	         * This value is the output of a call to [[boxCalc]]. It represents
	         * the computed size for the object along the layout orientation,
	         * and will always lie in the range `[minSize, maxSize]`.
	         *
	         * This value is output only.
	         *
	         * Changing this value will have no effect.
	         */
	        this.size = 0;
	        /**
	         * An internal storage property for the layout algorithm.
	         *
	         * #### Notes
	         * This value is used as temporary storage by the layout algorithm.
	         *
	         * Changing this value will have no effect.
	         */
	        this.done = false;
	    }
	    return BoxSizer;
	}());
	exports.BoxSizer = BoxSizer;
	/**
	 * Compute the optimal layout sizes for a sequence of box sizers.
	 *
	 * This distributes the available layout space among the box sizers
	 * according to the following algorithm:
	 *
	 * 1. Initialize the sizers's size to its size hint and compute the
	 *    sums for each of size hint, min size, and max size.
	 *
	 * 2. If the total size hint equals the available space, return.
	 *
	 * 3. If the available space is less than the total min size, set all
	 *    sizers to their min size and return.
	 *
	 * 4. If the available space is greater than the total max size, set
	 *    all sizers to their max size and return.
	 *
	 * 5. If the layout space is less than the total size hint, distribute
	 *    the negative delta as follows:
	 *
	 *    a. Shrink each sizer with a stretch factor greater than zero by
	 *       an amount proportional to the negative space and the sum of
	 *       stretch factors. If the sizer reaches its min size, remove
	 *       it and its stretch factor from the computation.
	 *
	 *    b. If after adjusting all stretch sizers there remains negative
	 *       space, distribute the space equally among the sizers with a
	 *       stretch factor of zero. If a sizer reaches its min size,
	 *       remove it from the computation.
	 *
	 * 6. If the layout space is greater than the total size hint,
	 *    distribute the positive delta as follows:
	 *
	 *    a. Expand each sizer with a stretch factor greater than zero by
	 *       an amount proportional to the postive space and the sum of
	 *       stretch factors. If the sizer reaches its max size, remove
	 *       it and its stretch factor from the computation.
	 *
	 *    b. If after adjusting all stretch sizers there remains positive
	 *       space, distribute the space equally among the sizers with a
	 *       stretch factor of zero. If a sizer reaches its max size,
	 *       remove it from the computation.
	 *
	 * 7. return
	 *
	 * @param sizers - The sizers for a particular layout line.
	 *
	 * @param space - The available layout space for the sizers.
	 *
	 * #### Notes
	 * The [[size]] of each sizer is updated with the computed size.
	 *
	 * This function can be called at any time to recompute the layout for
	 * an existing sequence of sizers. The previously computed results will
	 * have no effect on the new output. It is therefore not necessary to
	 * create new sizer objects on each resize event.
	 */
	function boxCalc(object, space) {
	    // Bail early if there is nothing to do.
	    var count = object.length;
	    if (count === 0) {
	        return;
	    }
	    // Cast the object to a sequence of sizers.
	    var sizers = sequence_1.asSequence(object);
	    // Setup the size and stretch counters.
	    var totalMin = 0;
	    var totalMax = 0;
	    var totalSize = 0;
	    var totalStretch = 0;
	    var stretchCount = 0;
	    // Setup the sizers and compute the totals.
	    for (var i = 0; i < count; ++i) {
	        var sizer = sizers.at(i);
	        var min = sizer.minSize;
	        var max = sizer.maxSize;
	        var hint = sizer.sizeHint;
	        sizer.done = false;
	        sizer.size = Math.max(min, Math.min(hint, max));
	        totalSize += sizer.size;
	        totalMin += min;
	        totalMax += max;
	        if (sizer.stretch > 0) {
	            totalStretch += sizer.stretch;
	            stretchCount++;
	        }
	    }
	    // If the space is equal to the total size, return.
	    if (space === totalSize) {
	        return;
	    }
	    // If the space is less than the total min, minimize each sizer.
	    if (space <= totalMin) {
	        for (var i = 0; i < count; ++i) {
	            var sizer = sizers.at(i);
	            sizer.size = sizer.minSize;
	        }
	        return;
	    }
	    // If the space is greater than the total max, maximize each sizer.
	    if (space >= totalMax) {
	        for (var i = 0; i < count; ++i) {
	            var sizer = sizers.at(i);
	            sizer.size = sizer.maxSize;
	        }
	        return;
	    }
	    // The loops below perform sub-pixel precision sizing. A near zero
	    // value is used for compares instead of zero to ensure that the
	    // loop terminates when the subdivided space is reasonably small.
	    var nearZero = 0.01;
	    // A counter which is decremented each time a sizer is resized to
	    // its limit. This ensures the loops terminate even if there is
	    // space remaining to distribute.
	    var notDoneCount = count;
	    // Distribute negative delta space.
	    if (space < totalSize) {
	        // Shrink each stretchable sizer by an amount proportional to its
	        // stretch factor. If a sizer reaches its min size it's marked as
	        // done. The loop progresses in phases where each sizer is given
	        // a chance to consume its fair share for the pass, regardless of
	        // whether a sizer before it reached its limit. This continues
	        // until the stretchable sizers or the free space is exhausted.
	        var freeSpace = totalSize - space;
	        while (stretchCount > 0 && freeSpace > nearZero) {
	            var distSpace = freeSpace;
	            var distStretch = totalStretch;
	            for (var i = 0; i < count; ++i) {
	                var sizer = sizers.at(i);
	                if (sizer.done || sizer.stretch === 0) {
	                    continue;
	                }
	                var amt = sizer.stretch * distSpace / distStretch;
	                if (sizer.size - amt <= sizer.minSize) {
	                    freeSpace -= sizer.size - sizer.minSize;
	                    totalStretch -= sizer.stretch;
	                    sizer.size = sizer.minSize;
	                    sizer.done = true;
	                    notDoneCount--;
	                    stretchCount--;
	                }
	                else {
	                    freeSpace -= amt;
	                    sizer.size -= amt;
	                }
	            }
	        }
	        // Distribute any remaining space evenly among the non-stretchable
	        // sizers. This progresses in phases in the same manner as above.
	        while (notDoneCount > 0 && freeSpace > nearZero) {
	            var amt = freeSpace / notDoneCount;
	            for (var i = 0; i < count; ++i) {
	                var sizer = sizers.at(i);
	                if (sizer.done) {
	                    continue;
	                }
	                if (sizer.size - amt <= sizer.minSize) {
	                    freeSpace -= sizer.size - sizer.minSize;
	                    sizer.size = sizer.minSize;
	                    sizer.done = true;
	                    notDoneCount--;
	                }
	                else {
	                    freeSpace -= amt;
	                    sizer.size -= amt;
	                }
	            }
	        }
	    }
	    else {
	        // Expand each stretchable sizer by an amount proportional to its
	        // stretch factor. If a sizer reaches its max size it's marked as
	        // done. The loop progresses in phases where each sizer is given
	        // a chance to consume its fair share for the pass, regardless of
	        // whether a sizer before it reached its limit. This continues
	        // until the stretchable sizers or the free space is exhausted.
	        var freeSpace = space - totalSize;
	        while (stretchCount > 0 && freeSpace > nearZero) {
	            var distSpace = freeSpace;
	            var distStretch = totalStretch;
	            for (var i = 0; i < count; ++i) {
	                var sizer = sizers.at(i);
	                if (sizer.done || sizer.stretch === 0) {
	                    continue;
	                }
	                var amt = sizer.stretch * distSpace / distStretch;
	                if (sizer.size + amt >= sizer.maxSize) {
	                    freeSpace -= sizer.maxSize - sizer.size;
	                    totalStretch -= sizer.stretch;
	                    sizer.size = sizer.maxSize;
	                    sizer.done = true;
	                    notDoneCount--;
	                    stretchCount--;
	                }
	                else {
	                    freeSpace -= amt;
	                    sizer.size += amt;
	                }
	            }
	        }
	        // Distribute any remaining space evenly among the non-stretchable
	        // sizers. This progresses in phases in the same manner as above.
	        while (notDoneCount > 0 && freeSpace > nearZero) {
	            var amt = freeSpace / notDoneCount;
	            for (var i = 0; i < count; ++i) {
	                var sizer = sizers.at(i);
	                if (sizer.done) {
	                    continue;
	                }
	                if (sizer.size + amt >= sizer.maxSize) {
	                    freeSpace -= sizer.maxSize - sizer.size;
	                    sizer.size = sizer.maxSize;
	                    sizer.done = true;
	                    notDoneCount--;
	                }
	                else {
	                    freeSpace -= amt;
	                    sizer.size += amt;
	                }
	            }
	        }
	    }
	}
	exports.boxCalc = boxCalc;


/***/ },
/* 27 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var mutation_1 = __webpack_require__(24);
	var searching_1 = __webpack_require__(11);
	var vector_1 = __webpack_require__(13);
	var messaging_1 = __webpack_require__(18);
	var widget_1 = __webpack_require__(17);
	/**
	 * The class name added to Panel instances.
	 */
	var PANEL_CLASS = 'p-Panel';
	/**
	 * A simple and convenient panel widget class.
	 *
	 * #### Notes
	 * This class is suitable as a base class for implementing a variety of
	 * convenience panel widgets, but can also be used directly with CSS to
	 * arrange a collection of widgets.
	 *
	 * This class provides a convenience wrapper around a [[PanelLayout]].
	 */
	var Panel = (function (_super) {
	    __extends(Panel, _super);
	    /**
	     * Construct a new panel.
	     *
	     * @param options - The options for initializing the panel.
	     */
	    function Panel(options) {
	        if (options === void 0) { options = {}; }
	        _super.call(this);
	        this.addClass(PANEL_CLASS);
	        this.layout = Private.createLayout(options);
	    }
	    Object.defineProperty(Panel.prototype, "widgets", {
	        /**
	         * A read-only sequence of the widgets in the panel.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.layout.widgets;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Add a widget to the end of the panel.
	     *
	     * @param widget - The widget to add to the panel.
	     *
	     * #### Notes
	     * If the is already contained in the panel, it will be moved.
	     */
	    Panel.prototype.addWidget = function (widget) {
	        this.layout.addWidget(widget);
	    };
	    /**
	     * Insert a widget at the specified index.
	     *
	     * @param index - The index at which to insert the widget.
	     *
	     * @param widget - The widget to insert into to the panel.
	     *
	     * #### Notes
	     * If the widget is already contained in the panel, it will be moved.
	     */
	    Panel.prototype.insertWidget = function (index, widget) {
	        this.layout.insertWidget(index, widget);
	    };
	    return Panel;
	}(widget_1.Widget));
	exports.Panel = Panel;
	/**
	 * A concrete layout implementation suitable for many use cases.
	 *
	 * #### Notes
	 * This class is suitable as a base class for implementing a variety of
	 * layouts, but can also be used directly with standard CSS to layout a
	 * collection of widgets.
	 */
	var PanelLayout = (function (_super) {
	    __extends(PanelLayout, _super);
	    function PanelLayout() {
	        _super.apply(this, arguments);
	        this._widgets = new vector_1.Vector();
	    }
	    /**
	     * Dispose of the resources held by the layout.
	     *
	     * #### Notes
	     * This will clear and dispose all widgets in the layout.
	     *
	     * All reimplementations should call the superclass method.
	     *
	     * This method is called automatically when the parent is disposed.
	     */
	    PanelLayout.prototype.dispose = function () {
	        while (this._widgets.length > 0) {
	            this._widgets.popBack().dispose();
	        }
	        _super.prototype.dispose.call(this);
	    };
	    Object.defineProperty(PanelLayout.prototype, "widgets", {
	        /**
	         * A read-only sequence of the widgets in the layout.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._widgets;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Create an iterator over the widgets in the layout.
	     *
	     * @returns A new iterator over the widgets in the layout.
	     */
	    PanelLayout.prototype.iter = function () {
	        return this._widgets.iter();
	    };
	    /**
	     * Add a widget to the end of the layout.
	     *
	     * @param widget - The widget to add to the layout.
	     *
	     * #### Notes
	     * If the widget is already contained in the layout, it will be moved.
	     */
	    PanelLayout.prototype.addWidget = function (widget) {
	        this.insertWidget(this._widgets.length, widget);
	    };
	    /**
	     * Insert a widget into the layout at the specified index.
	     *
	     * @param index - The index at which to insert the widget.
	     *
	     * @param widget - The widget to insert into the layout.
	     *
	     * #### Notes
	     * The index will be clamped to the bounds of the widgets.
	     *
	     * If the widget is already added to the layout, it will be moved.
	     */
	    PanelLayout.prototype.insertWidget = function (index, widget) {
	        // Remove the widget from its current parent. This is a no-op
	        // if the widget's parent is already the layout parent widget.
	        widget.parent = this.parent;
	        // Look up the current index of the widget.
	        var i = searching_1.indexOf(this._widgets, widget);
	        // Clamp the insert index to the vector bounds.
	        var j = Math.max(0, Math.min(Math.floor(index), this._widgets.length));
	        // If the widget is not in the vector, insert it.
	        if (i === -1) {
	            // Insert the widget into the vector.
	            this._widgets.insert(j, widget);
	            // If the layout is parented, attach the widget to the DOM.
	            if (this.parent)
	                this.attachWidget(j, widget);
	            // There is nothing more to do.
	            return;
	        }
	        // Otherwise, the widget exists in the vector and should be moved.
	        // Adjust the index if the location is at the end of the vector.
	        if (j === this._widgets.length)
	            j--;
	        // Bail if there is no effective move.
	        if (i === j)
	            return;
	        // Move the widget to the new location.
	        mutation_1.move(this._widgets, i, j);
	        // If the layout is parented, move the widget in the DOM.
	        if (this.parent)
	            this.moveWidget(i, j, widget);
	    };
	    /**
	     * Remove a widget from the layout.
	     *
	     * @param widget - The widget to remove from the layout.
	     *
	     * @returns The index occupied by the widget, or `-1` if the widget
	     *   was not contained in the layout.
	     *
	     * #### Notes
	     * A widget is automatically removed from the layout when its `parent`
	     * is set to `null`. This method should only be invoked directly when
	     * removing a widget from a layout which has yet to be installed on a
	     * parent widget.
	     *
	     * This method does *not* modify the widget's `parent`.
	     */
	    PanelLayout.prototype.removeWidget = function (widget) {
	        var index = searching_1.indexOf(this._widgets, widget);
	        if (index !== -1)
	            this.removeWidgetAt(index);
	        return index;
	    };
	    /**
	     * Remove the widget at a given index from the layout.
	     *
	     * @param index - The index of the widget to remove.
	     *
	     * @returns The widget occupying the index, or `null` if the index
	     *   is out of range.
	     *
	     * #### Notes
	     * A widget is automatically removed from the layout when its `parent`
	     * is set to `null`. This method should only be invoked directly when
	     * removing a widget from a layout which has yet to be installed on a
	     * parent widget.
	     *
	     * This method does *not* modify the widget's `parent`.
	     */
	    PanelLayout.prototype.removeWidgetAt = function (index) {
	        // Bail if the index is out of range.
	        var i = Math.floor(index);
	        if (i < 0 || i >= this._widgets.length) {
	            return null;
	        }
	        // Remove the widget from the vector.
	        var widget = this._widgets.removeAt(i);
	        // If the layout is parented, detach the widget from the DOM.
	        if (this.parent)
	            this.detachWidget(i, widget);
	        // Return the removed widget.
	        return widget;
	    };
	    /**
	     * Attach a widget to the parent's DOM node.
	     *
	     * @param index - The current index of the widget in the layout.
	     *
	     * @param widget - The widget to attach to the parent.
	     *
	     * #### Notes
	     * This method is called automatically by the panel layout at the
	     * appropriate time. It should not be called directly by user code.
	     *
	     * The default implementation adds the widgets's node to the parent's
	     * node at the proper location, and sends an `'after-attach'` message
	     * to the widget if the parent is attached to the DOM.
	     *
	     * Subclasses may reimplement this method to control how the widget's
	     * node is added to the parent's node, but the reimplementation must
	     * send an `'after-attach'` message to the widget if the parent is
	     * attached to the DOM.
	     */
	    PanelLayout.prototype.attachWidget = function (index, widget) {
	        // Look up the next sibling reference node.
	        var ref = this.parent.node.children[index];
	        // Insert the widget's node before the sibling.
	        this.parent.node.insertBefore(widget.node, ref);
	        // Send an `'after-attach'` message if the parent is attached.
	        if (this.parent.isAttached)
	            messaging_1.sendMessage(widget, widget_1.WidgetMessage.AfterAttach);
	    };
	    /**
	     * Move a widget in the parent's DOM node.
	     *
	     * @param fromIndex - The previous index of the widget in the layout.
	     *
	     * @param toIndex - The current index of the widget in the layout.
	     *
	     * @param widget - The widget to move in the parent.
	     *
	     * #### Notes
	     * This method is called automatically by the panel layout at the
	     * appropriate time. It should not be called directly by user code.
	     *
	     * The default implementation moves the widget's node to the proper
	     * location in the parent's node and sends both a `'before-detach'`
	     * and an `'after-attach'` message to the widget if the parent is
	     * attached to the DOM.
	     *
	     * Subclasses may reimplement this method to control how the widget's
	     * node is moved in the parent's node, but the reimplementation must
	     * send both a `'before-detach'` and an `'after-attach'` message to
	     * the widget if the parent is attached to the DOM.
	     */
	    PanelLayout.prototype.moveWidget = function (fromIndex, toIndex, widget) {
	        // Send a `'before-detach'` message if the parent is attached.
	        if (this.parent.isAttached)
	            messaging_1.sendMessage(widget, widget_1.WidgetMessage.BeforeDetach);
	        // Remove the widget's node from the parent.
	        this.parent.node.removeChild(widget.node);
	        // Look up the next sibling reference node.
	        var ref = this.parent.node.children[toIndex];
	        // Insert the widget's node before the sibling.
	        this.parent.node.insertBefore(widget.node, ref);
	        // Send an `'after-attach'` message if the parent is attached.
	        if (this.parent.isAttached)
	            messaging_1.sendMessage(widget, widget_1.WidgetMessage.AfterAttach);
	    };
	    /**
	     * Detach a widget from the parent's DOM node.
	     *
	     * @param index - The previous index of the widget in the layout.
	     *
	     * @param widget - The widget to detach from the parent.
	     *
	     * #### Notes
	     * This method is called automatically by the panel layout at the
	     * appropriate time. It should not be called directly by user code.
	     *
	     * The default implementation removes the widget's node from the
	     * parent's node, and sends a `'before-detach'` message to the widget
	     * if the parent is attached to the DOM.
	     *
	     * Subclasses may reimplement this method to control how the widget's
	     * node is removed from the parent's node, but the reimplementation
	     * must send a `'before-detach'` message to the widget if the parent
	     * is attached to the DOM.
	     */
	    PanelLayout.prototype.detachWidget = function (index, widget) {
	        // Send a `'before-detach'` message if the parent is attached.
	        if (this.parent.isAttached)
	            messaging_1.sendMessage(widget, widget_1.WidgetMessage.BeforeDetach);
	        // Remove the widget's node from the parent.
	        this.parent.node.removeChild(widget.node);
	    };
	    /**
	     * A message handler invoked on a `'layout-changed'` message.
	     *
	     * #### Notes
	     * This is called when the layout is installed on its parent.
	     *
	     * The default implementation attaches all widgets to the DOM.
	     *
	     * This may be reimplemented by subclasses as needed.
	     */
	    PanelLayout.prototype.onLayoutChanged = function (msg) {
	        for (var i = 0; i < this._widgets.length; ++i) {
	            var widget = this._widgets.at(i);
	            widget.parent = this.parent;
	            this.attachWidget(i, widget);
	        }
	    };
	    /**
	     * A message handler invoked on a `'child-removed'` message.
	     *
	     * #### Notes
	     * This will remove the child widget from the layout.
	     *
	     * Subclasses should **not** typically reimplement this method.
	     */
	    PanelLayout.prototype.onChildRemoved = function (msg) {
	        this.removeWidget(msg.child);
	    };
	    return PanelLayout;
	}(widget_1.Layout));
	exports.PanelLayout = PanelLayout;
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Create a panel layout for the given panel options.
	     */
	    function createLayout(options) {
	        return options.layout || new PanelLayout();
	    }
	    Private.createLayout = createLayout;
	})(Private || (Private = {}));


/***/ },
/* 28 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var iteration_1 = __webpack_require__(5);
	var searching_1 = __webpack_require__(11);
	var vector_1 = __webpack_require__(13);
	var mimedata_1 = __webpack_require__(29);
	var signaling_1 = __webpack_require__(6);
	var dragdrop_1 = __webpack_require__(30);
	var query_1 = __webpack_require__(32);
	var sizing_1 = __webpack_require__(25);
	var focustracker_1 = __webpack_require__(33);
	var splitpanel_1 = __webpack_require__(34);
	var stackedpanel_1 = __webpack_require__(35);
	var tabpanel_1 = __webpack_require__(36);
	var widget_1 = __webpack_require__(17);
	/**
	 * The class name added to a DockPanel instance.
	 */
	var DOCK_PANEL_CLASS = 'p-DockPanel';
	/**
	 * The class name added to a DockPanel tab panel descendant.
	 */
	var TAB_PANEL_CLASS = 'p-DockPanel-tabPanel';
	/**
	 * The class name added to a DockPanel split panel descendant.
	 */
	var SPLIT_PANEL_CLASS = 'p-DockPanel-splitPanel';
	/**
	 * The class name added to a DockPanel overlay.
	 */
	var OVERLAY_CLASS = 'p-DockPanel-overlay';
	/**
	 * The class name added to hidden entities.
	 */
	var HIDDEN_CLASS = 'p-mod-hidden';
	/**
	 * The factory MIME type supported by the dock panel.
	 */
	var FACTORY_MIME = 'application/vnd.phosphor.widget-factory';
	/**
	 * The size of the edge dock zone for the root panel, in pixels.
	 */
	var EDGE_SIZE = 30;
	/**
	 * A widget which provides a flexible docking area for widgets.
	 */
	var DockPanel = (function (_super) {
	    __extends(DockPanel, _super);
	    /**
	     * Construct a new dock panel.
	     *
	     * @param options - The options for initializing the panel.
	     */
	    function DockPanel(options) {
	        if (options === void 0) { options = {}; }
	        _super.call(this);
	        this._drag = null;
	        this._widgets = new vector_1.Vector();
	        this._tabPanels = new vector_1.Vector();
	        this._splitPanels = new vector_1.Vector();
	        this._tracker = new focustracker_1.FocusTracker();
	        this._root = null;
	        this.addClass(DOCK_PANEL_CLASS);
	        // Install the layout on the panel.
	        this.layout = new stackedpanel_1.StackedLayout();
	        // Parse the spacing option.
	        if (options.spacing !== void 0) {
	            this._spacing = Private.clampSpacing(options.spacing);
	        }
	        // Setup the overlay indicator.
	        if (options.overlay !== void 0) {
	            this._overlay = options.overlay;
	        }
	        else {
	            this._overlay = new DockPanel.Overlay();
	        }
	        // Connect the focus tracker changed signal.
	        this._tracker.currentChanged.connect(this._onCurrentChanged, this);
	        // Add the overlay node to the panel.
	        this.node.appendChild(this._overlay.node);
	    }
	    /**
	     * Dispose of the resources held by the panel.
	     */
	    DockPanel.prototype.dispose = function () {
	        // Hide the overlay.
	        this._overlay.hide(0);
	        // Cancel a drag if one is in progress.
	        if (this._drag)
	            this._drag.dispose();
	        // Clear the data structures.
	        this._root = null;
	        this._widgets.clear();
	        this._tabPanels.clear();
	        this._splitPanels.clear();
	        // Dispose of the focus tracker.
	        this._tracker.dispose();
	        // Dispose of the base class.
	        _super.prototype.dispose.call(this);
	    };
	    Object.defineProperty(DockPanel.prototype, "overlay", {
	        /**
	         * The overlay used by the dock panel.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._overlay;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DockPanel.prototype, "spacing", {
	        /**
	         * Get the spacing between the panels.
	         */
	        get: function () {
	            return this._spacing;
	        },
	        /**
	         * Set the spacing between the panels.
	         */
	        set: function (value) {
	            value = Private.clampSpacing(value);
	            if (this._spacing === value) {
	                return;
	            }
	            this._spacing = value;
	            iteration_1.each(this._splitPanels, function (panel) { panel.spacing = value; });
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DockPanel.prototype, "widgets", {
	        /**
	         * A read-only sequence of the widgets in the dock panel.
	         *
	         * #### Notes
	         * The order of the widgets in the sequence has no meaning.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._widgets;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DockPanel.prototype, "currentWidget", {
	        /**
	         * The current widget in the dock panel.
	         *
	         * #### Notes
	         * The current widget is the widget among the added widgets which
	         * has the *descendant node* which has most recently been focused.
	         *
	         * This is the `currentWidget` of the internal `FocusTracker` which
	         * tracks all widgets in the dock panel.
	         *
	         * This will be `null` if there is no current widget.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._tracker.currentWidget;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Activate the specified widget in the dock panel.
	     *
	     * @param widget - The widget of interest.
	     *
	     * #### Notes
	     * This will ensure that the widget is the current visible widget
	     * in its host tab panel and post the widget an activate request.
	     */
	    DockPanel.prototype.activateWidget = function (widget) {
	        // Ensure the widget is contained by the panel.
	        if (searching_1.indexOf(this._widgets, widget) === -1) {
	            throw new Error('Widget is not contained by the dock panel.');
	        }
	        // Ensure the widget is the current widget.
	        widget.parent.parent.currentWidget = widget;
	        // Activate the widget.
	        widget.activate();
	    };
	    /**
	     * Add a widget to the dock panel.
	     *
	     * @param widget - The widget to add into the dock panel.
	     *
	     * @param options - The additional options for adding the widget.
	     */
	    DockPanel.prototype.addWidget = function (widget, options) {
	        if (options === void 0) { options = {}; }
	        // Setup the option defaults.
	        var activate = true;
	        var ref = null;
	        var mode = 'tab-after';
	        // Extract the options.
	        if (options.activate !== void 0) {
	            activate = options.activate;
	        }
	        if (options.ref !== void 0) {
	            ref = options.ref;
	        }
	        if (options.mode !== void 0) {
	            mode = options.mode;
	        }
	        // Ensure the arguments are valid.
	        if (!widget) {
	            throw new Error('Target widget is null.');
	        }
	        if (widget === ref) {
	            throw new Error('Target widget cannot be the reference widget.');
	        }
	        if (ref && searching_1.indexOf(this._widgets, ref) === -1) {
	            throw new Error('Reference widget is not contained by the dock panel.');
	        }
	        // Unparent the widget before performing the insert, so that structural
	        // changes to the panel occur before searching for the insert location.
	        widget.parent = null;
	        // Add the widget to the focus tracker.
	        this._tracker.add(widget);
	        // Add the widget to the widgets vector.
	        this._widgets.pushBack(widget);
	        // Insert the widget based on the specified mode.
	        this._insertWidget(widget, mode, ref);
	        // Activate the widget if requested.
	        if (activate)
	            this.activateWidget(widget);
	    };
	    /**
	     * Find the drop target for the given client position.
	     *
	     * @param clientX - The client X position of interest.
	     *
	     * @param clientY - The client Y position of interest.
	     *
	     * @returns The drop target at the specified client position.
	     */
	    DockPanel.prototype.findDropTarget = function (clientX, clientY) {
	        // If the position is not over the dock panel, bail.
	        if (!query_1.hitTest(this.node, clientX, clientY)) {
	            return { zone: 'invalid', panel: null };
	        }
	        // If there is no root, indicate a center drop position.
	        if (!this._root) {
	            return { zone: 'root-center', panel: null };
	        }
	        // Test for a root zone first.
	        var zone = Private.getRootZone(this.node, clientX, clientY);
	        if (zone !== 'invalid') {
	            return { zone: zone, panel: null };
	        }
	        // Find the panel at the client position.
	        var panel = searching_1.find(this._tabPanels, function (panel) {
	            return query_1.hitTest(panel.node, clientX, clientY);
	        }) || null;
	        // Compute the zone for the hit panel, if any.
	        if (panel) {
	            zone = Private.getPanelZone(panel.node, clientX, clientY);
	        }
	        else {
	            zone = 'invalid';
	        }
	        // Return the final drop target.
	        return { zone: zone, panel: panel };
	    };
	    /**
	     * Show the overlay indicator at the given client position.
	     *
	     * @param clientX - The client X position of interest.
	     *
	     * @param clientY - The client Y position of interest.
	     *
	     * @returns The dock zone at the specified client position.
	     *
	     * #### Notes
	     * If the position is not over a valid zone, the overlay is hidden.
	     *
	     * This returns the dock zone used to display the overlay.
	     */
	    DockPanel.prototype.showOverlay = function (clientX, clientY) {
	        // Find the dock target for the given client position.
	        var target = this.findDropTarget(clientX, clientY);
	        // If the dock zone is invalid, hide the overlay and bail.
	        if (target.zone === 'invalid') {
	            this._overlay.hide(100);
	            return target.zone;
	        }
	        // Setup the variables needed to compute the overlay geometry.
	        var top;
	        var left;
	        var right;
	        var bottom;
	        var cr;
	        var box = sizing_1.boxSizing(this.node); // TODO cache this?
	        var rect = this.node.getBoundingClientRect();
	        // Compute the overlay geometry based on the dock zone.
	        switch (target.zone) {
	            case 'root-top':
	                top = box.paddingTop;
	                left = box.paddingLeft;
	                right = box.paddingRight;
	                bottom = (rect.height - box.verticalSum) * 2 / 3;
	                break;
	            case 'root-left':
	                top = box.paddingTop;
	                left = box.paddingLeft;
	                right = (rect.width - box.horizontalSum) * 2 / 3;
	                bottom = box.paddingBottom;
	                break;
	            case 'root-right':
	                top = box.paddingTop;
	                left = (rect.width - box.horizontalSum) * 2 / 3;
	                right = box.paddingRight;
	                bottom = box.paddingBottom;
	                break;
	            case 'root-bottom':
	                top = (rect.height - box.verticalSum) * 2 / 3;
	                left = box.paddingLeft;
	                right = box.paddingRight;
	                bottom = box.paddingBottom;
	                break;
	            case 'root-center':
	                top = box.paddingTop;
	                left = box.paddingLeft;
	                right = box.paddingRight;
	                bottom = box.paddingBottom;
	                break;
	            case 'panel-top':
	                cr = target.panel.node.getBoundingClientRect();
	                top = cr.top - rect.top - box.borderTop;
	                left = cr.left - rect.left - box.borderLeft;
	                right = rect.right - cr.right - box.borderRight;
	                bottom = rect.bottom - cr.bottom + cr.height / 2 - box.borderBottom;
	                break;
	            case 'panel-left':
	                cr = target.panel.node.getBoundingClientRect();
	                top = cr.top - rect.top - box.borderTop;
	                left = cr.left - rect.left - box.borderLeft;
	                right = rect.right - cr.right + cr.width / 2 - box.borderRight;
	                bottom = rect.bottom - cr.bottom - box.borderBottom;
	                break;
	            case 'panel-right':
	                cr = target.panel.node.getBoundingClientRect();
	                top = cr.top - rect.top - box.borderTop;
	                left = cr.left - rect.left + cr.width / 2 - box.borderLeft;
	                right = rect.right - cr.right - box.borderRight;
	                bottom = rect.bottom - cr.bottom - box.borderBottom;
	                break;
	            case 'panel-bottom':
	                cr = target.panel.node.getBoundingClientRect();
	                top = cr.top - rect.top + cr.height / 2 - box.borderTop;
	                left = cr.left - rect.left - box.borderLeft;
	                right = rect.right - cr.right - box.borderRight;
	                bottom = rect.bottom - cr.bottom - box.borderBottom;
	                break;
	            case 'panel-center':
	                cr = target.panel.node.getBoundingClientRect();
	                top = cr.top - rect.top - box.borderTop;
	                left = cr.left - rect.left - box.borderLeft;
	                right = rect.right - cr.right - box.borderRight;
	                bottom = rect.bottom - cr.bottom - box.borderBottom;
	                break;
	        }
	        // Derive the width and height from the other dimensions.
	        var width = rect.width - right - left - box.borderLeft - box.borderRight;
	        var height = rect.height - bottom - top - box.borderTop - box.borderBottom;
	        // Show the overlay with the computed geometry.
	        this._overlay.show({
	            zone: target.zone,
	            mouseX: clientX,
	            mouseY: clientY,
	            parentRect: rect,
	            top: top, left: left, right: right, bottom: bottom, width: width, height: height
	        });
	        // Finally, return the dock zone used for the overlay.
	        return target.zone;
	    };
	    /**
	     * Handle the DOM events for the dock panel.
	     *
	     * @param event - The DOM event sent to the dock panel.
	     *
	     * #### Notes
	     * This method implements the DOM `EventListener` interface and is
	     * called in response to events on the dock panel's node. It should
	     * not be called directly by user code.
	     */
	    DockPanel.prototype.handleEvent = function (event) {
	        switch (event.type) {
	            case 'p-dragenter':
	                this._evtDragEnter(event);
	                break;
	            case 'p-dragleave':
	                this._evtDragLeave(event);
	                break;
	            case 'p-dragover':
	                this._evtDragOver(event);
	                break;
	            case 'p-drop':
	                this._evtDrop(event);
	                break;
	        }
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     */
	    DockPanel.prototype.onAfterAttach = function (msg) {
	        var node = this.node;
	        node.addEventListener('p-dragenter', this);
	        node.addEventListener('p-dragleave', this);
	        node.addEventListener('p-dragover', this);
	        node.addEventListener('p-drop', this);
	    };
	    /**
	     * A message handler invoked on a `'before-detach'` message.
	     */
	    DockPanel.prototype.onBeforeDetach = function (msg) {
	        var node = this.node;
	        node.removeEventListener('p-dragenter', this);
	        node.removeEventListener('p-dragleave', this);
	        node.removeEventListener('p-dragover', this);
	        node.removeEventListener('p-drop', this);
	    };
	    /**
	     * Handle the `'p-dragenter'` event for the dock panel.
	     */
	    DockPanel.prototype._evtDragEnter = function (event) {
	        // If the factory mime type is present, mark the event as
	        // handled in order to get the rest of the drag events.
	        if (event.mimeData.hasData(FACTORY_MIME)) {
	            event.preventDefault();
	            event.stopPropagation();
	        }
	    };
	    /**
	     * Handle the `'p-dragleave'` event for the dock panel.
	     */
	    DockPanel.prototype._evtDragLeave = function (event) {
	        // Always mark the event as handled.
	        event.preventDefault();
	        event.stopPropagation();
	        // Get the node into which the drag is entering.
	        var related = event.relatedTarget;
	        // Hide the overlay if the drag is leaving the dock panel.
	        if (!related || !this.node.contains(related)) {
	            this._overlay.hide(0);
	        }
	    };
	    /**
	     * Handle the `'p-dragover'` event for the dock panel.
	     */
	    DockPanel.prototype._evtDragOver = function (event) {
	        // Always mark the event as handled.
	        event.preventDefault();
	        event.stopPropagation();
	        // Show the drop indicator overlay and update the drop
	        // action based on the drop target zone under the mouse.
	        if (this.showOverlay(event.clientX, event.clientY) === 'invalid') {
	            event.dropAction = 'none';
	        }
	        else {
	            event.dropAction = event.proposedAction;
	        }
	    };
	    /**
	     * Handle the `'p-drop'` event for the dock panel.
	     */
	    DockPanel.prototype._evtDrop = function (event) {
	        // Always mark the event as handled.
	        event.preventDefault();
	        event.stopPropagation();
	        // Hide the drop indicator overlay.
	        this._overlay.hide(0);
	        // Bail if the proposed action is to do nothing.
	        if (event.proposedAction === 'none') {
	            event.dropAction = 'none';
	            return;
	        }
	        // Find the drop target under the mouse.
	        var target = this.findDropTarget(event.clientX, event.clientY);
	        // Bail if the drop zone is invalid.
	        if (target.zone === 'invalid') {
	            event.dropAction = 'none';
	            return;
	        }
	        // Bail if the factory mime type has invalid data.
	        var factory = event.mimeData.getData(FACTORY_MIME);
	        if (typeof factory !== 'function') {
	            event.dropAction = 'none';
	            return;
	        }
	        // Bail if the factory does not produce a widget.
	        var widget = factory();
	        if (!(widget instanceof widget_1.Widget)) {
	            event.dropAction = 'none';
	            return;
	        }
	        // Handle the drop using the generated widget.
	        this._handleDrop(widget, target);
	        // Accept the proposed drop action.
	        event.dropAction = event.proposedAction;
	    };
	    /**
	     * Drop a widget onto the dock panel using the given drop target.
	     */
	    DockPanel.prototype._handleDrop = function (widget, target) {
	        // Do nothing if the dock zone is invalid.
	        if (target.zone === 'invalid') {
	            return;
	        }
	        // Handle the simple case of root drops first.
	        switch (target.zone) {
	            case 'root-top':
	                this.addWidget(widget, { mode: 'split-top' });
	                return;
	            case 'root-left':
	                this.addWidget(widget, { mode: 'split-left' });
	                return;
	            case 'root-right':
	                this.addWidget(widget, { mode: 'split-right' });
	                return;
	            case 'root-bottom':
	                this.addWidget(widget, { mode: 'split-bottom' });
	                return;
	            case 'root-center':
	                this.addWidget(widget, { mode: 'split-left' });
	                return;
	        }
	        // Otherwise, it's a panel drop, and that requires more checks.
	        // Fetch the children of the target panel.
	        var children = target.panel.widgets;
	        // Do nothing if the widget is dropped as a tab on its own panel.
	        if (target.zone === 'panel-center' && searching_1.indexOf(children, widget) !== -1) {
	            return;
	        }
	        // Do nothing if the panel only contains the drop widget.
	        if (children.length === 1 && children.at(0) === widget) {
	            return;
	        }
	        // Find a suitable reference widget for the drop.
	        var ref = children.at(children.length - 1);
	        if (ref === widget) {
	            ref = children.at(children.length - 2);
	        }
	        // Insert the widget based on the panel zone.
	        switch (target.zone) {
	            case 'panel-top':
	                this.addWidget(widget, { mode: 'split-top', ref: ref });
	                return;
	            case 'panel-left':
	                this.addWidget(widget, { mode: 'split-left', ref: ref });
	                return;
	            case 'panel-right':
	                this.addWidget(widget, { mode: 'split-right', ref: ref });
	                return;
	            case 'panel-bottom':
	                this.addWidget(widget, { mode: 'split-bottom', ref: ref });
	                return;
	            case 'panel-center':
	                this.addWidget(widget, { mode: 'tab-after', ref: ref });
	                return;
	        }
	    };
	    /**
	     * Insert a widget into the dock panel using the given mode.
	     *
	     * The target widget should have no parent, and the reference widget
	     * should either be null or a widget contained in the dock panel.
	     */
	    DockPanel.prototype._insertWidget = function (widget, mode, ref) {
	        // Determine whether the insert is before or after the ref.
	        var after = (mode === 'tab-after' ||
	            mode === 'split-right' ||
	            mode === 'split-bottom');
	        // Handle the simple case of adding to a tab panel.
	        if (mode === 'tab-before' || mode === 'tab-after') {
	            if (ref) {
	                var tabPanel_1 = ref.parent.parent;
	                var index = searching_1.indexOf(tabPanel_1.widgets, ref) + (after ? 1 : 0);
	                tabPanel_1.insertWidget(index, widget);
	            }
	            else {
	                var tabPanel_2 = this._ensureTabPanel();
	                var index = after ? tabPanel_2.widgets.length : 0;
	                tabPanel_2.insertWidget(index, widget);
	            }
	            return;
	        }
	        // Otherwise, determine the orientation of the new split.
	        var orientation;
	        if (mode === 'split-top' || mode === 'split-bottom') {
	            orientation = 'vertical';
	        }
	        else {
	            orientation = 'horizontal';
	        }
	        // Setup the new tab panel to host the widget.
	        var tabPanel = this._createTabPanel();
	        tabPanel.addWidget(widget);
	        // If there is no root, add the new tab panel as the root.
	        if (!this._root) {
	            this._setRoot(tabPanel);
	            return;
	        }
	        // If the ref widget is null, split the root panel.
	        if (!ref) {
	            var splitPanel_1 = this._ensureSplitRoot(orientation);
	            var sizes_1 = splitPanel_1.relativeSizes();
	            var index = after ? sizes_1.length : 0;
	            sizes_1.splice(index, 0, 0.5);
	            splitPanel_1.insertWidget(index, tabPanel);
	            splitPanel_1.setRelativeSizes(sizes_1);
	            return;
	        }
	        // Lookup the tab panel for the ref widget.
	        var refTabPanel = ref.parent.parent;
	        // If the ref tab panel is the root, split the root.
	        if (this._root === refTabPanel) {
	            var splitPanel_2 = this._ensureSplitRoot(orientation);
	            splitPanel_2.insertWidget(after ? 1 : 0, tabPanel);
	            splitPanel_2.setRelativeSizes([1, 1]);
	            return;
	        }
	        // Otherwise, the ref tab panel parent is a split panel.
	        var splitPanel = refTabPanel.parent;
	        // If the split panel is the correct orientation, the widget
	        // can be inserted directly and sized to 0.5 of the ref space.
	        if (splitPanel.orientation === orientation) {
	            var i_1 = searching_1.indexOf(splitPanel.widgets, refTabPanel);
	            var index = after ? i_1 + 1 : i_1;
	            var sizes_2 = splitPanel.relativeSizes();
	            var size = sizes_2[i_1] = sizes_2[i_1] / 2;
	            sizes_2.splice(index, 0, size);
	            splitPanel.insertWidget(index, tabPanel);
	            splitPanel.setRelativeSizes(sizes_2);
	            return;
	        }
	        // If the split panel only has a single child, its orientation
	        // can be changed directly and its sizes set to a 1:1 ratio.
	        if (splitPanel.widgets.length === 1) {
	            splitPanel.orientation = orientation;
	            splitPanel.insertWidget(after ? 1 : 0, tabPanel);
	            splitPanel.setRelativeSizes([1, 1]);
	            return;
	        }
	        // Otherwise, a new split panel with the correct orientation needs
	        // to be created to hold the ref panel and tab panel, and inserted
	        // at the previous location of the ref panel.
	        var sizes = splitPanel.relativeSizes();
	        var i = searching_1.indexOf(splitPanel.widgets, refTabPanel);
	        var childSplit = this._createSplitPanel(orientation);
	        childSplit.insertWidget(0, refTabPanel);
	        childSplit.insertWidget(after ? 1 : 0, tabPanel);
	        splitPanel.insertWidget(i, childSplit);
	        splitPanel.setRelativeSizes(sizes);
	        childSplit.setRelativeSizes([1, 1]);
	    };
	    /**
	     * Create a new tab panel for adding to the dock panel.
	     */
	    DockPanel.prototype._createTabPanel = function () {
	        var panel = new tabpanel_1.TabPanel({ tabsMovable: true });
	        panel.addClass(TAB_PANEL_CLASS);
	        panel.tabBar.tabDetachRequested.connect(this._onTabDetachRequested, this);
	        panel.stackedPanel.widgetRemoved.connect(this._onWidgetRemoved, this);
	        this._tabPanels.pushBack(panel);
	        return panel;
	    };
	    /**
	     * Create a new split panel for adding to the dock panel.
	     */
	    DockPanel.prototype._createSplitPanel = function (orientation) {
	        var panel = new splitpanel_1.SplitPanel({ orientation: orientation, spacing: this._spacing });
	        panel.addClass(SPLIT_PANEL_CLASS);
	        this._splitPanels.pushBack(panel);
	        return panel;
	    };
	    /**
	     * Dispose of a tab panel created for the dock panel.
	     */
	    DockPanel.prototype._disposeTabPanel = function (panel) {
	        this._tabPanels.remove(panel);
	        panel.dispose();
	    };
	    /**
	     * Dispose of a split panel created for the dock panel.
	     */
	    DockPanel.prototype._disposeSplitPanel = function (panel) {
	        this._splitPanels.remove(panel);
	        panel.dispose();
	    };
	    /**
	     * Ensure a tab panel is available in the dock panel.
	     *
	     * If there is no root panel, a new root tab panel will be created.
	     * Otherwise, if there is an active widget, the tab panel for that
	     * widget will be returned. Otherwise, the top-left tab panel will
	     * be returned.
	     */
	    DockPanel.prototype._ensureTabPanel = function () {
	        // If there is no root panel, create a new root tab panel.
	        if (!this._root) {
	            var panel_1 = this._createTabPanel();
	            this._setRoot(panel_1);
	            return panel_1;
	        }
	        // Otherwise, use the tab panel of the current widget if possible.
	        var current = this._tracker.currentWidget;
	        if (current) {
	            return current.parent.parent;
	        }
	        // Otherwise, fallback on using the top-left tab panel.
	        var panel = this._root;
	        while (panel instanceof splitpanel_1.SplitPanel) {
	            panel = panel.widgets.at(0);
	        }
	        // Return the top-left tab panel.
	        return panel;
	    };
	    /**
	     * Ensure the root panel is a split panel with the given orientation.
	     *
	     * This returns split panel so that casting the root is not needed.
	     */
	    DockPanel.prototype._ensureSplitRoot = function (orientation) {
	        // If there is no root panel, create a new root split panel.
	        if (!this._root) {
	            var root = this._createSplitPanel(orientation);
	            this._setRoot(root);
	            return root;
	        }
	        // If the root is a tab panel, add it to a new split root.
	        if (this._root instanceof tabpanel_1.TabPanel) {
	            var root = this._createSplitPanel(orientation);
	            root.addWidget(this._root);
	            this._setRoot(root);
	            return root;
	        }
	        // Otherwise, do nothing if the split root orientation is okay.
	        var oldRoot = this._root;
	        if (oldRoot.orientation === orientation) {
	            return oldRoot;
	        }
	        // Correct the orientation of the split root, if feasible.
	        if (oldRoot.widgets.length <= 1) {
	            oldRoot.orientation = orientation;
	            return oldRoot;
	        }
	        // Otherwise, create a new split root.
	        var newRoot = this._createSplitPanel(orientation);
	        newRoot.addWidget(oldRoot);
	        this._setRoot(newRoot);
	        return newRoot;
	    };
	    /**
	     * Set the non-null root widget for the dock panel.
	     */
	    DockPanel.prototype._setRoot = function (root) {
	        this._root = root;
	        this.layout.addWidget(root);
	        root.show();
	    };
	    /**
	     * Remove an empty dock tab panel from the hierarchy.
	     *
	     * This ensures that the hierarchy is kept consistent by merging an
	     * ancestor split panel when it contains only a single child widget.
	     */
	    DockPanel.prototype._removeTabPanel = function (tabPanel) {
	        // If the parent of the tab panel is the root, just remove it.
	        if (this._root === tabPanel) {
	            this._disposeTabPanel(tabPanel);
	            this._root = null;
	            return;
	        }
	        // Cast the tab panel parent to a split panel.
	        // It's guaranteed to have at least 2 children.
	        var splitPanel = tabPanel.parent;
	        // Release the tab panel.
	        this._disposeTabPanel(tabPanel);
	        // Do nothing more if the split panel still has multiple children.
	        if (splitPanel.widgets.length > 1) {
	            return;
	        }
	        // Extract the remaining child from the split panel.
	        var child = splitPanel.widgets.at(0);
	        // If the split panel is the root, replace it.
	        if (this._root === splitPanel) {
	            this._setRoot(child);
	            this._disposeSplitPanel(splitPanel);
	            return;
	        }
	        // Cast the split panel parent to a split panel and lookup
	        // the index of the split panel. The grand panel will have
	        // at least 2 children.
	        var grandPanel = splitPanel.parent;
	        var index = searching_1.indexOf(grandPanel.widgets, splitPanel);
	        // If the child is a tab panel, replace the split panel.
	        if (child instanceof tabpanel_1.TabPanel) {
	            var sizes = grandPanel.relativeSizes();
	            splitPanel.parent = null;
	            grandPanel.insertWidget(index, child);
	            grandPanel.setRelativeSizes(sizes);
	            this._disposeSplitPanel(splitPanel);
	            return;
	        }
	        // Cast the child to a split panel.
	        var childSplit = child;
	        // Child splitters have an orthogonal orientation to their parent.
	        // The grand children can now be merged with their grand parent.
	        // Start by fetching the relevant current sizes.
	        var childSizes = childSplit.relativeSizes();
	        var grandSizes = grandPanel.relativeSizes();
	        // Remove the split panel and store its share of the size.
	        splitPanel.parent = null;
	        var sizeShare = grandSizes.splice(index, 1)[0];
	        // Merge the grand children and maintain their relative size.
	        for (var i = 0; childSplit.widgets.length !== 0; ++i) {
	            grandPanel.insertWidget(index + i, childSplit.widgets.at(0));
	            grandSizes.splice(index + i, 0, sizeShare * childSizes[i]);
	        }
	        // Update the grand parent sizes.
	        grandPanel.setRelativeSizes(grandSizes);
	        // Dispose the removed split panel.
	        this._disposeSplitPanel(splitPanel);
	    };
	    /**
	     * Handle the `tabDetachRequested` signal from a tab bar.
	     */
	    DockPanel.prototype._onTabDetachRequested = function (sender, args) {
	        var _this = this;
	        // Do nothing if a drag is already in progress.
	        if (this._drag) {
	            return;
	        }
	        // Release the tab bar's hold on the mouse.
	        sender.releaseMouse();
	        // Extract the data from the args.
	        var index = args.index, title = args.title, tab = args.tab, clientX = args.clientX, clientY = args.clientY;
	        // Setup the mime data for the drag operation.
	        var mimeData = new mimedata_1.MimeData();
	        var widget = title.owner;
	        mimeData.setData(FACTORY_MIME, function () { return widget; });
	        // Create the drag image for the drag operation.
	        var dragImage = tab.cloneNode(true);
	        // Create the drag object to manage the drag-drop operation.
	        this._drag = new dragdrop_1.Drag({
	            mimeData: mimeData,
	            dragImage: dragImage,
	            proposedAction: 'move',
	            supportedActions: 'move',
	        });
	        // Hide the tab node in the original tab.
	        tab.classList.add(HIDDEN_CLASS);
	        // Create the cleanup callback.
	        var cleanup = (function () {
	            _this._drag = null;
	            tab.classList.remove(HIDDEN_CLASS);
	        });
	        // Start the drag operation and cleanup when done.
	        this._drag.start(clientX, clientY).then(cleanup);
	    };
	    /**
	     * Handle the `widgetRemoved` signal from a stacked panel.
	     */
	    DockPanel.prototype._onWidgetRemoved = function (sender, widget) {
	        this._widgets.remove(widget);
	        this._tracker.remove(widget);
	        if (sender.widgets.length === 0) {
	            this._removeTabPanel(sender.parent);
	        }
	    };
	    /**
	     * Handle the `currentChanged` signal from the focus tracker.
	     */
	    DockPanel.prototype._onCurrentChanged = function (sender, args) {
	        this.currentChanged.emit(args);
	    };
	    return DockPanel;
	}(widget_1.Widget));
	exports.DockPanel = DockPanel;
	// Define the signals for the `FocusTracker` class.
	signaling_1.defineSignal(DockPanel.prototype, 'currentChanged');
	/**
	 * The namespace for the `DockPanel` class statics.
	 */
	var DockPanel;
	(function (DockPanel) {
	    /**
	     * A concrete implementation of `IOverlay`.
	     *
	     * This is the default overlay implementation for a dock panel.
	     */
	    var Overlay = (function () {
	        /**
	         * Construct a new overlay.
	         */
	        function Overlay() {
	            this._timer = -1;
	            this._hidden = true;
	            this._zone = 'invalid';
	            this._node = document.createElement('div');
	            this._node.classList.add(OVERLAY_CLASS);
	            this._node.classList.add(HIDDEN_CLASS);
	            this._node.style.position = 'absolute';
	        }
	        Object.defineProperty(Overlay.prototype, "node", {
	            /**
	             * The DOM node for the overlay.
	             *
	             * #### Notes
	             * This is a read-only property.
	             */
	            get: function () {
	                return this._node;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        /**
	         * Show the overlay using the given overlay geometry.
	         *
	         * @param geo - The desired geometry for the overlay.
	         */
	        Overlay.prototype.show = function (geo) {
	            // Update the position of the overlay.
	            var style = this._node.style;
	            style.top = geo.top + "px";
	            style.left = geo.left + "px";
	            style.right = geo.right + "px";
	            style.bottom = geo.bottom + "px";
	            // Update the class name for the zone.
	            this._setZone(geo.zone);
	            // Clear any pending hide timer.
	            clearTimeout(this._timer);
	            this._timer = -1;
	            // If the overlay is already visible, we're done.
	            if (!this._hidden) {
	                return;
	            }
	            // Clear the hidden flag.
	            this._hidden = false;
	            // Finally, show the overlay.
	            this._node.classList.remove(HIDDEN_CLASS);
	        };
	        /**
	         * Hide the overlay node.
	         *
	         * @param delay - The delay (in ms) before hiding the overlay.
	         *   A delay value <= 0 will hide the overlay immediately.
	         */
	        Overlay.prototype.hide = function (delay) {
	            var _this = this;
	            // Do nothing if the overlay is already hidden.
	            if (this._hidden) {
	                return;
	            }
	            // Hide immediately if the delay is <= 0.
	            if (delay <= 0) {
	                clearTimeout(this._timer);
	                this._timer = -1;
	                this._hidden = true;
	                this._node.classList.add(HIDDEN_CLASS);
	                return;
	            }
	            // Do nothing if a hide is already pending.
	            if (this._timer !== -1) {
	                return;
	            }
	            // Otherwise setup the hide timer.
	            this._timer = setTimeout(function () {
	                _this._timer = -1;
	                _this._hidden = true;
	                _this._node.classList.add(HIDDEN_CLASS);
	            }, delay);
	        };
	        /**
	         * Set the dock zone for the overlay.
	         */
	        Overlay.prototype._setZone = function (newZone) {
	            var oldZone = this._zone;
	            if (oldZone === newZone) {
	                return;
	            }
	            var oldClass = oldZone !== 'invalid' ? "p-mod-" + oldZone : '';
	            var newClass = newZone !== 'invalid' ? "p-mod-" + newZone : '';
	            if (oldClass)
	                this._node.classList.remove(oldClass);
	            if (newClass)
	                this._node.classList.add(newClass);
	            this._zone = newZone;
	        };
	        return Overlay;
	    }());
	    DockPanel.Overlay = Overlay;
	})(DockPanel = exports.DockPanel || (exports.DockPanel = {}));
	/**
	 * The namespace for the module private data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Clamp a spacing value to an integer >= 0.
	     */
	    function clampSpacing(value) {
	        return Math.max(0, Math.floor(value));
	    }
	    Private.clampSpacing = clampSpacing;
	    /**
	     * Get the root zone for the given node and client position.
	     *
	     * This assumes the position lies within the node's client rect.
	     *
	     * Returns the `'invalid'` zone if the position is not within an edge.
	     */
	    function getRootZone(node, x, y) {
	        var zone;
	        var rect = node.getBoundingClientRect();
	        if (x < rect.left + EDGE_SIZE) {
	            if (y - rect.top < x - rect.left) {
	                zone = 'root-top';
	            }
	            else if (rect.bottom - y < x - rect.left) {
	                zone = 'root-bottom';
	            }
	            else {
	                zone = 'root-left';
	            }
	        }
	        else if (x >= rect.right - EDGE_SIZE) {
	            if (y - rect.top < rect.right - x) {
	                zone = 'root-top';
	            }
	            else if (rect.bottom - y < rect.right - x) {
	                zone = 'root-bottom';
	            }
	            else {
	                zone = 'root-right';
	            }
	        }
	        else if (y < rect.top + EDGE_SIZE) {
	            zone = 'root-top';
	        }
	        else if (y >= rect.bottom - EDGE_SIZE) {
	            zone = 'root-bottom';
	        }
	        else {
	            zone = 'invalid';
	        }
	        return zone;
	    }
	    Private.getRootZone = getRootZone;
	    /**
	     * Get the panel zone for the given node and position.
	     *
	     * This assumes the position lies within the node's client rect.
	     *
	     * This always returns a valid zone.
	     */
	    function getPanelZone(node, x, y) {
	        var zone;
	        var rect = node.getBoundingClientRect();
	        var fracX = (x - rect.left) / rect.width;
	        var fracY = (y - rect.top) / rect.height;
	        if (fracX < 1 / 3) {
	            if (fracY < fracX) {
	                zone = 'panel-top';
	            }
	            else if (1 - fracY < fracX) {
	                zone = 'panel-bottom';
	            }
	            else {
	                zone = 'panel-left';
	            }
	        }
	        else if (fracX < 2 / 3) {
	            if (fracY < 1 / 3) {
	                zone = 'panel-top';
	            }
	            else if (fracY < 2 / 3) {
	                zone = 'panel-center';
	            }
	            else {
	                zone = 'panel-bottom';
	            }
	        }
	        else {
	            if (fracY < 1 - fracX) {
	                zone = 'panel-top';
	            }
	            else if (fracY > fracX) {
	                zone = 'panel-bottom';
	            }
	            else {
	                zone = 'panel-right';
	            }
	        }
	        return zone;
	    }
	    Private.getPanelZone = getPanelZone;
	})(Private || (Private = {}));


/***/ },
/* 29 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * An object which stores MIME data for general application use.
	 *
	 * #### Notes
	 * This class does not attempt to enforce "correctness" of MIME types
	 * and their associated data. Since this class is designed to transfer
	 * arbitrary data and objects within the same application, it assumes
	 * that the user provides correct and accurate data.
	 */
	var MimeData = (function () {
	    function MimeData() {
	        this._types = [];
	        this._values = [];
	    }
	    /**
	     * Get an array of the MIME types contained within the dataset.
	     *
	     * @returns A new array of the MIME types, in order of insertion.
	     */
	    MimeData.prototype.types = function () {
	        return this._types.slice();
	    };
	    /**
	     * Test whether the dataset has an entry for the given type.
	     *
	     * @param mime - The MIME type of interest.
	     *
	     * @returns `true` if the dataset contains a value for the given
	     *   MIME type, `false` otherwise.
	     */
	    MimeData.prototype.hasData = function (mime) {
	        return this._types.indexOf(mime) !== -1;
	    };
	    /**
	     * Get the data value for the given MIME type.
	     *
	     * @param mime - The MIME type of interest.
	     *
	     * @returns The value for the given MIME type, or `undefined` if
	     *   the dataset does not contain a value for the type.
	     */
	    MimeData.prototype.getData = function (mime) {
	        var i = this._types.indexOf(mime);
	        return i !== -1 ? this._values[i] : void 0;
	    };
	    /**
	     * Set the data value for the given MIME type.
	     *
	     * @param mime - The MIME type of interest.
	     *
	     * @param data - The data value for the given MIME type.
	     *
	     * #### Notes
	     * This will overwrite any previous entry for the MIME type.
	     */
	    MimeData.prototype.setData = function (mime, data) {
	        this.clearData(mime);
	        this._types.push(mime);
	        this._values.push(data);
	    };
	    /**
	     * Remove the data entry for the given MIME type.
	     *
	     * @param mime - The MIME type of interest.
	     *
	     * #### Notes
	     * This is a no-op if there is no entry for the given MIME type.
	     */
	    MimeData.prototype.clearData = function (mime) {
	        var i = this._types.indexOf(mime);
	        if (i === -1)
	            return;
	        this._types.splice(i, 1);
	        this._values.splice(i, 1);
	    };
	    /**
	     * Remove all data entries from the dataset.
	     */
	    MimeData.prototype.clear = function () {
	        this._types.length = 0;
	        this._values.length = 0;
	    };
	    return MimeData;
	}());
	exports.MimeData = MimeData;


/***/ },
/* 30 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var cursor_1 = __webpack_require__(31);
	/**
	 * The class name added to drag image nodes.
	 */
	var DRAG_IMAGE_CLASS = 'p-mod-drag-image';
	/**
	 * An object which manages a drag-drop operation.
	 *
	 * A drag object dispatches four different events to drop targets:
	 *
	 * - `'p-dragenter'` - Dispatched when the mouse enters the target
	 *   element. This event must be canceled in order to receive any
	 *   of the other events.
	 *
	 * - `'p-dragover'` - Dispatched when the mouse moves over the drop
	 *   target. It must cancel the event and set the `dropAction` to one
	 *   of the supported actions in order to receive drop events.
	 *
	 * - `'p-dragleave'` - Dispatched when the mouse leaves the target
	 *   element. This includes moving the mouse into child elements.
	 *
	 * - `'p-drop'`- Dispatched when the mouse is released over the target
	 *   element when the target indicates an appropriate drop action. If
	 *   the event is canceled, the indicated drop action is returned to
	 *   the initiator through the resolved promise.
	 *
	 * A drag operation can be canceled at any time by pressing `Escape`
	 * or by disposing the drag object.
	 *
	 * #### Notes
	 * This class is designed to be used when dragging and dropping custom
	 * data *within* a single application. It is *not* a replacement for
	 * the native drag-drop API. Instead, it provides an API which allows
	 * drag operations to be initiated programmatically and enables the
	 * transfer of arbitrary non-string objects; two features which are
	 * not possible with the native drag-drop APIs.
	 */
	var Drag = (function () {
	    /**
	     * Construct a new drag object.
	     *
	     * @param options - The options for initializing the drag.
	     */
	    function Drag(options) {
	        this._disposed = false;
	        this._source = null;
	        this._mimeData = null;
	        this._dragImage = null;
	        this._dropAction = 'none';
	        this._proposedAction = 'copy';
	        this._supportedActions = 'all';
	        this._override = null;
	        this._currentTarget = null;
	        this._currentElement = null;
	        this._promise = null;
	        this._resolve = null;
	        this._mimeData = options.mimeData;
	        if (options.dragImage !== void 0) {
	            this._dragImage = options.dragImage;
	        }
	        if (options.proposedAction !== void 0) {
	            this._proposedAction = options.proposedAction;
	        }
	        if (options.supportedActions !== void 0) {
	            this._supportedActions = options.supportedActions;
	        }
	        if (options.source !== void 0) {
	            this._source = options.source;
	        }
	    }
	    /**
	     * Dispose of the resources held by the drag object.
	     *
	     * #### Notes
	     * This will cancel the drag operation if it is active.
	     *
	     * All calls made after the first call to this method are a no-op.
	     */
	    Drag.prototype.dispose = function () {
	        // Do nothing if the drag object is already disposed.
	        if (this._disposed) {
	            return;
	        }
	        this._disposed = true;
	        // If there is a current target, dispatch a drag leave event.
	        if (this._currentTarget) {
	            var event_1 = Private.createMouseEvent('mouseup', -1, -1);
	            Private.dispatchDragLeave(this, this._currentTarget, null, event_1);
	        }
	        // Finalize the drag object with `'none'`.
	        this._finalize('none');
	    };
	    Object.defineProperty(Drag.prototype, "isDisposed", {
	        /**
	         * Test whether the drag object is disposed.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._disposed;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Drag.prototype, "mimeData", {
	        /**
	         * Get the mime data for the drag object.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._mimeData;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Drag.prototype, "dragImage", {
	        /**
	         * Get the drag image element for the drag object.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._dragImage;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Drag.prototype, "proposedAction", {
	        /**
	         * Get the proposed drop action for the drag object.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._proposedAction;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Drag.prototype, "supportedActions", {
	        /**
	         * Get the supported drop actions for the drag object.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._supportedActions;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Drag.prototype, "source", {
	        /**
	         * Get the drag source for the drag object.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._source;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Start the drag operation at the specified client position.
	     *
	     * @param clientX - The client X position for the drag start.
	     *
	     * @param clientY - The client Y position for the drag start.
	     *
	     * @returns A promise which resolves to the result of the drag.
	     *
	     * #### Notes
	     * If the drag has already been started, the promise created by the
	     * first call to `start` is returned.
	     *
	     * If the drag operation has ended, or if the drag object has been
	     * disposed, the returned promise will resolve to `'none'`.
	     *
	     * The drag object will be automatically disposed when drag operation
	     * completes. This means `Drag` objects are for single-use only.
	     *
	     * This method assumes the left mouse button is already held down.
	     */
	    Drag.prototype.start = function (clientX, clientY) {
	        var _this = this;
	        // If the drag object is already disposed, resolve to `None`.
	        if (this._disposed) {
	            return Promise.resolve('none');
	        }
	        // If the drag has already been started, return the promise.
	        if (this._promise) {
	            return this._promise;
	        }
	        // Install the document listeners for the drag object.
	        this._addListeners();
	        // Attach the drag image at the specified client position.
	        this._attachDragImage(clientX, clientY);
	        // Create the promise which will be resolved on completion.
	        this._promise = new Promise(function (resolve, reject) {
	            _this._resolve = resolve;
	        });
	        // Trigger a fake move event to kick off the drag operation.
	        var event = Private.createMouseEvent('mousemove', clientX, clientY);
	        document.dispatchEvent(event);
	        // Return the pending promise for the drag operation.
	        return this._promise;
	    };
	    /**
	     * Handle the DOM events for the drag operation.
	     *
	     * @param event - The DOM event sent to the drag object.
	     *
	     * #### Notes
	     * This method implements the DOM `EventListener` interface and is
	     * called in response to events on the document. It should not be
	     * called directly by user code.
	     */
	    Drag.prototype.handleEvent = function (event) {
	        switch (event.type) {
	            case 'mousemove':
	                this._evtMouseMove(event);
	                break;
	            case 'mouseup':
	                this._evtMouseUp(event);
	                break;
	            case 'keydown':
	                this._evtKeyDown(event);
	                break;
	            default:
	                // Stop all other events during drag-drop.
	                event.preventDefault();
	                event.stopPropagation();
	                break;
	        }
	    };
	    /**
	     * Handle the `'mousemove'` event for the drag object.
	     */
	    Drag.prototype._evtMouseMove = function (event) {
	        // Stop all input events during drag-drop.
	        event.preventDefault();
	        event.stopPropagation();
	        // Update the current target node and dispatch enter/leave events.
	        this._updateCurrentTarget(event);
	        // Move the drag image to the specified client position. This is
	        // performed *after* dispatching to prevent unnecessary reflows.
	        this._moveDragImage(event.clientX, event.clientY);
	    };
	    /**
	     * Handle the `'mouseup'` event for the drag object.
	     */
	    Drag.prototype._evtMouseUp = function (event) {
	        // Stop all input events during drag-drop.
	        event.preventDefault();
	        event.stopPropagation();
	        // Do nothing if the left button is not released.
	        if (event.button !== 0) {
	            return;
	        }
	        // Update the current target node and dispatch enter/leave events.
	        // This prevents a subtle issue where the DOM mutates under the
	        // cursor after the last move event but before the drop event.
	        this._updateCurrentTarget(event);
	        // If there is no current target, finalize with `'none'`.
	        if (!this._currentTarget) {
	            this._finalize('none');
	            return;
	        }
	        // If the last drop action was `'none'`, dispatch a leave event
	        // to the current target and finalize the drag with `'none'`.
	        if (this._dropAction === 'none') {
	            Private.dispatchDragLeave(this, this._currentTarget, null, event);
	            this._finalize('none');
	            return;
	        }
	        // Dispatch the drop event at the current target and finalize
	        // with the resulting drop action.
	        var action = Private.dispatchDrop(this, this._currentTarget, event);
	        this._finalize(action);
	    };
	    /**
	     * Handle the `'keydown'` event for the drag object.
	     */
	    Drag.prototype._evtKeyDown = function (event) {
	        // Stop all input events during drag-drop.
	        event.preventDefault();
	        event.stopPropagation();
	        // Cancel the drag if `Escape` is pressed.
	        if (event.keyCode === 27)
	            this.dispose();
	    };
	    /**
	     * Add the document event listeners for the drag object.
	     */
	    Drag.prototype._addListeners = function () {
	        document.addEventListener('mousedown', this, true);
	        document.addEventListener('mousemove', this, true);
	        document.addEventListener('mouseup', this, true);
	        document.addEventListener('mouseenter', this, true);
	        document.addEventListener('mouseleave', this, true);
	        document.addEventListener('mouseover', this, true);
	        document.addEventListener('mouseout', this, true);
	        document.addEventListener('keydown', this, true);
	        document.addEventListener('keyup', this, true);
	        document.addEventListener('keypress', this, true);
	        document.addEventListener('contextmenu', this, true);
	    };
	    /**
	     * Remove the document event listeners for the drag object.
	     */
	    Drag.prototype._removeListeners = function () {
	        document.removeEventListener('mousedown', this, true);
	        document.removeEventListener('mousemove', this, true);
	        document.removeEventListener('mouseup', this, true);
	        document.removeEventListener('mouseenter', this, true);
	        document.removeEventListener('mouseleave', this, true);
	        document.removeEventListener('mouseover', this, true);
	        document.removeEventListener('mouseout', this, true);
	        document.removeEventListener('keydown', this, true);
	        document.removeEventListener('keyup', this, true);
	        document.removeEventListener('keypress', this, true);
	        document.removeEventListener('contextmenu', this, true);
	    };
	    /**
	     * Update the current target node using the given mouse event.
	     */
	    Drag.prototype._updateCurrentTarget = function (event) {
	        // Fetch common local state.
	        var prevTarget = this._currentTarget;
	        var currTarget = this._currentTarget;
	        var prevElem = this._currentElement;
	        // Find the current indicated element at the given position.
	        var currElem = document.elementFromPoint(event.clientX, event.clientY);
	        // Update the current element reference.
	        this._currentElement = currElem;
	        // Note: drag enter fires *before* drag leave according to spec.
	        // https://html.spec.whatwg.org/multipage/interaction.html#drag-and-drop-processing-model
	        // If the indicated element changes from the previous iteration,
	        // and is different from the current target, dispatch the enter
	        // events and compute the new target element.
	        if (currElem !== prevElem && currElem !== currTarget) {
	            currTarget = Private.dispatchDragEnter(this, currElem, currTarget, event);
	        }
	        // If the current target element has changed, update the current
	        // target reference and dispatch the leave event to the old target.
	        if (currTarget !== prevTarget) {
	            this._currentTarget = currTarget;
	            Private.dispatchDragLeave(this, prevTarget, currTarget, event);
	        }
	        // Dispatch the drag over event and update the drop action.
	        var action = Private.dispatchDragOver(this, currTarget, event);
	        this._setDropAction(action);
	    };
	    /**
	     * Attach the drag image element at the specified location.
	     *
	     * This is a no-op if there is no drag image element.
	     */
	    Drag.prototype._attachDragImage = function (clientX, clientY) {
	        if (!this._dragImage) {
	            return;
	        }
	        this._dragImage.classList.add(DRAG_IMAGE_CLASS);
	        var style = this._dragImage.style;
	        style.pointerEvents = 'none';
	        style.position = 'absolute';
	        style.top = clientY + "px";
	        style.left = clientX + "px";
	        document.body.appendChild(this._dragImage);
	    };
	    /**
	     * Move the drag image element to the specified location.
	     *
	     * This is a no-op if there is no drag image element.
	     */
	    Drag.prototype._moveDragImage = function (clientX, clientY) {
	        if (!this._dragImage) {
	            return;
	        }
	        var style = this._dragImage.style;
	        style.top = clientY + "px";
	        style.left = clientX + "px";
	    };
	    /**
	     * Detach the drag image element from the DOM.
	     *
	     * This is a no-op if there is no drag image element.
	     */
	    Drag.prototype._detachDragImage = function () {
	        if (!this._dragImage) {
	            return;
	        }
	        var parent = this._dragImage.parentNode;
	        if (!parent) {
	            return;
	        }
	        parent.removeChild(this._dragImage);
	    };
	    /**
	     * Set the internal drop action state and update the drag cursor.
	     */
	    Drag.prototype._setDropAction = function (action) {
	        action = Private.validateAction(action, this._supportedActions);
	        if (this._override && this._dropAction === action) {
	            return;
	        }
	        switch (action) {
	            case 'none':
	                this._dropAction = action;
	                this._override = cursor_1.overrideCursor('no-drop');
	                break;
	            case 'copy':
	                this._dropAction = action;
	                this._override = cursor_1.overrideCursor('copy');
	                break;
	            case 'link':
	                this._dropAction = action;
	                this._override = cursor_1.overrideCursor('alias');
	                break;
	            case 'move':
	                this._dropAction = action;
	                this._override = cursor_1.overrideCursor('move');
	                break;
	        }
	    };
	    /**
	     * Finalize the drag operation and resolve the drag promise.
	     */
	    Drag.prototype._finalize = function (action) {
	        // Store the resolve function as a temp variable.
	        var resolve = this._resolve;
	        // Remove the document event listeners.
	        this._removeListeners();
	        // Detach the drag image.
	        this._detachDragImage();
	        // Dispose of the cursor override.
	        if (this._override)
	            this._override.dispose();
	        // Clear the mime data.
	        if (this._mimeData)
	            this._mimeData.clear();
	        // Clear the internal drag state.
	        this._disposed = true;
	        this._source = null;
	        this._mimeData = null;
	        this._dragImage = null;
	        this._dropAction = 'none';
	        this._proposedAction = 'none';
	        this._supportedActions = 'none';
	        this._override = null;
	        this._currentTarget = null;
	        this._currentElement = null;
	        this._promise = null;
	        this._resolve = null;
	        // Resolve the promise to the given drop action, if possible.
	        if (resolve)
	            resolve(action);
	    };
	    return Drag;
	}());
	exports.Drag = Drag;
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Validate the given action is one of the supported actions.
	     *
	     * Returns the given action or `'none'` if the action is unsupported.
	     */
	    function validateAction(action, supported) {
	        var a = actionTable[action];
	        var b = supportedTable[supported];
	        return (a & b) ? action : 'none';
	    }
	    Private.validateAction = validateAction;
	    /**
	     * Create a left mouse event at the given position.
	     *
	     * @param type - The event type for the mouse event.
	     *
	     * @param clientX - The client X position.
	     *
	     * @param clientY - The client Y position.
	     *
	     * @returns A newly created and initialized mouse event.
	     */
	    function createMouseEvent(type, clientX, clientY) {
	        var event = document.createEvent('MouseEvent');
	        event.initMouseEvent(type, true, true, window, 0, 0, 0, clientX, clientY, false, false, false, false, 0, null);
	        return event;
	    }
	    Private.createMouseEvent = createMouseEvent;
	    /**
	     * Dispatch a drag enter event to the indicated element.
	     *
	     * @param drag - The drag object associated with the action.
	     *
	     * @param currElem - The currently indicated element, or `null`. This
	     *   is the "immediate user selection" from the whatwg spec.
	     *
	     * @param currTarget - The current drag target element, or `null`. This
	     *   is the "current target element" from the whatwg spec.
	     *
	     * @param event - The mouse event related to the action.
	     *
	     * @returns The element to use as the current drag target. This is the
	     *   "current target element" from the whatwg spec, and may be `null`.
	     *
	     * #### Notes
	     * This largely implements the drag enter portion of the whatwg spec:
	     * https://html.spec.whatwg.org/multipage/interaction.html#drag-and-drop-processing-model
	     */
	    function dispatchDragEnter(drag, currElem, currTarget, event) {
	        // If the current element is null, return null as the new target.
	        if (!currElem) {
	            return null;
	        }
	        // Dispatch a drag enter event to the current element.
	        var dragEvent = createDragEvent('p-dragenter', drag, event, currTarget);
	        var canceled = !currElem.dispatchEvent(dragEvent);
	        // If the event was canceled, use the current element as the new target.
	        if (canceled) {
	            return currElem;
	        }
	        // If the current element is the document body, keep the original target.
	        if (currElem === document.body) {
	            return currTarget;
	        }
	        // Dispatch a drag enter event on the document body.
	        dragEvent = createDragEvent('p-dragenter', drag, event, currTarget);
	        document.body.dispatchEvent(dragEvent);
	        // Ignore the event cancellation, and use the body as the new target.
	        return document.body;
	    }
	    Private.dispatchDragEnter = dispatchDragEnter;
	    /**
	     * Dispatch a drag leave event to the indicated element.
	     *
	     * @param drag - The drag object associated with the action.
	     *
	     * @param prevTarget - The previous target element, or `null`. This
	     *   is the previous "current target element" from the whatwg spec.
	     *
	     * @param currTarget - The current drag target element, or `null`. This
	     *   is the "current target element" from the whatwg spec.
	     *
	     * @param event - The mouse event related to the action.
	     *
	     * #### Notes
	     * This largely implements the drag leave portion of the whatwg spec:
	     * https://html.spec.whatwg.org/multipage/interaction.html#drag-and-drop-processing-model
	     */
	    function dispatchDragLeave(drag, prevTarget, currTarget, event) {
	        // If the previous target is null, do nothing.
	        if (!prevTarget) {
	            return;
	        }
	        // Dispatch the drag leave event to the previous target.
	        var dragEvent = createDragEvent('p-dragleave', drag, event, currTarget);
	        prevTarget.dispatchEvent(dragEvent);
	    }
	    Private.dispatchDragLeave = dispatchDragLeave;
	    /**
	     * Dispatch a drag over event to the indicated element.
	     *
	     * @param drag - The drag object associated with the action.
	     *
	     * @param currTarget - The current drag target element, or `null`. This
	     *   is the "current target element" from the whatwg spec.
	     *
	     * @param event - The mouse event related to the action.
	     *
	     * @returns The `DropAction` result of the drag over event.
	     *
	     * #### Notes
	     * This largely implements the drag over portion of the whatwg spec:
	     * https://html.spec.whatwg.org/multipage/interaction.html#drag-and-drop-processing-model
	     */
	    function dispatchDragOver(drag, currTarget, event) {
	        // If there is no current target, the drop action is none.
	        if (!currTarget) {
	            return 'none';
	        }
	        // Dispatch the drag over event to the current target.
	        var dragEvent = createDragEvent('p-dragover', drag, event, null);
	        var canceled = !currTarget.dispatchEvent(dragEvent);
	        // If the event was canceled, return the drop action result.
	        if (canceled) {
	            return dragEvent.dropAction;
	        }
	        // Otherwise, the effective drop action is none.
	        return 'none';
	    }
	    Private.dispatchDragOver = dispatchDragOver;
	    /**
	     * Dispatch a drop event to the indicated element.
	     *
	     * @param drag - The drag object associated with the action.
	     *
	     * @param currTarget - The current drag target element, or `null`. This
	     *   is the "current target element" from the whatwg spec.
	     *
	     * @param event - The mouse event related to the action.
	     *
	     * @returns The `DropAction` result of the drop event.
	     *
	     * #### Notes
	     * This largely implements the drag over portion of the whatwg spec:
	     * https://html.spec.whatwg.org/multipage/interaction.html#drag-and-drop-processing-model
	     */
	    function dispatchDrop(drag, currTarget, event) {
	        // If there is no current target, the drop action is none.
	        if (!currTarget) {
	            return 'none';
	        }
	        // Dispatch the drop event to the current target.
	        var dragEvent = createDragEvent('p-drop', drag, event, null);
	        var canceled = !currTarget.dispatchEvent(dragEvent);
	        // If the event was canceled, return the drop action result.
	        if (canceled) {
	            return dragEvent.dropAction;
	        }
	        // Otherwise, the effective drop action is none.
	        return 'none';
	    }
	    Private.dispatchDrop = dispatchDrop;
	    /**
	     * A lookup table from drop action to bit value.
	     */
	    var actionTable = {
	        'none': 0x0,
	        'copy': 0x1,
	        'link': 0x2,
	        'move': 0x4
	    };
	    /**
	     * A lookup table from supported action to drop action bit mask.
	     */
	    var supportedTable = {
	        'none': actionTable['none'],
	        'copy': actionTable['copy'],
	        'link': actionTable['link'],
	        'move': actionTable['move'],
	        'copy-link': actionTable['copy'] | actionTable['link'],
	        'copy-move': actionTable['copy'] | actionTable['move'],
	        'link-move': actionTable['link'] | actionTable['move'],
	        'all': actionTable['copy'] | actionTable['link'] | actionTable['move']
	    };
	    /**
	     * Create a new initialized `IDragEvent` from the given data.
	     *
	     * @param type - The event type for the drag event.
	     *
	     * @param drag - The drag object to use for seeding the drag data.
	     *
	     * @param event - The mouse event to use for seeding the mouse data.
	     *
	     * @param related - The related target for the event, or `null`.
	     *
	     * @returns A new object which implements `IDragEvent`.
	     */
	    function createDragEvent(type, drag, event, related) {
	        // Create a new mouse event and cast to a custom drag event.
	        var dragEvent = document.createEvent('MouseEvent');
	        // Initialize the mouse event data.
	        dragEvent.initMouseEvent(type, true, true, window, 0, event.screenX, event.screenY, event.clientX, event.clientY, event.ctrlKey, event.altKey, event.shiftKey, event.metaKey, event.button, related);
	        // Add the custom drag event data.
	        dragEvent.dropAction = 'none';
	        dragEvent.mimeData = drag.mimeData;
	        dragEvent.proposedAction = drag.proposedAction;
	        dragEvent.supportedActions = drag.supportedActions;
	        dragEvent.source = drag.source;
	        // Return the fully initialized drag event.
	        return dragEvent;
	    }
	})(Private || (Private = {}));


/***/ },
/* 31 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var disposable_1 = __webpack_require__(4);
	/**
	 * The class name added to the document body during cursor override.
	 */
	var OVERRIDE_CURSOR_CLASS = 'p-mod-override-cursor';
	/**
	 * Override the cursor for the entire document.
	 *
	 * @param cursor - The string representing the cursor style.
	 *
	 * @returns A disposable which will clear the override when disposed.
	 *
	 * #### Notes
	 * The most recent call to `overrideCursor` takes precedence. Disposing
	 * an old override is a no-op and will not effect the current override.
	 *
	 * #### Example
	 * ```typescript
	 * import { overrideCursor } from 'phosphor/lib/dom/cursor';
	 *
	 * // force the cursor to be 'wait' for the entire document
	 * let override = overrideCursor('wait');
	 *
	 * // clear the override by disposing the return value
	 * override.dispose();
	 * ```
	 */
	function overrideCursor(cursor) {
	    var id = ++Private.cursorID;
	    var body = document.body;
	    body.style.cursor = cursor;
	    body.classList.add(OVERRIDE_CURSOR_CLASS);
	    return new disposable_1.DisposableDelegate(function () {
	        if (id === Private.cursorID) {
	            body.style.cursor = '';
	            body.classList.remove(OVERRIDE_CURSOR_CLASS);
	        }
	    });
	}
	exports.overrideCursor = overrideCursor;
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * The id for the active cursor override.
	     */
	    Private.cursorID = 0;
	})(Private || (Private = {}));


/***/ },
/* 32 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * Test whether a client position lies within a node.
	 *
	 * @param node - The DOM node of interest.
	 *
	 * @param clientX - The client X coordinate of interest.
	 *
	 * @param clientY - The client Y coordinate of interest.
	 *
	 * @returns `true` if the node covers the position, `false` otherwise.
	 *
	 * #### Example
	 * ```typescript
	 * import { hitTest } from 'phosphor/lib/dom/query';
	 *
	 * let div = document.createElement('div');
	 * div.style.position = 'absolute';
	 * div.style.left = '0px';
	 * div.style.top = '0px';
	 * div.style.width = '100px';
	 * div.style.height = '100px';
	 * document.body.appendChild(div);
	 *
	 * hitTest(div, 50, 50);   // true
	 * hitTest(div, 150, 150); // false
	 * ```
	 */
	function hitTest(node, clientX, clientY) {
	    var rect = node.getBoundingClientRect();
	    return (clientX >= rect.left &&
	        clientX < rect.right &&
	        clientY >= rect.top &&
	        clientY < rect.bottom);
	}
	exports.hitTest = hitTest;
	/**
	 * Vertically scroll an element into view if needed.
	 *
	 * @param area - The scroll area element.
	 *
	 * @param elem - The element of interest.
	 *
	 * #### Notes
	 * This follows the "nearest" behavior of the native `scrollIntoView`
	 * method, which is not supported by all browsers.
	 * https://drafts.csswg.org/cssom-view/#element-scrolling-members
	 *
	 * If the element fully covers the visible area or is fully contained
	 * within the visible area, no scrolling will take place. Otherwise,
	 * the nearest edges of the area and element are aligned.
	 *
	 * #### Example
	 * ```typescript
	 * import { scrollIntoViewIfNeeded } from 'phosphor/lib/dom/query';
	 *
	 * let area = document.createElement('div');
	 * let elem = document.createElement('div');
	 *
	 * // Style the scrollable area with a small height and a black border.
	 * area.style.height = '100px';
	 * area.style.overflow = 'auto';
	 * area.style.border = '1px solid black';
	 *
	 * // Style the element of interest with a red border and some content.
	 * elem.style.border = '1px solid red';
	 * elem.textContent = 'visible content';
	 *
	 * // Add enough whitespace to to guarantee scrolling.
	 * for (let i = 0; i < 50; i++) {
	 *   area.appendChild(document.createElement('br'));
	 * }
	 *
	 * // Attach the nodes to the DOM.
	 * area.appendChild(elem);
	 * document.body.appendChild(area);
	 *
	 * // Scroll to the element of interest.
	 * scrollIntoViewIfNeeded(area, elem);
	 * ```
	 */
	function scrollIntoViewIfNeeded(area, elem) {
	    var ar = area.getBoundingClientRect();
	    var er = elem.getBoundingClientRect();
	    if (er.top <= ar.top && er.bottom >= ar.bottom) {
	        return;
	    }
	    if (er.top < ar.top && er.height <= ar.height) {
	        area.scrollTop -= ar.top - er.top;
	        return;
	    }
	    if (er.bottom > ar.bottom && er.height >= ar.height) {
	        area.scrollTop -= ar.top - er.top;
	        return;
	    }
	    if (er.top < ar.top && er.height > ar.height) {
	        area.scrollTop -= ar.bottom - er.bottom;
	        return;
	    }
	    if (er.bottom > ar.bottom && er.height < ar.height) {
	        area.scrollTop -= ar.bottom - er.bottom;
	        return;
	    }
	}
	exports.scrollIntoViewIfNeeded = scrollIntoViewIfNeeded;


/***/ },
/* 33 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var iteration_1 = __webpack_require__(5);
	var searching_1 = __webpack_require__(11);
	var vector_1 = __webpack_require__(13);
	var signaling_1 = __webpack_require__(6);
	/**
	 * A class which tracks focus among a set of widgets.
	 *
	 * This class is useful when code needs to keep track of the most
	 * recently focused widget(s) among a set of related widgets.
	 */
	var FocusTracker = (function () {
	    /**
	     * Construct a new focus tracker.
	     */
	    function FocusTracker() {
	        this._counter = 0;
	        this._currentWidget = null;
	        this._widgets = new vector_1.Vector();
	        this._numbers = new Map();
	        this._nodes = new Map();
	    }
	    /**
	     * Dispose of the resources held by the tracker.
	     */
	    FocusTracker.prototype.dispose = function () {
	        var _this = this;
	        // Do nothing if the tracker is already disposed.
	        if (this._counter < 0) {
	            return;
	        }
	        // Mark the tracker as disposed.
	        this._counter = -1;
	        // Clear the connections for the tracker.
	        signaling_1.clearSignalData(this);
	        // Remove all event listeners.
	        iteration_1.each(this._widgets, function (widget) {
	            widget.node.removeEventListener('focus', _this, true);
	        });
	        // Clear the internal data structures.
	        this._currentWidget = null;
	        this._nodes.clear();
	        this._numbers.clear();
	        this._widgets.clear();
	    };
	    Object.defineProperty(FocusTracker.prototype, "isDisposed", {
	        /**
	         * A flag indicated whether the tracker is disposed.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._counter < 0;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(FocusTracker.prototype, "currentWidget", {
	        /**
	         * The current widget in the tracker.
	         *
	         * #### Notes
	         * The current widget is the widget among the tracked widgets which
	         * has the *descendant node* which has most recently been focused.
	         *
	         * The current widget will not be updated if the node loses focus. It
	         * will only be updated when a different tracked widget gains focus.
	         *
	         * If the current widget is removed from the tracker, the previous
	         * current widget will be restored.
	         *
	         * This behavior is intended to follow a user's conceptual model of
	         * a semantically "active" widget, where the "last thing of type X"
	         * to be interacted with is the "active instance of X", regardless
	         * of whether that instance still has focus.
	         *
	         * This will be `null` if there is no current widget.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._currentWidget;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(FocusTracker.prototype, "widgets", {
	        /**
	         * A read only sequence of the widgets being tracked.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._widgets;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Get the focus number for a particular widget in the tracker.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns The focus number for the given widget, or `-1` if the
	     *   widget has not had focus since being added to the tracker.
	     *
	     * #### Notes
	     * The focus number indicates the relative order in which the widgets
	     * have gained focus. A widget with a larger number has gained focus
	     * more recently than a widget with a smaller number.
	     *
	     * The `currentWidget` will always have the largest focus number.
	     *
	     * All widgets start with a focus number of `-1`, which indicates that
	     * the widget has not been focused since being added to the tracker.
	     *
	     * #### Undefined Behavior
	     * A `widget` which is not contained in the tracker.
	     */
	    FocusTracker.prototype.focusNumber = function (widget) {
	        return this._numbers.get(widget);
	    };
	    /**
	     * Test whether the focus tracker contains a given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns `true` if the widget is tracked, `false` otherwise.
	     */
	    FocusTracker.prototype.has = function (widget) {
	        return this._numbers.has(widget);
	    };
	    /**
	     * Add a widget to the focus tracker.
	     *
	     * @param widget - The widget of interest.
	     *
	     * #### Notes
	     * If the widget is currently focused, it will automatically become
	     * the new `currentWidget`.
	     *
	     * A widget will be automatically removed from the tracker if it
	     * is disposed after being added.
	     *
	     * If the widget is already tracked, this is a no-op.
	     */
	    FocusTracker.prototype.add = function (widget) {
	        // Do nothing if the widget is already tracked.
	        if (this._numbers.has(widget)) {
	            return;
	        }
	        // Test whether this widget has focus.
	        var focused = widget.node.contains(document.activeElement);
	        // Setup the initial focus number.
	        var n = focused ? this._counter++ : -1;
	        // Add the widget to the internal data structures.
	        this._numbers.set(widget, n);
	        this._widgets.pushBack(widget);
	        this._nodes.set(widget.node, widget);
	        // Setup the focus event listener. The capturing phase must
	        // be used since the 'focus' event doesn't bubble and since
	        // firefox doesn't support the 'focusin' event.
	        widget.node.addEventListener('focus', this, true);
	        // Connect the disposed signal handler.
	        widget.disposed.connect(this._onWidgetDisposed, this);
	        // Update the current widget if the new widget has focus.
	        if (focused)
	            this._setCurrentWidget(widget);
	    };
	    /**
	     * Remove a widget from the focus tracker.
	     *
	     * #### Notes
	     * If the widget is the `currentWidget`, the previous current widget
	     * will become the new `currentWidget`.
	     *
	     * A widget will be automatically removed from the tracker if it
	     * is disposed after being added.
	     *
	     * If the widget is not tracked, this is a no-op.
	     */
	    FocusTracker.prototype.remove = function (widget) {
	        var _this = this;
	        // Do nothing if the widget is not tracked.
	        if (!this._numbers.has(widget)) {
	            return;
	        }
	        // Disconnect the disposed signal handler.
	        widget.disposed.disconnect(this._onWidgetDisposed, this);
	        // Remove the focus event listener.
	        widget.node.removeEventListener('focus', this, true);
	        // Remove the widget from the internal data structures.
	        this._widgets.remove(widget);
	        this._nodes.delete(widget.node);
	        this._numbers.delete(widget);
	        // If the widget is not the current widget, we're done.
	        if (this._currentWidget !== widget) {
	            return;
	        }
	        // Otherwise, filter the widgets for those which have had focus.
	        var valid = iteration_1.filter(this._widgets, function (w) { return _this._numbers.get(w) !== -1; });
	        // Get the valid widget with the max focus number.
	        var previous = searching_1.max(valid, function (first, second) {
	            var a = _this._numbers.get(first);
	            var b = _this._numbers.get(second);
	            return a - b;
	        }) || null;
	        // Finally, update the current widget.
	        this._setCurrentWidget(previous);
	    };
	    /**
	     * Handle the DOM events for the focus tracker.
	     *
	     * @param event - The DOM event sent to the panel.
	     *
	     * #### Notes
	     * This method implements the DOM `EventListener` interface and is
	     * called in response to events on the tracked nodes. It should
	     * not be called directly by user code.
	     */
	    FocusTracker.prototype.handleEvent = function (event) {
	        if (event.type === 'focus') {
	            this._evtFocus(event);
	        }
	    };
	    /**
	     * Set the current widget for the tracker.
	     */
	    FocusTracker.prototype._setCurrentWidget = function (widget) {
	        // Do nothing if there is no change.
	        if (this._currentWidget === widget) {
	            return;
	        }
	        // Swap the current widget.
	        var old = this._currentWidget;
	        this._currentWidget = widget;
	        // Emit the changed signal.
	        this.currentChanged.emit({ oldValue: old, newValue: widget });
	    };
	    /**
	     * Handle the `'focus'` event for a tracked widget.
	     */
	    FocusTracker.prototype._evtFocus = function (event) {
	        // Find the widget which gained focus.
	        var widget = this._nodes.get(event.currentTarget);
	        // Update the focus number for the widget.
	        this._numbers.set(widget, this._counter++);
	        // Update the current widget.
	        this._setCurrentWidget(widget);
	    };
	    /**
	     * Handle the `disposed` signal for a tracked widget.
	     */
	    FocusTracker.prototype._onWidgetDisposed = function (sender) {
	        this.remove(sender);
	    };
	    return FocusTracker;
	}());
	exports.FocusTracker = FocusTracker;
	// Define the signals for the `FocusTracker` class.
	signaling_1.defineSignal(FocusTracker.prototype, 'currentChanged');


/***/ },
/* 34 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var iteration_1 = __webpack_require__(5);
	var mutation_1 = __webpack_require__(24);
	var searching_1 = __webpack_require__(11);
	var vector_1 = __webpack_require__(13);
	var messaging_1 = __webpack_require__(18);
	var properties_1 = __webpack_require__(20);
	var cursor_1 = __webpack_require__(31);
	var platform_1 = __webpack_require__(14);
	var sizing_1 = __webpack_require__(25);
	var boxengine_1 = __webpack_require__(26);
	var panel_1 = __webpack_require__(27);
	var widget_1 = __webpack_require__(17);
	/**
	 * The class name added to SplitPanel instances.
	 */
	var SPLIT_PANEL_CLASS = 'p-SplitPanel';
	/**
	 * The class name added to split panel children.
	 */
	var CHILD_CLASS = 'p-SplitPanel-child';
	/**
	 * The class name added to split panel handles.
	 */
	var HANDLE_CLASS = 'p-SplitPanel-handle';
	/**
	 * The class name added to hidden split handles.
	 */
	var HIDDEN_CLASS = 'p-mod-hidden';
	/**
	 * The class name added to horizontal split panels.
	 */
	var HORIZONTAL_CLASS = 'p-mod-horizontal';
	/**
	 * The class name added to vertical split panels.
	 */
	var VERTICAL_CLASS = 'p-mod-vertical';
	/**
	 * A panel which arranges its widgets into resizable sections.
	 *
	 * #### Notes
	 * This class provides a convenience wrapper around a [[SplitLayout]].
	 */
	var SplitPanel = (function (_super) {
	    __extends(SplitPanel, _super);
	    /**
	     * Construct a new split panel.
	     *
	     * @param options - The options for initializing the split panel.
	     */
	    function SplitPanel(options) {
	        if (options === void 0) { options = {}; }
	        _super.call(this, { layout: Private.createLayout(options) });
	        this._pressData = null;
	        this.addClass(SPLIT_PANEL_CLASS);
	    }
	    /**
	     * Dispose of the resources held by the panel.
	     */
	    SplitPanel.prototype.dispose = function () {
	        this._releaseMouse();
	        _super.prototype.dispose.call(this);
	    };
	    Object.defineProperty(SplitPanel.prototype, "orientation", {
	        /**
	         * Get the layout orientation for the split panel.
	         */
	        get: function () {
	            return this.layout.orientation;
	        },
	        /**
	         * Set the layout orientation for the split panel.
	         */
	        set: function (value) {
	            this.layout.orientation = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SplitPanel.prototype, "spacing", {
	        /**
	         * Get the inter-element spacing for the split panel.
	         */
	        get: function () {
	            return this.layout.spacing;
	        },
	        /**
	         * Set the inter-element spacing for the split panel.
	         */
	        set: function (value) {
	            this.layout.spacing = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SplitPanel.prototype, "renderer", {
	        /**
	         * The renderer used by the split panel.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.layout.renderer;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SplitPanel.prototype, "handles", {
	        /**
	         * A read-only sequence of the split handles in the panel.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.layout.handles;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Get the relative sizes of the widgets in the panel.
	     *
	     * @returns A new array of the relative sizes of the widgets.
	     *
	     * #### Notes
	     * The returned sizes reflect the sizes of the widgets normalized
	     * relative to their siblings.
	     *
	     * This method **does not** measure the DOM nodes.
	     */
	    SplitPanel.prototype.relativeSizes = function () {
	        return this.layout.relativeSizes();
	    };
	    /**
	     * Set the relative sizes for the widgets in the panel.
	     *
	     * @param sizes - The relative sizes for the widgets in the panel.
	     *
	     * #### Notes
	     * Extra values are ignored, too few will yield an undefined layout.
	     *
	     * The actual geometry of the DOM nodes is updated asynchronously.
	     */
	    SplitPanel.prototype.setRelativeSizes = function (sizes) {
	        this.layout.setRelativeSizes(sizes);
	    };
	    /**
	     * Handle the DOM events for the split panel.
	     *
	     * @param event - The DOM event sent to the panel.
	     *
	     * #### Notes
	     * This method implements the DOM `EventListener` interface and is
	     * called in response to events on the panel's DOM node. It should
	     * not be called directly by user code.
	     */
	    SplitPanel.prototype.handleEvent = function (event) {
	        switch (event.type) {
	            case 'mousedown':
	                this._evtMouseDown(event);
	                break;
	            case 'mousemove':
	                this._evtMouseMove(event);
	                break;
	            case 'mouseup':
	                this._evtMouseUp(event);
	                break;
	            case 'keydown':
	                this._evtKeyDown(event);
	                break;
	            case 'keyup':
	            case 'keypress':
	            case 'contextmenu':
	                // Stop input events during drag.
	                event.preventDefault();
	                event.stopPropagation();
	                break;
	        }
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     */
	    SplitPanel.prototype.onAfterAttach = function (msg) {
	        this.node.addEventListener('mousedown', this);
	    };
	    /**
	     * A message handler invoked on a `'before-detach'` message.
	     */
	    SplitPanel.prototype.onBeforeDetach = function (msg) {
	        this.node.removeEventListener('mousedown', this);
	        this._releaseMouse();
	    };
	    /**
	     * A message handler invoked on a `'child-added'` message.
	     */
	    SplitPanel.prototype.onChildAdded = function (msg) {
	        msg.child.addClass(CHILD_CLASS);
	        this._releaseMouse();
	    };
	    /**
	     * A message handler invoked on a `'child-removed'` message.
	     */
	    SplitPanel.prototype.onChildRemoved = function (msg) {
	        msg.child.removeClass(CHILD_CLASS);
	        this._releaseMouse();
	    };
	    /**
	     * Handle the `'keydown'` event for the split panel.
	     */
	    SplitPanel.prototype._evtKeyDown = function (event) {
	        // Stop input events during drag.
	        event.preventDefault();
	        event.stopPropagation();
	        // Release the mouse if `Escape` is pressed.
	        if (event.keyCode === 27)
	            this._releaseMouse();
	    };
	    /**
	     * Handle the `'mousedown'` event for the split panel.
	     */
	    SplitPanel.prototype._evtMouseDown = function (event) {
	        // Do nothing if the left mouse button is not pressed.
	        if (event.button !== 0) {
	            return;
	        }
	        // Find the handle which contains the mouse target, if any.
	        var layout = this.layout;
	        var target = event.target;
	        var index = searching_1.findIndex(layout.handles, function (handle) { return handle.contains(target); });
	        if (index === -1) {
	            return;
	        }
	        // Stop the event when a split handle is pressed.
	        event.preventDefault();
	        event.stopPropagation();
	        // Add the extra document listeners.
	        document.addEventListener('mouseup', this, true);
	        document.addEventListener('mousemove', this, true);
	        document.addEventListener('keydown', this, true);
	        document.addEventListener('keyup', this, true);
	        document.addEventListener('keypress', this, true);
	        document.addEventListener('contextmenu', this, true);
	        // Compute the offset delta for the handle press.
	        var delta;
	        var handle = layout.handles.at(index);
	        var rect = handle.getBoundingClientRect();
	        if (layout.orientation === 'horizontal') {
	            delta = event.clientX - rect.left;
	        }
	        else {
	            delta = event.clientY - rect.top;
	        }
	        // Override the cursor and store the press data.
	        var style = window.getComputedStyle(handle);
	        var override = cursor_1.overrideCursor(style.cursor);
	        this._pressData = { index: index, delta: delta, override: override };
	    };
	    /**
	     * Handle the `'mousemove'` event for the split panel.
	     */
	    SplitPanel.prototype._evtMouseMove = function (event) {
	        // Stop the event when dragging a split handle.
	        event.preventDefault();
	        event.stopPropagation();
	        // Compute the desired offset position for the handle.
	        var pos;
	        var layout = this.layout;
	        var rect = this.node.getBoundingClientRect();
	        if (layout.orientation === 'horizontal') {
	            pos = event.clientX - rect.left - this._pressData.delta;
	        }
	        else {
	            pos = event.clientY - rect.top - this._pressData.delta;
	        }
	        // Set the handle as close to the desired position as possible.
	        layout.setHandlePosition(this._pressData.index, pos);
	    };
	    /**
	     * Handle the `'mouseup'` event for the split panel.
	     */
	    SplitPanel.prototype._evtMouseUp = function (event) {
	        // Do nothing if the left mouse button is not released.
	        if (event.button !== 0) {
	            return;
	        }
	        // Stop the event when releasing a handle.
	        event.preventDefault();
	        event.stopPropagation();
	        // Finalize the mouse release.
	        this._releaseMouse();
	    };
	    /**
	     * Release the mouse grab for the split panel.
	     */
	    SplitPanel.prototype._releaseMouse = function () {
	        // Bail early if no drag is in progress.
	        if (!this._pressData) {
	            return;
	        }
	        // Clear the override cursor.
	        this._pressData.override.dispose();
	        this._pressData = null;
	        // Remove the extra document listeners.
	        document.removeEventListener('mouseup', this, true);
	        document.removeEventListener('mousemove', this, true);
	        document.removeEventListener('keydown', this, true);
	        document.removeEventListener('keyup', this, true);
	        document.removeEventListener('keypress', this, true);
	        document.removeEventListener('contextmenu', this, true);
	    };
	    return SplitPanel;
	}(panel_1.Panel));
	exports.SplitPanel = SplitPanel;
	/**
	 * The namespace for the `SplitPanel` class statics.
	 */
	var SplitPanel;
	(function (SplitPanel) {
	    /**
	     * The default implementation of `IRenderer`.
	     */
	    var Renderer = (function () {
	        function Renderer() {
	        }
	        /**
	         * Create a new handle node for use with a split panel.
	         *
	         * @returns A new handle node for a split panel.
	         */
	        Renderer.prototype.createHandleNode = function () {
	            var node = document.createElement('div');
	            node.className = HANDLE_CLASS;
	            return node;
	        };
	        return Renderer;
	    }());
	    SplitPanel.Renderer = Renderer;
	    /**
	     * The default `Renderer` instance.
	     */
	    SplitPanel.defaultRenderer = new Renderer();
	    /**
	     * Get the split panel stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns The split panel stretch factor for the widget.
	     */
	    function getStretch(widget) {
	        return SplitLayout.getStretch(widget);
	    }
	    SplitPanel.getStretch = getStretch;
	    /**
	     * Set the split panel stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @param value - The value for the stretch factor.
	     */
	    function setStretch(widget, value) {
	        SplitLayout.setStretch(widget, value);
	    }
	    SplitPanel.setStretch = setStretch;
	})(SplitPanel = exports.SplitPanel || (exports.SplitPanel = {}));
	/**
	 * A layout which arranges its widgets into resizable sections.
	 */
	var SplitLayout = (function (_super) {
	    __extends(SplitLayout, _super);
	    /**
	     * Construct a new split layout.
	     *
	     * @param options - The options for initializing the layout.
	     */
	    function SplitLayout(options) {
	        _super.call(this);
	        this._fixed = 0;
	        this._spacing = 4;
	        this._dirty = false;
	        this._hasNormedSizes = false;
	        this._box = null;
	        this._sizers = new vector_1.Vector();
	        this._handles = new vector_1.Vector();
	        this._orientation = 'horizontal';
	        this._renderer = options.renderer;
	        if (options.orientation !== void 0) {
	            this._orientation = options.orientation;
	        }
	        if (options.spacing !== void 0) {
	            this._spacing = Private.clampSpacing(options.spacing);
	        }
	    }
	    Object.defineProperty(SplitLayout.prototype, "orientation", {
	        /**
	         * Get the layout orientation for the split layout.
	         */
	        get: function () {
	            return this._orientation;
	        },
	        /**
	         * Set the layout orientation for the split layout.
	         */
	        set: function (value) {
	            if (this._orientation === value) {
	                return;
	            }
	            this._orientation = value;
	            if (!this.parent) {
	                return;
	            }
	            Private.toggleOrientation(this.parent, value);
	            this.parent.fit();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SplitLayout.prototype, "spacing", {
	        /**
	         * Get the inter-element spacing for the split layout.
	         */
	        get: function () {
	            return this._spacing;
	        },
	        /**
	         * Set the inter-element spacing for the split layout.
	         */
	        set: function (value) {
	            value = Private.clampSpacing(value);
	            if (this._spacing === value) {
	                return;
	            }
	            this._spacing = value;
	            if (!this.parent) {
	                return;
	            }
	            this.parent.fit();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SplitLayout.prototype, "renderer", {
	        /**
	         * The renderer used by the split layout.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._renderer;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SplitLayout.prototype, "handles", {
	        /**
	         * A read-only sequence of the split handles in the layout.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._handles;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Get the relative sizes of the widgets in the layout.
	     *
	     * @returns A new array of the relative sizes of the widgets.
	     *
	     * #### Notes
	     * The returned sizes reflect the sizes of the widgets normalized
	     * relative to their siblings.
	     *
	     * This method **does not** measure the DOM nodes.
	     */
	    SplitLayout.prototype.relativeSizes = function () {
	        return Private.normalize(iteration_1.toArray(iteration_1.map(this._sizers, function (sizer) { return sizer.size; })));
	    };
	    /**
	     * Set the relative sizes for the widgets in the layout.
	     *
	     * @param sizes - The relative sizes for the widgets in the panel.
	     *
	     * #### Notes
	     * Extra values are ignored, too few will yield an undefined layout.
	     *
	     * The actual geometry of the DOM nodes is updated asynchronously.
	     */
	    SplitLayout.prototype.setRelativeSizes = function (sizes) {
	        // Copy the sizes and pad with zeros as needed.
	        var n = this._sizers.length;
	        var temp = sizes.slice(0, n);
	        while (temp.length < n)
	            temp.push(0);
	        // Normalize the padded sizes.
	        var normed = Private.normalize(temp);
	        // Apply the normalized sizes to the sizers.
	        for (var i = 0; i < n; ++i) {
	            var sizer = this._sizers.at(i);
	            sizer.sizeHint = sizer.size = normed[i];
	        }
	        // Set the flag indicating the sizes are normalized.
	        this._hasNormedSizes = true;
	        // Trigger an update of the parent widget.
	        if (this.parent)
	            this.parent.update();
	    };
	    /**
	     * Set the offset position of a split handle.
	     *
	     * @param index - The index of the handle of the interest.
	     *
	     * @param position - The desired offset position of the handle.
	     *
	     * #### Notes
	     * The position is relative to the offset parent.
	     *
	     * This will move the handle as close as possible to the desired
	     * position. The sibling widgets will be adjusted as necessary.
	     *
	     * #### Undefined Behavior
	     * An `index` which is non-integral or out of range.
	     */
	    SplitLayout.prototype.setHandlePosition = function (index, position) {
	        // Bail if the index is invalid or the handle is hidden.
	        var handle = this._handles.at(index);
	        if (!handle || handle.classList.contains(HIDDEN_CLASS)) {
	            return;
	        }
	        // Compute the desired delta movement for the handle.
	        var delta;
	        if (this._orientation === 'horizontal') {
	            delta = position - handle.offsetLeft;
	        }
	        else {
	            delta = position - handle.offsetTop;
	        }
	        // Bail if there is no handle movement.
	        if (delta === 0) {
	            return;
	        }
	        // Prevent widget resizing unless needed.
	        iteration_1.each(this._sizers, function (sizer) {
	            if (sizer.size > 0)
	                sizer.sizeHint = sizer.size;
	        });
	        // Adjust the sizers to reflect the handle movement.
	        if (delta > 0) {
	            Private.growSizer(this._sizers, index, delta);
	        }
	        else {
	            Private.shrinkSizer(this._sizers, index, -delta);
	        }
	        // Update the layout of the widgets.
	        if (this.parent)
	            this.parent.update();
	    };
	    /**
	     * Attach a widget to the parent's DOM node.
	     *
	     * @param index - The current index of the widget in the layout.
	     *
	     * @param widget - The widget to attach to the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    SplitLayout.prototype.attachWidget = function (index, widget) {
	        // Create and add the handle and sizer for the new widget.
	        var handle = Private.createHandle(this._renderer);
	        var average = Private.averageSize(this._sizers);
	        var sizer = Private.createSizer(average);
	        this._sizers.insert(index, sizer);
	        this._handles.insert(index, handle);
	        // Prepare the layout geometry for the widget.
	        widget_1.Widget.prepareGeometry(widget);
	        // Add the widget and handle nodes to the parent.
	        this.parent.node.appendChild(widget.node);
	        this.parent.node.appendChild(handle);
	        // Send an `'after-attach'` message if the parent is attached.
	        if (this.parent.isAttached)
	            messaging_1.sendMessage(widget, widget_1.WidgetMessage.AfterAttach);
	        // Post a layout request for the parent widget.
	        this.parent.fit();
	    };
	    /**
	     * Move a widget in the parent's DOM node.
	     *
	     * @param fromIndex - The previous index of the widget in the layout.
	     *
	     * @param toIndex - The current index of the widget in the layout.
	     *
	     * @param widget - The widget to move in the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    SplitLayout.prototype.moveWidget = function (fromIndex, toIndex, widget) {
	        // Move the sizer and handle for the widget.
	        mutation_1.move(this._sizers, fromIndex, toIndex);
	        mutation_1.move(this._handles, fromIndex, toIndex);
	        // Post a fit request to the parent to show/hide last handle.
	        this.parent.fit();
	    };
	    /**
	     * Detach a widget from the parent's DOM node.
	     *
	     * @param index - The previous index of the widget in the layout.
	     *
	     * @param widget - The widget to detach from the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    SplitLayout.prototype.detachWidget = function (index, widget) {
	        // Remove the handle for the widget.
	        var handle = this._handles.removeAt(index);
	        // Remove the sizer for the widget.
	        this._sizers.removeAt(index);
	        // Send a `'before-detach'` message if the parent is attached.
	        if (this.parent.isAttached)
	            messaging_1.sendMessage(widget, widget_1.WidgetMessage.BeforeDetach);
	        // Remove the widget and handle nodes from the parent.
	        this.parent.node.removeChild(widget.node);
	        this.parent.node.removeChild(handle);
	        // Reset the layout geometry for the widget.
	        widget_1.Widget.resetGeometry(widget);
	        // Post a layout request for the parent widget.
	        this.parent.fit();
	    };
	    /**
	     * A message handler invoked on a `'layout-changed'` message.
	     *
	     * #### Notes
	     * This is called when the layout is installed on its parent.
	     */
	    SplitLayout.prototype.onLayoutChanged = function (msg) {
	        Private.toggleOrientation(this.parent, this.orientation);
	        _super.prototype.onLayoutChanged.call(this, msg);
	    };
	    /**
	     * A message handler invoked on an `'after-show'` message.
	     */
	    SplitLayout.prototype.onAfterShow = function (msg) {
	        _super.prototype.onAfterShow.call(this, msg);
	        this.parent.update();
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     */
	    SplitLayout.prototype.onAfterAttach = function (msg) {
	        _super.prototype.onAfterAttach.call(this, msg);
	        this.parent.fit();
	    };
	    /**
	     * A message handler invoked on a `'child-shown'` message.
	     */
	    SplitLayout.prototype.onChildShown = function (msg) {
	        if (platform_1.IS_IE) {
	            messaging_1.sendMessage(this.parent, widget_1.WidgetMessage.FitRequest);
	        }
	        else {
	            this.parent.fit();
	        }
	    };
	    /**
	     * A message handler invoked on a `'child-hidden'` message.
	     */
	    SplitLayout.prototype.onChildHidden = function (msg) {
	        if (platform_1.IS_IE) {
	            messaging_1.sendMessage(this.parent, widget_1.WidgetMessage.FitRequest);
	        }
	        else {
	            this.parent.fit();
	        }
	    };
	    /**
	     * A message handler invoked on a `'resize'` message.
	     */
	    SplitLayout.prototype.onResize = function (msg) {
	        if (this.parent.isVisible) {
	            this._update(msg.width, msg.height);
	        }
	    };
	    /**
	     * A message handler invoked on an `'update-request'` message.
	     */
	    SplitLayout.prototype.onUpdateRequest = function (msg) {
	        if (this.parent.isVisible) {
	            this._update(-1, -1);
	        }
	    };
	    /**
	     * A message handler invoked on a `'fit-request'` message.
	     */
	    SplitLayout.prototype.onFitRequest = function (msg) {
	        if (this.parent.isAttached) {
	            this._fit();
	        }
	    };
	    /**
	     * Fit the layout to the total size required by the widgets.
	     */
	    SplitLayout.prototype._fit = function () {
	        // Update the handles and track the visible widget count.
	        var nVisible = 0;
	        var widgets = this.widgets;
	        var lastHandle = null;
	        for (var i = 0, n = widgets.length; i < n; ++i) {
	            var handle = this._handles.at(i);
	            if (widgets.at(i).isHidden) {
	                handle.classList.add(HIDDEN_CLASS);
	            }
	            else {
	                handle.classList.remove(HIDDEN_CLASS);
	                lastHandle = handle;
	                nVisible++;
	            }
	        }
	        // Hide the handle for the last visible widget.
	        if (lastHandle)
	            lastHandle.classList.add(HIDDEN_CLASS);
	        // Update the fixed space for the visible items.
	        this._fixed = this._spacing * Math.max(0, nVisible - 1);
	        // Setup the initial size limits.
	        var minW = 0;
	        var minH = 0;
	        var maxW = Infinity;
	        var maxH = Infinity;
	        var horz = this._orientation === 'horizontal';
	        if (horz) {
	            minW = this._fixed;
	            maxW = nVisible > 0 ? minW : maxW;
	        }
	        else {
	            minH = this._fixed;
	            maxH = nVisible > 0 ? minH : maxH;
	        }
	        // Update the sizers and computed size limits.
	        for (var i = 0, n = widgets.length; i < n; ++i) {
	            var widget = widgets.at(i);
	            var sizer = this._sizers.at(i);
	            if (sizer.size > 0) {
	                sizer.sizeHint = sizer.size;
	            }
	            if (widget.isHidden) {
	                sizer.minSize = 0;
	                sizer.maxSize = 0;
	                continue;
	            }
	            var limits = sizing_1.sizeLimits(widget.node);
	            sizer.stretch = SplitLayout.getStretch(widget);
	            if (horz) {
	                sizer.minSize = limits.minWidth;
	                sizer.maxSize = limits.maxWidth;
	                minW += limits.minWidth;
	                maxW += limits.maxWidth;
	                minH = Math.max(minH, limits.minHeight);
	                maxH = Math.min(maxH, limits.maxHeight);
	            }
	            else {
	                sizer.minSize = limits.minHeight;
	                sizer.maxSize = limits.maxHeight;
	                minH += limits.minHeight;
	                maxH += limits.maxHeight;
	                minW = Math.max(minW, limits.minWidth);
	                maxW = Math.min(maxW, limits.maxWidth);
	            }
	        }
	        // Update the box sizing and add it to the size constraints.
	        var box = this._box = sizing_1.boxSizing(this.parent.node);
	        minW += box.horizontalSum;
	        minH += box.verticalSum;
	        maxW += box.horizontalSum;
	        maxH += box.verticalSum;
	        // Update the parent's size constraints.
	        var style = this.parent.node.style;
	        style.minWidth = minW + "px";
	        style.minHeight = minH + "px";
	        style.maxWidth = maxW === Infinity ? 'none' : maxW + "px";
	        style.maxHeight = maxH === Infinity ? 'none' : maxH + "px";
	        // Set the dirty flag to ensure only a single update occurs.
	        this._dirty = true;
	        // Notify the ancestor that it should fit immediately. This may
	        // cause a resize of the parent, fulfilling the required update.
	        var ancestor = this.parent.parent;
	        if (ancestor)
	            messaging_1.sendMessage(ancestor, widget_1.WidgetMessage.FitRequest);
	        // If the dirty flag is still set, the parent was not resized.
	        // Trigger the required update on the parent widget immediately.
	        if (this._dirty)
	            messaging_1.sendMessage(this.parent, widget_1.WidgetMessage.UpdateRequest);
	    };
	    /**
	     * Update the layout position and size of the widgets.
	     *
	     * The parent offset dimensions should be `-1` if unknown.
	     */
	    SplitLayout.prototype._update = function (offsetWidth, offsetHeight) {
	        // Clear the dirty flag to indicate the update occurred.
	        this._dirty = false;
	        // Bail early if there are no widgets to layout.
	        var widgets = this.widgets;
	        if (widgets.length === 0) {
	            return;
	        }
	        // Measure the parent if the offset dimensions are unknown.
	        if (offsetWidth < 0) {
	            offsetWidth = this.parent.node.offsetWidth;
	        }
	        if (offsetHeight < 0) {
	            offsetHeight = this.parent.node.offsetHeight;
	        }
	        // Ensure the parent box sizing data is computed.
	        var box = this._box || (this._box = sizing_1.boxSizing(this.parent.node));
	        // Compute the actual layout bounds adjusted for border and padding.
	        var top = box.paddingTop;
	        var left = box.paddingLeft;
	        var width = offsetWidth - box.horizontalSum;
	        var height = offsetHeight - box.verticalSum;
	        // Compute the adjusted layout space.
	        var space;
	        var horz = this._orientation === 'horizontal';
	        if (horz) {
	            space = Math.max(0, width - this._fixed);
	        }
	        else {
	            space = Math.max(0, height - this._fixed);
	        }
	        // Scale the size hints if they are normalized.
	        if (this._hasNormedSizes) {
	            iteration_1.each(this._sizers, function (sizer) { sizer.sizeHint *= space; });
	            this._hasNormedSizes = false;
	        }
	        // Distribute the layout space to the box sizers.
	        boxengine_1.boxCalc(this._sizers, space);
	        // Layout the widgets using the computed box sizes.
	        var spacing = this._spacing;
	        for (var i = 0, n = widgets.length; i < n; ++i) {
	            var widget = widgets.at(i);
	            if (widget.isHidden) {
	                continue;
	            }
	            var size = this._sizers.at(i).size;
	            var hstyle = this._handles.at(i).style;
	            if (horz) {
	                widget_1.Widget.setGeometry(widget, left, top, size, height);
	                left += size;
	                hstyle.top = top + "px";
	                hstyle.left = left + "px";
	                hstyle.width = spacing + "px";
	                hstyle.height = height + "px";
	                left += spacing;
	            }
	            else {
	                widget_1.Widget.setGeometry(widget, left, top, width, size);
	                top += size;
	                hstyle.top = top + "px";
	                hstyle.left = left + "px";
	                hstyle.width = width + "px";
	                hstyle.height = spacing + "px";
	                top += spacing;
	            }
	        }
	    };
	    return SplitLayout;
	}(panel_1.PanelLayout));
	exports.SplitLayout = SplitLayout;
	/**
	 * The namespace for the `SplitLayout` class statics.
	 */
	var SplitLayout;
	(function (SplitLayout) {
	    /**
	     * Get the split layout stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns The split layout stretch factor for the widget.
	     */
	    function getStretch(widget) {
	        return Private.stretchProperty.get(widget);
	    }
	    SplitLayout.getStretch = getStretch;
	    /**
	     * Set the split layout stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @param value - The value for the stretch factor.
	     */
	    function setStretch(widget, value) {
	        Private.stretchProperty.set(widget, value);
	    }
	    SplitLayout.setStretch = setStretch;
	})(SplitLayout = exports.SplitLayout || (exports.SplitLayout = {}));
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * The property descriptor for a widget stretch factor.
	     */
	    Private.stretchProperty = new properties_1.AttachedProperty({
	        name: 'stretch',
	        value: 0,
	        coerce: function (owner, value) { return Math.max(0, Math.floor(value)); },
	        changed: onChildPropertyChanged
	    });
	    /**
	     * Create a split layout for the given panel options.
	     */
	    function createLayout(options) {
	        return options.layout || new SplitLayout({
	            renderer: options.renderer || SplitPanel.defaultRenderer,
	            orientation: options.orientation,
	            spacing: options.spacing
	        });
	    }
	    Private.createLayout = createLayout;
	    /**
	     * Create a new box sizer with the given size hint.
	     */
	    function createSizer(size) {
	        var sizer = new boxengine_1.BoxSizer();
	        sizer.sizeHint = Math.floor(size);
	        return sizer;
	    }
	    Private.createSizer = createSizer;
	    /**
	     * Create a new split handle node using the given renderer.
	     */
	    function createHandle(renderer) {
	        var node = renderer.createHandleNode();
	        node.style.position = 'absolute';
	        return node;
	    }
	    Private.createHandle = createHandle;
	    /**
	     * Toggle the CSS orientation class for the given widget.
	     */
	    function toggleOrientation(widget, orient) {
	        widget.toggleClass(HORIZONTAL_CLASS, orient === 'horizontal');
	        widget.toggleClass(VERTICAL_CLASS, orient === 'vertical');
	    }
	    Private.toggleOrientation = toggleOrientation;
	    /**
	     * Clamp a spacing value to an integer >= 0.
	     */
	    function clampSpacing(value) {
	        return Math.max(0, Math.floor(value));
	    }
	    Private.clampSpacing = clampSpacing;
	    /**
	     * Compute the average size of a vector of box sizers.
	     */
	    function averageSize(sizers) {
	        return iteration_1.reduce(sizers, function (v, s) { return v + s.size; }, 0) / sizers.length || 0;
	    }
	    Private.averageSize = averageSize;
	    /**
	     * Normalize an array of values.
	     */
	    function normalize(values) {
	        var n = values.length;
	        if (n === 0)
	            return [];
	        var sum = values.reduce(function (a, b) { return a + Math.abs(b); }, 0);
	        return sum === 0 ? values.map(function (v) { return 1 / n; }) : values.map(function (v) { return v / sum; });
	    }
	    Private.normalize = normalize;
	    /**
	     * Grow a sizer to the right by a positive delta and adjust neighbors.
	     */
	    function growSizer(sizers, index, delta) {
	        // Compute how much the items to the left can expand.
	        var growLimit = 0;
	        for (var i = 0; i <= index; ++i) {
	            var sizer = sizers.at(i);
	            growLimit += sizer.maxSize - sizer.size;
	        }
	        // Compute how much the items to the right can shrink.
	        var shrinkLimit = 0;
	        for (var i = index + 1, n = sizers.length; i < n; ++i) {
	            var sizer = sizers.at(i);
	            shrinkLimit += sizer.size - sizer.minSize;
	        }
	        // Clamp the delta adjustment to the limits.
	        delta = Math.min(delta, growLimit, shrinkLimit);
	        // Grow the sizers to the left by the delta.
	        var grow = delta;
	        for (var i = index; i >= 0 && grow > 0; --i) {
	            var sizer = sizers.at(i);
	            var limit = sizer.maxSize - sizer.size;
	            if (limit >= grow) {
	                sizer.sizeHint = sizer.size + grow;
	                grow = 0;
	            }
	            else {
	                sizer.sizeHint = sizer.size + limit;
	                grow -= limit;
	            }
	        }
	        // Shrink the sizers to the right by the delta.
	        var shrink = delta;
	        for (var i = index + 1, n = sizers.length; i < n && shrink > 0; ++i) {
	            var sizer = sizers.at(i);
	            var limit = sizer.size - sizer.minSize;
	            if (limit >= shrink) {
	                sizer.sizeHint = sizer.size - shrink;
	                shrink = 0;
	            }
	            else {
	                sizer.sizeHint = sizer.size - limit;
	                shrink -= limit;
	            }
	        }
	    }
	    Private.growSizer = growSizer;
	    /**
	     * Shrink a sizer to the left by a positive delta and adjust neighbors.
	     */
	    function shrinkSizer(sizers, index, delta) {
	        // Compute how much the items to the right can expand.
	        var growLimit = 0;
	        for (var i = index + 1, n = sizers.length; i < n; ++i) {
	            var sizer = sizers.at(i);
	            growLimit += sizer.maxSize - sizer.size;
	        }
	        // Compute how much the items to the left can shrink.
	        var shrinkLimit = 0;
	        for (var i = 0; i <= index; ++i) {
	            var sizer = sizers.at(i);
	            shrinkLimit += sizer.size - sizer.minSize;
	        }
	        // Clamp the delta adjustment to the limits.
	        delta = Math.min(delta, growLimit, shrinkLimit);
	        // Grow the sizers to the right by the delta.
	        var grow = delta;
	        for (var i = index + 1, n = sizers.length; i < n && grow > 0; ++i) {
	            var sizer = sizers.at(i);
	            var limit = sizer.maxSize - sizer.size;
	            if (limit >= grow) {
	                sizer.sizeHint = sizer.size + grow;
	                grow = 0;
	            }
	            else {
	                sizer.sizeHint = sizer.size + limit;
	                grow -= limit;
	            }
	        }
	        // Shrink the sizers to the left by the delta.
	        var shrink = delta;
	        for (var i = index; i >= 0 && shrink > 0; --i) {
	            var sizer = sizers.at(i);
	            var limit = sizer.size - sizer.minSize;
	            if (limit >= shrink) {
	                sizer.sizeHint = sizer.size - shrink;
	                shrink = 0;
	            }
	            else {
	                sizer.sizeHint = sizer.size - limit;
	                shrink -= limit;
	            }
	        }
	    }
	    Private.shrinkSizer = shrinkSizer;
	    /**
	     * The change handler for the attached child properties.
	     */
	    function onChildPropertyChanged(child) {
	        var parent = child.parent;
	        var layout = parent && parent.layout;
	        if (layout instanceof SplitLayout)
	            parent.fit();
	    }
	})(Private || (Private = {}));


/***/ },
/* 35 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var messaging_1 = __webpack_require__(18);
	var signaling_1 = __webpack_require__(6);
	var platform_1 = __webpack_require__(14);
	var sizing_1 = __webpack_require__(25);
	var panel_1 = __webpack_require__(27);
	var widget_1 = __webpack_require__(17);
	/**
	 * The class name added to StackedPanel instances.
	 */
	var STACKED_PANEL_CLASS = 'p-StackedPanel';
	/**
	 * The class name added to a StackedPanel child.
	 */
	var CHILD_CLASS = 'p-StackedPanel-child';
	/**
	 * A panel where visible widgets are stacked atop one another.
	 *
	 * #### Notes
	 * This class provides a convenience wrapper around a [[StackedLayout]].
	 */
	var StackedPanel = (function (_super) {
	    __extends(StackedPanel, _super);
	    /**
	     * Construct a new stacked panel.
	     *
	     * @param options - The options for initializing the panel.
	     */
	    function StackedPanel(options) {
	        if (options === void 0) { options = {}; }
	        _super.call(this, { layout: Private.createLayout(options) });
	        this.addClass(STACKED_PANEL_CLASS);
	    }
	    /**
	     * A message handler invoked on a `'child-added'` message.
	     */
	    StackedPanel.prototype.onChildAdded = function (msg) {
	        msg.child.addClass(CHILD_CLASS);
	    };
	    /**
	     * A message handler invoked on a `'child-removed'` message.
	     */
	    StackedPanel.prototype.onChildRemoved = function (msg) {
	        msg.child.removeClass(CHILD_CLASS);
	        this.widgetRemoved.emit(msg.child);
	    };
	    return StackedPanel;
	}(panel_1.Panel));
	exports.StackedPanel = StackedPanel;
	// Define the signals for the `StackedPanel` class.
	signaling_1.defineSignal(StackedPanel.prototype, 'widgetRemoved');
	/**
	 * A layout where visible widgets are stacked atop one another.
	 *
	 * #### Notes
	 * The Z-order of the visible widgets follows their layout order.
	 */
	var StackedLayout = (function (_super) {
	    __extends(StackedLayout, _super);
	    function StackedLayout() {
	        _super.apply(this, arguments);
	        this._dirty = false;
	        this._box = null;
	    }
	    /**
	     * Attach a widget to the parent's DOM node.
	     *
	     * @param index - The current index of the widget in the layout.
	     *
	     * @param widget - The widget to attach to the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    StackedLayout.prototype.attachWidget = function (index, widget) {
	        // Prepare the layout geometry for the widget.
	        widget_1.Widget.prepareGeometry(widget);
	        // Add the widget's node to the parent.
	        this.parent.node.appendChild(widget.node);
	        // Send an `'after-attach'` message if the parent is attached.
	        if (this.parent.isAttached)
	            messaging_1.sendMessage(widget, widget_1.WidgetMessage.AfterAttach);
	        // Post a layout request for the parent widget.
	        this.parent.fit();
	    };
	    /**
	     * Move a widget in the parent's DOM node.
	     *
	     * @param fromIndex - The previous index of the widget in the layout.
	     *
	     * @param toIndex - The current index of the widget in the layout.
	     *
	     * @param widget - The widget to move in the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    StackedLayout.prototype.moveWidget = function (fromIndex, toIndex, widget) {
	        // Post an update request for the parent widget.
	        this.parent.update();
	    };
	    /**
	     * Detach a widget from the parent's DOM node.
	     *
	     * @param index - The previous index of the widget in the layout.
	     *
	     * @param widget - The widget to detach from the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    StackedLayout.prototype.detachWidget = function (index, widget) {
	        // Send a `'before-detach'` message if the parent is attached.
	        if (this.parent.isAttached)
	            messaging_1.sendMessage(widget, widget_1.WidgetMessage.BeforeDetach);
	        // Remove the widget's node from the parent.
	        this.parent.node.removeChild(widget.node);
	        // Reset the layout geometry for the widget.
	        widget_1.Widget.resetGeometry(widget);
	        // Reset the z-index for the widget.
	        widget.node.style.zIndex = '';
	        // Post a layout request for the parent widget.
	        this.parent.fit();
	    };
	    /**
	     * A message handler invoked on an `'after-show'` message.
	     */
	    StackedLayout.prototype.onAfterShow = function (msg) {
	        _super.prototype.onAfterShow.call(this, msg);
	        this.parent.update();
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     */
	    StackedLayout.prototype.onAfterAttach = function (msg) {
	        _super.prototype.onAfterAttach.call(this, msg);
	        this.parent.fit();
	    };
	    /**
	     * A message handler invoked on a `'child-shown'` message.
	     */
	    StackedLayout.prototype.onChildShown = function (msg) {
	        if (platform_1.IS_IE) {
	            messaging_1.sendMessage(this.parent, widget_1.WidgetMessage.FitRequest);
	        }
	        else {
	            this.parent.fit();
	        }
	    };
	    /**
	     * A message handler invoked on a `'child-hidden'` message.
	     */
	    StackedLayout.prototype.onChildHidden = function (msg) {
	        if (platform_1.IS_IE) {
	            messaging_1.sendMessage(this.parent, widget_1.WidgetMessage.FitRequest);
	        }
	        else {
	            this.parent.fit();
	        }
	    };
	    /**
	     * A message handler invoked on a `'resize'` message.
	     */
	    StackedLayout.prototype.onResize = function (msg) {
	        if (this.parent.isVisible) {
	            this._update(msg.width, msg.height);
	        }
	    };
	    /**
	     * A message handler invoked on an `'update-request'` message.
	     */
	    StackedLayout.prototype.onUpdateRequest = function (msg) {
	        if (this.parent.isVisible) {
	            this._update(-1, -1);
	        }
	    };
	    /**
	     * A message handler invoked on a `'fit-request'` message.
	     */
	    StackedLayout.prototype.onFitRequest = function (msg) {
	        if (this.parent.isAttached) {
	            this._fit();
	        }
	    };
	    /**
	     * Fit the layout to the total size required by the widgets.
	     */
	    StackedLayout.prototype._fit = function () {
	        // Setup the initial size limits.
	        var minW = 0;
	        var minH = 0;
	        var maxW = Infinity;
	        var maxH = Infinity;
	        // Update the computed size limits.
	        var widgets = this.widgets;
	        for (var i = 0, n = widgets.length; i < n; ++i) {
	            var widget = widgets.at(i);
	            if (widget.isHidden) {
	                continue;
	            }
	            var limits = sizing_1.sizeLimits(widget.node);
	            minW = Math.max(minW, limits.minWidth);
	            minH = Math.max(minH, limits.minHeight);
	            maxW = Math.min(maxW, limits.maxWidth);
	            maxH = Math.min(maxH, limits.maxHeight);
	        }
	        // Ensure max limits >= min limits.
	        maxW = Math.max(minW, maxW);
	        maxH = Math.max(minH, maxH);
	        // Update the box sizing and add it to the size constraints.
	        var box = this._box = sizing_1.boxSizing(this.parent.node);
	        minW += box.horizontalSum;
	        minH += box.verticalSum;
	        maxW += box.horizontalSum;
	        maxH += box.verticalSum;
	        // Update the parent's size constraints.
	        var style = this.parent.node.style;
	        style.minWidth = minW + "px";
	        style.minHeight = minH + "px";
	        style.maxWidth = maxW === Infinity ? 'none' : maxW + "px";
	        style.maxHeight = maxH === Infinity ? 'none' : maxH + "px";
	        // Set the dirty flag to ensure only a single update occurs.
	        this._dirty = true;
	        // Notify the ancestor that it should fit immediately. This may
	        // cause a resize of the parent, fulfilling the required update.
	        var ancestor = this.parent.parent;
	        if (ancestor)
	            messaging_1.sendMessage(ancestor, widget_1.WidgetMessage.FitRequest);
	        // If the dirty flag is still set, the parent was not resized.
	        // Trigger the required update on the parent widget immediately.
	        if (this._dirty)
	            messaging_1.sendMessage(this.parent, widget_1.WidgetMessage.UpdateRequest);
	    };
	    /**
	     * Update the layout position and size of the widgets.
	     *
	     * The parent offset dimensions should be `-1` if unknown.
	     */
	    StackedLayout.prototype._update = function (offsetWidth, offsetHeight) {
	        // Clear the dirty flag to indicate the update occurred.
	        this._dirty = false;
	        // Bail early if there are no widgets to layout.
	        var widgets = this.widgets;
	        if (widgets.length === 0) {
	            return;
	        }
	        // Measure the parent if the offset dimensions are unknown.
	        if (offsetWidth < 0) {
	            offsetWidth = this.parent.node.offsetWidth;
	        }
	        if (offsetHeight < 0) {
	            offsetHeight = this.parent.node.offsetHeight;
	        }
	        // Ensure the parent box sizing data is computed.
	        var box = this._box || (this._box = sizing_1.boxSizing(this.parent.node));
	        // Compute the actual layout bounds adjusted for border and padding.
	        var top = box.paddingTop;
	        var left = box.paddingLeft;
	        var width = offsetWidth - box.horizontalSum;
	        var height = offsetHeight - box.verticalSum;
	        // Update the widget stacking order and layout geometry.
	        for (var i = 0, n = widgets.length; i < n; ++i) {
	            var widget = widgets.at(i);
	            if (widget.isHidden) {
	                continue;
	            }
	            widget.node.style.zIndex = "" + i;
	            widget_1.Widget.setGeometry(widget, left, top, width, height);
	        }
	    };
	    return StackedLayout;
	}(panel_1.PanelLayout));
	exports.StackedLayout = StackedLayout;
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Create a stacked layout for the given panel options.
	     */
	    function createLayout(options) {
	        return options.layout || new StackedLayout();
	    }
	    Private.createLayout = createLayout;
	})(Private || (Private = {}));


/***/ },
/* 36 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var signaling_1 = __webpack_require__(6);
	var boxpanel_1 = __webpack_require__(23);
	var stackedpanel_1 = __webpack_require__(35);
	var tabbar_1 = __webpack_require__(37);
	var widget_1 = __webpack_require__(17);
	/**
	 * The class name added to TabPanel instances.
	 */
	var TAB_PANEL_CLASS = 'p-TabPanel';
	/**
	 * The class name added to a TabPanel's tab bar.
	 */
	var TAB_BAR_CLASS = 'p-TabPanel-tabBar';
	/**
	 * The class name added to a TabPanel's stacked panel.
	 */
	var STACKED_PANEL_CLASS = 'p-TabPanel-stackedPanel';
	/**
	 * A widget which combines a `TabBar` and a `StackedPanel`.
	 *
	 * #### Notes
	 * This is a simple panel which handles the common case of a tab bar
	 * placed next to a content area. The selected tab controls the widget
	 * which is shown in the content area.
	 *
	 * For use cases which require more control than is provided by this
	 * panel, the `TabBar` widget may be used independently.
	 */
	var TabPanel = (function (_super) {
	    __extends(TabPanel, _super);
	    /**
	     * Construct a new tab panel.
	     *
	     * @param options - The options for initializing the tab panel.
	     */
	    function TabPanel(options) {
	        if (options === void 0) { options = {}; }
	        _super.call(this);
	        this.addClass(TAB_PANEL_CLASS);
	        // Create the tab bar and stacked panel.
	        this._tabBar = new tabbar_1.TabBar(options);
	        this._tabBar.addClass(TAB_BAR_CLASS);
	        this._stackedPanel = new stackedpanel_1.StackedPanel();
	        this._stackedPanel.addClass(STACKED_PANEL_CLASS);
	        // Connect the tab bar signal handlers.
	        this._tabBar.tabMoved.connect(this._onTabMoved, this);
	        this._tabBar.currentChanged.connect(this._onCurrentChanged, this);
	        this._tabBar.tabCloseRequested.connect(this._onTabCloseRequested, this);
	        // Connect the stacked panel signal handlers.
	        this._stackedPanel.widgetRemoved.connect(this._onWidgetRemoved, this);
	        // Get the data related to the placement.
	        this._tabPlacement = options.tabPlacement || 'top';
	        var direction = Private.directionFromPlacement(this._tabPlacement);
	        var orientation = Private.orientationFromPlacement(this._tabPlacement);
	        // Configure the tab bar for the placement.
	        this._tabBar.orientation = orientation;
	        this._tabBar.addClass("p-mod-" + this._tabPlacement);
	        // Create the box layout.
	        var layout = new boxpanel_1.BoxLayout({ direction: direction, spacing: 0 });
	        // Set the stretch factors for the child widgets.
	        boxpanel_1.BoxLayout.setStretch(this._tabBar, 0);
	        boxpanel_1.BoxLayout.setStretch(this._stackedPanel, 1);
	        // Add the child widgets to the layout.
	        layout.addWidget(this._tabBar);
	        layout.addWidget(this._stackedPanel);
	        // Install the layout on the tab panel.
	        this.layout = layout;
	    }
	    /**
	     * Dispose of the resources held by the widget.
	     */
	    TabPanel.prototype.dispose = function () {
	        this._tabBar = null;
	        this._stackedPanel = null;
	        _super.prototype.dispose.call(this);
	    };
	    Object.defineProperty(TabPanel.prototype, "currentIndex", {
	        /**
	         * Get the index of the currently selected tab.
	         *
	         * #### Notes
	         * This will be `-1` if no tab is selected.
	         */
	        get: function () {
	            return this._tabBar.currentIndex;
	        },
	        /**
	         * Set the index of the currently selected tab.
	         *
	         * #### Notes
	         * If the index is out of range, it will be set to `-1`.
	         */
	        set: function (value) {
	            this._tabBar.currentIndex = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabPanel.prototype, "currentWidget", {
	        /**
	         * Get the currently selected widget.
	         *
	         * #### Notes
	         * This will be `null` if there is no selected tab.
	         */
	        get: function () {
	            var title = this._tabBar.currentTitle;
	            return title ? title.owner : null;
	        },
	        /**
	         * Set the currently selected widget.
	         *
	         * #### Notes
	         * If the widget is not in the panel, it will be set to `null`.
	         */
	        set: function (value) {
	            this._tabBar.currentTitle = value ? value.title : null;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabPanel.prototype, "tabsMovable", {
	        /**
	         * Get the whether the tabs are movable by the user.
	         *
	         * #### Notes
	         * Tabs can always be moved programmatically.
	         */
	        get: function () {
	            return this._tabBar.tabsMovable;
	        },
	        /**
	         * Set the whether the tabs are movable by the user.
	         *
	         * #### Notes
	         * Tabs can always be moved programmatically.
	         */
	        set: function (value) {
	            this._tabBar.tabsMovable = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabPanel.prototype, "tabPlacement", {
	        /**
	         * Get the tab placement for the tab panel.
	         *
	         * #### Notes
	         * This controls the position of the tab bar relative to the content.
	         */
	        get: function () {
	            return this._tabPlacement;
	        },
	        /**
	         * Set the tab placement for the tab panel.
	         *
	         * #### Notes
	         * This controls the position of the tab bar relative to the content.
	         */
	        set: function (value) {
	            // Bail if the placement does not change.
	            if (this._tabPlacement === value) {
	                return;
	            }
	            // Swap the internal values.
	            var old = this._tabPlacement;
	            this._tabPlacement = value;
	            // Get the values related to the placement.
	            var direction = Private.directionFromPlacement(value);
	            var orientation = Private.orientationFromPlacement(value);
	            // Configure the tab bar for the placement.
	            this._tabBar.orientation = orientation;
	            this._tabBar.removeClass("p-mod-" + old);
	            this._tabBar.addClass("p-mod-" + value);
	            // Update the layout direction.
	            this.layout.direction = direction;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabPanel.prototype, "tabBar", {
	        /**
	         * The tab bar associated with the tab panel.
	         *
	         * #### Notes
	         * Modifying the tab bar directly can lead to undefined behavior.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._tabBar;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabPanel.prototype, "stackedPanel", {
	        /**
	         * The stacked panel associated with the tab panel.
	         *
	         * #### Notes
	         * Modifying the stack directly can lead to undefined behavior.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._stackedPanel;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabPanel.prototype, "widgets", {
	        /**
	         * A read-only sequence of the widgets in the panel.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._stackedPanel.widgets;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Add a widget to the end of the tab panel.
	     *
	     * @param widget - The widget to add to the tab panel.
	     *
	     * #### Notes
	     * If the widget is already contained in the panel, it will be moved.
	     *
	     * The widget's `title` is used to populate the tab.
	     */
	    TabPanel.prototype.addWidget = function (widget) {
	        this.insertWidget(this.widgets.length, widget);
	    };
	    /**
	     * Insert a widget into the tab panel at a specified index.
	     *
	     * @param index - The index at which to insert the widget.
	     *
	     * @param widget - The widget to insert into to the tab panel.
	     *
	     * #### Notes
	     * If the widget is already contained in the panel, it will be moved.
	     *
	     * The widget's `title` is used to populate the tab.
	     */
	    TabPanel.prototype.insertWidget = function (index, widget) {
	        if (widget !== this.currentWidget)
	            widget.hide();
	        this._stackedPanel.insertWidget(index, widget);
	        this._tabBar.insertTab(index, widget.title);
	    };
	    /**
	     * Handle the `currentChanged` signal from the tab bar.
	     */
	    TabPanel.prototype._onCurrentChanged = function (sender, args) {
	        var previousIndex = args.previousIndex, previousTitle = args.previousTitle, currentIndex = args.currentIndex, currentTitle = args.currentTitle;
	        var previousWidget = previousTitle ? previousTitle.owner : null;
	        var currentWidget = currentTitle ? currentTitle.owner : null;
	        if (previousWidget) {
	            previousWidget.hide();
	            previousWidget.deactivate();
	        }
	        if (currentWidget) {
	            currentWidget.show();
	            currentWidget.activate();
	        }
	        this.currentChanged.emit({
	            previousIndex: previousIndex, previousWidget: previousWidget, currentIndex: currentIndex, currentWidget: currentWidget
	        });
	    };
	    /**
	     * Handle the `tabCloseRequested` signal from the tab bar.
	     */
	    TabPanel.prototype._onTabCloseRequested = function (sender, args) {
	        args.title.owner.close();
	    };
	    /**
	     * Handle the `tabMoved` signal from the tab bar.
	     */
	    TabPanel.prototype._onTabMoved = function (sender, args) {
	        this._stackedPanel.insertWidget(args.toIndex, args.title.owner);
	    };
	    /**
	     * Handle the `widgetRemoved` signal from the stacked panel.
	     */
	    TabPanel.prototype._onWidgetRemoved = function (sender, widget) {
	        this._tabBar.removeTab(widget.title);
	    };
	    return TabPanel;
	}(widget_1.Widget));
	exports.TabPanel = TabPanel;
	// Define the signals for the `TabPanel` class.
	signaling_1.defineSignal(TabPanel.prototype, 'currentChanged');
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Convert a tab placement to tab bar orientation.
	     */
	    function orientationFromPlacement(plc) {
	        return placementToOrientationMap[plc];
	    }
	    Private.orientationFromPlacement = orientationFromPlacement;
	    /**
	     * Convert a tab placement to a box layout direction.
	     */
	    function directionFromPlacement(plc) {
	        return placementToDirectionMap[plc];
	    }
	    Private.directionFromPlacement = directionFromPlacement;
	    /**
	     * A mapping of tab placement to tab bar orientation.
	     */
	    var placementToOrientationMap = {
	        'top': 'horizontal',
	        'left': 'vertical',
	        'right': 'vertical',
	        'bottom': 'horizontal'
	    };
	    /**
	     * A mapping of tab placement to box layout direction.
	     */
	    var placementToDirectionMap = {
	        'top': 'top-to-bottom',
	        'left': 'left-to-right',
	        'right': 'right-to-left',
	        'bottom': 'bottom-to-top'
	    };
	})(Private || (Private = {}));


/***/ },
/* 37 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var iteration_1 = __webpack_require__(5);
	var mutation_1 = __webpack_require__(24);
	var searching_1 = __webpack_require__(11);
	var vector_1 = __webpack_require__(13);
	var messaging_1 = __webpack_require__(18);
	var signaling_1 = __webpack_require__(6);
	var cursor_1 = __webpack_require__(31);
	var query_1 = __webpack_require__(32);
	var title_1 = __webpack_require__(21);
	var vdom_1 = __webpack_require__(38);
	var widget_1 = __webpack_require__(17);
	/**
	 * The class name added to TabBar instances.
	 */
	var TAB_BAR_CLASS = 'p-TabBar';
	/**
	 * The class name added to a tab bar content node.
	 */
	var CONTENT_CLASS = 'p-TabBar-content';
	/**
	 * The class name added to a tab bar tab.
	 */
	var TAB_CLASS = 'p-TabBar-tab';
	/**
	 * The class name added to a tab label node.
	 */
	var LABEL_CLASS = 'p-TabBar-tabLabel';
	/**
	 * The class name added to a tab icon node.
	 */
	var ICON_CLASS = 'p-TabBar-tabIcon';
	/**
	 * The class name added to a tab close icon node.
	 */
	var CLOSE_ICON_CLASS = 'p-TabBar-tabCloseIcon';
	/**
	 * The class name added to a tab bar and tab when dragging.
	 */
	var DRAGGING_CLASS = 'p-mod-dragging';
	/**
	 * The class name added to the current tab.
	 */
	var CURRENT_CLASS = 'p-mod-current';
	/**
	 * The class name added to a closable tab.
	 */
	var CLOSABLE_CLASS = 'p-mod-closable';
	/**
	 * The start drag distance threshold.
	 */
	var DRAG_THRESHOLD = 5;
	/**
	 * The detach distance threshold.
	 */
	var DETACH_THRESHOLD = 20;
	/**
	 * The tab transition duration.
	 */
	var TRANSITION_DURATION = 150; // Keep in sync with CSS.
	/**
	 * The DOM structure for a TabBar.
	 */
	var TAB_BAR_NODE = (vdom_1.h.div(vdom_1.h.ul({ className: CONTENT_CLASS })));
	/**
	 * A widget which displays titles as a single row or column of tabs.
	 *
	 * #### Notes
	 * If CSS transforms are used to rotate nodes for vertically oriented
	 * text, then tab dragging will not work correctly. The `tabsMovable`
	 * property should be set to `false` when rotating nodes from CSS.
	 */
	var TabBar = (function (_super) {
	    __extends(TabBar, _super);
	    /**
	     * Construct a new tab bar.
	     *
	     * @param options - The options for initializing the tab bar.
	     */
	    function TabBar(options) {
	        if (options === void 0) { options = {}; }
	        _super.call(this, { node: vdom_1.realize(TAB_BAR_NODE) });
	        this._currentIndex = -1;
	        this._previousTitle = null;
	        this._titles = new vector_1.Vector();
	        this._dragData = null;
	        this.addClass(TAB_BAR_CLASS);
	        this.setFlag(widget_1.WidgetFlag.DisallowLayout);
	        this._tabsMovable = options.tabsMovable || false;
	        this._allowDeselect = options.allowDeselect || false;
	        this._orientation = options.orientation || 'horizontal';
	        this._renderer = options.renderer || TabBar.defaultRenderer;
	        this._insertBehavior = options.insertBehavior || 'select-tab-if-needed';
	        this._removeBehavior = options.removeBehavior || 'select-tab-after';
	        this.addClass("p-mod-" + this._orientation);
	    }
	    /**
	     * Dispose of the resources held by the widget.
	     */
	    TabBar.prototype.dispose = function () {
	        this._releaseMouse();
	        this._titles.clear();
	        this._renderer = null;
	        this._previousTitle = null;
	        _super.prototype.dispose.call(this);
	    };
	    Object.defineProperty(TabBar.prototype, "contentNode", {
	        /**
	         * Get the tab bar content node.
	         *
	         * #### Notes
	         * This is the node which holds the tab nodes.
	         *
	         * Modifying this node directly can lead to undefined behavior.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.node.getElementsByClassName(CONTENT_CLASS)[0];
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "titles", {
	        /**
	         * A read-only sequence of the titles in the tab bar.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._titles;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "currentTitle", {
	        /**
	         * Get the currently selected title.
	         *
	         * #### Notes
	         * This will be `null` if no tab is selected.
	         */
	        get: function () {
	            var i = this._currentIndex;
	            return i !== -1 ? this._titles.at(i) : null;
	        },
	        /**
	         * Set the currently selected title.
	         *
	         * #### Notes
	         * If the title does not exist, the title will be set to `null`.
	         */
	        set: function (value) {
	            this.currentIndex = searching_1.indexOf(this._titles, value);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "currentIndex", {
	        /**
	         * Get the index of the currently selected tab.
	         *
	         * #### Notes
	         * This will be `-1` if no tab is selected.
	         */
	        get: function () {
	            return this._currentIndex;
	        },
	        /**
	         * Set the index of the currently selected tab.
	         *
	         * #### Notes
	         * If the value is out of range, the index will be set to `-1`.
	         */
	        set: function (value) {
	            // Coerce the value to an index.
	            var i = Math.floor(value);
	            if (i < 0 || i >= this._titles.length) {
	                i = -1;
	            }
	            // Bail early if the index will not change.
	            if (this._currentIndex === i) {
	                return;
	            }
	            // Look up the previous index and title.
	            var pi = this._currentIndex;
	            var pt = pi === -1 ? null : this._titles.at(pi);
	            // Look up the current index and title.
	            var ci = i;
	            var ct = ci === -1 ? null : this._titles.at(ci);
	            // Update the current index and previous title.
	            this._currentIndex = ci;
	            this._previousTitle = pt;
	            // Emit the current changed signal.
	            this.currentChanged.emit({
	                previousIndex: pi, previousTitle: pt,
	                currentIndex: ci, currentTitle: ct
	            });
	            // Schedule an update of the tabs.
	            this.update();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "orientation", {
	        /**
	         * Get the orientation of the tab bar.
	         *
	         * #### Notes
	         * This controls whether the tabs are arranged in a row or column.
	         */
	        get: function () {
	            return this._orientation;
	        },
	        /**
	         * Set the orientation of the tab bar.
	         *
	         * #### Notes
	         * This controls whether the tabs are arranged in a row or column.
	         */
	        set: function (value) {
	            // Do nothing if the orientation does not change.
	            if (this._orientation === value) {
	                return;
	            }
	            // Release the mouse before making any changes.
	            this._releaseMouse();
	            // Swap the orientation values.
	            var old = this._orientation;
	            this._orientation = value;
	            // Toggle the orientation classes.
	            this.removeClass("p-mod-" + old);
	            this.addClass("p-mod-" + value);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "tabsMovable", {
	        /**
	         * Get whether the tabs are movable by the user.
	         *
	         * #### Notes
	         * Tabs can always be moved programmatically.
	         */
	        get: function () {
	            return this._tabsMovable;
	        },
	        /**
	         * Set whether the tabs are movable by the user.
	         *
	         * #### Notes
	         * Tabs can always be moved programmatically.
	         */
	        set: function (value) {
	            this._tabsMovable = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "allowDeselect", {
	        /**
	         * Get whether a tab can be deselected by the user.
	         *
	         * #### Notes
	         * Tabs can be always be deselected programmatically.
	         */
	        get: function () {
	            return this._allowDeselect;
	        },
	        /**
	         * Set whether a tab can be deselected by the user.
	         *
	         * #### Notes
	         * Tabs can be always be deselected programmatically.
	         */
	        set: function (value) {
	            this._allowDeselect = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "insertBehavior", {
	        /**
	         * Get the selection behavior when inserting a tab.
	         */
	        get: function () {
	            return this._insertBehavior;
	        },
	        /**
	         * Set the selection behavior when inserting a tab.
	         */
	        set: function (value) {
	            this._insertBehavior = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "removeBehavior", {
	        /**
	         * Get the selection behavior when removing a tab.
	         */
	        get: function () {
	            return this._removeBehavior;
	        },
	        /**
	         * Set the selection behavior when removing a tab.
	         */
	        set: function (value) {
	            this._removeBehavior = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "renderer", {
	        /**
	         * The renderer used by the tab bar.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._renderer;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Add a tab to the end of the tab bar.
	     *
	     * @param value - The title which holds the data for the tab,
	     *   or an options object to convert to a title.
	     *
	     * @returns The title object added to the tab bar.
	     *
	     * #### Notes
	     * If the title is already added to the tab bar, it will be moved.
	     */
	    TabBar.prototype.addTab = function (value) {
	        return this.insertTab(this._titles.length, value);
	    };
	    /**
	     * Insert a tab into the tab bar at the specified index.
	     *
	     * @param index - The index at which to insert the tab.
	     *
	     * @param value - The title which holds the data for the tab,
	     *   or an options object to convert to a title.
	     *
	     * @returns The title object added to the tab bar.
	     *
	     * #### Notes
	     * The index will be clamped to the bounds of the tabs.
	     *
	     * If the title is already added to the tab bar, it will be moved.
	     */
	    TabBar.prototype.insertTab = function (index, value) {
	        // Release the mouse before making any changes.
	        this._releaseMouse();
	        // Coerce the value to a title.
	        var title = Private.asTitle(value);
	        // Look up the index of the title.
	        var i = searching_1.indexOf(this._titles, title);
	        // Clamp the insert index to the vector bounds.
	        var j = Math.max(0, Math.min(Math.floor(index), this._titles.length));
	        // If the title is not in the vector, insert it.
	        if (i === -1) {
	            // Insert the title into the vector.
	            this._titles.insert(j, title);
	            // Connect to the title changed signal.
	            title.changed.connect(this._onTitleChanged, this);
	            // Adjust the current index for the insert.
	            this._adjustCurrentForInsert(j, title);
	            // Schedule an update of the tabs.
	            this.update();
	            // Return the title added to the tab bar.
	            return title;
	        }
	        // Otherwise, the title exists in the vector and should be moved.
	        // Adjust the index if the location is at the end of the vector.
	        if (j === this._titles.length)
	            j--;
	        // Bail if there is no effective move.
	        if (i === j)
	            return title;
	        // Move the title to the new location.
	        mutation_1.move(this._titles, i, j);
	        // Adjust the current index for the move.
	        this._adjustCurrentForMove(i, j);
	        // Schedule an update of the tabs.
	        this.update();
	        // Return the title added to the tab bar.
	        return title;
	    };
	    /**
	     * Remove a tab from the tab bar.
	     *
	     * @param title - The title for the tab to remove.
	     *
	     * @returns The index occupied by the tab, or `-1` if the tab
	     *   was not contained in the tab bar.
	     */
	    TabBar.prototype.removeTab = function (title) {
	        var index = searching_1.indexOf(this._titles, title);
	        if (index !== -1)
	            this.removeTabAt(index);
	        return index;
	    };
	    /**
	     * Remove the tab at a given index from the tab bar.
	     *
	     * @param index - The index of the tab to remove.
	     *
	     * @returns The title occupying the index, or `null` if the index
	     *   is out of range.
	     */
	    TabBar.prototype.removeTabAt = function (index) {
	        // Bail if the index is out of range.
	        var i = Math.floor(index);
	        if (i < 0 || i >= this._titles.length) {
	            return null;
	        }
	        // Release the mouse before making any changes.
	        this._releaseMouse();
	        // Remove the title from the vector.
	        var title = this._titles.removeAt(i);
	        // Disconnect from the title changed signal.
	        title.changed.disconnect(this._onTitleChanged, this);
	        // Clear the previous title if it's being removed.
	        if (title === this._previousTitle) {
	            this._previousTitle = null;
	        }
	        // Adjust the current index for the remove.
	        this._adjustCurrentForRemove(i, title);
	        // Schedule an update of the tabs.
	        this.update();
	        // Return the removed title.
	        return title;
	    };
	    /**
	     * Remove all tabs from the tab bar.
	     */
	    TabBar.prototype.clearTabs = function () {
	        var _this = this;
	        // Bail if there is nothing to remove.
	        if (this._titles.length === 0) {
	            return;
	        }
	        // Release the mouse before making any changes.
	        this._releaseMouse();
	        // Disconnect from the title changed signals.
	        iteration_1.each(this._titles, function (title) {
	            title.changed.disconnect(_this._onTitleChanged, _this);
	        });
	        // Get the current index and title.
	        var pi = this.currentIndex;
	        var pt = this.currentTitle;
	        // Reset the current index and previous title.
	        this._currentIndex = -1;
	        this._previousTitle = null;
	        // Clear the title vector.
	        this._titles.clear();
	        // Schedule an update of the tabs.
	        this.update();
	        // If no tab was selected, there's nothing else to do.
	        if (pi === -1) {
	            return;
	        }
	        // Emit the current changed signal.
	        this.currentChanged.emit({
	            previousIndex: pi, previousTitle: pt,
	            currentIndex: -1, currentTitle: null
	        });
	    };
	    /**
	     * Release the mouse and restore the non-dragged tab positions.
	     *
	     * #### Notes
	     * This will cause the tab bar to stop handling mouse events and to
	     * restore the tabs to their non-dragged positions.
	     */
	    TabBar.prototype.releaseMouse = function () {
	        this._releaseMouse();
	    };
	    /**
	     * Handle the DOM events for the tab bar.
	     *
	     * @param event - The DOM event sent to the tab bar.
	     *
	     * #### Notes
	     * This method implements the DOM `EventListener` interface and is
	     * called in response to events on the tab bar's DOM node.
	     *
	     * This should not be called directly by user code.
	     */
	    TabBar.prototype.handleEvent = function (event) {
	        switch (event.type) {
	            case 'click':
	                this._evtClick(event);
	                break;
	            case 'mousedown':
	                this._evtMouseDown(event);
	                break;
	            case 'mousemove':
	                this._evtMouseMove(event);
	                break;
	            case 'mouseup':
	                this._evtMouseUp(event);
	                break;
	            case 'keydown':
	                this._evtKeyDown(event);
	                break;
	            case 'contextmenu':
	                event.preventDefault();
	                event.stopPropagation();
	                break;
	        }
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     */
	    TabBar.prototype.onAfterAttach = function (msg) {
	        this.node.addEventListener('click', this);
	        this.node.addEventListener('mousedown', this);
	    };
	    /**
	     * A message handler invoked on a `'before-detach'` message.
	     */
	    TabBar.prototype.onBeforeDetach = function (msg) {
	        this.node.removeEventListener('click', this);
	        this.node.removeEventListener('mousedown', this);
	        this._releaseMouse();
	    };
	    /**
	     * A message handler invoked on an `'update-request'` message.
	     */
	    TabBar.prototype.onUpdateRequest = function (msg) {
	        var content = [];
	        var titles = this._titles;
	        var renderer = this._renderer;
	        var currentTitle = this.currentTitle;
	        for (var i = 0, n = titles.length; i < n; ++i) {
	            var title = titles.at(i);
	            var current = title === currentTitle;
	            var zIndex = current ? n : n - i - 1;
	            content.push(renderer.renderTab({ title: title, current: current, zIndex: zIndex }));
	        }
	        vdom_1.render(content, this.contentNode);
	    };
	    /**
	     * Handle the `'keydown'` event for the tab bar.
	     */
	    TabBar.prototype._evtKeyDown = function (event) {
	        // Stop all input events during drag.
	        event.preventDefault();
	        event.stopPropagation();
	        // Release the mouse if `Escape` is pressed.
	        if (event.keyCode === 27)
	            this._releaseMouse();
	    };
	    /**
	     * Handle the `'click'` event for the tab bar.
	     */
	    TabBar.prototype._evtClick = function (event) {
	        // Do nothing if it's not a left click.
	        if (event.button !== 0) {
	            return;
	        }
	        // Do nothing if a drag is in progress.
	        if (this._dragData) {
	            return;
	        }
	        // Lookup the tab nodes.
	        var tabs = this.contentNode.children;
	        // Do nothing if the click is not on a tab.
	        var x = event.clientX;
	        var y = event.clientY;
	        var i = searching_1.findIndex(tabs, function (tab) { return query_1.hitTest(tab, x, y); });
	        if (i < 0) {
	            return;
	        }
	        // Clicking on a tab stops the event propagation.
	        event.preventDefault();
	        event.stopPropagation();
	        // Ignore the click if the title is not closable.
	        var title = this._titles.at(i);
	        if (!title.closable) {
	            return;
	        }
	        // Ignore the click if it was not on a close icon.
	        var icon = tabs[i].querySelector(this._renderer.closeIconSelector);
	        if (!icon || !icon.contains(event.target)) {
	            return;
	        }
	        // Emit the tab close requested signal.
	        this.tabCloseRequested.emit({ index: i, title: title });
	    };
	    /**
	     * Handle the `'mousedown'` event for the tab bar.
	     */
	    TabBar.prototype._evtMouseDown = function (event) {
	        // Do nothing if it's not a left mouse press.
	        if (event.button !== 0) {
	            return;
	        }
	        // Do nothing if a drag is in progress.
	        if (this._dragData) {
	            return;
	        }
	        // Lookup the tab nodes.
	        var tabs = this.contentNode.children;
	        // Do nothing if the press is not on a tab.
	        var x = event.clientX;
	        var y = event.clientY;
	        var i = searching_1.findIndex(tabs, function (tab) { return query_1.hitTest(tab, x, y); });
	        if (i < 0) {
	            return;
	        }
	        // Pressing on a tab stops the event propagation.
	        event.preventDefault();
	        event.stopPropagation();
	        // Ignore the press if it was on a close icon.
	        var icon = tabs[i].querySelector(this._renderer.closeIconSelector);
	        if (icon && icon.contains(event.target)) {
	            return;
	        }
	        // Setup the drag data if the tabs are movable.
	        if (this._tabsMovable) {
	            this._dragData = new Private.DragData();
	            this._dragData.index = i;
	            this._dragData.tab = tabs[i];
	            this._dragData.pressX = event.clientX;
	            this._dragData.pressY = event.clientY;
	            document.addEventListener('mousemove', this, true);
	            document.addEventListener('mouseup', this, true);
	            document.addEventListener('keydown', this, true);
	            document.addEventListener('contextmenu', this, true);
	        }
	        // Update the current index as appropriate.
	        if (this._allowDeselect && this._currentIndex === i) {
	            this.currentIndex = -1;
	        }
	        else {
	            this.currentIndex = i;
	        }
	    };
	    /**
	     * Handle the `'mousemove'` event for the tab bar.
	     */
	    TabBar.prototype._evtMouseMove = function (event) {
	        // Do nothing if no drag is in progress.
	        if (!this._dragData) {
	            return;
	        }
	        // Suppress the event during a drag.
	        event.preventDefault();
	        event.stopPropagation();
	        // Lookup the tab nodes.
	        var tabs = this.contentNode.children;
	        // Check the threshold if the drag is not active.
	        var data = this._dragData;
	        if (!data.dragActive) {
	            // Bail if the drag threshold is not exceeded.
	            var dx = Math.abs(event.clientX - data.pressX);
	            var dy = Math.abs(event.clientY - data.pressY);
	            if (dx < DRAG_THRESHOLD && dy < DRAG_THRESHOLD) {
	                return;
	            }
	            // Fill in the rest of the drag data measurements.
	            var tabRect = data.tab.getBoundingClientRect();
	            if (this._orientation === 'horizontal') {
	                data.tabPos = data.tab.offsetLeft;
	                data.tabSize = tabRect.width;
	                data.tabPressPos = data.pressX - tabRect.left;
	            }
	            else {
	                data.tabPos = data.tab.offsetTop;
	                data.tabSize = tabRect.height;
	                data.tabPressPos = data.pressY - tabRect.top;
	            }
	            data.tabLayout = Private.snapTabLayout(tabs, this._orientation);
	            data.contentRect = this.contentNode.getBoundingClientRect();
	            data.override = cursor_1.overrideCursor('default');
	            // Add the dragging style classes.
	            data.tab.classList.add(DRAGGING_CLASS);
	            this.addClass(DRAGGING_CLASS);
	            // Mark the drag as active.
	            data.dragActive = true;
	        }
	        // Emit the detach requested signal if the threshold is exceeded.
	        if (!data.detachRequested && Private.detachExceeded(data, event)) {
	            // Only emit the signal once per drag cycle.
	            data.detachRequested = true;
	            // Setup the arguments for the signal.
	            var index = data.index;
	            var clientX = event.clientX;
	            var clientY = event.clientY;
	            var tab = tabs[index];
	            var title = this._titles.at(index);
	            // Emit the tab detach requested signal.
	            this.tabDetachRequested.emit({ index: index, title: title, tab: tab, clientX: clientX, clientY: clientY });
	            // Bail if the signal handler aborted the drag.
	            if (data.dragAborted) {
	                return;
	            }
	        }
	        // Update the positions of the tabs.
	        Private.layoutTabs(tabs, data, event, this._orientation);
	    };
	    /**
	     * Handle the `'mouseup'` event for the tab bar.
	     */
	    TabBar.prototype._evtMouseUp = function (event) {
	        var _this = this;
	        // Do nothing if it's not a left mouse release.
	        if (event.button !== 0) {
	            return;
	        }
	        // Do nothing if no drag is in progress.
	        if (!this._dragData) {
	            return;
	        }
	        // Suppress the event during a drag operation.
	        event.preventDefault();
	        event.stopPropagation();
	        // Remove the extra mouse event listeners.
	        document.removeEventListener('mousemove', this, true);
	        document.removeEventListener('mouseup', this, true);
	        document.removeEventListener('keydown', this, true);
	        document.removeEventListener('contextmenu', this, true);
	        // Bail early if the drag is not active.
	        var data = this._dragData;
	        if (!data.dragActive) {
	            this._dragData = null;
	            return;
	        }
	        // Position the tab at its final resting position.
	        Private.finalizeTabPosition(data, this._orientation);
	        // Remove the dragging class from the tab so it can be transitioned.
	        data.tab.classList.remove(DRAGGING_CLASS);
	        // Complete the release on a timer to allow the tab to transition.
	        setTimeout(function () {
	            // Do nothing if the drag has been aborted.
	            if (data.dragAborted) {
	                return;
	            }
	            // Clear the drag data reference.
	            _this._dragData = null;
	            // Reset the positions of the tabs.
	            Private.resetTabPositions(_this.contentNode.children, _this._orientation);
	            // Clear the cursor grab.
	            data.override.dispose();
	            // Remove the remaining dragging style.
	            _this.removeClass(DRAGGING_CLASS);
	            // If the tab was not moved, there is nothing else to do.
	            var i = data.index;
	            var j = data.targetIndex;
	            if (j === -1 || i === j) {
	                return;
	            }
	            // Move the title to the new locations.
	            mutation_1.move(_this._titles, i, j);
	            // Adjust the current index for the move.
	            _this._adjustCurrentForMove(i, j);
	            // Emit the tab moved signal.
	            _this.tabMoved.emit({
	                fromIndex: i, toIndex: j, title: _this._titles.at(j)
	            });
	            // Update the tabs immediately to prevent flicker.
	            messaging_1.sendMessage(_this, widget_1.WidgetMessage.UpdateRequest);
	        }, TRANSITION_DURATION);
	    };
	    /**
	     * Release the mouse and restore the non-dragged tab positions.
	     */
	    TabBar.prototype._releaseMouse = function () {
	        // Do nothing if no drag is in progress.
	        if (!this._dragData) {
	            return;
	        }
	        // Remove the extra mouse listeners.
	        document.removeEventListener('mousemove', this, true);
	        document.removeEventListener('mouseup', this, true);
	        document.removeEventListener('keydown', this, true);
	        document.removeEventListener('contextmenu', this, true);
	        // Clear the drag data reference.
	        var data = this._dragData;
	        this._dragData = null;
	        // Indicate the drag has been aborted. This allows the mouse
	        // event handlers to return early when the drag is canceled.
	        data.dragAborted = true;
	        // If the drag is not active, there's nothing more to do.
	        if (!data.dragActive) {
	            return;
	        }
	        // Reset the tabs to their non-dragged positions.
	        Private.resetTabPositions(this.contentNode.children, this._orientation);
	        // Clear the cursor override.
	        data.override.dispose();
	        // Clear the dragging style classes.
	        data.tab.classList.remove(DRAGGING_CLASS);
	        this.removeClass(DRAGGING_CLASS);
	    };
	    /**
	     * Adjust the current index for a tab insert operation.
	     *
	     * This method accounts for the tab bar's insertion behavior when
	     * adjusting the current index and emitting the changed signal.
	     */
	    TabBar.prototype._adjustCurrentForInsert = function (i, title) {
	        // Lookup commonly used variables.
	        var ct = this.currentTitle;
	        var ci = this._currentIndex;
	        var bh = this._insertBehavior;
	        // Handle the behavior where the new tab is always selected,
	        // or the behavior where the new tab is selected if needed.
	        if (bh === 'select-tab' || (bh === 'select-tab-if-needed' && ci === -1)) {
	            this._currentIndex = i;
	            this._previousTitle = ct;
	            this.currentChanged.emit({
	                previousIndex: ci, previousTitle: ct,
	                currentIndex: i, currentTitle: title
	            });
	            return;
	        }
	        // Otherwise, silently adjust the current index if needed.
	        if (ci >= i)
	            this._currentIndex++;
	    };
	    /**
	     * Adjust the current index for a tab move operation.
	     *
	     * This method will not cause the actual current tab to change.
	     * It silently adjusts the index to account for the given move.
	     */
	    TabBar.prototype._adjustCurrentForMove = function (i, j) {
	        if (this._currentIndex === i) {
	            this._currentIndex = j;
	        }
	        else if (this._currentIndex < i && this._currentIndex >= j) {
	            this._currentIndex++;
	        }
	        else if (this._currentIndex > i && this._currentIndex <= j) {
	            this._currentIndex--;
	        }
	    };
	    /**
	     * Adjust the current index for a tab remove operation.
	     *
	     * This method accounts for the tab bar's remove behavior when
	     * adjusting the current index and emitting the changed signal.
	     */
	    TabBar.prototype._adjustCurrentForRemove = function (i, title) {
	        // Lookup commonly used variables.
	        var ci = this._currentIndex;
	        var bh = this._removeBehavior;
	        // Silently adjust the index if the current tab is not removed.
	        if (ci !== i) {
	            if (ci > i)
	                this._currentIndex--;
	            return;
	        }
	        // No tab gets selected if the tab bar is empty.
	        if (this._titles.length === 0) {
	            this._currentIndex = -1;
	            this.currentChanged.emit({
	                previousIndex: i, previousTitle: title,
	                currentIndex: -1, currentTitle: null
	            });
	            return;
	        }
	        // Handle behavior where the next sibling tab is selected.
	        if (bh === 'select-tab-after') {
	            this._currentIndex = Math.min(i, this._titles.length - 1);
	            this.currentChanged.emit({
	                previousIndex: i, previousTitle: title,
	                currentIndex: this._currentIndex, currentTitle: this.currentTitle
	            });
	            return;
	        }
	        // Handle behavior where the previous sibling tab is selected.
	        if (bh === 'select-tab-before') {
	            this._currentIndex = Math.max(0, i - 1);
	            this.currentChanged.emit({
	                previousIndex: i, previousTitle: title,
	                currentIndex: this._currentIndex, currentTitle: this.currentTitle
	            });
	            return;
	        }
	        // Handle behavior where the previous history tab is selected.
	        if (bh === 'select-previous-tab') {
	            if (this._previousTitle) {
	                this._currentIndex = searching_1.indexOf(this._titles, this._previousTitle);
	                this._previousTitle = null;
	            }
	            else {
	                this._currentIndex = Math.min(i, this._titles.length - 1);
	            }
	            this.currentChanged.emit({
	                previousIndex: i, previousTitle: title,
	                currentIndex: this._currentIndex, currentTitle: this.currentTitle
	            });
	            return;
	        }
	        // Otherwise, no tab gets selected.
	        this._currentIndex = -1;
	        this.currentChanged.emit({
	            previousIndex: i, previousTitle: title,
	            currentIndex: -1, currentTitle: null
	        });
	    };
	    /**
	     * Handle the `changed` signal of a title object.
	     */
	    TabBar.prototype._onTitleChanged = function (sender) {
	        this.update();
	    };
	    return TabBar;
	}(widget_1.Widget));
	exports.TabBar = TabBar;
	// Define the signals for the `TabBar` class.
	signaling_1.defineSignal(TabBar.prototype, 'currentChanged');
	signaling_1.defineSignal(TabBar.prototype, 'tabMoved');
	signaling_1.defineSignal(TabBar.prototype, 'tabCloseRequested');
	signaling_1.defineSignal(TabBar.prototype, 'tabDetachRequested');
	/**
	 * The namespace for the `TabBar` class statics.
	 */
	var TabBar;
	(function (TabBar) {
	    /**
	     * The default implementation of `IRenderer`.
	     */
	    var Renderer = (function () {
	        /**
	         * Construct a new renderer.
	         *
	         * @param options - The options for initializing the renderer.
	         */
	        function Renderer(options) {
	            if (options === void 0) { options = {}; }
	            this._tabID = 0;
	            this._tabKeys = new WeakMap();
	            this._extraTabClass = options.extraTabClass || '';
	        }
	        Object.defineProperty(Renderer.prototype, "closeIconSelector", {
	            /**
	             * A selector which matches the close icon node in a tab.
	             *
	             * #### Notes
	             * This is a read-only property.
	             */
	            get: function () {
	                return "." + CLOSE_ICON_CLASS;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        /**
	         * Render the node for the a tab.
	         *
	         * @param data - The data to use for rendering the tab.
	         *
	         * @returns A virtual DOM node representing the tab.
	         */
	        Renderer.prototype.renderTab = function (data) {
	            var _a = data.title, label = _a.label, caption = _a.caption;
	            var key = this.createTabKey(data);
	            var style = this.createTabStyle(data);
	            var tabClass = this.createTabClass(data);
	            var iconClass = this.createIconClass(data);
	            return (vdom_1.h.li({ key: key, className: tabClass, title: caption, style: style }, vdom_1.h.div({ className: iconClass }), vdom_1.h.div({ className: LABEL_CLASS }, label), vdom_1.h.div({ className: CLOSE_ICON_CLASS })));
	        };
	        /**
	         * Create a unique render key for the tab.
	         *
	         * @param data - The data to use for the tab.
	         *
	         * @returns The unique render key for the tab.
	         *
	         * #### Notes
	         * This method caches the key against the tab title the first time
	         * the key is generated. This enables efficient rendering of moved
	         * tabs and avoids subtle hover style artifacts.
	         */
	        Renderer.prototype.createTabKey = function (data) {
	            var key = this._tabKeys.get(data.title);
	            if (key === void 0) {
	                key = "tab-key-" + this._tabID++;
	                this._tabKeys.set(data.title, key);
	            }
	            return key;
	        };
	        /**
	         * Create the inline style object for a tab.
	         *
	         * @param data - The data to use for the tab.
	         *
	         * @returns The inline style data for the tab.
	         */
	        Renderer.prototype.createTabStyle = function (data) {
	            return { zIndex: "" + data.zIndex };
	        };
	        /**
	         * Create the class name for the tab.
	         *
	         * @param data - The data to use for the tab.
	         *
	         * @returns The full class name for the tab.
	         */
	        Renderer.prototype.createTabClass = function (data) {
	            var title = data.title, current = data.current;
	            var name = TAB_CLASS;
	            if (title.className) {
	                name += " " + title.className;
	            }
	            if (title.closable) {
	                name += " " + CLOSABLE_CLASS;
	            }
	            if (current) {
	                name += " " + CURRENT_CLASS;
	            }
	            if (this._extraTabClass) {
	                name += " " + this._extraTabClass;
	            }
	            return name;
	        };
	        /**
	         * Create the class name for the tab icon.
	         *
	         * @param data - The data to use for the tab.
	         *
	         * @returns The full class name for the tab icon.
	         */
	        Renderer.prototype.createIconClass = function (data) {
	            var title = data.title;
	            var name = ICON_CLASS;
	            if (title.icon) {
	                name += " " + title.icon;
	            }
	            return name;
	        };
	        return Renderer;
	    }());
	    TabBar.Renderer = Renderer;
	    /**
	     * The default `Renderer` instance.
	     */
	    TabBar.defaultRenderer = new Renderer();
	})(TabBar = exports.TabBar || (exports.TabBar = {}));
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * A struct which holds the drag data for a tab bar.
	     */
	    var DragData = (function () {
	        function DragData() {
	            /**
	             * The tab node being dragged.
	             */
	            this.tab = null;
	            /**
	             * The index of the tab being dragged.
	             */
	            this.index = -1;
	            /**
	             * The offset left/top of the tab being dragged.
	             */
	            this.tabPos = -1;
	            /**
	             * The offset width/height of the tab being dragged.
	             */
	            this.tabSize = -1;
	            /**
	             * The original mouse X/Y position in tab coordinates.
	             */
	            this.tabPressPos = -1;
	            /**
	             * The tab target index upon mouse release.
	             */
	            this.targetIndex = -1;
	            /**
	             * The array of tab layout objects snapped at drag start.
	             */
	            this.tabLayout = null;
	            /**
	             * The mouse press client X position.
	             */
	            this.pressX = -1;
	            /**
	             * The mouse press client Y position.
	             */
	            this.pressY = -1;
	            /**
	             * The bounding client rect of the tab bar content node.
	             */
	            this.contentRect = null;
	            /**
	             * The disposable to clean up the cursor override.
	             */
	            this.override = null;
	            /**
	             * Whether the drag is currently active.
	             */
	            this.dragActive = false;
	            /**
	             * Whether the drag has been aborted.
	             */
	            this.dragAborted = false;
	            /**
	             * Whether a detach request as been made.
	             */
	            this.detachRequested = false;
	        }
	        return DragData;
	    }());
	    Private.DragData = DragData;
	    /**
	     * Coerce a title or options into a real title.
	     */
	    function asTitle(value) {
	        return value instanceof title_1.Title ? value : new title_1.Title(value);
	    }
	    Private.asTitle = asTitle;
	    /**
	     * Get a snapshot of the current tab layout values.
	     */
	    function snapTabLayout(tabs, orientation) {
	        var layout = new Array(tabs.length);
	        if (orientation === 'horizontal') {
	            for (var i = 0, n = tabs.length; i < n; ++i) {
	                var node = tabs[i];
	                var pos = node.offsetLeft;
	                var size = node.offsetWidth;
	                var cstyle = window.getComputedStyle(node);
	                var margin = parseInt(cstyle.marginLeft, 10) || 0;
	                layout[i] = { margin: margin, pos: pos, size: size };
	            }
	        }
	        else {
	            for (var i = 0, n = tabs.length; i < n; ++i) {
	                var node = tabs[i];
	                var pos = node.offsetTop;
	                var size = node.offsetHeight;
	                var cstyle = window.getComputedStyle(node);
	                var margin = parseInt(cstyle.marginTop, 10) || 0;
	                layout[i] = { margin: margin, pos: pos, size: size };
	            }
	        }
	        return layout;
	    }
	    Private.snapTabLayout = snapTabLayout;
	    /**
	     * Test if the event exceeds the drag detach threshold.
	     */
	    function detachExceeded(data, event) {
	        var rect = data.contentRect;
	        return ((event.clientX < rect.left - DETACH_THRESHOLD) ||
	            (event.clientX >= rect.right + DETACH_THRESHOLD) ||
	            (event.clientY < rect.top - DETACH_THRESHOLD) ||
	            (event.clientY >= rect.bottom + DETACH_THRESHOLD));
	    }
	    Private.detachExceeded = detachExceeded;
	    /**
	     * Update the relative tab positions and computed target index.
	     */
	    function layoutTabs(tabs, data, event, orientation) {
	        // Compute the orientation-sensitive values.
	        var pressPos;
	        var localPos;
	        var clientPos;
	        var clientSize;
	        if (orientation === 'horizontal') {
	            pressPos = data.pressX;
	            localPos = event.clientX - data.contentRect.left;
	            clientPos = event.clientX;
	            clientSize = data.contentRect.width;
	        }
	        else {
	            pressPos = data.pressY;
	            localPos = event.clientY - data.contentRect.top;
	            clientPos = event.clientY;
	            clientSize = data.contentRect.height;
	        }
	        // Compute the target data.
	        var targetIndex = data.index;
	        var targetPos = localPos - data.tabPressPos;
	        var targetEnd = targetPos + data.tabSize;
	        // Update the relative tab positions.
	        for (var i = 0, n = tabs.length; i < n; ++i) {
	            var pxPos = void 0;
	            var layout = data.tabLayout[i];
	            var threshold = layout.pos + (layout.size >> 1);
	            if (i < data.index && targetPos < threshold) {
	                pxPos = (data.tabSize + data.tabLayout[i + 1].margin) + "px";
	                targetIndex = Math.min(targetIndex, i);
	            }
	            else if (i > data.index && targetEnd > threshold) {
	                pxPos = (-data.tabSize - layout.margin) + "px";
	                targetIndex = Math.max(targetIndex, i);
	            }
	            else if (i === data.index) {
	                var ideal = clientPos - pressPos;
	                var limit = clientSize - (data.tabPos + data.tabSize);
	                pxPos = Math.max(-data.tabPos, Math.min(ideal, limit)) + "px";
	            }
	            else {
	                pxPos = '';
	            }
	            if (orientation === 'horizontal') {
	                tabs[i].style.left = pxPos;
	            }
	            else {
	                tabs[i].style.top = pxPos;
	            }
	        }
	        // Update the computed target index.
	        data.targetIndex = targetIndex;
	    }
	    Private.layoutTabs = layoutTabs;
	    /**
	     * Position the drag tab at its final resting relative position.
	     */
	    function finalizeTabPosition(data, orientation) {
	        // Compute the orientation-sensitive client size.
	        var clientSize;
	        if (orientation === 'horizontal') {
	            clientSize = data.contentRect.width;
	        }
	        else {
	            clientSize = data.contentRect.height;
	        }
	        // Compute the ideal final tab position.
	        var ideal;
	        if (data.targetIndex === data.index) {
	            ideal = 0;
	        }
	        else if (data.targetIndex > data.index) {
	            var tgt = data.tabLayout[data.targetIndex];
	            ideal = tgt.pos + tgt.size - data.tabSize - data.tabPos;
	        }
	        else {
	            var tgt = data.tabLayout[data.targetIndex];
	            ideal = tgt.pos - data.tabPos;
	        }
	        // Compute the tab position limit.
	        var limit = clientSize - (data.tabPos + data.tabSize);
	        var final = Math.max(-data.tabPos, Math.min(ideal, limit));
	        // Set the final orientation-sensitive position.
	        if (orientation === 'horizontal') {
	            data.tab.style.left = final + "px";
	        }
	        else {
	            data.tab.style.top = final + "px";
	        }
	    }
	    Private.finalizeTabPosition = finalizeTabPosition;
	    /**
	     * Reset the relative positions of the given tabs.
	     */
	    function resetTabPositions(tabs, orientation) {
	        if (orientation === 'horizontal') {
	            iteration_1.each(tabs, function (tab) { tab.style.left = ''; });
	        }
	        else {
	            iteration_1.each(tabs, function (tab) { tab.style.top = ''; });
	        }
	    }
	    Private.resetTabPositions = resetTabPositions;
	})(Private || (Private = {}));


/***/ },
/* 38 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * A node in a virtual DOM hierarchy.
	 *
	 * #### Notes
	 * User code will not usually instantiate an node directly. Rather, the
	 * `h()` function will be called to create a node in a type-safe manner.
	 *
	 * A node *must* be treated as immutable. Mutating the state of a node
	 * **will** result in undefined rendering behavior.
	 */
	var VNode = (function () {
	    /**
	     * Construct a new virtual DOM node.
	     *
	     * @param type - The type of the node.
	     *
	     * @param tag - The node tag.
	     *
	     * @param attrs - The node attributes.
	     *
	     * @param children - The node children.
	     */
	    function VNode(type, tag, attrs, children) {
	        this.type = type;
	        this.tag = tag;
	        this.attrs = attrs;
	        this.children = children;
	    }
	    return VNode;
	}());
	exports.VNode = VNode;
	function h(tag, first) {
	    // Setup the variables to hold the parsed data.
	    var attrs;
	    var children;
	    // Parse the first variadic argument.
	    if (first) {
	        if (typeof first === 'string') {
	            children = [first];
	        }
	        else if (first instanceof VNode) {
	            children = [first];
	        }
	        else if (first instanceof Array) {
	            children = first.slice();
	        }
	        else {
	            attrs = first;
	        }
	    }
	    // Parse the rest of the variadic arguments.
	    if (arguments.length > 2) {
	        children = children || [];
	        for (var i = 2, n = arguments.length; i < n; ++i) {
	            var child = arguments[i];
	            if (child instanceof Array) {
	                for (var j = 0, k = child.length; j < k; ++j) {
	                    if (child[j])
	                        children.push(child[j]);
	                }
	            }
	            else if (child) {
	                children.push(child);
	            }
	        }
	    }
	    // Convert string literal children into text nodes.
	    if (children) {
	        for (var i = 0, n = children.length; i < n; ++i) {
	            var child = children[i];
	            if (typeof child === 'string') {
	                children[i] = Private.createTextVNode(child);
	            }
	        }
	    }
	    // Return a new virtual DOM node.
	    return Private.createElementVNode(tag, attrs, children);
	}
	exports.h = h;
	/**
	 * The namespace for the `h()` function statics.
	 */
	var h;
	(function (h) {
	    h.a = h.bind(void 0, 'a');
	    h.abbr = h.bind(void 0, 'abbr');
	    h.address = h.bind(void 0, 'address');
	    h.area = h.bind(void 0, 'area');
	    h.article = h.bind(void 0, 'article');
	    h.aside = h.bind(void 0, 'aside');
	    h.audio = h.bind(void 0, 'audio');
	    h.b = h.bind(void 0, 'b');
	    h.bdi = h.bind(void 0, 'bdi');
	    h.bdo = h.bind(void 0, 'bdo');
	    h.blockquote = h.bind(void 0, 'blockquote');
	    h.br = h.bind(void 0, 'br');
	    h.button = h.bind(void 0, 'button');
	    h.canvas = h.bind(void 0, 'canvas');
	    h.caption = h.bind(void 0, 'caption');
	    h.cite = h.bind(void 0, 'cite');
	    h.code = h.bind(void 0, 'code');
	    h.col = h.bind(void 0, 'col');
	    h.colgroup = h.bind(void 0, 'colgroup');
	    h.data = h.bind(void 0, 'data');
	    h.datalist = h.bind(void 0, 'datalist');
	    h.dd = h.bind(void 0, 'dd');
	    h.del = h.bind(void 0, 'del');
	    h.dfn = h.bind(void 0, 'dfn');
	    h.div = h.bind(void 0, 'div');
	    h.dl = h.bind(void 0, 'dl');
	    h.dt = h.bind(void 0, 'dt');
	    h.em = h.bind(void 0, 'em');
	    h.embed = h.bind(void 0, 'embed');
	    h.fieldset = h.bind(void 0, 'fieldset');
	    h.figcaption = h.bind(void 0, 'figcaption');
	    h.figure = h.bind(void 0, 'figure');
	    h.footer = h.bind(void 0, 'footer');
	    h.form = h.bind(void 0, 'form');
	    h.h1 = h.bind(void 0, 'h1');
	    h.h2 = h.bind(void 0, 'h2');
	    h.h3 = h.bind(void 0, 'h3');
	    h.h4 = h.bind(void 0, 'h4');
	    h.h5 = h.bind(void 0, 'h5');
	    h.h6 = h.bind(void 0, 'h6');
	    h.header = h.bind(void 0, 'header');
	    h.hr = h.bind(void 0, 'hr');
	    h.i = h.bind(void 0, 'i');
	    h.iframe = h.bind(void 0, 'iframe');
	    h.img = h.bind(void 0, 'img');
	    h.input = h.bind(void 0, 'input');
	    h.ins = h.bind(void 0, 'ins');
	    h.kbd = h.bind(void 0, 'kbd');
	    h.label = h.bind(void 0, 'label');
	    h.legend = h.bind(void 0, 'legend');
	    h.li = h.bind(void 0, 'li');
	    h.main = h.bind(void 0, 'main');
	    h.map = h.bind(void 0, 'map');
	    h.mark = h.bind(void 0, 'mark');
	    h.meter = h.bind(void 0, 'meter');
	    h.nav = h.bind(void 0, 'nav');
	    h.noscript = h.bind(void 0, 'noscript');
	    h.object = h.bind(void 0, 'object');
	    h.ol = h.bind(void 0, 'ol');
	    h.optgroup = h.bind(void 0, 'optgroup');
	    h.option = h.bind(void 0, 'option');
	    h.output = h.bind(void 0, 'output');
	    h.p = h.bind(void 0, 'p');
	    h.param = h.bind(void 0, 'param');
	    h.pre = h.bind(void 0, 'pre');
	    h.progress = h.bind(void 0, 'progress');
	    h.q = h.bind(void 0, 'q');
	    h.rp = h.bind(void 0, 'rp');
	    h.rt = h.bind(void 0, 'rt');
	    h.ruby = h.bind(void 0, 'ruby');
	    h.s = h.bind(void 0, 's');
	    h.samp = h.bind(void 0, 'samp');
	    h.section = h.bind(void 0, 'section');
	    h.select = h.bind(void 0, 'select');
	    h.small = h.bind(void 0, 'small');
	    h.source = h.bind(void 0, 'source');
	    h.span = h.bind(void 0, 'span');
	    h.strong = h.bind(void 0, 'strong');
	    h.sub = h.bind(void 0, 'sub');
	    h.summary = h.bind(void 0, 'summary');
	    h.sup = h.bind(void 0, 'sup');
	    h.table = h.bind(void 0, 'table');
	    h.tbody = h.bind(void 0, 'tbody');
	    h.td = h.bind(void 0, 'td');
	    h.textarea = h.bind(void 0, 'textarea');
	    h.tfoot = h.bind(void 0, 'tfoot');
	    h.th = h.bind(void 0, 'th');
	    h.thead = h.bind(void 0, 'thead');
	    h.time = h.bind(void 0, 'time');
	    h.title = h.bind(void 0, 'title');
	    h.tr = h.bind(void 0, 'tr');
	    h.track = h.bind(void 0, 'track');
	    h.u = h.bind(void 0, 'u');
	    h.ul = h.bind(void 0, 'ul');
	    h.var_ = h.bind(void 0, 'var');
	    h.video = h.bind(void 0, 'video');
	    h.wbr = h.bind(void 0, 'wbr');
	})(h = exports.h || (exports.h = {}));
	/**
	 * Create a real DOM node from a virtual DOM node.
	 *
	 * @param content - The virtual DOM content to realize.
	 *
	 * @returns A new DOM node for the given virtual DOM tree.
	 *
	 * #### Notes
	 * The content node is assumed to be of the `'element'` type.
	 *
	 * This creates a brand new *real* DOM node with a structure which
	 * matches the given virtual DOM node.
	 *
	 * If virtual diffing is desired, use the `render` function instead.
	 */
	function realize(content) {
	    return Private.realizeImpl(content);
	}
	exports.realize = realize;
	/**
	 * Render virtual DOM content into a host element.
	 *
	 * @param content - The virtual DOM content to render.
	 *
	 * @param host - The host element for the rendered content.
	 *
	 * #### Notes
	 * This renders the delta from the previous rendering. It assumes that
	 * the content of the host element is not manipulated by external code.
	 *
	 * Providing `null` content will clear the rendering.
	 *
	 * Externally modifying the provided content or the host element will
	 * result in undefined rendering behavior.
	 */
	function render(content, host) {
	    Private.renderImpl(content, host);
	}
	exports.render = render;
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Create a virtual text node for the given string.
	     */
	    function createTextVNode(text) {
	        return new VNode('text', text, emptyObject, emptyArray);
	    }
	    Private.createTextVNode = createTextVNode;
	    /**
	     * Create a virtual element node for the given parameters.
	     */
	    function createElementVNode(tag, attrs, children) {
	        attrs = attrs || emptyObject;
	        children = children || emptyArray;
	        return new VNode('element', tag, attrs, children);
	    }
	    Private.createElementVNode = createElementVNode;
	    /**
	     * The internal `realize` entry point.
	     */
	    function realizeImpl(content) {
	        return createDOMNode(content);
	    }
	    Private.realizeImpl = realizeImpl;
	    /**
	     * The internal `render` entry point.
	     */
	    function renderImpl(content, host) {
	        var oldContent = hostMap.get(host) || emptyArray;
	        var newContent = asVNodeArray(content);
	        hostMap.set(host, newContent);
	        updateContent(host, oldContent, newContent);
	    }
	    Private.renderImpl = renderImpl;
	    /**
	     * A shared frozen empty array.
	     */
	    var emptyArray = Object.freeze([]);
	    /**
	     * A shared frozen empty object.
	     */
	    var emptyObject = Object.freeze({});
	    /**
	     * A weak mapping of host element to virtual DOM content.
	     */
	    var hostMap = new WeakMap();
	    /**
	     * Coerce content into a virtual node array.
	     *
	     * Null content will be coerced to an empty array.
	     */
	    function asVNodeArray(content) {
	        if (content instanceof Array) {
	            return content;
	        }
	        if (content) {
	            return [content];
	        }
	        return emptyArray;
	    }
	    /**
	     * Update a host element with the delta of the virtual content.
	     *
	     * This is the core "diff" algorithm. There is no explicit "patch"
	     * phase. The host is patched at each step as the diff progresses.
	     */
	    function updateContent(host, oldContent, newContent) {
	        // Bail early if the content is identical. This can occur when an
	        // node has no children or if the user is rendering cached content.
	        if (oldContent === newContent) {
	            return;
	        }
	        // Collect the old keyed elems into a mapping.
	        var oldKeyed = collectKeys(host, oldContent);
	        // Create a copy of the old content which can be modified in-place.
	        var oldCopy = oldContent.slice();
	        // Update the host with the new content. The diff always proceeds
	        // forward and never modifies a previously visited index. The old
	        // copy array is modified in-place to reflect the changes made to
	        // the host children. This causes the stale nodes to be pushed to
	        // the end of the host node and removed at the end of the loop.
	        var currNode = host.firstChild;
	        var newCount = newContent.length;
	        for (var i = 0; i < newCount; ++i) {
	            // If the old elems are exhausted, create a new node.
	            if (i >= oldCopy.length) {
	                host.appendChild(createDOMNode(newContent[i]));
	                continue;
	            }
	            // Cache a reference to the old and new elems.
	            var oldVNode = oldCopy[i];
	            var newVNode = newContent[i];
	            // If the new elem is keyed, move an old keyed elem to the proper
	            // location before proceeding with the diff. The search can start
	            // at the current index, since the unmatched old keyed elems are
	            // pushed forward in the old copy array.
	            var newKey = newVNode.attrs.key;
	            if (newKey && newKey in oldKeyed) {
	                var pair = oldKeyed[newKey];
	                if (pair.vNode !== oldVNode) {
	                    arrayMove(oldCopy, oldCopy.indexOf(pair.vNode), i);
	                    host.insertBefore(pair.element, currNode);
	                    oldVNode = pair.vNode;
	                    currNode = pair.element;
	                }
	            }
	            // If both elements are identical, there is nothing to do.
	            // This can occur when the user renders cached content.
	            if (oldVNode === newVNode) {
	                currNode = currNode.nextSibling;
	                continue;
	            }
	            // If the old elem is keyed and does not match the new elem key,
	            // create a new node. This is necessary since the old keyed elem
	            // may be matched at a later point in the diff.
	            var oldKey = oldVNode.attrs.key;
	            if (oldKey && oldKey !== newKey) {
	                arrayInsert(oldCopy, i, newVNode);
	                host.insertBefore(createDOMNode(newVNode), currNode);
	                continue;
	            }
	            // If the elements have different types, create a new node.
	            if (oldVNode.type !== newVNode.type) {
	                arrayInsert(oldCopy, i, newVNode);
	                host.insertBefore(createDOMNode(newVNode), currNode);
	                continue;
	            }
	            // If the element is a text node, update its text content.
	            if (newVNode.type === 'text') {
	                currNode.textContent = newVNode.tag;
	                currNode = currNode.nextSibling;
	                continue;
	            }
	            // At this point, the node is an 'element' type. If the tags
	            // are different, create a new node.
	            if (oldVNode.tag !== newVNode.tag) {
	                arrayInsert(oldCopy, i, newVNode);
	                host.insertBefore(createDOMNode(newVNode), currNode);
	                continue;
	            }
	            // The element tags match, update the element in place.
	            updateAttrs(currNode, oldVNode.attrs, newVNode.attrs);
	            updateContent(currNode, oldVNode.children, newVNode.children);
	            currNode = currNode.nextSibling;
	        }
	        // Dispose of the old nodes pushed to the end of the host.
	        for (var i = oldCopy.length - 1; i >= newCount; --i) {
	            host.removeChild(host.lastChild);
	        }
	    }
	    /**
	     * Add attributes to a newly created DOM node.
	     */
	    function addAttrs(node, attrs) {
	        // Set the known attributes defined in the attr table.
	        for (var name_1 in attrs) {
	            var mode = attrModeTable[name_1];
	            if (mode === 0 /* Property */ || mode === 2 /* Event */) {
	                node[name_1] = attrs[name_1];
	            }
	            else if (mode === 1 /* Attribute */) {
	                node.setAttribute(name_1.toLowerCase(), attrs[name_1]);
	            }
	        }
	        // Handle the dataset values.
	        var dataset = attrs.dataset;
	        if (dataset) {
	            for (var name_2 in dataset) {
	                node.setAttribute("data-" + name_2, dataset[name_2]);
	            }
	        }
	        // Handle the inline styles.
	        var styles = attrs.style;
	        if (styles) {
	            var nodeStyle = node.style;
	            for (var name_3 in styles) {
	                nodeStyle[name_3] = styles[name_3];
	            }
	        }
	    }
	    /**
	     * Update the node attributes with the delta of attribute objects.
	     */
	    function updateAttrs(node, oldAttrs, newAttrs) {
	        // Do nothing if the attrs are the same object.
	        if (oldAttrs === newAttrs) {
	            return;
	        }
	        // Remove attributes which no longer exist.
	        for (var name_4 in oldAttrs) {
	            if (!(name_4 in newAttrs)) {
	                var mode = attrModeTable[name_4];
	                if (mode === 0 /* Property */) {
	                    node.removeAttribute(name_4);
	                }
	                else if (mode === 1 /* Attribute */) {
	                    node.removeAttribute(name_4.toLowerCase());
	                }
	                else if (mode === 2 /* Event */) {
	                    node[name_4] = null;
	                }
	            }
	        }
	        // Add new attributes an update existing ones.
	        for (var name_5 in newAttrs) {
	            var value = newAttrs[name_5];
	            if (oldAttrs[name_5] !== value) {
	                var mode = attrModeTable[name_5];
	                if (mode === 0 /* Property */ || mode === 2 /* Event */) {
	                    node[name_5] = value;
	                }
	                else if (mode === 1 /* Attribute */) {
	                    node.setAttribute(name_5.toLowerCase(), value);
	                }
	            }
	        }
	        // Handle the dataset values.
	        var oldDataset = oldAttrs.dataset || emptyObject;
	        var newDataset = newAttrs.dataset || emptyObject;
	        if (oldDataset !== newDataset) {
	            for (var name_6 in oldDataset) {
	                if (!(name_6 in newDataset)) {
	                    node.removeAttribute('data-' + name_6);
	                }
	            }
	            for (var name_7 in newDataset) {
	                var value = newDataset[name_7];
	                if (oldDataset[name_7] !== value) {
	                    node.setAttribute('data-' + name_7, value);
	                }
	            }
	        }
	        // Handle the inline styles.
	        var oldStyle = oldAttrs.style || emptyObject;
	        var newStyle = newAttrs.style || emptyObject;
	        if (oldStyle !== newStyle) {
	            var nodeStyle = node.style;
	            for (var name_8 in oldStyle) {
	                if (!(name_8 in newStyle)) {
	                    nodeStyle[name_8] = '';
	                }
	            }
	            for (var name_9 in newStyle) {
	                var value = newStyle[name_9];
	                if (oldStyle[name_9] !== value) {
	                    nodeStyle[name_9] = value;
	                }
	            }
	        }
	    }
	    /**
	     * Collect a mapping of keyed elements for the host content.
	     */
	    function collectKeys(host, content) {
	        var node = host.firstChild;
	        var keyed = Object.create(null);
	        for (var i = 0, n = content.length; i < n; ++i) {
	            var vNode = content[i];
	            if (vNode.type === 'element') {
	                var key = vNode.attrs.key;
	                if (key)
	                    keyed[key] = { vNode: vNode, element: node };
	            }
	            node = node.nextSibling;
	        }
	        return keyed;
	    }
	    /**
	     * Create and return a new DOM node for a virtual element.
	     */
	    function createDOMNode(elem) {
	        var node;
	        if (elem.type === 'text') {
	            node = document.createTextNode(elem.tag);
	        }
	        else {
	            node = document.createElement(elem.tag);
	            addAttrs(node, elem.attrs);
	            addContent(node, elem.children);
	        }
	        return node;
	    }
	    /**
	     * Create and add child content to a newly created DOM node.
	     */
	    function addContent(node, content) {
	        for (var i = 0, n = content.length; i < n; ++i) {
	            node.appendChild(createDOMNode(content[i]));
	        }
	    }
	    /**
	     * A mapping of attribute name to attribute mode.
	     */
	    var attrModeTable = {
	        accept: 0 /* Property */,
	        acceptCharset: 0 /* Property */,
	        accessKey: 0 /* Property */,
	        action: 0 /* Property */,
	        allowFullscreen: 1 /* Attribute */,
	        alt: 0 /* Property */,
	        autocomplete: 0 /* Property */,
	        autofocus: 0 /* Property */,
	        autoplay: 0 /* Property */,
	        checked: 0 /* Property */,
	        cite: 0 /* Property */,
	        className: 0 /* Property */,
	        colSpan: 0 /* Property */,
	        cols: 0 /* Property */,
	        contentEditable: 0 /* Property */,
	        controls: 0 /* Property */,
	        coords: 0 /* Property */,
	        crossOrigin: 0 /* Property */,
	        data: 0 /* Property */,
	        dateTime: 0 /* Property */,
	        default: 0 /* Property */,
	        dir: 0 /* Property */,
	        dirName: 0 /* Property */,
	        disabled: 0 /* Property */,
	        download: 0 /* Property */,
	        draggable: 0 /* Property */,
	        enctype: 0 /* Property */,
	        form: 1 /* Attribute */,
	        formAction: 0 /* Property */,
	        formEnctype: 0 /* Property */,
	        formMethod: 0 /* Property */,
	        formNoValidate: 0 /* Property */,
	        formTarget: 0 /* Property */,
	        headers: 0 /* Property */,
	        height: 0 /* Property */,
	        hidden: 0 /* Property */,
	        high: 0 /* Property */,
	        href: 0 /* Property */,
	        hreflang: 0 /* Property */,
	        htmlFor: 0 /* Property */,
	        id: 0 /* Property */,
	        inputMode: 0 /* Property */,
	        isMap: 0 /* Property */,
	        kind: 0 /* Property */,
	        label: 0 /* Property */,
	        lang: 0 /* Property */,
	        list: 1 /* Attribute */,
	        loop: 0 /* Property */,
	        low: 0 /* Property */,
	        max: 0 /* Property */,
	        maxLength: 0 /* Property */,
	        media: 1 /* Attribute */,
	        mediaGroup: 0 /* Property */,
	        method: 0 /* Property */,
	        min: 0 /* Property */,
	        minLength: 0 /* Property */,
	        multiple: 0 /* Property */,
	        muted: 0 /* Property */,
	        name: 0 /* Property */,
	        noValidate: 0 /* Property */,
	        optimum: 0 /* Property */,
	        pattern: 0 /* Property */,
	        placeholder: 0 /* Property */,
	        poster: 0 /* Property */,
	        preload: 0 /* Property */,
	        readOnly: 0 /* Property */,
	        rel: 0 /* Property */,
	        required: 0 /* Property */,
	        reversed: 0 /* Property */,
	        rowSpan: 0 /* Property */,
	        rows: 0 /* Property */,
	        sandbox: 0 /* Property */,
	        scope: 0 /* Property */,
	        seamless: 1 /* Attribute */,
	        selected: 0 /* Property */,
	        shape: 0 /* Property */,
	        size: 0 /* Property */,
	        sizes: 1 /* Attribute */,
	        sorted: 0 /* Property */,
	        span: 0 /* Property */,
	        spellcheck: 0 /* Property */,
	        src: 0 /* Property */,
	        srcdoc: 0 /* Property */,
	        srclang: 0 /* Property */,
	        srcset: 1 /* Attribute */,
	        start: 0 /* Property */,
	        step: 0 /* Property */,
	        tabIndex: 0 /* Property */,
	        target: 0 /* Property */,
	        title: 0 /* Property */,
	        type: 0 /* Property */,
	        typeMustMatch: 0 /* Property */,
	        useMap: 0 /* Property */,
	        value: 0 /* Property */,
	        volume: 0 /* Property */,
	        width: 0 /* Property */,
	        wrap: 0 /* Property */,
	        onabort: 2 /* Event */,
	        onbeforecopy: 2 /* Event */,
	        onbeforecut: 2 /* Event */,
	        onbeforepaste: 2 /* Event */,
	        onblur: 2 /* Event */,
	        oncanplay: 2 /* Event */,
	        oncanplaythrough: 2 /* Event */,
	        onchange: 2 /* Event */,
	        onclick: 2 /* Event */,
	        oncontextmenu: 2 /* Event */,
	        oncopy: 2 /* Event */,
	        oncuechange: 2 /* Event */,
	        oncut: 2 /* Event */,
	        ondblclick: 2 /* Event */,
	        ondrag: 2 /* Event */,
	        ondragend: 2 /* Event */,
	        ondragenter: 2 /* Event */,
	        ondragleave: 2 /* Event */,
	        ondragover: 2 /* Event */,
	        ondragstart: 2 /* Event */,
	        ondrop: 2 /* Event */,
	        ondurationchange: 2 /* Event */,
	        onended: 2 /* Event */,
	        onemptied: 2 /* Event */,
	        onerror: 2 /* Event */,
	        onfocus: 2 /* Event */,
	        onhelp: 2 /* Event */,
	        oninput: 2 /* Event */,
	        onkeydown: 2 /* Event */,
	        onkeypress: 2 /* Event */,
	        onkeyup: 2 /* Event */,
	        onload: 2 /* Event */,
	        onloadeddata: 2 /* Event */,
	        onloadedmetadata: 2 /* Event */,
	        onloadstart: 2 /* Event */,
	        onmousedown: 2 /* Event */,
	        onmouseenter: 2 /* Event */,
	        onmouseleave: 2 /* Event */,
	        onmousemove: 2 /* Event */,
	        onmouseout: 2 /* Event */,
	        onmouseover: 2 /* Event */,
	        onmouseup: 2 /* Event */,
	        onmousewheel: 2 /* Event */,
	        onpaste: 2 /* Event */,
	        onpause: 2 /* Event */,
	        onplay: 2 /* Event */,
	        onplaying: 2 /* Event */,
	        onprogress: 2 /* Event */,
	        onratechange: 2 /* Event */,
	        onreadystatechange: 2 /* Event */,
	        onreset: 2 /* Event */,
	        onscroll: 2 /* Event */,
	        onseeked: 2 /* Event */,
	        onseeking: 2 /* Event */,
	        onselect: 2 /* Event */,
	        onselectstart: 2 /* Event */,
	        onstalled: 2 /* Event */,
	        onsubmit: 2 /* Event */,
	        onsuspend: 2 /* Event */,
	        ontimeupdate: 2 /* Event */,
	        onvolumechange: 2 /* Event */,
	        onwaiting: 2 /* Event */
	    };
	    /**
	     * Insert an element into an array at a specified index.
	     */
	    function arrayInsert(array, i, value) {
	        for (var k = array.length; k > i; --k) {
	            array[k] = array[k - 1];
	        }
	        array[i] = value;
	    }
	    /**
	     * Move an element in an array from one index to another.
	     */
	    function arrayMove(array, i, j) {
	        if (i === j) {
	            return;
	        }
	        var value = array[i];
	        var d = i < j ? 1 : -1;
	        for (var k = i; k !== j; k += d) {
	            array[k] = array[k + d];
	        }
	        array[j] = value;
	    }
	})(Private || (Private = {}));


/***/ },
/* 39 */
/***/ function(module, exports, __webpack_require__) {

	var require;var __WEBPACK_AMD_DEFINE_RESULT__;/* WEBPACK VAR INJECTION */(function(process, global, module) {/*!
	 * @overview es6-promise - a tiny implementation of Promises/A+.
	 * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
	 * @license   Licensed under MIT license
	 *            See https://raw.githubusercontent.com/jakearchibald/es6-promise/master/LICENSE
	 * @version   3.2.1
	 */
	
	(function() {
	    "use strict";
	    function lib$es6$promise$utils$$objectOrFunction(x) {
	      return typeof x === 'function' || (typeof x === 'object' && x !== null);
	    }
	
	    function lib$es6$promise$utils$$isFunction(x) {
	      return typeof x === 'function';
	    }
	
	    function lib$es6$promise$utils$$isMaybeThenable(x) {
	      return typeof x === 'object' && x !== null;
	    }
	
	    var lib$es6$promise$utils$$_isArray;
	    if (!Array.isArray) {
	      lib$es6$promise$utils$$_isArray = function (x) {
	        return Object.prototype.toString.call(x) === '[object Array]';
	      };
	    } else {
	      lib$es6$promise$utils$$_isArray = Array.isArray;
	    }
	
	    var lib$es6$promise$utils$$isArray = lib$es6$promise$utils$$_isArray;
	    var lib$es6$promise$asap$$len = 0;
	    var lib$es6$promise$asap$$vertxNext;
	    var lib$es6$promise$asap$$customSchedulerFn;
	
	    var lib$es6$promise$asap$$asap = function asap(callback, arg) {
	      lib$es6$promise$asap$$queue[lib$es6$promise$asap$$len] = callback;
	      lib$es6$promise$asap$$queue[lib$es6$promise$asap$$len + 1] = arg;
	      lib$es6$promise$asap$$len += 2;
	      if (lib$es6$promise$asap$$len === 2) {
	        // If len is 2, that means that we need to schedule an async flush.
	        // If additional callbacks are queued before the queue is flushed, they
	        // will be processed by this flush that we are scheduling.
	        if (lib$es6$promise$asap$$customSchedulerFn) {
	          lib$es6$promise$asap$$customSchedulerFn(lib$es6$promise$asap$$flush);
	        } else {
	          lib$es6$promise$asap$$scheduleFlush();
	        }
	      }
	    }
	
	    function lib$es6$promise$asap$$setScheduler(scheduleFn) {
	      lib$es6$promise$asap$$customSchedulerFn = scheduleFn;
	    }
	
	    function lib$es6$promise$asap$$setAsap(asapFn) {
	      lib$es6$promise$asap$$asap = asapFn;
	    }
	
	    var lib$es6$promise$asap$$browserWindow = (typeof window !== 'undefined') ? window : undefined;
	    var lib$es6$promise$asap$$browserGlobal = lib$es6$promise$asap$$browserWindow || {};
	    var lib$es6$promise$asap$$BrowserMutationObserver = lib$es6$promise$asap$$browserGlobal.MutationObserver || lib$es6$promise$asap$$browserGlobal.WebKitMutationObserver;
	    var lib$es6$promise$asap$$isNode = typeof self === 'undefined' && typeof process !== 'undefined' && {}.toString.call(process) === '[object process]';
	
	    // test for web worker but not in IE10
	    var lib$es6$promise$asap$$isWorker = typeof Uint8ClampedArray !== 'undefined' &&
	      typeof importScripts !== 'undefined' &&
	      typeof MessageChannel !== 'undefined';
	
	    // node
	    function lib$es6$promise$asap$$useNextTick() {
	      // node version 0.10.x displays a deprecation warning when nextTick is used recursively
	      // see https://github.com/cujojs/when/issues/410 for details
	      return function() {
	        process.nextTick(lib$es6$promise$asap$$flush);
	      };
	    }
	
	    // vertx
	    function lib$es6$promise$asap$$useVertxTimer() {
	      return function() {
	        lib$es6$promise$asap$$vertxNext(lib$es6$promise$asap$$flush);
	      };
	    }
	
	    function lib$es6$promise$asap$$useMutationObserver() {
	      var iterations = 0;
	      var observer = new lib$es6$promise$asap$$BrowserMutationObserver(lib$es6$promise$asap$$flush);
	      var node = document.createTextNode('');
	      observer.observe(node, { characterData: true });
	
	      return function() {
	        node.data = (iterations = ++iterations % 2);
	      };
	    }
	
	    // web worker
	    function lib$es6$promise$asap$$useMessageChannel() {
	      var channel = new MessageChannel();
	      channel.port1.onmessage = lib$es6$promise$asap$$flush;
	      return function () {
	        channel.port2.postMessage(0);
	      };
	    }
	
	    function lib$es6$promise$asap$$useSetTimeout() {
	      return function() {
	        setTimeout(lib$es6$promise$asap$$flush, 1);
	      };
	    }
	
	    var lib$es6$promise$asap$$queue = new Array(1000);
	    function lib$es6$promise$asap$$flush() {
	      for (var i = 0; i < lib$es6$promise$asap$$len; i+=2) {
	        var callback = lib$es6$promise$asap$$queue[i];
	        var arg = lib$es6$promise$asap$$queue[i+1];
	
	        callback(arg);
	
	        lib$es6$promise$asap$$queue[i] = undefined;
	        lib$es6$promise$asap$$queue[i+1] = undefined;
	      }
	
	      lib$es6$promise$asap$$len = 0;
	    }
	
	    function lib$es6$promise$asap$$attemptVertx() {
	      try {
	        var r = require;
	        var vertx = __webpack_require__(41);
	        lib$es6$promise$asap$$vertxNext = vertx.runOnLoop || vertx.runOnContext;
	        return lib$es6$promise$asap$$useVertxTimer();
	      } catch(e) {
	        return lib$es6$promise$asap$$useSetTimeout();
	      }
	    }
	
	    var lib$es6$promise$asap$$scheduleFlush;
	    // Decide what async method to use to triggering processing of queued callbacks:
	    if (lib$es6$promise$asap$$isNode) {
	      lib$es6$promise$asap$$scheduleFlush = lib$es6$promise$asap$$useNextTick();
	    } else if (lib$es6$promise$asap$$BrowserMutationObserver) {
	      lib$es6$promise$asap$$scheduleFlush = lib$es6$promise$asap$$useMutationObserver();
	    } else if (lib$es6$promise$asap$$isWorker) {
	      lib$es6$promise$asap$$scheduleFlush = lib$es6$promise$asap$$useMessageChannel();
	    } else if (lib$es6$promise$asap$$browserWindow === undefined && "function" === 'function') {
	      lib$es6$promise$asap$$scheduleFlush = lib$es6$promise$asap$$attemptVertx();
	    } else {
	      lib$es6$promise$asap$$scheduleFlush = lib$es6$promise$asap$$useSetTimeout();
	    }
	    function lib$es6$promise$then$$then(onFulfillment, onRejection) {
	      var parent = this;
	
	      var child = new this.constructor(lib$es6$promise$$internal$$noop);
	
	      if (child[lib$es6$promise$$internal$$PROMISE_ID] === undefined) {
	        lib$es6$promise$$internal$$makePromise(child);
	      }
	
	      var state = parent._state;
	
	      if (state) {
	        var callback = arguments[state - 1];
	        lib$es6$promise$asap$$asap(function(){
	          lib$es6$promise$$internal$$invokeCallback(state, child, callback, parent._result);
	        });
	      } else {
	        lib$es6$promise$$internal$$subscribe(parent, child, onFulfillment, onRejection);
	      }
	
	      return child;
	    }
	    var lib$es6$promise$then$$default = lib$es6$promise$then$$then;
	    function lib$es6$promise$promise$resolve$$resolve(object) {
	      /*jshint validthis:true */
	      var Constructor = this;
	
	      if (object && typeof object === 'object' && object.constructor === Constructor) {
	        return object;
	      }
	
	      var promise = new Constructor(lib$es6$promise$$internal$$noop);
	      lib$es6$promise$$internal$$resolve(promise, object);
	      return promise;
	    }
	    var lib$es6$promise$promise$resolve$$default = lib$es6$promise$promise$resolve$$resolve;
	    var lib$es6$promise$$internal$$PROMISE_ID = Math.random().toString(36).substring(16);
	
	    function lib$es6$promise$$internal$$noop() {}
	
	    var lib$es6$promise$$internal$$PENDING   = void 0;
	    var lib$es6$promise$$internal$$FULFILLED = 1;
	    var lib$es6$promise$$internal$$REJECTED  = 2;
	
	    var lib$es6$promise$$internal$$GET_THEN_ERROR = new lib$es6$promise$$internal$$ErrorObject();
	
	    function lib$es6$promise$$internal$$selfFulfillment() {
	      return new TypeError("You cannot resolve a promise with itself");
	    }
	
	    function lib$es6$promise$$internal$$cannotReturnOwn() {
	      return new TypeError('A promises callback cannot return that same promise.');
	    }
	
	    function lib$es6$promise$$internal$$getThen(promise) {
	      try {
	        return promise.then;
	      } catch(error) {
	        lib$es6$promise$$internal$$GET_THEN_ERROR.error = error;
	        return lib$es6$promise$$internal$$GET_THEN_ERROR;
	      }
	    }
	
	    function lib$es6$promise$$internal$$tryThen(then, value, fulfillmentHandler, rejectionHandler) {
	      try {
	        then.call(value, fulfillmentHandler, rejectionHandler);
	      } catch(e) {
	        return e;
	      }
	    }
	
	    function lib$es6$promise$$internal$$handleForeignThenable(promise, thenable, then) {
	       lib$es6$promise$asap$$asap(function(promise) {
	        var sealed = false;
	        var error = lib$es6$promise$$internal$$tryThen(then, thenable, function(value) {
	          if (sealed) { return; }
	          sealed = true;
	          if (thenable !== value) {
	            lib$es6$promise$$internal$$resolve(promise, value);
	          } else {
	            lib$es6$promise$$internal$$fulfill(promise, value);
	          }
	        }, function(reason) {
	          if (sealed) { return; }
	          sealed = true;
	
	          lib$es6$promise$$internal$$reject(promise, reason);
	        }, 'Settle: ' + (promise._label || ' unknown promise'));
	
	        if (!sealed && error) {
	          sealed = true;
	          lib$es6$promise$$internal$$reject(promise, error);
	        }
	      }, promise);
	    }
	
	    function lib$es6$promise$$internal$$handleOwnThenable(promise, thenable) {
	      if (thenable._state === lib$es6$promise$$internal$$FULFILLED) {
	        lib$es6$promise$$internal$$fulfill(promise, thenable._result);
	      } else if (thenable._state === lib$es6$promise$$internal$$REJECTED) {
	        lib$es6$promise$$internal$$reject(promise, thenable._result);
	      } else {
	        lib$es6$promise$$internal$$subscribe(thenable, undefined, function(value) {
	          lib$es6$promise$$internal$$resolve(promise, value);
	        }, function(reason) {
	          lib$es6$promise$$internal$$reject(promise, reason);
	        });
	      }
	    }
	
	    function lib$es6$promise$$internal$$handleMaybeThenable(promise, maybeThenable, then) {
	      if (maybeThenable.constructor === promise.constructor &&
	          then === lib$es6$promise$then$$default &&
	          constructor.resolve === lib$es6$promise$promise$resolve$$default) {
	        lib$es6$promise$$internal$$handleOwnThenable(promise, maybeThenable);
	      } else {
	        if (then === lib$es6$promise$$internal$$GET_THEN_ERROR) {
	          lib$es6$promise$$internal$$reject(promise, lib$es6$promise$$internal$$GET_THEN_ERROR.error);
	        } else if (then === undefined) {
	          lib$es6$promise$$internal$$fulfill(promise, maybeThenable);
	        } else if (lib$es6$promise$utils$$isFunction(then)) {
	          lib$es6$promise$$internal$$handleForeignThenable(promise, maybeThenable, then);
	        } else {
	          lib$es6$promise$$internal$$fulfill(promise, maybeThenable);
	        }
	      }
	    }
	
	    function lib$es6$promise$$internal$$resolve(promise, value) {
	      if (promise === value) {
	        lib$es6$promise$$internal$$reject(promise, lib$es6$promise$$internal$$selfFulfillment());
	      } else if (lib$es6$promise$utils$$objectOrFunction(value)) {
	        lib$es6$promise$$internal$$handleMaybeThenable(promise, value, lib$es6$promise$$internal$$getThen(value));
	      } else {
	        lib$es6$promise$$internal$$fulfill(promise, value);
	      }
	    }
	
	    function lib$es6$promise$$internal$$publishRejection(promise) {
	      if (promise._onerror) {
	        promise._onerror(promise._result);
	      }
	
	      lib$es6$promise$$internal$$publish(promise);
	    }
	
	    function lib$es6$promise$$internal$$fulfill(promise, value) {
	      if (promise._state !== lib$es6$promise$$internal$$PENDING) { return; }
	
	      promise._result = value;
	      promise._state = lib$es6$promise$$internal$$FULFILLED;
	
	      if (promise._subscribers.length !== 0) {
	        lib$es6$promise$asap$$asap(lib$es6$promise$$internal$$publish, promise);
	      }
	    }
	
	    function lib$es6$promise$$internal$$reject(promise, reason) {
	      if (promise._state !== lib$es6$promise$$internal$$PENDING) { return; }
	      promise._state = lib$es6$promise$$internal$$REJECTED;
	      promise._result = reason;
	
	      lib$es6$promise$asap$$asap(lib$es6$promise$$internal$$publishRejection, promise);
	    }
	
	    function lib$es6$promise$$internal$$subscribe(parent, child, onFulfillment, onRejection) {
	      var subscribers = parent._subscribers;
	      var length = subscribers.length;
	
	      parent._onerror = null;
	
	      subscribers[length] = child;
	      subscribers[length + lib$es6$promise$$internal$$FULFILLED] = onFulfillment;
	      subscribers[length + lib$es6$promise$$internal$$REJECTED]  = onRejection;
	
	      if (length === 0 && parent._state) {
	        lib$es6$promise$asap$$asap(lib$es6$promise$$internal$$publish, parent);
	      }
	    }
	
	    function lib$es6$promise$$internal$$publish(promise) {
	      var subscribers = promise._subscribers;
	      var settled = promise._state;
	
	      if (subscribers.length === 0) { return; }
	
	      var child, callback, detail = promise._result;
	
	      for (var i = 0; i < subscribers.length; i += 3) {
	        child = subscribers[i];
	        callback = subscribers[i + settled];
	
	        if (child) {
	          lib$es6$promise$$internal$$invokeCallback(settled, child, callback, detail);
	        } else {
	          callback(detail);
	        }
	      }
	
	      promise._subscribers.length = 0;
	    }
	
	    function lib$es6$promise$$internal$$ErrorObject() {
	      this.error = null;
	    }
	
	    var lib$es6$promise$$internal$$TRY_CATCH_ERROR = new lib$es6$promise$$internal$$ErrorObject();
	
	    function lib$es6$promise$$internal$$tryCatch(callback, detail) {
	      try {
	        return callback(detail);
	      } catch(e) {
	        lib$es6$promise$$internal$$TRY_CATCH_ERROR.error = e;
	        return lib$es6$promise$$internal$$TRY_CATCH_ERROR;
	      }
	    }
	
	    function lib$es6$promise$$internal$$invokeCallback(settled, promise, callback, detail) {
	      var hasCallback = lib$es6$promise$utils$$isFunction(callback),
	          value, error, succeeded, failed;
	
	      if (hasCallback) {
	        value = lib$es6$promise$$internal$$tryCatch(callback, detail);
	
	        if (value === lib$es6$promise$$internal$$TRY_CATCH_ERROR) {
	          failed = true;
	          error = value.error;
	          value = null;
	        } else {
	          succeeded = true;
	        }
	
	        if (promise === value) {
	          lib$es6$promise$$internal$$reject(promise, lib$es6$promise$$internal$$cannotReturnOwn());
	          return;
	        }
	
	      } else {
	        value = detail;
	        succeeded = true;
	      }
	
	      if (promise._state !== lib$es6$promise$$internal$$PENDING) {
	        // noop
	      } else if (hasCallback && succeeded) {
	        lib$es6$promise$$internal$$resolve(promise, value);
	      } else if (failed) {
	        lib$es6$promise$$internal$$reject(promise, error);
	      } else if (settled === lib$es6$promise$$internal$$FULFILLED) {
	        lib$es6$promise$$internal$$fulfill(promise, value);
	      } else if (settled === lib$es6$promise$$internal$$REJECTED) {
	        lib$es6$promise$$internal$$reject(promise, value);
	      }
	    }
	
	    function lib$es6$promise$$internal$$initializePromise(promise, resolver) {
	      try {
	        resolver(function resolvePromise(value){
	          lib$es6$promise$$internal$$resolve(promise, value);
	        }, function rejectPromise(reason) {
	          lib$es6$promise$$internal$$reject(promise, reason);
	        });
	      } catch(e) {
	        lib$es6$promise$$internal$$reject(promise, e);
	      }
	    }
	
	    var lib$es6$promise$$internal$$id = 0;
	    function lib$es6$promise$$internal$$nextId() {
	      return lib$es6$promise$$internal$$id++;
	    }
	
	    function lib$es6$promise$$internal$$makePromise(promise) {
	      promise[lib$es6$promise$$internal$$PROMISE_ID] = lib$es6$promise$$internal$$id++;
	      promise._state = undefined;
	      promise._result = undefined;
	      promise._subscribers = [];
	    }
	
	    function lib$es6$promise$promise$all$$all(entries) {
	      return new lib$es6$promise$enumerator$$default(this, entries).promise;
	    }
	    var lib$es6$promise$promise$all$$default = lib$es6$promise$promise$all$$all;
	    function lib$es6$promise$promise$race$$race(entries) {
	      /*jshint validthis:true */
	      var Constructor = this;
	
	      if (!lib$es6$promise$utils$$isArray(entries)) {
	        return new Constructor(function(resolve, reject) {
	          reject(new TypeError('You must pass an array to race.'));
	        });
	      } else {
	        return new Constructor(function(resolve, reject) {
	          var length = entries.length;
	          for (var i = 0; i < length; i++) {
	            Constructor.resolve(entries[i]).then(resolve, reject);
	          }
	        });
	      }
	    }
	    var lib$es6$promise$promise$race$$default = lib$es6$promise$promise$race$$race;
	    function lib$es6$promise$promise$reject$$reject(reason) {
	      /*jshint validthis:true */
	      var Constructor = this;
	      var promise = new Constructor(lib$es6$promise$$internal$$noop);
	      lib$es6$promise$$internal$$reject(promise, reason);
	      return promise;
	    }
	    var lib$es6$promise$promise$reject$$default = lib$es6$promise$promise$reject$$reject;
	
	
	    function lib$es6$promise$promise$$needsResolver() {
	      throw new TypeError('You must pass a resolver function as the first argument to the promise constructor');
	    }
	
	    function lib$es6$promise$promise$$needsNew() {
	      throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.");
	    }
	
	    var lib$es6$promise$promise$$default = lib$es6$promise$promise$$Promise;
	    /**
	      Promise objects represent the eventual result of an asynchronous operation. The
	      primary way of interacting with a promise is through its `then` method, which
	      registers callbacks to receive either a promise's eventual value or the reason
	      why the promise cannot be fulfilled.
	
	      Terminology
	      -----------
	
	      - `promise` is an object or function with a `then` method whose behavior conforms to this specification.
	      - `thenable` is an object or function that defines a `then` method.
	      - `value` is any legal JavaScript value (including undefined, a thenable, or a promise).
	      - `exception` is a value that is thrown using the throw statement.
	      - `reason` is a value that indicates why a promise was rejected.
	      - `settled` the final resting state of a promise, fulfilled or rejected.
	
	      A promise can be in one of three states: pending, fulfilled, or rejected.
	
	      Promises that are fulfilled have a fulfillment value and are in the fulfilled
	      state.  Promises that are rejected have a rejection reason and are in the
	      rejected state.  A fulfillment value is never a thenable.
	
	      Promises can also be said to *resolve* a value.  If this value is also a
	      promise, then the original promise's settled state will match the value's
	      settled state.  So a promise that *resolves* a promise that rejects will
	      itself reject, and a promise that *resolves* a promise that fulfills will
	      itself fulfill.
	
	
	      Basic Usage:
	      ------------
	
	      ```js
	      var promise = new Promise(function(resolve, reject) {
	        // on success
	        resolve(value);
	
	        // on failure
	        reject(reason);
	      });
	
	      promise.then(function(value) {
	        // on fulfillment
	      }, function(reason) {
	        // on rejection
	      });
	      ```
	
	      Advanced Usage:
	      ---------------
	
	      Promises shine when abstracting away asynchronous interactions such as
	      `XMLHttpRequest`s.
	
	      ```js
	      function getJSON(url) {
	        return new Promise(function(resolve, reject){
	          var xhr = new XMLHttpRequest();
	
	          xhr.open('GET', url);
	          xhr.onreadystatechange = handler;
	          xhr.responseType = 'json';
	          xhr.setRequestHeader('Accept', 'application/json');
	          xhr.send();
	
	          function handler() {
	            if (this.readyState === this.DONE) {
	              if (this.status === 200) {
	                resolve(this.response);
	              } else {
	                reject(new Error('getJSON: `' + url + '` failed with status: [' + this.status + ']'));
	              }
	            }
	          };
	        });
	      }
	
	      getJSON('/posts.json').then(function(json) {
	        // on fulfillment
	      }, function(reason) {
	        // on rejection
	      });
	      ```
	
	      Unlike callbacks, promises are great composable primitives.
	
	      ```js
	      Promise.all([
	        getJSON('/posts'),
	        getJSON('/comments')
	      ]).then(function(values){
	        values[0] // => postsJSON
	        values[1] // => commentsJSON
	
	        return values;
	      });
	      ```
	
	      @class Promise
	      @param {function} resolver
	      Useful for tooling.
	      @constructor
	    */
	    function lib$es6$promise$promise$$Promise(resolver) {
	      this[lib$es6$promise$$internal$$PROMISE_ID] = lib$es6$promise$$internal$$nextId();
	      this._result = this._state = undefined;
	      this._subscribers = [];
	
	      if (lib$es6$promise$$internal$$noop !== resolver) {
	        typeof resolver !== 'function' && lib$es6$promise$promise$$needsResolver();
	        this instanceof lib$es6$promise$promise$$Promise ? lib$es6$promise$$internal$$initializePromise(this, resolver) : lib$es6$promise$promise$$needsNew();
	      }
	    }
	
	    lib$es6$promise$promise$$Promise.all = lib$es6$promise$promise$all$$default;
	    lib$es6$promise$promise$$Promise.race = lib$es6$promise$promise$race$$default;
	    lib$es6$promise$promise$$Promise.resolve = lib$es6$promise$promise$resolve$$default;
	    lib$es6$promise$promise$$Promise.reject = lib$es6$promise$promise$reject$$default;
	    lib$es6$promise$promise$$Promise._setScheduler = lib$es6$promise$asap$$setScheduler;
	    lib$es6$promise$promise$$Promise._setAsap = lib$es6$promise$asap$$setAsap;
	    lib$es6$promise$promise$$Promise._asap = lib$es6$promise$asap$$asap;
	
	    lib$es6$promise$promise$$Promise.prototype = {
	      constructor: lib$es6$promise$promise$$Promise,
	
	    /**
	      The primary way of interacting with a promise is through its `then` method,
	      which registers callbacks to receive either a promise's eventual value or the
	      reason why the promise cannot be fulfilled.
	
	      ```js
	      findUser().then(function(user){
	        // user is available
	      }, function(reason){
	        // user is unavailable, and you are given the reason why
	      });
	      ```
	
	      Chaining
	      --------
	
	      The return value of `then` is itself a promise.  This second, 'downstream'
	      promise is resolved with the return value of the first promise's fulfillment
	      or rejection handler, or rejected if the handler throws an exception.
	
	      ```js
	      findUser().then(function (user) {
	        return user.name;
	      }, function (reason) {
	        return 'default name';
	      }).then(function (userName) {
	        // If `findUser` fulfilled, `userName` will be the user's name, otherwise it
	        // will be `'default name'`
	      });
	
	      findUser().then(function (user) {
	        throw new Error('Found user, but still unhappy');
	      }, function (reason) {
	        throw new Error('`findUser` rejected and we're unhappy');
	      }).then(function (value) {
	        // never reached
	      }, function (reason) {
	        // if `findUser` fulfilled, `reason` will be 'Found user, but still unhappy'.
	        // If `findUser` rejected, `reason` will be '`findUser` rejected and we're unhappy'.
	      });
	      ```
	      If the downstream promise does not specify a rejection handler, rejection reasons will be propagated further downstream.
	
	      ```js
	      findUser().then(function (user) {
	        throw new PedagogicalException('Upstream error');
	      }).then(function (value) {
	        // never reached
	      }).then(function (value) {
	        // never reached
	      }, function (reason) {
	        // The `PedgagocialException` is propagated all the way down to here
	      });
	      ```
	
	      Assimilation
	      ------------
	
	      Sometimes the value you want to propagate to a downstream promise can only be
	      retrieved asynchronously. This can be achieved by returning a promise in the
	      fulfillment or rejection handler. The downstream promise will then be pending
	      until the returned promise is settled. This is called *assimilation*.
	
	      ```js
	      findUser().then(function (user) {
	        return findCommentsByAuthor(user);
	      }).then(function (comments) {
	        // The user's comments are now available
	      });
	      ```
	
	      If the assimliated promise rejects, then the downstream promise will also reject.
	
	      ```js
	      findUser().then(function (user) {
	        return findCommentsByAuthor(user);
	      }).then(function (comments) {
	        // If `findCommentsByAuthor` fulfills, we'll have the value here
	      }, function (reason) {
	        // If `findCommentsByAuthor` rejects, we'll have the reason here
	      });
	      ```
	
	      Simple Example
	      --------------
	
	      Synchronous Example
	
	      ```javascript
	      var result;
	
	      try {
	        result = findResult();
	        // success
	      } catch(reason) {
	        // failure
	      }
	      ```
	
	      Errback Example
	
	      ```js
	      findResult(function(result, err){
	        if (err) {
	          // failure
	        } else {
	          // success
	        }
	      });
	      ```
	
	      Promise Example;
	
	      ```javascript
	      findResult().then(function(result){
	        // success
	      }, function(reason){
	        // failure
	      });
	      ```
	
	      Advanced Example
	      --------------
	
	      Synchronous Example
	
	      ```javascript
	      var author, books;
	
	      try {
	        author = findAuthor();
	        books  = findBooksByAuthor(author);
	        // success
	      } catch(reason) {
	        // failure
	      }
	      ```
	
	      Errback Example
	
	      ```js
	
	      function foundBooks(books) {
	
	      }
	
	      function failure(reason) {
	
	      }
	
	      findAuthor(function(author, err){
	        if (err) {
	          failure(err);
	          // failure
	        } else {
	          try {
	            findBoooksByAuthor(author, function(books, err) {
	              if (err) {
	                failure(err);
	              } else {
	                try {
	                  foundBooks(books);
	                } catch(reason) {
	                  failure(reason);
	                }
	              }
	            });
	          } catch(error) {
	            failure(err);
	          }
	          // success
	        }
	      });
	      ```
	
	      Promise Example;
	
	      ```javascript
	      findAuthor().
	        then(findBooksByAuthor).
	        then(function(books){
	          // found books
	      }).catch(function(reason){
	        // something went wrong
	      });
	      ```
	
	      @method then
	      @param {Function} onFulfilled
	      @param {Function} onRejected
	      Useful for tooling.
	      @return {Promise}
	    */
	      then: lib$es6$promise$then$$default,
	
	    /**
	      `catch` is simply sugar for `then(undefined, onRejection)` which makes it the same
	      as the catch block of a try/catch statement.
	
	      ```js
	      function findAuthor(){
	        throw new Error('couldn't find that author');
	      }
	
	      // synchronous
	      try {
	        findAuthor();
	      } catch(reason) {
	        // something went wrong
	      }
	
	      // async with promises
	      findAuthor().catch(function(reason){
	        // something went wrong
	      });
	      ```
	
	      @method catch
	      @param {Function} onRejection
	      Useful for tooling.
	      @return {Promise}
	    */
	      'catch': function(onRejection) {
	        return this.then(null, onRejection);
	      }
	    };
	    var lib$es6$promise$enumerator$$default = lib$es6$promise$enumerator$$Enumerator;
	    function lib$es6$promise$enumerator$$Enumerator(Constructor, input) {
	      this._instanceConstructor = Constructor;
	      this.promise = new Constructor(lib$es6$promise$$internal$$noop);
	
	      if (!this.promise[lib$es6$promise$$internal$$PROMISE_ID]) {
	        lib$es6$promise$$internal$$makePromise(this.promise);
	      }
	
	      if (lib$es6$promise$utils$$isArray(input)) {
	        this._input     = input;
	        this.length     = input.length;
	        this._remaining = input.length;
	
	        this._result = new Array(this.length);
	
	        if (this.length === 0) {
	          lib$es6$promise$$internal$$fulfill(this.promise, this._result);
	        } else {
	          this.length = this.length || 0;
	          this._enumerate();
	          if (this._remaining === 0) {
	            lib$es6$promise$$internal$$fulfill(this.promise, this._result);
	          }
	        }
	      } else {
	        lib$es6$promise$$internal$$reject(this.promise, lib$es6$promise$enumerator$$validationError());
	      }
	    }
	
	    function lib$es6$promise$enumerator$$validationError() {
	      return new Error('Array Methods must be provided an Array');
	    }
	
	    lib$es6$promise$enumerator$$Enumerator.prototype._enumerate = function() {
	      var length  = this.length;
	      var input   = this._input;
	
	      for (var i = 0; this._state === lib$es6$promise$$internal$$PENDING && i < length; i++) {
	        this._eachEntry(input[i], i);
	      }
	    };
	
	    lib$es6$promise$enumerator$$Enumerator.prototype._eachEntry = function(entry, i) {
	      var c = this._instanceConstructor;
	      var resolve = c.resolve;
	
	      if (resolve === lib$es6$promise$promise$resolve$$default) {
	        var then = lib$es6$promise$$internal$$getThen(entry);
	
	        if (then === lib$es6$promise$then$$default &&
	            entry._state !== lib$es6$promise$$internal$$PENDING) {
	          this._settledAt(entry._state, i, entry._result);
	        } else if (typeof then !== 'function') {
	          this._remaining--;
	          this._result[i] = entry;
	        } else if (c === lib$es6$promise$promise$$default) {
	          var promise = new c(lib$es6$promise$$internal$$noop);
	          lib$es6$promise$$internal$$handleMaybeThenable(promise, entry, then);
	          this._willSettleAt(promise, i);
	        } else {
	          this._willSettleAt(new c(function(resolve) { resolve(entry); }), i);
	        }
	      } else {
	        this._willSettleAt(resolve(entry), i);
	      }
	    };
	
	    lib$es6$promise$enumerator$$Enumerator.prototype._settledAt = function(state, i, value) {
	      var promise = this.promise;
	
	      if (promise._state === lib$es6$promise$$internal$$PENDING) {
	        this._remaining--;
	
	        if (state === lib$es6$promise$$internal$$REJECTED) {
	          lib$es6$promise$$internal$$reject(promise, value);
	        } else {
	          this._result[i] = value;
	        }
	      }
	
	      if (this._remaining === 0) {
	        lib$es6$promise$$internal$$fulfill(promise, this._result);
	      }
	    };
	
	    lib$es6$promise$enumerator$$Enumerator.prototype._willSettleAt = function(promise, i) {
	      var enumerator = this;
	
	      lib$es6$promise$$internal$$subscribe(promise, undefined, function(value) {
	        enumerator._settledAt(lib$es6$promise$$internal$$FULFILLED, i, value);
	      }, function(reason) {
	        enumerator._settledAt(lib$es6$promise$$internal$$REJECTED, i, reason);
	      });
	    };
	    function lib$es6$promise$polyfill$$polyfill() {
	      var local;
	
	      if (typeof global !== 'undefined') {
	          local = global;
	      } else if (typeof self !== 'undefined') {
	          local = self;
	      } else {
	          try {
	              local = Function('return this')();
	          } catch (e) {
	              throw new Error('polyfill failed because global object is unavailable in this environment');
	          }
	      }
	
	      var P = local.Promise;
	
	      if (P && Object.prototype.toString.call(P.resolve()) === '[object Promise]' && !P.cast) {
	        return;
	      }
	
	      local.Promise = lib$es6$promise$promise$$default;
	    }
	    var lib$es6$promise$polyfill$$default = lib$es6$promise$polyfill$$polyfill;
	
	    var lib$es6$promise$umd$$ES6Promise = {
	      'Promise': lib$es6$promise$promise$$default,
	      'polyfill': lib$es6$promise$polyfill$$default
	    };
	
	    /* global define:true module:true window: true */
	    if ("function" === 'function' && __webpack_require__(42)['amd']) {
	      !(__WEBPACK_AMD_DEFINE_RESULT__ = function() { return lib$es6$promise$umd$$ES6Promise; }.call(exports, __webpack_require__, exports, module), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	    } else if (typeof module !== 'undefined' && module['exports']) {
	      module['exports'] = lib$es6$promise$umd$$ES6Promise;
	    } else if (typeof this !== 'undefined') {
	      this['ES6Promise'] = lib$es6$promise$umd$$ES6Promise;
	    }
	
	    lib$es6$promise$polyfill$$default();
	}).call(this);
	
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(8), (function() { return this; }()), __webpack_require__(40)(module)))

/***/ },
/* 40 */
/***/ function(module, exports) {

	module.exports = function(module) {
		if(!module.webpackPolyfill) {
			module.deprecate = function() {};
			module.paths = [];
			// module.parent = undefined by default
			module.children = [];
			module.webpackPolyfill = 1;
		}
		return module;
	}


/***/ },
/* 41 */
/***/ function(module, exports) {

	/* (ignored) */

/***/ },
/* 42 */
/***/ function(module, exports) {

	module.exports = function() { throw new Error("define cannot be used indirect"); };


/***/ },
/* 43 */
/***/ function(module, exports, __webpack_require__) {

	// style-loader: Adds some css to the DOM by adding a <style> tag
	
	// load the styles
	var content = __webpack_require__(44);
	if(typeof content === 'string') content = [[module.id, content, '']];
	// add the styles to the DOM
	var update = __webpack_require__(52)(content, {});
	if(content.locals) module.exports = content.locals;
	// Hot Module Replacement
	if(false) {
		// When the styles change, update the <style> tags
		if(!content.locals) {
			module.hot.accept("!!./../../css-loader/index.js!./font-awesome.min.css", function() {
				var newContent = require("!!./../../css-loader/index.js!./font-awesome.min.css");
				if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
				update(newContent);
			});
		}
		// When the module is disposed, remove the <style> tags
		module.hot.dispose(function() { update(); });
	}

/***/ },
/* 44 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*!\n *  Font Awesome 4.6.3 by @davegandy - http://fontawesome.io - @fontawesome\n *  License - http://fontawesome.io/license (Font: SIL OFL 1.1, CSS: MIT License)\n */@font-face{font-family:'FontAwesome';src:url(" + __webpack_require__(46) + ");src:url(" + __webpack_require__(47) + "?#iefix&v=4.6.3) format('embedded-opentype'),url(" + __webpack_require__(48) + ") format('woff2'),url(" + __webpack_require__(49) + ") format('woff'),url(" + __webpack_require__(50) + ") format('truetype'),url(" + __webpack_require__(51) + "#fontawesomeregular) format('svg');font-weight:normal;font-style:normal}.fa{display:inline-block;font:normal normal normal 14px/1 FontAwesome;font-size:inherit;text-rendering:auto;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}.fa-lg{font-size:1.33333333em;line-height:.75em;vertical-align:-15%}.fa-2x{font-size:2em}.fa-3x{font-size:3em}.fa-4x{font-size:4em}.fa-5x{font-size:5em}.fa-fw{width:1.28571429em;text-align:center}.fa-ul{padding-left:0;margin-left:2.14285714em;list-style-type:none}.fa-ul>li{position:relative}.fa-li{position:absolute;left:-2.14285714em;width:2.14285714em;top:.14285714em;text-align:center}.fa-li.fa-lg{left:-1.85714286em}.fa-border{padding:.2em .25em .15em;border:solid .08em #eee;border-radius:.1em}.fa-pull-left{float:left}.fa-pull-right{float:right}.fa.fa-pull-left{margin-right:.3em}.fa.fa-pull-right{margin-left:.3em}.pull-right{float:right}.pull-left{float:left}.fa.pull-left{margin-right:.3em}.fa.pull-right{margin-left:.3em}.fa-spin{-webkit-animation:fa-spin 2s infinite linear;animation:fa-spin 2s infinite linear}.fa-pulse{-webkit-animation:fa-spin 1s infinite steps(8);animation:fa-spin 1s infinite steps(8)}@-webkit-keyframes fa-spin{0%{-webkit-transform:rotate(0deg);transform:rotate(0deg)}100%{-webkit-transform:rotate(359deg);transform:rotate(359deg)}}@keyframes fa-spin{0%{-webkit-transform:rotate(0deg);transform:rotate(0deg)}100%{-webkit-transform:rotate(359deg);transform:rotate(359deg)}}.fa-rotate-90{-ms-filter:\"progid:DXImageTransform.Microsoft.BasicImage(rotation=1)\";-webkit-transform:rotate(90deg);-ms-transform:rotate(90deg);transform:rotate(90deg)}.fa-rotate-180{-ms-filter:\"progid:DXImageTransform.Microsoft.BasicImage(rotation=2)\";-webkit-transform:rotate(180deg);-ms-transform:rotate(180deg);transform:rotate(180deg)}.fa-rotate-270{-ms-filter:\"progid:DXImageTransform.Microsoft.BasicImage(rotation=3)\";-webkit-transform:rotate(270deg);-ms-transform:rotate(270deg);transform:rotate(270deg)}.fa-flip-horizontal{-ms-filter:\"progid:DXImageTransform.Microsoft.BasicImage(rotation=0, mirror=1)\";-webkit-transform:scale(-1, 1);-ms-transform:scale(-1, 1);transform:scale(-1, 1)}.fa-flip-vertical{-ms-filter:\"progid:DXImageTransform.Microsoft.BasicImage(rotation=2, mirror=1)\";-webkit-transform:scale(1, -1);-ms-transform:scale(1, -1);transform:scale(1, -1)}:root .fa-rotate-90,:root .fa-rotate-180,:root .fa-rotate-270,:root .fa-flip-horizontal,:root .fa-flip-vertical{filter:none}.fa-stack{position:relative;display:inline-block;width:2em;height:2em;line-height:2em;vertical-align:middle}.fa-stack-1x,.fa-stack-2x{position:absolute;left:0;width:100%;text-align:center}.fa-stack-1x{line-height:inherit}.fa-stack-2x{font-size:2em}.fa-inverse{color:#fff}.fa-glass:before{content:\"\\F000\"}.fa-music:before{content:\"\\F001\"}.fa-search:before{content:\"\\F002\"}.fa-envelope-o:before{content:\"\\F003\"}.fa-heart:before{content:\"\\F004\"}.fa-star:before{content:\"\\F005\"}.fa-star-o:before{content:\"\\F006\"}.fa-user:before{content:\"\\F007\"}.fa-film:before{content:\"\\F008\"}.fa-th-large:before{content:\"\\F009\"}.fa-th:before{content:\"\\F00A\"}.fa-th-list:before{content:\"\\F00B\"}.fa-check:before{content:\"\\F00C\"}.fa-remove:before,.fa-close:before,.fa-times:before{content:\"\\F00D\"}.fa-search-plus:before{content:\"\\F00E\"}.fa-search-minus:before{content:\"\\F010\"}.fa-power-off:before{content:\"\\F011\"}.fa-signal:before{content:\"\\F012\"}.fa-gear:before,.fa-cog:before{content:\"\\F013\"}.fa-trash-o:before{content:\"\\F014\"}.fa-home:before{content:\"\\F015\"}.fa-file-o:before{content:\"\\F016\"}.fa-clock-o:before{content:\"\\F017\"}.fa-road:before{content:\"\\F018\"}.fa-download:before{content:\"\\F019\"}.fa-arrow-circle-o-down:before{content:\"\\F01A\"}.fa-arrow-circle-o-up:before{content:\"\\F01B\"}.fa-inbox:before{content:\"\\F01C\"}.fa-play-circle-o:before{content:\"\\F01D\"}.fa-rotate-right:before,.fa-repeat:before{content:\"\\F01E\"}.fa-refresh:before{content:\"\\F021\"}.fa-list-alt:before{content:\"\\F022\"}.fa-lock:before{content:\"\\F023\"}.fa-flag:before{content:\"\\F024\"}.fa-headphones:before{content:\"\\F025\"}.fa-volume-off:before{content:\"\\F026\"}.fa-volume-down:before{content:\"\\F027\"}.fa-volume-up:before{content:\"\\F028\"}.fa-qrcode:before{content:\"\\F029\"}.fa-barcode:before{content:\"\\F02A\"}.fa-tag:before{content:\"\\F02B\"}.fa-tags:before{content:\"\\F02C\"}.fa-book:before{content:\"\\F02D\"}.fa-bookmark:before{content:\"\\F02E\"}.fa-print:before{content:\"\\F02F\"}.fa-camera:before{content:\"\\F030\"}.fa-font:before{content:\"\\F031\"}.fa-bold:before{content:\"\\F032\"}.fa-italic:before{content:\"\\F033\"}.fa-text-height:before{content:\"\\F034\"}.fa-text-width:before{content:\"\\F035\"}.fa-align-left:before{content:\"\\F036\"}.fa-align-center:before{content:\"\\F037\"}.fa-align-right:before{content:\"\\F038\"}.fa-align-justify:before{content:\"\\F039\"}.fa-list:before{content:\"\\F03A\"}.fa-dedent:before,.fa-outdent:before{content:\"\\F03B\"}.fa-indent:before{content:\"\\F03C\"}.fa-video-camera:before{content:\"\\F03D\"}.fa-photo:before,.fa-image:before,.fa-picture-o:before{content:\"\\F03E\"}.fa-pencil:before{content:\"\\F040\"}.fa-map-marker:before{content:\"\\F041\"}.fa-adjust:before{content:\"\\F042\"}.fa-tint:before{content:\"\\F043\"}.fa-edit:before,.fa-pencil-square-o:before{content:\"\\F044\"}.fa-share-square-o:before{content:\"\\F045\"}.fa-check-square-o:before{content:\"\\F046\"}.fa-arrows:before{content:\"\\F047\"}.fa-step-backward:before{content:\"\\F048\"}.fa-fast-backward:before{content:\"\\F049\"}.fa-backward:before{content:\"\\F04A\"}.fa-play:before{content:\"\\F04B\"}.fa-pause:before{content:\"\\F04C\"}.fa-stop:before{content:\"\\F04D\"}.fa-forward:before{content:\"\\F04E\"}.fa-fast-forward:before{content:\"\\F050\"}.fa-step-forward:before{content:\"\\F051\"}.fa-eject:before{content:\"\\F052\"}.fa-chevron-left:before{content:\"\\F053\"}.fa-chevron-right:before{content:\"\\F054\"}.fa-plus-circle:before{content:\"\\F055\"}.fa-minus-circle:before{content:\"\\F056\"}.fa-times-circle:before{content:\"\\F057\"}.fa-check-circle:before{content:\"\\F058\"}.fa-question-circle:before{content:\"\\F059\"}.fa-info-circle:before{content:\"\\F05A\"}.fa-crosshairs:before{content:\"\\F05B\"}.fa-times-circle-o:before{content:\"\\F05C\"}.fa-check-circle-o:before{content:\"\\F05D\"}.fa-ban:before{content:\"\\F05E\"}.fa-arrow-left:before{content:\"\\F060\"}.fa-arrow-right:before{content:\"\\F061\"}.fa-arrow-up:before{content:\"\\F062\"}.fa-arrow-down:before{content:\"\\F063\"}.fa-mail-forward:before,.fa-share:before{content:\"\\F064\"}.fa-expand:before{content:\"\\F065\"}.fa-compress:before{content:\"\\F066\"}.fa-plus:before{content:\"\\F067\"}.fa-minus:before{content:\"\\F068\"}.fa-asterisk:before{content:\"\\F069\"}.fa-exclamation-circle:before{content:\"\\F06A\"}.fa-gift:before{content:\"\\F06B\"}.fa-leaf:before{content:\"\\F06C\"}.fa-fire:before{content:\"\\F06D\"}.fa-eye:before{content:\"\\F06E\"}.fa-eye-slash:before{content:\"\\F070\"}.fa-warning:before,.fa-exclamation-triangle:before{content:\"\\F071\"}.fa-plane:before{content:\"\\F072\"}.fa-calendar:before{content:\"\\F073\"}.fa-random:before{content:\"\\F074\"}.fa-comment:before{content:\"\\F075\"}.fa-magnet:before{content:\"\\F076\"}.fa-chevron-up:before{content:\"\\F077\"}.fa-chevron-down:before{content:\"\\F078\"}.fa-retweet:before{content:\"\\F079\"}.fa-shopping-cart:before{content:\"\\F07A\"}.fa-folder:before{content:\"\\F07B\"}.fa-folder-open:before{content:\"\\F07C\"}.fa-arrows-v:before{content:\"\\F07D\"}.fa-arrows-h:before{content:\"\\F07E\"}.fa-bar-chart-o:before,.fa-bar-chart:before{content:\"\\F080\"}.fa-twitter-square:before{content:\"\\F081\"}.fa-facebook-square:before{content:\"\\F082\"}.fa-camera-retro:before{content:\"\\F083\"}.fa-key:before{content:\"\\F084\"}.fa-gears:before,.fa-cogs:before{content:\"\\F085\"}.fa-comments:before{content:\"\\F086\"}.fa-thumbs-o-up:before{content:\"\\F087\"}.fa-thumbs-o-down:before{content:\"\\F088\"}.fa-star-half:before{content:\"\\F089\"}.fa-heart-o:before{content:\"\\F08A\"}.fa-sign-out:before{content:\"\\F08B\"}.fa-linkedin-square:before{content:\"\\F08C\"}.fa-thumb-tack:before{content:\"\\F08D\"}.fa-external-link:before{content:\"\\F08E\"}.fa-sign-in:before{content:\"\\F090\"}.fa-trophy:before{content:\"\\F091\"}.fa-github-square:before{content:\"\\F092\"}.fa-upload:before{content:\"\\F093\"}.fa-lemon-o:before{content:\"\\F094\"}.fa-phone:before{content:\"\\F095\"}.fa-square-o:before{content:\"\\F096\"}.fa-bookmark-o:before{content:\"\\F097\"}.fa-phone-square:before{content:\"\\F098\"}.fa-twitter:before{content:\"\\F099\"}.fa-facebook-f:before,.fa-facebook:before{content:\"\\F09A\"}.fa-github:before{content:\"\\F09B\"}.fa-unlock:before{content:\"\\F09C\"}.fa-credit-card:before{content:\"\\F09D\"}.fa-feed:before,.fa-rss:before{content:\"\\F09E\"}.fa-hdd-o:before{content:\"\\F0A0\"}.fa-bullhorn:before{content:\"\\F0A1\"}.fa-bell:before{content:\"\\F0F3\"}.fa-certificate:before{content:\"\\F0A3\"}.fa-hand-o-right:before{content:\"\\F0A4\"}.fa-hand-o-left:before{content:\"\\F0A5\"}.fa-hand-o-up:before{content:\"\\F0A6\"}.fa-hand-o-down:before{content:\"\\F0A7\"}.fa-arrow-circle-left:before{content:\"\\F0A8\"}.fa-arrow-circle-right:before{content:\"\\F0A9\"}.fa-arrow-circle-up:before{content:\"\\F0AA\"}.fa-arrow-circle-down:before{content:\"\\F0AB\"}.fa-globe:before{content:\"\\F0AC\"}.fa-wrench:before{content:\"\\F0AD\"}.fa-tasks:before{content:\"\\F0AE\"}.fa-filter:before{content:\"\\F0B0\"}.fa-briefcase:before{content:\"\\F0B1\"}.fa-arrows-alt:before{content:\"\\F0B2\"}.fa-group:before,.fa-users:before{content:\"\\F0C0\"}.fa-chain:before,.fa-link:before{content:\"\\F0C1\"}.fa-cloud:before{content:\"\\F0C2\"}.fa-flask:before{content:\"\\F0C3\"}.fa-cut:before,.fa-scissors:before{content:\"\\F0C4\"}.fa-copy:before,.fa-files-o:before{content:\"\\F0C5\"}.fa-paperclip:before{content:\"\\F0C6\"}.fa-save:before,.fa-floppy-o:before{content:\"\\F0C7\"}.fa-square:before{content:\"\\F0C8\"}.fa-navicon:before,.fa-reorder:before,.fa-bars:before{content:\"\\F0C9\"}.fa-list-ul:before{content:\"\\F0CA\"}.fa-list-ol:before{content:\"\\F0CB\"}.fa-strikethrough:before{content:\"\\F0CC\"}.fa-underline:before{content:\"\\F0CD\"}.fa-table:before{content:\"\\F0CE\"}.fa-magic:before{content:\"\\F0D0\"}.fa-truck:before{content:\"\\F0D1\"}.fa-pinterest:before{content:\"\\F0D2\"}.fa-pinterest-square:before{content:\"\\F0D3\"}.fa-google-plus-square:before{content:\"\\F0D4\"}.fa-google-plus:before{content:\"\\F0D5\"}.fa-money:before{content:\"\\F0D6\"}.fa-caret-down:before{content:\"\\F0D7\"}.fa-caret-up:before{content:\"\\F0D8\"}.fa-caret-left:before{content:\"\\F0D9\"}.fa-caret-right:before{content:\"\\F0DA\"}.fa-columns:before{content:\"\\F0DB\"}.fa-unsorted:before,.fa-sort:before{content:\"\\F0DC\"}.fa-sort-down:before,.fa-sort-desc:before{content:\"\\F0DD\"}.fa-sort-up:before,.fa-sort-asc:before{content:\"\\F0DE\"}.fa-envelope:before{content:\"\\F0E0\"}.fa-linkedin:before{content:\"\\F0E1\"}.fa-rotate-left:before,.fa-undo:before{content:\"\\F0E2\"}.fa-legal:before,.fa-gavel:before{content:\"\\F0E3\"}.fa-dashboard:before,.fa-tachometer:before{content:\"\\F0E4\"}.fa-comment-o:before{content:\"\\F0E5\"}.fa-comments-o:before{content:\"\\F0E6\"}.fa-flash:before,.fa-bolt:before{content:\"\\F0E7\"}.fa-sitemap:before{content:\"\\F0E8\"}.fa-umbrella:before{content:\"\\F0E9\"}.fa-paste:before,.fa-clipboard:before{content:\"\\F0EA\"}.fa-lightbulb-o:before{content:\"\\F0EB\"}.fa-exchange:before{content:\"\\F0EC\"}.fa-cloud-download:before{content:\"\\F0ED\"}.fa-cloud-upload:before{content:\"\\F0EE\"}.fa-user-md:before{content:\"\\F0F0\"}.fa-stethoscope:before{content:\"\\F0F1\"}.fa-suitcase:before{content:\"\\F0F2\"}.fa-bell-o:before{content:\"\\F0A2\"}.fa-coffee:before{content:\"\\F0F4\"}.fa-cutlery:before{content:\"\\F0F5\"}.fa-file-text-o:before{content:\"\\F0F6\"}.fa-building-o:before{content:\"\\F0F7\"}.fa-hospital-o:before{content:\"\\F0F8\"}.fa-ambulance:before{content:\"\\F0F9\"}.fa-medkit:before{content:\"\\F0FA\"}.fa-fighter-jet:before{content:\"\\F0FB\"}.fa-beer:before{content:\"\\F0FC\"}.fa-h-square:before{content:\"\\F0FD\"}.fa-plus-square:before{content:\"\\F0FE\"}.fa-angle-double-left:before{content:\"\\F100\"}.fa-angle-double-right:before{content:\"\\F101\"}.fa-angle-double-up:before{content:\"\\F102\"}.fa-angle-double-down:before{content:\"\\F103\"}.fa-angle-left:before{content:\"\\F104\"}.fa-angle-right:before{content:\"\\F105\"}.fa-angle-up:before{content:\"\\F106\"}.fa-angle-down:before{content:\"\\F107\"}.fa-desktop:before{content:\"\\F108\"}.fa-laptop:before{content:\"\\F109\"}.fa-tablet:before{content:\"\\F10A\"}.fa-mobile-phone:before,.fa-mobile:before{content:\"\\F10B\"}.fa-circle-o:before{content:\"\\F10C\"}.fa-quote-left:before{content:\"\\F10D\"}.fa-quote-right:before{content:\"\\F10E\"}.fa-spinner:before{content:\"\\F110\"}.fa-circle:before{content:\"\\F111\"}.fa-mail-reply:before,.fa-reply:before{content:\"\\F112\"}.fa-github-alt:before{content:\"\\F113\"}.fa-folder-o:before{content:\"\\F114\"}.fa-folder-open-o:before{content:\"\\F115\"}.fa-smile-o:before{content:\"\\F118\"}.fa-frown-o:before{content:\"\\F119\"}.fa-meh-o:before{content:\"\\F11A\"}.fa-gamepad:before{content:\"\\F11B\"}.fa-keyboard-o:before{content:\"\\F11C\"}.fa-flag-o:before{content:\"\\F11D\"}.fa-flag-checkered:before{content:\"\\F11E\"}.fa-terminal:before{content:\"\\F120\"}.fa-code:before{content:\"\\F121\"}.fa-mail-reply-all:before,.fa-reply-all:before{content:\"\\F122\"}.fa-star-half-empty:before,.fa-star-half-full:before,.fa-star-half-o:before{content:\"\\F123\"}.fa-location-arrow:before{content:\"\\F124\"}.fa-crop:before{content:\"\\F125\"}.fa-code-fork:before{content:\"\\F126\"}.fa-unlink:before,.fa-chain-broken:before{content:\"\\F127\"}.fa-question:before{content:\"\\F128\"}.fa-info:before{content:\"\\F129\"}.fa-exclamation:before{content:\"\\F12A\"}.fa-superscript:before{content:\"\\F12B\"}.fa-subscript:before{content:\"\\F12C\"}.fa-eraser:before{content:\"\\F12D\"}.fa-puzzle-piece:before{content:\"\\F12E\"}.fa-microphone:before{content:\"\\F130\"}.fa-microphone-slash:before{content:\"\\F131\"}.fa-shield:before{content:\"\\F132\"}.fa-calendar-o:before{content:\"\\F133\"}.fa-fire-extinguisher:before{content:\"\\F134\"}.fa-rocket:before{content:\"\\F135\"}.fa-maxcdn:before{content:\"\\F136\"}.fa-chevron-circle-left:before{content:\"\\F137\"}.fa-chevron-circle-right:before{content:\"\\F138\"}.fa-chevron-circle-up:before{content:\"\\F139\"}.fa-chevron-circle-down:before{content:\"\\F13A\"}.fa-html5:before{content:\"\\F13B\"}.fa-css3:before{content:\"\\F13C\"}.fa-anchor:before{content:\"\\F13D\"}.fa-unlock-alt:before{content:\"\\F13E\"}.fa-bullseye:before{content:\"\\F140\"}.fa-ellipsis-h:before{content:\"\\F141\"}.fa-ellipsis-v:before{content:\"\\F142\"}.fa-rss-square:before{content:\"\\F143\"}.fa-play-circle:before{content:\"\\F144\"}.fa-ticket:before{content:\"\\F145\"}.fa-minus-square:before{content:\"\\F146\"}.fa-minus-square-o:before{content:\"\\F147\"}.fa-level-up:before{content:\"\\F148\"}.fa-level-down:before{content:\"\\F149\"}.fa-check-square:before{content:\"\\F14A\"}.fa-pencil-square:before{content:\"\\F14B\"}.fa-external-link-square:before{content:\"\\F14C\"}.fa-share-square:before{content:\"\\F14D\"}.fa-compass:before{content:\"\\F14E\"}.fa-toggle-down:before,.fa-caret-square-o-down:before{content:\"\\F150\"}.fa-toggle-up:before,.fa-caret-square-o-up:before{content:\"\\F151\"}.fa-toggle-right:before,.fa-caret-square-o-right:before{content:\"\\F152\"}.fa-euro:before,.fa-eur:before{content:\"\\F153\"}.fa-gbp:before{content:\"\\F154\"}.fa-dollar:before,.fa-usd:before{content:\"\\F155\"}.fa-rupee:before,.fa-inr:before{content:\"\\F156\"}.fa-cny:before,.fa-rmb:before,.fa-yen:before,.fa-jpy:before{content:\"\\F157\"}.fa-ruble:before,.fa-rouble:before,.fa-rub:before{content:\"\\F158\"}.fa-won:before,.fa-krw:before{content:\"\\F159\"}.fa-bitcoin:before,.fa-btc:before{content:\"\\F15A\"}.fa-file:before{content:\"\\F15B\"}.fa-file-text:before{content:\"\\F15C\"}.fa-sort-alpha-asc:before{content:\"\\F15D\"}.fa-sort-alpha-desc:before{content:\"\\F15E\"}.fa-sort-amount-asc:before{content:\"\\F160\"}.fa-sort-amount-desc:before{content:\"\\F161\"}.fa-sort-numeric-asc:before{content:\"\\F162\"}.fa-sort-numeric-desc:before{content:\"\\F163\"}.fa-thumbs-up:before{content:\"\\F164\"}.fa-thumbs-down:before{content:\"\\F165\"}.fa-youtube-square:before{content:\"\\F166\"}.fa-youtube:before{content:\"\\F167\"}.fa-xing:before{content:\"\\F168\"}.fa-xing-square:before{content:\"\\F169\"}.fa-youtube-play:before{content:\"\\F16A\"}.fa-dropbox:before{content:\"\\F16B\"}.fa-stack-overflow:before{content:\"\\F16C\"}.fa-instagram:before{content:\"\\F16D\"}.fa-flickr:before{content:\"\\F16E\"}.fa-adn:before{content:\"\\F170\"}.fa-bitbucket:before{content:\"\\F171\"}.fa-bitbucket-square:before{content:\"\\F172\"}.fa-tumblr:before{content:\"\\F173\"}.fa-tumblr-square:before{content:\"\\F174\"}.fa-long-arrow-down:before{content:\"\\F175\"}.fa-long-arrow-up:before{content:\"\\F176\"}.fa-long-arrow-left:before{content:\"\\F177\"}.fa-long-arrow-right:before{content:\"\\F178\"}.fa-apple:before{content:\"\\F179\"}.fa-windows:before{content:\"\\F17A\"}.fa-android:before{content:\"\\F17B\"}.fa-linux:before{content:\"\\F17C\"}.fa-dribbble:before{content:\"\\F17D\"}.fa-skype:before{content:\"\\F17E\"}.fa-foursquare:before{content:\"\\F180\"}.fa-trello:before{content:\"\\F181\"}.fa-female:before{content:\"\\F182\"}.fa-male:before{content:\"\\F183\"}.fa-gittip:before,.fa-gratipay:before{content:\"\\F184\"}.fa-sun-o:before{content:\"\\F185\"}.fa-moon-o:before{content:\"\\F186\"}.fa-archive:before{content:\"\\F187\"}.fa-bug:before{content:\"\\F188\"}.fa-vk:before{content:\"\\F189\"}.fa-weibo:before{content:\"\\F18A\"}.fa-renren:before{content:\"\\F18B\"}.fa-pagelines:before{content:\"\\F18C\"}.fa-stack-exchange:before{content:\"\\F18D\"}.fa-arrow-circle-o-right:before{content:\"\\F18E\"}.fa-arrow-circle-o-left:before{content:\"\\F190\"}.fa-toggle-left:before,.fa-caret-square-o-left:before{content:\"\\F191\"}.fa-dot-circle-o:before{content:\"\\F192\"}.fa-wheelchair:before{content:\"\\F193\"}.fa-vimeo-square:before{content:\"\\F194\"}.fa-turkish-lira:before,.fa-try:before{content:\"\\F195\"}.fa-plus-square-o:before{content:\"\\F196\"}.fa-space-shuttle:before{content:\"\\F197\"}.fa-slack:before{content:\"\\F198\"}.fa-envelope-square:before{content:\"\\F199\"}.fa-wordpress:before{content:\"\\F19A\"}.fa-openid:before{content:\"\\F19B\"}.fa-institution:before,.fa-bank:before,.fa-university:before{content:\"\\F19C\"}.fa-mortar-board:before,.fa-graduation-cap:before{content:\"\\F19D\"}.fa-yahoo:before{content:\"\\F19E\"}.fa-google:before{content:\"\\F1A0\"}.fa-reddit:before{content:\"\\F1A1\"}.fa-reddit-square:before{content:\"\\F1A2\"}.fa-stumbleupon-circle:before{content:\"\\F1A3\"}.fa-stumbleupon:before{content:\"\\F1A4\"}.fa-delicious:before{content:\"\\F1A5\"}.fa-digg:before{content:\"\\F1A6\"}.fa-pied-piper-pp:before{content:\"\\F1A7\"}.fa-pied-piper-alt:before{content:\"\\F1A8\"}.fa-drupal:before{content:\"\\F1A9\"}.fa-joomla:before{content:\"\\F1AA\"}.fa-language:before{content:\"\\F1AB\"}.fa-fax:before{content:\"\\F1AC\"}.fa-building:before{content:\"\\F1AD\"}.fa-child:before{content:\"\\F1AE\"}.fa-paw:before{content:\"\\F1B0\"}.fa-spoon:before{content:\"\\F1B1\"}.fa-cube:before{content:\"\\F1B2\"}.fa-cubes:before{content:\"\\F1B3\"}.fa-behance:before{content:\"\\F1B4\"}.fa-behance-square:before{content:\"\\F1B5\"}.fa-steam:before{content:\"\\F1B6\"}.fa-steam-square:before{content:\"\\F1B7\"}.fa-recycle:before{content:\"\\F1B8\"}.fa-automobile:before,.fa-car:before{content:\"\\F1B9\"}.fa-cab:before,.fa-taxi:before{content:\"\\F1BA\"}.fa-tree:before{content:\"\\F1BB\"}.fa-spotify:before{content:\"\\F1BC\"}.fa-deviantart:before{content:\"\\F1BD\"}.fa-soundcloud:before{content:\"\\F1BE\"}.fa-database:before{content:\"\\F1C0\"}.fa-file-pdf-o:before{content:\"\\F1C1\"}.fa-file-word-o:before{content:\"\\F1C2\"}.fa-file-excel-o:before{content:\"\\F1C3\"}.fa-file-powerpoint-o:before{content:\"\\F1C4\"}.fa-file-photo-o:before,.fa-file-picture-o:before,.fa-file-image-o:before{content:\"\\F1C5\"}.fa-file-zip-o:before,.fa-file-archive-o:before{content:\"\\F1C6\"}.fa-file-sound-o:before,.fa-file-audio-o:before{content:\"\\F1C7\"}.fa-file-movie-o:before,.fa-file-video-o:before{content:\"\\F1C8\"}.fa-file-code-o:before{content:\"\\F1C9\"}.fa-vine:before{content:\"\\F1CA\"}.fa-codepen:before{content:\"\\F1CB\"}.fa-jsfiddle:before{content:\"\\F1CC\"}.fa-life-bouy:before,.fa-life-buoy:before,.fa-life-saver:before,.fa-support:before,.fa-life-ring:before{content:\"\\F1CD\"}.fa-circle-o-notch:before{content:\"\\F1CE\"}.fa-ra:before,.fa-resistance:before,.fa-rebel:before{content:\"\\F1D0\"}.fa-ge:before,.fa-empire:before{content:\"\\F1D1\"}.fa-git-square:before{content:\"\\F1D2\"}.fa-git:before{content:\"\\F1D3\"}.fa-y-combinator-square:before,.fa-yc-square:before,.fa-hacker-news:before{content:\"\\F1D4\"}.fa-tencent-weibo:before{content:\"\\F1D5\"}.fa-qq:before{content:\"\\F1D6\"}.fa-wechat:before,.fa-weixin:before{content:\"\\F1D7\"}.fa-send:before,.fa-paper-plane:before{content:\"\\F1D8\"}.fa-send-o:before,.fa-paper-plane-o:before{content:\"\\F1D9\"}.fa-history:before{content:\"\\F1DA\"}.fa-circle-thin:before{content:\"\\F1DB\"}.fa-header:before{content:\"\\F1DC\"}.fa-paragraph:before{content:\"\\F1DD\"}.fa-sliders:before{content:\"\\F1DE\"}.fa-share-alt:before{content:\"\\F1E0\"}.fa-share-alt-square:before{content:\"\\F1E1\"}.fa-bomb:before{content:\"\\F1E2\"}.fa-soccer-ball-o:before,.fa-futbol-o:before{content:\"\\F1E3\"}.fa-tty:before{content:\"\\F1E4\"}.fa-binoculars:before{content:\"\\F1E5\"}.fa-plug:before{content:\"\\F1E6\"}.fa-slideshare:before{content:\"\\F1E7\"}.fa-twitch:before{content:\"\\F1E8\"}.fa-yelp:before{content:\"\\F1E9\"}.fa-newspaper-o:before{content:\"\\F1EA\"}.fa-wifi:before{content:\"\\F1EB\"}.fa-calculator:before{content:\"\\F1EC\"}.fa-paypal:before{content:\"\\F1ED\"}.fa-google-wallet:before{content:\"\\F1EE\"}.fa-cc-visa:before{content:\"\\F1F0\"}.fa-cc-mastercard:before{content:\"\\F1F1\"}.fa-cc-discover:before{content:\"\\F1F2\"}.fa-cc-amex:before{content:\"\\F1F3\"}.fa-cc-paypal:before{content:\"\\F1F4\"}.fa-cc-stripe:before{content:\"\\F1F5\"}.fa-bell-slash:before{content:\"\\F1F6\"}.fa-bell-slash-o:before{content:\"\\F1F7\"}.fa-trash:before{content:\"\\F1F8\"}.fa-copyright:before{content:\"\\F1F9\"}.fa-at:before{content:\"\\F1FA\"}.fa-eyedropper:before{content:\"\\F1FB\"}.fa-paint-brush:before{content:\"\\F1FC\"}.fa-birthday-cake:before{content:\"\\F1FD\"}.fa-area-chart:before{content:\"\\F1FE\"}.fa-pie-chart:before{content:\"\\F200\"}.fa-line-chart:before{content:\"\\F201\"}.fa-lastfm:before{content:\"\\F202\"}.fa-lastfm-square:before{content:\"\\F203\"}.fa-toggle-off:before{content:\"\\F204\"}.fa-toggle-on:before{content:\"\\F205\"}.fa-bicycle:before{content:\"\\F206\"}.fa-bus:before{content:\"\\F207\"}.fa-ioxhost:before{content:\"\\F208\"}.fa-angellist:before{content:\"\\F209\"}.fa-cc:before{content:\"\\F20A\"}.fa-shekel:before,.fa-sheqel:before,.fa-ils:before{content:\"\\F20B\"}.fa-meanpath:before{content:\"\\F20C\"}.fa-buysellads:before{content:\"\\F20D\"}.fa-connectdevelop:before{content:\"\\F20E\"}.fa-dashcube:before{content:\"\\F210\"}.fa-forumbee:before{content:\"\\F211\"}.fa-leanpub:before{content:\"\\F212\"}.fa-sellsy:before{content:\"\\F213\"}.fa-shirtsinbulk:before{content:\"\\F214\"}.fa-simplybuilt:before{content:\"\\F215\"}.fa-skyatlas:before{content:\"\\F216\"}.fa-cart-plus:before{content:\"\\F217\"}.fa-cart-arrow-down:before{content:\"\\F218\"}.fa-diamond:before{content:\"\\F219\"}.fa-ship:before{content:\"\\F21A\"}.fa-user-secret:before{content:\"\\F21B\"}.fa-motorcycle:before{content:\"\\F21C\"}.fa-street-view:before{content:\"\\F21D\"}.fa-heartbeat:before{content:\"\\F21E\"}.fa-venus:before{content:\"\\F221\"}.fa-mars:before{content:\"\\F222\"}.fa-mercury:before{content:\"\\F223\"}.fa-intersex:before,.fa-transgender:before{content:\"\\F224\"}.fa-transgender-alt:before{content:\"\\F225\"}.fa-venus-double:before{content:\"\\F226\"}.fa-mars-double:before{content:\"\\F227\"}.fa-venus-mars:before{content:\"\\F228\"}.fa-mars-stroke:before{content:\"\\F229\"}.fa-mars-stroke-v:before{content:\"\\F22A\"}.fa-mars-stroke-h:before{content:\"\\F22B\"}.fa-neuter:before{content:\"\\F22C\"}.fa-genderless:before{content:\"\\F22D\"}.fa-facebook-official:before{content:\"\\F230\"}.fa-pinterest-p:before{content:\"\\F231\"}.fa-whatsapp:before{content:\"\\F232\"}.fa-server:before{content:\"\\F233\"}.fa-user-plus:before{content:\"\\F234\"}.fa-user-times:before{content:\"\\F235\"}.fa-hotel:before,.fa-bed:before{content:\"\\F236\"}.fa-viacoin:before{content:\"\\F237\"}.fa-train:before{content:\"\\F238\"}.fa-subway:before{content:\"\\F239\"}.fa-medium:before{content:\"\\F23A\"}.fa-yc:before,.fa-y-combinator:before{content:\"\\F23B\"}.fa-optin-monster:before{content:\"\\F23C\"}.fa-opencart:before{content:\"\\F23D\"}.fa-expeditedssl:before{content:\"\\F23E\"}.fa-battery-4:before,.fa-battery-full:before{content:\"\\F240\"}.fa-battery-3:before,.fa-battery-three-quarters:before{content:\"\\F241\"}.fa-battery-2:before,.fa-battery-half:before{content:\"\\F242\"}.fa-battery-1:before,.fa-battery-quarter:before{content:\"\\F243\"}.fa-battery-0:before,.fa-battery-empty:before{content:\"\\F244\"}.fa-mouse-pointer:before{content:\"\\F245\"}.fa-i-cursor:before{content:\"\\F246\"}.fa-object-group:before{content:\"\\F247\"}.fa-object-ungroup:before{content:\"\\F248\"}.fa-sticky-note:before{content:\"\\F249\"}.fa-sticky-note-o:before{content:\"\\F24A\"}.fa-cc-jcb:before{content:\"\\F24B\"}.fa-cc-diners-club:before{content:\"\\F24C\"}.fa-clone:before{content:\"\\F24D\"}.fa-balance-scale:before{content:\"\\F24E\"}.fa-hourglass-o:before{content:\"\\F250\"}.fa-hourglass-1:before,.fa-hourglass-start:before{content:\"\\F251\"}.fa-hourglass-2:before,.fa-hourglass-half:before{content:\"\\F252\"}.fa-hourglass-3:before,.fa-hourglass-end:before{content:\"\\F253\"}.fa-hourglass:before{content:\"\\F254\"}.fa-hand-grab-o:before,.fa-hand-rock-o:before{content:\"\\F255\"}.fa-hand-stop-o:before,.fa-hand-paper-o:before{content:\"\\F256\"}.fa-hand-scissors-o:before{content:\"\\F257\"}.fa-hand-lizard-o:before{content:\"\\F258\"}.fa-hand-spock-o:before{content:\"\\F259\"}.fa-hand-pointer-o:before{content:\"\\F25A\"}.fa-hand-peace-o:before{content:\"\\F25B\"}.fa-trademark:before{content:\"\\F25C\"}.fa-registered:before{content:\"\\F25D\"}.fa-creative-commons:before{content:\"\\F25E\"}.fa-gg:before{content:\"\\F260\"}.fa-gg-circle:before{content:\"\\F261\"}.fa-tripadvisor:before{content:\"\\F262\"}.fa-odnoklassniki:before{content:\"\\F263\"}.fa-odnoklassniki-square:before{content:\"\\F264\"}.fa-get-pocket:before{content:\"\\F265\"}.fa-wikipedia-w:before{content:\"\\F266\"}.fa-safari:before{content:\"\\F267\"}.fa-chrome:before{content:\"\\F268\"}.fa-firefox:before{content:\"\\F269\"}.fa-opera:before{content:\"\\F26A\"}.fa-internet-explorer:before{content:\"\\F26B\"}.fa-tv:before,.fa-television:before{content:\"\\F26C\"}.fa-contao:before{content:\"\\F26D\"}.fa-500px:before{content:\"\\F26E\"}.fa-amazon:before{content:\"\\F270\"}.fa-calendar-plus-o:before{content:\"\\F271\"}.fa-calendar-minus-o:before{content:\"\\F272\"}.fa-calendar-times-o:before{content:\"\\F273\"}.fa-calendar-check-o:before{content:\"\\F274\"}.fa-industry:before{content:\"\\F275\"}.fa-map-pin:before{content:\"\\F276\"}.fa-map-signs:before{content:\"\\F277\"}.fa-map-o:before{content:\"\\F278\"}.fa-map:before{content:\"\\F279\"}.fa-commenting:before{content:\"\\F27A\"}.fa-commenting-o:before{content:\"\\F27B\"}.fa-houzz:before{content:\"\\F27C\"}.fa-vimeo:before{content:\"\\F27D\"}.fa-black-tie:before{content:\"\\F27E\"}.fa-fonticons:before{content:\"\\F280\"}.fa-reddit-alien:before{content:\"\\F281\"}.fa-edge:before{content:\"\\F282\"}.fa-credit-card-alt:before{content:\"\\F283\"}.fa-codiepie:before{content:\"\\F284\"}.fa-modx:before{content:\"\\F285\"}.fa-fort-awesome:before{content:\"\\F286\"}.fa-usb:before{content:\"\\F287\"}.fa-product-hunt:before{content:\"\\F288\"}.fa-mixcloud:before{content:\"\\F289\"}.fa-scribd:before{content:\"\\F28A\"}.fa-pause-circle:before{content:\"\\F28B\"}.fa-pause-circle-o:before{content:\"\\F28C\"}.fa-stop-circle:before{content:\"\\F28D\"}.fa-stop-circle-o:before{content:\"\\F28E\"}.fa-shopping-bag:before{content:\"\\F290\"}.fa-shopping-basket:before{content:\"\\F291\"}.fa-hashtag:before{content:\"\\F292\"}.fa-bluetooth:before{content:\"\\F293\"}.fa-bluetooth-b:before{content:\"\\F294\"}.fa-percent:before{content:\"\\F295\"}.fa-gitlab:before{content:\"\\F296\"}.fa-wpbeginner:before{content:\"\\F297\"}.fa-wpforms:before{content:\"\\F298\"}.fa-envira:before{content:\"\\F299\"}.fa-universal-access:before{content:\"\\F29A\"}.fa-wheelchair-alt:before{content:\"\\F29B\"}.fa-question-circle-o:before{content:\"\\F29C\"}.fa-blind:before{content:\"\\F29D\"}.fa-audio-description:before{content:\"\\F29E\"}.fa-volume-control-phone:before{content:\"\\F2A0\"}.fa-braille:before{content:\"\\F2A1\"}.fa-assistive-listening-systems:before{content:\"\\F2A2\"}.fa-asl-interpreting:before,.fa-american-sign-language-interpreting:before{content:\"\\F2A3\"}.fa-deafness:before,.fa-hard-of-hearing:before,.fa-deaf:before{content:\"\\F2A4\"}.fa-glide:before{content:\"\\F2A5\"}.fa-glide-g:before{content:\"\\F2A6\"}.fa-signing:before,.fa-sign-language:before{content:\"\\F2A7\"}.fa-low-vision:before{content:\"\\F2A8\"}.fa-viadeo:before{content:\"\\F2A9\"}.fa-viadeo-square:before{content:\"\\F2AA\"}.fa-snapchat:before{content:\"\\F2AB\"}.fa-snapchat-ghost:before{content:\"\\F2AC\"}.fa-snapchat-square:before{content:\"\\F2AD\"}.fa-pied-piper:before{content:\"\\F2AE\"}.fa-first-order:before{content:\"\\F2B0\"}.fa-yoast:before{content:\"\\F2B1\"}.fa-themeisle:before{content:\"\\F2B2\"}.fa-google-plus-circle:before,.fa-google-plus-official:before{content:\"\\F2B3\"}.fa-fa:before,.fa-font-awesome:before{content:\"\\F2B4\"}.sr-only{position:absolute;width:1px;height:1px;padding:0;margin:-1px;overflow:hidden;clip:rect(0, 0, 0, 0);border:0}.sr-only-focusable:active,.sr-only-focusable:focus{position:static;width:auto;height:auto;margin:0;overflow:visible;clip:auto}\n", ""]);
	
	// exports


/***/ },
/* 45 */
/***/ function(module, exports) {

	/*
		MIT License http://www.opensource.org/licenses/mit-license.php
		Author Tobias Koppers @sokra
	*/
	// css base code, injected by the css-loader
	module.exports = function() {
		var list = [];
	
		// return the list of modules as css string
		list.toString = function toString() {
			var result = [];
			for(var i = 0; i < this.length; i++) {
				var item = this[i];
				if(item[2]) {
					result.push("@media " + item[2] + "{" + item[1] + "}");
				} else {
					result.push(item[1]);
				}
			}
			return result.join("");
		};
	
		// import a list of modules into the list
		list.i = function(modules, mediaQuery) {
			if(typeof modules === "string")
				modules = [[null, modules, ""]];
			var alreadyImportedModules = {};
			for(var i = 0; i < this.length; i++) {
				var id = this[i][0];
				if(typeof id === "number")
					alreadyImportedModules[id] = true;
			}
			for(i = 0; i < modules.length; i++) {
				var item = modules[i];
				// skip already imported module
				// this implementation is not 100% perfect for weird media query combinations
				//  when a module is imported multiple times with different media queries.
				//  I hope this will never occur (Hey this way we have smaller bundles)
				if(typeof item[0] !== "number" || !alreadyImportedModules[item[0]]) {
					if(mediaQuery && !item[2]) {
						item[2] = mediaQuery;
					} else if(mediaQuery) {
						item[2] = "(" + item[2] + ") and (" + mediaQuery + ")";
					}
					list.push(item);
				}
			}
		};
		return list;
	};


/***/ },
/* 46 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "25a32416abee198dd821b0b17a198a8f.eot";

/***/ },
/* 47 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "25a32416abee198dd821b0b17a198a8f.eot";

/***/ },
/* 48 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "e6cf7c6ec7c2d6f670ae9d762604cb0b.woff2";

/***/ },
/* 49 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "c8ddf1e5e5bf3682bc7bebf30f394148.woff";

/***/ },
/* 50 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "1dc35d25e61d819a9c357074014867ab.ttf";

/***/ },
/* 51 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "d7c639084f684d66a1bc66855d193ed8.svg";

/***/ },
/* 52 */
/***/ function(module, exports, __webpack_require__) {

	/*
		MIT License http://www.opensource.org/licenses/mit-license.php
		Author Tobias Koppers @sokra
	*/
	var stylesInDom = {},
		memoize = function(fn) {
			var memo;
			return function () {
				if (typeof memo === "undefined") memo = fn.apply(this, arguments);
				return memo;
			};
		},
		isOldIE = memoize(function() {
			return /msie [6-9]\b/.test(window.navigator.userAgent.toLowerCase());
		}),
		getHeadElement = memoize(function () {
			return document.head || document.getElementsByTagName("head")[0];
		}),
		singletonElement = null,
		singletonCounter = 0,
		styleElementsInsertedAtTop = [];
	
	module.exports = function(list, options) {
		if(true) {
			if(typeof document !== "object") throw new Error("The style-loader cannot be used in a non-browser environment");
		}
	
		options = options || {};
		// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
		// tags it will allow on a page
		if (typeof options.singleton === "undefined") options.singleton = isOldIE();
	
		// By default, add <style> tags to the bottom of <head>.
		if (typeof options.insertAt === "undefined") options.insertAt = "bottom";
	
		var styles = listToStyles(list);
		addStylesToDom(styles, options);
	
		return function update(newList) {
			var mayRemove = [];
			for(var i = 0; i < styles.length; i++) {
				var item = styles[i];
				var domStyle = stylesInDom[item.id];
				domStyle.refs--;
				mayRemove.push(domStyle);
			}
			if(newList) {
				var newStyles = listToStyles(newList);
				addStylesToDom(newStyles, options);
			}
			for(var i = 0; i < mayRemove.length; i++) {
				var domStyle = mayRemove[i];
				if(domStyle.refs === 0) {
					for(var j = 0; j < domStyle.parts.length; j++)
						domStyle.parts[j]();
					delete stylesInDom[domStyle.id];
				}
			}
		};
	}
	
	function addStylesToDom(styles, options) {
		for(var i = 0; i < styles.length; i++) {
			var item = styles[i];
			var domStyle = stylesInDom[item.id];
			if(domStyle) {
				domStyle.refs++;
				for(var j = 0; j < domStyle.parts.length; j++) {
					domStyle.parts[j](item.parts[j]);
				}
				for(; j < item.parts.length; j++) {
					domStyle.parts.push(addStyle(item.parts[j], options));
				}
			} else {
				var parts = [];
				for(var j = 0; j < item.parts.length; j++) {
					parts.push(addStyle(item.parts[j], options));
				}
				stylesInDom[item.id] = {id: item.id, refs: 1, parts: parts};
			}
		}
	}
	
	function listToStyles(list) {
		var styles = [];
		var newStyles = {};
		for(var i = 0; i < list.length; i++) {
			var item = list[i];
			var id = item[0];
			var css = item[1];
			var media = item[2];
			var sourceMap = item[3];
			var part = {css: css, media: media, sourceMap: sourceMap};
			if(!newStyles[id])
				styles.push(newStyles[id] = {id: id, parts: [part]});
			else
				newStyles[id].parts.push(part);
		}
		return styles;
	}
	
	function insertStyleElement(options, styleElement) {
		var head = getHeadElement();
		var lastStyleElementInsertedAtTop = styleElementsInsertedAtTop[styleElementsInsertedAtTop.length - 1];
		if (options.insertAt === "top") {
			if(!lastStyleElementInsertedAtTop) {
				head.insertBefore(styleElement, head.firstChild);
			} else if(lastStyleElementInsertedAtTop.nextSibling) {
				head.insertBefore(styleElement, lastStyleElementInsertedAtTop.nextSibling);
			} else {
				head.appendChild(styleElement);
			}
			styleElementsInsertedAtTop.push(styleElement);
		} else if (options.insertAt === "bottom") {
			head.appendChild(styleElement);
		} else {
			throw new Error("Invalid value for parameter 'insertAt'. Must be 'top' or 'bottom'.");
		}
	}
	
	function removeStyleElement(styleElement) {
		styleElement.parentNode.removeChild(styleElement);
		var idx = styleElementsInsertedAtTop.indexOf(styleElement);
		if(idx >= 0) {
			styleElementsInsertedAtTop.splice(idx, 1);
		}
	}
	
	function createStyleElement(options) {
		var styleElement = document.createElement("style");
		styleElement.type = "text/css";
		insertStyleElement(options, styleElement);
		return styleElement;
	}
	
	function createLinkElement(options) {
		var linkElement = document.createElement("link");
		linkElement.rel = "stylesheet";
		insertStyleElement(options, linkElement);
		return linkElement;
	}
	
	function addStyle(obj, options) {
		var styleElement, update, remove;
	
		if (options.singleton) {
			var styleIndex = singletonCounter++;
			styleElement = singletonElement || (singletonElement = createStyleElement(options));
			update = applyToSingletonTag.bind(null, styleElement, styleIndex, false);
			remove = applyToSingletonTag.bind(null, styleElement, styleIndex, true);
		} else if(obj.sourceMap &&
			typeof URL === "function" &&
			typeof URL.createObjectURL === "function" &&
			typeof URL.revokeObjectURL === "function" &&
			typeof Blob === "function" &&
			typeof btoa === "function") {
			styleElement = createLinkElement(options);
			update = updateLink.bind(null, styleElement);
			remove = function() {
				removeStyleElement(styleElement);
				if(styleElement.href)
					URL.revokeObjectURL(styleElement.href);
			};
		} else {
			styleElement = createStyleElement(options);
			update = applyToTag.bind(null, styleElement);
			remove = function() {
				removeStyleElement(styleElement);
			};
		}
	
		update(obj);
	
		return function updateStyle(newObj) {
			if(newObj) {
				if(newObj.css === obj.css && newObj.media === obj.media && newObj.sourceMap === obj.sourceMap)
					return;
				update(obj = newObj);
			} else {
				remove();
			}
		};
	}
	
	var replaceText = (function () {
		var textStore = [];
	
		return function (index, replacement) {
			textStore[index] = replacement;
			return textStore.filter(Boolean).join('\n');
		};
	})();
	
	function applyToSingletonTag(styleElement, index, remove, obj) {
		var css = remove ? "" : obj.css;
	
		if (styleElement.styleSheet) {
			styleElement.styleSheet.cssText = replaceText(index, css);
		} else {
			var cssNode = document.createTextNode(css);
			var childNodes = styleElement.childNodes;
			if (childNodes[index]) styleElement.removeChild(childNodes[index]);
			if (childNodes.length) {
				styleElement.insertBefore(cssNode, childNodes[index]);
			} else {
				styleElement.appendChild(cssNode);
			}
		}
	}
	
	function applyToTag(styleElement, obj) {
		var css = obj.css;
		var media = obj.media;
	
		if(media) {
			styleElement.setAttribute("media", media)
		}
	
		if(styleElement.styleSheet) {
			styleElement.styleSheet.cssText = css;
		} else {
			while(styleElement.firstChild) {
				styleElement.removeChild(styleElement.firstChild);
			}
			styleElement.appendChild(document.createTextNode(css));
		}
	}
	
	function updateLink(linkElement, obj) {
		var css = obj.css;
		var sourceMap = obj.sourceMap;
	
		if(sourceMap) {
			// http://stackoverflow.com/a/26603875
			css += "\n/*# sourceMappingURL=data:application/json;base64," + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + " */";
		}
	
		var blob = new Blob([css], { type: "text/css" });
	
		var oldSrc = linkElement.href;
	
		linkElement.href = URL.createObjectURL(blob);
	
		if(oldSrc)
			URL.revokeObjectURL(oldSrc);
	}


/***/ },
/* 53 */
/***/ function(module, exports, __webpack_require__) {

	// style-loader: Adds some css to the DOM by adding a <style> tag
	
	// load the styles
	var content = __webpack_require__(54);
	if(typeof content === 'string') content = [[module.id, content, '']];
	// add the styles to the DOM
	var update = __webpack_require__(52)(content, {});
	if(content.locals) module.exports = content.locals;
	// Hot Module Replacement
	if(false) {
		// When the styles change, update the <style> tags
		if(!content.locals) {
			module.hot.accept("!!./../../css-loader/index.js!./material-icons.css", function() {
				var newContent = require("!!./../../css-loader/index.js!./material-icons.css");
				if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
				update(newContent);
			});
		}
		// When the module is disposed, remove the <style> tags
		module.hot.dispose(function() { update(); });
	}

/***/ },
/* 54 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "@font-face {\n  font-family: 'Material Icons';\n  font-style: normal;\n  font-weight: 400;\n  src: url(" + __webpack_require__(55) + "); /* For IE6-8 */\n  src: local('Material Icons'),\n       local('MaterialIcons-Regular'),\n       url(" + __webpack_require__(56) + ") format('woff2'),\n       url(" + __webpack_require__(57) + ") format('woff'),\n       url(" + __webpack_require__(58) + ") format('truetype');\n}\n\n.material-icons {\n  font-family: 'Material Icons';\n  font-weight: normal;\n  font-style: normal;\n  font-size: 24px;  /* Preferred icon size */\n  display: inline-block;\n  width: 1em;\n  height: 1em;\n  line-height: 1;\n  text-transform: none;\n  letter-spacing: normal;\n  word-wrap: normal;\n  white-space: nowrap;\n  direction: ltr;\n\n  /* Support for all WebKit browsers. */\n  -webkit-font-smoothing: antialiased;\n  /* Support for Safari and Chrome. */\n  text-rendering: optimizeLegibility;\n\n  /* Support for Firefox. */\n  -moz-osx-font-smoothing: grayscale;\n\n  /* Support for IE. */\n  font-feature-settings: 'liga';\n}\n", ""]);
	
	// exports


/***/ },
/* 55 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "e79bfd88537def476913f3ed52f4f4b3.eot";

/***/ },
/* 56 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "570eb83859dc23dd0eec423a49e147fe.woff2";

/***/ },
/* 57 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "012cf6a10129e2275d79d6adac7f3b02.woff";

/***/ },
/* 58 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "a37b0c01c0baf1888ca812cc0508f6e2.ttf";

/***/ },
/* 59 */
/***/ function(module, exports, __webpack_require__) {

	// style-loader: Adds some css to the DOM by adding a <style> tag
	
	// load the styles
	var content = __webpack_require__(60);
	if(typeof content === 'string') content = [[module.id, content, '']];
	// add the styles to the DOM
	var update = __webpack_require__(52)(content, {});
	if(content.locals) module.exports = content.locals;
	// Hot Module Replacement
	if(false) {
		// When the styles change, update the <style> tags
		if(!content.locals) {
			module.hot.accept("!!./../../../css-loader/index.js!./index.css", function() {
				var newContent = require("!!./../../../css-loader/index.js!./index.css");
				if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
				update(newContent);
			});
		}
		// When the module is disposed, remove the <style> tags
		module.hot.dispose(function() { update(); });
	}

/***/ },
/* 60 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	exports.i(__webpack_require__(61), "");
	exports.i(__webpack_require__(62), "");
	exports.i(__webpack_require__(63), "");
	exports.i(__webpack_require__(64), "");
	exports.i(__webpack_require__(65), "");
	exports.i(__webpack_require__(83), "");
	exports.i(__webpack_require__(94), "");
	exports.i(__webpack_require__(95), "");
	exports.i(__webpack_require__(96), "");
	exports.i(__webpack_require__(97), "");
	exports.i(__webpack_require__(98), "");
	exports.i(__webpack_require__(99), "");
	exports.i(__webpack_require__(100), "");
	exports.i(__webpack_require__(101), "");
	exports.i(__webpack_require__(102), "");
	exports.i(__webpack_require__(112), "");
	exports.i(__webpack_require__(113), "");
	exports.i(__webpack_require__(114), "");
	exports.i(__webpack_require__(115), "");
	exports.i(__webpack_require__(116), "");
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n\nbody {\n  background: #E0E0E0;\n  font-family: sans-serif;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  margin: 0;\n  padding: 0;\n  overflow: hidden;\n}\n\n\n.p-Widget {\n  background: white;\n}\n\n\n.p-mod-hidden {\n  display: none !important;\n}\n\n\n.p-TabBar-tab.jp-mod-current {\n  border-top: 1px solid #2196F3;\n}\n\n\n.jp-Document {\n  min-width: 120px;\n  min-height: 120px;\n  outline: none;\n}\n\n\n.jp-NotebookContainer-widget {\n  flex: 0 0 auto;\n}\n\n\n.jp-Notebook {\n  flex: 1 1 auto;\n}\n\n\n.p-DockPanel-tabPanel {\n  border-top: none;\n}\n\n\n.p-DockPanel-tabPanel > .p-StackedPanel {\n  background: white;\n  border-left: 1px solid #BDBDBD;\n  border-right: 1px solid #BDBDBD;\n  border-bottom: 1px solid #BDBDBD;\n}\n\n\n.p-DockPanel-overlay {\n  background: rgba(33, 150, 243, 0.1);\n  border: 1px dashed #2196F3;\n}\n\n\n.p-DockPanel-overlay.p-mod-root-top,\n.p-DockPanel-overlay.p-mod-root-left,\n.p-DockPanel-overlay.p-mod-root-right,\n.p-DockPanel-overlay.p-mod-root-bottom,\n.p-DockPanel-overlay.p-mod-root-center {\n  border-width: 2px;\n}\n\n\n.p-TabBar {\n  overflow: visible;\n  min-height: 24px;\n  max-height: 24px;\n  color: #777777;\n  font-size: 13px;\n}\n\n\n.p-TabBar.p-mod-horizontal {\n  min-height: 24px;\n  max-height: 24px;\n}\n\n\n.p-TabBar.p-mod-vertical {\n  min-width: 24px;\n  max-width: 24px;\n}\n\n\n.p-TabBar.p-mod-top {\n  border-bottom: 1px solid #C0C0C0;\n}\n\n\n.p-TabBar.p-mod-bottom {\n  border-top: 1px solid #C0C0C0;\n}\n\n\n.p-TabBar.p-mod-left {\n  border-right: 1px solid #C0C0C0;\n}\n\n\n.p-TabBar.p-mod-right {\n  border-left: 1px solid #C0C0C0;\n}\n\n\n/* increase specificity to override default */\n.p-TabBar > .p-TabBar-header {\n  flex: 0 0 1px;\n}\n\n\n.p-TabBar-content {\n  min-width: 0;\n  min-height: 0;\n  padding-right: 1px;\n}\n\n\n.p-TabBar.p-mod-top > .p-TabBar-content {\n  align-items: flex-end;\n}\n\n\n.p-TabBar.p-mod-bottom > .p-TabBar-content {\n  align-items: flex-start;\n}\n\n\n.p-TabBar-tab {\n  flex-basis: 144px;\n  min-height: 23px;\n  max-height: 23px;\n  min-width: 35px;\n  padding: 0px 7px;\n  background: #EEEEEE;\n  border: 1px solid #BDBDBD;\n  transform: translateY(-1px);\n  border-bottom: none;\n  margin-right: -1px;\n}\n\n\n.p-TabBar-tab.p-mod-current {\n  min-height: 24px;\n  max-height: 24px;\n  background: #FFFFFF;\n}\n\n\n.p-TabBar-tab:hover:not(.p-mod-current) {\n  background: #FAFAFA;\n}\n\n\n.p-TabBar.p-mod-top .p-TabBar-tab,\n.p-TabBar.p-mod-bottom .p-TabBar-tab {\n  flex: 0 1 125px;\n  min-height: 20px;\n  max-height: 20px;\n  min-width: 35px;\n  margin-left: -1px;\n  line-height: 20px;\n}\n\n\n.p-TabBar.p-mod-top .p-TabBar-tab {\n  border-bottom: none;\n}\n\n\n.p-TabBar.p-mod-bottom .p-TabBar-tab {\n  border-top: none;\n}\n\n\n.p-TabBar.p-mod-top .p-TabBar-tab:first-child,\n.p-TabBar.p-mod-bottom .p-TabBar-tab:first-child {\n  margin-left: 0;\n}\n\n\n.p-TabBar.p-mod-top .p-TabBar-tab.p-mod-current,\n.p-TabBar.p-mod-bottom .p-TabBar-tab.p-mod-current {\n  min-height: 23px;\n  max-height: 23px;\n}\n\n\n.p-TabBar.p-mod-top .p-TabBar-tab.p-mod-current {\n  transform: translateY(1px);\n}\n\n\n.p-TabBar.p-mod-bottom .p-TabBar-tab.p-mod-current {\n  transform: translateY(-1px);\n}\n\n\n.p-TabBar.p-mod-left .p-TabBar-tab,\n.p-TabBar.p-mod-right .p-TabBar-tab {\n  flex: 0 1 40px;\n  margin-top: -1px;\n  line-height: 40px;\n}\n\n\n.p-TabBar.p-mod-left .p-TabBar-tab {\n  border-right: none;\n}\n\n\n.p-TabBar.p-mod-right .p-TabBar-tab {\n  border-left: none;\n}\n\n\n.p-TabBar.p-mod-left .p-TabBar-tab:first-child,\n.p-TabBar.p-mod-right .p-TabBar-tab:first-child {\n  margin-top: 0;\n}\n\n\n.p-TabBar.p-mod-left .p-TabBar-tab.p-mod-current,\n.p-TabBar.p-mod-right .p-TabBar-tab.p-mod-current {\n  min-width: 80px;\n  max-width: 80px;\n}\n\n\n.p-TabBar.p-mod-right .p-TabBar-tab.p-mod-current {\n  transform: translateX(-1px);\n}\n\n\n.p-TabBar-tabIcon,\n.p-TabBar-tabLabel,\n.p-TabBar-tabCloseIcon {\n  display: inline-block;\n}\n\n\n.p-TabBar-tab.p-mod-closable > .p-TabBar-tabCloseIcon {\n  margin-left: 4px;\n}\n\n\n.p-TabBar-tab.p-mod-closable > .p-TabBar-tabCloseIcon:before {\n  content: '\\F00D';\n  font-family: FontAwesome;\n  font-size: 10px;\n}\n\n\n.p-TabBar-tab.p-mod-closable.jp-mod-dirty > .p-TabBar-tabCloseIcon:before {\n  font-family: FontAwesome;\n  content: '\\F111'; /* circle */\n  font-size: 10px;\n}\n\n\n.p-TabPanel-stackedPanel {\n  padding: 10px;\n  background: white;\n  border: 1px solid #C0C0C0;\n  box-shadow: 1px 1px 2px rgba(0, 0, 0, 0.2);\n}\n\n\n.p-TabPanel.p-mod-top-to-bottom > .p-TabPanel-stackedPanel {\n  border-top: none;\n}\n\n\n.p-TabPanel.p-mod-bottom-to-top > .p-TabPanel-stackedPanel {\n  border-bottom: none;\n}\n\n\n.p-TabPanel.p-mod-left-to-right > .p-TabPanel-stackedPanel {\n  border-left: none;\n}\n\n\n.p-TabPanel.p-mod-right-to-left > .p-TabPanel-stackedPanel {\n  border-right: none;\n}\n\n\n.p-TabBar-tab.p-mod-drag-image {\n  min-height: 24px;\n  min-width: 124px;\n  color: #777777;\n  background: white;\n  border: 1px solid #BDBDBD;\n  border-top: 1px solid #2196F3;\n  font-size: 14px;\n  box-shadow: 1px 1px 2px rgba(0, 0, 1, 0.1);\n  transform: translateX(-40%) translateY(-58%);\n}\n\n\n.p-MenuBar {\n  padding-left: 5px;\n  background: #FAFAFA;\n  color: rgba(0, 0, 0, 0.87);\n  font-size: 14px;\n}\n\n\n.p-MenuBar-menu {\n  transform: translateY(-1px);\n}\n\n\n.p-MenuBar-item {\n  padding: 4px 8px;\n  border-left: 1px solid transparent;\n  border-right: 1px solid transparent;\n}\n\n\n.p-MenuBar-item.p-mod-active {\n  background: #E5E5E5;\n}\n\n\n.p-MenuBar-item.p-mod-disabled {\n  color: rgba(0, 0, 0, 0.26);\n}\n\n\n.p-MenuBar-item.p-type-separator {\n  margin: 2px;\n  padding: 0;\n  border: none;\n  border-left: 1px solid #DDDDDD;\n}\n\n\n.p-MenuBar.p-mod-active .p-MenuBar-item.p-mod-active {\n  z-index: 10001;\n  background: white;\n  border-left: 1px solid #C0C0C0;\n  border-right: 1px solid #C0C0C0;\n  box-shadow: 0px 0px 6px rgba(0, 0, 0, 0.2);\n}\n\n\n.p-Menu {\n  z-index: 10000;\n  padding: 3px 0px;\n  background: white;\n  color: rgba(0, 0, 0, 0.87);\n  border: 1px solid #C0C0C0;\n  font-size: 14px;\n  box-shadow: 0px 1px 6px rgba(0, 0, 0, 0.2);\n}\n\n\n.p-Menu-item.p-mod-active {\n  background: #E5E5E5;\n}\n\n\n.p-Menu-item.p-mod-disabled {\n  color: rgba(0, 0, 0, 0.26);\n}\n\n\n.p-Menu-itemIcon {\n  width: 21px;\n  padding: 4px 2px;\n}\n\n\n.p-Menu-itemLabel {\n  padding: 4px 35px 4px 2px;\n}\n\n\n.p-Menu-itemShortcut {\n  padding: 4px 0px;\n}\n\n\n.p-Menu-itemSubmenuIcon {\n  width: 16px;\n  padding: 4px 0px;\n}\n\n\n.p-Menu-item.p-type-separator > div {\n  padding: 0;\n  height: 9px;\n}\n\n\n.p-Menu-item.p-type-separator > div::after {\n  content: '';\n  display: block;\n  position: relative;\n  top: 4px;\n  border-top: 1px solid #DDDDDD;\n}\n\n\n.p-Menu-itemIcon::before,\n.p-Menu-itemSubmenuIcon::before {\n  font-family: FontAwesome;\n}\n\n\n.p-Menu-item.p-type-check.p-mod-checked > .p-Menu-itemIcon::before {\n  content: '\\F00C';\n}\n\n\n.p-Menu-item.p-type-submenu > .p-Menu-itemSubmenuIcon::before {\n  content: '\\F0DA';\n}\n\n\n.p-MenuBar-itemMnemonic {\n  text-decoration: underline;\n}\n\n\n.p-Widget.jp-Cell.jp-CodeCell.jp-mod-collapsed.jp-mod-readOnly {\n  padding-left: 5px;\n  padding-right: 5px;\n  border-width: 1px;\n  border-style: solid;\n  border-color: transparent;\n  outline: none;\n  background: transparent;\n  border-color: transparent;\n}\n\n\n.jp-MainAreaLandscapeIcon {\n  background-repeat: no-repeat;\n  margin-right: 2px;\n  width: 22px;\n}\n\n\n.jp-MainAreaPortraitIcon {\n  background-position: 0 1px;\n  background-repeat: no-repeat;\n  margin-right: 0;\n  width: 20px;\n}\n", ""]);
	
	// exports


/***/ },
/* 61 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\r\n| Copyright (c) 2014-2016, PhosphorJS Contributors\r\n|\r\n| Distributed under the terms of the BSD 3-Clause License.\r\n|\r\n| The full license is in the file LICENSE, distributed with this software.\r\n|----------------------------------------------------------------------------*/\r\n\r\n\r\n/*-----------------------------------------------------------------------------\r\n| dom/cursor\r\n|----------------------------------------------------------------------------*/\r\nbody.p-mod-override-cursor * {\r\n  cursor: inherit !important;\r\n}\r\n\r\n\r\n/*-----------------------------------------------------------------------------\r\n| ui/widget\r\n|----------------------------------------------------------------------------*/\r\n.p-Widget {\r\n  box-sizing: border-box;\r\n  position: relative;\r\n  overflow: hidden;\r\n  cursor: default;\r\n}\r\n\r\n\r\n.p-Widget.p-mod-hidden {\r\n  display: none;\r\n}\r\n\r\n\r\n/*-----------------------------------------------------------------------------\r\n| ui/commandpalette\r\n|----------------------------------------------------------------------------*/\r\n.p-CommandPalette {\r\n  display: flex;\r\n  flex-direction: column;\r\n  -webkit-user-select: none;\r\n  -moz-user-select: none;\r\n  -ms-user-select: none;\r\n  user-select: none;\r\n}\r\n\r\n\r\n.p-CommandPalette-search {\r\n  flex: 0 0 auto;\r\n}\r\n\r\n\r\n.p-CommandPalette-content {\r\n  flex: 1 1 auto;\r\n  margin: 0;\r\n  padding: 0;\r\n  min-height: 0;\r\n  overflow: auto;\r\n  list-style-type: none;\r\n}\r\n\r\n\r\n.p-CommandPalette-header {\r\n  overflow: hidden;\r\n  white-space: nowrap;\r\n  text-overflow: ellipsis;\r\n  text-transform: capitalize;\r\n}\r\n\r\n\r\n.p-CommandPalette-itemShortcut {\r\n  float: right;\r\n}\r\n\r\n\r\n.p-CommandPalette-itemLabel {\r\n  overflow: hidden;\r\n  white-space: nowrap;\r\n  text-overflow: ellipsis;\r\n}\r\n\r\n\r\n/*-----------------------------------------------------------------------------\r\n| ui/menu\r\n|----------------------------------------------------------------------------*/\r\n.p-Menu {\r\n  position: absolute;\r\n  white-space: nowrap;\r\n  overflow-x: hidden;\r\n  overflow-y: auto;\r\n  outline: none;\r\n  -webkit-user-select: none;\r\n  -moz-user-select: none;\r\n  -ms-user-select: none;\r\n  user-select: none;\r\n}\r\n\r\n\r\n.p-Menu-content {\r\n  margin: 0;\r\n  padding: 0;\r\n  display: table;\r\n  list-style-type: none;\r\n}\r\n\r\n\r\n.p-Menu-item {\r\n  display: table-row;\r\n}\r\n\r\n\r\n.p-Menu-item.p-mod-hidden {\r\n  display: none;\r\n}\r\n\r\n\r\n.p-Menu-itemIcon,\r\n.p-Menu-itemSubmenuIcon {\r\n  display: table-cell;\r\n  text-align: center;\r\n}\r\n\r\n\r\n.p-Menu-itemLabel {\r\n  display: table-cell;\r\n  text-align: left;\r\n}\r\n\r\n\r\n.p-Menu-itemShortcut {\r\n  display: table-cell;\r\n  text-align: right;\r\n}\r\n\r\n\r\n/*-----------------------------------------------------------------------------\r\n| ui/menubar\r\n|----------------------------------------------------------------------------*/\r\n.p-MenuBar {\r\n  outline: none;\r\n  -webkit-user-select: none;\r\n  -moz-user-select: none;\r\n  -ms-user-select: none;\r\n  user-select: none;\r\n}\r\n\r\n\r\n.p-MenuBar-content {\r\n  margin: 0;\r\n  padding: 0;\r\n  display: flex;\r\n  flex-direction: row;\r\n  list-style-type: none;\r\n}\r\n\r\n\r\n.p-MenuBar-item {\r\n  box-sizing: border-box;\r\n}\r\n\r\n\r\n.p-MenuBar-itemIcon,\r\n.p-MenuBar-itemLabel {\r\n  display: inline-block;\r\n}\r\n\r\n\r\n/*-----------------------------------------------------------------------------\r\n| ui/splitpanel\r\n|----------------------------------------------------------------------------*/\r\n.p-SplitPanel-child {\r\n  z-index: 0;\r\n}\r\n\r\n\r\n.p-SplitPanel-handle {\r\n  z-index: 1;\r\n}\r\n\r\n\r\n.p-SplitPanel-handle.p-mod-hidden {\r\n  display: none;\r\n}\r\n\r\n\r\n.p-SplitPanel-handle:after {\r\n  position: absolute;\r\n  top: 0;\r\n  left: 0;\r\n  width: 100%;\r\n  height: 100%;\r\n  content: '';\r\n}\r\n\r\n\r\n.p-SplitPanel.p-mod-horizontal > .p-SplitPanel-handle {\r\n  cursor: ew-resize;\r\n}\r\n\r\n\r\n.p-SplitPanel.p-mod-vertical > .p-SplitPanel-handle {\r\n  cursor: ns-resize;\r\n}\r\n\r\n\r\n.p-SplitPanel.p-mod-horizontal > .p-SplitPanel-handle:after {\r\n  left: 50%;\r\n  min-width: 7px;\r\n  transform: translateX(-50%);\r\n}\r\n\r\n\r\n.p-SplitPanel.p-mod-vertical > .p-SplitPanel-handle:after {\r\n  top: 50%;\r\n  min-height: 7px;\r\n  transform: translateY(-50%);\r\n}\r\n\r\n\r\n/*-----------------------------------------------------------------------------\r\n| ui/tabbar\r\n|----------------------------------------------------------------------------*/\r\n.p-TabBar {\r\n  display: flex;\r\n  -webkit-user-select: none;\r\n  -moz-user-select: none;\r\n  -ms-user-select: none;\r\n  user-select: none;\r\n}\r\n\r\n\r\n.p-TabBar.p-mod-horizontal {\r\n  flex-direction: row;\r\n}\r\n\r\n\r\n.p-TabBar.p-mod-vertical {\r\n  flex-direction: column;\r\n}\r\n\r\n\r\n.p-TabBar-content {\r\n  margin: 0;\r\n  padding: 0;\r\n  display: flex;\r\n  flex: 1 1 auto;\r\n  list-style-type: none;\r\n}\r\n\r\n\r\n.p-TabBar.p-mod-horizontal > .p-TabBar-content {\r\n  flex-direction: row;\r\n}\r\n\r\n\r\n.p-TabBar.p-mod-vertical > .p-TabBar-content {\r\n  flex-direction: column;\r\n}\r\n\r\n\r\n.p-TabBar-tab {\r\n  display: flex;\r\n  flex-direction: row;\r\n  box-sizing: border-box;\r\n  overflow: hidden;\r\n}\r\n\r\n\r\n.p-TabBar-tabIcon,\r\n.p-TabBar-tabCloseIcon {\r\n  flex: 0 0 auto;\r\n}\r\n\r\n\r\n.p-TabBar-tabLabel {\r\n  flex: 1 1 auto;\r\n  overflow: hidden;\r\n  white-space: nowrap;\r\n}\r\n\r\n\r\n.p-TabBar-tab.p-mod-hidden {\r\n  display: none;\r\n}\r\n\r\n\r\n.p-TabBar.p-mod-dragging .p-TabBar-tab {\r\n  position: relative;\r\n}\r\n\r\n\r\n.p-TabBar.p-mod-horizontal.p-mod-dragging .p-TabBar-tab {\r\n  left: 0;\r\n  transition: left 150ms ease; /* keep in sync with JS */\r\n}\r\n\r\n\r\n.p-TabBar.p-mod-vertical.p-mod-dragging .p-TabBar-tab {\r\n  top: 0;\r\n  transition: top 150ms ease; /* keep in sync with JS */\r\n}\r\n\r\n\r\n.p-TabBar.p-mod-dragging .p-TabBar-tab.p-mod-dragging {\r\n  transition: none;\r\n}\r\n\r\n\r\n/*-----------------------------------------------------------------------------\r\n| ui/tabpanel\r\n|----------------------------------------------------------------------------*/\r\n.p-TabPanel-tabBar {\r\n  z-index: 1;\r\n}\r\n\r\n\r\n.p-TabPanel-stackedPanel {\r\n  z-index: 0;\r\n}\r\n\r\n\r\n/*-----------------------------------------------------------------------------\r\n| ui/dockpanel\r\n|----------------------------------------------------------------------------*/\r\n.p-DockPanel {\r\n  z-index: 0;\r\n}\r\n\r\n\r\n.p-DockPanel-splitPanel,\r\n.p-DockPanel-tabPanel {\r\n  z-index: 0;\r\n}\r\n\r\n\r\n.p-DockPanel-overlay {\r\n  z-index: 1;\r\n  box-sizing: border-box;\r\n  pointer-events: none;\r\n}\r\n\r\n\r\n.p-DockPanel-overlay.p-mod-hidden {\r\n  display: none;\r\n}\r\n", ""]);
	
	// exports


/***/ },
/* 62 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2016, Jupyter Development Team.\n|\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-ConsolePanel {\n  display: flex;\n  flex: 1 1 auto;\n  flex-direction: column;\n}\n\n\n.p-Widget.jp-Console {\n  overflow: auto;\n}\n", ""]);
	
	// exports


/***/ },
/* 63 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2016, Jupyter Development Team.\n|\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-Notebook-panel {\n  display: flex;\n  flex-direction: column;\n}\n\n\n.p-Widget.jp-NBToolbar {\n  flex: 0 0 auto;\n}\n\n\n.p-Widget.jp-Notebook-container {\n  flex: 1 1 auto;\n}\n\n\n.jp-InputArea {\n  display: flex;\n  flex-direction: row;\n}\n\n\n.jp-InputArea-prompt {\n  flex-grow: 0;\n  flex-shrink: 0;\n  padding-top: 8px !important;\n}\n\n\n.jp-InputArea-editor {\n  flex-grow: 1;\n  flex-shrink: 1;\n}\n\n\n.jp-MarkdownCell-content.p-Widget {\n  padding: 7px;\n  user-select: text;\n  -moz-user-select: text;\n  -webkit-user-select: text;\n  -ms-user-select: text;\n}\n\n\n.jp-MarkdownCell-content.p-Widget h1 {\n  font-size: 26px;\n  line-height: 1.0;\n  margin: 14px 0 0 0;\n}\n\n\n.jp-MarkdownCell-content.p-Widget h2 {\n  font-size: 22px;\n  line-height: 1.0;\n  margin: 14px 0 0 0;\n}\n\n\n.jp-MarkdownCell-content.p-Widget h3 {\n  font-size: 18px;\n  line-height: 1.0;\n  margin: 14px 0 0 0;\n}\n\n\n.jp-MarkdownCell-content.p-Widget h4 {\n  font-size: 14px;\n  line-height: 1.0;\n  margin: 14px 0 0 0;\n}\n\n\n.jp-MarkdownCell-content.p-Widget h5 {\n  font-size: 14px;\n  font-style: italic;\n  line-height: 1.0;\n  margin: 14px 0 0 0;\n}\n\n\n.jp-MarkdownCell-content.p-Widget h6 {\n  font-size: 14px;\n  font-style: italic;\n  line-height: 1.0;\n  margin: 14px 0 0 0;\n}\n\n\n.jp-MarkdownCell-content.p-Widget p {\n  font-size: 14px;\n  line-height: 20px;\n  margin: 0 0 0 0;\n}\n\n\n.jp-MarkdownCell-content.p-Widget li {\n  line-height: 20px;\n  margin: 14px 0 0 0;\n}\n\n\n.jp-Output-result.p-Widget {\n  user-select: text;\n  -moz-user-select: text;\n  -webkit-user-select: text;\n  -ms-user-select: text;\n}\n\n.jp-Output-result {\n  overflow: auto;\n}\n\n/* If we have two nested output areas (for example, as with output widgets),\n   then the inner output looks weird with a prompt, so we hide it. */\n.jp-Output .jp-Output .jp-Output-prompt {\n  display: none;\n}\n", ""]);
	
	// exports


/***/ },
/* 64 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2016, Jupyter Development Team.\n|\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n/* Increased specificity in case phosphor css is loaded later. */\n.p-Widget.jp-Notebook {\n  margin-top: 20px;\n  min-width: 50px;\n  min-height: 50px;\n  outline: none;\n  overflow: auto;\n}\n\n\n.p-Widget.jp-Notebook-panel {\n  height: 100%;\n}\n\n\n.p-Widget.jp-Notebook-container {\n  display: flex;\n  flex-direction: column;\n  padding-left: 10px;\n  padding-right: 10px;\n  padding-bottom: 20px;\n}\n\n\n.jp-InputArea-prompt {\n  flex-basis: 90px;\n  color: #303F9F;\n  font-family: monospace;\n  padding: 0.4em;\n  text-align: right;\n  line-height: 20px;\n  font-size: 14px;\n}\n\n\n.jp-InputArea-editor {\n  height: auto;\n  min-height: 2em;\n}\n\n\n.jp-CellEditor {\n  border: 1px solid #cfcfcf;\n  border-radius: 2px;\n  background: #f7f7f7;\n  line-height: 1.2em;\n  padding: 4px;\n}\n\n\n.jp-MarkdownCell {\n  outline: 0;\n}\n\n\n.jp-MarkdownCell.jp-mod-rendered {\n  padding-left: 100px;\n}\n\n\n.jp-MarkdownCell-renderer {\n  padding-left: 4px;\n}\n\n\n.jp-OutputArea {\n  background: none;\n}\n\n\n.jp-Output {\n  display: flex;\n  flex-direction: row;\n}\n\n\n.jp-Output-executeResult {\n  margin-left: 0px;\n  flex: 1 1 auto;\n}\n\n\n.jp-Output-prompt {\n  color: #D84315;\n  font-family: monospace;\n  text-align: right;\n  vertical-align: middle;\n  padding: 0.4em;\n  font-size: 14px;\n  flex: 0 0 90px;\n  box-sizing: border-box;\n}\n\n\n.jp-Output-result {\n  padding: 0.4em;\n}\n\n\n.jp-Notebook .jp-Output pre {\n  border: none;\n  margin: 1px 0 0 5px;\n  overflow-x: auto;\n  overflow-y: auto;\n  word-break: break-all;\n  word-wrap: break-word;\n  white-space: pre-wrap;\n}\n\n\n.jp-Output-stderr {\n  background: #fdd;\n}\n\n\n.jp-Output-stdinPrompt {\n  padding-right: 8px;\n}\n\n\n.jp-Notebook.jp-mod-commandMode .jp-Notebook-cell.jp-mod-active.jp-mod-selected {\n  border-color: #ABABAB;\n  border-left-width: 1px;\n  background: linear-gradient(to right, #42A5F5 -40px, #42A5F5 5px, transparent 5px, transparent 100%);\n}\n\n\n.jp-Notebook.jp-mod-commandMode .jp-Notebook-cell.jp-mod-multiSelected.jp-mod-active {\n  background: linear-gradient(to right, #42A5F5 -40px, #42A5F5 7px, #E3F2FD 7px, #E3F2FD 100%);\n}\n\n\n.jp-Notebook.jp-mod-commandMode .jp-Notebook-cell.jp-mod-selected {\n  background: #E3F2FD;\n}\n\n\n.jp-Notebook.jp-mod-editMode .jp-Notebook-cell.jp-mod-active {\n  border-color: #66BB6A;\n  border-left-width: 1px;\n  background: linear-gradient(to right, #66BB6A -40px, #66BB6A 5px, transparent 5px, transparent 100%);\n}\n\n\n.jp-Cell {\n  padding-top: 5px;\n  padding-bottom: 5px;\n  padding-left: 5px;\n  padding-right: 5px;\n  border-width: 1px;\n  border-style: solid;\n  border-color: transparent;\n  outline: none;\n}\n\n.jp-NBToolbar {\n    display: flex;\n    flex-direction: row;\n    border-bottom: 1px solid #E0E0E0;\n    height: 24px;\n}\n\n\n.jp-NBToolbar > .jp-NBToolbar-item {\n    flex: 0 0 auto;\n    padding-left: 8px;\n    padding-right: 8px;\n    vertical-align: middle;\n    font-size: 14px;\n    color: #616161;\n    line-height: 23px;\n}\n\n\n.jp-NBToolbar-item.jp-NBToolbar-button,\n.jp-NBToolbar-item.jp-NBToolbar-kernelIndicator {\n    font-family: FontAwesome;\n    text-align: center;\n    display: inline-block;\n}\n\n\n.jp-NBToolbar-item.jp-NBToolbar-cellType select {\n    background: #FFFFFF;\n}\n\n.jp-NBToolbar-cellType .jp-NBToolbar-cellTypeDropdown {\n    border: 1px solid #BDBDBD;\n    border-radius: 0;\n    outline: none;\n    width: 100%;\n    font-size: 14px;\n    line-height: 23px;\n    color: #616161;\n}\n\n\n.jp-NBToolbar-item.jp-NBToolbar-kernelName {\n    text-align: right;\n    flex-grow: 1;\n    flex-shrink: 1;\n}\n\n\n.jp-NBToolbar-item.jp-NBToolbar-kernelIndicator {\n    border-right: none;\n}\n\n\n.jp-NBToolbar-button.jp-mod-pressed {\n    background-color: #E0E0E0;\n    box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.5);\n}\n\n\n.jp-NBToolbar-button:hover {\n    background-color: #EEEEEE;\n    box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.5);\n}\n\n\n.jp-NBToolbar-button.jp-NBToolbar-save::before {\n   content: \"\\F0C7\";  /* Save */\n}\n\n\n.jp-NBToolbar-button.jp-NBToolbar-insert::before {\n   content: \"\\F067\";  /* Plus */\n}\n\n\n.jp-NBToolbar-button.jp-NBToolbar-cut::before {\n   content: \"\\F0C4\";  /* Cut */\n}\n\n\n.jp-NBToolbar-button.jp-NBToolbar-copy::before {\n   content: \"\\F0C5\";  /* Copy */\n}\n\n\n.jp-NBToolbar-button.jp-NBToolbar-paste::before {\n   content: \"\\F0EA\";  /* Paste */\n}\n\n\n.jp-NBToolbar-button.jp-NBToolbar-run::before {\n   content: \"\\F051\";  /* Step-forward */\n}\n\n\n.jp-NBToolbar-button.jp-NBToolbar-interrupt::before {\n   content: \"\\F04D\";  /* Stop */\n}\n\n\n.jp-NBToolbar-button.jp-NBToolbar-restart::before {\n   content: \"\\F01E\";  /* Rotate-right */\n}\n\n\n.jp-NBToolbar-item.jp-NBToolbar-kernelIndicator::before {\n    content: \"\\F10C\";  /* Circle-o */\n}\n\n\n.jp-NBToolbar-item.jp-NBToolbar-kernelIndicator.jp-mod-busy::before {\n    content: \"\\F111\";  /* Circle */\n}\n\n\n.jp-CellEditor > .CodeMirror {\n  line-height: 1.21429em;\n  /* Changed from 1em to our global default */\n  font-size: 14px;\n  height: auto;\n  /* Changed to auto to autogrow */\n  background: none;\n  /* Changed from white to allow our bg to show through */\n}\n\n\n.jp-CellEditor > .CodeMirror-scroll {\n  /*  The CodeMirror docs are a bit fuzzy on if overflow-y should be hidden or visible.*/\n  /*  We have found that if it is visible, vertical scrollbars appear with font size changes.*/\n  overflow-y: hidden;\n  overflow-x: auto;\n}\n\n\n.jp-CellEditor > .CodeMirror-lines {\n  /* In CM2, this used to be 0.4em, but in CM3 it went to 4px. We need the em value because */\n  /* we have set a different line-height and want this to scale with that. */\n  padding: 0.4em;\n}\n\n\n.jp-CellEditor > .CodeMirror-linenumber {\n  padding: 0 8px 0 4px;\n}\n\n\n.jp-CellEditor > .CodeMirror-gutters {\n  border-bottom-left-radius: 2px;\n  border-top-left-radius: 2px;\n}\n\n\n.jp-CellEditor > .CodeMirror pre {\n  /* In CM3 this went to 4px from 0 in CM2. We need the 0 value because of how we size */\n  /* .CodeMirror-lines */\n  padding: 0;\n  border: 0;\n  border-radius: 0;\n}\n", ""]);
	
	// exports


/***/ },
/* 65 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	exports.i(__webpack_require__(66), "");
	exports.i(__webpack_require__(77), "");
	exports.i(__webpack_require__(78), "");
	exports.i(__webpack_require__(79), "");
	exports.i(__webpack_require__(80), "");
	exports.i(__webpack_require__(81), "");
	exports.i(__webpack_require__(82), "");
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2016, Jupyter Development Team.\n|\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n\n", ""]);
	
	// exports


/***/ },
/* 66 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "#about {\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  overflow: scroll;\n  scroll-snap-points-y: repeat(100%);\n  scroll-snap-type: mandatory;\n  scroll-snap-destination: 100% 0%;\n}\n\n#about .section {\n  position: relative;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  display: table;\n}\n#about .sectioncenter {\n  display: table-cell;\n  vertical-align: middle;\n}\n\n#about .container {\n  position: relative;\n  width: 100%;\n  max-width: 880px;\n  margin: 0 auto;\n  padding: 0 20px;\n  box-sizing: border-box;\n}\n\n#about .column,\n#about .columns {\n  width: 100%;\n  margin: 0 auto;\n  float: none;\n  box-sizing: border-box;\n}\n\n/* For devices larger than 400px */\n@media (min-width: 400px) {\n  #about .container {\n    width: 85%;\n    padding: 0;\n  }\n}\n\n/* For devices larger than 550px */\n@media (min-width: 550px) {\n  #about .container {\n    width: 80%;\n  }\n  #about .column,\n  #about .columns {\n    margin-left: 4%;\n  }\n  #about .column:first-child,\n  #about .columns:first-child {\n    margin-left: 0;\n  }\n\n\n  #about .one-half.column {\n    width: 48%;\n  }\n}\n\n#about * {\n  -webkit-box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  -ms-box-sizing: border-box;\n  box-sizing: border-box;\n}\n\n#about .row {\n  width: 100%;\n  display: flex;\n  flex-wrap: wrap;\n}\n\n#about .col-1 {\n  width: 8.33%\n}\n\n#about .col-2 {\n  width: 16.66%;\n}\n\n#about .col-3 {\n  width: 25%;\n}\n\n#about .col-4 {\n  width: 33.33%;\n}\n\n#about .col-5 {\n  width: 41.66%;\n}\n\n#about .col-6 {\n  width: 50%;\n}\n\n#about .col-7 {\n  width: 58.33%;\n}\n\n#about .col-8 {\n  width: 66.66%;\n}\n\n#about .col-9 {\n  width: 75%;\n}\n\n#about .col-10 {\n  width: 83.33%;\n}\n\n#about .col-11 {\n  width: 91.66%;\n}\n\n#about .col-12 {\n  width: 100%;\n}\n\n#about {\n  font-family: 'Helvetica Neue', 'Helvetica', 'Arial', sans-serif;\n  text-align: center;\n}\n\n#about .header {\n  font-size: 26px;\n  font-weight: 300;\n  color: #333333;\n  padding-left: 10px;\n  padding-right: 10px;\n  margin: 10px 0;\n}\n\n#about .desc-one {\n  font-size: 13px;\n  color: #555555;\n  line-height: 20px;\n  padding-left: 15px;\n  padding-right: 15px;\n}\n\n#about .desc-two {\n  font-size: 13px;\n  color: #555555;\n  padding-left: 50px;\n  padding-right: 50px;\n  margin-top: 0px;\n}\n\n#about .desc-two-header {\n  color: #333333;\n  font-size: 20px;\n  margin-bottom: 9px;\n  margin-top: 9px;\n}\n\n#about .row img {\n  margin-top: 20px\n}\n\n#about .header.content img {\n  vertical-align: middle;\n  padding-right: 30px;\n}\n\n#about .header.content {\n  vertical-align: middle;\n  line-height: 20px;\n}\n\n#about .content-img {\n  padding: 40px 0 35px 0;\n  height: 40vh;\n  max-height: 453px;\n}\n\n#about .content-desc {\n  font-family: 'Helvetica Neue', 'Helvetica', 'Arial', sans-serif;\n  font-size: 13px;\n  max-width: 550px;\n  margin: 0 auto;\n  float: none;\n  color: #555555;\n  line-height: 20px;\n  padding-bottom: 8px;\n}\n\n#about .content-desc ul {\n  text-align: left;\n  margin-left: 92px;\n  float: none;\n}\n\n#about .desc-two-header {\n  padding: 15px 0 10px 0;\n}\n\n#about .desc-one p {\n  max-width: 740px;\n  margin: 0 auto;\n  float: none;\n}\n\n#about .column .desc-two-header a {\n  color: #555555;\n  text-decoration: none;\n}\n\n#about .desc-two-header:hover a{\n  color: #e46e2e;\n}\n\n#about .nav-button {\n  display: block;\n  position: relative;\n  margin: auto;\n  width: 28px;\n  height: 17px;\n  overflow: hidden;\n  margin-top: 35px;\n  margin-bottom: 10px;\n  background-image: url(" + __webpack_require__(67) + ");\n  background-size: 100%;\n  background-position: top;\n  -webkit-animation: navbtn-anim ease 4s infinite;\n  animation: navbtn-anim ease 4s infinite;\n  -webkit-transition: all 300ms ease;\n  transition: all 300ms ease;\n}\n\n#about .nav-button:hover {\n  background-position: bottom;\n}\n\n@keyframes navbtn-anim {\n  0% { transform: translate(0px,0px); }\n  50% { transform: translate(0px,20px); }\n  100% { transform: translate(0px,0px); }\n}\n\n@-webkit-keyframes navbtn-anim {\n  0% { transform: translate(0px,0px); }\n  50% { transform: translate(0px,20px); }\n  100% { transform: translate(0px,0px); }\n}\n\n#about a, #about a:visited {\n  font-weight: 500;\n  color: #e46e2e;\n  text-decoration: none;\n  -webkit-transition: all 200ms ease-out;\n  transition: all 200ms ease-out;\n}\n\n#about a:hover, #about a:active {\n  color: #ad4b16;\n  text-decoration: underline;\n}\n\n\n/* * * IMAGES * * */\n\n#about .jp-img {\n  display: block;\n  background-position: center;\n  background-repeat: no-repeat;\n  background-size: contain;\n}\n\n#about .jp-About-logo {\n  background-image: url(" + __webpack_require__(68) + ");\n  width: 234px;\n  height: 51px;\n  margin: 20px auto 0 auto;\n}\n\n#about .jp-About-hero-mainarea {\n  display: inline-block;\n  background-image: url(" + __webpack_require__(69) + ");\n  width: 40px;\n  height: 40px;\n  margin: 0 30px;\n  vertical-align: middle;\n}\n\n#about .jp-About-hero-command {\n  display: inline-block;\n  background-image: url(" + __webpack_require__(70) + ");\n  width: 40px;\n  height: 40px;\n  margin: 0 30px;\n  vertical-align: middle;\n}\n\n#about .jp-About-hero-filebrowser {\n  display: inline-block;\n  background-image: url(" + __webpack_require__(71) + ");\n  width: 60px;\n  height: 40px;\n  margin: 0 30px;\n  vertical-align: middle;\n}\n\n#about .jp-About-hero-notebook {\n  display: inline-block;\n  background-image: url(" + __webpack_require__(72) + ");\n  width: 31px;\n  height: 40px;\n  margin: 0 30px;\n  vertical-align: middle;\n}\n\n#about .jp-About-nb {\n  background-image: url(" + __webpack_require__(73) + ");\n  display: block;\n  background-size: contain;\n  margin: 0 0 35px 0;\n  height: 38vh;\n}\n\n#about .jp-About-mainarea {\n  background-image: url(" + __webpack_require__(74) + ");\n  display: inline-block;\n  margin: 0 0 35px 0;\n  max-height: 390px;\n  height: 325px;\n  width: 650px;\n}\n\n#about .jp-About-fb {\n  background-image: url(" + __webpack_require__(75) + ");\n  display: inline-block;\n  margin: 0 0 35px 0;\n  max-height: 390px;\n  height: 325px;\n  width: 650px;\n}\n\n#about .jp-About-command {\n  background-image: url(" + __webpack_require__(76) + ");\n  display: inline-block;\n  margin: 0 0 35px 0;\n  max-height: 390px;\n  height: 325px;\n  width: 650px;\n}\n", ""]);
	
	// exports


/***/ },
/* 67 */
/***/ function(module, exports) {

	module.exports = "data:image/svg+xml;base64,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"

/***/ },
/* 68 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "930dde33391603fade73980cf67feb4e.svg";

/***/ },
/* 69 */
/***/ function(module, exports) {

	module.exports = "data:image/svg+xml;base64,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"

/***/ },
/* 70 */
/***/ function(module, exports) {

	module.exports = "data:image/svg+xml;base64,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"

/***/ },
/* 71 */
/***/ function(module, exports) {

	module.exports = "data:image/svg+xml;base64,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"

/***/ },
/* 72 */
/***/ function(module, exports) {

	module.exports = "data:image/svg+xml;base64,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"

/***/ },
/* 73 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "0662c22d4e544cecf2bc66ee4c761ed6.svg";

/***/ },
/* 74 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "28f2f5e6ac027acb7fbd41f7e02ebf90.gif";

/***/ },
/* 75 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "cdbbf3faea3d6d5b7c7c8a27736254df.gif";

/***/ },
/* 76 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "5e9fca8da62c2b939b204d8883012664.gif";

/***/ },
/* 77 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2016, Jupyter Development Team.\n|\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-Dialog {\n  position: absolute;\n  z-index: 10000;\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  top: 0px;\n  left: 0px;\n  margin: 0;\n  padding: 0;\n  width: 100%;\n  height: 100%;\n}\n\n\n.jp-Dialog-content {\n  margin-left: auto;\n  margin-right: auto;\n}\n\n\n.jp-Dialog-header {\n\n}\n\n\n.jp-Dialog-footer {\n\n}\n\n\n.jp-Dialog-title {\n  overflow: hidden;\n  white-space: nowrap;\n  text-overflow: ellipsis;\n}\n", ""]);
	
	// exports


/***/ },
/* 78 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-FileBrowser {\n  display: flex;\n  flex-direction: column;\n}\n\n\n.jp-BreadCrumbs {\n  flex: 0 0 auto;\n}\n\n\n.jp-FileButtons {\n  flex: 0 0 auto;\n  display: flex;\n  flex-direction: row;\n}\n\n\n.jp-FileButtons-buttonContent {\n  display: flex;\n  flex-direction: row;\n  align-items: baseline;\n}\n\n\n.jp-FileButtons-buttonIcon {\n  margin-left: auto;\n  margin-right: auto;\n}\n\n\n.jp-DirListing {\n  flex: 1 1 auto;\n  display: flex;\n  flex-direction: column;\n}\n\n\n.jp-DirListing-header {\n  flex: 0 0 auto;\n  display: flex;\n  flex-direction: row;\n  overflow: hidden;\n}\n\n\n.jp-DirListing-content {\n  flex: 1 1 auto;\n  margin: 0;\n  padding: 0;\n  list-style-type: none;\n  overflow: auto;\n}\n\n\n.jp-DirListing-item {\n  display: flex;\n  flex-direction: row;\n}\n", ""]);
	
	// exports


/***/ },
/* 79 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n/*\nWhen drag events occur, `p-mod-override-cursor` is added to the body.\nBecause iframes steal all cursor events, the following two rules are necessary\nto suppress pointer events while resize drags are occuring. There may be a\nbetter solution to this problem.\n*/\nbody.p-mod-override-cursor .jp-IFrame {\n  position: relative;\n}\n\n\nbody.p-mod-override-cursor .jp-IFrame:before {\n  content: '';\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background: transparent;\n}\n", ""]);
	
	// exports


/***/ },
/* 80 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n#jp-MainMenu.p-Widget.p-MenuBar {\n   background: white;\n}\n\n#jp-top-panel.p-Widget.p-Panel {\n   border-bottom: 1px solid #BDBDBD;\n   background: white;\n   min-height: 28px;\n   max-height: 28px;\n}\n\n.p-MenuBar .p-MenuBar-item {\n  padding: 6px 8px;\n}\n\n.p-MenuBar-itemText {\n  font-size: 13px;\n  color: #777777;\n}\n\n.p-MenuBar-item.p-mod-active > .p-MenuBar-itemText {\n  color: #2196F3;\n}\n", ""]);
	
	// exports


/***/ },
/* 81 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2016, Jupyter Development Team.\n|\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-Completion {\n  margin: 0;\n  position: absolute;\n  z-index: 10001;\n}\n\n\n.jp-Completion.jp-mod-outofview {\n  display: none;\n}\n", ""]);
	
	// exports


/***/ },
/* 82 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-TerminalWidget {\n  background: red;\n  padding: 0;\n  margin: 0;\n}\n\n\n.jp-TerminalWidget-body {\n  font-family: \"DejaVu Sans Mono\", \"Liberation Mono\", monospace;\n}\n", ""]);
	
	// exports


/***/ },
/* 83 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	exports.i(__webpack_require__(84), "");
	exports.i(__webpack_require__(85), "");
	exports.i(__webpack_require__(86), "");
	exports.i(__webpack_require__(87), "");
	exports.i(__webpack_require__(88), "");
	exports.i(__webpack_require__(89), "");
	exports.i(__webpack_require__(90), "");
	exports.i(__webpack_require__(91), "");
	exports.i(__webpack_require__(92), "");
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2016, Jupyter Development Team.\n|\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n\n\n", ""]);
	
	// exports


/***/ },
/* 84 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.jp-CSVWidget {\n  padding: 1em;\n  overflow: auto;\n}\n\n\n.jp-CSVWidget th,\n.jp-CSVWidget td {\n  border: 1px solid black;\n  padding: 0.2em 0.5em;\n}\n\n.jp-CSVWidget table {\n  border: 1px solid black;\n  border-collapse: collapse;\n}\n", ""]);
	
	// exports


/***/ },
/* 85 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "\n/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2016, Jupyter Development Team.\n|\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-Dialog {\n  background: rgba(0,0,0,0.25);\n  color: #757575;\n}\n\n\n.jp-Dialog-content {\n  background: #FAFAFA;\n  padding: 24px;\n  width: 300px;\n  box-sizing: border-box;\n  box-shadow: 0px 2px 2px 0px rgba(0,0,0,0.5);\n  word-wrap: break-word;\n}\n\n\n.jp-Dialog-header {\n  padding-bottom: 12px;\n  font-size: 18px;\n  color: #616161;\n}\n\n\n.jp-Dialog-body {\n  font-size: 15px;\n  background: #FAFAFA;\n}\n\n\n.jp-Dialog-bodyContent {\n  font-size: 15px;\n  outline: none;\n  margin-bottom: 12px;\n}\n\n\n.jp-Dialog-footer {\n  margin-top: 24px;\n}\n\n\n.jp-Dialog-button {\n  font-size: 15px;\n  border: none;\n  min-width: 120px;\n  max-width: 120px;\n  text-transform: uppercase;\n  line-height: 38px;\n  border-radius: 2px;\n  outline: none;\n  padding: 0px;\n}\n\n\n.jp-Dialog-okButton {\n  background: #2196F3;\n  color: white;\n}\n\n\n.jp-Dialog-cancelButton {\n  background: #9E9E9E;\n  margin-right: 12px;\n  color: white;\n}\n\n\n.jp-Dialog-inputWrapper {\n  padding: 7px;\n  background: white;\n  width: 252px;\n  box-sizing: border-box;\n  border: 1px solid #BDBDBD;\n  border-radius: 2px;\n  margin-bottom: 12px;\n}\n\n\n.jp-Dialog-input {\n  font-size: 15px;\n  color: #676767;\n  width: 100%;\n  outline: none;\n  border: none;\n}\n\n\n.jp-Dialog-selectWrapper {\n  padding-top: 6px;\n  padding-bottom: 6px;\n  background: white;\n  width: 252px;\n  box-sizing: border-box;\n  border: 1px solid #BDBDBD;\n  border-radius: 2px;\n  margin-bottom: 12px;\n}\n\n\n.jp-Dialog-select {\n  font-size: 15px;\n  background: white;\n  color: #676767;\n  width: 100%;\n  outline: none;\n  border: none;\n}\n", ""]);
	
	// exports


/***/ },
/* 86 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2016, Jupyter Development Team.\n|\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-CodeMirrorWidget {\n  height: 100%;\n}\n\n\n.jp-CodeMirrorWidget > .CodeMirror {\n  line-height: 1.21429em;\n  /* Changed from 1em to our global default */\n  font-size: 14px;\n  height: 100%;\n  /* Changed to auto to autogrow */\n  background: none;\n  /* Changed from white to allow our bg to show through */\n}\n\n\n.jp-CodeMirrorWidget .CodeMirror-scroll {\n  /*  The CodeMirror docs are a bit fuzzy on if overflow-y should be hidden or visible.*/\n  /*  We have found that if it is visible, vertical scrollbars appear with font size changes.*/\n  overflow-y: hidden;\n  overflow-x: auto;\n}\n\n\n.jp-CodeMirrorWidget .CodeMirror-lines {\n  /* In CM2, this used to be 0.4em, but in CM3 it went to 4px. We need the em value because */\n  /* we have set a different line-height and want this to scale with that. */\n  padding: 0.4em;\n}\n\n\n.jp-CodeMirrorWidget .CodeMirror-linenumber {\n  padding: 0 8px 0 4px;\n}\n\n\n.jp-CodeMirrorWidget .CodeMirror-gutters {\n  border-bottom-left-radius: 2px;\n  border-top-left-radius: 2px;\n}\n\n\n.jp-CodeMirrorWidget > .CodeMirror pre {\n  /* In CM3 this went to 4px from 0 in CM2. We need the 0 value because of how we size */\n  /* .CodeMirror-lines */\n  padding: 0;\n  border: 0;\n  border-radius: 0;\n}\n\n\n", ""]);
	
	// exports


/***/ },
/* 87 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-EditorWidget {\n    border-top: 1px solid #E0E0E0;\n    margin-top: 4px;\n}\n", ""]);
	
	// exports


/***/ },
/* 88 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-FAQ-body {\n  font-family: \"Helvetica Neue\", \"Helvetica\", \"Arial\", sans-serif;\n}\n\n\n.jp-FAQ-h1 {\n  font-size: 26px;\n  font-weight: 300;\n  color: #313940;\n  margin: 10px 0 0 20px;\n}\n\n\n#faq-header {\n  width: 412px;\n  display: flex;\n  margin: 65px auto 0 auto;\n  text-align: center;\n}\n\n\n.jp-FAQ-h2 {\n  font-size: 14px;\n  font-weight: 300;\n  color: #9E9E9E;\n  margin: 52px 0 0 0;\n}\n\n\n.jp-FAQ-ul {\n  margin: 0 0 0 0;\n}\n\n\nli.jp-FAQ-question {\n  cursor: pointer;\n  font-size: 20px;\n  color: #616161;\n  font-weight: 400;\n  line-height: 150%;\n  list-style-type: none;\n  margin: 28px 0 0 0;\n}\n\n\nli.jp-FAQ-answer{\n  font-size: 15px;\n  font-weight: 200;\n  color: #9E9E9E;\n  line-height: 160%;\n  border-left: 2px solid #9E9E9E;\n  padding-left: 25px;\n  list-style-type: none;\n  margin: 28px 0 0 0;\n}\n\n\nli.jp-FAQ-question:hover {\n  color: #42A5F5;\n}\n\n\nli.jp-FAQ-question:focus{\n  color: #42A5F5;\n}\n\n\n.jp-FAQ-hide {\n  display:none;\n}\n\n\nli>jp-FAQ-answer {\n  color: #4A90E2;\n  text-decoration: none;\n}\n\n\n#faq-content {\n  margin: 0 auto 60px auto;\n  display: block;\n  width: 94%;\n  max-width: 675px;\n}\n\n\nh1 span.jp-FAQ-title {\n  color: #616161;\n  display: block;\n}\n\n\n.jp-FAQ-a {\n    text-decoration: none;\n    cursor: pointer;\n    color: #2196F3;\n}\n\n\n.jp-QuestionMark.jp-FAQ-QuestionMark {\n  height: 49px;\n  width: 49px;\n}\n", ""]);
	
	// exports


/***/ },
/* 89 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-FileBrowser {\n  color: #757575;\n  background: #FAFAFA;\n  font-size: 13px;\n}\n\n\n.jp-BreadCrumbs {\n  margin: 4px 12px;\n}\n\n\n.jp-BreadCrumbs-item {\n  margin: 0px 4px;\n  cursor: pointer;\n}\n\n\n.jp-BreadCrumbs-item:first-child {\n  margin-left: 0px;\n}\n\n\n.jp-BreadCrumbs-item.jp-mod-dropTarget {\n  background: #FEDBC4;\n}\n\n\n.jp-FileButtons {\n  border-bottom: 1px solid #E0E0E0;\n}\n\n\n.jp-FileButtons-button {\n  flex: 1 1 auto;\n  max-width: 100px;\n  padding: 4px 6px;\n  color: #757575;\n  background: #FAFAFA;\n  border: none;\n  font-size: 14px;\n  outline: 0;\n  padding-top: 8px;\n  padding-bottom: 8px;\n}\n\n\n.jp-FileButtons-button::-moz-focus-inner {\n  border: 0;\n}\n\n\n.jp-FileButtons-button:hover {\n  background: #F5F5F5;\n  border-color: #D0D0D0;\n  z-index: 1; /* raise overlapping border */\n}\n\n\n.jp-FileButtons-button:active,\n.jp-FileButtons-button.jp-id-create.jp-mod-active {\n  background: #EEEEEE;\n  border-color: #BDBDBD;\n  z-index: 1; /* raise overlapping border */\n}\n\n\n.jp-FileButtons-button.jp-id-upload {\n  margin-left: -1px; /* overlap borders */\n}\n\n\n.jp-DirListing {\n  outline: 0;\n}\n\n\n.jp-DirListing-header {\n  margin-bottom: 4px;\n  border-top: 1px solid #E0E0E0;\n  border-bottom: 1px solid #E0E0E0;\n}\n\n\n.jp-DirListing-headerItem {\n  padding: 4px 12px;\n  font-weight: 500;\n}\n\n\n.jp-DirListing-headerItem:hover {\n  background: #EEEEEE;\n}\n\n\n.jp-DirListing-headerItem.jp-id-name {\n  flex: 1 0 84px;\n}\n\n\n.jp-DirListing-headerItem.jp-id-modified {\n  flex: 0 0 112px;\n  border-left: 1px solid #E0E0E0;\n  text-align: right;\n}\n\n\n.jp-DirListing-headerItem.jp-mod-selected {\n  font-weight: 600;\n}\n\n\n.jp-DirListing-headerItem.jp-mod-selected .jp-DirListing-headerItemIcon:before {\n  font-family: FontAwesome;\n  content: \"\\F0D8\";\n}\n\n\n.jp-DirListing-headerItem.jp-mod-selected.jp-mod-descending .jp-DirListing-headerItemIcon:before {\n  font-family: FontAwesome;\n  content: \"\\F0D7\";\n}\n\n\n.jp-DirListing-headerItem.jp-mod-selected.jp-id-name .jp-DirListing-headerItemIcon:before {\n  float: right;\n}\n\n\n.jp-DirListing-headerItem.jp-mod-selected.jp-id-modified .jp-DirListing-headerItemIcon:before {\n  float: left;\n}\n\n/* increase specificity to override bundled default */\n/*.jp-DirListing > .jp-DirListing-content {\n  padding: 0px;\n}*/\n\n\n.jp-DirListing-item {\n  padding: 4px 12px;\n}\n\n\n.jp-DirListing-item.jp-mod-selected {\n  color: white;\n  background: #2196F3;\n}\n\n\n.jp-DirListing-item.jp-mod-dropTarget {\n  background: #FEDBC4;\n}\n\n\n.jp-DirListing-item:hover:not(.jp-mod-selected) {\n  background: #EEEEEE;\n}\n\n\n.jp-DirListing-itemIcon {\n  flex: 0 0 20px;\n  font-family: FontAwesome;\n  font-size: 14px;\n}\n\n\n.jp-DirListing-itemText {\n  flex: 1 0 64px;\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis;\n  user-select: none;\n}\n\n\n.jp-DirListing-itemModified {\n  flex: 0 0 108px;\n  text-align: right;\n}\n\n\n.jp-DirListing-editor {\n  flex: 1 0 64px;\n}\n\n\n.jp-type-folder.jp-DirListing-itemIcon:before {\n  content: \"\\F114\";\n}\n\n\n.jp-type-file.jp-DirListing-itemIcon:before {\n  content: \"\\F016\";\n}\n\n\n.jp-type-notebook.jp-DirListing-itemIcon:before {\n  content: \"\\F02D\";\n}\n\n\n.jp-DirListing-item.jp-mod-running .jp-DirListing-itemIcon {\n  color: #27AE60;\n}\n\n.jp-DirListing-item.p-mod-drag-image,\n.jp-DirListing-item.jp-mod-selected.p-mod-drag-image {\n  background-color: #FFFFFF;\n  box-shadow: 5px 5px 10px rgba(46,46,46,0.5);\n  border-radius: 3px;\n  color: #757575;\n  transform: translateX(-40%) translateY(-58%);\n}\n", ""]);
	
	// exports


/***/ },
/* 90 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-ImageWidget {\n  overflow: auto;\n  padding: 0 4px 4px 4px;\n}\n\n.jp-ImageWidget img {\n  max-width: 100%;\n  max-height: 100%;\n  margin: auto;\n}\n", ""]);
	
	// exports


/***/ },
/* 91 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-MarkdownWidget {\n  overflow: auto;\n}\n", ""]);
	
	// exports


/***/ },
/* 92 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	exports.i(__webpack_require__(93), "");
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-TerminalWidget {\n  min-width: 200px;\n  min-height: 200px;\n  padding: 8px;\n}\n\n\n.jp-TerminalWidget-body {\n  outline: none;\n  user-select: text;\n  -webkit-user-select: text;\n}\n\n.terminal {\n  font-family: monospace;\n}\n", ""]);
	
	// exports


/***/ },
/* 93 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/**\n * xterm.js: xterm, in the browser\n * Copyright (c) 2014, sourceLair Limited (www.sourcelair.com (MIT License)\n * Copyright (c) 2012-2013, Christopher Jeffrey (MIT License)\n * https://github.com/chjj/term.js\n *\n * Permission is hereby granted, free of charge, to any person obtaining a copy\n * of this software and associated documentation files (the \"Software\"), to deal\n * in the Software without restriction, including without limitation the rights\n * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell\n * copies of the Software, and to permit persons to whom the Software is\n * furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\n * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN\n * THE SOFTWARE.\n *\n * Originally forked from (with the author's permission):\n *   Fabrice Bellard's javascript vt100 for jslinux:\n *   http://bellard.org/jslinux/\n *   Copyright (c) 2011 Fabrice Bellard\n *   The original design remains. The terminal itself\n *   has been extended to include xterm CSI codes, among\n *   other features.\n */\n\n/*\n *  Default style for xterm.js\n */\n\n.terminal {\n    background-color: #000;\n    color: #fff;\n    font-family: courier-new, courier, monospace;\n    font-feature-settings: \"liga\" 0;\n    position: relative;\n}\n\n.terminal:focus {\n    outline: none;\n}\n\n.terminal .terminal-cursor {\n    background-color: #fff;\n    color: #000;\n}\n\n.terminal:not(:focus) .terminal-cursor {\n    outline: 1px solid #fff;\n    outline-offset: -1px;\n    background-color: transparent;\n}\n\n.terminal:focus .terminal-cursor.blinking {\n    animation: blink-cursor 1.2s infinite step-end;\n}\n\n@keyframes blink-cursor {\n    0% {\n        background-color: #fff;\n        color: #000;\n    }\n    50% {\n        background-color: transparent;\n        color: #FFF;\n    }\n}\n\n/*\n *  Determine default colors for xterm.js\n */\n.terminal .xterm-bold {\n    font-weight: bold;\n}\n\n.terminal .xterm-underline {\n    text-decoration: underline;\n}\n\n.terminal .xterm-blink {\n    text-decoration: blink;\n}\n\n.terminal .xterm-hidden {\n    visibility: hidden;\n}\n\n.terminal .xterm-color-0 {\n    color: #2e3436;\n}\n\n.terminal .xterm-bg-color-0 {\n    background-color: #2e3436;\n}\n\n.terminal .xterm-color-1 {\n    color: #cc0000;\n}\n\n.terminal .xterm-bg-color-1 {\n    background-color: #cc0000;\n}\n\n.terminal .xterm-color-2 {\n    color: #4e9a06;\n}\n\n.terminal .xterm-bg-color-2 {\n    background-color: #4e9a06;\n}\n\n.terminal .xterm-color-3 {\n    color: #c4a000;\n}\n\n.terminal .xterm-bg-color-3 {\n    background-color: #c4a000;\n}\n\n.terminal .xterm-color-4 {\n    color: #3465a4;\n}\n\n.terminal .xterm-bg-color-4 {\n    background-color: #3465a4;\n}\n\n.terminal .xterm-color-5 {\n    color: #75507b;\n}\n\n.terminal .xterm-bg-color-5 {\n    background-color: #75507b;\n}\n\n.terminal .xterm-color-6 {\n    color: #06989a;\n}\n\n.terminal .xterm-bg-color-6 {\n    background-color: #06989a;\n}\n\n.terminal .xterm-color-7 {\n    color: #d3d7cf;\n}\n\n.terminal .xterm-bg-color-7 {\n    background-color: #d3d7cf;\n}\n\n.terminal .xterm-color-8 {\n    color: #555753;\n}\n\n.terminal .xterm-bg-color-8 {\n    background-color: #555753;\n}\n\n.terminal .xterm-color-9 {\n    color: #ef2929;\n}\n\n.terminal .xterm-bg-color-9 {\n    background-color: #ef2929;\n}\n\n.terminal .xterm-color-10 {\n    color: #8ae234;\n}\n\n.terminal .xterm-bg-color-10 {\n    background-color: #8ae234;\n}\n\n.terminal .xterm-color-11 {\n    color: #fce94f;\n}\n\n.terminal .xterm-bg-color-11 {\n    background-color: #fce94f;\n}\n\n.terminal .xterm-color-12 {\n    color: #729fcf;\n}\n\n.terminal .xterm-bg-color-12 {\n    background-color: #729fcf;\n}\n\n.terminal .xterm-color-13 {\n    color: #ad7fa8;\n}\n\n.terminal .xterm-bg-color-13 {\n    background-color: #ad7fa8;\n}\n\n.terminal .xterm-color-14 {\n    color: #34e2e2;\n}\n\n.terminal .xterm-bg-color-14 {\n    background-color: #34e2e2;\n}\n\n.terminal .xterm-color-15 {\n    color: #eeeeec;\n}\n\n.terminal .xterm-bg-color-15 {\n    background-color: #eeeeec;\n}\n\n.terminal .xterm-color-16 {\n    color: #000000;\n}\n\n.terminal .xterm-bg-color-16 {\n    background-color: #000000;\n}\n\n.terminal .xterm-color-17 {\n    color: #00005f;\n}\n\n.terminal .xterm-bg-color-17 {\n    background-color: #00005f;\n}\n\n.terminal .xterm-color-18 {\n    color: #000087;\n}\n\n.terminal .xterm-bg-color-18 {\n    background-color: #000087;\n}\n\n.terminal .xterm-color-19 {\n    color: #0000af;\n}\n\n.terminal .xterm-bg-color-19 {\n    background-color: #0000af;\n}\n\n.terminal .xterm-color-20 {\n    color: #0000d7;\n}\n\n.terminal .xterm-bg-color-20 {\n    background-color: #0000d7;\n}\n\n.terminal .xterm-color-21 {\n    color: #0000ff;\n}\n\n.terminal .xterm-bg-color-21 {\n    background-color: #0000ff;\n}\n\n.terminal .xterm-color-22 {\n    color: #005f00;\n}\n\n.terminal .xterm-bg-color-22 {\n    background-color: #005f00;\n}\n\n.terminal .xterm-color-23 {\n    color: #005f5f;\n}\n\n.terminal .xterm-bg-color-23 {\n    background-color: #005f5f;\n}\n\n.terminal .xterm-color-24 {\n    color: #005f87;\n}\n\n.terminal .xterm-bg-color-24 {\n    background-color: #005f87;\n}\n\n.terminal .xterm-color-25 {\n    color: #005faf;\n}\n\n.terminal .xterm-bg-color-25 {\n    background-color: #005faf;\n}\n\n.terminal .xterm-color-26 {\n    color: #005fd7;\n}\n\n.terminal .xterm-bg-color-26 {\n    background-color: #005fd7;\n}\n\n.terminal .xterm-color-27 {\n    color: #005fff;\n}\n\n.terminal .xterm-bg-color-27 {\n    background-color: #005fff;\n}\n\n.terminal .xterm-color-28 {\n    color: #008700;\n}\n\n.terminal .xterm-bg-color-28 {\n    background-color: #008700;\n}\n\n.terminal .xterm-color-29 {\n    color: #00875f;\n}\n\n.terminal .xterm-bg-color-29 {\n    background-color: #00875f;\n}\n\n.terminal .xterm-color-30 {\n    color: #008787;\n}\n\n.terminal .xterm-bg-color-30 {\n    background-color: #008787;\n}\n\n.terminal .xterm-color-31 {\n    color: #0087af;\n}\n\n.terminal .xterm-bg-color-31 {\n    background-color: #0087af;\n}\n\n.terminal .xterm-color-32 {\n    color: #0087d7;\n}\n\n.terminal .xterm-bg-color-32 {\n    background-color: #0087d7;\n}\n\n.terminal .xterm-color-33 {\n    color: #0087ff;\n}\n\n.terminal .xterm-bg-color-33 {\n    background-color: #0087ff;\n}\n\n.terminal .xterm-color-34 {\n    color: #00af00;\n}\n\n.terminal .xterm-bg-color-34 {\n    background-color: #00af00;\n}\n\n.terminal .xterm-color-35 {\n    color: #00af5f;\n}\n\n.terminal .xterm-bg-color-35 {\n    background-color: #00af5f;\n}\n\n.terminal .xterm-color-36 {\n    color: #00af87;\n}\n\n.terminal .xterm-bg-color-36 {\n    background-color: #00af87;\n}\n\n.terminal .xterm-color-37 {\n    color: #00afaf;\n}\n\n.terminal .xterm-bg-color-37 {\n    background-color: #00afaf;\n}\n\n.terminal .xterm-color-38 {\n    color: #00afd7;\n}\n\n.terminal .xterm-bg-color-38 {\n    background-color: #00afd7;\n}\n\n.terminal .xterm-color-39 {\n    color: #00afff;\n}\n\n.terminal .xterm-bg-color-39 {\n    background-color: #00afff;\n}\n\n.terminal .xterm-color-40 {\n    color: #00d700;\n}\n\n.terminal .xterm-bg-color-40 {\n    background-color: #00d700;\n}\n\n.terminal .xterm-color-41 {\n    color: #00d75f;\n}\n\n.terminal .xterm-bg-color-41 {\n    background-color: #00d75f;\n}\n\n.terminal .xterm-color-42 {\n    color: #00d787;\n}\n\n.terminal .xterm-bg-color-42 {\n    background-color: #00d787;\n}\n\n.terminal .xterm-color-43 {\n    color: #00d7af;\n}\n\n.terminal .xterm-bg-color-43 {\n    background-color: #00d7af;\n}\n\n.terminal .xterm-color-44 {\n    color: #00d7d7;\n}\n\n.terminal .xterm-bg-color-44 {\n    background-color: #00d7d7;\n}\n\n.terminal .xterm-color-45 {\n    color: #00d7ff;\n}\n\n.terminal .xterm-bg-color-45 {\n    background-color: #00d7ff;\n}\n\n.terminal .xterm-color-46 {\n    color: #00ff00;\n}\n\n.terminal .xterm-bg-color-46 {\n    background-color: #00ff00;\n}\n\n.terminal .xterm-color-47 {\n    color: #00ff5f;\n}\n\n.terminal .xterm-bg-color-47 {\n    background-color: #00ff5f;\n}\n\n.terminal .xterm-color-48 {\n    color: #00ff87;\n}\n\n.terminal .xterm-bg-color-48 {\n    background-color: #00ff87;\n}\n\n.terminal .xterm-color-49 {\n    color: #00ffaf;\n}\n\n.terminal .xterm-bg-color-49 {\n    background-color: #00ffaf;\n}\n\n.terminal .xterm-color-50 {\n    color: #00ffd7;\n}\n\n.terminal .xterm-bg-color-50 {\n    background-color: #00ffd7;\n}\n\n.terminal .xterm-color-51 {\n    color: #00ffff;\n}\n\n.terminal .xterm-bg-color-51 {\n    background-color: #00ffff;\n}\n\n.terminal .xterm-color-52 {\n    color: #5f0000;\n}\n\n.terminal .xterm-bg-color-52 {\n    background-color: #5f0000;\n}\n\n.terminal .xterm-color-53 {\n    color: #5f005f;\n}\n\n.terminal .xterm-bg-color-53 {\n    background-color: #5f005f;\n}\n\n.terminal .xterm-color-54 {\n    color: #5f0087;\n}\n\n.terminal .xterm-bg-color-54 {\n    background-color: #5f0087;\n}\n\n.terminal .xterm-color-55 {\n    color: #5f00af;\n}\n\n.terminal .xterm-bg-color-55 {\n    background-color: #5f00af;\n}\n\n.terminal .xterm-color-56 {\n    color: #5f00d7;\n}\n\n.terminal .xterm-bg-color-56 {\n    background-color: #5f00d7;\n}\n\n.terminal .xterm-color-57 {\n    color: #5f00ff;\n}\n\n.terminal .xterm-bg-color-57 {\n    background-color: #5f00ff;\n}\n\n.terminal .xterm-color-58 {\n    color: #5f5f00;\n}\n\n.terminal .xterm-bg-color-58 {\n    background-color: #5f5f00;\n}\n\n.terminal .xterm-color-59 {\n    color: #5f5f5f;\n}\n\n.terminal .xterm-bg-color-59 {\n    background-color: #5f5f5f;\n}\n\n.terminal .xterm-color-60 {\n    color: #5f5f87;\n}\n\n.terminal .xterm-bg-color-60 {\n    background-color: #5f5f87;\n}\n\n.terminal .xterm-color-61 {\n    color: #5f5faf;\n}\n\n.terminal .xterm-bg-color-61 {\n    background-color: #5f5faf;\n}\n\n.terminal .xterm-color-62 {\n    color: #5f5fd7;\n}\n\n.terminal .xterm-bg-color-62 {\n    background-color: #5f5fd7;\n}\n\n.terminal .xterm-color-63 {\n    color: #5f5fff;\n}\n\n.terminal .xterm-bg-color-63 {\n    background-color: #5f5fff;\n}\n\n.terminal .xterm-color-64 {\n    color: #5f8700;\n}\n\n.terminal .xterm-bg-color-64 {\n    background-color: #5f8700;\n}\n\n.terminal .xterm-color-65 {\n    color: #5f875f;\n}\n\n.terminal .xterm-bg-color-65 {\n    background-color: #5f875f;\n}\n\n.terminal .xterm-color-66 {\n    color: #5f8787;\n}\n\n.terminal .xterm-bg-color-66 {\n    background-color: #5f8787;\n}\n\n.terminal .xterm-color-67 {\n    color: #5f87af;\n}\n\n.terminal .xterm-bg-color-67 {\n    background-color: #5f87af;\n}\n\n.terminal .xterm-color-68 {\n    color: #5f87d7;\n}\n\n.terminal .xterm-bg-color-68 {\n    background-color: #5f87d7;\n}\n\n.terminal .xterm-color-69 {\n    color: #5f87ff;\n}\n\n.terminal .xterm-bg-color-69 {\n    background-color: #5f87ff;\n}\n\n.terminal .xterm-color-70 {\n    color: #5faf00;\n}\n\n.terminal .xterm-bg-color-70 {\n    background-color: #5faf00;\n}\n\n.terminal .xterm-color-71 {\n    color: #5faf5f;\n}\n\n.terminal .xterm-bg-color-71 {\n    background-color: #5faf5f;\n}\n\n.terminal .xterm-color-72 {\n    color: #5faf87;\n}\n\n.terminal .xterm-bg-color-72 {\n    background-color: #5faf87;\n}\n\n.terminal .xterm-color-73 {\n    color: #5fafaf;\n}\n\n.terminal .xterm-bg-color-73 {\n    background-color: #5fafaf;\n}\n\n.terminal .xterm-color-74 {\n    color: #5fafd7;\n}\n\n.terminal .xterm-bg-color-74 {\n    background-color: #5fafd7;\n}\n\n.terminal .xterm-color-75 {\n    color: #5fafff;\n}\n\n.terminal .xterm-bg-color-75 {\n    background-color: #5fafff;\n}\n\n.terminal .xterm-color-76 {\n    color: #5fd700;\n}\n\n.terminal .xterm-bg-color-76 {\n    background-color: #5fd700;\n}\n\n.terminal .xterm-color-77 {\n    color: #5fd75f;\n}\n\n.terminal .xterm-bg-color-77 {\n    background-color: #5fd75f;\n}\n\n.terminal .xterm-color-78 {\n    color: #5fd787;\n}\n\n.terminal .xterm-bg-color-78 {\n    background-color: #5fd787;\n}\n\n.terminal .xterm-color-79 {\n    color: #5fd7af;\n}\n\n.terminal .xterm-bg-color-79 {\n    background-color: #5fd7af;\n}\n\n.terminal .xterm-color-80 {\n    color: #5fd7d7;\n}\n\n.terminal .xterm-bg-color-80 {\n    background-color: #5fd7d7;\n}\n\n.terminal .xterm-color-81 {\n    color: #5fd7ff;\n}\n\n.terminal .xterm-bg-color-81 {\n    background-color: #5fd7ff;\n}\n\n.terminal .xterm-color-82 {\n    color: #5fff00;\n}\n\n.terminal .xterm-bg-color-82 {\n    background-color: #5fff00;\n}\n\n.terminal .xterm-color-83 {\n    color: #5fff5f;\n}\n\n.terminal .xterm-bg-color-83 {\n    background-color: #5fff5f;\n}\n\n.terminal .xterm-color-84 {\n    color: #5fff87;\n}\n\n.terminal .xterm-bg-color-84 {\n    background-color: #5fff87;\n}\n\n.terminal .xterm-color-85 {\n    color: #5fffaf;\n}\n\n.terminal .xterm-bg-color-85 {\n    background-color: #5fffaf;\n}\n\n.terminal .xterm-color-86 {\n    color: #5fffd7;\n}\n\n.terminal .xterm-bg-color-86 {\n    background-color: #5fffd7;\n}\n\n.terminal .xterm-color-87 {\n    color: #5fffff;\n}\n\n.terminal .xterm-bg-color-87 {\n    background-color: #5fffff;\n}\n\n.terminal .xterm-color-88 {\n    color: #870000;\n}\n\n.terminal .xterm-bg-color-88 {\n    background-color: #870000;\n}\n\n.terminal .xterm-color-89 {\n    color: #87005f;\n}\n\n.terminal .xterm-bg-color-89 {\n    background-color: #87005f;\n}\n\n.terminal .xterm-color-90 {\n    color: #870087;\n}\n\n.terminal .xterm-bg-color-90 {\n    background-color: #870087;\n}\n\n.terminal .xterm-color-91 {\n    color: #8700af;\n}\n\n.terminal .xterm-bg-color-91 {\n    background-color: #8700af;\n}\n\n.terminal .xterm-color-92 {\n    color: #8700d7;\n}\n\n.terminal .xterm-bg-color-92 {\n    background-color: #8700d7;\n}\n\n.terminal .xterm-color-93 {\n    color: #8700ff;\n}\n\n.terminal .xterm-bg-color-93 {\n    background-color: #8700ff;\n}\n\n.terminal .xterm-color-94 {\n    color: #875f00;\n}\n\n.terminal .xterm-bg-color-94 {\n    background-color: #875f00;\n}\n\n.terminal .xterm-color-95 {\n    color: #875f5f;\n}\n\n.terminal .xterm-bg-color-95 {\n    background-color: #875f5f;\n}\n\n.terminal .xterm-color-96 {\n    color: #875f87;\n}\n\n.terminal .xterm-bg-color-96 {\n    background-color: #875f87;\n}\n\n.terminal .xterm-color-97 {\n    color: #875faf;\n}\n\n.terminal .xterm-bg-color-97 {\n    background-color: #875faf;\n}\n\n.terminal .xterm-color-98 {\n    color: #875fd7;\n}\n\n.terminal .xterm-bg-color-98 {\n    background-color: #875fd7;\n}\n\n.terminal .xterm-color-99 {\n    color: #875fff;\n}\n\n.terminal .xterm-bg-color-99 {\n    background-color: #875fff;\n}\n\n.terminal .xterm-color-100 {\n    color: #878700;\n}\n\n.terminal .xterm-bg-color-100 {\n    background-color: #878700;\n}\n\n.terminal .xterm-color-101 {\n    color: #87875f;\n}\n\n.terminal .xterm-bg-color-101 {\n    background-color: #87875f;\n}\n\n.terminal .xterm-color-102 {\n    color: #878787;\n}\n\n.terminal .xterm-bg-color-102 {\n    background-color: #878787;\n}\n\n.terminal .xterm-color-103 {\n    color: #8787af;\n}\n\n.terminal .xterm-bg-color-103 {\n    background-color: #8787af;\n}\n\n.terminal .xterm-color-104 {\n    color: #8787d7;\n}\n\n.terminal .xterm-bg-color-104 {\n    background-color: #8787d7;\n}\n\n.terminal .xterm-color-105 {\n    color: #8787ff;\n}\n\n.terminal .xterm-bg-color-105 {\n    background-color: #8787ff;\n}\n\n.terminal .xterm-color-106 {\n    color: #87af00;\n}\n\n.terminal .xterm-bg-color-106 {\n    background-color: #87af00;\n}\n\n.terminal .xterm-color-107 {\n    color: #87af5f;\n}\n\n.terminal .xterm-bg-color-107 {\n    background-color: #87af5f;\n}\n\n.terminal .xterm-color-108 {\n    color: #87af87;\n}\n\n.terminal .xterm-bg-color-108 {\n    background-color: #87af87;\n}\n\n.terminal .xterm-color-109 {\n    color: #87afaf;\n}\n\n.terminal .xterm-bg-color-109 {\n    background-color: #87afaf;\n}\n\n.terminal .xterm-color-110 {\n    color: #87afd7;\n}\n\n.terminal .xterm-bg-color-110 {\n    background-color: #87afd7;\n}\n\n.terminal .xterm-color-111 {\n    color: #87afff;\n}\n\n.terminal .xterm-bg-color-111 {\n    background-color: #87afff;\n}\n\n.terminal .xterm-color-112 {\n    color: #87d700;\n}\n\n.terminal .xterm-bg-color-112 {\n    background-color: #87d700;\n}\n\n.terminal .xterm-color-113 {\n    color: #87d75f;\n}\n\n.terminal .xterm-bg-color-113 {\n    background-color: #87d75f;\n}\n\n.terminal .xterm-color-114 {\n    color: #87d787;\n}\n\n.terminal .xterm-bg-color-114 {\n    background-color: #87d787;\n}\n\n.terminal .xterm-color-115 {\n    color: #87d7af;\n}\n\n.terminal .xterm-bg-color-115 {\n    background-color: #87d7af;\n}\n\n.terminal .xterm-color-116 {\n    color: #87d7d7;\n}\n\n.terminal .xterm-bg-color-116 {\n    background-color: #87d7d7;\n}\n\n.terminal .xterm-color-117 {\n    color: #87d7ff;\n}\n\n.terminal .xterm-bg-color-117 {\n    background-color: #87d7ff;\n}\n\n.terminal .xterm-color-118 {\n    color: #87ff00;\n}\n\n.terminal .xterm-bg-color-118 {\n    background-color: #87ff00;\n}\n\n.terminal .xterm-color-119 {\n    color: #87ff5f;\n}\n\n.terminal .xterm-bg-color-119 {\n    background-color: #87ff5f;\n}\n\n.terminal .xterm-color-120 {\n    color: #87ff87;\n}\n\n.terminal .xterm-bg-color-120 {\n    background-color: #87ff87;\n}\n\n.terminal .xterm-color-121 {\n    color: #87ffaf;\n}\n\n.terminal .xterm-bg-color-121 {\n    background-color: #87ffaf;\n}\n\n.terminal .xterm-color-122 {\n    color: #87ffd7;\n}\n\n.terminal .xterm-bg-color-122 {\n    background-color: #87ffd7;\n}\n\n.terminal .xterm-color-123 {\n    color: #87ffff;\n}\n\n.terminal .xterm-bg-color-123 {\n    background-color: #87ffff;\n}\n\n.terminal .xterm-color-124 {\n    color: #af0000;\n}\n\n.terminal .xterm-bg-color-124 {\n    background-color: #af0000;\n}\n\n.terminal .xterm-color-125 {\n    color: #af005f;\n}\n\n.terminal .xterm-bg-color-125 {\n    background-color: #af005f;\n}\n\n.terminal .xterm-color-126 {\n    color: #af0087;\n}\n\n.terminal .xterm-bg-color-126 {\n    background-color: #af0087;\n}\n\n.terminal .xterm-color-127 {\n    color: #af00af;\n}\n\n.terminal .xterm-bg-color-127 {\n    background-color: #af00af;\n}\n\n.terminal .xterm-color-128 {\n    color: #af00d7;\n}\n\n.terminal .xterm-bg-color-128 {\n    background-color: #af00d7;\n}\n\n.terminal .xterm-color-129 {\n    color: #af00ff;\n}\n\n.terminal .xterm-bg-color-129 {\n    background-color: #af00ff;\n}\n\n.terminal .xterm-color-130 {\n    color: #af5f00;\n}\n\n.terminal .xterm-bg-color-130 {\n    background-color: #af5f00;\n}\n\n.terminal .xterm-color-131 {\n    color: #af5f5f;\n}\n\n.terminal .xterm-bg-color-131 {\n    background-color: #af5f5f;\n}\n\n.terminal .xterm-color-132 {\n    color: #af5f87;\n}\n\n.terminal .xterm-bg-color-132 {\n    background-color: #af5f87;\n}\n\n.terminal .xterm-color-133 {\n    color: #af5faf;\n}\n\n.terminal .xterm-bg-color-133 {\n    background-color: #af5faf;\n}\n\n.terminal .xterm-color-134 {\n    color: #af5fd7;\n}\n\n.terminal .xterm-bg-color-134 {\n    background-color: #af5fd7;\n}\n\n.terminal .xterm-color-135 {\n    color: #af5fff;\n}\n\n.terminal .xterm-bg-color-135 {\n    background-color: #af5fff;\n}\n\n.terminal .xterm-color-136 {\n    color: #af8700;\n}\n\n.terminal .xterm-bg-color-136 {\n    background-color: #af8700;\n}\n\n.terminal .xterm-color-137 {\n    color: #af875f;\n}\n\n.terminal .xterm-bg-color-137 {\n    background-color: #af875f;\n}\n\n.terminal .xterm-color-138 {\n    color: #af8787;\n}\n\n.terminal .xterm-bg-color-138 {\n    background-color: #af8787;\n}\n\n.terminal .xterm-color-139 {\n    color: #af87af;\n}\n\n.terminal .xterm-bg-color-139 {\n    background-color: #af87af;\n}\n\n.terminal .xterm-color-140 {\n    color: #af87d7;\n}\n\n.terminal .xterm-bg-color-140 {\n    background-color: #af87d7;\n}\n\n.terminal .xterm-color-141 {\n    color: #af87ff;\n}\n\n.terminal .xterm-bg-color-141 {\n    background-color: #af87ff;\n}\n\n.terminal .xterm-color-142 {\n    color: #afaf00;\n}\n\n.terminal .xterm-bg-color-142 {\n    background-color: #afaf00;\n}\n\n.terminal .xterm-color-143 {\n    color: #afaf5f;\n}\n\n.terminal .xterm-bg-color-143 {\n    background-color: #afaf5f;\n}\n\n.terminal .xterm-color-144 {\n    color: #afaf87;\n}\n\n.terminal .xterm-bg-color-144 {\n    background-color: #afaf87;\n}\n\n.terminal .xterm-color-145 {\n    color: #afafaf;\n}\n\n.terminal .xterm-bg-color-145 {\n    background-color: #afafaf;\n}\n\n.terminal .xterm-color-146 {\n    color: #afafd7;\n}\n\n.terminal .xterm-bg-color-146 {\n    background-color: #afafd7;\n}\n\n.terminal .xterm-color-147 {\n    color: #afafff;\n}\n\n.terminal .xterm-bg-color-147 {\n    background-color: #afafff;\n}\n\n.terminal .xterm-color-148 {\n    color: #afd700;\n}\n\n.terminal .xterm-bg-color-148 {\n    background-color: #afd700;\n}\n\n.terminal .xterm-color-149 {\n    color: #afd75f;\n}\n\n.terminal .xterm-bg-color-149 {\n    background-color: #afd75f;\n}\n\n.terminal .xterm-color-150 {\n    color: #afd787;\n}\n\n.terminal .xterm-bg-color-150 {\n    background-color: #afd787;\n}\n\n.terminal .xterm-color-151 {\n    color: #afd7af;\n}\n\n.terminal .xterm-bg-color-151 {\n    background-color: #afd7af;\n}\n\n.terminal .xterm-color-152 {\n    color: #afd7d7;\n}\n\n.terminal .xterm-bg-color-152 {\n    background-color: #afd7d7;\n}\n\n.terminal .xterm-color-153 {\n    color: #afd7ff;\n}\n\n.terminal .xterm-bg-color-153 {\n    background-color: #afd7ff;\n}\n\n.terminal .xterm-color-154 {\n    color: #afff00;\n}\n\n.terminal .xterm-bg-color-154 {\n    background-color: #afff00;\n}\n\n.terminal .xterm-color-155 {\n    color: #afff5f;\n}\n\n.terminal .xterm-bg-color-155 {\n    background-color: #afff5f;\n}\n\n.terminal .xterm-color-156 {\n    color: #afff87;\n}\n\n.terminal .xterm-bg-color-156 {\n    background-color: #afff87;\n}\n\n.terminal .xterm-color-157 {\n    color: #afffaf;\n}\n\n.terminal .xterm-bg-color-157 {\n    background-color: #afffaf;\n}\n\n.terminal .xterm-color-158 {\n    color: #afffd7;\n}\n\n.terminal .xterm-bg-color-158 {\n    background-color: #afffd7;\n}\n\n.terminal .xterm-color-159 {\n    color: #afffff;\n}\n\n.terminal .xterm-bg-color-159 {\n    background-color: #afffff;\n}\n\n.terminal .xterm-color-160 {\n    color: #d70000;\n}\n\n.terminal .xterm-bg-color-160 {\n    background-color: #d70000;\n}\n\n.terminal .xterm-color-161 {\n    color: #d7005f;\n}\n\n.terminal .xterm-bg-color-161 {\n    background-color: #d7005f;\n}\n\n.terminal .xterm-color-162 {\n    color: #d70087;\n}\n\n.terminal .xterm-bg-color-162 {\n    background-color: #d70087;\n}\n\n.terminal .xterm-color-163 {\n    color: #d700af;\n}\n\n.terminal .xterm-bg-color-163 {\n    background-color: #d700af;\n}\n\n.terminal .xterm-color-164 {\n    color: #d700d7;\n}\n\n.terminal .xterm-bg-color-164 {\n    background-color: #d700d7;\n}\n\n.terminal .xterm-color-165 {\n    color: #d700ff;\n}\n\n.terminal .xterm-bg-color-165 {\n    background-color: #d700ff;\n}\n\n.terminal .xterm-color-166 {\n    color: #d75f00;\n}\n\n.terminal .xterm-bg-color-166 {\n    background-color: #d75f00;\n}\n\n.terminal .xterm-color-167 {\n    color: #d75f5f;\n}\n\n.terminal .xterm-bg-color-167 {\n    background-color: #d75f5f;\n}\n\n.terminal .xterm-color-168 {\n    color: #d75f87;\n}\n\n.terminal .xterm-bg-color-168 {\n    background-color: #d75f87;\n}\n\n.terminal .xterm-color-169 {\n    color: #d75faf;\n}\n\n.terminal .xterm-bg-color-169 {\n    background-color: #d75faf;\n}\n\n.terminal .xterm-color-170 {\n    color: #d75fd7;\n}\n\n.terminal .xterm-bg-color-170 {\n    background-color: #d75fd7;\n}\n\n.terminal .xterm-color-171 {\n    color: #d75fff;\n}\n\n.terminal .xterm-bg-color-171 {\n    background-color: #d75fff;\n}\n\n.terminal .xterm-color-172 {\n    color: #d78700;\n}\n\n.terminal .xterm-bg-color-172 {\n    background-color: #d78700;\n}\n\n.terminal .xterm-color-173 {\n    color: #d7875f;\n}\n\n.terminal .xterm-bg-color-173 {\n    background-color: #d7875f;\n}\n\n.terminal .xterm-color-174 {\n    color: #d78787;\n}\n\n.terminal .xterm-bg-color-174 {\n    background-color: #d78787;\n}\n\n.terminal .xterm-color-175 {\n    color: #d787af;\n}\n\n.terminal .xterm-bg-color-175 {\n    background-color: #d787af;\n}\n\n.terminal .xterm-color-176 {\n    color: #d787d7;\n}\n\n.terminal .xterm-bg-color-176 {\n    background-color: #d787d7;\n}\n\n.terminal .xterm-color-177 {\n    color: #d787ff;\n}\n\n.terminal .xterm-bg-color-177 {\n    background-color: #d787ff;\n}\n\n.terminal .xterm-color-178 {\n    color: #d7af00;\n}\n\n.terminal .xterm-bg-color-178 {\n    background-color: #d7af00;\n}\n\n.terminal .xterm-color-179 {\n    color: #d7af5f;\n}\n\n.terminal .xterm-bg-color-179 {\n    background-color: #d7af5f;\n}\n\n.terminal .xterm-color-180 {\n    color: #d7af87;\n}\n\n.terminal .xterm-bg-color-180 {\n    background-color: #d7af87;\n}\n\n.terminal .xterm-color-181 {\n    color: #d7afaf;\n}\n\n.terminal .xterm-bg-color-181 {\n    background-color: #d7afaf;\n}\n\n.terminal .xterm-color-182 {\n    color: #d7afd7;\n}\n\n.terminal .xterm-bg-color-182 {\n    background-color: #d7afd7;\n}\n\n.terminal .xterm-color-183 {\n    color: #d7afff;\n}\n\n.terminal .xterm-bg-color-183 {\n    background-color: #d7afff;\n}\n\n.terminal .xterm-color-184 {\n    color: #d7d700;\n}\n\n.terminal .xterm-bg-color-184 {\n    background-color: #d7d700;\n}\n\n.terminal .xterm-color-185 {\n    color: #d7d75f;\n}\n\n.terminal .xterm-bg-color-185 {\n    background-color: #d7d75f;\n}\n\n.terminal .xterm-color-186 {\n    color: #d7d787;\n}\n\n.terminal .xterm-bg-color-186 {\n    background-color: #d7d787;\n}\n\n.terminal .xterm-color-187 {\n    color: #d7d7af;\n}\n\n.terminal .xterm-bg-color-187 {\n    background-color: #d7d7af;\n}\n\n.terminal .xterm-color-188 {\n    color: #d7d7d7;\n}\n\n.terminal .xterm-bg-color-188 {\n    background-color: #d7d7d7;\n}\n\n.terminal .xterm-color-189 {\n    color: #d7d7ff;\n}\n\n.terminal .xterm-bg-color-189 {\n    background-color: #d7d7ff;\n}\n\n.terminal .xterm-color-190 {\n    color: #d7ff00;\n}\n\n.terminal .xterm-bg-color-190 {\n    background-color: #d7ff00;\n}\n\n.terminal .xterm-color-191 {\n    color: #d7ff5f;\n}\n\n.terminal .xterm-bg-color-191 {\n    background-color: #d7ff5f;\n}\n\n.terminal .xterm-color-192 {\n    color: #d7ff87;\n}\n\n.terminal .xterm-bg-color-192 {\n    background-color: #d7ff87;\n}\n\n.terminal .xterm-color-193 {\n    color: #d7ffaf;\n}\n\n.terminal .xterm-bg-color-193 {\n    background-color: #d7ffaf;\n}\n\n.terminal .xterm-color-194 {\n    color: #d7ffd7;\n}\n\n.terminal .xterm-bg-color-194 {\n    background-color: #d7ffd7;\n}\n\n.terminal .xterm-color-195 {\n    color: #d7ffff;\n}\n\n.terminal .xterm-bg-color-195 {\n    background-color: #d7ffff;\n}\n\n.terminal .xterm-color-196 {\n    color: #ff0000;\n}\n\n.terminal .xterm-bg-color-196 {\n    background-color: #ff0000;\n}\n\n.terminal .xterm-color-197 {\n    color: #ff005f;\n}\n\n.terminal .xterm-bg-color-197 {\n    background-color: #ff005f;\n}\n\n.terminal .xterm-color-198 {\n    color: #ff0087;\n}\n\n.terminal .xterm-bg-color-198 {\n    background-color: #ff0087;\n}\n\n.terminal .xterm-color-199 {\n    color: #ff00af;\n}\n\n.terminal .xterm-bg-color-199 {\n    background-color: #ff00af;\n}\n\n.terminal .xterm-color-200 {\n    color: #ff00d7;\n}\n\n.terminal .xterm-bg-color-200 {\n    background-color: #ff00d7;\n}\n\n.terminal .xterm-color-201 {\n    color: #ff00ff;\n}\n\n.terminal .xterm-bg-color-201 {\n    background-color: #ff00ff;\n}\n\n.terminal .xterm-color-202 {\n    color: #ff5f00;\n}\n\n.terminal .xterm-bg-color-202 {\n    background-color: #ff5f00;\n}\n\n.terminal .xterm-color-203 {\n    color: #ff5f5f;\n}\n\n.terminal .xterm-bg-color-203 {\n    background-color: #ff5f5f;\n}\n\n.terminal .xterm-color-204 {\n    color: #ff5f87;\n}\n\n.terminal .xterm-bg-color-204 {\n    background-color: #ff5f87;\n}\n\n.terminal .xterm-color-205 {\n    color: #ff5faf;\n}\n\n.terminal .xterm-bg-color-205 {\n    background-color: #ff5faf;\n}\n\n.terminal .xterm-color-206 {\n    color: #ff5fd7;\n}\n\n.terminal .xterm-bg-color-206 {\n    background-color: #ff5fd7;\n}\n\n.terminal .xterm-color-207 {\n    color: #ff5fff;\n}\n\n.terminal .xterm-bg-color-207 {\n    background-color: #ff5fff;\n}\n\n.terminal .xterm-color-208 {\n    color: #ff8700;\n}\n\n.terminal .xterm-bg-color-208 {\n    background-color: #ff8700;\n}\n\n.terminal .xterm-color-209 {\n    color: #ff875f;\n}\n\n.terminal .xterm-bg-color-209 {\n    background-color: #ff875f;\n}\n\n.terminal .xterm-color-210 {\n    color: #ff8787;\n}\n\n.terminal .xterm-bg-color-210 {\n    background-color: #ff8787;\n}\n\n.terminal .xterm-color-211 {\n    color: #ff87af;\n}\n\n.terminal .xterm-bg-color-211 {\n    background-color: #ff87af;\n}\n\n.terminal .xterm-color-212 {\n    color: #ff87d7;\n}\n\n.terminal .xterm-bg-color-212 {\n    background-color: #ff87d7;\n}\n\n.terminal .xterm-color-213 {\n    color: #ff87ff;\n}\n\n.terminal .xterm-bg-color-213 {\n    background-color: #ff87ff;\n}\n\n.terminal .xterm-color-214 {\n    color: #ffaf00;\n}\n\n.terminal .xterm-bg-color-214 {\n    background-color: #ffaf00;\n}\n\n.terminal .xterm-color-215 {\n    color: #ffaf5f;\n}\n\n.terminal .xterm-bg-color-215 {\n    background-color: #ffaf5f;\n}\n\n.terminal .xterm-color-216 {\n    color: #ffaf87;\n}\n\n.terminal .xterm-bg-color-216 {\n    background-color: #ffaf87;\n}\n\n.terminal .xterm-color-217 {\n    color: #ffafaf;\n}\n\n.terminal .xterm-bg-color-217 {\n    background-color: #ffafaf;\n}\n\n.terminal .xterm-color-218 {\n    color: #ffafd7;\n}\n\n.terminal .xterm-bg-color-218 {\n    background-color: #ffafd7;\n}\n\n.terminal .xterm-color-219 {\n    color: #ffafff;\n}\n\n.terminal .xterm-bg-color-219 {\n    background-color: #ffafff;\n}\n\n.terminal .xterm-color-220 {\n    color: #ffd700;\n}\n\n.terminal .xterm-bg-color-220 {\n    background-color: #ffd700;\n}\n\n.terminal .xterm-color-221 {\n    color: #ffd75f;\n}\n\n.terminal .xterm-bg-color-221 {\n    background-color: #ffd75f;\n}\n\n.terminal .xterm-color-222 {\n    color: #ffd787;\n}\n\n.terminal .xterm-bg-color-222 {\n    background-color: #ffd787;\n}\n\n.terminal .xterm-color-223 {\n    color: #ffd7af;\n}\n\n.terminal .xterm-bg-color-223 {\n    background-color: #ffd7af;\n}\n\n.terminal .xterm-color-224 {\n    color: #ffd7d7;\n}\n\n.terminal .xterm-bg-color-224 {\n    background-color: #ffd7d7;\n}\n\n.terminal .xterm-color-225 {\n    color: #ffd7ff;\n}\n\n.terminal .xterm-bg-color-225 {\n    background-color: #ffd7ff;\n}\n\n.terminal .xterm-color-226 {\n    color: #ffff00;\n}\n\n.terminal .xterm-bg-color-226 {\n    background-color: #ffff00;\n}\n\n.terminal .xterm-color-227 {\n    color: #ffff5f;\n}\n\n.terminal .xterm-bg-color-227 {\n    background-color: #ffff5f;\n}\n\n.terminal .xterm-color-228 {\n    color: #ffff87;\n}\n\n.terminal .xterm-bg-color-228 {\n    background-color: #ffff87;\n}\n\n.terminal .xterm-color-229 {\n    color: #ffffaf;\n}\n\n.terminal .xterm-bg-color-229 {\n    background-color: #ffffaf;\n}\n\n.terminal .xterm-color-230 {\n    color: #ffffd7;\n}\n\n.terminal .xterm-bg-color-230 {\n    background-color: #ffffd7;\n}\n\n.terminal .xterm-color-231 {\n    color: #ffffff;\n}\n\n.terminal .xterm-bg-color-231 {\n    background-color: #ffffff;\n}\n\n.terminal .xterm-color-232 {\n    color: #080808;\n}\n\n.terminal .xterm-bg-color-232 {\n    background-color: #080808;\n}\n\n.terminal .xterm-color-233 {\n    color: #121212;\n}\n\n.terminal .xterm-bg-color-233 {\n    background-color: #121212;\n}\n\n.terminal .xterm-color-234 {\n    color: #1c1c1c;\n}\n\n.terminal .xterm-bg-color-234 {\n    background-color: #1c1c1c;\n}\n\n.terminal .xterm-color-235 {\n    color: #262626;\n}\n\n.terminal .xterm-bg-color-235 {\n    background-color: #262626;\n}\n\n.terminal .xterm-color-236 {\n    color: #303030;\n}\n\n.terminal .xterm-bg-color-236 {\n    background-color: #303030;\n}\n\n.terminal .xterm-color-237 {\n    color: #3a3a3a;\n}\n\n.terminal .xterm-bg-color-237 {\n    background-color: #3a3a3a;\n}\n\n.terminal .xterm-color-238 {\n    color: #444444;\n}\n\n.terminal .xterm-bg-color-238 {\n    background-color: #444444;\n}\n\n.terminal .xterm-color-239 {\n    color: #4e4e4e;\n}\n\n.terminal .xterm-bg-color-239 {\n    background-color: #4e4e4e;\n}\n\n.terminal .xterm-color-240 {\n    color: #585858;\n}\n\n.terminal .xterm-bg-color-240 {\n    background-color: #585858;\n}\n\n.terminal .xterm-color-241 {\n    color: #626262;\n}\n\n.terminal .xterm-bg-color-241 {\n    background-color: #626262;\n}\n\n.terminal .xterm-color-242 {\n    color: #6c6c6c;\n}\n\n.terminal .xterm-bg-color-242 {\n    background-color: #6c6c6c;\n}\n\n.terminal .xterm-color-243 {\n    color: #767676;\n}\n\n.terminal .xterm-bg-color-243 {\n    background-color: #767676;\n}\n\n.terminal .xterm-color-244 {\n    color: #808080;\n}\n\n.terminal .xterm-bg-color-244 {\n    background-color: #808080;\n}\n\n.terminal .xterm-color-245 {\n    color: #8a8a8a;\n}\n\n.terminal .xterm-bg-color-245 {\n    background-color: #8a8a8a;\n}\n\n.terminal .xterm-color-246 {\n    color: #949494;\n}\n\n.terminal .xterm-bg-color-246 {\n    background-color: #949494;\n}\n\n.terminal .xterm-color-247 {\n    color: #9e9e9e;\n}\n\n.terminal .xterm-bg-color-247 {\n    background-color: #9e9e9e;\n}\n\n.terminal .xterm-color-248 {\n    color: #a8a8a8;\n}\n\n.terminal .xterm-bg-color-248 {\n    background-color: #a8a8a8;\n}\n\n.terminal .xterm-color-249 {\n    color: #b2b2b2;\n}\n\n.terminal .xterm-bg-color-249 {\n    background-color: #b2b2b2;\n}\n\n.terminal .xterm-color-250 {\n    color: #bcbcbc;\n}\n\n.terminal .xterm-bg-color-250 {\n    background-color: #bcbcbc;\n}\n\n.terminal .xterm-color-251 {\n    color: #c6c6c6;\n}\n\n.terminal .xterm-bg-color-251 {\n    background-color: #c6c6c6;\n}\n\n.terminal .xterm-color-252 {\n    color: #d0d0d0;\n}\n\n.terminal .xterm-bg-color-252 {\n    background-color: #d0d0d0;\n}\n\n.terminal .xterm-color-253 {\n    color: #dadada;\n}\n\n.terminal .xterm-bg-color-253 {\n    background-color: #dadada;\n}\n\n.terminal .xterm-color-254 {\n    color: #e4e4e4;\n}\n\n.terminal .xterm-bg-color-254 {\n    background-color: #e4e4e4;\n}\n\n.terminal .xterm-color-255 {\n    color: #eeeeee;\n}\n\n.terminal .xterm-bg-color-255 {\n    background-color: #eeeeee;\n}\n\n/**\n * All terminal rows should have explicitly declared height,\n * in order to allow child elements to adjust.\n */\n.terminal .xterm-rows > div {\n    line-height: normal;\n}\n", ""]);
	
	// exports


/***/ },
/* 94 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.jp-RunningSessions {\n  display: flex;\n  flex-direction: column;\n}\n\n\n.jp-RunningSessions-header {\n  flex: 0 0 auto;\n  display: flex;\n  flex-direction: row;\n}\n\n\n.jp-RunningSessions-headerTitle {\n  flex: 1 1 auto;\n}\n\n\n.jp-RunningSessions-headerRefresh {\n  flex: 0 0 auto;\n}\n\n\n.jp-RunningSessions-section {\n  display: flex;\n  flex: 0 1 auto;\n  flex-direction: column;\n}\n\n\n.jp-RunningSessions-sectionHeader {\n  flex: 0 0 auto;\n}\n\n\n.jp-RunningSessions-sectionContainer {\n  flex: 1 1 auto;\n  margin: 0;\n  padding: 0;\n  overflow: auto;\n}\n\n\n.jp-RunningSessions-sectionList {\n  margin: 0;\n  padding: 0;\n  list-style-type: none;\n}\n\n\n.jp-RunningSessions-item {\n  display: flex;\n  flex-direction: row;\n}\n\n\n.jp-RunningSessions-itemIcon {\n  flex: 0 0 auto;\n}\n\n\n.jp-RunningSessions-itemLabel {\n  flex: 1 1 auto;\n}\n\n\n.jp-RunningSessions-itemKernelName {\n  flex: 0 0 auto;\n}\n\n\n.jp-RunningSessions-itemShutdown {\n  flex: 0 0 auto;\n}\n", ""]);
	
	// exports


/***/ },
/* 95 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.jp-RunningSessions {\n  min-width: 300px;\n  color: #757575;\n  background: #FAFAFA;\n  font-size: 13px;\n}\n\n\n.jp-RunningSessions-header {\n  border-bottom: 1px solid #E0E0E0;\n}\n\n\n.jp-RunningSessions-headerTitle {\n  padding: 6px;\n  font-size: 12px;\n  vertical-align: middle;\n}\n\n\n.jp-RunningSessions-headerRefresh {\n  flex: 1 1 auto;\n  max-width: 100px;\n  padding: 4px 6px;\n  background: #FAFAFA;\n  color: #757575;\n  border: none;\n  font-size: 14px;\n  outline: 0;\n  padding-top: 8px;\n  padding-bottom: 8px;\n}\n\n\n.jp-RunningSessions-headerRefresh:before {\n  font-family: FontAwesome;\n  content: '\\F021'; /* refresh */\n  font-size: 12px;\n}\n\n\n.jp-RunningSessions-headerRefresh:hover {\n  background: #F5F5F5;\n  border-color: #D0D0D0;\n  z-index: 1; /* raise overlapping border */\n}\n\n\n.jp-RunningSessions-sectionHeader {\n  margin: 4px 0px;\n  padding: 4px 12px;\n  font-size: 11px;\n  font-weight: 600;\n  text-transform: uppercase;\n  border-bottom: 1px solid #E0E0E0;\n  letter-spacing: 2px;\n}\n\n\n.jp-RunningSessions-item {\n  padding: 3px 12px;\n  font-size: 13px;\n  font-weight: 500;\n  color: #757575;\n}\n\n\n.jp-RunningSessions-item:hover {\n    background: #F5F5F5;\n}\n\n\n.jp-RunningSessions-itemIcon {\n  padding: 1px 4px;\n  font-size: 14px;\n  font-family: FontAwesome;\n  color: #5e5e5e;\n  margin-right: 7px;\n  margin-left: 7px;\n  vertical-align: baseline;\n}\n\n.jp-RunningSessions-itemIcon.jp-mod-notebook:before {\n  content: '\\F02D';\n}\n\n\n.jp-RunningSessions-itemIcon.jp-mod-file:before {\n  content: '\\F016';\n}\n\n\n.jp-RunningSessions-itemIcon.jp-mod-terminal:before {\n  content: '\\F120';\n}\n\n.jp-RunningSessions-itemLabel {\n  padding: 1px;\n}\n\n.jp-RunningSessions-itemKernelName {\n  padding: 1px;\n  margin-right: 7px;\n}\n\n\n.jp-RunningSessions-itemShutdown {\n  padding: 1px 4px;\n  color: #ffffff;\n  background: #f0ad4e;\n  border-radius: 1px;\n  cursor: pointer;\n}\n", ""]);
	
	// exports


/***/ },
/* 96 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n#about-jupyterlab {\n    padding: 2em;\n}\n", ""]);
	
	// exports


/***/ },
/* 97 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n", ""]);
	
	// exports


/***/ },
/* 98 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.p-CommandPalette {\n  padding-bottom: 0px;\n  color: #757575;\n  background: #FAFAFA;\n}\n\n\n.p-CommandPalette-search {\n  padding: 8px;\n}\n\n\n.p-CommandPalette-wrapper {\n  padding: 4px 6px;\n  background: white;\n  border: 1px solid #E0E0E0;\n}\n\n\n.p-CommandPalette-input {\n  width: 100%;\n  border: none;\n  outline: none;\n  font-size: 16px;\n}\n\n\n.p-CommandPalette-header {\n  padding: 4px;\n  color: #757575;\n  font-size: 12px;\n  font-weight: 600;\n  background: #E1E1E1;\n  cursor: pointer;\n}\n\n\n.p-CommandPalette-header.p-mod-active {\n  background: #7FDBFF;\n}\n\n\n.p-CommandPalette-header:hover::before {\n  content: '\\2026'; /* ellipsis */\n  float: right;\n  margin-right: 4px;\n}\n\n\n.p-CommandPalette-header > mark {\n  background-color: transparent;\n  font-weight: bold;\n}\n\n\n.p-CommandPalette-item {\n  padding: 4px 8px;\n  color: #757575;\n  font-size: 13px;\n  font-weight: 500;\n}\n\n\n.p-CommandPalette-item.p-mod-disabled {\n  color: rgba(0, 0, 0, 0.25);\n}\n\n\n.p-CommandPalette-item.p-mod-active {\n  background: #7FDBFF;\n}\n\n\n.p-CommandPalette-item:hover:not(.p-mod-active):not(.p-mod-disabled) {\n  background: #E5E5E5;\n}\n\n\n.p-CommandPalette-itemLabel > mark {\n  background-color: transparent;\n  font-weight: bold;\n}\n\n\n.p-CommandPalette-item.p-mod-disabled mark {\n  color: rgba(0, 0, 0, 0.4);\n}\n\n\n.p-CommandPalette-itemCaption {\n  color: #9E9E9E;\n  font-size: 11px;\n  font-weight: 400;\n}\n", ""]);
	
	// exports


/***/ },
/* 99 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-Completion {\n  background: #EEEEEE;\n  border: 1px solid #000000;\n  list-style-type: none;\n  overflow: auto;\n  padding: 0;\n}\n\n\n.jp-Completion-item {\n  margin: 0;\n  min-width: 150px;\n  padding: 0 2px;\n}\n\n\n.jp-Completion-item:nth-child(odd) {\n  background: #FFFFFF;\n}\n\n\n.jp-Completion-item.jp-mod-active {\n  background: #BFBFBF;\n}\n\n\n.jp-Completion-item code {\n  font-size: 14px;\n  line-height: 25px;\n}\n\n\n.jp-Completion-item mark {\n  font-weight: bold;\n  text-decoration: underline;\n  background: inherit;\n  color: inherit;\n}\n", ""]);
	
	// exports


/***/ },
/* 100 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-Console {\n  height: 100%;\n  padding: 0 10px 20px 10px;\n}\n\n\n.jp-Console .jp-Cell {\n  padding-top: 0;\n  padding-bottom: 0;\n}\n\n\n.jp-Console .jp-InputArea-editor.jp-CellEditor {\n  background: transparent;\n  border-color: transparent;\n}\n\n\n.jp-Console-prompt.jp-Cell {\n  border-color: #66BB6A;\n  border-left-width: 1px;\n  background: linear-gradient(to right, #66BB6A -40px, #66BB6A 5px, transparent 5px, transparent 100%);\n}\n\n\n.jp-Console .jp-InputArea-prompt {\n  flex-basis: auto;\n  text-align: left;\n}\n\n\n.jp-Console .jp-Output-prompt {\n  flex-basis: auto;\n  text-align: left;\n}\n\n\n.jp-Console .jp-Output pre {\n  border: none;\n  margin: 1px 0 0 5px;\n  overflow-x: auto;\n  overflow-y: auto;\n  word-break: break-all;\n  word-wrap: break-word;\n  white-space: pre-wrap;\n}\n\n\n.jp-Console .jp-Console-banner .jp-InputArea-prompt {\n  display: none;\n}\n", ""]);
	
	// exports


/***/ },
/* 101 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-Help {\n  min-width: 480px;\n  background: white;\n}\n\n\n.jp-Help > iframe {\n  border: none;\n}\n", ""]);
	
	// exports


/***/ },
/* 102 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-ImageConsole {\n  background-image: url(" + __webpack_require__(103) + ");\n}\n\n\n.jp-ImageJupyterLab {\n  background-image: url(" + __webpack_require__(104) + ");\n}\n\n\n.jp-ImageNotebook {\n  background-image: url(" + __webpack_require__(105) + ");\n}\n\n\n.jp-ImageTerminal {\n  background-image: url(" + __webpack_require__(106) + ");\n}\n\n\n.jp-ImageTextEditor {\n  background-image: url(" + __webpack_require__(107) + ");\n}\n\n\n.jp-QuestionMark {\n  background-image: url(" + __webpack_require__(108) + ");\n}\n\n\n.jp-JupyterIcon {\n  background-image: url(" + __webpack_require__(109) + ");\n  background-size: 16px;\n  margin: 2px;\n  margin-left: 10px;\n  margin-right: 0px;\n  padding-right: 0px;\n}\n\n.jp-Landing-tour {\n  background-image: url(" + __webpack_require__(110) + ");\n}\n\n.jp-Landing-folder {\n  background-image: url(" + __webpack_require__(111) + ");\n}", ""]);
	
	// exports


/***/ },
/* 103 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "a5f896d73c05dd2cec16fd54f7b6d38b.svg";

/***/ },
/* 104 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "899a0c289a928e6bc3bb14ab1f551df0.svg";

/***/ },
/* 105 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "67210cba51efc06308353fa274b6d389.svg";

/***/ },
/* 106 */
/***/ function(module, exports) {

	module.exports = "data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4NCjwhLS0gR2VuZXJhdG9yOiBBZG9iZSBJbGx1c3RyYXRvciAxOS4xLjAsIFNWRyBFeHBvcnQgUGx1Zy1JbiAuIFNWRyBWZXJzaW9uOiA2LjAwIEJ1aWxkIDApICAtLT4NCjxzdmcgdmVyc2lvbj0iMS4xIiBpZD0iTGF5ZXJfMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgeD0iMHB4IiB5PSIwcHgiDQoJIHZpZXdCb3g9IjAgMCAxOTIgMTkyIiBzdHlsZT0iZW5hYmxlLWJhY2tncm91bmQ6bmV3IDAgMCAxOTIgMTkyOyIgeG1sOnNwYWNlPSJwcmVzZXJ2ZSI+DQo8c3R5bGUgdHlwZT0idGV4dC9jc3MiPg0KCS5zdDB7ZmlsbDojQUFBQUFBO3N0cm9rZTojNzY3NDc0O3N0cm9rZS13aWR0aDoyO3N0cm9rZS1taXRlcmxpbWl0OjEwO30NCgkuc3Qxe2ZpbGw6IzIxMjEyMTtzdHJva2U6Izc2NzQ3NDtzdHJva2Utd2lkdGg6MjtzdHJva2UtbWl0ZXJsaW1pdDoxMDt9DQoJLnN0MntmaWxsOiNGRkZGRkY7fQ0KCS5zdDN7ZmlsbDojRTQ2RTJFO30NCjwvc3R5bGU+DQo8ZyBpZD0iTGF5ZXJfMV8xXyI+DQoJPHJlY3QgeD0iOCIgeT0iMzIiIGNsYXNzPSJzdDAiIHdpZHRoPSIxNzYiIGhlaWdodD0iMTI4Ii8+DQoJPHJlY3QgeD0iMTYiIHk9IjQwIiBjbGFzcz0ic3QxIiB3aWR0aD0iMTYwIiBoZWlnaHQ9IjExMiIvPg0KCTxnPg0KCQk8cGF0aCBjbGFzcz0ic3QyIiBkPSJNNTMuMSw4OS4xYy0xLjEtMC44LTIuMi0xLjQtMy4yLTEuOHMtMi4yLTAuNi0zLjUtMC42Yy0yLjIsMC0zLjMsMC43LTMuMywyLjJjMCwwLjYsMC4zLDEuMSwxLDEuNA0KCQkJYzAuNywwLjQsMS42LDAuOCwyLjYsMS4yYzEsMC40LDIuMiwwLjgsMy40LDEuMmMxLjIsMC40LDIuMywxLDMuNCwxLjdjMSwwLjcsMS45LDEuNSwyLjYsMi41YzAuNywxLDEsMi4yLDEsMy42DQoJCQljMCwyLTAuNywzLjgtMi4xLDUuM2MtMS40LDEuNS0zLjQsMi41LTYuMSwyLjl2Ny4yaC00Ljd2LTdjLTEuNi0wLjItMy4yLTAuNi00LjgtMS4yYy0xLjctMC43LTMuMS0xLjUtNC4zLTIuNmwzLjEtNC44DQoJCQljMS41LDAuOSwzLDEuNyw0LjMsMi4yYzEuNCwwLjUsMi44LDAuOCw0LjMsMC44YzEuMiwwLDItMC4yLDIuNi0wLjZzMC45LTAuOSwwLjktMS42cy0wLjMtMS4yLTEtMS43Yy0wLjctMC40LTEuNi0wLjktMi42LTEuMw0KCQkJcy0yLjItMC44LTMuNC0xLjNjLTEuMi0wLjQtMi4zLTEtMy40LTEuN2MtMS0wLjctMS45LTEuNS0yLjYtMi41Yy0wLjctMS0xLTIuMi0xLTMuN2MwLTIuMSwwLjctMy44LDIuMS01LjINCgkJCWMxLjQtMS40LDMuMy0yLjMsNS44LTIuNnYtNi4zaDQuN1Y4MWMxLjcsMC4yLDMuMSwwLjcsNC4zLDEuNGMxLjIsMC43LDIuMywxLjUsMy4zLDIuNkw1My4xLDg5LjF6Ii8+DQoJCTxwYXRoIGNsYXNzPSJzdDMiIGQ9Ik04Ni43LDExMy4ydjUuM2gtMjN2LTUuM0g4Ni43eiIvPg0KCTwvZz4NCjwvZz4NCjwvc3ZnPg0K"

/***/ },
/* 107 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "2b609d364e2e1d67ba33a81c58d9eb8a.svg";

/***/ },
/* 108 */
/***/ function(module, exports) {

	module.exports = "data:image/svg+xml;base64,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"

/***/ },
/* 109 */
/***/ function(module, exports) {

	module.exports = "data:image/svg+xml;base64,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"

/***/ },
/* 110 */
/***/ function(module, exports) {

	module.exports = "data:image/svg+xml;base64,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"

/***/ },
/* 111 */
/***/ function(module, exports) {

	module.exports = "data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+Cjxzdmcgd2lkdGg9IjE0cHgiIGhlaWdodD0iMTRweCIgdmlld0JveD0iMCAwIDEwIDkiIHZlcnNpb249IjEuMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+CiAgICA8IS0tIEdlbmVyYXRvcjogU2tldGNoIDM5ICgzMTY2NykgLSBodHRwOi8vd3d3LmJvaGVtaWFuY29kaW5nLmNvbS9za2V0Y2ggLS0+CiAgICA8dGl0bGU+aWNfZm9sZGVyX2JsYWNrXzI0cHg8L3RpdGxlPgogICAgPGRlc2M+Q3JlYXRlZCB3aXRoIFNrZXRjaC48L2Rlc2M+CiAgICA8ZGVmcz48L2RlZnM+CiAgICA8ZyBpZD0iUGFnZS0xIiBzdHJva2U9Im5vbmUiIHN0cm9rZS13aWR0aD0iMSIgZmlsbD0ibm9uZSIgZmlsbC1ydWxlPSJldmVub2RkIj4KICAgICAgICA8ZyBpZD0iQXJ0Ym9hcmQtMSIgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoLTY2NC4wMDAwMDAsIC01NzguMDAwMDAwKSI+CiAgICAgICAgICAgIDxnIGlkPSJMYXVuY2hlciIgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoNjU1LjAwMDAwMCwgMjkxLjAwMDAwMCkiPgogICAgICAgICAgICAgICAgPGcgaWQ9Ikdyb3VwLTMiIHRyYW5zZm9ybT0idHJhbnNsYXRlKDguMDAwMDAwLCAyODQuODUxODUyKSI+CiAgICAgICAgICAgICAgICAgICAgPGcgaWQ9ImljX2ZvbGRlcl9ibGFja18yNHB4IiB0cmFuc2Zvcm09InRyYW5zbGF0ZSgwLjAwMDAwMCwgMS4wMDAwMDApIj4KICAgICAgICAgICAgICAgICAgICAgICAgPGcgaWQ9Ikdyb3VwIj4KICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxwYXRoIGQ9Ik01LDIgTDIsMiBDMS40NSwyIDEuMDA1LDIuNDUgMS4wMDUsMyBMMSw5IEMxLDkuNTUgMS40NSwxMCAyLDEwIEwxMCwxMCBDMTAuNTUsMTAgMTEsOS41NSAxMSw5IEwxMSw0IEMxMSwzLjQ1IDEwLjU1LDMgMTAsMyBMNiwzIEw1LDIgTDUsMiBaIiBpZD0iU2hhcGUiIGZpbGw9IiM5RTlFOUUiPjwvcGF0aD4KICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxwb2x5Z29uIGlkPSJTaGFwZSIgcG9pbnRzPSIwIDAgMTIgMCAxMiAxMiAwIDEyIj48L3BvbHlnb24+CiAgICAgICAgICAgICAgICAgICAgICAgIDwvZz4KICAgICAgICAgICAgICAgICAgICA8L2c+CiAgICAgICAgICAgICAgICA8L2c+CiAgICAgICAgICAgIDwvZz4KICAgICAgICA8L2c+CiAgICA8L2c+Cjwvc3ZnPg=="

/***/ },
/* 112 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-Inspector .p-TabBar {\n  min-width: 300px;\n  min-height: 24px;\n  max-height: 24px;\n  color: #777777;\n  font-size: 13px;\n}\n\n\n.jp-Inspector .p-TabBar > .p-TabBar-header {\n  flex: 0 0 1px;\n}\n\n\n.jp-Inspector .p-TabBar-content {\n  min-width: 0;\n  padding-right: 1px;\n}\n\n\n.jp-Inspector .p-TabBar > .p-TabBar-footer {\n  flex: 0 0 1px;\n  background: #BDBDBD;\n}\n\n\n.jp-Inspector .p-TabBar-tab {\n  flex-basis: 144px;\n  min-height: 23px;\n  max-height: 23px;\n  min-width: 35px;\n  padding: 0px 7px;\n  background: #EEEEEE;\n  border: 1px solid #BDBDBD;\n  transform: translateY(-1px);\n  border-bottom: none;\n  margin-right: -1px;\n}\n\n\n.jp-Inspector .p-TabBar-tab.p-mod-current {\n  min-height: 24px;\n  max-height: 24px;\n  background: #FFFFFF;\n  border-top: 1px solid #2196F3;\n}\n\n\n.jp-Inspector .p-TabBar-tab:hover:not(.p-mod-current) {\n  background: #FAFAFA;\n}\n\n\n.jp-Inspector .p-TabBar-tabIcon,\n.jp-Inspector .p-TabBar-tabText {\n  line-height: 24px;\n}\n\n\n.jp-InspectorItem {\n  border: 1px solid #E0E0E0;\n}\n\n\n.jp-InspectorItem .jp-NBToolbar {\n    display: flex;\n    flex-direction: row;\n    border-bottom: 1px solid #E0E0E0;\n    height: 24px;\n}\n\n\n.jp-InspectorItem-content {\n  height: calc(100% - 24px); /* Subtract the height of the toolbar. */\n  overflow: auto;\n}\n\n\n.jp-InspectorItem .jp-NBToolbar-button.jp-InspectorItem-clear::before {\n   content: \"\\F05E\";  /* ban */\n}\n\n\n.jp-InspectorItem .jp-NBToolbar-button.jp-InspectorItem-back::before {\n   content: \"\\F060\";  /* arrow-left */\n}\n\n\n.jp-InspectorItem .jp-NBToolbar-button.jp-InspectorItem-forward::before {\n   content: \"\\F061\";  /* arrow-right */\n}\n\n\n.jp-InspectorItem .jp-NBToolbar-button.jp-InspectorItem-bottom {\n  position: absolute;\n  right: 0;\n}\n\n\n.jp-InspectorItem .jp-NBToolbar-button.jp-InspectorItem-bottom::before {\n   content: \"\\F103\";  /* angle-double-down */\n}\n\n\n.jp-InspectorItem .jp-NBToolbar-button.jp-InspectorItem-right {\n  position: absolute;\n  right: 0;\n}\n\n\n.jp-InspectorItem .jp-NBToolbar-button.jp-InspectorItem-right::before {\n   content: \"\\F101\";  /* angle-double-right */\n}\n\n\n.jp-InspectorItem pre {\n  font-size: 11px;\n  margin: 0;\n  padding: 2px;\n  white-space: pre-wrap;\n}\n\n\n/* ansi_up creates classed spans for console foregrounds and backgrounds. */\n.jp-InspectorItem pre .ansi-black-fg { color: #3A3A3A; }\n\n\n.jp-InspectorItem pre .ansi-red-fg { color: #DD948E; }\n\n\n.jp-InspectorItem pre .ansi-green-fg { color: #B6D1AA; }\n\n\n.jp-InspectorItem pre .ansi-yellow-fg { color: #F3D57C; }\n\n\n.jp-InspectorItem pre .ansi-blue-fg { color: #8AA9D5; }\n\n\n.jp-InspectorItem pre .ansi-magenta-fg { color: #CBAFD5; }\n\n\n.jp-InspectorItem pre .ansi-cyan-fg { color: #9AD1D4; }\n\n\n.jp-InspectorItem pre .ansi-white-fg { color: #EFEFEF; }\n\n\n.jp-InspectorItem pre .ansi-bright-black-fg { color: #5E5D5E; }\n\n\n.jp-InspectorItem pre .ansi-bright-red-fg { color: #E69B94; }\n\n\n.jp-InspectorItem pre .ansi-bright-green-fg { color: #D1F0C3; }\n\n\n.jp-InspectorItem pre .ansi-bright-yellow-fg { color: #F4D799; }\n\n\n.jp-InspectorItem pre .ansi-bright-blue-fg { color: #A6CBFE; }\n\n\n.jp-InspectorItem pre .ansi-bright-magenta-fg { color: #E8C8F3; }\n\n\n.jp-InspectorItem pre .ansi-bright-cyan-fg { color: #B1F1F6; }\n\n\n.jp-InspectorItem pre .ansi-bright-white-fg { color: #FFFFFF; }\n\n\n.jp-InspectorItem pre .ansi-black-bg { background-color: #3B3B3B; }\n\n\n.jp-InspectorItem pre .ansi-red-bg { background-color: #DE958F; }\n\n\n.jp-InspectorItem pre .ansi-green-bg { background-color: #B7D2AB; }\n\n\n.jp-InspectorItem pre .ansi-yellow-bg { background-color: #F4D67D; }\n\n\n.jp-InspectorItem pre .ansi-blue-bg { background-color: #8BAAD6; }\n\n\n.jp-InspectorItem pre .ansi-magenta-bg { background-color: #CCB0D6; }\n\n\n.jp-InspectorItem pre .ansi-cyan-bg { background-color: #9BD2D5; }\n\n\n.jp-InspectorItem pre .ansi-white-bg { background-color: #F0F0F0; }\n\n\n.jp-InspectorItem pre .ansi-bright-black-bg { background-color: #5F5E5F; }\n\n\n.jp-InspectorItem pre .ansi-bright-red-bg { background-color: #E79C95; }\n\n\n.jp-InspectorItem pre .ansi-bright-green-bg { background-color: #D2F1C4; }\n\n\n.jp-InspectorItem pre .ansi-bright-yellow-bg { background-color: #F5D89A; }\n\n\n.jp-InspectorItem pre .ansi-bright-blue-bg { background-color: #A7CCFF; }\n\n\n.jp-InspectorItem pre .ansi-bright-magenta-bg { background-color: #E8C8F3; }\n\n\n.jp-InspectorItem pre .ansi-bright-cyan-bg { background-color: #B1F1F6; }\n\n\n.jp-InspectorItem pre .ansi-bright-white-bg { background-color: #FFFFFF; }\n\n\n/* default inspector items: hints */\n.jp-InspectorItem.jp-HintsInspectorItem.p-Widget,\n.jp-InspectorItem.jp-HintsInspectorItem.p-Widget .p-Widget {\n  background: #FFFFCA;\n}\n\n\n/* default inspector items: details */\n.jp-InspectorItem.jp-DetailsInspectorItem.p-Widget .p-Widget {\n  background: #FFFFFF;\n}\n", ""]);
	
	// exports


/***/ },
/* 113 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-MarkdownWidget {\n  border-top: 1px solid #E0E0E0;\n  padding: 14px;\n}\n", ""]);
	
	// exports


/***/ },
/* 114 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.jp-Rendered-html {\n  color: #000;\n  /* any extras will just be numbers: */\n}\n\n.jp-Rendered-html em {\n  font-style: italic;\n}\n\n.jp-Rendered-html strong {\n  font-weight: bold;\n}\n\n.jp-Rendered-html u {\n  text-decoration: underline;\n}\n\n.jp-Rendered-html :link {\n  text-decoration: underline;\n}\n\n.jp-Rendered-html :visited {\n  text-decoration: underline;\n}\n\n.jp-Rendered-html h1 {\n  font-size: 185.7%;\n  margin: 1.08em 0 0 0;\n  font-weight: bold;\n  line-height: 1.0;\n}\n\n.jp-Rendered-html h2 {\n  font-size: 157.1%;\n  margin: 1.27em 0 0 0;\n  font-weight: bold;\n  line-height: 1.0;\n}\n\n.jp-Rendered-html h3 {\n  font-size: 128.6%;\n  margin: 1.55em 0 0 0;\n  font-weight: bold;\n  line-height: 1.0;\n}\n\n.jp-Rendered-html h4 {\n  font-size: 100%;\n  margin: 2em 0 0 0;\n  font-weight: bold;\n  line-height: 1.0;\n}\n\n.jp-Rendered-html h5 {\n  font-size: 100%;\n  margin: 2em 0 0 0;\n  font-weight: bold;\n  line-height: 1.0;\n  font-style: italic;\n}\n\n.jp-Rendered-html h6 {\n  font-size: 100%;\n  margin: 2em 0 0 0;\n  font-weight: bold;\n  line-height: 1.0;\n  font-style: italic;\n}\n\n.jp-Rendered-html h1:first-child {\n  margin-top: 0.538em;\n}\n\n.jp-Rendered-html h2:first-child {\n  margin-top: 0.636em;\n}\n\n.jp-Rendered-html h3:first-child {\n  margin-top: 0.777em;\n}\n\n.jp-Rendered-html h4:first-child {\n  margin-top: 1em;\n}\n\n.jp-Rendered-html h5:first-child {\n  margin-top: 1em;\n}\n\n.jp-Rendered-html h6:first-child {\n  margin-top: 1em;\n}\n\n.jp-Rendered-html ul:not(.list-inline),\n.jp-Rendered-html ol:not(.list-inline) {\n  padding-left: 2em;\n}\n\n.jp-Rendered-html ul {\n  list-style: disc;\n}\n\n.jp-Rendered-html ul ul {\n  list-style: square;\n}\n\n.jp-Rendered-html ul ul ul {\n  list-style: circle;\n}\n\n.jp-Rendered-html ol {\n  list-style: decimal;\n}\n\n.jp-Rendered-html ol ol {\n  list-style: upper-alpha;\n}\n\n.jp-Rendered-html ol ol ol {\n  list-style: lower-alpha;\n}\n\n.jp-Rendered-html ol ol ol ol {\n  list-style: lower-roman;\n}\n\n.jp-Rendered-html ol ol ol ol ol {\n  list-style: decimal;\n}\n\n.jp-Rendered-html * + ul {\n  margin-top: 1em;\n}\n\n.jp-Rendered-html * + ol {\n  margin-top: 1em;\n}\n\n.jp-Rendered-html hr {\n  color: black;\n  background-color: black;\n}\n\n.jp-Rendered-html pre {\n  margin: 1em 2em;\n}\n\n.jp-Rendered-html pre,\n.jp-Rendered-html code {\n  border: 0;\n  background-color: #fff;\n  color: #000;\n  font-size: 100%;\n  padding: 0px;\n}\n\n.jp-Rendered-html blockquote {\n  margin: 1em 2em;\n}\n\n.jp-Rendered-html table {\n  margin-left: auto;\n  margin-right: auto;\n  border: 1px solid black;\n  border-collapse: collapse;\n}\n\n.jp-Rendered-html tr,\n.jp-Rendered-html th,\n.jp-Rendered-html td {\n  border: 1px solid black;\n  border-collapse: collapse;\n  margin: 1em 2em;\n}\n\n.jp-Rendered-html td,\n.jp-Rendered-html th {\n  text-align: left;\n  vertical-align: middle;\n  padding: 4px;\n}\n\n.jp-Rendered-html th {\n  font-weight: bold;\n}\n\n.jp-Rendered-html * + table {\n  margin-top: 1em;\n}\n\n.jp-Rendered-html p {\n  text-align: left;\n}\n\n.jp-Rendered-html * + p {\n  margin-top: 1em;\n}\n\n.jp-Rendered-html img {\n  display: block;\n  margin-left: auto;\n  margin-right: auto;\n}\n\n.jp-Rendered-html * + img {\n  margin-top: 1em;\n}\n\n.jp-Rendered-html img,\n.jp-Rendered-html svg {\n  max-width: 100%;\n  height: auto;\n}\n\n.jp-Rendered-html img.unconfined,\n.jp-Rendered-html svg.unconfined {\n  max-width: none;\n}\n\n.jp-Rendered-html .alert {\n  margin-bottom: initial;\n}\n\n.jp-Rendered-html * + .alert {\n  margin-top: 1em;\n}\n", ""]);
	
	// exports


/***/ },
/* 115 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n#main {\n  display: flex;\n  flex-direction: column;\n  font-size: 14px;\n  position: absolute;\n  left: 0;\n  top: 0;\n  bottom: 0;\n  right: 0;\n}\n\n\n#jp-main-content-panel {\n  display: flex;\n  flex: 1 1 auto;\n}\n\n\n#jp-top-panel {\n  display: flex;\n  flex: 0 0 auto;\n  min-height: 24px;\n}\n\n\n#jp-main-split-panel {\n  display: flex;\n  flex: 1 1 auto;\n}\n\n\n#jp-left-stack, #jp-right-stack {\n  display: flex;\n  flex: 1 1 auto;\n}\n\n\n#jp-left-stack > .p-Widget, #jp-right-stack > .p-Widget {\n  flex: 1 1 auto;\n  min-width: 300px;\n}\n\n\n.jp-SideBar.p-TabBar.jp-mod-right, .jp-SideBar.p-TabBar.jp-mod-left {\n  margin: 0;\n  padding: 0;\n  display: flex;\n  align-items: stretch;\n  list-style-type: none;\n  max-height: none;\n  color: #777777;\n  font-size: 14px;\n  min-width: 36px;\n  max-width: 36px;\n  overflow: visible;\n}\n\n\n.jp-SideBar.p-Widget {\n  overflow: visible;\n}\n\n\n.jp-SideBar.jp-mod-left .p-TabBar-content,\n.jp-SideBar.jp-mod-right .p-TabBar-content {\n  display: flex;\n  list-style: none;\n  height: 100%;\n  line-height: 35px;\n  background: #EEEEEE;\n  border: none;\n  border-top: 1px solid #BDBDBD;\n  margin-top: 1px;\n}\n\n\n.jp-SideBar.jp-mod-left .p-TabBar-content {\n  flex-direction: column;\n  border-right: 1px solid #BDBDBD;\n  margin-right: 1px;\n}\n\n\n.jp-SideBar.jp-mod-right .p-TabBar-content {\n  flex-direction: column-reverse;\n  justify-content: flex-end;\n  border-left: 1px solid #BDBDBD;\n  margin-left: 1px;\n}\n\n\n.jp-SideBar .p-TabBar-tab,\n.jp-SideBar .p-TabBar-tab.p-mod-current {\n  font-size: 13px;\n  width: 100px;\n  margin-bottom: 32px;\n  margin-top: 33px;\n  min-height: 35px;\n  max-height: 35px;\n  line-height: 35px;\n  text-align: center;\n  border: none;\n}\n\n\n.jp-SideBar .p-TabBar-tab.p-mod-current {\n  background: #EEEEEE;\n  color: #2196F3;\n}\n\n\n.jp-SideBar.jp-mod-left .p-TabBar-tab {\n  transform: rotate(-90deg) translateY(-100%);\n  border-left: 1px solid #BDBDBD;\n}\n\n\n.jp-SideBar.jp-mod-right .p-TabBar-tab {\n  transform: rotate(90deg) translateY(90%);\n  border-right: 1px solid #BDBDBD;\n}\n\n\n/*.jp-SideBar-button {\n  padding: 0 18px;\n  line-height: 35px;\n}\n\n\n.jp-SideBar-button:hover:not(.p-mod-current) {\n  background: #FAFAFA;\n}\n\n\n.jp-SideBar-button.p-mod-current {\n  color: #2196F3;\n  background: #FAFAFA;\n}\n\n\n.jp-SideBar.jp-mod-left .jp-SideBar-button {\n  border-left: 1px solid #BDBDBD;\n}\n\n\n.jp-SideBar.jp-mod-right .jp-SideBar-button {\n  border-right: 1px solid #BDBDBD;\n}\n*/\n", ""]);
	
	// exports


/***/ },
/* 116 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(45)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-Landing {\n  color: #757575;\n  position: absolute;\n  z-index: 10000;\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  top: 0px;\n  left: 0px;\n  margin: 0;\n  padding: 0;\n  width: 100%;\n  height: 100%;\n}\n\n\n.jp-Landing-dialog {\n  padding-bottom: 12px;\n  font-size: 16px;\n  color: #757575;\n  margin-left: auto;\n  margin-right: auto;\n  text-align: center;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  flex-direction: column;\n  box-shadow: 0 2px 7px 1px #BDBDBD;\n}\n\n\n.jp-Landing-logo {\n  flex: 0 0 50px;\n  margin-left: auto;\n  margin-right: auto;\n  width: 100%;\n  background-color: white;\n  background-size: 232px 50px;\n  background-repeat: no-repeat;\n  background-position: center;\n  margin-top: 20px;\n\n}\n\n.jp-Landing-subtitle {\n  font-size: 16px;\n  background-color: white;\n  width: 100%;\n  margin-top: 4px;\n  font-weight: 300;\n}\n\n.jp-Landing-header {\n\n  font-size: 14px;\n  padding-top: 16px;\n  padding-bottom: 4px;\n}\n\n\n.jp-Landing-body {\n  display: flex;\n  flex-direction: row;\n  padding-left: 20px;\n  padding-right: 20px;\n}\n\n\n.jp-Landing-column {\n  padding-left: 20px;\n  padding-right: 20px;\n  display: flex;\n  flex-direction: column;\n}\n\n\n.jp-Landing-image {\n  flex: 0 0 auto;\n  min-height: 72px;\n  max-height: 72px;\n  min-width: 56px;\n  max-width: 56px;\n  background-size: 56px 72px;\n  background-repeat: no-repeat;\n\n}\n\n.jp-Landing-image:hover {\n  cursor: pointer;\n}\n\n.jp-Landing-text {\n  flex: 0 0 auto;\n  font-size: 12px;\n  padding-top: 8px;\n}\n\n.jp-Landing-tour {\n    margin-top: 14px;\n    height: 14px;\n    width: 100%;\n    cursor: pointer;\n    padding-bottom: 14px;\n    border-bottom: 2px solid #EEEEEE;\n    background-position: top center;\n    background-repeat: no-repeat;\n}\n\n.jp-Landing-folder {\n  margin-right: 0;\n  float:left;\n  display: inline-block;\n  background-origin: content-box;\n  background-repeat: no-repeat;\n  clear: none;\n  padding-top: 2px;\n  height: 12px;\n  width: 12px;\n}\n\n.jp-Landing-path {\n    padding-left: 8px;\n    color: #9E9E9E;\n    font-size: 12px;\n}\n\n.jp-Landing-cwd {\n    float: left;\n    padding-top: 24px;\n    padding-left: 14px;\n    margin-right: auto;\n}\n\n\n", ""]);
	
	// exports


/***/ },
/* 117 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var widget_1 = __webpack_require__(17);
	var commandpalette_1 = __webpack_require__(118);
	var html_1 = __webpack_require__(120);
	/**
	 * The about page extension.
	 */
	exports.aboutExtension = {
	    id: 'jupyter.extensions.about',
	    activate: activateAbout,
	    autoStart: true,
	    requires: [commandpalette_1.ICommandPalette]
	};
	function activateAbout(app, palette) {
	    var widget = new widget_1.Widget();
	    widget.id = 'about-jupyterlab';
	    widget.title.label = 'About';
	    widget.title.closable = true;
	    widget.node.innerHTML = html_1.html;
	    widget.node.style.overflowY = 'auto';
	    var command = 'about-jupyterlab:show';
	    app.commands.addCommand(command, {
	        label: 'About JupyterLab',
	        execute: function () {
	            if (!widget.isAttached) {
	                app.shell.addToMainArea(widget);
	            }
	            else {
	                app.shell.activateMain(widget.id);
	            }
	        }
	    });
	    palette.addItem({ command: command, category: 'Help' });
	}


/***/ },
/* 118 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) Jupyter Development Team.
	| Distributed under the terms of the Modified BSD License.
	|----------------------------------------------------------------------------*/
	"use strict";
	var token_1 = __webpack_require__(119);
	/* tslint:disable */
	/**
	 * The command palette token.
	 */
	exports.ICommandPalette = new token_1.Token('jupyter.services.commandpalette');


/***/ },
/* 119 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * A runtime object which captures compile-time type information.
	 *
	 * #### Notes
	 * A token captures the compile-time type of an interface or class in
	 * an object which is useful for various type-safe runtime operations.
	 *
	 * #### Example
	 * ``` typescript
	 * interface IThing {
	 *   value: number;
	 * }
	 *
	 * const IThing = new Token<IThing>('my-module/IThing');
	 *
	 * // some runtime type registry
	 * registry.registerFactory(IThing, () => { value: 42 });
	 *
	 * // later...
	 * let thing = registry.getInstance(IThing);
	 * thing.value; // 42
	 * ```
	 */
	var Token = (function () {
	    /**
	     * Construct a new token.
	     *
	     * @param name - A human readable name for the token.
	     */
	    function Token(name) {
	        this._name = name;
	    }
	    Object.defineProperty(Token.prototype, "name", {
	        /**
	         * The human readable name for the token.
	         *
	         * #### Notes
	         * This can be useful for debugging and logging.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._name;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return Token;
	}());
	exports.Token = Token;


/***/ },
/* 120 */
/***/ function(module, exports) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	exports.html = "\n<div id=\"about\">\n    <!-- PAGE ONE -->\n    <div class=\"section\">\n      <a name=\"#\"></a>\n        <div class=\"sectioncenter\">\n        <div class=\"container\">\n            <div class=\"row\">\n                <div class=\"column\">\n                    <span class=\"jp-img jp-About-logo\"></span>\n                    <p class=\"header\">Welcome to the JupyterLab Alpha preview</p>\n                    <div class=\"desc-one\">\n                        <p>Click on the JupyterLab tab for the initial JupyterLab screen.</p>\n                        <p>This demo gives an Alpha-level developer preview of the JupyterLab environment. <b>It is not ready for general usage yet.</b> We are developing JupyterLab at <a href=\"https://github.com/jupyter/jupyterlab\">https://github.com/jupyter/jupyterlab</a>. Pull requests are welcome!</p>\n                        <p>Here is a brief description of some of the things you'll find in this demo.</p>\n                    </div>\n                </div>\n            </div>\n            <!-- 4 SECTIONS -->\n            <div class=\"row\">\n                <div class=\"one-half column\">\n                    <p class=\"desc-two-header\">\n                        <a href=\"#main-area\">\n                          <span class=\"jp-img jp-About-hero-mainarea\"></span>Main Area\n                        </a>\n                    </p>\n                    <p class=\"desc-two\">\n                        Open tabs and drag and drop them to rearrange them\n                    </p>\n                </div>\n                <div class=\"one-half column\">\n                    <p class=\"desc-two-header\">\n                        <a href=\"#command\">\n                            <span class=\"jp-img jp-About-hero-command\"></span>Command Palette\n                        </a>\n                    </p>\n                    <p class=\"desc-two\">\n                        View list of commands and keyboard shortcuts\n                    </p>\n                </div>\n            </div>\n\n            <div class=\"row\">\n                <div class=\"one-half column\">\n                    <p class=\"desc-two-header\">\n                        <a href=\"#filebrowser\">\n                            <span class=\"jp-img jp-About-hero-filebrowser\"></span>File Browser\n                        </a>\n                    </p>\n                    <p class=\"desc-two\">\n                        Navigate and organize your files\n                    </p>\n                </div>\n                <div class=\"one-half column\">\n                    <p class=\"desc-two-header\">\n                        <a href=\"#notebook\">\n                            <span class=\"jp-img jp-About-hero-notebook\"></span>Notebook\n                        </a>\n                    </p>\n                    <p class=\"desc-two\">\n                        Dedicate a tab to running a classic notebook\n                    </p>\n                </div>\n            </div>\n\n            <!-- END OF 4 SECTIONS -->\n        </div>\n        <a href=\"#main-area\">\n          <span class=\"nav-button\"></span>\n        </a>\n    </div>\n  </div>\n    <div class=\"section\">\n      <a name=\"main-area\"></a>\n      <div class=\"sectioncenter\">\n        <p class=\"header content\"><span class=\"jp-img jp-About-hero-mainarea\"></span>Main Area</p>\n        <span class=\"jp-img jp-About-mainarea\"></span>\n        <p class=\"content-desc\">The main area is divided into panels of tabs. Drag a tab around the area to split the main area in different ways. Drag a tab to the center of a panel to move a tab without splitting the panel (in this case, the whole panel will highlight instead of just a portion).</p>\n        <p class=\"content-desc\">Resize panels by dragging their borders (be aware that panels and sidebars also have a minimum width). A file that contains changes to be saved has a circle for a close icon.</p>\n        <a href=\"#command\">\n          <span class=\"nav-button\"></span>\n        </a>\n      </div>\n    </div>\n    <div class=\"section\">\n      <a name=\"command\"></a>\n      <div class=\"sectioncenter\">\n        <p class=\"header content\"><span class=\"jp-img jp-About-hero-command\"></span>Command Palette</p>\n        <span class=\"jp-img jp-About-command\"></span>\n        <p class=\"content-desc\">Clicking the \"Commands\" tab, located on the left, will toggle the command palette. Execute a command by clicking, or navigating with your arrow keys and pressing Enter. Filter commands by typing in the text box at the top of the palette. The palette is organized into categories, and you can filter on a single category by clicking on the category header or by typing the header surrounded by colons in the search input (e.g., <code>:file:</code>).</p>\n        <div class=\"content-desc\">\n            <p>You can try these things from the command palette:</p>\n            <ul>\n                <li>Open a new terminal (requires OS X or Linux)</li>\n                <li>Open an IPython console</li>\n                <li>Open a new file</li>\n                <li>Save a file</li>\n                <li>Open up a help panel on the right</li>\n            </ul>\n        </div>\n        <a href=\"#filebrowser\">\n          <span class=\"nav-button\"></span>\n        </a>\n      </div>\n    </div>\n    <div class=\"section\">\n      <a name=\"filebrowser\"></a>\n      <div class=\"sectioncenter\">\n        <p class=\"header content\"><span class=\"jp-img jp-About-hero-filebrowser\"></span>File Browser</p>\n        <span class=\"jp-img jp-About-fb\"></span>\n        <p class=\"content-desc\">Clicking the \"Files\" tab, located on the left, will toggle the file browser. Navigate into directories by double-clicking, and use the breadcrumbs at the top to navigate out. Create a new file/directory by clicking the plus icon at the top. Click the middle icon to upload files, and click the last icon to reload the file listing. Drag and drop files to move them to subdirectories. Click on a selected file to rename it. Sort the list by clicking on a column header. Open a file by double-clicking it or dragging it into the main area. Opening an image displays the image. Opening a code file opens a code editor. Opening a notebook opens a very preliminary notebook component.</p>\n        <a href=\"#notebook\">\n          <span class=\"nav-button\"></span>\n        </a>\n      </div>\n    </div>\n    <div class=\"section\">\n      <a name=\"notebook\"></a>\n      <div class=\"sectioncenter\">\n        <p class=\"header content\"><span class=\"jp-img jp-About-hero-notebook\"></span>Notebook</p>\n        <span class=\"jp-img jp-About-nb\"></span>\n        <p class=\"content-desc\">Opening a notebook will open a minimally-featured notebook. Code execution, Markdown rendering, and basic cell toolbar actions are supported. Future versions will add more features from the existing Jupyter notebook.</p>\n      </div>\n    </div>\n</div>";


/***/ },
/* 121 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var mimedata_1 = __webpack_require__(29);
	var _1 = __webpack_require__(122);
	/**
	 * The clipboard provider.
	 */
	exports.clipboardProvider = {
	    id: 'jupyter.services.clipboard',
	    provides: _1.IClipboard,
	    activate: function () { return new mimedata_1.MimeData(); }
	};


/***/ },
/* 122 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var token_1 = __webpack_require__(119);
	/* tslint:disable */
	/**
	 * The clipboard token.
	 */
	exports.IClipboard = new token_1.Token('jupyter.services.clipboard');
	/**
	 * Copy text to the system clipboard.
	 *
	 * #### Notes
	 * This can only be called in response to a user input event.
	 */
	function copyToClipboard(text) {
	    var node = document.body;
	    var handler = function (event) {
	        var data = event.clipboardData || window.clipboardData;
	        data.setData('text', text);
	        event.preventDefault();
	        node.removeEventListener('copy', handler);
	    };
	    node.addEventListener('copy', handler);
	    generateClipboardEvent(node);
	}
	exports.copyToClipboard = copyToClipboard;
	/**
	 * Generate a clipboard event on a node.
	 *
	 * @param node - The element on which to generate the event.
	 *
	 * @param type - The type of event to generate: `'copy'` or `'cut'`.
	 *   `'paste'` events cannot be programmatically generated.
	 *
	 * #### Notes
	 * This can only be called in response to a user input event.
	 */
	function generateClipboardEvent(node, type) {
	    // http://stackoverflow.com/a/5210367
	    if (type === void 0) { type = 'copy'; }
	    // Identify selected text.
	    var sel = window.getSelection();
	    // Save the current selection.
	    var savedRanges = [];
	    for (var i = 0, len = sel.rangeCount; i < len; ++i) {
	        savedRanges[i] = sel.getRangeAt(i).cloneRange();
	    }
	    // Select the node content.
	    var range = document.createRange();
	    range.selectNodeContents(node);
	    sel.removeAllRanges();
	    sel.addRange(range);
	    // Execute the command.
	    document.execCommand(type);
	    // Restore the previous selection.
	    sel = window.getSelection();
	    sel.removeAllRanges();
	    for (var i = 0, len = savedRanges.length; i < len; ++i) {
	        sel.addRange(savedRanges[i]);
	    }
	}
	exports.generateClipboardEvent = generateClipboardEvent;


/***/ },
/* 123 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) Jupyter Development Team.
	| Distributed under the terms of the Modified BSD License.
	|----------------------------------------------------------------------------*/
	"use strict";
	var disposable_1 = __webpack_require__(4);
	var commandpalette_1 = __webpack_require__(124);
	var _1 = __webpack_require__(118);
	/**
	 * A thin wrapper around the `CommandPalette` class to conform with the
	 * JupyterLab interface for the application-wide command palette.
	 */
	var Palette = (function () {
	    /**
	     * Create a palette instance.
	     */
	    function Palette(palette) {
	        this._palette = null;
	        this._palette = palette;
	    }
	    Object.defineProperty(Palette.prototype, "placeholder", {
	        get: function () {
	            return this._palette.inputNode.placeholder;
	        },
	        /**
	         * The placeholder text of the command palette's search input.
	         */
	        set: function (placeholder) {
	            this._palette.inputNode.placeholder = placeholder;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Activate the command palette for user input.
	     */
	    Palette.prototype.activate = function () {
	        this._palette.activate();
	    };
	    /**
	     * Add a command item to the command palette.
	     *
	     * @param options - The options for creating the command item.
	     *
	     * @returns A disposable that will remove the item from the palette.
	     */
	    Palette.prototype.addItem = function (options) {
	        var _this = this;
	        var item = this._palette.addItem(options);
	        return new disposable_1.DisposableDelegate(function () { return _this._palette.removeItem(item); });
	    };
	    return Palette;
	}());
	/**
	 * The default commmand palette extension.
	 */
	exports.commandPaletteProvider = {
	    id: 'jupyter.services.commandpalette',
	    provides: _1.ICommandPalette,
	    activate: activateCommandPalette,
	    autoStart: true
	};
	/**
	 * Activate the command palette.
	 */
	function activateCommandPalette(app) {
	    var commands = app.commands, keymap = app.keymap;
	    var palette = new commandpalette_1.CommandPalette({ commands: commands, keymap: keymap });
	    palette.id = 'command-palette';
	    palette.title.label = 'Commands';
	    /**
	     * Activate the command palette within the app shell (used as a command).
	     */
	    function activatePalette() {
	        app.shell.activateLeft(palette.id);
	        palette.activate();
	    }
	    /**
	     * Hide the command palette within the app shell (used as a command).
	     */
	    function hidePalette() {
	        if (!palette.isHidden) {
	            app.shell.collapseLeft();
	        }
	    }
	    /**
	     * Toggle the command palette within the app shell (used as a command).
	     */
	    function togglePalette() {
	        if (palette.isHidden) {
	            activatePalette();
	        }
	        else {
	            hidePalette();
	        }
	    }
	    app.commands.addCommand('command-palette:activate', {
	        execute: activatePalette,
	        label: 'Activate Command Palette'
	    });
	    app.commands.addCommand('command-palette:hide', {
	        execute: hidePalette,
	        label: 'Hide Command Palette'
	    });
	    app.commands.addCommand('command-palette:toggle', {
	        execute: togglePalette,
	        label: 'Toggle Command Palette'
	    });
	    app.shell.addToLeftArea(palette);
	    return new Palette(palette);
	}


/***/ },
/* 124 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var searching_1 = __webpack_require__(11);
	var vector_1 = __webpack_require__(13);
	var query_1 = __webpack_require__(32);
	var keymap_1 = __webpack_require__(9);
	var widget_1 = __webpack_require__(17);
	/**
	 * The class name added to `CommandPalette` instances.
	 */
	var PALETTE_CLASS = 'p-CommandPalette';
	/**
	 * The class name added to the search section of the palette.
	 */
	var SEARCH_CLASS = 'p-CommandPalette-search';
	/**
	 * The class name added to the input wrapper in the search section.
	 */
	var WRAPPER_CLASS = 'p-CommandPalette-wrapper';
	/**
	 * The class name added to the input node in the search section.
	 */
	var INPUT_CLASS = 'p-CommandPalette-input';
	/**
	 * The class name added to the content section of the palette.
	 */
	var CONTENT_CLASS = 'p-CommandPalette-content';
	/**
	 * The class name added to a palette section header.
	 */
	var HEADER_CLASS = 'p-CommandPalette-header';
	/**
	 * The class name added to a palette item node.
	 */
	var ITEM_CLASS = 'p-CommandPalette-item';
	/**
	 * The class name added to a item label node.
	 */
	var LABEL_CLASS = 'p-CommandPalette-itemLabel';
	/**
	 * The class name added to a item shortcut node.
	 */
	var SHORTCUT_CLASS = 'p-CommandPalette-itemShortcut';
	/**
	 * The class name added to a item caption node.
	 */
	var CAPTION_CLASS = 'p-CommandPalette-itemCaption';
	/**
	 * The class name added to the active palette header or item.
	 */
	var ACTIVE_CLASS = 'p-mod-active';
	/**
	 * The class name added to a disabled command item.
	 */
	var DISABLED_CLASS = 'p-mod-disabled';
	/**
	 * The class name added to a toggled command item.
	 */
	var TOGGLED_CLASS = 'p-mod-toggled';
	/**
	 * A widget which displays command items as a searchable palette.
	 */
	var CommandPalette = (function (_super) {
	    __extends(CommandPalette, _super);
	    /**
	     * Construct a new command palette.
	     *
	     * @param options - The options for initializing the palette.
	     */
	    function CommandPalette(options) {
	        _super.call(this, { node: Private.createNode() });
	        this._activeIndex = 1;
	        this._itemNodes = new vector_1.Vector();
	        this._headerNodes = new vector_1.Vector();
	        this._items = new vector_1.Vector();
	        this._result = null;
	        this.addClass(PALETTE_CLASS);
	        this.setFlag(widget_1.WidgetFlag.DisallowLayout);
	        this._keymap = options.keymap;
	        this._commands = options.commands;
	        this._renderer = options.renderer || CommandPalette.defaultRenderer;
	        this._commands.commandChanged.connect(this._onGenericChange, this);
	        this._keymap.bindingChanged.connect(this._onGenericChange, this);
	    }
	    /**
	     * Dispose of the resources held by the command palette.
	     */
	    CommandPalette.prototype.dispose = function () {
	        this._items.clear();
	        this._itemNodes.clear();
	        this._headerNodes.clear();
	        this._result = null;
	        this._keymap = null;
	        this._commands = null;
	        this._renderer = null;
	        _super.prototype.dispose.call(this);
	    };
	    Object.defineProperty(CommandPalette.prototype, "searchNode", {
	        /**
	         * Get the command palette search node.
	         *
	         * #### Notes
	         * This is the node which contains the search-related elements.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.node.getElementsByClassName(SEARCH_CLASS)[0];
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(CommandPalette.prototype, "inputNode", {
	        /**
	         * Get the command palette input node.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.node.getElementsByClassName(INPUT_CLASS)[0];
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(CommandPalette.prototype, "contentNode", {
	        /**
	         * Get the command palette content node.
	         *
	         * #### Notes
	         * This is the node which holds the command item nodes.
	         *
	         * Modifying this node directly can lead to undefined behavior.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.node.getElementsByClassName(CONTENT_CLASS)[0];
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(CommandPalette.prototype, "items", {
	        /**
	         * A read-only sequence of the command items in the palette.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._items;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(CommandPalette.prototype, "commands", {
	        /**
	         * The command registry used by the command palette.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._commands;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(CommandPalette.prototype, "keymap", {
	        /**
	         * The keymap used by the command palette.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._keymap;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(CommandPalette.prototype, "renderer", {
	        /**
	         * The renderer used by the command palette.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._renderer;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Add a command item to the command palette.
	     *
	     * @param options - The options for creating the command item.
	     *
	     * @returns The command item added to the palette.
	     */
	    CommandPalette.prototype.addItem = function (options) {
	        // Create a new command item for the options.
	        var item = Private.createItem(this._commands, this._keymap, options);
	        // Add the item to the vector.
	        this._items.pushBack(item);
	        // Schedule an update of the content.
	        if (this.isAttached)
	            this.update();
	        // Return the item added to the palette.
	        return item;
	    };
	    /**
	     * Remove an item from the command palette.
	     *
	     * @param item - The item to remove from the palette.
	     *
	     * @returns The index occupied by the item, or `-1` if the item
	     *   was not contained in the menu.
	     */
	    CommandPalette.prototype.removeItem = function (item) {
	        var index = searching_1.indexOf(this._items, item);
	        if (index !== -1)
	            this.removeItemAt(index);
	        return index;
	    };
	    /**
	     * Remove the item at a given index from the command palette.
	     *
	     * @param index - The index of the item to remove.
	     *
	     * @returns The item occupying the index, or `null` if the index
	     *   is out of range.
	     */
	    CommandPalette.prototype.removeItemAt = function (index) {
	        // Bail if the index is out of range.
	        var i = Math.floor(index);
	        if (i < 0 || i >= this._items.length) {
	            return null;
	        }
	        // Remove the item from the vector.
	        var item = this._items.removeAt(index);
	        // Schedule an update of the content.
	        if (this.isAttached)
	            this.update();
	        // Return the removed item.
	        return item;
	    };
	    /**
	     * Remove all command items from the command palette.
	     */
	    CommandPalette.prototype.clearItems = function () {
	        // Clear the vector of items.
	        this._items.clear();
	        // Schedule an update of the content.
	        if (this.isAttached)
	            this.update();
	    };
	    /**
	     * Handle the DOM events for the command palette.
	     *
	     * @param event - The DOM event sent to the command palette.
	     *
	     * #### Notes
	     * This method implements the DOM `EventListener` interface and is
	     * called in response to events on the command palette's DOM node.
	     * It should not be called directly by user code.
	     */
	    CommandPalette.prototype.handleEvent = function (event) {
	        switch (event.type) {
	            case 'click':
	                this._evtClick(event);
	                break;
	            case 'keydown':
	                this._evtKeyDown(event);
	                break;
	            case 'input':
	                this.update();
	                break;
	        }
	    };
	    /**
	     * A message handler invoked on a `'after-attach'` message.
	     */
	    CommandPalette.prototype.onAfterAttach = function (msg) {
	        this.node.addEventListener('click', this);
	        this.node.addEventListener('keydown', this);
	        this.node.addEventListener('input', this);
	        this.update();
	    };
	    /**
	     * A message handler invoked on a `'before-detach'` message.
	     */
	    CommandPalette.prototype.onBeforeDetach = function (msg) {
	        this.node.removeEventListener('click', this);
	        this.node.removeEventListener('keydown', this);
	        this.node.removeEventListener('input', this);
	    };
	    /**
	     * A message handler invoked on an `'activate-request'` message.
	     */
	    CommandPalette.prototype.onActivateRequest = function (msg) {
	        if (this.isAttached) {
	            var input = this.inputNode;
	            input.focus();
	            input.select();
	        }
	    };
	    /**
	     * A message handler invoked on a `'deactivate-request'` message.
	     */
	    CommandPalette.prototype.onDeactivateRequest = function (msg) {
	        if (this.isAttached) {
	            var input = this.inputNode;
	            input.blur();
	            input.setSelectionRange(0, 0);
	        }
	    };
	    /**
	     * A message handler invoked on an `'update-request'` message.
	     */
	    CommandPalette.prototype.onUpdateRequest = function (msg) {
	        var _this = this;
	        // Clear the current content.
	        this.contentNode.textContent = '';
	        // Reset the active index and search result.
	        this._activeIndex = -1;
	        this._result = null;
	        // Bail early if there are no command items.
	        if (this._items.isEmpty) {
	            return;
	        }
	        // Split the query text into its category and text parts.
	        var _a = CommandPalette.splitQuery(this.inputNode.value), category = _a.category, text = _a.text;
	        // Search the command items for query matches.
	        var result = this._result = Private.search(this._items, category, text);
	        // If the result is empty, there is nothing left to do.
	        if (result.parts.length === 0) {
	            return;
	        }
	        // Fetch command variables.
	        var renderer = this._renderer;
	        var itemNodes = this._itemNodes;
	        var headerNodes = this._headerNodes;
	        // Ensure there are enough header nodes.
	        while (headerNodes.length < result.headerCount) {
	            headerNodes.pushBack(renderer.createHeaderNode());
	        }
	        // Ensure there are enough item nodes.
	        while (itemNodes.length < result.itemCount) {
	            itemNodes.pushBack(renderer.createItemNode());
	        }
	        // Setup the index counters and document fragment.
	        var itemIndex = 0;
	        var headerIndex = 0;
	        var fragment = document.createDocumentFragment();
	        // Render the search result into the fragment.
	        for (var _i = 0, _b = result.parts; _i < _b.length; _i++) {
	            var part = _b[_i];
	            var node = void 0;
	            if (part.item === null) {
	                node = headerNodes.at(headerIndex++);
	                renderer.updateHeaderNode(node, part.markup);
	            }
	            else {
	                node = itemNodes.at(itemIndex++);
	                renderer.updateItemNode(node, part.item, part.markup);
	            }
	            fragment.appendChild(node);
	        }
	        // Add the fragment to the content node.
	        this.contentNode.appendChild(fragment);
	        // If there is query text, activate the first command item.
	        // Otherwise, reset the content scroll position to the top.
	        if (category || text) {
	            this._activateNext('item');
	        }
	        else {
	            requestAnimationFrame(function () { _this.contentNode.scrollTop = 0; });
	        }
	    };
	    /**
	     * Handle the `'click'` event for the command palette.
	     */
	    CommandPalette.prototype._evtClick = function (event) {
	        // Bail if the click is not the left button.
	        if (event.button !== 0) {
	            return;
	        }
	        // Bail if the click was not on a content item.
	        var target = event.target;
	        var children = this.contentNode.children;
	        var i = searching_1.findIndex(children, function (child) { return child.contains(target); });
	        if (i === -1) {
	            return;
	        }
	        // Kill the event when a content item is clicked.
	        event.preventDefault();
	        event.stopPropagation();
	        // Bail if there is no search result.
	        if (!this._result) {
	            return;
	        }
	        // Bail if the index is out of range.
	        var part = this._result.parts[i];
	        if (!part) {
	            return;
	        }
	        // Bail if the part has a disabled item.
	        if (part.item && !part.item.isEnabled) {
	            return;
	        }
	        // Activate the index and trigger the part.
	        this._activate(i);
	        this._triggerActive();
	    };
	    /**
	     * Handle the `'keydown'` event for the command palette.
	     */
	    CommandPalette.prototype._evtKeyDown = function (event) {
	        if (event.altKey || event.ctrlKey || event.metaKey || event.shiftKey) {
	            return;
	        }
	        switch (event.keyCode) {
	            case 13:
	                event.preventDefault();
	                event.stopPropagation();
	                this._triggerActive();
	                break;
	            case 38:
	                event.preventDefault();
	                event.stopPropagation();
	                this._activatePrev('any');
	                break;
	            case 40:
	                event.preventDefault();
	                event.stopPropagation();
	                this._activateNext('any');
	                break;
	        }
	    };
	    /**
	     * Activate the node at the given render index.
	     *
	     * If the node is scrolled out of view, it will be scrolled into
	     * view and aligned according to the `alignTop` parameter.
	     */
	    CommandPalette.prototype._activate = function (index) {
	        // Fetch common variables.
	        var content = this.contentNode;
	        var children = content.children;
	        // Ensure the index is valid.
	        if (index < 0 || index >= children.length) {
	            index = -1;
	        }
	        // Bail if there is no effective change.
	        if (this._activeIndex === index) {
	            return;
	        }
	        // Look up the relevant nodes.
	        var oldNode = children[this._activeIndex];
	        var newNode = children[index];
	        // Update the internal active index.
	        this._activeIndex = index;
	        // Deactivate the old node.
	        if (oldNode) {
	            oldNode.classList.remove(ACTIVE_CLASS);
	        }
	        // Activate the new node and scroll it into view.
	        if (newNode) {
	            newNode.classList.add(ACTIVE_CLASS);
	            requestAnimationFrame(function () {
	                query_1.scrollIntoViewIfNeeded(content, newNode);
	            });
	        }
	    };
	    /**
	     * Activate the next enabled index of the given kind.
	     */
	    CommandPalette.prototype._activateNext = function (kind) {
	        // Bail if there are no current search results.
	        if (!this._result) {
	            return;
	        }
	        // Bail if the search results are empty.
	        var parts = this._result.parts;
	        if (parts.length === 0) {
	            return;
	        }
	        // Activate the next enabled index of the specified kind.
	        var start = this._activeIndex + 1;
	        for (var i = 0, n = parts.length; i < n; ++i) {
	            var k = (start + i) % n;
	            var item = parts[k].item;
	            if (kind === 'item' && item && item.isEnabled) {
	                this._activate(k);
	                return;
	            }
	            if (kind === 'header' && !item) {
	                this._activate(k);
	                return;
	            }
	            if (kind === 'any' && (!item || item.isEnabled)) {
	                this._activate(k);
	                return;
	            }
	        }
	        // Otherwise, deactivate the current item.
	        this._activate(-1);
	    };
	    /**
	     * Activate the previous enabled index of the given kind.
	     */
	    CommandPalette.prototype._activatePrev = function (kind) {
	        // Bail if there are no current search results.
	        if (!this._result) {
	            return;
	        }
	        // Bail if the search results are empty.
	        var parts = this._result.parts;
	        if (parts.length === 0) {
	            return;
	        }
	        // Activate the previous enabled index of the specified kind.
	        var ai = this._activeIndex;
	        var start = ai <= 0 ? parts.length - 1 : ai - 1;
	        for (var i = 0, n = parts.length; i < n; ++i) {
	            var k = (start - i + n) % n;
	            var item = parts[k].item;
	            if (kind === 'item' && item && item.isEnabled) {
	                this._activate(k);
	                return;
	            }
	            if (kind === 'header' && !item) {
	                this._activate(k);
	                return;
	            }
	            if (kind === 'any' && (!item || item.isEnabled)) {
	                this._activate(k);
	                return;
	            }
	        }
	        // Otherwise, deactivate the current item.
	        this._activate(-1);
	    };
	    /**
	     * Trigger the result part at the active index.
	     *
	     * If the part is an enabled command it will be executed. If the
	     * part is a header, the category search term will be toggled.
	     */
	    CommandPalette.prototype._triggerActive = function () {
	        // Bail if there is no search result.
	        if (!this._result) {
	            return;
	        }
	        // Bail if the active index is out of range.
	        var part = this._result.parts[this._activeIndex];
	        if (!part) {
	            return;
	        }
	        // Bail if the part has a disabled item.
	        if (part.item && !part.item.isEnabled) {
	            return;
	        }
	        // Look up the input node.
	        var input = this.inputNode;
	        // If the part has an item, focus the input field, select the
	        // text, and execute the command.
	        if (part.item) {
	            input.focus();
	            input.select();
	            this._commands.execute(part.item.command, part.item.args);
	            return;
	        }
	        // Otherwise, toggle the category text...
	        // Parse the current input value.
	        var _a = CommandPalette.splitQuery(input.value), category = _a.category, text = _a.text;
	        // Extract the raw category text.
	        var desired = part.markup.replace(/<mark>|<\/mark>/g, '');
	        // Create a new query with the toggled category.
	        var computed = desired === category ? '' : desired;
	        var query = CommandPalette.joinQuery(computed, text);
	        // Update the input text and refocus the field.
	        input.value = query;
	        input.focus();
	        // Schedule an update to render the new search results.
	        this.update();
	    };
	    /**
	     * A signal handler for commands and keymap changes.
	     */
	    CommandPalette.prototype._onGenericChange = function () {
	        if (this.isAttached)
	            this.update();
	    };
	    return CommandPalette;
	}(widget_1.Widget));
	exports.CommandPalette = CommandPalette;
	/**
	 * The namespace for the `CommandPalette` class statics.
	 */
	var CommandPalette;
	(function (CommandPalette) {
	    /**
	     * The default implementation of `IRenderer`.
	     */
	    var Renderer = (function () {
	        function Renderer() {
	        }
	        /**
	         * Create a node for a section header.
	         *
	         * @returns A new node for a section header.
	         */
	        Renderer.prototype.createHeaderNode = function () {
	            var node = document.createElement('li');
	            node.className = HEADER_CLASS;
	            return node;
	        };
	        /**
	         * Create a node for a command item.
	         *
	         * @returns A new node for a command item.
	         */
	        Renderer.prototype.createItemNode = function () {
	            var node = document.createElement('li');
	            var label = document.createElement('div');
	            var caption = document.createElement('div');
	            var shortcut = document.createElement('div');
	            node.className = ITEM_CLASS;
	            label.className = LABEL_CLASS;
	            caption.className = CAPTION_CLASS;
	            shortcut.className = SHORTCUT_CLASS;
	            node.appendChild(shortcut); // will float: right
	            node.appendChild(label);
	            node.appendChild(caption);
	            return node;
	        };
	        /**
	         * Update a header node to reflect the given data.
	         *
	         * @param node - A node created by a call to `createHeaderNode`.
	         *
	         * @param markup - The markup for the header text. This is the
	         *   section category text interpolated with `<mark>` tags for
	         *   the matching search characters.
	         */
	        Renderer.prototype.updateHeaderNode = function (node, markup) {
	            node.className = HEADER_CLASS;
	            node.innerHTML = markup;
	        };
	        /**
	         * Update an item node to reflect the state of a command item.
	         *
	         * @param node - A node created by a call to `createItemNode`.
	         *
	         * @param item - The command item holding the data for the node.
	         *
	         * @param markup - The markup for the item label. This is the
	         *   item label text interpolated with `<mark>` tags for the
	         *   matching search characters.
	         */
	        Renderer.prototype.updateItemNode = function (node, item, markup) {
	            // Setup the initial item class.
	            var itemClass = ITEM_CLASS;
	            // Add the boolean states to the item class.
	            //
	            // Note: non-visible items are not rendered by the palette, so
	            // there is no need to check the visibility flag of the item.
	            if (!item.isEnabled) {
	                itemClass += " " + DISABLED_CLASS;
	            }
	            if (item.isToggled) {
	                itemClass += " " + TOGGLED_CLASS;
	            }
	            // Add the extra class name(s) to the item class.
	            var extraItemClass = item.className;
	            if (extraItemClass) {
	                itemClass += " " + extraItemClass;
	            }
	            // Generate the formatted shortcut text.
	            var shortcutText = this.formatShortcut(item.keyBinding);
	            // Extract the relevant child nodes.
	            var shortcut = node.firstChild;
	            var label = shortcut.nextSibling;
	            var caption = label.nextSibling;
	            // Set the command ID in the data set.
	            node.dataset['command'] = item.command;
	            // Update the rest of the node state.
	            node.className = itemClass;
	            label.innerHTML = markup;
	            caption.textContent = item.caption;
	            shortcut.textContent = shortcutText;
	        };
	        /**
	         * Format a key binding into shortcut text for display.
	         *
	         * @param binding - The key binding to format. This may be `null`.
	         *
	         * @returns The formatted shortcut text for display.
	         */
	        Renderer.prototype.formatShortcut = function (binding) {
	            return binding ? binding.keys.map(keymap_1.Keymap.formatKeystroke).join(' ') : '';
	        };
	        return Renderer;
	    }());
	    CommandPalette.Renderer = Renderer;
	    /**
	     * The default `Renderer` instance.
	     */
	    CommandPalette.defaultRenderer = new Renderer();
	    /**
	     * Split a query string into its category and text components.
	     *
	     * @param query - A query string of the form `(:<category>:)?<text>`.
	     *
	     * @returns The `category` and `text` components of the query with
	     *   leading and trailing whitespace removed.
	     */
	    function splitQuery(query) {
	        query = query.trim();
	        var i = query.indexOf(':');
	        if (i === -1) {
	            return { category: '', text: query };
	        }
	        var category = query.slice(0, i).trim();
	        var text = query.slice(i + 1).trim();
	        return { category: category, text: text };
	    }
	    CommandPalette.splitQuery = splitQuery;
	    /**
	     * Join category and text components into a query string.
	     *
	     * @param category - The category for the query or an empty string.
	     *
	     * @param text - The text for the query or an empty string.
	     *
	     * @returns The joined query string for the components.
	     */
	    function joinQuery(category, text) {
	        var query;
	        if (category && text) {
	            query = category.trim() + ": " + text.trim();
	        }
	        else if (category) {
	            query = category.trim() + ": ";
	        }
	        else if (text) {
	            query = text.trim();
	        }
	        else {
	            query = '';
	        }
	        return query;
	    }
	    CommandPalette.joinQuery = joinQuery;
	})(CommandPalette = exports.CommandPalette || (exports.CommandPalette = {}));
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Create the DOM node for a command palette.
	     */
	    function createNode() {
	        var node = document.createElement('div');
	        var search = document.createElement('div');
	        var wrapper = document.createElement('div');
	        var input = document.createElement('input');
	        var content = document.createElement('ul');
	        search.className = SEARCH_CLASS;
	        wrapper.className = WRAPPER_CLASS;
	        input.className = INPUT_CLASS;
	        content.className = CONTENT_CLASS;
	        input.spellcheck = false;
	        wrapper.appendChild(input);
	        search.appendChild(wrapper);
	        node.appendChild(search);
	        node.appendChild(content);
	        return node;
	    }
	    Private.createNode = createNode;
	    /**
	     * Create a new command item from a keymap, commands, and options.
	     */
	    function createItem(commands, keymap, options) {
	        return new CommandItem(commands, keymap, options);
	    }
	    Private.createItem = createItem;
	    /**
	     * Search the a sequence of command items for fuzzy matches.
	     *
	     * @param category - The category to match against the command items.
	     *   If this is an empty string, all item categories will be matched.
	     *
	     * @param text - The text to match against the command items.
	     *   If this is an empty string, all items will be matched.
	     *
	     * @returns The result of the search.
	     */
	    function search(items, category, text) {
	        // Collect a mapping of the matching categories. The mapping will
	        // only contain categories which match the provided query text.
	        // If the category is an empty string, all categories will be
	        // matched with a score of `0` and a `null` indices array.
	        var catmap = matchCategory(items, category);
	        // Filter the items for matching labels. Only items which have a
	        // category in the given map are considered. The category score
	        // is added to the label score to create the final item score.
	        // If the text is an empty string, all items will be matched
	        // with a label score of `0` and `null` indices array.
	        var scores = matchLabel(items, text, catmap);
	        // Sort the items based on their total item score. Ties are
	        // broken by locale order of the category followed by label.
	        scores.sort(scoreCmp);
	        // Group the item scores by category. The categories are added
	        // to the map in the order they appear in the scores array.
	        var groups = groupScores(scores);
	        // Return the result for the search. The headers are created in
	        // the order of key iteration of the map. On all major browsers,
	        // this is insertion order. This means that headers are created
	        // in the order of first appearance in the sorted scores array.
	        return createSearchResult(groups, catmap);
	    }
	    Private.search = search;
	    /**
	     * A concrete implementation of `CommandPalette.IItem`.
	     */
	    var CommandItem = (function () {
	        /**
	         * Construct a new command item.
	         */
	        function CommandItem(commands, keymap, options) {
	            this._commands = commands;
	            this._keymap = keymap;
	            this._command = options.command;
	            this._args = options.args || null;
	            this._category = normalizeCategory(options.category || 'general');
	        }
	        Object.defineProperty(CommandItem.prototype, "command", {
	            /**
	             * The command to execute when the item is triggered.
	             */
	            get: function () {
	                return this._command;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(CommandItem.prototype, "args", {
	            /**
	             * The arguments for the command.
	             */
	            get: function () {
	                return this._args;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(CommandItem.prototype, "category", {
	            /**
	             * The category for the command item.
	             */
	            get: function () {
	                return this._category;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(CommandItem.prototype, "label", {
	            /**
	             * The display label for the command item.
	             */
	            get: function () {
	                return this._commands.label(this._command, this._args);
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(CommandItem.prototype, "caption", {
	            /**
	             * The display caption for the command item.
	             */
	            get: function () {
	                return this._commands.caption(this._command, this._args);
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(CommandItem.prototype, "className", {
	            /**
	             * The extra class name for the command item.
	             */
	            get: function () {
	                return this._commands.className(this._command, this._args);
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(CommandItem.prototype, "isEnabled", {
	            /**
	             * Whether the command item is enabled.
	             */
	            get: function () {
	                return this._commands.isEnabled(this._command, this._args);
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(CommandItem.prototype, "isToggled", {
	            /**
	             * Whether the command item is toggled.
	             */
	            get: function () {
	                return this._commands.isToggled(this._command, this._args);
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(CommandItem.prototype, "isVisible", {
	            /**
	             * Whether the command item is visible.
	             */
	            get: function () {
	                return this._commands.isVisible(this._command, this._args);
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(CommandItem.prototype, "keyBinding", {
	            /**
	             * The key binding for the command item.
	             */
	            get: function () {
	                return this._keymap.findBinding(this._command, this._args);
	            },
	            enumerable: true,
	            configurable: true
	        });
	        return CommandItem;
	    }());
	    /**
	     * Normalize a category for a command item.
	     */
	    function normalizeCategory(category) {
	        return category.trim().replace(/\s+/g, ' ').toLowerCase();
	    }
	    /**
	     * Normalize the query text for a command item.
	     *
	     * @param text - The category or text portion of a query.
	     *
	     * @returns The normalized query text.
	     *
	     * #### Notes
	     * The text is normalized by converting to lower case and removing
	     * all whitespace.
	     */
	    function normalizeQueryText(text) {
	        return text.replace(/\s+/g, '').toLowerCase();
	    }
	    /**
	     * Collect a mapping of the categories which match the given query.
	     *
	     * @param items - The command items to search.
	     *
	     * @param query - The category portion of the query.
	     *
	     * @returns A mapping of matched category to match score.
	     *
	     * #### Notes
	     * The query string will be normalized by lower casing and removing
	     * all whitespace. If the normalized query is an empty string, all
	     * categories will be matched with a `0` score and `null` indices.
	     *
	     * Non-visible items will be ignored.
	     */
	    function matchCategory(items, query) {
	        // Normalize the query text to lower case with no whitespace.
	        query = normalizeQueryText(query);
	        // Create the maps needed to track the match state.
	        var seen = Object.create(null);
	        var matched = Object.create(null);
	        // Iterate over the items and match the categories.
	        for (var i = 0, n = items.length; i < n; ++i) {
	            // Ignore items which are not visible.
	            var item = items.at(i);
	            if (!item.isVisible) {
	                continue;
	            }
	            // If a category has already been seen, no more work is needed.
	            var category = item.category;
	            if (category in seen) {
	                continue;
	            }
	            // Mark the category as seen so it is only processed once.
	            seen[category] = true;
	            // If the query is empty, all categories match by default.
	            if (!query) {
	                matched[category] = { score: 0, indices: null };
	                continue;
	            }
	            // Run the matcher for the query and skip if no match.
	            var match = searching_1.StringSearch.sumOfSquares(category, query);
	            if (!match) {
	                continue;
	            }
	            // Store the match score in the results.
	            matched[category] = match;
	        }
	        // Return the final mapping of matched categories.
	        return matched;
	    }
	    /**
	     * Filter command items for those with matching label and category.
	     *
	     * @param items - The command items to search.
	     *
	     * @param query - The text portion of the query.
	     *
	     * @param categories - A mapping of the valid item categories.
	     *
	     * @returns An array of item scores for the matching items.
	     *
	     * #### Notes
	     * The query string will be normalized by lower casing and removing
	     * all whitespace. If the normalized query is an empty string, all
	     * items will be matched with a `0` label score and `null` indices.
	     *
	     * Items which have a category which is not present in the category
	     * map will be ignored.
	     *
	     * Non-visible items will be ignored.
	     *
	     * The final item score is the sum of the item label score and the
	     * relevant category score.
	     */
	    function matchLabel(items, query, categories) {
	        // Normalize the query text to lower case with no whitespace.
	        query = normalizeQueryText(query);
	        // Create the array to hold the resulting scores.
	        var scores = [];
	        // Iterate over the items and match the text with the query.
	        for (var i = 0, n = items.length; i < n; ++i) {
	            // Ignore items which are not visible.
	            var item = items.at(i);
	            if (!item.isVisible) {
	                continue;
	            }
	            // Look up the category score for the item category.
	            var cs = categories[item.category];
	            // If the category was not matched, the item is skipped.
	            if (!cs) {
	                continue;
	            }
	            // If the query is empty, all items are matched by default.
	            if (!query) {
	                scores.push({ score: cs.score, indices: null, item: item });
	                continue;
	            }
	            // Run the matcher for the query and skip if no match.
	            var match = searching_1.StringSearch.sumOfSquares(item.label.toLowerCase(), query);
	            if (!match) {
	                continue;
	            }
	            // Create the match score for the item.
	            var score = cs.score + match.score;
	            scores.push({ score: score, indices: match.indices, item: item });
	        }
	        // Return the final array of matched item scores.
	        return scores;
	    }
	    /**
	     * A sort comparison function for a command item match score.
	     *
	     * This orders the items first based on score (lower is better), then
	     * by locale order of the item category followed by the item text.
	     */
	    function scoreCmp(a, b) {
	        var d1 = a.score - b.score;
	        if (d1 !== 0) {
	            return d1;
	        }
	        var d2 = a.item.category.localeCompare(b.item.category);
	        if (d2 !== 0) {
	            return d2;
	        }
	        return a.item.label.localeCompare(b.item.label);
	    }
	    /**
	     * Group item scores by item category.
	     *
	     * @param scores - The items to group by category.
	     *
	     * @returns A mapping of category name to group of items.
	     *
	     * #### Notes
	     * The categories are added to the map in the order of first
	     * appearance in the `scores` array.
	     */
	    function groupScores(scores) {
	        var result = Object.create(null);
	        for (var _i = 0, scores_1 = scores; _i < scores_1.length; _i++) {
	            var score = scores_1[_i];
	            var cat = score.item.category;
	            (result[cat] || (result[cat] = [])).push(score);
	        }
	        return result;
	    }
	    /**
	     * Create the search results for a collection of item scores.
	     *
	     * @param groups - The item scores, grouped by category.
	     *
	     * @param categories - A mapping of category scores.
	     *
	     * @returns New search results for the given scores.
	     *
	     * #### Notes
	     * This function renders the groups in iteration order, which on
	     * all major browsers is the order of insertion (by convention).
	     */
	    function createSearchResult(groups, categories) {
	        var itemCount = 0;
	        var headerCount = 0;
	        var parts = [];
	        for (var cat in groups) {
	            headerCount++;
	            parts.push(createHeaderPart(cat, categories[cat]));
	            for (var _i = 0, _a = groups[cat]; _i < _a.length; _i++) {
	                var score = _a[_i];
	                itemCount++;
	                parts.push(createItemPart(score));
	            }
	        }
	        return { itemCount: itemCount, headerCount: headerCount, parts: parts };
	    }
	    /**
	     * Create a header result part for the given data.
	     *
	     * @param category - The category name for the header.
	     *
	     * @param score - The score for the category match.
	     *
	     * @returns A header result part for the given data.
	     */
	    function createHeaderPart(category, score) {
	        var markup = highlightText(category, score.indices);
	        return { markup: markup, item: null };
	    }
	    /**
	     * Create an item result part for the given data.
	     *
	     * @param score - The score for the item match.
	     *
	     * @returns An item result part for the given data.
	     */
	    function createItemPart(score) {
	        var markup = highlightText(score.item.label, score.indices);
	        return { markup: markup, item: score.item };
	    }
	    /**
	     * Highlight the matching character of the given text.
	     *
	     * @param text - The text to highlight.
	     *
	     * @param indices - The character indices to highlight, or `null`.
	     *
	     * @returns The text interpolated with `<mark>` tags as needed.
	     */
	    function highlightText(text, indices) {
	        return indices ? searching_1.StringSearch.highlight(text, indices) : text;
	    }
	})(Private || (Private = {}));


/***/ },
/* 125 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var focustracker_1 = __webpack_require__(33);
	var menu_1 = __webpack_require__(126);
	var commandpalette_1 = __webpack_require__(118);
	var docregistry_1 = __webpack_require__(127);
	var inspector_1 = __webpack_require__(135);
	var mainmenu_1 = __webpack_require__(139);
	var rendermime_1 = __webpack_require__(141);
	var services_1 = __webpack_require__(142);
	var _1 = __webpack_require__(143);
	/**
	 * The console extension.
	 */
	exports.consoleExtension = {
	    id: 'jupyter.extensions.console',
	    requires: [
	        services_1.IServiceManager,
	        rendermime_1.IRenderMime,
	        mainmenu_1.IMainMenu,
	        inspector_1.IInspector,
	        commandpalette_1.ICommandPalette,
	        _1.ConsoleWidget.IRenderer
	    ],
	    activate: activateConsole,
	    autoStart: true
	};
	/**
	 * The class name for all main area landscape tab icons.
	 */
	var LANDSCAPE_ICON_CLASS = 'jp-MainAreaLandscapeIcon';
	/**
	 * The class name for the console icon from the default theme.
	 */
	var CONSOLE_ICON_CLASS = 'jp-ImageConsole';
	/**
	 * Activate the console extension.
	 */
	function activateConsole(app, services, rendermime, mainMenu, inspector, palette, renderer) {
	    var tracker = new focustracker_1.FocusTracker();
	    var manager = services.sessions;
	    var commands = app.commands, keymap = app.keymap;
	    var category = 'Console';
	    var menu = new menu_1.Menu({ commands: commands, keymap: keymap });
	    menu.title.label = 'Console';
	    var submenu = null;
	    var command;
	    // Set the source of the code inspector to the current console.
	    tracker.currentChanged.connect(function (sender, args) {
	        if (args.newValue) {
	            inspector.source = args.newValue.content.inspectionHandler;
	        }
	        else {
	            inspector.source = null;
	        }
	    });
	    // Set the main menu title.
	    menu.title.label = 'Console';
	    // Add the ability to create new consoles for each kernel.
	    var specs = services.kernelspecs;
	    var displayNameMap = Object.create(null);
	    for (var kernelName in specs.kernelspecs) {
	        var displayName = specs.kernelspecs[kernelName].spec.display_name;
	        displayNameMap[displayName] = kernelName;
	    }
	    var displayNames = Object.keys(displayNameMap).sort(function (a, b) {
	        return a.localeCompare(b);
	    });
	    var count = 0;
	    // If there are available kernels, populate the "New" menu item.
	    if (displayNames.length) {
	        submenu = new menu_1.Menu({ commands: commands, keymap: keymap });
	        submenu.title.label = 'New';
	        menu.addItem({ type: 'submenu', menu: submenu });
	    }
	    var _loop_1 = function(displayName) {
	        command = "console:create-" + displayNameMap[displayName];
	        commands.addCommand(command, {
	            label: displayName + " console",
	            execute: function () {
	                var path = "Console-" + count++;
	                var kernelName = "" + displayNameMap[displayName];
	                manager.startNew({ path: path, kernelName: kernelName }).then(function (session) {
	                    var panel = new _1.ConsolePanel({
	                        session: session,
	                        rendermime: rendermime.clone(),
	                        renderer: renderer
	                    });
	                    panel.id = "console-" + count;
	                    panel.title.label = displayName + " (" + count + ")";
	                    panel.title.icon = LANDSCAPE_ICON_CLASS + " " + CONSOLE_ICON_CLASS;
	                    panel.title.closable = true;
	                    app.shell.addToMainArea(panel);
	                    tracker.add(panel);
	                });
	            }
	        });
	        palette.addItem({ command: command, category: category });
	        submenu.addItem({ command: command });
	    };
	    for (var _i = 0, displayNames_1 = displayNames; _i < displayNames_1.length; _i++) {
	        var displayName = displayNames_1[_i];
	        _loop_1(displayName);
	    }
	    command = 'console:clear';
	    commands.addCommand(command, {
	        label: 'Clear Cells',
	        execute: function () {
	            if (tracker.currentWidget) {
	                tracker.currentWidget.content.clear();
	            }
	        }
	    });
	    palette.addItem({ command: command, category: category });
	    menu.addItem({ command: command });
	    command = 'console:dismiss-completion';
	    commands.addCommand(command, {
	        execute: function () {
	            if (tracker.currentWidget) {
	                tracker.currentWidget.content.dismissCompletion();
	            }
	        }
	    });
	    command = 'console:execute';
	    commands.addCommand(command, {
	        label: 'Execute Cell',
	        execute: function () {
	            if (tracker.currentWidget) {
	                tracker.currentWidget.content.execute();
	            }
	        }
	    });
	    palette.addItem({ command: command, category: category });
	    menu.addItem({ command: command });
	    command = 'console:interrupt-kernel';
	    commands.addCommand(command, {
	        label: 'Interrupt Kernel',
	        execute: function () {
	            if (tracker.currentWidget) {
	                var kernel = tracker.currentWidget.content.session.kernel;
	                if (kernel) {
	                    kernel.interrupt();
	                }
	            }
	        }
	    });
	    palette.addItem({ command: command, category: category });
	    menu.addItem({ command: command });
	    command = 'console:switch-kernel';
	    commands.addCommand(command, {
	        label: 'Switch Kernel',
	        execute: function () {
	            if (!tracker.currentWidget) {
	                return;
	            }
	            var widget = tracker.currentWidget.content;
	            var session = widget.session;
	            var lang = '';
	            if (session.kernel) {
	                lang = specs.kernelspecs[session.kernel.name].spec.language;
	            }
	            manager.listRunning().then(function (sessions) {
	                var options = {
	                    name: widget.parent.title.label,
	                    specs: specs,
	                    sessions: sessions,
	                    preferredLanguage: lang,
	                    kernel: session.kernel.model,
	                    host: widget.parent.node
	                };
	                return docregistry_1.selectKernel(options);
	            }).then(function (kernelId) {
	                if (kernelId) {
	                    session.changeKernel(kernelId);
	                }
	                else {
	                    session.kernel.shutdown();
	                }
	            });
	        }
	    });
	    palette.addItem({ command: command, category: category });
	    menu.addItem({ command: command });
	    mainMenu.addMenu(menu, { rank: 50 });
	}


/***/ },
/* 126 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var searching_1 = __webpack_require__(11);
	var vector_1 = __webpack_require__(13);
	var messaging_1 = __webpack_require__(18);
	var signaling_1 = __webpack_require__(6);
	var query_1 = __webpack_require__(32);
	var sizing_1 = __webpack_require__(25);
	var keymap_1 = __webpack_require__(9);
	var widget_1 = __webpack_require__(17);
	/**
	 * The class name added to Menu instances.
	 */
	var MENU_CLASS = 'p-Menu';
	/**
	 * The class name added to a menu content node.
	 */
	var CONTENT_CLASS = 'p-Menu-content';
	/**
	 * The class name added to a menu item node.
	 */
	var ITEM_CLASS = 'p-Menu-item';
	/**
	 * The class name added to a menu item icon node.
	 */
	var ICON_CLASS = 'p-Menu-itemIcon';
	/**
	 * The class name added to a menu item label node.
	 */
	var LABEL_CLASS = 'p-Menu-itemLabel';
	/**
	 * The class name added to a menu item mnemonic node.
	 */
	var MNEMONIC_CLASS = 'p-Menu-itemMnemonic';
	/**
	 * The class name added to a menu item shortcut node.
	 */
	var SHORTCUT_CLASS = 'p-Menu-itemShortcut';
	/**
	 * The class name added to a menu item submenu icon node.
	 */
	var SUBMENU_ICON_CLASS = 'p-Menu-itemSubmenuIcon';
	/**
	 * The class name added to a `'command'` type menu item.
	 */
	var COMMAND_TYPE_CLASS = 'p-type-command';
	/**
	 * The class name added to a `'separator'` type menu item.
	 */
	var SEPARATOR_TYPE_CLASS = 'p-type-separator';
	/**
	 * The class name added to a `'submenu'` type menu item.
	 */
	var SUBMENU_TYPE_CLASS = 'p-type-submenu';
	/**
	 * The class name added to active menu items.
	 */
	var ACTIVE_CLASS = 'p-mod-active';
	/**
	 * The class name added to a disabled menu item.
	 */
	var DISABLED_CLASS = 'p-mod-disabled';
	/**
	 * The class name added to a toggled menu item.
	 */
	var TOGGLED_CLASS = 'p-mod-toggled';
	/**
	 * The class name added to a hidden menu item.
	 */
	var HIDDEN_CLASS = 'p-mod-hidden';
	/**
	 * The ms delay for opening and closing a submenu.
	 */
	var TIMER_DELAY = 300;
	/**
	 * The horizontal pixel overlap for an open submenu.
	 */
	var SUBMENU_OVERLAP = 3;
	/**
	 * A widget which displays menu items as a canonical menu.
	 */
	var Menu = (function (_super) {
	    __extends(Menu, _super);
	    /**
	     * Construct a new menu.
	     *
	     * @param options - The options for initializing the menu.
	     */
	    function Menu(options) {
	        _super.call(this, { node: Private.createNode() });
	        this._childIndex = -1;
	        this._openTimerID = 0;
	        this._closeTimerID = 0;
	        this._activeIndex = -1;
	        this._childMenu = null;
	        this._parentMenu = null;
	        this._items = new vector_1.Vector();
	        this._nodes = new vector_1.Vector();
	        this.addClass(MENU_CLASS);
	        this.setFlag(widget_1.WidgetFlag.DisallowLayout);
	        this._keymap = options.keymap;
	        this._commands = options.commands;
	        this._renderer = options.renderer || Menu.defaultRenderer;
	    }
	    /**
	     * Dispose of the resources held by the menu.
	     */
	    Menu.prototype.dispose = function () {
	        this.close();
	        this._items.clear();
	        this._nodes.clear();
	        this._keymap = null;
	        this._commands = null;
	        this._renderer = null;
	        _super.prototype.dispose.call(this);
	    };
	    Object.defineProperty(Menu.prototype, "parentMenu", {
	        /**
	         * Get the parent menu of the menu.
	         *
	         * #### Notes
	         * This will be `null` if the menu is not an open submenu.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._parentMenu;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Menu.prototype, "childMenu", {
	        /**
	         * Get the child menu of the menu.
	         *
	         * #### Notes
	         * This will be `null` if the menu does not have an open submenu.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._childMenu;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Menu.prototype, "rootMenu", {
	        /**
	         * Find the root menu of this menu hierarchy.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            var menu = this;
	            while (menu._parentMenu) {
	                menu = menu._parentMenu;
	            }
	            return menu;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Menu.prototype, "leafMenu", {
	        /**
	         * Find the leaf menu of this menu hierarchy.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            var menu = this;
	            while (menu._childMenu) {
	                menu = menu._childMenu;
	            }
	            return menu;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Menu.prototype, "contentNode", {
	        /**
	         * Get the menu content node.
	         *
	         * #### Notes
	         * This is the node which holds the menu item nodes.
	         *
	         * Modifying this node directly can lead to undefined behavior.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.node.getElementsByClassName(CONTENT_CLASS)[0];
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Menu.prototype, "commands", {
	        /**
	         * The command registry used by the menu.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._commands;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Menu.prototype, "keymap", {
	        /**
	         * The keymap used by the menu.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._keymap;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Menu.prototype, "renderer", {
	        /**
	         * The renderer used by the menu.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._renderer;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Menu.prototype, "items", {
	        /**
	         * A read-only sequence of the menu items in the menu.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._items;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Menu.prototype, "activeItem", {
	        /**
	         * Get the currently active menu item.
	         *
	         * #### Notes
	         * This will be `null` if no menu item is active.
	         */
	        get: function () {
	            var i = this._activeIndex;
	            return i !== -1 ? this._items.at(i) : null;
	        },
	        /**
	         * Set the currently active menu item.
	         *
	         * #### Notes
	         * If the item cannot be activated, the item will be set to `null`.
	         */
	        set: function (value) {
	            this.activeIndex = searching_1.indexOf(this._items, value);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Menu.prototype, "activeIndex", {
	        /**
	         * Get the index of the currently active menu item.
	         *
	         * #### Notes
	         * This will be `-1` if no menu item is active.
	         */
	        get: function () {
	            return this._activeIndex;
	        },
	        /**
	         * Set the index of the currently active menu item.
	         *
	         * #### Notes
	         * If the item cannot be activated, the index will be set to `-1`.
	         */
	        set: function (value) {
	            // Coerce the value to an index.
	            var i = Math.floor(value);
	            if (i < 0 || i >= this._items.length) {
	                i = -1;
	            }
	            // Ensure the item can be activated.
	            if (i !== -1) {
	                var item = this._items.at(i);
	                if (item.type === 'separator' || !item.isEnabled || !item.isVisible) {
	                    i = -1;
	                }
	            }
	            // Bail early if the index will not change.
	            if (this._activeIndex === i) {
	                return;
	            }
	            // Remove the active class from the old node.
	            if (this._activeIndex !== -1) {
	                var node = this._nodes.at(this._activeIndex);
	                node.classList.remove(ACTIVE_CLASS);
	            }
	            // Add the active class to the new node.
	            if (i !== -1) {
	                var node = this._nodes.at(i);
	                node.classList.add(ACTIVE_CLASS);
	            }
	            // Update the active index.
	            this._activeIndex = i;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Activate the next selectable item in the menu.
	     *
	     * #### Notes
	     * If no item is selectable, the index will be set to `-1`.
	     */
	    Menu.prototype.activateNextItem = function () {
	        var n = this._items.length;
	        var j = this._activeIndex + 1;
	        for (var i = 0; i < n; ++i) {
	            var k = (i + j) % n;
	            var item = this._items.at(k);
	            if (item.type !== 'separator' && item.isEnabled && item.isVisible) {
	                this.activeIndex = k;
	                return;
	            }
	        }
	        this.activeIndex = -1;
	    };
	    /**
	     * Activate the previous selectable item in the menu.
	     *
	     * #### Notes
	     * If no item is selectable, the index will be set to `-1`.
	     */
	    Menu.prototype.activatePreviousItem = function () {
	        var n = this._items.length;
	        var ai = this._activeIndex;
	        var j = ai <= 0 ? n - 1 : ai - 1;
	        for (var i = 0; i < n; ++i) {
	            var k = (j - i + n) % n;
	            var item = this._items.at(k);
	            if (item.type !== 'separator' && item.isEnabled && item.isVisible) {
	                this.activeIndex = k;
	                return;
	            }
	        }
	        this.activeIndex = -1;
	    };
	    /**
	     * Trigger the active menu item.
	     *
	     * #### Notes
	     * If the active item is a submenu, it will be opened and the first
	     * item will be activated.
	     *
	     * If the active item is a command, the command will be executed.
	     *
	     * If the menu is not attached, this is a no-op.
	     *
	     * If there is no active item, this is a no-op.
	     */
	    Menu.prototype.triggerActiveItem = function () {
	        // Bail if the menu is not attached.
	        if (!this.isAttached) {
	            return;
	        }
	        // Bail if there is no active item.
	        var item = this.activeItem;
	        if (!item) {
	            return;
	        }
	        // Cancel the pending timers.
	        this._cancelOpenTimer();
	        this._cancelCloseTimer();
	        // If the item is a submenu, open it.
	        if (item.type === 'submenu') {
	            this._openChildMenu(true);
	            return;
	        }
	        // Close the root menu before executing the command.
	        this.rootMenu.close();
	        // Execute the command for the item.
	        var command = item.command, args = item.args;
	        if (this._commands.isEnabled(command, args)) {
	            this._commands.execute(command, args);
	        }
	        else {
	            // TODO - is this the right logging here?
	            console.log("Command '" + command + "' is disabled.");
	        }
	    };
	    /**
	     * Add a menu item to the end of the menu.
	     *
	     * @param options - The options for creating the menu item.
	     *
	     * @returns The menu item added to the menu.
	     */
	    Menu.prototype.addItem = function (options) {
	        return this.insertItem(this._items.length, options);
	    };
	    /**
	     * Insert a menu item into the menu at the specified index.
	     *
	     * @param index - The index at which to insert the item.
	     *
	     * @param options - The options for creating the menu item.
	     *
	     * @returns The menu item added to the menu.
	     *
	     * #### Notes
	     * The index will be clamped to the bounds of the items.
	     */
	    Menu.prototype.insertItem = function (index, options) {
	        // Close the menu if it's attached.
	        if (this.isAttached) {
	            this.close();
	        }
	        // Reset the active index.
	        this.activeIndex = -1;
	        // Clamp the insert index to the vector bounds.
	        var i = Math.max(0, Math.min(Math.floor(index), this._items.length));
	        // Create the item for the options.
	        var item = Private.createItem(this._commands, this._keymap, options);
	        // Create the node for the item. It will be initialized on open.
	        var node = this._renderer.createItemNode();
	        // Insert the item and node into the vectors.
	        this._items.insert(i, item);
	        this._nodes.insert(i, node);
	        // Look up the next sibling node.
	        var ref = i + 1 < this._nodes.length ? this._nodes.at(i + 1) : null;
	        // Insert the node into the content node.
	        this.contentNode.insertBefore(node, ref);
	        // Return the item added to the menu.
	        return item;
	    };
	    /**
	     * Remove an item from the menu.
	     *
	     * @param item - The item to remove from the menu.
	     *
	     * @returns The index occupied by the item, or `-1` if the item
	     *   was not contained in the menu.
	     */
	    Menu.prototype.removeItem = function (item) {
	        var index = searching_1.indexOf(this._items, item);
	        if (index !== -1)
	            this.removeItemAt(index);
	        return index;
	    };
	    /**
	     * Remove the item at a given index from the menu.
	     *
	     * @param index - The index of the item to remove.
	     *
	     * @returns The item occupying the index, or `null` if the index
	     *   is out of range.
	     */
	    Menu.prototype.removeItemAt = function (index) {
	        // Bail if the index is out of range.
	        var i = Math.floor(index);
	        if (i < 0 || i >= this._items.length) {
	            return null;
	        }
	        // Close the menu if it's attached.
	        if (this.isAttached) {
	            this.close();
	        }
	        // Reset the active index.
	        this.activeIndex = -1;
	        // Remove the node and items from the vectors.
	        var node = this._nodes.removeAt(i);
	        var item = this._items.removeAt(i);
	        // Remove the node from the content node.
	        this.contentNode.removeChild(node);
	        // Return the removed item.
	        return item;
	    };
	    /**
	     * Remove all menu items from the menu.
	     */
	    Menu.prototype.clearItems = function () {
	        // Close the menu if it's attached.
	        if (this.isAttached) {
	            this.close();
	        }
	        // Reset the active index.
	        this.activeIndex = -1;
	        // Clear the item and node vectors.
	        this._items.clear();
	        this._nodes.clear();
	        // Clear the content node.
	        this.contentNode.textContent = '';
	    };
	    /**
	     * Open the menu at the specified location.
	     *
	     * @param x - The client X coordinate of the menu location.
	     *
	     * @param y - The client Y coordinate of the menu location.
	     *
	     * @param options - The additional options for opening the menu.
	     *
	     * #### Notes
	     * The menu will be opened at the given location unless it will not
	     * fully fit on the screen. If it will not fit, it will be adjusted
	     * to fit naturally on the screen.
	     *
	     * This is a no-op if the menu is already attached to the DOM.
	     */
	    Menu.prototype.open = function (x, y, options) {
	        if (options === void 0) { options = {}; }
	        // Bail early if the menu is already attached.
	        if (this.isAttached) {
	            return;
	        }
	        // Extract the position options.
	        var forceX = options.forceX || false;
	        var forceY = options.forceY || false;
	        // Open the menu as a root menu.
	        Private.openRootMenu(this, x, y, forceX, forceY);
	        // Activate the menu to accept keyboard input.
	        this.activate();
	    };
	    /**
	     * Handle the DOM events for the menu.
	     *
	     * @param event - The DOM event sent to the menu.
	     *
	     * #### Notes
	     * This method implements the DOM `EventListener` interface and is
	     * called in response to events on the menu's DOM nodes. It should
	     * not be called directly by user code.
	     */
	    Menu.prototype.handleEvent = function (event) {
	        switch (event.type) {
	            case 'keydown':
	                this._evtKeyDown(event);
	                break;
	            case 'mouseup':
	                this._evtMouseUp(event);
	                break;
	            case 'mousemove':
	                this._evtMouseMove(event);
	                break;
	            case 'mouseenter':
	                this._evtMouseEnter(event);
	                break;
	            case 'mouseleave':
	                this._evtMouseLeave(event);
	                break;
	            case 'mousedown':
	                this._evtMouseDown(event);
	                break;
	            case 'contextmenu':
	                event.preventDefault();
	                event.stopPropagation();
	                break;
	        }
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     */
	    Menu.prototype.onAfterAttach = function (msg) {
	        this.node.addEventListener('keydown', this);
	        this.node.addEventListener('mouseup', this);
	        this.node.addEventListener('mousemove', this);
	        this.node.addEventListener('mouseenter', this);
	        this.node.addEventListener('mouseleave', this);
	        this.node.addEventListener('contextmenu', this);
	        document.addEventListener('mousedown', this, true);
	    };
	    /**
	     * A message handler invoked on a `'before-detach'` message.
	     */
	    Menu.prototype.onBeforeDetach = function (msg) {
	        this.node.removeEventListener('keydown', this);
	        this.node.removeEventListener('mouseup', this);
	        this.node.removeEventListener('mousemove', this);
	        this.node.removeEventListener('mouseenter', this);
	        this.node.removeEventListener('mouseleave', this);
	        this.node.removeEventListener('contextmenu', this);
	        document.removeEventListener('mousedown', this, true);
	    };
	    /**
	     * A message handler invoked on an `'activate-request'` message.
	     */
	    Menu.prototype.onActivateRequest = function (msg) {
	        if (this.isAttached)
	            this.node.focus();
	    };
	    /**
	     * A message handler invoked on a `'deactivate-request'` message.
	     */
	    Menu.prototype.onDeactivateRequest = function (msg) {
	        if (this.isAttached)
	            this.node.blur();
	    };
	    /**
	     * A message handler invoked on an `'update-request'` message.
	     */
	    Menu.prototype.onUpdateRequest = function (msg) {
	        // TODO - currently, an 'update-request' message is sent to a menu
	        // just before it is opened. This ensures it is current when shown
	        // without needing to subscribe to any commands or keymap signals.
	        // Often, the update will be unnecessary. If it becomes an issue
	        // for performance, the menu can maintain a dirty flag.
	        // Fetch common variables.
	        var items = this._items;
	        var nodes = this._nodes;
	        var renderer = this._renderer;
	        // Update the state of the item nodes.
	        for (var i = 0, n = items.length; i < n; ++i) {
	            renderer.updateItemNode(nodes.at(i), items.at(i));
	        }
	        // Add the active class to the active item.
	        if (this._activeIndex !== -1) {
	            nodes.at(this._activeIndex).classList.add(ACTIVE_CLASS);
	        }
	        // Hide the extra separator nodes.
	        Private.hideExtraSeparators(nodes, items);
	    };
	    /**
	     * A message handler invoked on a `'close-request'` message.
	     */
	    Menu.prototype.onCloseRequest = function (msg) {
	        // Cancel the pending timers.
	        this._cancelOpenTimer();
	        this._cancelCloseTimer();
	        // Reset the active index.
	        this.activeIndex = -1;
	        // Close any open child menu.
	        var childMenu = this._childMenu;
	        if (childMenu) {
	            this._childIndex = -1;
	            this._childMenu = null;
	            childMenu._parentMenu = null;
	            childMenu.close();
	        }
	        // Remove this menu from its parent and activate the parent.
	        var parentMenu = this._parentMenu;
	        if (parentMenu) {
	            this._parentMenu = null;
	            parentMenu._cancelOpenTimer();
	            parentMenu._cancelCloseTimer();
	            parentMenu._childIndex = -1;
	            parentMenu._childMenu = null;
	            parentMenu.activate();
	        }
	        // Emit the `aboutToClose` signal if the menu is attached.
	        if (this.isAttached) {
	            this.aboutToClose.emit(void 0);
	        }
	        // Finish closing the menu.
	        _super.prototype.onCloseRequest.call(this, msg);
	    };
	    /**
	     * Handle the `'keydown'` event for the menu.
	     *
	     * #### Notes
	     * This listener is attached to the menu node.
	     */
	    Menu.prototype._evtKeyDown = function (event) {
	        // A menu handles all keydown events.
	        event.preventDefault();
	        event.stopPropagation();
	        // Fetch the key code for the event.
	        var kc = event.keyCode;
	        // Enter
	        if (kc === 13) {
	            this.triggerActiveItem();
	            return;
	        }
	        // Escape
	        if (kc === 27) {
	            this.close();
	            return;
	        }
	        // Left Arrow
	        if (kc === 37) {
	            if (this._parentMenu) {
	                this.close();
	            }
	            else {
	                this.menuRequested.emit('previous');
	            }
	            return;
	        }
	        // Up Arrow
	        if (kc === 38) {
	            this.activatePreviousItem();
	            return;
	        }
	        // Right Arrow
	        if (kc === 39) {
	            var item = this.activeItem;
	            if (item && item.type === 'submenu') {
	                this.triggerActiveItem();
	            }
	            else {
	                this.rootMenu.menuRequested.emit('next');
	            }
	            return;
	        }
	        // Down Arrow
	        if (kc === 40) {
	            this.activateNextItem();
	            return;
	        }
	        // The following code activates an item by mnemonic.
	        // Get the pressed key character for the current layout.
	        var key = this._keymap.layout.keyForKeydownEvent(event);
	        // Bail if the key is not valid for the current layout.
	        if (!key) {
	            return;
	        }
	        // Normalize the case of the key.
	        key = key.toUpperCase();
	        // Setup the storage for the search results.
	        var mnIndex = -1;
	        var autoIndex = -1;
	        var mnMultiple = false;
	        // Search for the best mnemonic item. This searches the menu items
	        // starting at the active index and finds the following:
	        //   - the index of the first matching mnemonic item
	        //   - whether there are multiple matching mnemonic items
	        //   - the index of the first item with no mnemonic, but
	        //     which has a matching first character
	        var n = this._items.length;
	        var j = this._activeIndex + 1;
	        for (var i = 0; i < n; ++i) {
	            var k = (i + j) % n;
	            var item = this._items.at(k);
	            if (item.type === 'separator' || !item.isEnabled || !item.isVisible) {
	                continue;
	            }
	            var label = item.label;
	            if (label.length === 0) {
	                continue;
	            }
	            var mn = item.mnemonic;
	            if (mn >= 0 && mn < label.length) {
	                if (label[mn].toUpperCase() === key) {
	                    if (mnIndex === -1) {
	                        mnIndex = k;
	                    }
	                    else {
	                        mnMultiple = true;
	                    }
	                }
	            }
	            else if (autoIndex === -1) {
	                if (label[0].toUpperCase() === key) {
	                    autoIndex = k;
	                }
	            }
	        }
	        // Handle the requested mnemonic based on the search results.
	        // If exactly one mnemonic is matched, that item is triggered.
	        // Otherwise, the next mnemonic is activated if available,
	        // followed by the auto mnemonic if available.
	        if (mnIndex !== -1 && !mnMultiple) {
	            this.activeIndex = mnIndex;
	            this.triggerActiveItem();
	        }
	        else if (mnIndex !== -1) {
	            this.activeIndex = mnIndex;
	        }
	        else if (autoIndex !== -1) {
	            this.activeIndex = autoIndex;
	        }
	    };
	    /**
	     * Handle the `'mouseup'` event for the menu.
	     *
	     * #### Notes
	     * This listener is attached to the menu node.
	     */
	    Menu.prototype._evtMouseUp = function (event) {
	        if (event.button !== 0) {
	            return;
	        }
	        event.preventDefault();
	        event.stopPropagation();
	        this.triggerActiveItem();
	    };
	    /**
	     * Handle the `'mousemove'` event for the menu.
	     *
	     * #### Notes
	     * This listener is attached to the menu node.
	     */
	    Menu.prototype._evtMouseMove = function (event) {
	        // Hit test the item nodes for the item under the mouse.
	        var x = event.clientX;
	        var y = event.clientY;
	        var i = searching_1.findIndex(this._nodes, function (node) { return query_1.hitTest(node, x, y); });
	        // Bail early if the mouse is already over the active index.
	        if (i === this._activeIndex) {
	            return;
	        }
	        // Update and coerce the active index.
	        this.activeIndex = i;
	        i = this.activeIndex;
	        // If the index is the current child index, cancel the timers.
	        if (i === this._childIndex) {
	            this._cancelOpenTimer();
	            this._cancelCloseTimer();
	            return;
	        }
	        // If a child menu is currently open, start the close timer.
	        if (this._childIndex !== -1) {
	            this._startCloseTimer();
	        }
	        // Cancel the open timer to give a full delay for opening.
	        this._cancelOpenTimer();
	        // Bail if the active item is not a valid submenu item.
	        var item = this.activeItem;
	        if (!item || item.type !== 'submenu' || !item.menu) {
	            return;
	        }
	        // Start the open timer to open the active item submenu.
	        this._startOpenTimer();
	    };
	    /**
	     * Handle the `'mouseenter'` event for the menu.
	     *
	     * #### Notes
	     * This listener is attached to the menu node.
	     */
	    Menu.prototype._evtMouseEnter = function (event) {
	        // Synchronize the active ancestor items.
	        for (var menu = this._parentMenu; menu; menu = menu._parentMenu) {
	            menu._cancelOpenTimer();
	            menu._cancelCloseTimer();
	            menu.activeIndex = menu._childIndex;
	        }
	    };
	    /**
	     * Handle the `'mouseleave'` event for the menu.
	     *
	     * #### Notes
	     * This listener is attached to the menu node.
	     */
	    Menu.prototype._evtMouseLeave = function (event) {
	        // Cancel any pending submenu opening.
	        this._cancelOpenTimer();
	        // If there is no open child menu, just reset the active index.
	        if (!this._childMenu) {
	            this.activeIndex = -1;
	            return;
	        }
	        // If the mouse is over the child menu, cancel the close timer.
	        if (query_1.hitTest(this._childMenu.node, event.clientX, event.clientY)) {
	            this._cancelCloseTimer();
	            return;
	        }
	        // Otherwise, reset the active index and start the close timer.
	        this.activeIndex = -1;
	        this._startCloseTimer();
	    };
	    /**
	     * Handle the `'mousedown'` event for the menu.
	     *
	     * #### Notes
	     * This listener is attached to the document node.
	     */
	    Menu.prototype._evtMouseDown = function (event) {
	        // Bail if the menu is not a root menu.
	        if (this._parentMenu) {
	            return;
	        }
	        // The mouse button which is pressed is irrelevant. If the press
	        // is not on a menu, the entire hierarchy is closed and the event
	        // is allowed to propagate. This allows other code to act on the
	        // event, such as focusing the clicked element.
	        if (Private.hitTestMenus(this, event.clientX, event.clientY)) {
	            event.preventDefault();
	            event.stopPropagation();
	        }
	        else {
	            this.close();
	        }
	    };
	    /**
	     * Open the child menu at the active index immediately.
	     *
	     * If a different child menu is already open, it will be closed,
	     * even if the active item is not a valid submenu.
	     */
	    Menu.prototype._openChildMenu = function (activateFirst) {
	        if (activateFirst === void 0) { activateFirst = false; }
	        // If the item is not a valid submenu, close the child menu.
	        var item = this.activeItem;
	        if (!item || item.type !== 'submenu' || !item.menu) {
	            this._closeChildMenu();
	            return;
	        }
	        // Do nothing if the child menu will not change.
	        var menu = item.menu;
	        if (menu === this._childMenu) {
	            return;
	        }
	        // Ensure the current child menu is closed.
	        this._closeChildMenu();
	        // Update the private child state.
	        this._childMenu = menu;
	        this._childIndex = this._activeIndex;
	        // Set the parent menu reference for the child.
	        menu._parentMenu = this;
	        // Open the submenu at the active node.
	        Private.openSubmenu(menu, this._nodes.at(this._activeIndex));
	        // Activate the first item if desired.
	        if (activateFirst) {
	            menu.activeIndex = -1;
	            menu.activateNextItem();
	        }
	        // Activate the child menu.
	        menu.activate();
	    };
	    /**
	     * Close the child menu immediately.
	     *
	     * This is a no-op if a child menu is not open.
	     */
	    Menu.prototype._closeChildMenu = function () {
	        if (this._childMenu) {
	            this._childMenu.close();
	        }
	    };
	    /**
	     * Start the open timer, unless it is already pending.
	     */
	    Menu.prototype._startOpenTimer = function () {
	        var _this = this;
	        if (this._openTimerID === 0) {
	            this._openTimerID = setTimeout(function () {
	                _this._openTimerID = 0;
	                _this._openChildMenu();
	            }, TIMER_DELAY);
	        }
	    };
	    /**
	     * Start the close timer, unless it is already pending.
	     */
	    Menu.prototype._startCloseTimer = function () {
	        var _this = this;
	        if (this._closeTimerID === 0) {
	            this._closeTimerID = setTimeout(function () {
	                _this._closeTimerID = 0;
	                _this._closeChildMenu();
	            }, TIMER_DELAY);
	        }
	    };
	    /**
	     * Cancel the open timer, if the timer is pending.
	     */
	    Menu.prototype._cancelOpenTimer = function () {
	        if (this._openTimerID !== 0) {
	            clearTimeout(this._openTimerID);
	            this._openTimerID = 0;
	        }
	    };
	    /**
	     * Cancel the close timer, if the timer is pending.
	     */
	    Menu.prototype._cancelCloseTimer = function () {
	        if (this._closeTimerID !== 0) {
	            clearTimeout(this._closeTimerID);
	            this._closeTimerID = 0;
	        }
	    };
	    return Menu;
	}(widget_1.Widget));
	exports.Menu = Menu;
	// Define the signals for the `Menu` class.
	signaling_1.defineSignal(Menu.prototype, 'aboutToClose');
	signaling_1.defineSignal(Menu.prototype, 'menuRequested');
	/**
	 * The namespace for the `Menu` class statics.
	 */
	var Menu;
	(function (Menu) {
	    /**
	     * The default implementation of `IRenderer`.
	     */
	    var Renderer = (function () {
	        function Renderer() {
	        }
	        /**
	         * Create a node for a menu item.
	         *
	         * @returns A new node for a menu item.
	         */
	        Renderer.prototype.createItemNode = function () {
	            var node = document.createElement('li');
	            var icon = document.createElement('div');
	            var label = document.createElement('div');
	            var shortcut = document.createElement('div');
	            var submenu = document.createElement('div');
	            node.className = ITEM_CLASS;
	            icon.className = ICON_CLASS;
	            label.className = LABEL_CLASS;
	            shortcut.className = SHORTCUT_CLASS;
	            submenu.className = SUBMENU_ICON_CLASS;
	            node.appendChild(icon);
	            node.appendChild(label);
	            node.appendChild(shortcut);
	            node.appendChild(submenu);
	            return node;
	        };
	        /**
	         * Update an item node to reflect the state of a menu item.
	         *
	         * @param node - A node created by a call to `createItemNode`.
	         *
	         * @param item - The menu item holding the data for the node.
	         */
	        Renderer.prototype.updateItemNode = function (node, item) {
	            // Setup the initial item class.
	            var itemClass = ITEM_CLASS;
	            // Add the item type to the item class.
	            switch (item.type) {
	                case 'command':
	                    itemClass += " " + COMMAND_TYPE_CLASS;
	                    break;
	                case 'submenu':
	                    itemClass += " " + SUBMENU_TYPE_CLASS;
	                    break;
	                case 'separator':
	                    itemClass += " " + SEPARATOR_TYPE_CLASS;
	                    break;
	            }
	            // Add the boolean states to the item class.
	            if (!item.isEnabled) {
	                itemClass += " " + DISABLED_CLASS;
	            }
	            if (item.isToggled) {
	                itemClass += " " + TOGGLED_CLASS;
	            }
	            if (!item.isVisible) {
	                itemClass += " " + HIDDEN_CLASS;
	            }
	            // Add the extra class name(s) to the item class.
	            var extraItemClass = item.className;
	            if (extraItemClass) {
	                itemClass += " " + extraItemClass;
	            }
	            // Setup the initial icon class.
	            var iconClass = ICON_CLASS;
	            // Add the extra class name(s) to the icon class.
	            var extraIconClass = item.icon;
	            if (extraIconClass) {
	                iconClass += " " + extraIconClass;
	            }
	            // Generate the formatted label HTML.
	            var labelHTML = this.formatLabel(item.label, item.mnemonic);
	            // Generate the formatted shortcut text.
	            var shortcutText = this.formatShortcut(item.keyBinding);
	            // Extract the relevant child nodes.
	            var icon = node.firstChild;
	            var label = icon.nextSibling;
	            var shortcut = label.nextSibling;
	            // Set the command ID in the data set.
	            if (item.type === 'command') {
	                node.dataset['command'] = item.command;
	            }
	            else {
	                delete node.dataset['command'];
	            }
	            // Update the rest of the node state.
	            node.title = item.caption;
	            node.className = itemClass;
	            icon.className = iconClass;
	            label.innerHTML = labelHTML;
	            shortcut.textContent = shortcutText;
	        };
	        /**
	         * Format a label into HTML for display.
	         *
	         * @param label - The label text of interest.
	         *
	         * @param mnemonic - The index of the mnemonic character.
	         *
	         * @return The formatted label HTML for display.
	         */
	        Renderer.prototype.formatLabel = function (label, mnemonic) {
	            // If the index is out of range, do not modify the label.
	            if (mnemonic < 0 || mnemonic >= label.length) {
	                return label;
	            }
	            // Split the label into parts.
	            var pref = label.slice(0, mnemonic);
	            var suff = label.slice(mnemonic + 1);
	            var char = label[mnemonic];
	            // Join the label with the mnemonic span.
	            return pref + "<span class=\"" + MNEMONIC_CLASS + "\">" + char + "</span>" + suff;
	        };
	        /**
	         * Format a key binding into shortcut text for display.
	         *
	         * @param binding - The key binding to format. This may be `null`.
	         *
	         * @returns The formatted shortcut text for display.
	         */
	        Renderer.prototype.formatShortcut = function (binding) {
	            return binding ? binding.keys.map(keymap_1.Keymap.formatKeystroke).join(' ') : '';
	        };
	        return Renderer;
	    }());
	    Menu.Renderer = Renderer;
	    /**
	     * The default `Renderer` instance.
	     */
	    Menu.defaultRenderer = new Renderer();
	})(Menu = exports.Menu || (exports.Menu = {}));
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Create the DOM node for a menu.
	     */
	    function createNode() {
	        var node = document.createElement('div');
	        var content = document.createElement('ul');
	        content.className = CONTENT_CLASS;
	        node.appendChild(content);
	        node.tabIndex = -1;
	        return node;
	    }
	    Private.createNode = createNode;
	    /**
	     * Create a new menu item from a keymap, commands, and options.
	     */
	    function createItem(commands, keymap, options) {
	        return new MenuItem(commands, keymap, options);
	    }
	    Private.createItem = createItem;
	    /**
	     * Hit test a menu hierarchy starting at the given root.
	     */
	    function hitTestMenus(menu, x, y) {
	        for (; menu; menu = menu.childMenu) {
	            if (query_1.hitTest(menu.node, x, y))
	                return true;
	        }
	        return false;
	    }
	    Private.hitTestMenus = hitTestMenus;
	    /**
	     * Hide the extra and redundant separator nodes.
	     */
	    function hideExtraSeparators(nodes, items) {
	        // Hide the leading separators.
	        var k1 = 0;
	        var n = items.length;
	        for (; k1 < n; ++k1) {
	            var item = items.at(k1);
	            if (!item.isVisible) {
	                continue;
	            }
	            if (item.type !== 'separator') {
	                break;
	            }
	            nodes.at(k1).classList.add(HIDDEN_CLASS);
	        }
	        // Hide the trailing separators.
	        var k2 = n - 1;
	        for (; k2 >= 0; --k2) {
	            var item = items.at(k2);
	            if (!item.isVisible) {
	                continue;
	            }
	            if (item.type !== 'separator') {
	                break;
	            }
	            nodes.at(k2).classList.add(HIDDEN_CLASS);
	        }
	        // Hide the remaining consecutive separators.
	        var hide = false;
	        while (++k1 < k2) {
	            var item = items.at(k1);
	            if (!item.isVisible) {
	                continue;
	            }
	            if (item.type !== 'separator') {
	                hide = false;
	            }
	            else if (hide) {
	                nodes.at(k1).classList.add(HIDDEN_CLASS);
	            }
	            else {
	                hide = true;
	            }
	        }
	    }
	    Private.hideExtraSeparators = hideExtraSeparators;
	    /**
	     * Open a menu as a root menu at the target location.
	     */
	    function openRootMenu(menu, x, y, forceX, forceY) {
	        // Ensure the menu is updated before opening.
	        messaging_1.sendMessage(menu, widget_1.WidgetMessage.UpdateRequest);
	        // Get the current position and size of the main viewport.
	        var px = window.pageXOffset;
	        var py = window.pageYOffset;
	        var cw = document.documentElement.clientWidth;
	        var ch = document.documentElement.clientHeight;
	        // Compute the maximum allowed height for the menu.
	        var maxHeight = ch - (forceY ? y : 0);
	        // Fetch common variables.
	        var node = menu.node;
	        var style = node.style;
	        // Clear the menu geometry and prepare it for measuring.
	        style.top = '';
	        style.left = '';
	        style.width = '';
	        style.height = '';
	        style.visibility = 'hidden';
	        style.maxHeight = maxHeight + "px";
	        // Attach the menu to the document.
	        widget_1.Widget.attach(menu, document.body);
	        // Expand the menu width by the scrollbar size, if present.
	        if (node.scrollHeight > maxHeight) {
	            style.width = (2 * node.offsetWidth - node.clientWidth) + "px";
	        }
	        // Measure the size of the menu.
	        var _a = node.getBoundingClientRect(), width = _a.width, height = _a.height;
	        // Adjust the X position of the menu to fit on-screen.
	        if (!forceX && (x + width > px + cw)) {
	            x = px + cw - width;
	        }
	        // Adjust the Y position of the menu to fit on-screen.
	        if (!forceY && (y + height > py + ch)) {
	            if (y > py + ch) {
	                y = py + ch - height;
	            }
	            else {
	                y = y - height;
	            }
	        }
	        // Update the position of the menu to the computed position.
	        style.top = Math.max(0, y) + "px";
	        style.left = Math.max(0, x) + "px";
	        // Finally, make the menu visible on the screen.
	        style.visibility = '';
	    }
	    Private.openRootMenu = openRootMenu;
	    /**
	     * Open a menu as a submenu using an item node for positioning.
	     */
	    function openSubmenu(menu, itemNode) {
	        // Ensure the menu is updated before opening.
	        messaging_1.sendMessage(menu, widget_1.WidgetMessage.UpdateRequest);
	        // Get the current position and size of the main viewport.
	        var px = window.pageXOffset;
	        var py = window.pageYOffset;
	        var cw = document.documentElement.clientWidth;
	        var ch = document.documentElement.clientHeight;
	        // Compute the maximum allowed height for the menu.
	        var maxHeight = ch;
	        // Fetch common variables.
	        var node = menu.node;
	        var style = node.style;
	        // Clear the menu geometry and prepare it for measuring.
	        style.top = '';
	        style.left = '';
	        style.width = '';
	        style.height = '';
	        style.visibility = 'hidden';
	        style.maxHeight = maxHeight + "px";
	        // Attach the menu to the document.
	        widget_1.Widget.attach(menu, document.body);
	        // Expand the menu width by the scrollbar size, if present.
	        if (node.scrollHeight > maxHeight) {
	            style.width = (2 * node.offsetWidth - node.clientWidth) + "px";
	        }
	        // Measure the size of the menu.
	        var _a = node.getBoundingClientRect(), width = _a.width, height = _a.height;
	        // Compute the box sizing for the menu.
	        var box = sizing_1.boxSizing(menu.node);
	        // Get the bounding rect for the target item node.
	        var itemRect = itemNode.getBoundingClientRect();
	        // Compute the target X position.
	        var x = itemRect.right - SUBMENU_OVERLAP;
	        // Adjust the X position to fit on the screen.
	        if (x + width > px + cw) {
	            x = itemRect.left + SUBMENU_OVERLAP - width;
	        }
	        // Compute the target Y position.
	        var y = itemRect.top - box.borderTop - box.paddingTop;
	        // Adjust the Y position to fit on the screen.
	        if (y + height > py + ch) {
	            y = itemRect.bottom + box.borderBottom + box.paddingBottom - height;
	        }
	        // Update the position of the menu to the computed position.
	        style.top = Math.max(0, y) + "px";
	        style.left = Math.max(0, x) + "px";
	        // Finally, make the menu visible on the screen.
	        style.visibility = '';
	    }
	    Private.openSubmenu = openSubmenu;
	    /**
	     * A concrete implementation of `Menu.IItem`.
	     */
	    var MenuItem = (function () {
	        /**
	         * Construct a new menu item.
	         */
	        function MenuItem(commands, keymap, options) {
	            this._commands = commands;
	            this._keymap = keymap;
	            this._type = options.type || 'command';
	            this._command = options.command || '';
	            this._args = options.args || null;
	            this._menu = options.menu || null;
	        }
	        Object.defineProperty(MenuItem.prototype, "type", {
	            /**
	             * The type of the menu item.
	             */
	            get: function () {
	                return this._type;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(MenuItem.prototype, "command", {
	            /**
	             * The command to execute when the item is triggered.
	             */
	            get: function () {
	                return this._command;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(MenuItem.prototype, "args", {
	            /**
	             * The arguments for the command.
	             */
	            get: function () {
	                return this._args;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(MenuItem.prototype, "menu", {
	            /**
	             * The menu for a `'submenu'` type item.
	             */
	            get: function () {
	                return this._menu;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(MenuItem.prototype, "label", {
	            /**
	             * The display label for the menu item.
	             */
	            get: function () {
	                if (this._type === 'command') {
	                    return this._commands.label(this._command, this._args);
	                }
	                if (this._type === 'submenu' && this._menu) {
	                    return this._menu.title.label;
	                }
	                return '';
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(MenuItem.prototype, "mnemonic", {
	            /**
	             * The mnemonic index for the menu item.
	             */
	            get: function () {
	                if (this._type === 'command') {
	                    return this._commands.mnemonic(this._command, this._args);
	                }
	                if (this._type === 'submenu' && this._menu) {
	                    return this._menu.title.mnemonic;
	                }
	                return -1;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(MenuItem.prototype, "icon", {
	            /**
	             * The icon class for the menu item.
	             */
	            get: function () {
	                if (this._type === 'command') {
	                    return this._commands.icon(this._command, this._args);
	                }
	                if (this._type === 'submenu' && this._menu) {
	                    return this._menu.title.icon;
	                }
	                return '';
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(MenuItem.prototype, "caption", {
	            /**
	             * The display caption for the menu item.
	             */
	            get: function () {
	                if (this._type === 'command') {
	                    return this._commands.caption(this._command, this._args);
	                }
	                if (this._type === 'submenu' && this._menu) {
	                    return this._menu.title.caption;
	                }
	                return '';
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(MenuItem.prototype, "className", {
	            /**
	             * The extra class name for the menu item.
	             */
	            get: function () {
	                if (this._type === 'command') {
	                    return this._commands.className(this._command, this._args);
	                }
	                if (this._type === 'submenu' && this._menu) {
	                    return this._menu.title.className;
	                }
	                return '';
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(MenuItem.prototype, "isEnabled", {
	            /**
	             * Whether the menu item is enabled.
	             */
	            get: function () {
	                if (this._type === 'command') {
	                    return this._commands.isEnabled(this._command, this._args);
	                }
	                if (this._type === 'submenu') {
	                    return this._menu !== null;
	                }
	                return true;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(MenuItem.prototype, "isToggled", {
	            /**
	             * Whether the menu item is toggled.
	             */
	            get: function () {
	                if (this._type === 'command') {
	                    return this._commands.isToggled(this._command, this._args);
	                }
	                return false;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(MenuItem.prototype, "isVisible", {
	            /**
	             * Whether the menu item is visible.
	             */
	            get: function () {
	                if (this._type === 'command') {
	                    return this._commands.isVisible(this._command, this._args);
	                }
	                if (this._type === 'submenu') {
	                    return this._menu !== null;
	                }
	                return true;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(MenuItem.prototype, "keyBinding", {
	            /**
	             * The key binding for the menu item.
	             */
	            get: function () {
	                if (this._type === 'command') {
	                    return this._keymap.findBinding(this._command, this._args);
	                }
	                return null;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        return MenuItem;
	    }());
	})(Private || (Private = {}));


/***/ },
/* 127 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	function __export(m) {
	    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
	}
	__export(__webpack_require__(128));
	__export(__webpack_require__(131));
	__export(__webpack_require__(133));
	__export(__webpack_require__(134));


/***/ },
/* 128 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var CodeMirror = __webpack_require__(129);
	__webpack_require__(130);
	var signaling_1 = __webpack_require__(6);
	/**
	 * The default implementation of a document model.
	 */
	var DocumentModel = (function () {
	    /**
	     * Construct a new document model.
	     */
	    function DocumentModel(languagePreference) {
	        this._text = '';
	        this._defaultLang = '';
	        this._dirty = false;
	        this._readOnly = false;
	        this._isDisposed = false;
	        this._defaultLang = languagePreference || '';
	    }
	    Object.defineProperty(DocumentModel.prototype, "isDisposed", {
	        /**
	         * Get whether the model factory has been disposed.
	         */
	        get: function () {
	            return this._isDisposed;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DocumentModel.prototype, "dirty", {
	        /**
	         * The dirty state of the document.
	         */
	        get: function () {
	            return this._dirty;
	        },
	        set: function (newValue) {
	            if (newValue === this._dirty) {
	                return;
	            }
	            var oldValue = this._dirty;
	            this._dirty = newValue;
	            this.stateChanged.emit({ name: 'dirty', oldValue: oldValue, newValue: newValue });
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DocumentModel.prototype, "readOnly", {
	        /**
	         * The read only state of the document.
	         */
	        get: function () {
	            return this._readOnly;
	        },
	        set: function (newValue) {
	            if (newValue === this._readOnly) {
	                return;
	            }
	            var oldValue = this._readOnly;
	            this._readOnly = newValue;
	            this.stateChanged.emit({ name: 'readOnly', oldValue: oldValue, newValue: newValue });
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DocumentModel.prototype, "defaultKernelName", {
	        /**
	         * The default kernel name of the document.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return '';
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DocumentModel.prototype, "defaultKernelLanguage", {
	        /**
	         * The default kernel language of the document.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._defaultLang;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the resources held by the document manager.
	     */
	    DocumentModel.prototype.dispose = function () {
	        this._isDisposed = true;
	    };
	    /**
	     * Serialize the model to a string.
	     */
	    DocumentModel.prototype.toString = function () {
	        return this._text;
	    };
	    /**
	     * Deserialize the model from a string.
	     *
	     * #### Notes
	     * Should emit a [contentChanged] signal.
	     */
	    DocumentModel.prototype.fromString = function (value) {
	        if (this._text === value) {
	            return;
	        }
	        this._text = value;
	        this.contentChanged.emit(void 0);
	        this.dirty = true;
	    };
	    /**
	     * Serialize the model to JSON.
	     */
	    DocumentModel.prototype.toJSON = function () {
	        return JSON.stringify(this._text);
	    };
	    /**
	     * Deserialize the model from JSON.
	     *
	     * #### Notes
	     * Should emit a [contentChanged] signal.
	     */
	    DocumentModel.prototype.fromJSON = function (value) {
	        this.fromString(JSON.parse(value));
	    };
	    return DocumentModel;
	}());
	exports.DocumentModel = DocumentModel;
	// Define the signals for the `DocumentModel` class.
	signaling_1.defineSignal(DocumentModel.prototype, 'contentChanged');
	signaling_1.defineSignal(DocumentModel.prototype, 'stateChanged');
	/**
	 * An implementation of a model factory for text files.
	 */
	var TextModelFactory = (function () {
	    function TextModelFactory() {
	        this._isDisposed = false;
	    }
	    Object.defineProperty(TextModelFactory.prototype, "name", {
	        /**
	         * The name of the model type.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return 'text';
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TextModelFactory.prototype, "fileType", {
	        /**
	         * The type of the file.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return 'file';
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TextModelFactory.prototype, "fileFormat", {
	        /**
	         * The format of the file.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return 'text';
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TextModelFactory.prototype, "isDisposed", {
	        /**
	         * Get whether the model factory has been disposed.
	         */
	        get: function () {
	            return this._isDisposed;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the resources held by the model factory.
	     */
	    TextModelFactory.prototype.dispose = function () {
	        this._isDisposed = true;
	    };
	    /**
	     * Create a new model.
	     *
	     * @param languagePreference - An optional kernel language preference.
	     *
	     * @returns A new document model.
	     */
	    TextModelFactory.prototype.createNew = function (languagePreference) {
	        return new DocumentModel(languagePreference);
	    };
	    /**
	     * Get the preferred kernel language given an extension.
	     */
	    TextModelFactory.prototype.preferredLanguage = function (ext) {
	        var mode = CodeMirror.findModeByExtension(ext.slice(1));
	        if (mode) {
	            return mode.mode;
	        }
	    };
	    return TextModelFactory;
	}());
	exports.TextModelFactory = TextModelFactory;
	/**
	 * An implementation of a model factory for base64 files.
	 */
	var Base64ModelFactory = (function (_super) {
	    __extends(Base64ModelFactory, _super);
	    function Base64ModelFactory() {
	        _super.apply(this, arguments);
	    }
	    Object.defineProperty(Base64ModelFactory.prototype, "name", {
	        /**
	         * The name of the model type.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return 'base64';
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Base64ModelFactory.prototype, "fileType", {
	        /**
	         * The type of the file.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return 'file';
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Base64ModelFactory.prototype, "fileFormat", {
	        /**
	         * The format of the file.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return 'base64';
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return Base64ModelFactory;
	}(TextModelFactory));
	exports.Base64ModelFactory = Base64ModelFactory;
	/**
	 * The default implemetation of a widget factory.
	 */
	var ABCWidgetFactory = (function () {
	    function ABCWidgetFactory() {
	        this._isDisposed = false;
	    }
	    Object.defineProperty(ABCWidgetFactory.prototype, "isDisposed", {
	        /**
	         * Get whether the model factory has been disposed.
	         */
	        get: function () {
	            return this._isDisposed;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the resources held by the document manager.
	     */
	    ABCWidgetFactory.prototype.dispose = function () {
	        this._isDisposed = true;
	    };
	    return ABCWidgetFactory;
	}());
	exports.ABCWidgetFactory = ABCWidgetFactory;
	// Define the signals for the `ABCWidgetFactory` class.
	signaling_1.defineSignal(ABCWidgetFactory.prototype, 'widgetCreated');


/***/ },
/* 129 */
/***/ function(module, exports, __webpack_require__) {

	// CodeMirror, copyright (c) by Marijn Haverbeke and others
	// Distributed under an MIT license: http://codemirror.net/LICENSE
	
	// This is CodeMirror (http://codemirror.net), a code editor
	// implemented in JavaScript on top of the browser's DOM.
	//
	// You can find some technical background for some of the code below
	// at http://marijnhaverbeke.nl/blog/#cm-internals .
	
	(function(mod) {
	  if (true) // CommonJS
	    module.exports = mod();
	  else if (typeof define == "function" && define.amd) // AMD
	    return define([], mod);
	  else // Plain browser env
	    (this || window).CodeMirror = mod();
	})(function() {
	  "use strict";
	
	  // BROWSER SNIFFING
	
	  // Kludges for bugs and behavior differences that can't be feature
	  // detected are enabled based on userAgent etc sniffing.
	  var userAgent = navigator.userAgent;
	  var platform = navigator.platform;
	
	  var gecko = /gecko\/\d/i.test(userAgent);
	  var ie_upto10 = /MSIE \d/.test(userAgent);
	  var ie_11up = /Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(userAgent);
	  var ie = ie_upto10 || ie_11up;
	  var ie_version = ie && (ie_upto10 ? document.documentMode || 6 : ie_11up[1]);
	  var webkit = /WebKit\//.test(userAgent);
	  var qtwebkit = webkit && /Qt\/\d+\.\d+/.test(userAgent);
	  var chrome = /Chrome\//.test(userAgent);
	  var presto = /Opera\//.test(userAgent);
	  var safari = /Apple Computer/.test(navigator.vendor);
	  var mac_geMountainLion = /Mac OS X 1\d\D([8-9]|\d\d)\D/.test(userAgent);
	  var phantom = /PhantomJS/.test(userAgent);
	
	  var ios = /AppleWebKit/.test(userAgent) && /Mobile\/\w+/.test(userAgent);
	  // This is woefully incomplete. Suggestions for alternative methods welcome.
	  var mobile = ios || /Android|webOS|BlackBerry|Opera Mini|Opera Mobi|IEMobile/i.test(userAgent);
	  var mac = ios || /Mac/.test(platform);
	  var chromeOS = /\bCrOS\b/.test(userAgent);
	  var windows = /win/i.test(platform);
	
	  var presto_version = presto && userAgent.match(/Version\/(\d*\.\d*)/);
	  if (presto_version) presto_version = Number(presto_version[1]);
	  if (presto_version && presto_version >= 15) { presto = false; webkit = true; }
	  // Some browsers use the wrong event properties to signal cmd/ctrl on OS X
	  var flipCtrlCmd = mac && (qtwebkit || presto && (presto_version == null || presto_version < 12.11));
	  var captureRightClick = gecko || (ie && ie_version >= 9);
	
	  // Optimize some code when these features are not used.
	  var sawReadOnlySpans = false, sawCollapsedSpans = false;
	
	  // EDITOR CONSTRUCTOR
	
	  // A CodeMirror instance represents an editor. This is the object
	  // that user code is usually dealing with.
	
	  function CodeMirror(place, options) {
	    if (!(this instanceof CodeMirror)) return new CodeMirror(place, options);
	
	    this.options = options = options ? copyObj(options) : {};
	    // Determine effective options based on given values and defaults.
	    copyObj(defaults, options, false);
	    setGuttersForLineNumbers(options);
	
	    var doc = options.value;
	    if (typeof doc == "string") doc = new Doc(doc, options.mode, null, options.lineSeparator);
	    this.doc = doc;
	
	    var input = new CodeMirror.inputStyles[options.inputStyle](this);
	    var display = this.display = new Display(place, doc, input);
	    display.wrapper.CodeMirror = this;
	    updateGutters(this);
	    themeChanged(this);
	    if (options.lineWrapping)
	      this.display.wrapper.className += " CodeMirror-wrap";
	    if (options.autofocus && !mobile) display.input.focus();
	    initScrollbars(this);
	
	    this.state = {
	      keyMaps: [],  // stores maps added by addKeyMap
	      overlays: [], // highlighting overlays, as added by addOverlay
	      modeGen: 0,   // bumped when mode/overlay changes, used to invalidate highlighting info
	      overwrite: false,
	      delayingBlurEvent: false,
	      focused: false,
	      suppressEdits: false, // used to disable editing during key handlers when in readOnly mode
	      pasteIncoming: false, cutIncoming: false, // help recognize paste/cut edits in input.poll
	      selectingText: false,
	      draggingText: false,
	      highlight: new Delayed(), // stores highlight worker timeout
	      keySeq: null,  // Unfinished key sequence
	      specialChars: null
	    };
	
	    var cm = this;
	
	    // Override magic textarea content restore that IE sometimes does
	    // on our hidden textarea on reload
	    if (ie && ie_version < 11) setTimeout(function() { cm.display.input.reset(true); }, 20);
	
	    registerEventHandlers(this);
	    ensureGlobalHandlers();
	
	    startOperation(this);
	    this.curOp.forceUpdate = true;
	    attachDoc(this, doc);
	
	    if ((options.autofocus && !mobile) || cm.hasFocus())
	      setTimeout(bind(onFocus, this), 20);
	    else
	      onBlur(this);
	
	    for (var opt in optionHandlers) if (optionHandlers.hasOwnProperty(opt))
	      optionHandlers[opt](this, options[opt], Init);
	    maybeUpdateLineNumberWidth(this);
	    if (options.finishInit) options.finishInit(this);
	    for (var i = 0; i < initHooks.length; ++i) initHooks[i](this);
	    endOperation(this);
	    // Suppress optimizelegibility in Webkit, since it breaks text
	    // measuring on line wrapping boundaries.
	    if (webkit && options.lineWrapping &&
	        getComputedStyle(display.lineDiv).textRendering == "optimizelegibility")
	      display.lineDiv.style.textRendering = "auto";
	  }
	
	  // DISPLAY CONSTRUCTOR
	
	  // The display handles the DOM integration, both for input reading
	  // and content drawing. It holds references to DOM nodes and
	  // display-related state.
	
	  function Display(place, doc, input) {
	    var d = this;
	    this.input = input;
	
	    // Covers bottom-right square when both scrollbars are present.
	    d.scrollbarFiller = elt("div", null, "CodeMirror-scrollbar-filler");
	    d.scrollbarFiller.setAttribute("cm-not-content", "true");
	    // Covers bottom of gutter when coverGutterNextToScrollbar is on
	    // and h scrollbar is present.
	    d.gutterFiller = elt("div", null, "CodeMirror-gutter-filler");
	    d.gutterFiller.setAttribute("cm-not-content", "true");
	    // Will contain the actual code, positioned to cover the viewport.
	    d.lineDiv = elt("div", null, "CodeMirror-code");
	    // Elements are added to these to represent selection and cursors.
	    d.selectionDiv = elt("div", null, null, "position: relative; z-index: 1");
	    d.cursorDiv = elt("div", null, "CodeMirror-cursors");
	    // A visibility: hidden element used to find the size of things.
	    d.measure = elt("div", null, "CodeMirror-measure");
	    // When lines outside of the viewport are measured, they are drawn in this.
	    d.lineMeasure = elt("div", null, "CodeMirror-measure");
	    // Wraps everything that needs to exist inside the vertically-padded coordinate system
	    d.lineSpace = elt("div", [d.measure, d.lineMeasure, d.selectionDiv, d.cursorDiv, d.lineDiv],
	                      null, "position: relative; outline: none");
	    // Moved around its parent to cover visible view.
	    d.mover = elt("div", [elt("div", [d.lineSpace], "CodeMirror-lines")], null, "position: relative");
	    // Set to the height of the document, allowing scrolling.
	    d.sizer = elt("div", [d.mover], "CodeMirror-sizer");
	    d.sizerWidth = null;
	    // Behavior of elts with overflow: auto and padding is
	    // inconsistent across browsers. This is used to ensure the
	    // scrollable area is big enough.
	    d.heightForcer = elt("div", null, null, "position: absolute; height: " + scrollerGap + "px; width: 1px;");
	    // Will contain the gutters, if any.
	    d.gutters = elt("div", null, "CodeMirror-gutters");
	    d.lineGutter = null;
	    // Actual scrollable element.
	    d.scroller = elt("div", [d.sizer, d.heightForcer, d.gutters], "CodeMirror-scroll");
	    d.scroller.setAttribute("tabIndex", "-1");
	    // The element in which the editor lives.
	    d.wrapper = elt("div", [d.scrollbarFiller, d.gutterFiller, d.scroller], "CodeMirror");
	
	    // Work around IE7 z-index bug (not perfect, hence IE7 not really being supported)
	    if (ie && ie_version < 8) { d.gutters.style.zIndex = -1; d.scroller.style.paddingRight = 0; }
	    if (!webkit && !(gecko && mobile)) d.scroller.draggable = true;
	
	    if (place) {
	      if (place.appendChild) place.appendChild(d.wrapper);
	      else place(d.wrapper);
	    }
	
	    // Current rendered range (may be bigger than the view window).
	    d.viewFrom = d.viewTo = doc.first;
	    d.reportedViewFrom = d.reportedViewTo = doc.first;
	    // Information about the rendered lines.
	    d.view = [];
	    d.renderedView = null;
	    // Holds info about a single rendered line when it was rendered
	    // for measurement, while not in view.
	    d.externalMeasured = null;
	    // Empty space (in pixels) above the view
	    d.viewOffset = 0;
	    d.lastWrapHeight = d.lastWrapWidth = 0;
	    d.updateLineNumbers = null;
	
	    d.nativeBarWidth = d.barHeight = d.barWidth = 0;
	    d.scrollbarsClipped = false;
	
	    // Used to only resize the line number gutter when necessary (when
	    // the amount of lines crosses a boundary that makes its width change)
	    d.lineNumWidth = d.lineNumInnerWidth = d.lineNumChars = null;
	    // Set to true when a non-horizontal-scrolling line widget is
	    // added. As an optimization, line widget aligning is skipped when
	    // this is false.
	    d.alignWidgets = false;
	
	    d.cachedCharWidth = d.cachedTextHeight = d.cachedPaddingH = null;
	
	    // Tracks the maximum line length so that the horizontal scrollbar
	    // can be kept static when scrolling.
	    d.maxLine = null;
	    d.maxLineLength = 0;
	    d.maxLineChanged = false;
	
	    // Used for measuring wheel scrolling granularity
	    d.wheelDX = d.wheelDY = d.wheelStartX = d.wheelStartY = null;
	
	    // True when shift is held down.
	    d.shift = false;
	
	    // Used to track whether anything happened since the context menu
	    // was opened.
	    d.selForContextMenu = null;
	
	    d.activeTouch = null;
	
	    input.init(d);
	  }
	
	  // STATE UPDATES
	
	  // Used to get the editor into a consistent state again when options change.
	
	  function loadMode(cm) {
	    cm.doc.mode = CodeMirror.getMode(cm.options, cm.doc.modeOption);
	    resetModeState(cm);
	  }
	
	  function resetModeState(cm) {
	    cm.doc.iter(function(line) {
	      if (line.stateAfter) line.stateAfter = null;
	      if (line.styles) line.styles = null;
	    });
	    cm.doc.frontier = cm.doc.first;
	    startWorker(cm, 100);
	    cm.state.modeGen++;
	    if (cm.curOp) regChange(cm);
	  }
	
	  function wrappingChanged(cm) {
	    if (cm.options.lineWrapping) {
	      addClass(cm.display.wrapper, "CodeMirror-wrap");
	      cm.display.sizer.style.minWidth = "";
	      cm.display.sizerWidth = null;
	    } else {
	      rmClass(cm.display.wrapper, "CodeMirror-wrap");
	      findMaxLine(cm);
	    }
	    estimateLineHeights(cm);
	    regChange(cm);
	    clearCaches(cm);
	    setTimeout(function(){updateScrollbars(cm);}, 100);
	  }
	
	  // Returns a function that estimates the height of a line, to use as
	  // first approximation until the line becomes visible (and is thus
	  // properly measurable).
	  function estimateHeight(cm) {
	    var th = textHeight(cm.display), wrapping = cm.options.lineWrapping;
	    var perLine = wrapping && Math.max(5, cm.display.scroller.clientWidth / charWidth(cm.display) - 3);
	    return function(line) {
	      if (lineIsHidden(cm.doc, line)) return 0;
	
	      var widgetsHeight = 0;
	      if (line.widgets) for (var i = 0; i < line.widgets.length; i++) {
	        if (line.widgets[i].height) widgetsHeight += line.widgets[i].height;
	      }
	
	      if (wrapping)
	        return widgetsHeight + (Math.ceil(line.text.length / perLine) || 1) * th;
	      else
	        return widgetsHeight + th;
	    };
	  }
	
	  function estimateLineHeights(cm) {
	    var doc = cm.doc, est = estimateHeight(cm);
	    doc.iter(function(line) {
	      var estHeight = est(line);
	      if (estHeight != line.height) updateLineHeight(line, estHeight);
	    });
	  }
	
	  function themeChanged(cm) {
	    cm.display.wrapper.className = cm.display.wrapper.className.replace(/\s*cm-s-\S+/g, "") +
	      cm.options.theme.replace(/(^|\s)\s*/g, " cm-s-");
	    clearCaches(cm);
	  }
	
	  function guttersChanged(cm) {
	    updateGutters(cm);
	    regChange(cm);
	    setTimeout(function(){alignHorizontally(cm);}, 20);
	  }
	
	  // Rebuild the gutter elements, ensure the margin to the left of the
	  // code matches their width.
	  function updateGutters(cm) {
	    var gutters = cm.display.gutters, specs = cm.options.gutters;
	    removeChildren(gutters);
	    for (var i = 0; i < specs.length; ++i) {
	      var gutterClass = specs[i];
	      var gElt = gutters.appendChild(elt("div", null, "CodeMirror-gutter " + gutterClass));
	      if (gutterClass == "CodeMirror-linenumbers") {
	        cm.display.lineGutter = gElt;
	        gElt.style.width = (cm.display.lineNumWidth || 1) + "px";
	      }
	    }
	    gutters.style.display = i ? "" : "none";
	    updateGutterSpace(cm);
	  }
	
	  function updateGutterSpace(cm) {
	    var width = cm.display.gutters.offsetWidth;
	    cm.display.sizer.style.marginLeft = width + "px";
	  }
	
	  // Compute the character length of a line, taking into account
	  // collapsed ranges (see markText) that might hide parts, and join
	  // other lines onto it.
	  function lineLength(line) {
	    if (line.height == 0) return 0;
	    var len = line.text.length, merged, cur = line;
	    while (merged = collapsedSpanAtStart(cur)) {
	      var found = merged.find(0, true);
	      cur = found.from.line;
	      len += found.from.ch - found.to.ch;
	    }
	    cur = line;
	    while (merged = collapsedSpanAtEnd(cur)) {
	      var found = merged.find(0, true);
	      len -= cur.text.length - found.from.ch;
	      cur = found.to.line;
	      len += cur.text.length - found.to.ch;
	    }
	    return len;
	  }
	
	  // Find the longest line in the document.
	  function findMaxLine(cm) {
	    var d = cm.display, doc = cm.doc;
	    d.maxLine = getLine(doc, doc.first);
	    d.maxLineLength = lineLength(d.maxLine);
	    d.maxLineChanged = true;
	    doc.iter(function(line) {
	      var len = lineLength(line);
	      if (len > d.maxLineLength) {
	        d.maxLineLength = len;
	        d.maxLine = line;
	      }
	    });
	  }
	
	  // Make sure the gutters options contains the element
	  // "CodeMirror-linenumbers" when the lineNumbers option is true.
	  function setGuttersForLineNumbers(options) {
	    var found = indexOf(options.gutters, "CodeMirror-linenumbers");
	    if (found == -1 && options.lineNumbers) {
	      options.gutters = options.gutters.concat(["CodeMirror-linenumbers"]);
	    } else if (found > -1 && !options.lineNumbers) {
	      options.gutters = options.gutters.slice(0);
	      options.gutters.splice(found, 1);
	    }
	  }
	
	  // SCROLLBARS
	
	  // Prepare DOM reads needed to update the scrollbars. Done in one
	  // shot to minimize update/measure roundtrips.
	  function measureForScrollbars(cm) {
	    var d = cm.display, gutterW = d.gutters.offsetWidth;
	    var docH = Math.round(cm.doc.height + paddingVert(cm.display));
	    return {
	      clientHeight: d.scroller.clientHeight,
	      viewHeight: d.wrapper.clientHeight,
	      scrollWidth: d.scroller.scrollWidth, clientWidth: d.scroller.clientWidth,
	      viewWidth: d.wrapper.clientWidth,
	      barLeft: cm.options.fixedGutter ? gutterW : 0,
	      docHeight: docH,
	      scrollHeight: docH + scrollGap(cm) + d.barHeight,
	      nativeBarWidth: d.nativeBarWidth,
	      gutterWidth: gutterW
	    };
	  }
	
	  function NativeScrollbars(place, scroll, cm) {
	    this.cm = cm;
	    var vert = this.vert = elt("div", [elt("div", null, null, "min-width: 1px")], "CodeMirror-vscrollbar");
	    var horiz = this.horiz = elt("div", [elt("div", null, null, "height: 100%; min-height: 1px")], "CodeMirror-hscrollbar");
	    place(vert); place(horiz);
	
	    on(vert, "scroll", function() {
	      if (vert.clientHeight) scroll(vert.scrollTop, "vertical");
	    });
	    on(horiz, "scroll", function() {
	      if (horiz.clientWidth) scroll(horiz.scrollLeft, "horizontal");
	    });
	
	    this.checkedZeroWidth = false;
	    // Need to set a minimum width to see the scrollbar on IE7 (but must not set it on IE8).
	    if (ie && ie_version < 8) this.horiz.style.minHeight = this.vert.style.minWidth = "18px";
	  }
	
	  NativeScrollbars.prototype = copyObj({
	    update: function(measure) {
	      var needsH = measure.scrollWidth > measure.clientWidth + 1;
	      var needsV = measure.scrollHeight > measure.clientHeight + 1;
	      var sWidth = measure.nativeBarWidth;
	
	      if (needsV) {
	        this.vert.style.display = "block";
	        this.vert.style.bottom = needsH ? sWidth + "px" : "0";
	        var totalHeight = measure.viewHeight - (needsH ? sWidth : 0);
	        // A bug in IE8 can cause this value to be negative, so guard it.
	        this.vert.firstChild.style.height =
	          Math.max(0, measure.scrollHeight - measure.clientHeight + totalHeight) + "px";
	      } else {
	        this.vert.style.display = "";
	        this.vert.firstChild.style.height = "0";
	      }
	
	      if (needsH) {
	        this.horiz.style.display = "block";
	        this.horiz.style.right = needsV ? sWidth + "px" : "0";
	        this.horiz.style.left = measure.barLeft + "px";
	        var totalWidth = measure.viewWidth - measure.barLeft - (needsV ? sWidth : 0);
	        this.horiz.firstChild.style.width =
	          (measure.scrollWidth - measure.clientWidth + totalWidth) + "px";
	      } else {
	        this.horiz.style.display = "";
	        this.horiz.firstChild.style.width = "0";
	      }
	
	      if (!this.checkedZeroWidth && measure.clientHeight > 0) {
	        if (sWidth == 0) this.zeroWidthHack();
	        this.checkedZeroWidth = true;
	      }
	
	      return {right: needsV ? sWidth : 0, bottom: needsH ? sWidth : 0};
	    },
	    setScrollLeft: function(pos) {
	      if (this.horiz.scrollLeft != pos) this.horiz.scrollLeft = pos;
	      if (this.disableHoriz) this.enableZeroWidthBar(this.horiz, this.disableHoriz);
	    },
	    setScrollTop: function(pos) {
	      if (this.vert.scrollTop != pos) this.vert.scrollTop = pos;
	      if (this.disableVert) this.enableZeroWidthBar(this.vert, this.disableVert);
	    },
	    zeroWidthHack: function() {
	      var w = mac && !mac_geMountainLion ? "12px" : "18px";
	      this.horiz.style.height = this.vert.style.width = w;
	      this.horiz.style.pointerEvents = this.vert.style.pointerEvents = "none";
	      this.disableHoriz = new Delayed;
	      this.disableVert = new Delayed;
	    },
	    enableZeroWidthBar: function(bar, delay) {
	      bar.style.pointerEvents = "auto";
	      function maybeDisable() {
	        // To find out whether the scrollbar is still visible, we
	        // check whether the element under the pixel in the bottom
	        // left corner of the scrollbar box is the scrollbar box
	        // itself (when the bar is still visible) or its filler child
	        // (when the bar is hidden). If it is still visible, we keep
	        // it enabled, if it's hidden, we disable pointer events.
	        var box = bar.getBoundingClientRect();
	        var elt = document.elementFromPoint(box.left + 1, box.bottom - 1);
	        if (elt != bar) bar.style.pointerEvents = "none";
	        else delay.set(1000, maybeDisable);
	      }
	      delay.set(1000, maybeDisable);
	    },
	    clear: function() {
	      var parent = this.horiz.parentNode;
	      parent.removeChild(this.horiz);
	      parent.removeChild(this.vert);
	    }
	  }, NativeScrollbars.prototype);
	
	  function NullScrollbars() {}
	
	  NullScrollbars.prototype = copyObj({
	    update: function() { return {bottom: 0, right: 0}; },
	    setScrollLeft: function() {},
	    setScrollTop: function() {},
	    clear: function() {}
	  }, NullScrollbars.prototype);
	
	  CodeMirror.scrollbarModel = {"native": NativeScrollbars, "null": NullScrollbars};
	
	  function initScrollbars(cm) {
	    if (cm.display.scrollbars) {
	      cm.display.scrollbars.clear();
	      if (cm.display.scrollbars.addClass)
	        rmClass(cm.display.wrapper, cm.display.scrollbars.addClass);
	    }
	
	    cm.display.scrollbars = new CodeMirror.scrollbarModel[cm.options.scrollbarStyle](function(node) {
	      cm.display.wrapper.insertBefore(node, cm.display.scrollbarFiller);
	      // Prevent clicks in the scrollbars from killing focus
	      on(node, "mousedown", function() {
	        if (cm.state.focused) setTimeout(function() { cm.display.input.focus(); }, 0);
	      });
	      node.setAttribute("cm-not-content", "true");
	    }, function(pos, axis) {
	      if (axis == "horizontal") setScrollLeft(cm, pos);
	      else setScrollTop(cm, pos);
	    }, cm);
	    if (cm.display.scrollbars.addClass)
	      addClass(cm.display.wrapper, cm.display.scrollbars.addClass);
	  }
	
	  function updateScrollbars(cm, measure) {
	    if (!measure) measure = measureForScrollbars(cm);
	    var startWidth = cm.display.barWidth, startHeight = cm.display.barHeight;
	    updateScrollbarsInner(cm, measure);
	    for (var i = 0; i < 4 && startWidth != cm.display.barWidth || startHeight != cm.display.barHeight; i++) {
	      if (startWidth != cm.display.barWidth && cm.options.lineWrapping)
	        updateHeightsInViewport(cm);
	      updateScrollbarsInner(cm, measureForScrollbars(cm));
	      startWidth = cm.display.barWidth; startHeight = cm.display.barHeight;
	    }
	  }
	
	  // Re-synchronize the fake scrollbars with the actual size of the
	  // content.
	  function updateScrollbarsInner(cm, measure) {
	    var d = cm.display;
	    var sizes = d.scrollbars.update(measure);
	
	    d.sizer.style.paddingRight = (d.barWidth = sizes.right) + "px";
	    d.sizer.style.paddingBottom = (d.barHeight = sizes.bottom) + "px";
	    d.heightForcer.style.borderBottom = sizes.bottom + "px solid transparent"
	
	    if (sizes.right && sizes.bottom) {
	      d.scrollbarFiller.style.display = "block";
	      d.scrollbarFiller.style.height = sizes.bottom + "px";
	      d.scrollbarFiller.style.width = sizes.right + "px";
	    } else d.scrollbarFiller.style.display = "";
	    if (sizes.bottom && cm.options.coverGutterNextToScrollbar && cm.options.fixedGutter) {
	      d.gutterFiller.style.display = "block";
	      d.gutterFiller.style.height = sizes.bottom + "px";
	      d.gutterFiller.style.width = measure.gutterWidth + "px";
	    } else d.gutterFiller.style.display = "";
	  }
	
	  // Compute the lines that are visible in a given viewport (defaults
	  // the the current scroll position). viewport may contain top,
	  // height, and ensure (see op.scrollToPos) properties.
	  function visibleLines(display, doc, viewport) {
	    var top = viewport && viewport.top != null ? Math.max(0, viewport.top) : display.scroller.scrollTop;
	    top = Math.floor(top - paddingTop(display));
	    var bottom = viewport && viewport.bottom != null ? viewport.bottom : top + display.wrapper.clientHeight;
	
	    var from = lineAtHeight(doc, top), to = lineAtHeight(doc, bottom);
	    // Ensure is a {from: {line, ch}, to: {line, ch}} object, and
	    // forces those lines into the viewport (if possible).
	    if (viewport && viewport.ensure) {
	      var ensureFrom = viewport.ensure.from.line, ensureTo = viewport.ensure.to.line;
	      if (ensureFrom < from) {
	        from = ensureFrom;
	        to = lineAtHeight(doc, heightAtLine(getLine(doc, ensureFrom)) + display.wrapper.clientHeight);
	      } else if (Math.min(ensureTo, doc.lastLine()) >= to) {
	        from = lineAtHeight(doc, heightAtLine(getLine(doc, ensureTo)) - display.wrapper.clientHeight);
	        to = ensureTo;
	      }
	    }
	    return {from: from, to: Math.max(to, from + 1)};
	  }
	
	  // LINE NUMBERS
	
	  // Re-align line numbers and gutter marks to compensate for
	  // horizontal scrolling.
	  function alignHorizontally(cm) {
	    var display = cm.display, view = display.view;
	    if (!display.alignWidgets && (!display.gutters.firstChild || !cm.options.fixedGutter)) return;
	    var comp = compensateForHScroll(display) - display.scroller.scrollLeft + cm.doc.scrollLeft;
	    var gutterW = display.gutters.offsetWidth, left = comp + "px";
	    for (var i = 0; i < view.length; i++) if (!view[i].hidden) {
	      if (cm.options.fixedGutter && view[i].gutter)
	        view[i].gutter.style.left = left;
	      var align = view[i].alignable;
	      if (align) for (var j = 0; j < align.length; j++)
	        align[j].style.left = left;
	    }
	    if (cm.options.fixedGutter)
	      display.gutters.style.left = (comp + gutterW) + "px";
	  }
	
	  // Used to ensure that the line number gutter is still the right
	  // size for the current document size. Returns true when an update
	  // is needed.
	  function maybeUpdateLineNumberWidth(cm) {
	    if (!cm.options.lineNumbers) return false;
	    var doc = cm.doc, last = lineNumberFor(cm.options, doc.first + doc.size - 1), display = cm.display;
	    if (last.length != display.lineNumChars) {
	      var test = display.measure.appendChild(elt("div", [elt("div", last)],
	                                                 "CodeMirror-linenumber CodeMirror-gutter-elt"));
	      var innerW = test.firstChild.offsetWidth, padding = test.offsetWidth - innerW;
	      display.lineGutter.style.width = "";
	      display.lineNumInnerWidth = Math.max(innerW, display.lineGutter.offsetWidth - padding) + 1;
	      display.lineNumWidth = display.lineNumInnerWidth + padding;
	      display.lineNumChars = display.lineNumInnerWidth ? last.length : -1;
	      display.lineGutter.style.width = display.lineNumWidth + "px";
	      updateGutterSpace(cm);
	      return true;
	    }
	    return false;
	  }
	
	  function lineNumberFor(options, i) {
	    return String(options.lineNumberFormatter(i + options.firstLineNumber));
	  }
	
	  // Computes display.scroller.scrollLeft + display.gutters.offsetWidth,
	  // but using getBoundingClientRect to get a sub-pixel-accurate
	  // result.
	  function compensateForHScroll(display) {
	    return display.scroller.getBoundingClientRect().left - display.sizer.getBoundingClientRect().left;
	  }
	
	  // DISPLAY DRAWING
	
	  function DisplayUpdate(cm, viewport, force) {
	    var display = cm.display;
	
	    this.viewport = viewport;
	    // Store some values that we'll need later (but don't want to force a relayout for)
	    this.visible = visibleLines(display, cm.doc, viewport);
	    this.editorIsHidden = !display.wrapper.offsetWidth;
	    this.wrapperHeight = display.wrapper.clientHeight;
	    this.wrapperWidth = display.wrapper.clientWidth;
	    this.oldDisplayWidth = displayWidth(cm);
	    this.force = force;
	    this.dims = getDimensions(cm);
	    this.events = [];
	  }
	
	  DisplayUpdate.prototype.signal = function(emitter, type) {
	    if (hasHandler(emitter, type))
	      this.events.push(arguments);
	  };
	  DisplayUpdate.prototype.finish = function() {
	    for (var i = 0; i < this.events.length; i++)
	      signal.apply(null, this.events[i]);
	  };
	
	  function maybeClipScrollbars(cm) {
	    var display = cm.display;
	    if (!display.scrollbarsClipped && display.scroller.offsetWidth) {
	      display.nativeBarWidth = display.scroller.offsetWidth - display.scroller.clientWidth;
	      display.heightForcer.style.height = scrollGap(cm) + "px";
	      display.sizer.style.marginBottom = -display.nativeBarWidth + "px";
	      display.sizer.style.borderRightWidth = scrollGap(cm) + "px";
	      display.scrollbarsClipped = true;
	    }
	  }
	
	  // Does the actual updating of the line display. Bails out
	  // (returning false) when there is nothing to be done and forced is
	  // false.
	  function updateDisplayIfNeeded(cm, update) {
	    var display = cm.display, doc = cm.doc;
	
	    if (update.editorIsHidden) {
	      resetView(cm);
	      return false;
	    }
	
	    // Bail out if the visible area is already rendered and nothing changed.
	    if (!update.force &&
	        update.visible.from >= display.viewFrom && update.visible.to <= display.viewTo &&
	        (display.updateLineNumbers == null || display.updateLineNumbers >= display.viewTo) &&
	        display.renderedView == display.view && countDirtyView(cm) == 0)
	      return false;
	
	    if (maybeUpdateLineNumberWidth(cm)) {
	      resetView(cm);
	      update.dims = getDimensions(cm);
	    }
	
	    // Compute a suitable new viewport (from & to)
	    var end = doc.first + doc.size;
	    var from = Math.max(update.visible.from - cm.options.viewportMargin, doc.first);
	    var to = Math.min(end, update.visible.to + cm.options.viewportMargin);
	    if (display.viewFrom < from && from - display.viewFrom < 20) from = Math.max(doc.first, display.viewFrom);
	    if (display.viewTo > to && display.viewTo - to < 20) to = Math.min(end, display.viewTo);
	    if (sawCollapsedSpans) {
	      from = visualLineNo(cm.doc, from);
	      to = visualLineEndNo(cm.doc, to);
	    }
	
	    var different = from != display.viewFrom || to != display.viewTo ||
	      display.lastWrapHeight != update.wrapperHeight || display.lastWrapWidth != update.wrapperWidth;
	    adjustView(cm, from, to);
	
	    display.viewOffset = heightAtLine(getLine(cm.doc, display.viewFrom));
	    // Position the mover div to align with the current scroll position
	    cm.display.mover.style.top = display.viewOffset + "px";
	
	    var toUpdate = countDirtyView(cm);
	    if (!different && toUpdate == 0 && !update.force && display.renderedView == display.view &&
	        (display.updateLineNumbers == null || display.updateLineNumbers >= display.viewTo))
	      return false;
	
	    // For big changes, we hide the enclosing element during the
	    // update, since that speeds up the operations on most browsers.
	    var focused = activeElt();
	    if (toUpdate > 4) display.lineDiv.style.display = "none";
	    patchDisplay(cm, display.updateLineNumbers, update.dims);
	    if (toUpdate > 4) display.lineDiv.style.display = "";
	    display.renderedView = display.view;
	    // There might have been a widget with a focused element that got
	    // hidden or updated, if so re-focus it.
	    if (focused && activeElt() != focused && focused.offsetHeight) focused.focus();
	
	    // Prevent selection and cursors from interfering with the scroll
	    // width and height.
	    removeChildren(display.cursorDiv);
	    removeChildren(display.selectionDiv);
	    display.gutters.style.height = display.sizer.style.minHeight = 0;
	
	    if (different) {
	      display.lastWrapHeight = update.wrapperHeight;
	      display.lastWrapWidth = update.wrapperWidth;
	      startWorker(cm, 400);
	    }
	
	    display.updateLineNumbers = null;
	
	    return true;
	  }
	
	  function postUpdateDisplay(cm, update) {
	    var viewport = update.viewport;
	
	    for (var first = true;; first = false) {
	      if (!first || !cm.options.lineWrapping || update.oldDisplayWidth == displayWidth(cm)) {
	        // Clip forced viewport to actual scrollable area.
	        if (viewport && viewport.top != null)
	          viewport = {top: Math.min(cm.doc.height + paddingVert(cm.display) - displayHeight(cm), viewport.top)};
	        // Updated line heights might result in the drawn area not
	        // actually covering the viewport. Keep looping until it does.
	        update.visible = visibleLines(cm.display, cm.doc, viewport);
	        if (update.visible.from >= cm.display.viewFrom && update.visible.to <= cm.display.viewTo)
	          break;
	      }
	      if (!updateDisplayIfNeeded(cm, update)) break;
	      updateHeightsInViewport(cm);
	      var barMeasure = measureForScrollbars(cm);
	      updateSelection(cm);
	      updateScrollbars(cm, barMeasure);
	      setDocumentHeight(cm, barMeasure);
	    }
	
	    update.signal(cm, "update", cm);
	    if (cm.display.viewFrom != cm.display.reportedViewFrom || cm.display.viewTo != cm.display.reportedViewTo) {
	      update.signal(cm, "viewportChange", cm, cm.display.viewFrom, cm.display.viewTo);
	      cm.display.reportedViewFrom = cm.display.viewFrom; cm.display.reportedViewTo = cm.display.viewTo;
	    }
	  }
	
	  function updateDisplaySimple(cm, viewport) {
	    var update = new DisplayUpdate(cm, viewport);
	    if (updateDisplayIfNeeded(cm, update)) {
	      updateHeightsInViewport(cm);
	      postUpdateDisplay(cm, update);
	      var barMeasure = measureForScrollbars(cm);
	      updateSelection(cm);
	      updateScrollbars(cm, barMeasure);
	      setDocumentHeight(cm, barMeasure);
	      update.finish();
	    }
	  }
	
	  function setDocumentHeight(cm, measure) {
	    cm.display.sizer.style.minHeight = measure.docHeight + "px";
	    cm.display.heightForcer.style.top = measure.docHeight + "px";
	    cm.display.gutters.style.height = (measure.docHeight + cm.display.barHeight + scrollGap(cm)) + "px";
	  }
	
	  // Read the actual heights of the rendered lines, and update their
	  // stored heights to match.
	  function updateHeightsInViewport(cm) {
	    var display = cm.display;
	    var prevBottom = display.lineDiv.offsetTop;
	    for (var i = 0; i < display.view.length; i++) {
	      var cur = display.view[i], height;
	      if (cur.hidden) continue;
	      if (ie && ie_version < 8) {
	        var bot = cur.node.offsetTop + cur.node.offsetHeight;
	        height = bot - prevBottom;
	        prevBottom = bot;
	      } else {
	        var box = cur.node.getBoundingClientRect();
	        height = box.bottom - box.top;
	      }
	      var diff = cur.line.height - height;
	      if (height < 2) height = textHeight(display);
	      if (diff > .001 || diff < -.001) {
	        updateLineHeight(cur.line, height);
	        updateWidgetHeight(cur.line);
	        if (cur.rest) for (var j = 0; j < cur.rest.length; j++)
	          updateWidgetHeight(cur.rest[j]);
	      }
	    }
	  }
	
	  // Read and store the height of line widgets associated with the
	  // given line.
	  function updateWidgetHeight(line) {
	    if (line.widgets) for (var i = 0; i < line.widgets.length; ++i)
	      line.widgets[i].height = line.widgets[i].node.parentNode.offsetHeight;
	  }
	
	  // Do a bulk-read of the DOM positions and sizes needed to draw the
	  // view, so that we don't interleave reading and writing to the DOM.
	  function getDimensions(cm) {
	    var d = cm.display, left = {}, width = {};
	    var gutterLeft = d.gutters.clientLeft;
	    for (var n = d.gutters.firstChild, i = 0; n; n = n.nextSibling, ++i) {
	      left[cm.options.gutters[i]] = n.offsetLeft + n.clientLeft + gutterLeft;
	      width[cm.options.gutters[i]] = n.clientWidth;
	    }
	    return {fixedPos: compensateForHScroll(d),
	            gutterTotalWidth: d.gutters.offsetWidth,
	            gutterLeft: left,
	            gutterWidth: width,
	            wrapperWidth: d.wrapper.clientWidth};
	  }
	
	  // Sync the actual display DOM structure with display.view, removing
	  // nodes for lines that are no longer in view, and creating the ones
	  // that are not there yet, and updating the ones that are out of
	  // date.
	  function patchDisplay(cm, updateNumbersFrom, dims) {
	    var display = cm.display, lineNumbers = cm.options.lineNumbers;
	    var container = display.lineDiv, cur = container.firstChild;
	
	    function rm(node) {
	      var next = node.nextSibling;
	      // Works around a throw-scroll bug in OS X Webkit
	      if (webkit && mac && cm.display.currentWheelTarget == node)
	        node.style.display = "none";
	      else
	        node.parentNode.removeChild(node);
	      return next;
	    }
	
	    var view = display.view, lineN = display.viewFrom;
	    // Loop over the elements in the view, syncing cur (the DOM nodes
	    // in display.lineDiv) with the view as we go.
	    for (var i = 0; i < view.length; i++) {
	      var lineView = view[i];
	      if (lineView.hidden) {
	      } else if (!lineView.node || lineView.node.parentNode != container) { // Not drawn yet
	        var node = buildLineElement(cm, lineView, lineN, dims);
	        container.insertBefore(node, cur);
	      } else { // Already drawn
	        while (cur != lineView.node) cur = rm(cur);
	        var updateNumber = lineNumbers && updateNumbersFrom != null &&
	          updateNumbersFrom <= lineN && lineView.lineNumber;
	        if (lineView.changes) {
	          if (indexOf(lineView.changes, "gutter") > -1) updateNumber = false;
	          updateLineForChanges(cm, lineView, lineN, dims);
	        }
	        if (updateNumber) {
	          removeChildren(lineView.lineNumber);
	          lineView.lineNumber.appendChild(document.createTextNode(lineNumberFor(cm.options, lineN)));
	        }
	        cur = lineView.node.nextSibling;
	      }
	      lineN += lineView.size;
	    }
	    while (cur) cur = rm(cur);
	  }
	
	  // When an aspect of a line changes, a string is added to
	  // lineView.changes. This updates the relevant part of the line's
	  // DOM structure.
	  function updateLineForChanges(cm, lineView, lineN, dims) {
	    for (var j = 0; j < lineView.changes.length; j++) {
	      var type = lineView.changes[j];
	      if (type == "text") updateLineText(cm, lineView);
	      else if (type == "gutter") updateLineGutter(cm, lineView, lineN, dims);
	      else if (type == "class") updateLineClasses(lineView);
	      else if (type == "widget") updateLineWidgets(cm, lineView, dims);
	    }
	    lineView.changes = null;
	  }
	
	  // Lines with gutter elements, widgets or a background class need to
	  // be wrapped, and have the extra elements added to the wrapper div
	  function ensureLineWrapped(lineView) {
	    if (lineView.node == lineView.text) {
	      lineView.node = elt("div", null, null, "position: relative");
	      if (lineView.text.parentNode)
	        lineView.text.parentNode.replaceChild(lineView.node, lineView.text);
	      lineView.node.appendChild(lineView.text);
	      if (ie && ie_version < 8) lineView.node.style.zIndex = 2;
	    }
	    return lineView.node;
	  }
	
	  function updateLineBackground(lineView) {
	    var cls = lineView.bgClass ? lineView.bgClass + " " + (lineView.line.bgClass || "") : lineView.line.bgClass;
	    if (cls) cls += " CodeMirror-linebackground";
	    if (lineView.background) {
	      if (cls) lineView.background.className = cls;
	      else { lineView.background.parentNode.removeChild(lineView.background); lineView.background = null; }
	    } else if (cls) {
	      var wrap = ensureLineWrapped(lineView);
	      lineView.background = wrap.insertBefore(elt("div", null, cls), wrap.firstChild);
	    }
	  }
	
	  // Wrapper around buildLineContent which will reuse the structure
	  // in display.externalMeasured when possible.
	  function getLineContent(cm, lineView) {
	    var ext = cm.display.externalMeasured;
	    if (ext && ext.line == lineView.line) {
	      cm.display.externalMeasured = null;
	      lineView.measure = ext.measure;
	      return ext.built;
	    }
	    return buildLineContent(cm, lineView);
	  }
	
	  // Redraw the line's text. Interacts with the background and text
	  // classes because the mode may output tokens that influence these
	  // classes.
	  function updateLineText(cm, lineView) {
	    var cls = lineView.text.className;
	    var built = getLineContent(cm, lineView);
	    if (lineView.text == lineView.node) lineView.node = built.pre;
	    lineView.text.parentNode.replaceChild(built.pre, lineView.text);
	    lineView.text = built.pre;
	    if (built.bgClass != lineView.bgClass || built.textClass != lineView.textClass) {
	      lineView.bgClass = built.bgClass;
	      lineView.textClass = built.textClass;
	      updateLineClasses(lineView);
	    } else if (cls) {
	      lineView.text.className = cls;
	    }
	  }
	
	  function updateLineClasses(lineView) {
	    updateLineBackground(lineView);
	    if (lineView.line.wrapClass)
	      ensureLineWrapped(lineView).className = lineView.line.wrapClass;
	    else if (lineView.node != lineView.text)
	      lineView.node.className = "";
	    var textClass = lineView.textClass ? lineView.textClass + " " + (lineView.line.textClass || "") : lineView.line.textClass;
	    lineView.text.className = textClass || "";
	  }
	
	  function updateLineGutter(cm, lineView, lineN, dims) {
	    if (lineView.gutter) {
	      lineView.node.removeChild(lineView.gutter);
	      lineView.gutter = null;
	    }
	    if (lineView.gutterBackground) {
	      lineView.node.removeChild(lineView.gutterBackground);
	      lineView.gutterBackground = null;
	    }
	    if (lineView.line.gutterClass) {
	      var wrap = ensureLineWrapped(lineView);
	      lineView.gutterBackground = elt("div", null, "CodeMirror-gutter-background " + lineView.line.gutterClass,
	                                      "left: " + (cm.options.fixedGutter ? dims.fixedPos : -dims.gutterTotalWidth) +
	                                      "px; width: " + dims.gutterTotalWidth + "px");
	      wrap.insertBefore(lineView.gutterBackground, lineView.text);
	    }
	    var markers = lineView.line.gutterMarkers;
	    if (cm.options.lineNumbers || markers) {
	      var wrap = ensureLineWrapped(lineView);
	      var gutterWrap = lineView.gutter = elt("div", null, "CodeMirror-gutter-wrapper", "left: " +
	                                             (cm.options.fixedGutter ? dims.fixedPos : -dims.gutterTotalWidth) + "px");
	      cm.display.input.setUneditable(gutterWrap);
	      wrap.insertBefore(gutterWrap, lineView.text);
	      if (lineView.line.gutterClass)
	        gutterWrap.className += " " + lineView.line.gutterClass;
	      if (cm.options.lineNumbers && (!markers || !markers["CodeMirror-linenumbers"]))
	        lineView.lineNumber = gutterWrap.appendChild(
	          elt("div", lineNumberFor(cm.options, lineN),
	              "CodeMirror-linenumber CodeMirror-gutter-elt",
	              "left: " + dims.gutterLeft["CodeMirror-linenumbers"] + "px; width: "
	              + cm.display.lineNumInnerWidth + "px"));
	      if (markers) for (var k = 0; k < cm.options.gutters.length; ++k) {
	        var id = cm.options.gutters[k], found = markers.hasOwnProperty(id) && markers[id];
	        if (found)
	          gutterWrap.appendChild(elt("div", [found], "CodeMirror-gutter-elt", "left: " +
	                                     dims.gutterLeft[id] + "px; width: " + dims.gutterWidth[id] + "px"));
	      }
	    }
	  }
	
	  function updateLineWidgets(cm, lineView, dims) {
	    if (lineView.alignable) lineView.alignable = null;
	    for (var node = lineView.node.firstChild, next; node; node = next) {
	      var next = node.nextSibling;
	      if (node.className == "CodeMirror-linewidget")
	        lineView.node.removeChild(node);
	    }
	    insertLineWidgets(cm, lineView, dims);
	  }
	
	  // Build a line's DOM representation from scratch
	  function buildLineElement(cm, lineView, lineN, dims) {
	    var built = getLineContent(cm, lineView);
	    lineView.text = lineView.node = built.pre;
	    if (built.bgClass) lineView.bgClass = built.bgClass;
	    if (built.textClass) lineView.textClass = built.textClass;
	
	    updateLineClasses(lineView);
	    updateLineGutter(cm, lineView, lineN, dims);
	    insertLineWidgets(cm, lineView, dims);
	    return lineView.node;
	  }
	
	  // A lineView may contain multiple logical lines (when merged by
	  // collapsed spans). The widgets for all of them need to be drawn.
	  function insertLineWidgets(cm, lineView, dims) {
	    insertLineWidgetsFor(cm, lineView.line, lineView, dims, true);
	    if (lineView.rest) for (var i = 0; i < lineView.rest.length; i++)
	      insertLineWidgetsFor(cm, lineView.rest[i], lineView, dims, false);
	  }
	
	  function insertLineWidgetsFor(cm, line, lineView, dims, allowAbove) {
	    if (!line.widgets) return;
	    var wrap = ensureLineWrapped(lineView);
	    for (var i = 0, ws = line.widgets; i < ws.length; ++i) {
	      var widget = ws[i], node = elt("div", [widget.node], "CodeMirror-linewidget");
	      if (!widget.handleMouseEvents) node.setAttribute("cm-ignore-events", "true");
	      positionLineWidget(widget, node, lineView, dims);
	      cm.display.input.setUneditable(node);
	      if (allowAbove && widget.above)
	        wrap.insertBefore(node, lineView.gutter || lineView.text);
	      else
	        wrap.appendChild(node);
	      signalLater(widget, "redraw");
	    }
	  }
	
	  function positionLineWidget(widget, node, lineView, dims) {
	    if (widget.noHScroll) {
	      (lineView.alignable || (lineView.alignable = [])).push(node);
	      var width = dims.wrapperWidth;
	      node.style.left = dims.fixedPos + "px";
	      if (!widget.coverGutter) {
	        width -= dims.gutterTotalWidth;
	        node.style.paddingLeft = dims.gutterTotalWidth + "px";
	      }
	      node.style.width = width + "px";
	    }
	    if (widget.coverGutter) {
	      node.style.zIndex = 5;
	      node.style.position = "relative";
	      if (!widget.noHScroll) node.style.marginLeft = -dims.gutterTotalWidth + "px";
	    }
	  }
	
	  // POSITION OBJECT
	
	  // A Pos instance represents a position within the text.
	  var Pos = CodeMirror.Pos = function(line, ch) {
	    if (!(this instanceof Pos)) return new Pos(line, ch);
	    this.line = line; this.ch = ch;
	  };
	
	  // Compare two positions, return 0 if they are the same, a negative
	  // number when a is less, and a positive number otherwise.
	  var cmp = CodeMirror.cmpPos = function(a, b) { return a.line - b.line || a.ch - b.ch; };
	
	  function copyPos(x) {return Pos(x.line, x.ch);}
	  function maxPos(a, b) { return cmp(a, b) < 0 ? b : a; }
	  function minPos(a, b) { return cmp(a, b) < 0 ? a : b; }
	
	  // INPUT HANDLING
	
	  function ensureFocus(cm) {
	    if (!cm.state.focused) { cm.display.input.focus(); onFocus(cm); }
	  }
	
	  // This will be set to a {lineWise: bool, text: [string]} object, so
	  // that, when pasting, we know what kind of selections the copied
	  // text was made out of.
	  var lastCopied = null;
	
	  function applyTextInput(cm, inserted, deleted, sel, origin) {
	    var doc = cm.doc;
	    cm.display.shift = false;
	    if (!sel) sel = doc.sel;
	
	    var paste = cm.state.pasteIncoming || origin == "paste";
	    var textLines = doc.splitLines(inserted), multiPaste = null
	    // When pasing N lines into N selections, insert one line per selection
	    if (paste && sel.ranges.length > 1) {
	      if (lastCopied && lastCopied.text.join("\n") == inserted) {
	        if (sel.ranges.length % lastCopied.text.length == 0) {
	          multiPaste = [];
	          for (var i = 0; i < lastCopied.text.length; i++)
	            multiPaste.push(doc.splitLines(lastCopied.text[i]));
	        }
	      } else if (textLines.length == sel.ranges.length) {
	        multiPaste = map(textLines, function(l) { return [l]; });
	      }
	    }
	
	    // Normal behavior is to insert the new text into every selection
	    for (var i = sel.ranges.length - 1; i >= 0; i--) {
	      var range = sel.ranges[i];
	      var from = range.from(), to = range.to();
	      if (range.empty()) {
	        if (deleted && deleted > 0) // Handle deletion
	          from = Pos(from.line, from.ch - deleted);
	        else if (cm.state.overwrite && !paste) // Handle overwrite
	          to = Pos(to.line, Math.min(getLine(doc, to.line).text.length, to.ch + lst(textLines).length));
	        else if (lastCopied && lastCopied.lineWise && lastCopied.text.join("\n") == inserted)
	          from = to = Pos(from.line, 0)
	      }
	      var updateInput = cm.curOp.updateInput;
	      var changeEvent = {from: from, to: to, text: multiPaste ? multiPaste[i % multiPaste.length] : textLines,
	                         origin: origin || (paste ? "paste" : cm.state.cutIncoming ? "cut" : "+input")};
	      makeChange(cm.doc, changeEvent);
	      signalLater(cm, "inputRead", cm, changeEvent);
	    }
	    if (inserted && !paste)
	      triggerElectric(cm, inserted);
	
	    ensureCursorVisible(cm);
	    cm.curOp.updateInput = updateInput;
	    cm.curOp.typing = true;
	    cm.state.pasteIncoming = cm.state.cutIncoming = false;
	  }
	
	  function handlePaste(e, cm) {
	    var pasted = e.clipboardData && e.clipboardData.getData("text/plain");
	    if (pasted) {
	      e.preventDefault();
	      if (!cm.isReadOnly() && !cm.options.disableInput)
	        runInOp(cm, function() { applyTextInput(cm, pasted, 0, null, "paste"); });
	      return true;
	    }
	  }
	
	  function triggerElectric(cm, inserted) {
	    // When an 'electric' character is inserted, immediately trigger a reindent
	    if (!cm.options.electricChars || !cm.options.smartIndent) return;
	    var sel = cm.doc.sel;
	
	    for (var i = sel.ranges.length - 1; i >= 0; i--) {
	      var range = sel.ranges[i];
	      if (range.head.ch > 100 || (i && sel.ranges[i - 1].head.line == range.head.line)) continue;
	      var mode = cm.getModeAt(range.head);
	      var indented = false;
	      if (mode.electricChars) {
	        for (var j = 0; j < mode.electricChars.length; j++)
	          if (inserted.indexOf(mode.electricChars.charAt(j)) > -1) {
	            indented = indentLine(cm, range.head.line, "smart");
	            break;
	          }
	      } else if (mode.electricInput) {
	        if (mode.electricInput.test(getLine(cm.doc, range.head.line).text.slice(0, range.head.ch)))
	          indented = indentLine(cm, range.head.line, "smart");
	      }
	      if (indented) signalLater(cm, "electricInput", cm, range.head.line);
	    }
	  }
	
	  function copyableRanges(cm) {
	    var text = [], ranges = [];
	    for (var i = 0; i < cm.doc.sel.ranges.length; i++) {
	      var line = cm.doc.sel.ranges[i].head.line;
	      var lineRange = {anchor: Pos(line, 0), head: Pos(line + 1, 0)};
	      ranges.push(lineRange);
	      text.push(cm.getRange(lineRange.anchor, lineRange.head));
	    }
	    return {text: text, ranges: ranges};
	  }
	
	  function disableBrowserMagic(field) {
	    field.setAttribute("autocorrect", "off");
	    field.setAttribute("autocapitalize", "off");
	    field.setAttribute("spellcheck", "false");
	  }
	
	  // TEXTAREA INPUT STYLE
	
	  function TextareaInput(cm) {
	    this.cm = cm;
	    // See input.poll and input.reset
	    this.prevInput = "";
	
	    // Flag that indicates whether we expect input to appear real soon
	    // now (after some event like 'keypress' or 'input') and are
	    // polling intensively.
	    this.pollingFast = false;
	    // Self-resetting timeout for the poller
	    this.polling = new Delayed();
	    // Tracks when input.reset has punted to just putting a short
	    // string into the textarea instead of the full selection.
	    this.inaccurateSelection = false;
	    // Used to work around IE issue with selection being forgotten when focus moves away from textarea
	    this.hasSelection = false;
	    this.composing = null;
	  };
	
	  function hiddenTextarea() {
	    var te = elt("textarea", null, null, "position: absolute; bottom: -1em; padding: 0; width: 1px; height: 1em; outline: none");
	    var div = elt("div", [te], null, "overflow: hidden; position: relative; width: 3px; height: 0px;");
	    // The textarea is kept positioned near the cursor to prevent the
	    // fact that it'll be scrolled into view on input from scrolling
	    // our fake cursor out of view. On webkit, when wrap=off, paste is
	    // very slow. So make the area wide instead.
	    if (webkit) te.style.width = "1000px";
	    else te.setAttribute("wrap", "off");
	    // If border: 0; -- iOS fails to open keyboard (issue #1287)
	    if (ios) te.style.border = "1px solid black";
	    disableBrowserMagic(te);
	    return div;
	  }
	
	  TextareaInput.prototype = copyObj({
	    init: function(display) {
	      var input = this, cm = this.cm;
	
	      // Wraps and hides input textarea
	      var div = this.wrapper = hiddenTextarea();
	      // The semihidden textarea that is focused when the editor is
	      // focused, and receives input.
	      var te = this.textarea = div.firstChild;
	      display.wrapper.insertBefore(div, display.wrapper.firstChild);
	
	      // Needed to hide big blue blinking cursor on Mobile Safari (doesn't seem to work in iOS 8 anymore)
	      if (ios) te.style.width = "0px";
	
	      on(te, "input", function() {
	        if (ie && ie_version >= 9 && input.hasSelection) input.hasSelection = null;
	        input.poll();
	      });
	
	      on(te, "paste", function(e) {
	        if (signalDOMEvent(cm, e) || handlePaste(e, cm)) return
	
	        cm.state.pasteIncoming = true;
	        input.fastPoll();
	      });
	
	      function prepareCopyCut(e) {
	        if (signalDOMEvent(cm, e)) return
	        if (cm.somethingSelected()) {
	          lastCopied = {lineWise: false, text: cm.getSelections()};
	          if (input.inaccurateSelection) {
	            input.prevInput = "";
	            input.inaccurateSelection = false;
	            te.value = lastCopied.text.join("\n");
	            selectInput(te);
	          }
	        } else if (!cm.options.lineWiseCopyCut) {
	          return;
	        } else {
	          var ranges = copyableRanges(cm);
	          lastCopied = {lineWise: true, text: ranges.text};
	          if (e.type == "cut") {
	            cm.setSelections(ranges.ranges, null, sel_dontScroll);
	          } else {
	            input.prevInput = "";
	            te.value = ranges.text.join("\n");
	            selectInput(te);
	          }
	        }
	        if (e.type == "cut") cm.state.cutIncoming = true;
	      }
	      on(te, "cut", prepareCopyCut);
	      on(te, "copy", prepareCopyCut);
	
	      on(display.scroller, "paste", function(e) {
	        if (eventInWidget(display, e) || signalDOMEvent(cm, e)) return;
	        cm.state.pasteIncoming = true;
	        input.focus();
	      });
	
	      // Prevent normal selection in the editor (we handle our own)
	      on(display.lineSpace, "selectstart", function(e) {
	        if (!eventInWidget(display, e)) e_preventDefault(e);
	      });
	
	      on(te, "compositionstart", function() {
	        var start = cm.getCursor("from");
	        if (input.composing) input.composing.range.clear()
	        input.composing = {
	          start: start,
	          range: cm.markText(start, cm.getCursor("to"), {className: "CodeMirror-composing"})
	        };
	      });
	      on(te, "compositionend", function() {
	        if (input.composing) {
	          input.poll();
	          input.composing.range.clear();
	          input.composing = null;
	        }
	      });
	    },
	
	    prepareSelection: function() {
	      // Redraw the selection and/or cursor
	      var cm = this.cm, display = cm.display, doc = cm.doc;
	      var result = prepareSelection(cm);
	
	      // Move the hidden textarea near the cursor to prevent scrolling artifacts
	      if (cm.options.moveInputWithCursor) {
	        var headPos = cursorCoords(cm, doc.sel.primary().head, "div");
	        var wrapOff = display.wrapper.getBoundingClientRect(), lineOff = display.lineDiv.getBoundingClientRect();
	        result.teTop = Math.max(0, Math.min(display.wrapper.clientHeight - 10,
	                                            headPos.top + lineOff.top - wrapOff.top));
	        result.teLeft = Math.max(0, Math.min(display.wrapper.clientWidth - 10,
	                                             headPos.left + lineOff.left - wrapOff.left));
	      }
	
	      return result;
	    },
	
	    showSelection: function(drawn) {
	      var cm = this.cm, display = cm.display;
	      removeChildrenAndAdd(display.cursorDiv, drawn.cursors);
	      removeChildrenAndAdd(display.selectionDiv, drawn.selection);
	      if (drawn.teTop != null) {
	        this.wrapper.style.top = drawn.teTop + "px";
	        this.wrapper.style.left = drawn.teLeft + "px";
	      }
	    },
	
	    // Reset the input to correspond to the selection (or to be empty,
	    // when not typing and nothing is selected)
	    reset: function(typing) {
	      if (this.contextMenuPending) return;
	      var minimal, selected, cm = this.cm, doc = cm.doc;
	      if (cm.somethingSelected()) {
	        this.prevInput = "";
	        var range = doc.sel.primary();
	        minimal = hasCopyEvent &&
	          (range.to().line - range.from().line > 100 || (selected = cm.getSelection()).length > 1000);
	        var content = minimal ? "-" : selected || cm.getSelection();
	        this.textarea.value = content;
	        if (cm.state.focused) selectInput(this.textarea);
	        if (ie && ie_version >= 9) this.hasSelection = content;
	      } else if (!typing) {
	        this.prevInput = this.textarea.value = "";
	        if (ie && ie_version >= 9) this.hasSelection = null;
	      }
	      this.inaccurateSelection = minimal;
	    },
	
	    getField: function() { return this.textarea; },
	
	    supportsTouch: function() { return false; },
	
	    focus: function() {
	      if (this.cm.options.readOnly != "nocursor" && (!mobile || activeElt() != this.textarea)) {
	        try { this.textarea.focus(); }
	        catch (e) {} // IE8 will throw if the textarea is display: none or not in DOM
	      }
	    },
	
	    blur: function() { this.textarea.blur(); },
	
	    resetPosition: function() {
	      this.wrapper.style.top = this.wrapper.style.left = 0;
	    },
	
	    receivedFocus: function() { this.slowPoll(); },
	
	    // Poll for input changes, using the normal rate of polling. This
	    // runs as long as the editor is focused.
	    slowPoll: function() {
	      var input = this;
	      if (input.pollingFast) return;
	      input.polling.set(this.cm.options.pollInterval, function() {
	        input.poll();
	        if (input.cm.state.focused) input.slowPoll();
	      });
	    },
	
	    // When an event has just come in that is likely to add or change
	    // something in the input textarea, we poll faster, to ensure that
	    // the change appears on the screen quickly.
	    fastPoll: function() {
	      var missed = false, input = this;
	      input.pollingFast = true;
	      function p() {
	        var changed = input.poll();
	        if (!changed && !missed) {missed = true; input.polling.set(60, p);}
	        else {input.pollingFast = false; input.slowPoll();}
	      }
	      input.polling.set(20, p);
	    },
	
	    // Read input from the textarea, and update the document to match.
	    // When something is selected, it is present in the textarea, and
	    // selected (unless it is huge, in which case a placeholder is
	    // used). When nothing is selected, the cursor sits after previously
	    // seen text (can be empty), which is stored in prevInput (we must
	    // not reset the textarea when typing, because that breaks IME).
	    poll: function() {
	      var cm = this.cm, input = this.textarea, prevInput = this.prevInput;
	      // Since this is called a *lot*, try to bail out as cheaply as
	      // possible when it is clear that nothing happened. hasSelection
	      // will be the case when there is a lot of text in the textarea,
	      // in which case reading its value would be expensive.
	      if (this.contextMenuPending || !cm.state.focused ||
	          (hasSelection(input) && !prevInput && !this.composing) ||
	          cm.isReadOnly() || cm.options.disableInput || cm.state.keySeq)
	        return false;
	
	      var text = input.value;
	      // If nothing changed, bail.
	      if (text == prevInput && !cm.somethingSelected()) return false;
	      // Work around nonsensical selection resetting in IE9/10, and
	      // inexplicable appearance of private area unicode characters on
	      // some key combos in Mac (#2689).
	      if (ie && ie_version >= 9 && this.hasSelection === text ||
	          mac && /[\uf700-\uf7ff]/.test(text)) {
	        cm.display.input.reset();
	        return false;
	      }
	
	      if (cm.doc.sel == cm.display.selForContextMenu) {
	        var first = text.charCodeAt(0);
	        if (first == 0x200b && !prevInput) prevInput = "\u200b";
	        if (first == 0x21da) { this.reset(); return this.cm.execCommand("undo"); }
	      }
	      // Find the part of the input that is actually new
	      var same = 0, l = Math.min(prevInput.length, text.length);
	      while (same < l && prevInput.charCodeAt(same) == text.charCodeAt(same)) ++same;
	
	      var self = this;
	      runInOp(cm, function() {
	        applyTextInput(cm, text.slice(same), prevInput.length - same,
	                       null, self.composing ? "*compose" : null);
	
	        // Don't leave long text in the textarea, since it makes further polling slow
	        if (text.length > 1000 || text.indexOf("\n") > -1) input.value = self.prevInput = "";
	        else self.prevInput = text;
	
	        if (self.composing) {
	          self.composing.range.clear();
	          self.composing.range = cm.markText(self.composing.start, cm.getCursor("to"),
	                                             {className: "CodeMirror-composing"});
	        }
	      });
	      return true;
	    },
	
	    ensurePolled: function() {
	      if (this.pollingFast && this.poll()) this.pollingFast = false;
	    },
	
	    onKeyPress: function() {
	      if (ie && ie_version >= 9) this.hasSelection = null;
	      this.fastPoll();
	    },
	
	    onContextMenu: function(e) {
	      var input = this, cm = input.cm, display = cm.display, te = input.textarea;
	      var pos = posFromMouse(cm, e), scrollPos = display.scroller.scrollTop;
	      if (!pos || presto) return; // Opera is difficult.
	
	      // Reset the current text selection only if the click is done outside of the selection
	      // and 'resetSelectionOnContextMenu' option is true.
	      var reset = cm.options.resetSelectionOnContextMenu;
	      if (reset && cm.doc.sel.contains(pos) == -1)
	        operation(cm, setSelection)(cm.doc, simpleSelection(pos), sel_dontScroll);
	
	      var oldCSS = te.style.cssText, oldWrapperCSS = input.wrapper.style.cssText;
	      input.wrapper.style.cssText = "position: absolute"
	      var wrapperBox = input.wrapper.getBoundingClientRect()
	      te.style.cssText = "position: absolute; width: 30px; height: 30px; top: " + (e.clientY - wrapperBox.top - 5) +
	        "px; left: " + (e.clientX - wrapperBox.left - 5) + "px; z-index: 1000; background: " +
	        (ie ? "rgba(255, 255, 255, .05)" : "transparent") +
	        "; outline: none; border-width: 0; outline: none; overflow: hidden; opacity: .05; filter: alpha(opacity=5);";
	      if (webkit) var oldScrollY = window.scrollY; // Work around Chrome issue (#2712)
	      display.input.focus();
	      if (webkit) window.scrollTo(null, oldScrollY);
	      display.input.reset();
	      // Adds "Select all" to context menu in FF
	      if (!cm.somethingSelected()) te.value = input.prevInput = " ";
	      input.contextMenuPending = true;
	      display.selForContextMenu = cm.doc.sel;
	      clearTimeout(display.detectingSelectAll);
	
	      // Select-all will be greyed out if there's nothing to select, so
	      // this adds a zero-width space so that we can later check whether
	      // it got selected.
	      function prepareSelectAllHack() {
	        if (te.selectionStart != null) {
	          var selected = cm.somethingSelected();
	          var extval = "\u200b" + (selected ? te.value : "");
	          te.value = "\u21da"; // Used to catch context-menu undo
	          te.value = extval;
	          input.prevInput = selected ? "" : "\u200b";
	          te.selectionStart = 1; te.selectionEnd = extval.length;
	          // Re-set this, in case some other handler touched the
	          // selection in the meantime.
	          display.selForContextMenu = cm.doc.sel;
	        }
	      }
	      function rehide() {
	        input.contextMenuPending = false;
	        input.wrapper.style.cssText = oldWrapperCSS
	        te.style.cssText = oldCSS;
	        if (ie && ie_version < 9) display.scrollbars.setScrollTop(display.scroller.scrollTop = scrollPos);
	
	        // Try to detect the user choosing select-all
	        if (te.selectionStart != null) {
	          if (!ie || (ie && ie_version < 9)) prepareSelectAllHack();
	          var i = 0, poll = function() {
	            if (display.selForContextMenu == cm.doc.sel && te.selectionStart == 0 &&
	                te.selectionEnd > 0 && input.prevInput == "\u200b")
	              operation(cm, commands.selectAll)(cm);
	            else if (i++ < 10) display.detectingSelectAll = setTimeout(poll, 500);
	            else display.input.reset();
	          };
	          display.detectingSelectAll = setTimeout(poll, 200);
	        }
	      }
	
	      if (ie && ie_version >= 9) prepareSelectAllHack();
	      if (captureRightClick) {
	        e_stop(e);
	        var mouseup = function() {
	          off(window, "mouseup", mouseup);
	          setTimeout(rehide, 20);
	        };
	        on(window, "mouseup", mouseup);
	      } else {
	        setTimeout(rehide, 50);
	      }
	    },
	
	    readOnlyChanged: function(val) {
	      if (!val) this.reset();
	    },
	
	    setUneditable: nothing,
	
	    needsContentAttribute: false
	  }, TextareaInput.prototype);
	
	  // CONTENTEDITABLE INPUT STYLE
	
	  function ContentEditableInput(cm) {
	    this.cm = cm;
	    this.lastAnchorNode = this.lastAnchorOffset = this.lastFocusNode = this.lastFocusOffset = null;
	    this.polling = new Delayed();
	    this.gracePeriod = false;
	  }
	
	  ContentEditableInput.prototype = copyObj({
	    init: function(display) {
	      var input = this, cm = input.cm;
	      var div = input.div = display.lineDiv;
	      disableBrowserMagic(div);
	
	      on(div, "paste", function(e) {
	        if (!signalDOMEvent(cm, e)) handlePaste(e, cm);
	      })
	
	      on(div, "compositionstart", function(e) {
	        var data = e.data;
	        input.composing = {sel: cm.doc.sel, data: data, startData: data};
	        if (!data) return;
	        var prim = cm.doc.sel.primary();
	        var line = cm.getLine(prim.head.line);
	        var found = line.indexOf(data, Math.max(0, prim.head.ch - data.length));
	        if (found > -1 && found <= prim.head.ch)
	          input.composing.sel = simpleSelection(Pos(prim.head.line, found),
	                                                Pos(prim.head.line, found + data.length));
	      });
	      on(div, "compositionupdate", function(e) {
	        input.composing.data = e.data;
	      });
	      on(div, "compositionend", function(e) {
	        var ours = input.composing;
	        if (!ours) return;
	        if (e.data != ours.startData && !/\u200b/.test(e.data))
	          ours.data = e.data;
	        // Need a small delay to prevent other code (input event,
	        // selection polling) from doing damage when fired right after
	        // compositionend.
	        setTimeout(function() {
	          if (!ours.handled)
	            input.applyComposition(ours);
	          if (input.composing == ours)
	            input.composing = null;
	        }, 50);
	      });
	
	      on(div, "touchstart", function() {
	        input.forceCompositionEnd();
	      });
	
	      on(div, "input", function() {
	        if (input.composing) return;
	        if (cm.isReadOnly() || !input.pollContent())
	          runInOp(input.cm, function() {regChange(cm);});
	      });
	
	      function onCopyCut(e) {
	        if (signalDOMEvent(cm, e)) return
	        if (cm.somethingSelected()) {
	          lastCopied = {lineWise: false, text: cm.getSelections()};
	          if (e.type == "cut") cm.replaceSelection("", null, "cut");
	        } else if (!cm.options.lineWiseCopyCut) {
	          return;
	        } else {
	          var ranges = copyableRanges(cm);
	          lastCopied = {lineWise: true, text: ranges.text};
	          if (e.type == "cut") {
	            cm.operation(function() {
	              cm.setSelections(ranges.ranges, 0, sel_dontScroll);
	              cm.replaceSelection("", null, "cut");
	            });
	          }
	        }
	        // iOS exposes the clipboard API, but seems to discard content inserted into it
	        if (e.clipboardData && !ios) {
	          e.preventDefault();
	          e.clipboardData.clearData();
	          e.clipboardData.setData("text/plain", lastCopied.text.join("\n"));
	        } else {
	          // Old-fashioned briefly-focus-a-textarea hack
	          var kludge = hiddenTextarea(), te = kludge.firstChild;
	          cm.display.lineSpace.insertBefore(kludge, cm.display.lineSpace.firstChild);
	          te.value = lastCopied.text.join("\n");
	          var hadFocus = document.activeElement;
	          selectInput(te);
	          setTimeout(function() {
	            cm.display.lineSpace.removeChild(kludge);
	            hadFocus.focus();
	          }, 50);
	        }
	      }
	      on(div, "copy", onCopyCut);
	      on(div, "cut", onCopyCut);
	    },
	
	    prepareSelection: function() {
	      var result = prepareSelection(this.cm, false);
	      result.focus = this.cm.state.focused;
	      return result;
	    },
	
	    showSelection: function(info, takeFocus) {
	      if (!info || !this.cm.display.view.length) return;
	      if (info.focus || takeFocus) this.showPrimarySelection();
	      this.showMultipleSelections(info);
	    },
	
	    showPrimarySelection: function() {
	      var sel = window.getSelection(), prim = this.cm.doc.sel.primary();
	      var curAnchor = domToPos(this.cm, sel.anchorNode, sel.anchorOffset);
	      var curFocus = domToPos(this.cm, sel.focusNode, sel.focusOffset);
	      if (curAnchor && !curAnchor.bad && curFocus && !curFocus.bad &&
	          cmp(minPos(curAnchor, curFocus), prim.from()) == 0 &&
	          cmp(maxPos(curAnchor, curFocus), prim.to()) == 0)
	        return;
	
	      var start = posToDOM(this.cm, prim.from());
	      var end = posToDOM(this.cm, prim.to());
	      if (!start && !end) return;
	
	      var view = this.cm.display.view;
	      var old = sel.rangeCount && sel.getRangeAt(0);
	      if (!start) {
	        start = {node: view[0].measure.map[2], offset: 0};
	      } else if (!end) { // FIXME dangerously hacky
	        var measure = view[view.length - 1].measure;
	        var map = measure.maps ? measure.maps[measure.maps.length - 1] : measure.map;
	        end = {node: map[map.length - 1], offset: map[map.length - 2] - map[map.length - 3]};
	      }
	
	      try { var rng = range(start.node, start.offset, end.offset, end.node); }
	      catch(e) {} // Our model of the DOM might be outdated, in which case the range we try to set can be impossible
	      if (rng) {
	        if (!gecko && this.cm.state.focused) {
	          sel.collapse(start.node, start.offset);
	          if (!rng.collapsed) sel.addRange(rng);
	        } else {
	          sel.removeAllRanges();
	          sel.addRange(rng);
	        }
	        if (old && sel.anchorNode == null) sel.addRange(old);
	        else if (gecko) this.startGracePeriod();
	      }
	      this.rememberSelection();
	    },
	
	    startGracePeriod: function() {
	      var input = this;
	      clearTimeout(this.gracePeriod);
	      this.gracePeriod = setTimeout(function() {
	        input.gracePeriod = false;
	        if (input.selectionChanged())
	          input.cm.operation(function() { input.cm.curOp.selectionChanged = true; });
	      }, 20);
	    },
	
	    showMultipleSelections: function(info) {
	      removeChildrenAndAdd(this.cm.display.cursorDiv, info.cursors);
	      removeChildrenAndAdd(this.cm.display.selectionDiv, info.selection);
	    },
	
	    rememberSelection: function() {
	      var sel = window.getSelection();
	      this.lastAnchorNode = sel.anchorNode; this.lastAnchorOffset = sel.anchorOffset;
	      this.lastFocusNode = sel.focusNode; this.lastFocusOffset = sel.focusOffset;
	    },
	
	    selectionInEditor: function() {
	      var sel = window.getSelection();
	      if (!sel.rangeCount) return false;
	      var node = sel.getRangeAt(0).commonAncestorContainer;
	      return contains(this.div, node);
	    },
	
	    focus: function() {
	      if (this.cm.options.readOnly != "nocursor") this.div.focus();
	    },
	    blur: function() { this.div.blur(); },
	    getField: function() { return this.div; },
	
	    supportsTouch: function() { return true; },
	
	    receivedFocus: function() {
	      var input = this;
	      if (this.selectionInEditor())
	        this.pollSelection();
	      else
	        runInOp(this.cm, function() { input.cm.curOp.selectionChanged = true; });
	
	      function poll() {
	        if (input.cm.state.focused) {
	          input.pollSelection();
	          input.polling.set(input.cm.options.pollInterval, poll);
	        }
	      }
	      this.polling.set(this.cm.options.pollInterval, poll);
	    },
	
	    selectionChanged: function() {
	      var sel = window.getSelection();
	      return sel.anchorNode != this.lastAnchorNode || sel.anchorOffset != this.lastAnchorOffset ||
	        sel.focusNode != this.lastFocusNode || sel.focusOffset != this.lastFocusOffset;
	    },
	
	    pollSelection: function() {
	      if (!this.composing && !this.gracePeriod && this.selectionChanged()) {
	        var sel = window.getSelection(), cm = this.cm;
	        this.rememberSelection();
	        var anchor = domToPos(cm, sel.anchorNode, sel.anchorOffset);
	        var head = domToPos(cm, sel.focusNode, sel.focusOffset);
	        if (anchor && head) runInOp(cm, function() {
	          setSelection(cm.doc, simpleSelection(anchor, head), sel_dontScroll);
	          if (anchor.bad || head.bad) cm.curOp.selectionChanged = true;
	        });
	      }
	    },
	
	    pollContent: function() {
	      var cm = this.cm, display = cm.display, sel = cm.doc.sel.primary();
	      var from = sel.from(), to = sel.to();
	      if (from.line < display.viewFrom || to.line > display.viewTo - 1) return false;
	
	      var fromIndex;
	      if (from.line == display.viewFrom || (fromIndex = findViewIndex(cm, from.line)) == 0) {
	        var fromLine = lineNo(display.view[0].line);
	        var fromNode = display.view[0].node;
	      } else {
	        var fromLine = lineNo(display.view[fromIndex].line);
	        var fromNode = display.view[fromIndex - 1].node.nextSibling;
	      }
	      var toIndex = findViewIndex(cm, to.line);
	      if (toIndex == display.view.length - 1) {
	        var toLine = display.viewTo - 1;
	        var toNode = display.lineDiv.lastChild;
	      } else {
	        var toLine = lineNo(display.view[toIndex + 1].line) - 1;
	        var toNode = display.view[toIndex + 1].node.previousSibling;
	      }
	
	      var newText = cm.doc.splitLines(domTextBetween(cm, fromNode, toNode, fromLine, toLine));
	      var oldText = getBetween(cm.doc, Pos(fromLine, 0), Pos(toLine, getLine(cm.doc, toLine).text.length));
	      while (newText.length > 1 && oldText.length > 1) {
	        if (lst(newText) == lst(oldText)) { newText.pop(); oldText.pop(); toLine--; }
	        else if (newText[0] == oldText[0]) { newText.shift(); oldText.shift(); fromLine++; }
	        else break;
	      }
	
	      var cutFront = 0, cutEnd = 0;
	      var newTop = newText[0], oldTop = oldText[0], maxCutFront = Math.min(newTop.length, oldTop.length);
	      while (cutFront < maxCutFront && newTop.charCodeAt(cutFront) == oldTop.charCodeAt(cutFront))
	        ++cutFront;
	      var newBot = lst(newText), oldBot = lst(oldText);
	      var maxCutEnd = Math.min(newBot.length - (newText.length == 1 ? cutFront : 0),
	                               oldBot.length - (oldText.length == 1 ? cutFront : 0));
	      while (cutEnd < maxCutEnd &&
	             newBot.charCodeAt(newBot.length - cutEnd - 1) == oldBot.charCodeAt(oldBot.length - cutEnd - 1))
	        ++cutEnd;
	
	      newText[newText.length - 1] = newBot.slice(0, newBot.length - cutEnd);
	      newText[0] = newText[0].slice(cutFront);
	
	      var chFrom = Pos(fromLine, cutFront);
	      var chTo = Pos(toLine, oldText.length ? lst(oldText).length - cutEnd : 0);
	      if (newText.length > 1 || newText[0] || cmp(chFrom, chTo)) {
	        replaceRange(cm.doc, newText, chFrom, chTo, "+input");
	        return true;
	      }
	    },
	
	    ensurePolled: function() {
	      this.forceCompositionEnd();
	    },
	    reset: function() {
	      this.forceCompositionEnd();
	    },
	    forceCompositionEnd: function() {
	      if (!this.composing || this.composing.handled) return;
	      this.applyComposition(this.composing);
	      this.composing.handled = true;
	      this.div.blur();
	      this.div.focus();
	    },
	    applyComposition: function(composing) {
	      if (this.cm.isReadOnly())
	        operation(this.cm, regChange)(this.cm)
	      else if (composing.data && composing.data != composing.startData)
	        operation(this.cm, applyTextInput)(this.cm, composing.data, 0, composing.sel);
	    },
	
	    setUneditable: function(node) {
	      node.contentEditable = "false"
	    },
	
	    onKeyPress: function(e) {
	      e.preventDefault();
	      if (!this.cm.isReadOnly())
	        operation(this.cm, applyTextInput)(this.cm, String.fromCharCode(e.charCode == null ? e.keyCode : e.charCode), 0);
	    },
	
	    readOnlyChanged: function(val) {
	      this.div.contentEditable = String(val != "nocursor")
	    },
	
	    onContextMenu: nothing,
	    resetPosition: nothing,
	
	    needsContentAttribute: true
	  }, ContentEditableInput.prototype);
	
	  function posToDOM(cm, pos) {
	    var view = findViewForLine(cm, pos.line);
	    if (!view || view.hidden) return null;
	    var line = getLine(cm.doc, pos.line);
	    var info = mapFromLineView(view, line, pos.line);
	
	    var order = getOrder(line), side = "left";
	    if (order) {
	      var partPos = getBidiPartAt(order, pos.ch);
	      side = partPos % 2 ? "right" : "left";
	    }
	    var result = nodeAndOffsetInLineMap(info.map, pos.ch, side);
	    result.offset = result.collapse == "right" ? result.end : result.start;
	    return result;
	  }
	
	  function badPos(pos, bad) { if (bad) pos.bad = true; return pos; }
	
	  function domToPos(cm, node, offset) {
	    var lineNode;
	    if (node == cm.display.lineDiv) {
	      lineNode = cm.display.lineDiv.childNodes[offset];
	      if (!lineNode) return badPos(cm.clipPos(Pos(cm.display.viewTo - 1)), true);
	      node = null; offset = 0;
	    } else {
	      for (lineNode = node;; lineNode = lineNode.parentNode) {
	        if (!lineNode || lineNode == cm.display.lineDiv) return null;
	        if (lineNode.parentNode && lineNode.parentNode == cm.display.lineDiv) break;
	      }
	    }
	    for (var i = 0; i < cm.display.view.length; i++) {
	      var lineView = cm.display.view[i];
	      if (lineView.node == lineNode)
	        return locateNodeInLineView(lineView, node, offset);
	    }
	  }
	
	  function locateNodeInLineView(lineView, node, offset) {
	    var wrapper = lineView.text.firstChild, bad = false;
	    if (!node || !contains(wrapper, node)) return badPos(Pos(lineNo(lineView.line), 0), true);
	    if (node == wrapper) {
	      bad = true;
	      node = wrapper.childNodes[offset];
	      offset = 0;
	      if (!node) {
	        var line = lineView.rest ? lst(lineView.rest) : lineView.line;
	        return badPos(Pos(lineNo(line), line.text.length), bad);
	      }
	    }
	
	    var textNode = node.nodeType == 3 ? node : null, topNode = node;
	    if (!textNode && node.childNodes.length == 1 && node.firstChild.nodeType == 3) {
	      textNode = node.firstChild;
	      if (offset) offset = textNode.nodeValue.length;
	    }
	    while (topNode.parentNode != wrapper) topNode = topNode.parentNode;
	    var measure = lineView.measure, maps = measure.maps;
	
	    function find(textNode, topNode, offset) {
	      for (var i = -1; i < (maps ? maps.length : 0); i++) {
	        var map = i < 0 ? measure.map : maps[i];
	        for (var j = 0; j < map.length; j += 3) {
	          var curNode = map[j + 2];
	          if (curNode == textNode || curNode == topNode) {
	            var line = lineNo(i < 0 ? lineView.line : lineView.rest[i]);
	            var ch = map[j] + offset;
	            if (offset < 0 || curNode != textNode) ch = map[j + (offset ? 1 : 0)];
	            return Pos(line, ch);
	          }
	        }
	      }
	    }
	    var found = find(textNode, topNode, offset);
	    if (found) return badPos(found, bad);
	
	    // FIXME this is all really shaky. might handle the few cases it needs to handle, but likely to cause problems
	    for (var after = topNode.nextSibling, dist = textNode ? textNode.nodeValue.length - offset : 0; after; after = after.nextSibling) {
	      found = find(after, after.firstChild, 0);
	      if (found)
	        return badPos(Pos(found.line, found.ch - dist), bad);
	      else
	        dist += after.textContent.length;
	    }
	    for (var before = topNode.previousSibling, dist = offset; before; before = before.previousSibling) {
	      found = find(before, before.firstChild, -1);
	      if (found)
	        return badPos(Pos(found.line, found.ch + dist), bad);
	      else
	        dist += after.textContent.length;
	    }
	  }
	
	  function domTextBetween(cm, from, to, fromLine, toLine) {
	    var text = "", closing = false, lineSep = cm.doc.lineSeparator();
	    function recognizeMarker(id) { return function(marker) { return marker.id == id; }; }
	    function walk(node) {
	      if (node.nodeType == 1) {
	        var cmText = node.getAttribute("cm-text");
	        if (cmText != null) {
	          if (cmText == "") cmText = node.textContent.replace(/\u200b/g, "");
	          text += cmText;
	          return;
	        }
	        var markerID = node.getAttribute("cm-marker"), range;
	        if (markerID) {
	          var found = cm.findMarks(Pos(fromLine, 0), Pos(toLine + 1, 0), recognizeMarker(+markerID));
	          if (found.length && (range = found[0].find()))
	            text += getBetween(cm.doc, range.from, range.to).join(lineSep);
	          return;
	        }
	        if (node.getAttribute("contenteditable") == "false") return;
	        for (var i = 0; i < node.childNodes.length; i++)
	          walk(node.childNodes[i]);
	        if (/^(pre|div|p)$/i.test(node.nodeName))
	          closing = true;
	      } else if (node.nodeType == 3) {
	        var val = node.nodeValue;
	        if (!val) return;
	        if (closing) {
	          text += lineSep;
	          closing = false;
	        }
	        text += val;
	      }
	    }
	    for (;;) {
	      walk(from);
	      if (from == to) break;
	      from = from.nextSibling;
	    }
	    return text;
	  }
	
	  CodeMirror.inputStyles = {"textarea": TextareaInput, "contenteditable": ContentEditableInput};
	
	  // SELECTION / CURSOR
	
	  // Selection objects are immutable. A new one is created every time
	  // the selection changes. A selection is one or more non-overlapping
	  // (and non-touching) ranges, sorted, and an integer that indicates
	  // which one is the primary selection (the one that's scrolled into
	  // view, that getCursor returns, etc).
	  function Selection(ranges, primIndex) {
	    this.ranges = ranges;
	    this.primIndex = primIndex;
	  }
	
	  Selection.prototype = {
	    primary: function() { return this.ranges[this.primIndex]; },
	    equals: function(other) {
	      if (other == this) return true;
	      if (other.primIndex != this.primIndex || other.ranges.length != this.ranges.length) return false;
	      for (var i = 0; i < this.ranges.length; i++) {
	        var here = this.ranges[i], there = other.ranges[i];
	        if (cmp(here.anchor, there.anchor) != 0 || cmp(here.head, there.head) != 0) return false;
	      }
	      return true;
	    },
	    deepCopy: function() {
	      for (var out = [], i = 0; i < this.ranges.length; i++)
	        out[i] = new Range(copyPos(this.ranges[i].anchor), copyPos(this.ranges[i].head));
	      return new Selection(out, this.primIndex);
	    },
	    somethingSelected: function() {
	      for (var i = 0; i < this.ranges.length; i++)
	        if (!this.ranges[i].empty()) return true;
	      return false;
	    },
	    contains: function(pos, end) {
	      if (!end) end = pos;
	      for (var i = 0; i < this.ranges.length; i++) {
	        var range = this.ranges[i];
	        if (cmp(end, range.from()) >= 0 && cmp(pos, range.to()) <= 0)
	          return i;
	      }
	      return -1;
	    }
	  };
	
	  function Range(anchor, head) {
	    this.anchor = anchor; this.head = head;
	  }
	
	  Range.prototype = {
	    from: function() { return minPos(this.anchor, this.head); },
	    to: function() { return maxPos(this.anchor, this.head); },
	    empty: function() {
	      return this.head.line == this.anchor.line && this.head.ch == this.anchor.ch;
	    }
	  };
	
	  // Take an unsorted, potentially overlapping set of ranges, and
	  // build a selection out of it. 'Consumes' ranges array (modifying
	  // it).
	  function normalizeSelection(ranges, primIndex) {
	    var prim = ranges[primIndex];
	    ranges.sort(function(a, b) { return cmp(a.from(), b.from()); });
	    primIndex = indexOf(ranges, prim);
	    for (var i = 1; i < ranges.length; i++) {
	      var cur = ranges[i], prev = ranges[i - 1];
	      if (cmp(prev.to(), cur.from()) >= 0) {
	        var from = minPos(prev.from(), cur.from()), to = maxPos(prev.to(), cur.to());
	        var inv = prev.empty() ? cur.from() == cur.head : prev.from() == prev.head;
	        if (i <= primIndex) --primIndex;
	        ranges.splice(--i, 2, new Range(inv ? to : from, inv ? from : to));
	      }
	    }
	    return new Selection(ranges, primIndex);
	  }
	
	  function simpleSelection(anchor, head) {
	    return new Selection([new Range(anchor, head || anchor)], 0);
	  }
	
	  // Most of the external API clips given positions to make sure they
	  // actually exist within the document.
	  function clipLine(doc, n) {return Math.max(doc.first, Math.min(n, doc.first + doc.size - 1));}
	  function clipPos(doc, pos) {
	    if (pos.line < doc.first) return Pos(doc.first, 0);
	    var last = doc.first + doc.size - 1;
	    if (pos.line > last) return Pos(last, getLine(doc, last).text.length);
	    return clipToLen(pos, getLine(doc, pos.line).text.length);
	  }
	  function clipToLen(pos, linelen) {
	    var ch = pos.ch;
	    if (ch == null || ch > linelen) return Pos(pos.line, linelen);
	    else if (ch < 0) return Pos(pos.line, 0);
	    else return pos;
	  }
	  function isLine(doc, l) {return l >= doc.first && l < doc.first + doc.size;}
	  function clipPosArray(doc, array) {
	    for (var out = [], i = 0; i < array.length; i++) out[i] = clipPos(doc, array[i]);
	    return out;
	  }
	
	  // SELECTION UPDATES
	
	  // The 'scroll' parameter given to many of these indicated whether
	  // the new cursor position should be scrolled into view after
	  // modifying the selection.
	
	  // If shift is held or the extend flag is set, extends a range to
	  // include a given position (and optionally a second position).
	  // Otherwise, simply returns the range between the given positions.
	  // Used for cursor motion and such.
	  function extendRange(doc, range, head, other) {
	    if (doc.cm && doc.cm.display.shift || doc.extend) {
	      var anchor = range.anchor;
	      if (other) {
	        var posBefore = cmp(head, anchor) < 0;
	        if (posBefore != (cmp(other, anchor) < 0)) {
	          anchor = head;
	          head = other;
	        } else if (posBefore != (cmp(head, other) < 0)) {
	          head = other;
	        }
	      }
	      return new Range(anchor, head);
	    } else {
	      return new Range(other || head, head);
	    }
	  }
	
	  // Extend the primary selection range, discard the rest.
	  function extendSelection(doc, head, other, options) {
	    setSelection(doc, new Selection([extendRange(doc, doc.sel.primary(), head, other)], 0), options);
	  }
	
	  // Extend all selections (pos is an array of selections with length
	  // equal the number of selections)
	  function extendSelections(doc, heads, options) {
	    for (var out = [], i = 0; i < doc.sel.ranges.length; i++)
	      out[i] = extendRange(doc, doc.sel.ranges[i], heads[i], null);
	    var newSel = normalizeSelection(out, doc.sel.primIndex);
	    setSelection(doc, newSel, options);
	  }
	
	  // Updates a single range in the selection.
	  function replaceOneSelection(doc, i, range, options) {
	    var ranges = doc.sel.ranges.slice(0);
	    ranges[i] = range;
	    setSelection(doc, normalizeSelection(ranges, doc.sel.primIndex), options);
	  }
	
	  // Reset the selection to a single range.
	  function setSimpleSelection(doc, anchor, head, options) {
	    setSelection(doc, simpleSelection(anchor, head), options);
	  }
	
	  // Give beforeSelectionChange handlers a change to influence a
	  // selection update.
	  function filterSelectionChange(doc, sel, options) {
	    var obj = {
	      ranges: sel.ranges,
	      update: function(ranges) {
	        this.ranges = [];
	        for (var i = 0; i < ranges.length; i++)
	          this.ranges[i] = new Range(clipPos(doc, ranges[i].anchor),
	                                     clipPos(doc, ranges[i].head));
	      },
	      origin: options && options.origin
	    };
	    signal(doc, "beforeSelectionChange", doc, obj);
	    if (doc.cm) signal(doc.cm, "beforeSelectionChange", doc.cm, obj);
	    if (obj.ranges != sel.ranges) return normalizeSelection(obj.ranges, obj.ranges.length - 1);
	    else return sel;
	  }
	
	  function setSelectionReplaceHistory(doc, sel, options) {
	    var done = doc.history.done, last = lst(done);
	    if (last && last.ranges) {
	      done[done.length - 1] = sel;
	      setSelectionNoUndo(doc, sel, options);
	    } else {
	      setSelection(doc, sel, options);
	    }
	  }
	
	  // Set a new selection.
	  function setSelection(doc, sel, options) {
	    setSelectionNoUndo(doc, sel, options);
	    addSelectionToHistory(doc, doc.sel, doc.cm ? doc.cm.curOp.id : NaN, options);
	  }
	
	  function setSelectionNoUndo(doc, sel, options) {
	    if (hasHandler(doc, "beforeSelectionChange") || doc.cm && hasHandler(doc.cm, "beforeSelectionChange"))
	      sel = filterSelectionChange(doc, sel, options);
	
	    var bias = options && options.bias ||
	      (cmp(sel.primary().head, doc.sel.primary().head) < 0 ? -1 : 1);
	    setSelectionInner(doc, skipAtomicInSelection(doc, sel, bias, true));
	
	    if (!(options && options.scroll === false) && doc.cm)
	      ensureCursorVisible(doc.cm);
	  }
	
	  function setSelectionInner(doc, sel) {
	    if (sel.equals(doc.sel)) return;
	
	    doc.sel = sel;
	
	    if (doc.cm) {
	      doc.cm.curOp.updateInput = doc.cm.curOp.selectionChanged = true;
	      signalCursorActivity(doc.cm);
	    }
	    signalLater(doc, "cursorActivity", doc);
	  }
	
	  // Verify that the selection does not partially select any atomic
	  // marked ranges.
	  function reCheckSelection(doc) {
	    setSelectionInner(doc, skipAtomicInSelection(doc, doc.sel, null, false), sel_dontScroll);
	  }
	
	  // Return a selection that does not partially select any atomic
	  // ranges.
	  function skipAtomicInSelection(doc, sel, bias, mayClear) {
	    var out;
	    for (var i = 0; i < sel.ranges.length; i++) {
	      var range = sel.ranges[i];
	      var old = sel.ranges.length == doc.sel.ranges.length && doc.sel.ranges[i];
	      var newAnchor = skipAtomic(doc, range.anchor, old && old.anchor, bias, mayClear);
	      var newHead = skipAtomic(doc, range.head, old && old.head, bias, mayClear);
	      if (out || newAnchor != range.anchor || newHead != range.head) {
	        if (!out) out = sel.ranges.slice(0, i);
	        out[i] = new Range(newAnchor, newHead);
	      }
	    }
	    return out ? normalizeSelection(out, sel.primIndex) : sel;
	  }
	
	  function skipAtomicInner(doc, pos, oldPos, dir, mayClear) {
	    var line = getLine(doc, pos.line);
	    if (line.markedSpans) for (var i = 0; i < line.markedSpans.length; ++i) {
	      var sp = line.markedSpans[i], m = sp.marker;
	      if ((sp.from == null || (m.inclusiveLeft ? sp.from <= pos.ch : sp.from < pos.ch)) &&
	          (sp.to == null || (m.inclusiveRight ? sp.to >= pos.ch : sp.to > pos.ch))) {
	        if (mayClear) {
	          signal(m, "beforeCursorEnter");
	          if (m.explicitlyCleared) {
	            if (!line.markedSpans) break;
	            else {--i; continue;}
	          }
	        }
	        if (!m.atomic) continue;
	
	        if (oldPos) {
	          var near = m.find(dir < 0 ? 1 : -1), diff;
	          if (dir < 0 ? m.inclusiveRight : m.inclusiveLeft)
	            near = movePos(doc, near, -dir, near && near.line == pos.line ? line : null);
	          if (near && near.line == pos.line && (diff = cmp(near, oldPos)) && (dir < 0 ? diff < 0 : diff > 0))
	            return skipAtomicInner(doc, near, pos, dir, mayClear);
	        }
	
	        var far = m.find(dir < 0 ? -1 : 1);
	        if (dir < 0 ? m.inclusiveLeft : m.inclusiveRight)
	          far = movePos(doc, far, dir, far.line == pos.line ? line : null);
	        return far ? skipAtomicInner(doc, far, pos, dir, mayClear) : null;
	      }
	    }
	    return pos;
	  }
	
	  // Ensure a given position is not inside an atomic range.
	  function skipAtomic(doc, pos, oldPos, bias, mayClear) {
	    var dir = bias || 1;
	    var found = skipAtomicInner(doc, pos, oldPos, dir, mayClear) ||
	        (!mayClear && skipAtomicInner(doc, pos, oldPos, dir, true)) ||
	        skipAtomicInner(doc, pos, oldPos, -dir, mayClear) ||
	        (!mayClear && skipAtomicInner(doc, pos, oldPos, -dir, true));
	    if (!found) {
	      doc.cantEdit = true;
	      return Pos(doc.first, 0);
	    }
	    return found;
	  }
	
	  function movePos(doc, pos, dir, line) {
	    if (dir < 0 && pos.ch == 0) {
	      if (pos.line > doc.first) return clipPos(doc, Pos(pos.line - 1));
	      else return null;
	    } else if (dir > 0 && pos.ch == (line || getLine(doc, pos.line)).text.length) {
	      if (pos.line < doc.first + doc.size - 1) return Pos(pos.line + 1, 0);
	      else return null;
	    } else {
	      return new Pos(pos.line, pos.ch + dir);
	    }
	  }
	
	  // SELECTION DRAWING
	
	  function updateSelection(cm) {
	    cm.display.input.showSelection(cm.display.input.prepareSelection());
	  }
	
	  function prepareSelection(cm, primary) {
	    var doc = cm.doc, result = {};
	    var curFragment = result.cursors = document.createDocumentFragment();
	    var selFragment = result.selection = document.createDocumentFragment();
	
	    for (var i = 0; i < doc.sel.ranges.length; i++) {
	      if (primary === false && i == doc.sel.primIndex) continue;
	      var range = doc.sel.ranges[i];
	      if (range.from().line >= cm.display.viewTo || range.to().line < cm.display.viewFrom) continue;
	      var collapsed = range.empty();
	      if (collapsed || cm.options.showCursorWhenSelecting)
	        drawSelectionCursor(cm, range.head, curFragment);
	      if (!collapsed)
	        drawSelectionRange(cm, range, selFragment);
	    }
	    return result;
	  }
	
	  // Draws a cursor for the given range
	  function drawSelectionCursor(cm, head, output) {
	    var pos = cursorCoords(cm, head, "div", null, null, !cm.options.singleCursorHeightPerLine);
	
	    var cursor = output.appendChild(elt("div", "\u00a0", "CodeMirror-cursor"));
	    cursor.style.left = pos.left + "px";
	    cursor.style.top = pos.top + "px";
	    cursor.style.height = Math.max(0, pos.bottom - pos.top) * cm.options.cursorHeight + "px";
	
	    if (pos.other) {
	      // Secondary cursor, shown when on a 'jump' in bi-directional text
	      var otherCursor = output.appendChild(elt("div", "\u00a0", "CodeMirror-cursor CodeMirror-secondarycursor"));
	      otherCursor.style.display = "";
	      otherCursor.style.left = pos.other.left + "px";
	      otherCursor.style.top = pos.other.top + "px";
	      otherCursor.style.height = (pos.other.bottom - pos.other.top) * .85 + "px";
	    }
	  }
	
	  // Draws the given range as a highlighted selection
	  function drawSelectionRange(cm, range, output) {
	    var display = cm.display, doc = cm.doc;
	    var fragment = document.createDocumentFragment();
	    var padding = paddingH(cm.display), leftSide = padding.left;
	    var rightSide = Math.max(display.sizerWidth, displayWidth(cm) - display.sizer.offsetLeft) - padding.right;
	
	    function add(left, top, width, bottom) {
	      if (top < 0) top = 0;
	      top = Math.round(top);
	      bottom = Math.round(bottom);
	      fragment.appendChild(elt("div", null, "CodeMirror-selected", "position: absolute; left: " + left +
	                               "px; top: " + top + "px; width: " + (width == null ? rightSide - left : width) +
	                               "px; height: " + (bottom - top) + "px"));
	    }
	
	    function drawForLine(line, fromArg, toArg) {
	      var lineObj = getLine(doc, line);
	      var lineLen = lineObj.text.length;
	      var start, end;
	      function coords(ch, bias) {
	        return charCoords(cm, Pos(line, ch), "div", lineObj, bias);
	      }
	
	      iterateBidiSections(getOrder(lineObj), fromArg || 0, toArg == null ? lineLen : toArg, function(from, to, dir) {
	        var leftPos = coords(from, "left"), rightPos, left, right;
	        if (from == to) {
	          rightPos = leftPos;
	          left = right = leftPos.left;
	        } else {
	          rightPos = coords(to - 1, "right");
	          if (dir == "rtl") { var tmp = leftPos; leftPos = rightPos; rightPos = tmp; }
	          left = leftPos.left;
	          right = rightPos.right;
	        }
	        if (fromArg == null && from == 0) left = leftSide;
	        if (rightPos.top - leftPos.top > 3) { // Different lines, draw top part
	          add(left, leftPos.top, null, leftPos.bottom);
	          left = leftSide;
	          if (leftPos.bottom < rightPos.top) add(left, leftPos.bottom, null, rightPos.top);
	        }
	        if (toArg == null && to == lineLen) right = rightSide;
	        if (!start || leftPos.top < start.top || leftPos.top == start.top && leftPos.left < start.left)
	          start = leftPos;
	        if (!end || rightPos.bottom > end.bottom || rightPos.bottom == end.bottom && rightPos.right > end.right)
	          end = rightPos;
	        if (left < leftSide + 1) left = leftSide;
	        add(left, rightPos.top, right - left, rightPos.bottom);
	      });
	      return {start: start, end: end};
	    }
	
	    var sFrom = range.from(), sTo = range.to();
	    if (sFrom.line == sTo.line) {
	      drawForLine(sFrom.line, sFrom.ch, sTo.ch);
	    } else {
	      var fromLine = getLine(doc, sFrom.line), toLine = getLine(doc, sTo.line);
	      var singleVLine = visualLine(fromLine) == visualLine(toLine);
	      var leftEnd = drawForLine(sFrom.line, sFrom.ch, singleVLine ? fromLine.text.length + 1 : null).end;
	      var rightStart = drawForLine(sTo.line, singleVLine ? 0 : null, sTo.ch).start;
	      if (singleVLine) {
	        if (leftEnd.top < rightStart.top - 2) {
	          add(leftEnd.right, leftEnd.top, null, leftEnd.bottom);
	          add(leftSide, rightStart.top, rightStart.left, rightStart.bottom);
	        } else {
	          add(leftEnd.right, leftEnd.top, rightStart.left - leftEnd.right, leftEnd.bottom);
	        }
	      }
	      if (leftEnd.bottom < rightStart.top)
	        add(leftSide, leftEnd.bottom, null, rightStart.top);
	    }
	
	    output.appendChild(fragment);
	  }
	
	  // Cursor-blinking
	  function restartBlink(cm) {
	    if (!cm.state.focused) return;
	    var display = cm.display;
	    clearInterval(display.blinker);
	    var on = true;
	    display.cursorDiv.style.visibility = "";
	    if (cm.options.cursorBlinkRate > 0)
	      display.blinker = setInterval(function() {
	        display.cursorDiv.style.visibility = (on = !on) ? "" : "hidden";
	      }, cm.options.cursorBlinkRate);
	    else if (cm.options.cursorBlinkRate < 0)
	      display.cursorDiv.style.visibility = "hidden";
	  }
	
	  // HIGHLIGHT WORKER
	
	  function startWorker(cm, time) {
	    if (cm.doc.mode.startState && cm.doc.frontier < cm.display.viewTo)
	      cm.state.highlight.set(time, bind(highlightWorker, cm));
	  }
	
	  function highlightWorker(cm) {
	    var doc = cm.doc;
	    if (doc.frontier < doc.first) doc.frontier = doc.first;
	    if (doc.frontier >= cm.display.viewTo) return;
	    var end = +new Date + cm.options.workTime;
	    var state = copyState(doc.mode, getStateBefore(cm, doc.frontier));
	    var changedLines = [];
	
	    doc.iter(doc.frontier, Math.min(doc.first + doc.size, cm.display.viewTo + 500), function(line) {
	      if (doc.frontier >= cm.display.viewFrom) { // Visible
	        var oldStyles = line.styles, tooLong = line.text.length > cm.options.maxHighlightLength;
	        var highlighted = highlightLine(cm, line, tooLong ? copyState(doc.mode, state) : state, true);
	        line.styles = highlighted.styles;
	        var oldCls = line.styleClasses, newCls = highlighted.classes;
	        if (newCls) line.styleClasses = newCls;
	        else if (oldCls) line.styleClasses = null;
	        var ischange = !oldStyles || oldStyles.length != line.styles.length ||
	          oldCls != newCls && (!oldCls || !newCls || oldCls.bgClass != newCls.bgClass || oldCls.textClass != newCls.textClass);
	        for (var i = 0; !ischange && i < oldStyles.length; ++i) ischange = oldStyles[i] != line.styles[i];
	        if (ischange) changedLines.push(doc.frontier);
	        line.stateAfter = tooLong ? state : copyState(doc.mode, state);
	      } else {
	        if (line.text.length <= cm.options.maxHighlightLength)
	          processLine(cm, line.text, state);
	        line.stateAfter = doc.frontier % 5 == 0 ? copyState(doc.mode, state) : null;
	      }
	      ++doc.frontier;
	      if (+new Date > end) {
	        startWorker(cm, cm.options.workDelay);
	        return true;
	      }
	    });
	    if (changedLines.length) runInOp(cm, function() {
	      for (var i = 0; i < changedLines.length; i++)
	        regLineChange(cm, changedLines[i], "text");
	    });
	  }
	
	  // Finds the line to start with when starting a parse. Tries to
	  // find a line with a stateAfter, so that it can start with a
	  // valid state. If that fails, it returns the line with the
	  // smallest indentation, which tends to need the least context to
	  // parse correctly.
	  function findStartLine(cm, n, precise) {
	    var minindent, minline, doc = cm.doc;
	    var lim = precise ? -1 : n - (cm.doc.mode.innerMode ? 1000 : 100);
	    for (var search = n; search > lim; --search) {
	      if (search <= doc.first) return doc.first;
	      var line = getLine(doc, search - 1);
	      if (line.stateAfter && (!precise || search <= doc.frontier)) return search;
	      var indented = countColumn(line.text, null, cm.options.tabSize);
	      if (minline == null || minindent > indented) {
	        minline = search - 1;
	        minindent = indented;
	      }
	    }
	    return minline;
	  }
	
	  function getStateBefore(cm, n, precise) {
	    var doc = cm.doc, display = cm.display;
	    if (!doc.mode.startState) return true;
	    var pos = findStartLine(cm, n, precise), state = pos > doc.first && getLine(doc, pos-1).stateAfter;
	    if (!state) state = startState(doc.mode);
	    else state = copyState(doc.mode, state);
	    doc.iter(pos, n, function(line) {
	      processLine(cm, line.text, state);
	      var save = pos == n - 1 || pos % 5 == 0 || pos >= display.viewFrom && pos < display.viewTo;
	      line.stateAfter = save ? copyState(doc.mode, state) : null;
	      ++pos;
	    });
	    if (precise) doc.frontier = pos;
	    return state;
	  }
	
	  // POSITION MEASUREMENT
	
	  function paddingTop(display) {return display.lineSpace.offsetTop;}
	  function paddingVert(display) {return display.mover.offsetHeight - display.lineSpace.offsetHeight;}
	  function paddingH(display) {
	    if (display.cachedPaddingH) return display.cachedPaddingH;
	    var e = removeChildrenAndAdd(display.measure, elt("pre", "x"));
	    var style = window.getComputedStyle ? window.getComputedStyle(e) : e.currentStyle;
	    var data = {left: parseInt(style.paddingLeft), right: parseInt(style.paddingRight)};
	    if (!isNaN(data.left) && !isNaN(data.right)) display.cachedPaddingH = data;
	    return data;
	  }
	
	  function scrollGap(cm) { return scrollerGap - cm.display.nativeBarWidth; }
	  function displayWidth(cm) {
	    return cm.display.scroller.clientWidth - scrollGap(cm) - cm.display.barWidth;
	  }
	  function displayHeight(cm) {
	    return cm.display.scroller.clientHeight - scrollGap(cm) - cm.display.barHeight;
	  }
	
	  // Ensure the lineView.wrapping.heights array is populated. This is
	  // an array of bottom offsets for the lines that make up a drawn
	  // line. When lineWrapping is on, there might be more than one
	  // height.
	  function ensureLineHeights(cm, lineView, rect) {
	    var wrapping = cm.options.lineWrapping;
	    var curWidth = wrapping && displayWidth(cm);
	    if (!lineView.measure.heights || wrapping && lineView.measure.width != curWidth) {
	      var heights = lineView.measure.heights = [];
	      if (wrapping) {
	        lineView.measure.width = curWidth;
	        var rects = lineView.text.firstChild.getClientRects();
	        for (var i = 0; i < rects.length - 1; i++) {
	          var cur = rects[i], next = rects[i + 1];
	          if (Math.abs(cur.bottom - next.bottom) > 2)
	            heights.push((cur.bottom + next.top) / 2 - rect.top);
	        }
	      }
	      heights.push(rect.bottom - rect.top);
	    }
	  }
	
	  // Find a line map (mapping character offsets to text nodes) and a
	  // measurement cache for the given line number. (A line view might
	  // contain multiple lines when collapsed ranges are present.)
	  function mapFromLineView(lineView, line, lineN) {
	    if (lineView.line == line)
	      return {map: lineView.measure.map, cache: lineView.measure.cache};
	    for (var i = 0; i < lineView.rest.length; i++)
	      if (lineView.rest[i] == line)
	        return {map: lineView.measure.maps[i], cache: lineView.measure.caches[i]};
	    for (var i = 0; i < lineView.rest.length; i++)
	      if (lineNo(lineView.rest[i]) > lineN)
	        return {map: lineView.measure.maps[i], cache: lineView.measure.caches[i], before: true};
	  }
	
	  // Render a line into the hidden node display.externalMeasured. Used
	  // when measurement is needed for a line that's not in the viewport.
	  function updateExternalMeasurement(cm, line) {
	    line = visualLine(line);
	    var lineN = lineNo(line);
	    var view = cm.display.externalMeasured = new LineView(cm.doc, line, lineN);
	    view.lineN = lineN;
	    var built = view.built = buildLineContent(cm, view);
	    view.text = built.pre;
	    removeChildrenAndAdd(cm.display.lineMeasure, built.pre);
	    return view;
	  }
	
	  // Get a {top, bottom, left, right} box (in line-local coordinates)
	  // for a given character.
	  function measureChar(cm, line, ch, bias) {
	    return measureCharPrepared(cm, prepareMeasureForLine(cm, line), ch, bias);
	  }
	
	  // Find a line view that corresponds to the given line number.
	  function findViewForLine(cm, lineN) {
	    if (lineN >= cm.display.viewFrom && lineN < cm.display.viewTo)
	      return cm.display.view[findViewIndex(cm, lineN)];
	    var ext = cm.display.externalMeasured;
	    if (ext && lineN >= ext.lineN && lineN < ext.lineN + ext.size)
	      return ext;
	  }
	
	  // Measurement can be split in two steps, the set-up work that
	  // applies to the whole line, and the measurement of the actual
	  // character. Functions like coordsChar, that need to do a lot of
	  // measurements in a row, can thus ensure that the set-up work is
	  // only done once.
	  function prepareMeasureForLine(cm, line) {
	    var lineN = lineNo(line);
	    var view = findViewForLine(cm, lineN);
	    if (view && !view.text) {
	      view = null;
	    } else if (view && view.changes) {
	      updateLineForChanges(cm, view, lineN, getDimensions(cm));
	      cm.curOp.forceUpdate = true;
	    }
	    if (!view)
	      view = updateExternalMeasurement(cm, line);
	
	    var info = mapFromLineView(view, line, lineN);
	    return {
	      line: line, view: view, rect: null,
	      map: info.map, cache: info.cache, before: info.before,
	      hasHeights: false
	    };
	  }
	
	  // Given a prepared measurement object, measures the position of an
	  // actual character (or fetches it from the cache).
	  function measureCharPrepared(cm, prepared, ch, bias, varHeight) {
	    if (prepared.before) ch = -1;
	    var key = ch + (bias || ""), found;
	    if (prepared.cache.hasOwnProperty(key)) {
	      found = prepared.cache[key];
	    } else {
	      if (!prepared.rect)
	        prepared.rect = prepared.view.text.getBoundingClientRect();
	      if (!prepared.hasHeights) {
	        ensureLineHeights(cm, prepared.view, prepared.rect);
	        prepared.hasHeights = true;
	      }
	      found = measureCharInner(cm, prepared, ch, bias);
	      if (!found.bogus) prepared.cache[key] = found;
	    }
	    return {left: found.left, right: found.right,
	            top: varHeight ? found.rtop : found.top,
	            bottom: varHeight ? found.rbottom : found.bottom};
	  }
	
	  var nullRect = {left: 0, right: 0, top: 0, bottom: 0};
	
	  function nodeAndOffsetInLineMap(map, ch, bias) {
	    var node, start, end, collapse;
	    // First, search the line map for the text node corresponding to,
	    // or closest to, the target character.
	    for (var i = 0; i < map.length; i += 3) {
	      var mStart = map[i], mEnd = map[i + 1];
	      if (ch < mStart) {
	        start = 0; end = 1;
	        collapse = "left";
	      } else if (ch < mEnd) {
	        start = ch - mStart;
	        end = start + 1;
	      } else if (i == map.length - 3 || ch == mEnd && map[i + 3] > ch) {
	        end = mEnd - mStart;
	        start = end - 1;
	        if (ch >= mEnd) collapse = "right";
	      }
	      if (start != null) {
	        node = map[i + 2];
	        if (mStart == mEnd && bias == (node.insertLeft ? "left" : "right"))
	          collapse = bias;
	        if (bias == "left" && start == 0)
	          while (i && map[i - 2] == map[i - 3] && map[i - 1].insertLeft) {
	            node = map[(i -= 3) + 2];
	            collapse = "left";
	          }
	        if (bias == "right" && start == mEnd - mStart)
	          while (i < map.length - 3 && map[i + 3] == map[i + 4] && !map[i + 5].insertLeft) {
	            node = map[(i += 3) + 2];
	            collapse = "right";
	          }
	        break;
	      }
	    }
	    return {node: node, start: start, end: end, collapse: collapse, coverStart: mStart, coverEnd: mEnd};
	  }
	
	  function getUsefulRect(rects, bias) {
	    var rect = nullRect
	    if (bias == "left") for (var i = 0; i < rects.length; i++) {
	      if ((rect = rects[i]).left != rect.right) break
	    } else for (var i = rects.length - 1; i >= 0; i--) {
	      if ((rect = rects[i]).left != rect.right) break
	    }
	    return rect
	  }
	
	  function measureCharInner(cm, prepared, ch, bias) {
	    var place = nodeAndOffsetInLineMap(prepared.map, ch, bias);
	    var node = place.node, start = place.start, end = place.end, collapse = place.collapse;
	
	    var rect;
	    if (node.nodeType == 3) { // If it is a text node, use a range to retrieve the coordinates.
	      for (var i = 0; i < 4; i++) { // Retry a maximum of 4 times when nonsense rectangles are returned
	        while (start && isExtendingChar(prepared.line.text.charAt(place.coverStart + start))) --start;
	        while (place.coverStart + end < place.coverEnd && isExtendingChar(prepared.line.text.charAt(place.coverStart + end))) ++end;
	        if (ie && ie_version < 9 && start == 0 && end == place.coverEnd - place.coverStart)
	          rect = node.parentNode.getBoundingClientRect();
	        else
	          rect = getUsefulRect(range(node, start, end).getClientRects(), bias)
	        if (rect.left || rect.right || start == 0) break;
	        end = start;
	        start = start - 1;
	        collapse = "right";
	      }
	      if (ie && ie_version < 11) rect = maybeUpdateRectForZooming(cm.display.measure, rect);
	    } else { // If it is a widget, simply get the box for the whole widget.
	      if (start > 0) collapse = bias = "right";
	      var rects;
	      if (cm.options.lineWrapping && (rects = node.getClientRects()).length > 1)
	        rect = rects[bias == "right" ? rects.length - 1 : 0];
	      else
	        rect = node.getBoundingClientRect();
	    }
	    if (ie && ie_version < 9 && !start && (!rect || !rect.left && !rect.right)) {
	      var rSpan = node.parentNode.getClientRects()[0];
	      if (rSpan)
	        rect = {left: rSpan.left, right: rSpan.left + charWidth(cm.display), top: rSpan.top, bottom: rSpan.bottom};
	      else
	        rect = nullRect;
	    }
	
	    var rtop = rect.top - prepared.rect.top, rbot = rect.bottom - prepared.rect.top;
	    var mid = (rtop + rbot) / 2;
	    var heights = prepared.view.measure.heights;
	    for (var i = 0; i < heights.length - 1; i++)
	      if (mid < heights[i]) break;
	    var top = i ? heights[i - 1] : 0, bot = heights[i];
	    var result = {left: (collapse == "right" ? rect.right : rect.left) - prepared.rect.left,
	                  right: (collapse == "left" ? rect.left : rect.right) - prepared.rect.left,
	                  top: top, bottom: bot};
	    if (!rect.left && !rect.right) result.bogus = true;
	    if (!cm.options.singleCursorHeightPerLine) { result.rtop = rtop; result.rbottom = rbot; }
	
	    return result;
	  }
	
	  // Work around problem with bounding client rects on ranges being
	  // returned incorrectly when zoomed on IE10 and below.
	  function maybeUpdateRectForZooming(measure, rect) {
	    if (!window.screen || screen.logicalXDPI == null ||
	        screen.logicalXDPI == screen.deviceXDPI || !hasBadZoomedRects(measure))
	      return rect;
	    var scaleX = screen.logicalXDPI / screen.deviceXDPI;
	    var scaleY = screen.logicalYDPI / screen.deviceYDPI;
	    return {left: rect.left * scaleX, right: rect.right * scaleX,
	            top: rect.top * scaleY, bottom: rect.bottom * scaleY};
	  }
	
	  function clearLineMeasurementCacheFor(lineView) {
	    if (lineView.measure) {
	      lineView.measure.cache = {};
	      lineView.measure.heights = null;
	      if (lineView.rest) for (var i = 0; i < lineView.rest.length; i++)
	        lineView.measure.caches[i] = {};
	    }
	  }
	
	  function clearLineMeasurementCache(cm) {
	    cm.display.externalMeasure = null;
	    removeChildren(cm.display.lineMeasure);
	    for (var i = 0; i < cm.display.view.length; i++)
	      clearLineMeasurementCacheFor(cm.display.view[i]);
	  }
	
	  function clearCaches(cm) {
	    clearLineMeasurementCache(cm);
	    cm.display.cachedCharWidth = cm.display.cachedTextHeight = cm.display.cachedPaddingH = null;
	    if (!cm.options.lineWrapping) cm.display.maxLineChanged = true;
	    cm.display.lineNumChars = null;
	  }
	
	  function pageScrollX() { return window.pageXOffset || (document.documentElement || document.body).scrollLeft; }
	  function pageScrollY() { return window.pageYOffset || (document.documentElement || document.body).scrollTop; }
	
	  // Converts a {top, bottom, left, right} box from line-local
	  // coordinates into another coordinate system. Context may be one of
	  // "line", "div" (display.lineDiv), "local"/null (editor), "window",
	  // or "page".
	  function intoCoordSystem(cm, lineObj, rect, context) {
	    if (lineObj.widgets) for (var i = 0; i < lineObj.widgets.length; ++i) if (lineObj.widgets[i].above) {
	      var size = widgetHeight(lineObj.widgets[i]);
	      rect.top += size; rect.bottom += size;
	    }
	    if (context == "line") return rect;
	    if (!context) context = "local";
	    var yOff = heightAtLine(lineObj);
	    if (context == "local") yOff += paddingTop(cm.display);
	    else yOff -= cm.display.viewOffset;
	    if (context == "page" || context == "window") {
	      var lOff = cm.display.lineSpace.getBoundingClientRect();
	      yOff += lOff.top + (context == "window" ? 0 : pageScrollY());
	      var xOff = lOff.left + (context == "window" ? 0 : pageScrollX());
	      rect.left += xOff; rect.right += xOff;
	    }
	    rect.top += yOff; rect.bottom += yOff;
	    return rect;
	  }
	
	  // Coverts a box from "div" coords to another coordinate system.
	  // Context may be "window", "page", "div", or "local"/null.
	  function fromCoordSystem(cm, coords, context) {
	    if (context == "div") return coords;
	    var left = coords.left, top = coords.top;
	    // First move into "page" coordinate system
	    if (context == "page") {
	      left -= pageScrollX();
	      top -= pageScrollY();
	    } else if (context == "local" || !context) {
	      var localBox = cm.display.sizer.getBoundingClientRect();
	      left += localBox.left;
	      top += localBox.top;
	    }
	
	    var lineSpaceBox = cm.display.lineSpace.getBoundingClientRect();
	    return {left: left - lineSpaceBox.left, top: top - lineSpaceBox.top};
	  }
	
	  function charCoords(cm, pos, context, lineObj, bias) {
	    if (!lineObj) lineObj = getLine(cm.doc, pos.line);
	    return intoCoordSystem(cm, lineObj, measureChar(cm, lineObj, pos.ch, bias), context);
	  }
	
	  // Returns a box for a given cursor position, which may have an
	  // 'other' property containing the position of the secondary cursor
	  // on a bidi boundary.
	  function cursorCoords(cm, pos, context, lineObj, preparedMeasure, varHeight) {
	    lineObj = lineObj || getLine(cm.doc, pos.line);
	    if (!preparedMeasure) preparedMeasure = prepareMeasureForLine(cm, lineObj);
	    function get(ch, right) {
	      var m = measureCharPrepared(cm, preparedMeasure, ch, right ? "right" : "left", varHeight);
	      if (right) m.left = m.right; else m.right = m.left;
	      return intoCoordSystem(cm, lineObj, m, context);
	    }
	    function getBidi(ch, partPos) {
	      var part = order[partPos], right = part.level % 2;
	      if (ch == bidiLeft(part) && partPos && part.level < order[partPos - 1].level) {
	        part = order[--partPos];
	        ch = bidiRight(part) - (part.level % 2 ? 0 : 1);
	        right = true;
	      } else if (ch == bidiRight(part) && partPos < order.length - 1 && part.level < order[partPos + 1].level) {
	        part = order[++partPos];
	        ch = bidiLeft(part) - part.level % 2;
	        right = false;
	      }
	      if (right && ch == part.to && ch > part.from) return get(ch - 1);
	      return get(ch, right);
	    }
	    var order = getOrder(lineObj), ch = pos.ch;
	    if (!order) return get(ch);
	    var partPos = getBidiPartAt(order, ch);
	    var val = getBidi(ch, partPos);
	    if (bidiOther != null) val.other = getBidi(ch, bidiOther);
	    return val;
	  }
	
	  // Used to cheaply estimate the coordinates for a position. Used for
	  // intermediate scroll updates.
	  function estimateCoords(cm, pos) {
	    var left = 0, pos = clipPos(cm.doc, pos);
	    if (!cm.options.lineWrapping) left = charWidth(cm.display) * pos.ch;
	    var lineObj = getLine(cm.doc, pos.line);
	    var top = heightAtLine(lineObj) + paddingTop(cm.display);
	    return {left: left, right: left, top: top, bottom: top + lineObj.height};
	  }
	
	  // Positions returned by coordsChar contain some extra information.
	  // xRel is the relative x position of the input coordinates compared
	  // to the found position (so xRel > 0 means the coordinates are to
	  // the right of the character position, for example). When outside
	  // is true, that means the coordinates lie outside the line's
	  // vertical range.
	  function PosWithInfo(line, ch, outside, xRel) {
	    var pos = Pos(line, ch);
	    pos.xRel = xRel;
	    if (outside) pos.outside = true;
	    return pos;
	  }
	
	  // Compute the character position closest to the given coordinates.
	  // Input must be lineSpace-local ("div" coordinate system).
	  function coordsChar(cm, x, y) {
	    var doc = cm.doc;
	    y += cm.display.viewOffset;
	    if (y < 0) return PosWithInfo(doc.first, 0, true, -1);
	    var lineN = lineAtHeight(doc, y), last = doc.first + doc.size - 1;
	    if (lineN > last)
	      return PosWithInfo(doc.first + doc.size - 1, getLine(doc, last).text.length, true, 1);
	    if (x < 0) x = 0;
	
	    var lineObj = getLine(doc, lineN);
	    for (;;) {
	      var found = coordsCharInner(cm, lineObj, lineN, x, y);
	      var merged = collapsedSpanAtEnd(lineObj);
	      var mergedPos = merged && merged.find(0, true);
	      if (merged && (found.ch > mergedPos.from.ch || found.ch == mergedPos.from.ch && found.xRel > 0))
	        lineN = lineNo(lineObj = mergedPos.to.line);
	      else
	        return found;
	    }
	  }
	
	  function coordsCharInner(cm, lineObj, lineNo, x, y) {
	    var innerOff = y - heightAtLine(lineObj);
	    var wrongLine = false, adjust = 2 * cm.display.wrapper.clientWidth;
	    var preparedMeasure = prepareMeasureForLine(cm, lineObj);
	
	    function getX(ch) {
	      var sp = cursorCoords(cm, Pos(lineNo, ch), "line", lineObj, preparedMeasure);
	      wrongLine = true;
	      if (innerOff > sp.bottom) return sp.left - adjust;
	      else if (innerOff < sp.top) return sp.left + adjust;
	      else wrongLine = false;
	      return sp.left;
	    }
	
	    var bidi = getOrder(lineObj), dist = lineObj.text.length;
	    var from = lineLeft(lineObj), to = lineRight(lineObj);
	    var fromX = getX(from), fromOutside = wrongLine, toX = getX(to), toOutside = wrongLine;
	
	    if (x > toX) return PosWithInfo(lineNo, to, toOutside, 1);
	    // Do a binary search between these bounds.
	    for (;;) {
	      if (bidi ? to == from || to == moveVisually(lineObj, from, 1) : to - from <= 1) {
	        var ch = x < fromX || x - fromX <= toX - x ? from : to;
	        var outside = ch == from ? fromOutside : toOutside
	        var xDiff = x - (ch == from ? fromX : toX);
	        // This is a kludge to handle the case where the coordinates
	        // are after a line-wrapped line. We should replace it with a
	        // more general handling of cursor positions around line
	        // breaks. (Issue #4078)
	        if (toOutside && !bidi && !/\s/.test(lineObj.text.charAt(ch)) && xDiff > 0 &&
	            ch < lineObj.text.length && preparedMeasure.view.measure.heights.length > 1) {
	          var charSize = measureCharPrepared(cm, preparedMeasure, ch, "right");
	          if (innerOff <= charSize.bottom && innerOff >= charSize.top && Math.abs(x - charSize.right) < xDiff) {
	            outside = false
	            ch++
	            xDiff = x - charSize.right
	          }
	        }
	        while (isExtendingChar(lineObj.text.charAt(ch))) ++ch;
	        var pos = PosWithInfo(lineNo, ch, outside, xDiff < -1 ? -1 : xDiff > 1 ? 1 : 0);
	        return pos;
	      }
	      var step = Math.ceil(dist / 2), middle = from + step;
	      if (bidi) {
	        middle = from;
	        for (var i = 0; i < step; ++i) middle = moveVisually(lineObj, middle, 1);
	      }
	      var middleX = getX(middle);
	      if (middleX > x) {to = middle; toX = middleX; if (toOutside = wrongLine) toX += 1000; dist = step;}
	      else {from = middle; fromX = middleX; fromOutside = wrongLine; dist -= step;}
	    }
	  }
	
	  var measureText;
	  // Compute the default text height.
	  function textHeight(display) {
	    if (display.cachedTextHeight != null) return display.cachedTextHeight;
	    if (measureText == null) {
	      measureText = elt("pre");
	      // Measure a bunch of lines, for browsers that compute
	      // fractional heights.
	      for (var i = 0; i < 49; ++i) {
	        measureText.appendChild(document.createTextNode("x"));
	        m