from typing import Any, List, Mapping, Optional, Set, Union

from java.io import Closeable, InputStream, IOException, OutputStream
from java.lang import Class, Enum, Object
from java.nio.channels import SocketChannel

class SocketAddress(Object):
    def __init__(self) -> None: ...

class CookiePolicy:
    def shouldAccept(self, uri: URI, cookie: HttpCookie) -> bool: ...

class CookieStore:
    def add(self, uri: URI, cookie: HttpCookie) -> None: ...
    def get(self, uri: URI) -> List[HttpCookie]: ...
    def getCookies(self) -> List[HttpCookie]: ...
    def getURIs(self) -> List[URI]: ...
    def remove(self, uri: URI, cookie: HttpCookie) -> bool: ...
    def removeAll(self) -> bool: ...

class FileNameMap:
    def getContentTypeFor(
        self, fileName: Union[str, unicode]
    ) -> Union[str, unicode]: ...

class SocketImplFactory:
    def createSocketImpl(self) -> SocketImpl: ...

class SocketOption:
    def name(self) -> Union[str, unicode]: ...
    def type(self) -> Class: ...

class CookieHandler(Object):
    def __init__(self) -> None: ...
    def get(
        self,
        uri: URI,
        requestHeaders: Mapping[Union[str, unicode], List[Union[str, unicode]]],
    ) -> Mapping[Union[str, unicode], List[Union[str, unicode]]]: ...
    @staticmethod
    def getDefault() -> CookieHandler: ...
    def put(
        self,
        uri: URI,
        responseHeaders: Mapping[Union[str, unicode], List[Union[str, unicode]]],
    ) -> Mapping[Union[str, unicode], List[Union[str, unicode]]]: ...
    @staticmethod
    def setDefault(cHandler: CookieHandler) -> None: ...

class CookieManager(CookieHandler):
    def __init__(self, *args: Any) -> None: ...
    def get(
        self,
        uri: URI,
        requestHeaders: Mapping[Union[str, unicode], List[Union[str, unicode]]],
    ) -> Mapping[Union[str, unicode], List[Union[str, unicode]]]: ...
    def getCookieStore(self) -> CookieStore: ...
    def put(
        self,
        uri: URI,
        responseHeaders: Mapping[Union[str, unicode], List[Union[str, unicode]]],
    ) -> Mapping[Union[str, unicode], List[Union[str, unicode]]]: ...
    def setCookiePolicy(self, cookiePolicy: CookiePolicy) -> None: ...

class HttpCookie(Object):
    def __init__(
        self, name: Union[str, unicode], value: Union[str, unicode]
    ) -> None: ...

class InetAddress(Object):
    def getAddress(self) -> bytearray: ...
    @staticmethod
    def getAllByName(host: Union[str, unicode]) -> List[InetAddress]: ...
    @staticmethod
    def getByAddress(*args: Any) -> InetAddress: ...
    @staticmethod
    def getByName(host: Union[str, unicode]) -> InetAddress: ...
    def getCanonicalHostName(self) -> Union[str, unicode]: ...
    def getHostAddress(self) -> Union[str, unicode]: ...
    def getHostName(self) -> Union[str, unicode]: ...
    @staticmethod
    def getLocalHost() -> InetAddress: ...
    @staticmethod
    def getLoopbackAddress() -> InetAddress: ...
    def isAnyLocalAddress(self) -> bool: ...
    def isLinkLocalAddress(self) -> bool: ...
    def isLoopbackAddress(self) -> bool: ...
    def isMCGlobal(self) -> bool: ...
    def isMCLinkLocal(self) -> bool: ...
    def isMCNodeLocal(self) -> bool: ...
    def isMCOrgLocal(self) -> bool: ...
    def isMCSiteLocal(self) -> bool: ...
    def isMulticastAddress(self) -> bool: ...
    def isReachable(self, *args: Any) -> bool: ...
    def isSiteLocalAddress(self) -> bool: ...

class InetSocketAddress(SocketAddress):
    def __init__(self, *args: Any) -> None: ...
    @staticmethod
    def createUnresolved(host: Union[str, unicode], port: int) -> InetSocketAddress: ...
    def getAddress(self) -> InetAddress: ...
    def getHostname(self) -> Union[str, unicode]: ...
    def getHostString(self) -> Union[str, unicode]: ...
    def getPort(self) -> int: ...
    def isUnresolved(self) -> bool: ...

class Proxy(Object):
    class Type(Enum):
        DIRECT: Proxy.Type
        HTTP: Proxy.Type
        SOCKS: Proxy.Type
        @staticmethod
        def values() -> List[Proxy.Type]: ...

    NO_PROXY: Proxy
    def __init__(self, type_: Proxy.Type, sa: SocketAddress) -> None: ...
    def address(self) -> SocketAddress: ...
    def type(self) -> Proxy.Type: ...

class Socket(Object, Closeable):
    def __init__(self, *args: Any) -> None: ...
    def bind(self, bindpoint: SocketAddress) -> None: ...
    def close(self) -> None: ...
    def connect(
        self, endpoint: SocketAddress, timeout: Optional[int] = ...
    ) -> None: ...
    def getChannel(self) -> SocketChannel: ...
    def getInetAddress(self) -> InetAddress: ...
    def getInputStream(self) -> InputStream: ...
    def getKeepAlive(self) -> bool: ...
    def getLocalAddress(self) -> InetAddress: ...
    def getLocalPort(self) -> int: ...
    def getLocalSocketAddress(self) -> SocketAddress: ...
    def getOOBInline(self) -> bool: ...
    def getOption(self, name: SocketOption) -> Any: ...
    def getOutputStream(self) -> OutputStream: ...
    def getPort(self) -> int: ...
    def getReceiveBufferSize(self) -> int: ...
    def getRemoteSocketAddress(self) -> SocketAddress: ...
    def getReuseAddress(self) -> bool: ...
    def getSendBufferSize(self) -> int: ...
    def getSoLinger(self) -> int: ...
    def getSoTimeout(self) -> int: ...
    def getTcpNoDelay(self) -> bool: ...
    def getTrafficClass(self) -> int: ...
    def isBound(self) -> bool: ...
    def isClosed(self) -> bool: ...
    def isConnected(self) -> bool: ...
    def isInputShutdown(self) -> bool: ...
    def isOutputShutdown(self) -> bool: ...
    def sendUrgentData(self, data: int) -> None: ...
    def setKeepAlive(self, on: bool) -> None: ...
    def setOOBInline(self, on: bool) -> None: ...
    def setOption(self, name: SocketOption, value: Any) -> Socket: ...
    def setPerformancePreferences(
        self, connectionTime: int, latency: int, bandwidth: int
    ) -> None: ...
    def setReceiveBufferSize(self, size: int) -> None: ...
    def setReuseAddress(self, on: bool) -> None: ...
    def setSendBufferSize(self, size: int) -> None: ...
    @staticmethod
    def setSocketImplFactory(fac: SocketImplFactory) -> None: ...
    def setSoLinger(self, on: bool, linger: int) -> None: ...
    def setSoTimeout(self, timeout: int) -> None: ...
    def setTcpNoDelay(self, on: bool) -> None: ...
    def setTrafficClass(self, tc: int) -> None: ...
    def shutdownInput(self) -> None: ...
    def shutdownOutput(self) -> None: ...
    def supportedOptions(self) -> Set[SocketOption]: ...

class SocketImpl(Object):
    def __init__(self) -> None: ...

class URI(Object):
    def __init__(self, *args: Any) -> None: ...

class UnknownHostException(IOException):
    def __init__(self, message: Optional[str] = ...) -> None: ...
