from typing import Any, Iterator, List, Optional, Set, Union

from java.io import (
    BufferedReader,
    BufferedWriter,
    InputStream,
    IOException,
    OutputStream,
)
from java.lang import (
    AutoCloseable,
    CharSequence,
    Class,
    Enum,
    IllegalArgumentException,
    IllegalStateException,
    Object,
    RuntimeException,
    Throwable,
    UnsupportedOperationException,
)
from java.nio.channels import SeekableByteChannel
from java.nio.charset import Charset
from java.nio.file.attribute import (
    BasicFileAttributes,
    FileAttribute,
    FileAttributeView,
    FileStoreAttributeView,
    FileTime,
    PosixFilePermission,
    UserPrincipal,
)
from java.util import ConcurrentModificationException
from java.util.function import BiPredicate
from java.util.stream import Stream

class CopyOption: ...

class DirectoryStream(AutoCloseable):
    def close(self) -> None: ...

class OpenOption: ...

class Watchable:
    def register(self, *args: Any) -> WatchKey: ...

class FileStore(Object):
    def getAttribute(self, attribute: Union[str, unicode]) -> Object: ...
    def getBlockSize(self) -> long: ...
    def getFileStoreAttributeView(self, type: Class) -> FileStoreAttributeView: ...
    def getTotalSpace(self) -> long: ...
    def getUnallocatedSpace(self) -> long: ...
    def getUsableSpace(self) -> long: ...
    def isReadOnly(self) -> bool: ...
    def name(self) -> Union[str, unicode]: ...
    def supportsFileAttributeView(self, type: Class) -> bool: ...
    def type(self) -> Union[str, unicode]: ...

class ClosedDirectoryStreamException(IllegalStateException):
    def __init__(self) -> None: ...

class ClosedFileSystemException(IllegalStateException):
    def __init__(self) -> None: ...

class DirectoryIteratorException(ConcurrentModificationException):
    def __init__(self, cause: Throwable) -> None: ...

class FileSystemAlreadyExistsException(RuntimeException):
    def __init__(self, message: Optional[str] = ...) -> None: ...

class FileSystemException(IOException):
    def __init__(
        self,
        file: Union[str, unicode],
        other: Union[str, unicode, None] = ...,
        reason: Union[str, unicode, None] = ...,
    ) -> None: ...
    def getFile(self) -> Union[str, unicode]: ...
    def getOtherFile(self) -> Union[str, unicode, None]: ...
    def getReason(self) -> Union[str, unicode, None]: ...

class AccessDeniedException(FileSystemException):
    def __init__(
        self,
        file: Union[str, unicode],
        other: Union[str, unicode, None] = ...,
        reason: Union[str, unicode, None] = ...,
    ) -> None: ...

class AtomicMoveNotSupportedException(FileSystemException):
    def __init__(
        self,
        source: Union[str, unicode],
        target: Union[str, unicode],
        reason: Union[str, unicode],
    ) -> None: ...

class DirectoryNotEmptyException(FileSystemException):
    def __init__(self, dir_: Union[str, unicode]) -> None: ...

class FileAlreadyExistsException(FileSystemException):
    def __init__(
        self,
        file: Union[str, unicode],
        other: Union[str, unicode, None] = ...,
        reason: Union[str, unicode, None] = ...,
    ) -> None: ...

class FileSystemLoopException(FileSystemException):
    def __init__(self, file: Union[str, unicode]) -> None: ...

class FileSystemNotFoundException(RuntimeException):
    def __init__(self, message: Optional[str] = ...) -> None: ...

class NoSuchFileException(FileSystemException):
    def __init__(
        self,
        file: Union[str, unicode],
        other: Union[str, unicode, None] = ...,
        reason: Union[str, unicode, None] = ...,
    ) -> None: ...

class NotDirectoryException(FileSystemException):
    def __init__(self, file: Union[str, unicode]) -> None: ...

class NotLinkException(FileSystemException):
    def __init__(
        self,
        file: Union[str, unicode],
        other: Union[str, unicode, None] = ...,
        reason: Union[str, unicode, None] = ...,
    ) -> None: ...

class FileVisitOption(Enum):
    FOLLOW_LINKS: FileVisitOption
    @staticmethod
    def values() -> List[FileVisitOption]: ...

class Files(Object):
    @staticmethod
    def copy(*args: Any) -> Union[long, Path]: ...
    @staticmethod
    def createDirectories(dir: Path, *attrs: FileAttribute) -> Path: ...
    @staticmethod
    def createDirectory(dir: Path, *attrs: FileAttribute) -> Path: ...
    @staticmethod
    def createFile(path: Path, *attrs: FileAttribute) -> Path: ...
    @staticmethod
    def createLink(link: Path, existing: Path) -> Path: ...
    @staticmethod
    def createSymbolicLink(link: Path, target: Path, *attrs: FileAttribute) -> Path: ...
    @staticmethod
    def createTempDirectory(*args: Any) -> Path: ...
    @staticmethod
    def createTempFile(*args: Any) -> Path: ...
    @staticmethod
    def delete(path: Path) -> None: ...
    @staticmethod
    def deleteIfExists(path: Path) -> bool: ...
    @staticmethod
    def exists(path: Path, *options: LinkOption) -> bool: ...
    @staticmethod
    def find(
        start: Path, maxDepth: int, matcher: BiPredicate, *options: FileVisitOption
    ) -> Stream: ...
    @staticmethod
    def getAttribute(
        path: Path, attribute: Union[str, unicode], *options: LinkOption
    ) -> Object: ...
    @staticmethod
    def getFileAttributeView(
        path: Path, type: Class, *options: LinkOption
    ) -> FileAttributeView: ...
    @staticmethod
    def getFileStore(path: Path) -> FileStore: ...
    @staticmethod
    def getLastModifiedTime(path: Path, *options: LinkOption) -> FileTime: ...
    @staticmethod
    def getOwner(path: Path, *options: LinkOption) -> UserPrincipal: ...
    @staticmethod
    def getPosixFilePermissions(
        path: Path, *options: LinkOption
    ) -> Set[PosixFilePermission]: ...
    @staticmethod
    def isDirectory(path: Path, *options: LinkOption) -> bool: ...
    @staticmethod
    def isExecutable(path: Path) -> bool: ...
    @staticmethod
    def isHidden(path: Path) -> bool: ...
    @staticmethod
    def isReadable(path: Path) -> bool: ...
    @staticmethod
    def isRegularFile(path: Path, *options: LinkOption) -> bool: ...
    @staticmethod
    def isSameFile(path: Path, path2: Path) -> bool: ...
    @staticmethod
    def isSymbolicLink(path: Path) -> bool: ...
    @staticmethod
    def isWritable(path: Path) -> bool: ...
    @staticmethod
    def lines(path: Path, cs: Optional[Charset] = ...) -> Stream: ...
    @staticmethod
    def list(path: Path) -> Stream: ...
    @staticmethod
    def move(source: Path, target: Path, *options: CopyOption) -> Path: ...
    @staticmethod
    def newBufferedReader(
        path: Path, cs: Optional[Charset] = ...
    ) -> BufferedReader: ...
    @staticmethod
    def newBufferedWriter(path: Path, *args: Any) -> BufferedWriter: ...
    @staticmethod
    def newByteChannel(path: Path, *args: Any) -> SeekableByteChannel: ...
    @staticmethod
    def newDirectoryStream(dir: Path, *args: Any) -> DirectoryStream: ...
    @staticmethod
    def newInputStream(path: Path, *options: OpenOption) -> InputStream: ...
    @staticmethod
    def newOutputStream(path: Path, *options: OpenOption) -> OutputStream: ...
    @staticmethod
    def notExists(path: Path, *options: LinkOption) -> bool: ...
    @staticmethod
    def probeContentType(path: Path) -> Union[str, unicode]: ...
    @staticmethod
    def readAllBytes(path: Path) -> bytearray: ...
    @staticmethod
    def readAllLines(
        path: Path, cs: Optional[Charset] = ...
    ) -> List[Union[str, unicode]]: ...
    @staticmethod
    def readAttributes(path: Path, *args: Any) -> BasicFileAttributes: ...
    @staticmethod
    def readString(path: Path, cs: Optional[Charset] = ...) -> Union[str, unicode]: ...
    @staticmethod
    def readSymbolicLink(link: Path) -> Path: ...
    @staticmethod
    def setAttribute(
        path: Path, attribute: Union[str, unicode], value: Object, *options: LinkOption
    ) -> Path: ...
    @staticmethod
    def setLastModifiedTime(path: Path, time: FileTime) -> Path: ...
    @staticmethod
    def setOwner(path: Path, owner: UserPrincipal) -> Path: ...
    @staticmethod
    def setPosixFilePermissions(
        path: Path, perms: Set[PosixFilePermission]
    ) -> Path: ...
    @staticmethod
    def size(path: Path) -> long: ...
    @staticmethod
    def walk(path: Path, *args: Any) -> Stream: ...
    @staticmethod
    def walkFileTree(path: Path, *args: Any) -> Path: ...
    @staticmethod
    def write(path: Path, *args: Any) -> Path: ...
    @staticmethod
    def writeString(path: Path, csq: CharSequence, *args: Any) -> Path: ...

class InvalidPathException(IllegalArgumentException):
    def __init__(self, input: str, reason: str, index: Optional[int] = ...) -> None: ...
    def getIndex(self) -> Optional[int]: ...
    def getInput(self) -> Union[str, unicode]: ...
    def getReason(self) -> Union[str, unicode]: ...

class LinkOption(Enum, CopyOption, OpenOption):
    NOFOLLOW_LINKS: LinkOption
    @staticmethod
    def values() -> List[LinkOption]: ...

class Path(Watchable):
    def compareTo(self, other: Path) -> int: ...
    def endsWith(self, other: Union[str, unicode, Object, Path]) -> bool: ...
    def equals(self, other: Object) -> bool: ...
    def getFileName(self) -> Path: ...
    def getName(self, index: int) -> Path: ...
    def getNameCount(self) -> int: ...
    def getParent(self) -> Path: ...
    def getRoot(self) -> Path: ...
    def hashCode(self) -> int: ...
    def isAbsolute(self) -> bool: ...
    def iterator(self) -> Iterator[Path]: ...
    def normalize(self) -> Path: ...
    @staticmethod
    def of(*args: Any) -> Path: ...
    def register(self, *args: Any) -> WatchKey: ...
    def relativize(self, other: Path) -> Path: ...
    def resolve(self, other: Union[Path, str, unicode]) -> Path: ...
    def resolveSibling(self, other: Path) -> Path: ...
    def startsWith(self, other: Path) -> bool: ...
    def subpath(self, beginIndex: int, endIndex: int) -> Path: ...
    def toAbsolutePath(self) -> Path: ...
    def toFile(self) -> Any: ...
    def toRealPath(self, *args: LinkOption) -> Path: ...
    def toString(self) -> Union[str, unicode]: ...
    def toUri(self) -> Any: ...

class Paths(Object):
    @staticmethod
    def get(*args: Any) -> Path: ...

class ReadOnlyFileSystemException(UnsupportedOperationException):
    def __init__(self) -> None: ...

class StandardCopyOption(Enum, CopyOption, OpenOption):
    ATOMIC_MOVE: StandardCopyOption
    COPY_ATTRIBUTES: StandardCopyOption
    REPLACE_EXISTING: StandardCopyOption
    @staticmethod
    def values() -> List[StandardCopyOption]: ...

class WatchEvent:
    class Kind:
        def name(self) -> Union[str, unicode]: ...
        def type(self) -> Class: ...

    class Modifier:
        def name(self) -> Union[str, unicode]: ...

    def context(self) -> Any: ...
    def count(self) -> int: ...
    def kind(self) -> WatchEvent.Kind: ...

class WatchKey:
    def cancel(self) -> None: ...
    def isValid(self) -> bool: ...
    def pollEvents(self) -> List[WatchEvent]: ...
    def reset(self) -> bool: ...
    def watchable(self) -> Watchable: ...
