from typing import Any, Dict, List, Union

from java.lang import Comparable, Object
from java.time import Instant, LocalTime, ZoneId, ZoneOffset
from java.time.format import DateTimeFormatter, ResolverStyle, TextStyle
from java.time.temporal import (
    ChronoField,
    Temporal,
    TemporalAccessor,
    TemporalAdjuster,
    TemporalAmount,
    TemporalField,
    TemporalUnit,
    ValueRange,
)
from java.util import Comparator, Locale

class ChronoLocalDate(Temporal, TemporalAdjuster, Comparable):
    def adjustInto(self, temporal: Temporal) -> Temporal: ...
    def atTime(self, localTime: LocalTime) -> ChronoLocalDateTime: ...
    def compareTo(self, o: ChronoLocalDate) -> int: ...
    def equals(self, obj: Any) -> bool: ...
    def format(self, formatter: DateTimeFormatter) -> Union[str, unicode]: ...
    def getChronology(self) -> Chronology: ...
    def getEra(self) -> Era: ...
    def hashCode(self) -> int: ...
    def isAfter(self, other: ChronoLocalDate) -> bool: ...
    def isBefore(self, other: ChronoLocalDate) -> bool: ...
    def isEqual(self, other: ChronoLocalDate) -> bool: ...
    def isLeapYear(self) -> bool: ...
    def lengthOfMonth(self) -> int: ...
    def lengthOfYear(self) -> int: ...
    @staticmethod
    def timeLineOrder() -> Comparator: ...
    def toEpochDay(self) -> long: ...
    def toString(self) -> Union[str, unicode]: ...
    def until(self, endExclusive: Temporal, unit: TemporalUnit) -> long: ...

class ChronoLocalDateTime(Temporal, TemporalAdjuster, Comparable):
    def atZone(self, zone: ZoneId) -> ChronoZonedDateTime: ...
    def toLocalDate(self) -> Any: ...
    def toLocalTime(self) -> LocalTime: ...
    def toString(self) -> Union[str, unicode]: ...

class ChronoPeriod(TemporalAmount):
    @staticmethod
    def between(
        startDateInclusive: ChronoLocalDate, endDateExclusive: ChronoLocalDate
    ) -> ChronoPeriod: ...
    def equals(self, obj: Object) -> bool: ...
    def getChronology(self) -> Chronology: ...
    def hashCode(self) -> int: ...
    def isNegative(self) -> bool: ...
    def isZero(self) -> bool: ...
    def minus(self, amountToSubtract: TemporalAmount) -> ChronoPeriod: ...
    def multipliedBy(self, scalar: int) -> ChronoPeriod: ...
    def negated(self) -> ChronoPeriod: ...
    def normalized(self) -> ChronoPeriod: ...
    def plus(self, amountToAdd: TemporalAmount) -> ChronoPeriod: ...
    def toString(self) -> Union[str, unicode]: ...

class ChronoZonedDateTime(Temporal, Comparable):
    def format(self, formatter: DateTimeFormatter) -> Union[str, unicode]: ...
    def getChronology(self) -> Chronology: ...
    def getOffset(self) -> ZoneOffset: ...
    def getZone(self) -> ZoneId: ...
    def isAfter(self, other: ChronoZonedDateTime) -> bool: ...
    def isBefore(self, other: ChronoZonedDateTime) -> bool: ...
    def isEqual(self, other: ChronoZonedDateTime) -> bool: ...
    @staticmethod
    def timeLineOrder() -> Comparator: ...
    def toEpochSecond(self) -> long: ...
    def toInstant(self) -> Instant: ...
    def toLocalDate(self) -> Any: ...
    def toLocalDateTime(self) -> ChronoLocalDateTime: ...
    def toLocalTime(self) -> LocalTime: ...
    def withEarlierOffsetAtOverlap(self) -> ChronoZonedDateTime: ...
    def withLaterOffsetAtOverlap(self) -> ChronoZonedDateTime: ...
    def withZoneSameInstant(self, zone: ZoneId) -> ChronoZonedDateTime: ...
    def withZoneSameLocal(self, zone: ZoneId) -> ChronoZonedDateTime: ...

class Chronology(Comparable):
    def date(self, *args: Any) -> ChronoLocalDate: ...
    def dateEpochDay(self, epochDay: long) -> ChronoLocalDate: ...
    def dateYearDay(self, prolepticYear: int, dayOfYear: int) -> ChronoLocalDate: ...
    def equals(self, obj: Object) -> bool: ...
    def eraOf(self, eraValue: int) -> Era: ...
    def eras(self) -> List[Era]: ...
    def getCalendarType(self) -> Union[str, unicode]: ...
    def getId(self) -> Union[str, unicode]: ...
    def hashCode(self) -> int: ...
    def isLeapYear(self, prolepticYear: long) -> bool: ...
    def prolepticYear(self, era: Era, yearOfEra: int) -> int: ...
    def range(self, field: ChronoField) -> ValueRange: ...
    def resolveDate(
        self, fieldValues: Dict[TemporalField, long], resolverStyle: ResolverStyle
    ) -> ChronoLocalDate: ...
    def toString(self) -> Union[str, unicode]: ...

class Era(TemporalAccessor, TemporalAdjuster):
    def adjustInto(self, temporal: Temporal) -> Temporal: ...
    def getDisplayName(self, style: TextStyle, locale: Locale) -> long: ...
    def getValue(self) -> int: ...
