# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings
import functools

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import datetime

from pydantic import Field, StrictStr, conint

from typing import Optional

from circle.web3.developer_controlled_wallets.models.create_wallet_set_request import CreateWalletSetRequest
from circle.web3.developer_controlled_wallets.models.update_wallet_set_request import UpdateWalletSetRequest
from circle.web3.developer_controlled_wallets.models.wallet_set_response import WalletSetResponse
from circle.web3.developer_controlled_wallets.models.wallet_sets import WalletSets

from circle.web3.developer_controlled_wallets.api_client import ApiClient
from circle.web3.developer_controlled_wallets.api_response import ApiResponse
from circle.web3.developer_controlled_wallets.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


def auto_fill(func):
    functools.wraps(func)

    def wrapper(*args, **kwargs):
        api = args[0]
        for arg in args:
            api.api_client.fill_entity_secret_ciphertext(arg)
            api.api_client.fill_idempotency_key(arg)
        for name, arg in kwargs.items():
            api.api_client.fill_entity_secret_ciphertext(arg)
            api.api_client.fill_idempotency_key(arg)
        return func(*args, **kwargs)

    return wrapper


class WalletSetsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @auto_fill
    @validate_arguments
    def create_wallet_set(self, create_wallet_set_request : Annotated[CreateWalletSetRequest, Field(..., description="Schema for the request payload to create a new wallet set.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> WalletSetResponse:  # noqa: E501
        """Create a new wallet set  # noqa: E501

        Creates a new developer-controlled wallet set.  **Note:** A developer account can create up to 1,000 wallet sets, with each set supporting up to 10 million wallets. To ensure EVM wallets are created with the same address across chains, see [Unified Wallet Addressing on EVM Chains](/w3s/unified-wallet-addressing-evm).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_wallet_set(create_wallet_set_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param create_wallet_set_request: Schema for the request payload to create a new wallet set. (required)
        :type create_wallet_set_request: CreateWalletSetRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WalletSetResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_wallet_set_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_wallet_set_with_http_info(create_wallet_set_request, x_request_id, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def create_wallet_set_with_http_info(self, create_wallet_set_request : Annotated[CreateWalletSetRequest, Field(..., description="Schema for the request payload to create a new wallet set.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Create a new wallet set  # noqa: E501

        Creates a new developer-controlled wallet set.  **Note:** A developer account can create up to 1,000 wallet sets, with each set supporting up to 10 million wallets. To ensure EVM wallets are created with the same address across chains, see [Unified Wallet Addressing on EVM Chains](/w3s/unified-wallet-addressing-evm).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_wallet_set_with_http_info(create_wallet_set_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param create_wallet_set_request: Schema for the request payload to create a new wallet set. (required)
        :type create_wallet_set_request: CreateWalletSetRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WalletSetResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_wallet_set_request',
            'x_request_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_wallet_set" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_request_id']:
            _header_params['X-Request-Id'] = _params['x_request_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_wallet_set_request'] is not None:
            _body_params = _params['create_wallet_set_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "WalletSetResponse",
            '201': "WalletSetResponse",
            '400': "BadRequestResponse",
            '401': "NotAuthorizedResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/developer/walletSets', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def get_wallet_set(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> WalletSetResponse:  # noqa: E501
        """Get a wallet set  # noqa: E501

        Retrieve an existing wallet set.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_wallet_set(id, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WalletSetResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_wallet_set_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_wallet_set_with_http_info(id, x_request_id, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def get_wallet_set_with_http_info(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get a wallet set  # noqa: E501

        Retrieve an existing wallet set.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_wallet_set_with_http_info(id, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WalletSetResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'x_request_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_wallet_set" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_request_id']:
            _header_params['X-Request-Id'] = _params['x_request_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "WalletSetResponse",
            '401': "NotAuthorizedResponse",
            '404': "NotFoundResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/walletSets/{id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def get_wallet_sets(self, x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, var_from : Annotated[Optional[datetime], Field(description="Queries items created since the specified date-time (inclusive) in ISO 8601 format.")] = None, to : Annotated[Optional[datetime], Field(description="Queries items created before the specified date-time (inclusive) in ISO 8601 format.")] = None, page_before : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. ")] = None, page_after : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. ")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. ")] = None, order : Annotated[Optional[StrictStr], Field(description="Specifies the sort order of the collection by `CreateDate`.  Valid values: - `ASC` – Sort results in ascending order. - `DESC` – Sort results in descending order (default). ")] = None, **kwargs) -> WalletSets:  # noqa: E501
        """Get all wallet sets  # noqa: E501

        Retrieve an array of existing wallet sets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_wallet_sets(x_request_id, var_from, to, page_before, page_after, page_size, order, async_req=True)
        >>> result = thread.get()

        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param var_from: Queries items created since the specified date-time (inclusive) in ISO 8601 format.
        :type var_from: datetime
        :param to: Queries items created before the specified date-time (inclusive) in ISO 8601 format.
        :type to: datetime
        :param page_before: A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. 
        :type page_before: str
        :param page_after: A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. 
        :type page_after: str
        :param page_size: Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. 
        :type page_size: int
        :param order: Specifies the sort order of the collection by `CreateDate`.  Valid values: - `ASC` – Sort results in ascending order. - `DESC` – Sort results in descending order (default). 
        :type order: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WalletSets
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_wallet_sets_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_wallet_sets_with_http_info(x_request_id, var_from, to, page_before, page_after, page_size, order, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def get_wallet_sets_with_http_info(self, x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, var_from : Annotated[Optional[datetime], Field(description="Queries items created since the specified date-time (inclusive) in ISO 8601 format.")] = None, to : Annotated[Optional[datetime], Field(description="Queries items created before the specified date-time (inclusive) in ISO 8601 format.")] = None, page_before : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. ")] = None, page_after : Annotated[Optional[StrictStr], Field(description="A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. ")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. ")] = None, order : Annotated[Optional[StrictStr], Field(description="Specifies the sort order of the collection by `CreateDate`.  Valid values: - `ASC` – Sort results in ascending order. - `DESC` – Sort results in descending order (default). ")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get all wallet sets  # noqa: E501

        Retrieve an array of existing wallet sets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_wallet_sets_with_http_info(x_request_id, var_from, to, page_before, page_after, page_size, order, async_req=True)
        >>> result = thread.get()

        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param var_from: Queries items created since the specified date-time (inclusive) in ISO 8601 format.
        :type var_from: datetime
        :param to: Queries items created before the specified date-time (inclusive) in ISO 8601 format.
        :type to: datetime
        :param page_before: A collection ID value used for pagination.  It marks the exclusive end of a page. When provided, the collection resource will return the next n items before the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.   SHOULD NOT be used in conjunction with pageAfter. 
        :type page_before: str
        :param page_after: A collection ID value used for pagination.  It marks the exclusive begin of a page. When provided, the collection resource will return the next n items after the id, with n being specified by pageSize.  The items will be returned in the natural order of the collection.  The resource will return the first page if neither pageAfter nor pageBefore are specified.  SHOULD NOT be used in conjunction with pageBefore. 
        :type page_after: str
        :param page_size: Limits the number of items to be returned.  Some collections have a strict upper bound that will disregard this value. In case the specified value is higher than the allowed limit, the collection limit will be used.  If avoided, the collection will determine the page size itself. 
        :type page_size: int
        :param order: Specifies the sort order of the collection by `CreateDate`.  Valid values: - `ASC` – Sort results in ascending order. - `DESC` – Sort results in descending order (default). 
        :type order: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WalletSets, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'x_request_id',
            'var_from',
            'to',
            'page_before',
            'page_after',
            'page_size',
            'order'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_wallet_sets" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('var_from') is not None:  # noqa: E501
            if isinstance(_params['var_from'], datetime):
                _query_params.append(('from', _params['var_from'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('from', _params['var_from']))

        if _params.get('to') is not None:  # noqa: E501
            if isinstance(_params['to'], datetime):
                _query_params.append(('to', _params['to'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('to', _params['to']))

        if _params.get('page_before') is not None:  # noqa: E501
            _query_params.append(('pageBefore', _params['page_before']))

        if _params.get('page_after') is not None:  # noqa: E501
            _query_params.append(('pageAfter', _params['page_after']))

        if _params.get('page_size') is not None:  # noqa: E501
            _query_params.append(('pageSize', _params['page_size']))

        if _params.get('order') is not None:  # noqa: E501
            _query_params.append(('order', _params['order']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_request_id']:
            _header_params['X-Request-Id'] = _params['x_request_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "WalletSets",
            '401': "NotAuthorizedResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/walletSets', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @auto_fill
    @validate_arguments
    def update_wallet_set(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], update_wallet_set_request : Annotated[UpdateWalletSetRequest, Field(..., description="Schema for the request payload to update an existing wallet set.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> WalletSetResponse:  # noqa: E501
        """Update a wallet set  # noqa: E501

        Update the name of the wallet set  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_wallet_set(id, update_wallet_set_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param update_wallet_set_request: Schema for the request payload to update an existing wallet set. (required)
        :type update_wallet_set_request: UpdateWalletSetRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WalletSetResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the update_wallet_set_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.update_wallet_set_with_http_info(id, update_wallet_set_request, x_request_id, **kwargs)  # noqa: E501

    @auto_fill
    @validate_arguments
    def update_wallet_set_with_http_info(self, id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the resource.")], update_wallet_set_request : Annotated[UpdateWalletSetRequest, Field(..., description="Schema for the request payload to update an existing wallet set.")], x_request_id : Annotated[Optional[StrictStr], Field(description="Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Update a wallet set  # noqa: E501

        Update the name of the wallet set  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_wallet_set_with_http_info(id, update_wallet_set_request, x_request_id, async_req=True)
        >>> result = thread.get()

        :param id: The universally unique identifier of the resource. (required)
        :type id: str
        :param update_wallet_set_request: Schema for the request payload to update an existing wallet set. (required)
        :type update_wallet_set_request: UpdateWalletSetRequest
        :param x_request_id: Developer-provided parameter used to identify this request. Useful when communicating with Circle Support.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WalletSetResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'update_wallet_set_request',
            'x_request_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_wallet_set" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_request_id']:
            _header_params['X-Request-Id'] = _params['x_request_id']

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_wallet_set_request'] is not None:
            _body_params = _params['update_wallet_set_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "WalletSetResponse",
            '400': "BadRequestResponse",
            '401': "NotAuthorizedResponse",
            '404': "NotFoundResponse",
        }

        return self.api_client.call_api(
            '/v1/w3s/developer/walletSets/{id}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
