# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

# CUSTOMIZED: Added pydantic_encoder import (not in default OpenAPI Generator template)
# pydantic_encoder is needed to address serialization issues with datetime and other non-primitive fields,
# which are not handled by the default JSON encoder.
from pydantic.json import pydantic_encoder


from typing import List, Optional, Union
from pydantic import BaseModel, Field, StrictBytes, StrictStr, conlist
from circle.web3.developer_controlled_wallets.models.abi_parameters_inner import AbiParametersInner
from circle.web3.developer_controlled_wallets.models.contract_execution_blockchain import ContractExecutionBlockchain
from circle.web3.developer_controlled_wallets.models.fee_level import FeeLevel

class CreateContractExecutionTransactionForDeveloperRequest(BaseModel):
    """
    CreateContractExecutionTransactionForDeveloperRequest
    """
    idempotency_key: StrictStr = Field(..., alias="idempotencyKey", description="Universally unique identifier (UUID v4) idempotency key. This key is utilized to ensure exactly-once execution of mutating requests. To create a UUIDv4 go to [uuidgenerator.net](https://www.uuidgenerator.net). If the same key is reused, it will be treated as the same request and the original response will be returned.")
    abi_function_signature: Optional[StrictStr] = Field(None, alias="abiFunctionSignature", description="The contract ABI function signature or `callData` field is required for interacting with the smart contract. The ABI function signature cannot be used simultaneously with `callData`. e.g. burn(uint256)")
    abi_parameters: Optional[conlist(AbiParametersInner)] = Field(None, alias="abiParameters", description="The contract ABI function signature parameters for executing the contract interaction. Supported parameter types include string, integer, boolean, and array. These parameters should be used exclusively with the abiFunctionSignature and cannot be used with `callData`.")
    call_data: Optional[StrictStr] = Field(None, alias="callData", description="The raw transaction data, must be an even-length hexadecimal string with the `0x` prefix, to be executed. It is important to note that the usage of `callData` is mutually exclusive with the `abiFunctionSignature` and `abiParameters`. Therefore, `callData` cannot be utilized simultaneously with either `abiFunctionSignature` or `abiParameters`.")
    amount: Optional[StrictStr] = Field(None, description="The amount of native token that will be sent to the contract abi execution. Optional field for payable api only, if not provided, no native token will be sent.")
    contract_address: StrictStr = Field(..., alias="contractAddress", description="The blockchain address of the contract to be executed.")
    entity_secret_ciphertext: Union[StrictBytes, StrictStr] = Field(..., alias="entitySecretCiphertext", description="A base64 string expression of the entity secret ciphertext. The entity secret should be encrypted by the entity public key. Circle mandates that the entity secret ciphertext is unique for each API request. ")
    fee_level: Optional[FeeLevel] = Field(None, alias="feeLevel")
    gas_limit: Optional[StrictStr] = Field(None, alias="gasLimit", description="The maximum units of gas to use for the transaction. Required if `feeLevel` is not provided. Estimates for this limit can be obtained through the [`POST /transactions/transfer/estimateFee`](/api-reference/w3s/developer-controlled-wallets/create-transfer-estimate-fee) API. GasLimit override (only supported for EOA wallets): Using `gasLimit` together with `feeLevel`, the provided `gasLimit` is required to be greater or equal to `feeLevel` estimation and will override the estimation's gasLimit. ")
    gas_price: Optional[StrictStr] = Field(None, alias="gasPrice", description="For blockchains without EIP-1559 support, the maximum price of gas, in gwei, to use per each unit of gas (see `gasLimit`). Requires `gasLimit`. Cannot be used with `feeLevel`, `priorityFee`, or `maxFee`. Estimates for this fee can be obtained through the [`POST /transactions/transfer/estimateFee`](/api-reference/w3s/developer-controlled-wallets/create-transfer-estimate-fee) API. ")
    max_fee: Optional[StrictStr] = Field(None, alias="maxFee", description="For blockchains with EIP-1559 support, the maximum price per unit of gas (see `gasLimit`), in gwei. Requires `priorityFee`, and `gasLimit` to be present. Cannot be used with `feeLevel` or `gasPrice`. Estimates for this fee can be obtained through the [`POST /transactions/transfer/estimateFee`](/api-reference/w3s/developer-controlled-wallets/create-transfer-estimate-fee) API. ")
    priority_fee: Optional[StrictStr] = Field(None, alias="priorityFee", description="For blockchains with EIP-1559 support, the “tip”, in gwei, to add to the base fee as an incentive for validators. Please note that the `maxFee` and `gasLimit` parameters are required alongside the `priorityFee`. The `feeLevel` and `gasPrice` parameters cannot be used with the `priorityFee`.  Estimations for this fee can be obtained through the [`POST /transactions/transfer/estimateFee`](/api-reference/w3s/developer-controlled-wallets/create-transfer-estimate-fee) API. ")
    ref_id: Optional[StrictStr] = Field(None, alias="refId", description="Optional reference or description used to identify the transaction.")
    wallet_id: Optional[StrictStr] = Field(None, alias="walletId", description="Unique system generated identifier of the wallet. For contract deploys this wallet ID will be used as the source. ")
    blockchain: Optional[ContractExecutionBlockchain] = None
    wallet_address: Optional[StrictStr] = Field(None, alias="walletAddress", description="Blockchain generated unique identifier, associated with wallet (account), smart contract or other blockchain objects. ")
    __properties = ["idempotencyKey", "abiFunctionSignature", "abiParameters", "callData", "amount", "contractAddress", "entitySecretCiphertext", "feeLevel", "gasLimit", "gasPrice", "maxFee", "priorityFee", "refId", "walletId", "blockchain", "walletAddress"]

    def __init__(self, **kwargs):
        if "idempotencyKey" in self.__properties and not kwargs.get("idempotency_key"):
            kwargs["idempotency_key"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in self.__properties and not kwargs.get("entity_secret_ciphertext"):
            kwargs["entity_secret_ciphertext"] = "#REFILL_PLACEHOLDER"
        super().__init__(**kwargs)


    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Return JSON string of the model (handles datetime/UUID/Decimal/Enum, etc.)"""
        # CUSTOMIZED: Added default=pydantic_encoder to handle complex types (datetime, UUID, Enum, etc.)
        # This differs from the default OpenAPI Generator template which doesn't handle these types properly
        return json.dumps(self.to_dict(), default=pydantic_encoder)

    @classmethod
    def from_json(cls, json_str: str) -> CreateContractExecutionTransactionForDeveloperRequest:
        """Create an instance of CreateContractExecutionTransactionForDeveloperRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in abi_parameters (list)
        _items = []
        if self.abi_parameters:
            for _item in self.abi_parameters:
                if _item:
                    _items.append(_item.to_dict())
            _dict['abiParameters'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateContractExecutionTransactionForDeveloperRequest:
        """Create an instance of CreateContractExecutionTransactionForDeveloperRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateContractExecutionTransactionForDeveloperRequest.parse_obj(obj)

        # fill idempotency_key and ciphertext with placeholder for auto_fill
        if "idempotencyKey" in cls.__properties and not obj.get("idempotencyKey"):
            obj["idempotencyKey"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in cls.__properties and not obj.get("entitySecretCiphertext"):
            obj["entitySecretCiphertext"] = "#REFILL_PLACEHOLDER"

        _obj = CreateContractExecutionTransactionForDeveloperRequest.parse_obj({
            "idempotency_key": obj.get("idempotencyKey"),
                        "abi_function_signature": obj.get("abiFunctionSignature"),
                        "abi_parameters": [AbiParametersInner.from_dict(_item) for _item in obj.get("abiParameters")] if obj.get("abiParameters") is not None else None,
                        "call_data": obj.get("callData"),
                        "amount": obj.get("amount"),
                        "contract_address": obj.get("contractAddress"),
                        "entity_secret_ciphertext": obj.get("entitySecretCiphertext"),
                        "fee_level": obj.get("feeLevel"),
                        "gas_limit": obj.get("gasLimit"),
                        "gas_price": obj.get("gasPrice"),
                        "max_fee": obj.get("maxFee"),
                        "priority_fee": obj.get("priorityFee"),
                        "ref_id": obj.get("refId"),
                        "wallet_id": obj.get("walletId"),
                        "blockchain": obj.get("blockchain"),
                        "wallet_address": obj.get("walletAddress")
            
        })
        return _obj


