# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401

from typing import Optional
from pydantic import BaseModel, Field, StrictStr, ValidationError, validator
from circle.web3.developer_controlled_wallets.models.token_blockchain import TokenBlockchain
from circle.web3.developer_controlled_wallets.models.transfer_blockchain import TransferBlockchain
from typing import Union, Any, List, TYPE_CHECKING
from pydantic import StrictStr, Field

CREATETRANSFERTRANSACTIONFORDEVELOPERREQUESTBLOCKCHAIN_ANY_OF_SCHEMAS = ["TokenBlockchain", "TransferBlockchain"]

class CreateTransferTransactionForDeveloperRequestBlockchain(BaseModel):
    """
    CreateTransferTransactionForDeveloperRequestBlockchain
    """

    # data type: TransferBlockchain
    anyof_schema_1_validator: Optional[TransferBlockchain] = None
    # data type: TokenBlockchain
    anyof_schema_2_validator: Optional[TokenBlockchain] = None
    if TYPE_CHECKING:
        actual_instance: Union[TokenBlockchain, TransferBlockchain]
    else:
        actual_instance: Any
    any_of_schemas: List[str] = Field(CREATETRANSFERTRANSACTIONFORDEVELOPERREQUESTBLOCKCHAIN_ANY_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    def __init__(self, *args, **kwargs):
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = CreateTransferTransactionForDeveloperRequestBlockchain.construct()
        error_messages = []
        # validate data type: TransferBlockchain
        if not isinstance(v, TransferBlockchain):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TransferBlockchain`")
        else:
            return v

        # validate data type: TokenBlockchain
        if not isinstance(v, TokenBlockchain):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TokenBlockchain`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in CreateTransferTransactionForDeveloperRequestBlockchain with anyOf schemas: TokenBlockchain, TransferBlockchain. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> CreateTransferTransactionForDeveloperRequestBlockchain:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> CreateTransferTransactionForDeveloperRequestBlockchain:
        """Returns the object represented by the json string"""
        instance = CreateTransferTransactionForDeveloperRequestBlockchain.construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[TransferBlockchain] = None
        try:
            instance.actual_instance = TransferBlockchain.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[TokenBlockchain] = None
        try:
            instance.actual_instance = TokenBlockchain.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into CreateTransferTransactionForDeveloperRequestBlockchain with anyOf schemas: TokenBlockchain, TransferBlockchain. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        to_json = getattr(self.actual_instance, "to_json", None)
        if callable(to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self):
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        to_dict = getattr(self.actual_instance, "to_dict", None)
        if callable(to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance  # Return actual value instead of json.dumps()

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())


