# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

# CUSTOMIZED: Added pydantic_encoder import (not in default OpenAPI Generator template)
# pydantic_encoder is needed to address serialization issues with datetime and other non-primitive fields,
# which are not handled by the default JSON encoder.
from pydantic.json import pydantic_encoder


from typing import List, Optional, Union
from pydantic import BaseModel, Field, StrictBytes, StrictStr, conint, conlist
from circle.web3.developer_controlled_wallets.models.account_type import AccountType
from circle.web3.developer_controlled_wallets.models.blockchain import Blockchain
from circle.web3.developer_controlled_wallets.models.wallet_metadata import WalletMetadata

class CreateWalletRequest(BaseModel):
    """
    CreateWalletRequest
    """
    idempotency_key: StrictStr = Field(..., alias="idempotencyKey", description="Universally unique identifier (UUID v4) idempotency key. This key is utilized to ensure exactly-once execution of mutating requests. To create a UUIDv4 go to [uuidgenerator.net](https://www.uuidgenerator.net). If the same key is reused, it will be treated as the same request and the original response will be returned.")
    account_type: Optional[AccountType] = Field(None, alias="accountType")
    blockchains: conlist(Blockchain) = Field(..., description="Blockchain(s) the requested wallets will be created on.")
    count: Optional[conint(strict=True, le=200, ge=1)] = Field(None, description="Number of wallets that will be created per specified blockchain.")
    entity_secret_ciphertext: Union[StrictBytes, StrictStr] = Field(..., alias="entitySecretCiphertext", description="A base64 string expression of the entity secret ciphertext. The entity secret should be encrypted by the entity public key. Circle mandates that the entity secret ciphertext is unique for each API request. ")
    metadata: Optional[conlist(WalletMetadata)] = Field(None, description="List of metadata fields to associate with the corresponding wallet. If count is specified, the amount of items in the array should match the count field.")
    wallet_set_id: StrictStr = Field(..., alias="walletSetId", description="System-generated unique identifier of the resource.")
    __properties = ["idempotencyKey", "accountType", "blockchains", "count", "entitySecretCiphertext", "metadata", "walletSetId"]

    def __init__(self, **kwargs):
        if "idempotencyKey" in self.__properties and not kwargs.get("idempotency_key"):
            kwargs["idempotency_key"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in self.__properties and not kwargs.get("entity_secret_ciphertext"):
            kwargs["entity_secret_ciphertext"] = "#REFILL_PLACEHOLDER"
        super().__init__(**kwargs)


    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Return JSON string of the model (handles datetime/UUID/Decimal/Enum, etc.)"""
        # CUSTOMIZED: Added default=pydantic_encoder to handle complex types (datetime, UUID, Enum, etc.)
        # This differs from the default OpenAPI Generator template which doesn't handle these types properly
        return json.dumps(self.to_dict(), default=pydantic_encoder)

    @classmethod
    def from_json(cls, json_str: str) -> CreateWalletRequest:
        """Create an instance of CreateWalletRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in metadata (list)
        _items = []
        if self.metadata:
            for _item in self.metadata:
                if _item:
                    _items.append(_item.to_dict())
            _dict['metadata'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateWalletRequest:
        """Create an instance of CreateWalletRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateWalletRequest.parse_obj(obj)

        # fill idempotency_key and ciphertext with placeholder for auto_fill
        if "idempotencyKey" in cls.__properties and not obj.get("idempotencyKey"):
            obj["idempotencyKey"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in cls.__properties and not obj.get("entitySecretCiphertext"):
            obj["entitySecretCiphertext"] = "#REFILL_PLACEHOLDER"

        _obj = CreateWalletRequest.parse_obj({
            "idempotency_key": obj.get("idempotencyKey"),
                        "account_type": obj.get("accountType"),
                        "blockchains": obj.get("blockchains"),
                        "count": obj.get("count"),
                        "entity_secret_ciphertext": obj.get("entitySecretCiphertext"),
                        "metadata": [WalletMetadata.from_dict(_item) for _item in obj.get("metadata")] if obj.get("metadata") is not None else None,
                        "wallet_set_id": obj.get("walletSetId")
            
        })
        return _obj


