# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

# CUSTOMIZED: Added pydantic_encoder import (not in default OpenAPI Generator template)
# pydantic_encoder is needed to address serialization issues with datetime and other non-primitive fields,
# which are not handled by the default JSON encoder.
from pydantic.json import pydantic_encoder

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr, constr, validator
from circle.web3.developer_controlled_wallets.models.blockchain import Blockchain
from circle.web3.developer_controlled_wallets.models.custody_type import CustodyType
from circle.web3.developer_controlled_wallets.models.wallet_state import WalletState

class EOAWallet(BaseModel):
    """
    EOAWallet
    """
    id: StrictStr = Field(..., description="System-generated unique identifier of the resource.")
    address: StrictStr = Field(..., description="Blockchain generated unique identifier, associated with wallet (account), smart contract or other blockchain objects. ")
    blockchain: Blockchain = Field(...)
    create_date: datetime = Field(..., alias="createDate", description="Date and time the resource was created, in ISO-8601 UTC format.")
    update_date: datetime = Field(..., alias="updateDate", description="Date and time the resource was last updated, in ISO-8601 UTC format.")
    custody_type: CustodyType = Field(..., alias="custodyType")
    name: Optional[StrictStr] = Field(None, description="Name or description associated with the wallet or walletSet.")
    ref_id: Optional[StrictStr] = Field(None, alias="refId", description="Reference or description used to identify the object.")
    state: WalletState = Field(...)
    user_id: Optional[constr(strict=True, max_length=50, min_length=5)] = Field(None, alias="userId", description="Unique system generated identifier for the user.")
    wallet_set_id: StrictStr = Field(..., alias="walletSetId", description="System-generated unique identifier of the resource.")
    initial_public_key: Optional[StrictStr] = Field(None, alias="initialPublicKey", description="For NEAR blockchains only, the originally assigned public key of a wallet at the time of its creation.")
    account_type: StrictStr = Field(..., alias="accountType", description="An account can be a Smart Contract Account (SCA) or an Externally Owned Account (EOA). To learn more, see the [account types guide](https://developers.circle.com/w3s/docs/programmable-wallets-account-types).  If an account type is not specified during the creation of a wallet, it defaults to `EOA` (Externally Owned Account). Note that Solana and Aptos don't support Smart Contract Account (SCA). ")
    __properties = ["id", "address", "blockchain", "createDate", "updateDate", "custodyType", "name", "refId", "state", "userId", "walletSetId", "initialPublicKey", "accountType"]

    def __init__(self, **kwargs):
        if "idempotencyKey" in self.__properties and not kwargs.get("idempotency_key"):
            kwargs["idempotency_key"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in self.__properties and not kwargs.get("entity_secret_ciphertext"):
            kwargs["entity_secret_ciphertext"] = "#REFILL_PLACEHOLDER"
        super().__init__(**kwargs)


    @validator('account_type')
    def account_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('EOA'):
            raise ValueError("must be one of enum values ('EOA')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Return JSON string of the model (handles datetime/UUID/Decimal/Enum, etc.)"""
        # CUSTOMIZED: Added default=pydantic_encoder to handle complex types (datetime, UUID, Enum, etc.)
        # This differs from the default OpenAPI Generator template which doesn't handle these types properly
        return json.dumps(self.to_dict(), default=pydantic_encoder)

    @classmethod
    def from_json(cls, json_str: str) -> EOAWallet:
        """Create an instance of EOAWallet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EOAWallet:
        """Create an instance of EOAWallet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return EOAWallet.parse_obj(obj)

        # fill idempotency_key and ciphertext with placeholder for auto_fill
        if "idempotencyKey" in cls.__properties and not obj.get("idempotencyKey"):
            obj["idempotencyKey"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in cls.__properties and not obj.get("entitySecretCiphertext"):
            obj["entitySecretCiphertext"] = "#REFILL_PLACEHOLDER"

        _obj = EOAWallet.parse_obj({
            "id": obj.get("id"),
                        "address": obj.get("address"),
                        "blockchain": obj.get("blockchain"),
                        "create_date": obj.get("createDate"),
                        "update_date": obj.get("updateDate"),
                        "custody_type": obj.get("custodyType"),
                        "name": obj.get("name"),
                        "ref_id": obj.get("refId"),
                        "state": obj.get("state"),
                        "user_id": obj.get("userId"),
                        "wallet_set_id": obj.get("walletSetId"),
                        "initial_public_key": obj.get("initialPublicKey"),
                        "account_type": obj.get("accountType")
            
        })
        return _obj


