# coding: utf-8

"""
    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

# CUSTOMIZED: Added pydantic_encoder import (not in default OpenAPI Generator template)
# pydantic_encoder is needed to address serialization issues with datetime and other non-primitive fields,
# which are not handled by the default JSON encoder.
from pydantic.json import pydantic_encoder


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from circle.web3.developer_controlled_wallets.models.token_blockchain import TokenBlockchain

class EstimateTransferTransactionFeeRequest(BaseModel):
    """
    EstimateTransferTransactionFeeRequest
    """
    amounts: conlist(StrictStr, min_items=1) = Field(..., description="Transfer amounts in decimal number format, at least one element is required for transfer. For ERC721 token transfer, the amounts field is required to be [\"1\"] (array with \"1\" as the only element).")
    destination_address: StrictStr = Field(..., alias="destinationAddress", description="Blockchain generated unique identifier, associated with wallet (account), smart contract or other blockchain objects. ")
    nft_token_ids: Optional[conlist(StrictStr)] = Field(None, alias="nftTokenIds", description="List of NFT token IDs corresponding with the NFTs to transfer. Batch transfers are supported only for ERC-1155 tokens. The length of NFT token IDs must match the length of amounts.")
    source_address: Optional[StrictStr] = Field(None, alias="sourceAddress", description="Source address of the transaction. Required along with `blockchain` if `walletId` is not provided.  The `sourceAddress` and `walletId` fields are mutually exclusive. ")
    token_id: Optional[StrictStr] = Field(None, alias="tokenId", description="System generated identifier of the token. Excluded with `tokenAddress` and `tokenBlockchain`.")
    token_address: Optional[StrictStr] = Field(None, alias="tokenAddress", description="Blockchain address of the transferred token. Empty for native tokens. Excluded with `tokenId`.")
    blockchain: Optional[TokenBlockchain] = None
    wallet_id: Optional[StrictStr] = Field(None, alias="walletId", description="Unique system generated identifier of the wallet. For contract deploys this wallet ID will be used as the source. ")
    __properties = ["amounts", "destinationAddress", "nftTokenIds", "sourceAddress", "tokenId", "tokenAddress", "blockchain", "walletId"]

    def __init__(self, **kwargs):
        if "idempotencyKey" in self.__properties and not kwargs.get("idempotency_key"):
            kwargs["idempotency_key"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in self.__properties and not kwargs.get("entity_secret_ciphertext"):
            kwargs["entity_secret_ciphertext"] = "#REFILL_PLACEHOLDER"
        super().__init__(**kwargs)


    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Return JSON string of the model (handles datetime/UUID/Decimal/Enum, etc.)"""
        # CUSTOMIZED: Added default=pydantic_encoder to handle complex types (datetime, UUID, Enum, etc.)
        # This differs from the default OpenAPI Generator template which doesn't handle these types properly
        return json.dumps(self.to_dict(), default=pydantic_encoder)

    @classmethod
    def from_json(cls, json_str: str) -> EstimateTransferTransactionFeeRequest:
        """Create an instance of EstimateTransferTransactionFeeRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EstimateTransferTransactionFeeRequest:
        """Create an instance of EstimateTransferTransactionFeeRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return EstimateTransferTransactionFeeRequest.parse_obj(obj)

        # fill idempotency_key and ciphertext with placeholder for auto_fill
        if "idempotencyKey" in cls.__properties and not obj.get("idempotencyKey"):
            obj["idempotencyKey"] = "#REFILL_PLACEHOLDER"

        if "entitySecretCiphertext" in cls.__properties and not obj.get("entitySecretCiphertext"):
            obj["entitySecretCiphertext"] = "#REFILL_PLACEHOLDER"

        _obj = EstimateTransferTransactionFeeRequest.parse_obj({
            "amounts": obj.get("amounts"),
                        "destination_address": obj.get("destinationAddress"),
                        "nft_token_ids": obj.get("nftTokenIds"),
                        "source_address": obj.get("sourceAddress"),
                        "token_id": obj.get("tokenId"),
                        "token_address": obj.get("tokenAddress"),
                        "blockchain": obj.get("blockchain"),
                        "wallet_id": obj.get("walletId")
            
        })
        return _obj


